/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSQuoteUnquotePropertiesIntentionBase
extends JavaScriptIntention {
    protected abstract String getActionName();

    protected abstract boolean canPerformAction(Collection<? extends JSProperty> var1, Project var2);

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element2)) {
            return false;
        }
        Collection<JSProperty> properties2 = JSQuoteUnquotePropertiesIntentionBase.collectProperties(element2, editor);
        if (properties2.size() == 1) {
            this.setText(JavaScriptBundle.message((String)"js.quote.unquote.intention.singular", (Object[])new Object[]{this.getActionName()}));
        } else {
            this.setText(JavaScriptBundle.message((String)"js.quote.unquote.intention.plural", (Object[])new Object[]{this.getActionName()}));
        }
        return this.canPerformAction(properties2, project);
    }

    @NotNull
    protected static Collection<JSProperty> collectProperties(PsiElement element2, Editor editor) {
        if (!editor.getSelectionModel().hasSelection()) {
            JSObjectLiteralExpression literalExpression;
            JSObjectLiteralExpression literalExpression2;
            PsiElement elementParent = element2.getParent();
            JSProperty property = (JSProperty)ObjectUtils.tryCast((Object)elementParent, JSProperty.class);
            if (property != null) {
                List<JSProperty> list = Collections.singletonList(property);
                if (list == null) {
                    JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(2);
                }
                return list;
            }
            if ((element2 instanceof PsiWhiteSpace || element2 instanceof PsiComment) && (element2 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element2)) == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(3);
                }
                return list;
            }
            IElementType type2 = PsiUtilCore.getElementType((PsiElement)element2);
            if ((type2 == JSTokenTypes.LBRACE || type2 == JSTokenTypes.RBRACE || type2 == JSTokenTypes.COMMA) && (literalExpression2 = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)elementParent, JSObjectLiteralExpression.class)) != null) {
                return JSQuoteUnquotePropertiesIntentionBase.collectLiteralProperties(literalExpression2);
            }
            PsiElement sibling = element2.getPrevSibling();
            if (sibling != null && (literalExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)sibling.getLastChild(), JSObjectLiteralExpression.class)) != null) {
                return JSQuoteUnquotePropertiesIntentionBase.collectLiteralProperties(literalExpression);
            }
        } else {
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            TextRange selectionRange = new TextRange(start, end);
            ArrayList<JSProperty> allProps = new ArrayList<JSProperty>();
            SyntaxTraverser.psiTraverser((PsiElement)element2.getContainingFile()).onRange(JSQuoteUnquotePropertiesIntentionBase.fixRange(start, end, element2.getContainingFile())).filter(JSObjectLiteralExpression.class).forEach(e -> JSQuoteUnquotePropertiesIntentionBase.collectPassingProperties(e, selectionRange, allProps));
            ArrayList<JSProperty> arrayList = allProps;
            if (arrayList == null) {
                JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static TextRange fixRange(int start, int end, PsiFile file) {
        JSObjectLiteralExpression literal;
        PsiElement endElement;
        JSObjectLiteralExpression literal2;
        PsiElement startElement = file.findElementAt(start);
        if (startElement != null && (literal2 = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, JSObjectLiteralExpression.class)) != null) {
            int offset = literal2.getTextOffset();
            int n = start = offset == 0 ? 0 : offset - 1;
        }
        if ((endElement = file.findElementAt(start)) != null && (literal = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)endElement, JSObjectLiteralExpression.class)) != null) {
            end = literal.getTextRange().getEndOffset() + 1;
        }
        return new TextRange(start, end);
    }

    private static void collectPassingProperties(JSObjectLiteralExpression startLiteral, TextRange selectionRange, List<JSProperty> allProps) {
        for (JSProperty property : JSQuoteUnquotePropertiesIntentionBase.collectLiteralProperties(startLiteral)) {
            TextRange propertyRange = property.getTextRange();
            if (!selectionRange.intersects(propertyRange) || propertyRange.contains(selectionRange) && !propertyRange.equals((Object)selectionRange)) continue;
            allProps.add(property);
        }
    }

    @NotNull
    protected static Collection<JSProperty> collectLiteralProperties(JSObjectLiteralExpression element2) {
        List<JSProperty> allProps = Arrays.asList(element2.getProperties());
        List additionalProps = SyntaxTraverser.psiTraverser((PsiElement)element2).filter(JSObjectLiteralExpression.class).flatMap(l -> Arrays.asList(l.getProperties())).toList();
        List list = ContainerUtil.concat(allProps, (List)additionalProps);
        if (list == null) {
            JSQuoteUnquotePropertiesIntentionBase.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSQuoteUnquotePropertiesIntentionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSQuoteUnquotePropertiesIntentionBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLiteralProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

