/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.injections;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.injections.JSInjectionUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.annotations.NotNull;

public final class JSInjectionController {
    private static final Key<ParameterizedCachedValue<HtmlInjectionKind, PsiElement>> WILL_INJECT_HTML_CACHE_KEY = Key.create((String)"willInjectHtml");

    private JSInjectionController() {
    }

    public static boolean willInjectCss(@NotNull PsiElement languageInjectionHost) {
        JSLiteralExpression jsLiteralExpression;
        if (languageInjectionHost == null) {
            JSInjectionController.$$$reportNull$$$0(0);
        }
        JSLiteralExpression jSLiteralExpression = jsLiteralExpression = languageInjectionHost instanceof JSLiteralExpression ? (JSLiteralExpression)languageInjectionHost : null;
        if (jsLiteralExpression == null) {
            return false;
        }
        if (JavaScriptReferenceContributor.isAcceptableCssLiteralPlace((PsiElement)jsLiteralExpression, false)) {
            return JSInjectionController.checkValidAndNontrivialCss(JSInjectionUtil.getQuotedLiteralText(jsLiteralExpression));
        }
        return false;
    }

    private static boolean checkValidAndNontrivialCss(String text) {
        if (StringUtil.containsChar((String)text, (char)'?')) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'%')) {
            return false;
        }
        if (text.contains("##")) {
            return false;
        }
        if (text.length() == 1 && (text.charAt(0) == '#' || text.charAt(0) == '.')) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'#')) {
            int diesIndex = text.indexOf(35);
            while (diesIndex == 0 || diesIndex > 0 && (text.charAt(diesIndex - 1) == '\'' || text.charAt(diesIndex - 1) != '=')) {
                diesIndex = text.indexOf(35, diesIndex + 1);
            }
            if (diesIndex >= 0) {
                return false;
            }
        }
        if (text.contains("[]")) {
            return false;
        }
        int eqPos = text.indexOf(61);
        if (eqPos != -1) {
            int valuePos;
            for (valuePos = eqPos + 1; valuePos < text.length() && Character.isWhitespace(text.charAt(valuePos)); ++valuePos) {
            }
            if (valuePos < text.length() && Character.isDigit(text.charAt(valuePos))) {
                return false;
            }
        }
        return !JavaScriptReferenceContributor.isSimpleCss(text);
    }

    public static HtmlInjectionKind willInjectHtml(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(1);
        }
        return (HtmlInjectionKind)((Object)CachedValuesManager.getManager((Project)topElement.getProject()).getParameterizedCachedValue((UserDataHolder)topElement, WILL_INJECT_HTML_CACHE_KEY, param -> new CachedValueProvider.Result((Object)JSInjectionController.willInjectInJSInternal(param), new Object[]{param}), false, (Object)topElement));
    }

    private static HtmlInjectionKind willInjectInJSInternal(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(2);
        }
        if (DialectDetector.isActionScript((PsiElement)topElement)) {
            return HtmlInjectionKind.NONE;
        }
        if (!topElement.textContains('<')) {
            return HtmlInjectionKind.NONE;
        }
        String text = JSInjectionUtil.getConcatenationText(JSInjectionUtil.getConcatenationParts(topElement));
        int length = text.length();
        int tagStart = text.indexOf(60);
        if (tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text.charAt(tagStart + 1)) || tagStart < length - 2 && text.charAt(tagStart + 1) == '/' && Character.isLetter(text.charAt(tagStart + 2)) || tagStart < length - 3 && text.charAt(tagStart + 1) == '!' && text.charAt(tagStart + 2) == '-' && text.charAt(tagStart + 3) == '-' || tagStart < length - 2 && text.charAt(tagStart + 1) == '!' && (text.charAt(tagStart + 2) == 'd' || text.charAt(tagStart + 2) == 'D')) && text.indexOf(62, tagStart) > 0) {
            return JSInjectionController.isPossiblyReactJSX(text) ? HtmlInjectionKind.REACT_JSX : HtmlInjectionKind.HTML;
        }
        return HtmlInjectionKind.NONE;
    }

    private static boolean isPossiblyReactJSX(@NotNull String text) {
        if (text == null) {
            JSInjectionController.$$$reportNull$$$0(3);
        }
        int doubleQuoteCount = 0;
        int singleQuoteCount = 0;
        boolean hasEq = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                ++doubleQuoteCount;
                hasEq = false;
                continue;
            }
            if (c == '\'') {
                ++singleQuoteCount;
                hasEq = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == '=') {
                hasEq = true;
                continue;
            }
            if (doubleQuoteCount % 2 == 0 && singleQuoteCount % 2 == 0 && hasEq && c == '{') {
                return true;
            }
            hasEq = false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageInjectionHost";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/injections/JSInjectionController";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "willInjectCss";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "willInjectHtml";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "willInjectInJSInternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPossiblyReactJSX";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum HtmlInjectionKind {
        HTML,
        REACT_JSX,
        NONE;

    }
}

