/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSReferencePathUpdater;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExactFileReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements JSModuleBaseReference,
PsiFileReference,
BindablePsiReference {
    private static final ResolveCache.PolyVariantResolver<JSExactFileReference> RESOLVER = (el, incomplete) -> el.multiResolveInner();
    @NotNull
    private final Collection<String> myPaths;
    private final String @NotNull [] myExtensions;

    public JSExactFileReference(@NotNull PsiElement context2, @NotNull TextRange range, @NotNull Collection<String> filePaths, String @Nullable [] extensions) {
        if (context2 == null) {
            JSExactFileReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JSExactFileReference.$$$reportNull$$$0(1);
        }
        if (filePaths == null) {
            JSExactFileReference.$$$reportNull$$$0(2);
        }
        super(context2, range, false);
        this.myPaths = filePaths;
        this.myExtensions = extensions == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : extensions;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiPolyVariantReference)this, RESOLVER, false, incompleteCode);
        if (resolveResultArray == null) {
            JSExactFileReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    protected ResolveResult @NotNull [] multiResolveInner() {
        SmartList result2 = new SmartList();
        for (String path2 : this.myPaths) {
            PsiElement resolvedElement = this.findFileOrDirectory(this.getElement(), path2, this.myExtensions);
            if (resolvedElement == null) continue;
            result2.add((Object)resolvedElement);
            if (this.directoryOnly() || this.acceptAll()) continue;
            break;
        }
        ResolveResult[] resolveResultArray = this.getResolveResults((List<PsiElement>)result2);
        if (resolveResultArray == null) {
            JSExactFileReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    protected ResolveResult @NotNull [] getResolveResults(@NotNull List<PsiElement> results) {
        if (results == null) {
            JSExactFileReference.$$$reportNull$$$0(5);
        }
        SmartList resolveResult = new SmartList();
        for (PsiElement result2 : results) {
            Object[] elements;
            if (result2 instanceof PsiDirectory && !this.directoryOnly() && (elements = this.resolveForNpmPackages(result2)) != null) {
                ContainerUtil.addAll((Collection)resolveResult, (Object[])elements);
                continue;
            }
            resolveResult.add((Object)new JSResolveResult(result2));
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])resolveResult.toArray((Object[])ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            JSExactFileReference.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    protected boolean acceptAll() {
        return false;
    }

    protected boolean directoryOnly() {
        return false;
    }

    @Nullable
    protected PsiElement findFileOrDirectory(@NotNull PsiElement context2, @Nullable String path2, String @NotNull [] extensions) {
        VirtualFile file;
        if (context2 == null) {
            JSExactFileReference.$$$reportNull$$$0(7);
        }
        if (extensions == null) {
            JSExactFileReference.$$$reportNull$$$0(8);
        }
        if (path2 == null) {
            return null;
        }
        VirtualFile virtualFile = file = this.acceptFileWithoutExtension() ? this.findFileByPath(path2) : null;
        if (file == null) {
            for (String extension : extensions) {
                VirtualFile pathWithExtension = this.findFileByPath(path2 + extension);
                if (pathWithExtension == null || pathWithExtension.isDirectory()) continue;
                file = pathWithExtension;
                break;
            }
        }
        if (file != null) {
            PsiManager manager = context2.getManager();
            return file.isDirectory() ? manager.findDirectory(file) : manager.findFile(file);
        }
        return null;
    }

    protected boolean acceptFileWithoutExtension() {
        return true;
    }

    @Nullable
    protected VirtualFile findFileByPath(@NotNull String path2) {
        VirtualFile file;
        if (path2 == null) {
            JSExactFileReference.$$$reportNull$$$0(9);
        }
        LocalFileSystem fileSystem = (file = PsiUtilCore.getVirtualFile((PsiElement)this.myElement)) == null ? LocalFileSystem.getInstance() : file.getFileSystem();
        return fileSystem.findFileByPath(FileUtil.toSystemIndependentName((String)path2));
    }

    protected ResolveResult @Nullable [] resolveForNpmPackages(@NotNull PsiElement result2) {
        ResolveResult[] resolveResultArray;
        ResolveResult resolveResult;
        if (result2 == null) {
            JSExactFileReference.$$$reportNull$$$0(10);
        }
        if ((resolveResult = JSExactFileReference.resolveForNpmPackages(result2, this.createNodeProcessor())) == null) {
            resolveResultArray = null;
        } else {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = resolveResult;
        }
        return resolveResultArray;
    }

    @Nullable
    public static ResolveResult resolveForNpmPackages(@Nullable PsiElement result2, @NotNull JSDirectorySearchProcessor processor) {
        if (processor == null) {
            JSExactFileReference.$$$reportNull$$$0(11);
        }
        if (!(result2 instanceof PsiDirectory)) {
            return null;
        }
        VirtualFile file = ((PsiDirectory)result2).getVirtualFile();
        VirtualFile mainFile = JSExactFileReference.resolveForNpmPackages(file, processor);
        if (mainFile == null) {
            return null;
        }
        PsiFile mainPsiFile = result2.getManager().findFile(mainFile);
        return mainPsiFile == null ? null : new PsiElementResolveResult((PsiElement)mainPsiFile);
    }

    public static VirtualFile resolveForNpmPackages(@NotNull VirtualFile file, @NotNull JSDirectorySearchProcessor processor) {
        if (file == null) {
            JSExactFileReference.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSExactFileReference.$$$reportNull$$$0(13);
        }
        return processor.loadDirectory(file);
    }

    public PsiElement bindToElement(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JSExactFileReference.$$$reportNull$$$0(14);
        }
        return JSReferencePathUpdater.bindForModule(newElement, (PsiReference)this);
    }

    protected JSDirectorySearchProcessor createNodeProcessor() {
        return NodeModuleDirectorySearchProcessor.PROCESSOR;
    }

    public int getWeight() {
        return JSModuleBaseReference.ModuleTypes.PATH_MAPPING.weight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSExactFileReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveInner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFileOrDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveForNpmPackages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

