/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.Chunk;
import com.intellij.lang.javascript.documentation.EagerChunk;
import com.intellij.lang.javascript.documentation.JSDocumentationCommentGenerator;
import com.intellij.lang.javascript.documentation.JSDocumentationCommentGeneratorBase;
import com.intellij.lang.javascript.documentation.JSDocumentationCommentGeneratorKt;
import com.intellij.lang.javascript.documentation.JSDocumentationService;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.LazyChunk;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDocTextStringBuilder;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagsCompletionProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010\u000f\u001a\u00020\b2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u00110\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0004J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0004J$\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010+2\b\u0010&\u001a\u0004\u0018\u00010\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J\u0010\u0010,\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010-\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0014J\u0012\u0010.\u001a\u00020\u00152\b\u0010/\u001a\u0004\u0018\u000100H\u0004J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0014J\u001c\u00104\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0010\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u000200H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/lang/javascript/documentation/JSDocumentationCommentGeneratorBase;", "Lcom/intellij/lang/javascript/documentation/JSDocumentationCommentGenerator;", "<init>", "()V", "builder", "", "Lcom/intellij/lang/javascript/documentation/Chunk;", "insertDocumentationContentStub", "", "contextComment", "Lcom/intellij/psi/PsiComment;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "scheduleSlowPartsInsertion", "slowParts", "Lkotlin/Pair;", "Lcom/intellij/lang/javascript/documentation/LazyChunk;", "append", "chunk", "", "appendSlow", "supplier", "Lkotlin/Function0;", "shouldAddTypeAnnotation", "", "context", "Lcom/intellij/psi/PsiElement;", "doGenerateDoc", "expression", "Lcom/intellij/lang/javascript/psi/JSExpression;", "function", "Lcom/intellij/lang/javascript/psi/JSFunction;", "field", "Lcom/intellij/lang/javascript/psi/JSField;", "buildTypeDocString", "element", "name", "attributeListOwner", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeListOwner;", "isAvailable", "getDeclarationAccessModifier", "Lcom/intellij/lang/javascript/psi/ecmal4/JSAttributeList$AccessType;", "appendFunctionInfoDoc", "appendFunctionReturnTypeForInfoDoc", "getFunctionReturnTypeDoc", "returnType", "Lcom/intellij/lang/javascript/psi/JSType;", "appendParameterDoc", "parameter", "Lcom/intellij/lang/javascript/psi/JSParameter;", "appendAccessModifiersDoc", "getTypeTextForGenerateDoc", "rawType", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSDocumentationCommentGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSDocumentationCommentGenerator.kt\ncom/intellij/lang/javascript/documentation/JSDocumentationCommentGeneratorBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,271:1\n1563#2:272\n1634#2,3:273\n30#3,2:276\n*S KotlinDebug\n*F\n+ 1 JSDocumentationCommentGenerator.kt\ncom/intellij/lang/javascript/documentation/JSDocumentationCommentGeneratorBase\n*L\n100#1:272\n100#1:273,3\n104#1:276,2\n*E\n"})
public class JSDocumentationCommentGeneratorBase
implements JSDocumentationCommentGenerator {
    @NotNull
    private final List<Chunk> builder = new ArrayList();

    @Override
    public void insertDocumentationContentStub(@NotNull PsiComment contextComment, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)contextComment, (String)"contextComment");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement el = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)contextComment);
        if (el instanceof JSFunction) {
            this.doGenerateDoc((JSFunction)el);
        } else if (el instanceof JSProperty) {
            JSExpression propertyValue = ((JSProperty)el).getValue();
            if (propertyValue instanceof JSFunction) {
                this.doGenerateDoc((JSFunction)propertyValue);
            }
        } else if (el instanceof JSDefinitionExpression) {
            expression = ((JSDefinitionExpression)el).getParent();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                if (rOperand instanceof JSFunctionExpression) {
                    this.doGenerateDoc((JSFunction)rOperand);
                } else if (rOperand != null) {
                    this.doGenerateDoc(rOperand);
                }
            }
        } else if (el instanceof JSVariable) {
            expression = ((JSVariable)el).getInitializer();
            if (expression instanceof JSFunctionExpression) {
                this.doGenerateDoc((JSFunction)expression);
            } else if (el instanceof JSField) {
                this.doGenerateDoc((JSField)el);
            } else if (expression != null) {
                this.doGenerateDoc((JSExpression)expression);
            }
        }
        StringBuilder fastResult = new StringBuilder();
        List slowParts = new ArrayList();
        for (Chunk chunk : this.builder) {
            Comparable<StringBuilder> comparable;
            Chunk chunk2 = chunk;
            if (chunk2 instanceof EagerChunk) {
                comparable = fastResult.append(((EagerChunk)chunk).getContent());
                continue;
            }
            if (chunk2 instanceof LazyChunk) {
                comparable = slowParts.add(new Pair((Object)fastResult.length(), (Object)chunk));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        document.insertString(offset, (CharSequence)fastResult.toString());
        this.scheduleSlowPartsInsertion(slowParts, contextComment, offset);
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleSlowPartsInsertion(List<Pair<Integer, LazyChunk>> slowParts, PsiComment contextComment, int offset) {
        void $this$mapTo$iv$iv;
        if (slowParts.isEmpty()) {
            return;
        }
        Project project = contextComment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(contextComment.getContainingFile());
        if (document == null) {
            return;
        }
        Document document2 = document;
        Iterable $this$map$iv = slowParts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RangeMarker rangeMarker;
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)document2.createRangeMarker(TextRange.from((int)(offset + ((Number)it.getFirst()).intValue()), (int)0)), (String)"createRangeMarker(...)");
            collection.add(new Pair((Object)rangeMarker, ((LazyChunk)it.getSecond()).getSupplier()));
        }
        List rangeToSupplier = (List)destination$iv$iv;
        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<JSDocumentationService> serviceClass$iv = JSDocumentationService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((JSDocumentationService)object).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends Pair<? extends RangeMarker, ? extends Function0<String>>>)rangeToSupplier, project2, document2, null){
            int label;
            final /* synthetic */ List<Pair<RangeMarker, Function0<String>>> $rangeToSupplier;
            final /* synthetic */ Project $project;
            final /* synthetic */ Document $document;
            {
                this.$rangeToSupplier = $rangeToSupplier;
                this.$project = $project;
                this.$document = $document;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)JSDocumentationCommentGeneratorKt.access$getSLOW_OPERATIONS_TIMEOUT$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$rangeToSupplier, this.$project, this.$document, null){
                            int label;
                            final /* synthetic */ List<Pair<RangeMarker, Function0<String>>> $rangeToSupplier;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ Document $document;
                            {
                                this.$rangeToSupplier = $rangeToSupplier;
                                this.$project = $project;
                                this.$document = $document;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = CoroutinesKt.readAndEdtWriteAction(arg_0 -> scheduleSlowPartsInsertion.1.invokeSuspend$lambda$0(this.$rangeToSupplier, this.$project, this.$document, arg_0), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            private static final ReadResult invokeSuspend$lambda$0(List $rangeToSupplier, Project $project, Document $document, ReadAndWriteScope $this$readAndEdtWriteAction) {
                                List list;
                                try {
                                    void $this$mapTo$iv$iv;
                                    Iterable $this$map$iv = $rangeToSupplier;
                                    boolean $i$f$map = false;
                                    Iterable iterable = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void it;
                                        Pair pair = (Pair)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        boolean bl = false;
                                        collection.add(new Pair(it.getFirst(), ((Function0)it.getSecond()).invoke()));
                                    }
                                    list = (List)destination$iv$iv;
                                }
                                catch (PsiInvalidElementAccessException psiInvalidElementAccessException) {
                                    throw new CancellationException();
                                }
                                List rangeToText = list;
                                return $this$readAndEdtWriteAction.writeAction(() -> scheduleSlowPartsInsertion.1.invokeSuspend$lambda$0$1(rangeToText, $project, $document));
                            }

                            private static final Unit invokeSuspend$lambda$0$1(List $rangeToText, Project $project, Document $document) {
                                CommandProcessor.getInstance().runUndoTransparentAction(() -> scheduleSlowPartsInsertion.1.invokeSuspend$lambda$0$1$0($rangeToText, $project, $document));
                                return Unit.INSTANCE;
                            }

                            private static final void invokeSuspend$lambda$0$1$0(List $rangeToText, Project $project, Document $document) {
                                for (Pair pair : $rangeToText) {
                                    RangeMarker range = (RangeMarker)pair.component1();
                                    String text = (String)pair.component2();
                                    range.getDocument().insertString(range.getStartOffset(), (CharSequence)text);
                                    if (!StringsKt.contains$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null)) continue;
                                    CodeStyleManager.getInstance((Project)$project).adjustLineIndent($document, range.getStartOffset());
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    protected final void append(@NotNull String chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.builder.add(new EagerChunk(chunk));
    }

    protected final void appendSlow(@NotNull Function0<String> supplier) {
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        this.builder.add(new LazyChunk(supplier));
    }

    protected boolean shouldAddTypeAnnotation(@Nullable PsiElement context2) {
        return true;
    }

    private final void doGenerateDoc(JSExpression expression) {
        String string;
        if (!this.isAvailable((PsiElement)expression)) {
            return;
        }
        PsiElement parent = expression.getParent();
        PsiElement psiElement = parent;
        if (psiElement instanceof JSNamedElement) {
            string = ((JSNamedElement)parent).getName();
        } else if (psiElement instanceof JSAssignmentExpression) {
            JSExpression jSExpression;
            JSExpression operand = ((JSAssignmentExpression)parent).getLOperand();
            if (operand instanceof JSDefinitionExpression) {
                operand = ((JSDefinitionExpression)operand).getExpression();
            }
            JSReferenceExpression jSReferenceExpression = (jSExpression = operand) instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
            string = jSReferenceExpression != null ? jSReferenceExpression.getReferenceName() : null;
        } else {
            string = null;
        }
        String name = string;
        this.buildTypeDocString((PsiElement)expression, name, parent instanceof JSAttributeListOwner ? (JSAttributeListOwner)parent : null);
    }

    private final void doGenerateDoc(JSFunction function) {
        JSParameterList parameterList = function.getParameterList();
        if (parameterList != null) {
            JSParameter[] jSParameterArray = parameterList.getParameterVariables();
            Intrinsics.checkNotNullExpressionValue((Object)jSParameterArray, (String)"getParameterVariables(...)");
            for (JSParameter parameter : jSParameterArray) {
                Intrinsics.checkNotNull((Object)parameter);
                this.appendParameterDoc(parameter);
                this.append("\n");
            }
        }
        Project project = function.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return;
        }
        this.appendFunctionInfoDoc(function);
    }

    protected final void doGenerateDoc(@NotNull JSField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (!this.isAvailable((PsiElement)field)) {
            return;
        }
        this.buildTypeDocString((PsiElement)field, field.getName(), (JSAttributeListOwner)field);
    }

    private final void buildTypeDocString(PsiElement element2, String name, JSAttributeListOwner attributeListOwner) {
        if (this.shouldAddTypeAnnotation(element2)) {
            this.appendSlow((Function0<String>)((Function0)() -> JSDocumentationCommentGeneratorBase.buildTypeDocString$lambda$0(element2, this)));
        }
        this.appendAccessModifiersDoc(name, attributeListOwner);
    }

    private final boolean isAvailable(PsiElement context2) {
        if (DialectDetector.isActionScript((PsiElement)context2)) {
            return false;
        }
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DumbService dumbService = DumbService.Companion.getInstance(project);
        return !dumbService.isDumb();
    }

    @Nullable
    protected JSAttributeList.AccessType getDeclarationAccessModifier(@Nullable String name, @Nullable JSAttributeListOwner attributeListOwner) {
        CharSequence charSequence = name;
        return !(charSequence == null || charSequence.length() == 0) && (StringsKt.startsWith$default((String)name, (String)"_", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"_", (boolean)false, (int)2, null)) ? JSAttributeList.AccessType.PRIVATE : JSAttributeList.AccessType.PUBLIC;
    }

    protected void appendFunctionInfoDoc(@NotNull JSFunction function) {
        CharSequence charSequence;
        JSQualifiedNamedElement initializedElement;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.appendFunctionReturnTypeForInfoDoc(function);
        String name = function.getName();
        if (function instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)((JSExpression)function))) != null) {
            name = initializedElement.getName();
        }
        if (!((charSequence = (CharSequence)name) == null || charSequence.length() == 0) && Character.isUpperCase(name.charAt(0))) {
            this.append("* @constructor\n");
        }
        this.appendAccessModifiersDoc(name, (JSAttributeListOwner)function);
    }

    protected void appendFunctionReturnTypeForInfoDoc(@NotNull JSFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.appendSlow((Function0<String>)((Function0)() -> JSDocumentationCommentGeneratorBase.appendFunctionReturnTypeForInfoDoc$lambda$0(this, function)));
    }

    @NotNull
    protected final String getFunctionReturnTypeDoc(@Nullable JSType returnType2) {
        if (returnType2 != null && !(returnType2 instanceof JSVoidType)) {
            String typeString = this.getTypeTextForGenerateDoc(returnType2);
            return "* @" + JSDocTagsCompletionProvider.Companion.getReturnTag() + " {" + typeString + "}\n";
        }
        return "";
    }

    protected void appendParameterDoc(@NotNull JSParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        this.append("* @param " + parameter.getName());
    }

    private final void appendAccessModifiersDoc(String name, JSAttributeListOwner attributeListOwner) {
        JSAttributeList.AccessType accessType = this.getDeclarationAccessModifier(name, attributeListOwner);
        if (accessType == null) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[accessType.ordinal()]) {
            case 1: {
                this.append("* @private\n");
                break;
            }
            case 2: {
                this.append("* @protected\n");
            }
        }
    }

    @NotNull
    protected String getTypeTextForGenerateDoc(@NotNull JSType rawType) {
        Intrinsics.checkNotNullParameter((Object)rawType, (String)"rawType");
        JSDocTextStringBuilder builder2 = new JSDocTextStringBuilder();
        rawType.buildTypeText(JSType.TypeTextFormat.CODE, (JSTypeTextBuilder)builder2);
        String string = builder2.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResult(...)");
        return string;
    }

    private static final String buildTypeDocString$lambda$0(PsiElement $element, JSDocumentationCommentGeneratorBase this$0) {
        Object object;
        JSType type2;
        JSType jSType = type2 = $element instanceof JSField ? ((JSField)$element).getJSType() : JSResolveUtil.getElementJSType((PsiElement)$element);
        if (type2 != null && !(type2 instanceof JSVoidType) && !(type2 instanceof JSAnyType)) {
            String typeName = this$0.getTypeTextForGenerateDoc(type2);
            object = "* @type {" + typeName + "}\n";
        } else {
            object = "";
        }
        return object;
    }

    private static final String appendFunctionReturnTypeForInfoDoc$lambda$0(JSDocumentationCommentGeneratorBase this$0, JSFunction $function) {
        return this$0.getFunctionReturnTypeDoc(TypeFromUsageDetector.detectTypeFromUsage((PsiElement)((PsiElement)$function)));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSAttributeList.AccessType.values().length];
            try {
                nArray[JSAttributeList.AccessType.PRIVATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSAttributeList.AccessType.PROTECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

