/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.beans;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.jam.JamService;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.beans.JamPsiMemberMicronautBean;
import com.intellij.micronaut.jam.beans.JamPsiMethodMicronautBean;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnBeansModel;
import com.intellij.micronaut.jam.beans.MnFieldBean;
import com.intellij.micronaut.jam.beans.MnInjectionPoint;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.provider.beans.MnDumbModeLineMarkersKt;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.microservices.jvm.gutter.BeanInjectionTargetPresentationRenderer;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0016J&\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\r0\u00140\u000fH\u0014J&\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\r0\u00140\u000fH\u0014J&\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\r0\u00140\u000fH\u0014J&\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\r0\u00140\u000fH\u0014J.\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\r0\u00140\u000fH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010$\u001a\u00020 H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010&\u001a\u00020'H\u0002J*\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010!\u001a\u00020\r2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0#0*H\u0002J*\u0010+\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0002\u00a8\u0006,"}, d2={"Lcom/intellij/micronaut/provider/beans/MnBeansLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getName", "", "getIcon", "Ljavax/swing/Icon;", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "annotateClass", "uClass", "Lorg/jetbrains/uast/UClass;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "annotateMethodParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "annotateField", "uField", "Lorg/jetbrains/uast/UFieldEx;", "addAutowiredMarker", "psiInjectedElement", "Lcom/intellij/psi/PsiModifierListOwner;", "identifier", "findAutowiredDependencies", "", "psiElement", "findAutowiredCandidates", "psiMember", "Lcom/intellij/psi/PsiMember;", "beanDefinitionMarker", "navigationTargets", "Lcom/intellij/openapi/util/NotNullLazyValue;", "annotateInDumbMode", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnBeansLineMarkers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnBeansLineMarkers.kt\ncom/intellij/micronaut/provider/beans/MnBeansLineMarkers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,192:1\n1563#2:193\n1634#2,3:194\n1563#2:197\n1634#2,3:198\n1563#2:204\n1634#2,3:205\n13130#3,3:201\n*S KotlinDebug\n*F\n+ 1 MnBeansLineMarkers.kt\ncom/intellij/micronaut/provider/beans/MnBeansLineMarkers\n*L\n123#1:193\n123#1:194,3\n132#1:197\n132#1:198,3\n50#1:204\n50#1:205,3\n169#1:201,3\n*E\n"})
public final class MnBeansLineMarkers
extends MnLineMarkerProvider
implements DumbAware {
    @NotNull
    public String getName() {
        return MicronautBundle.message("micronaut.bean.markers", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.Bean;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Bean");
        return icon;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement first = psiElement;
        Project project = first.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean isDumb = DumbService.Companion.isDumb(project);
        if (!isDumb) {
            super.collectSlowLineMarkers(elements, result);
        } else {
            this.annotateInDumbMode(elements, result);
        }
    }

    @Override
    protected void annotateClass(@NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        JamPsiMemberMicronautBean<?> jamPsiMemberMicronautBean = MicronautBeanUtilsKt.getBeanMapping(psiClass);
        if (jamPsiMemberMicronautBean == null) {
            return;
        }
        JamPsiMemberMicronautBean<?> beanJamElement = jamPsiMemberMicronautBean;
        NotNullLazyValue notNullLazyValue = NotNullLazyValue.lazy(() -> MnBeansLineMarkers.annotateClass$lambda$0(beanJamElement));
        Intrinsics.checkNotNullExpressionValue((Object)notNullLazyValue, (String)"lazy(...)");
        result.add((RelatedItemLineMarkerInfo<PsiElement>)this.beanDefinitionMarker(identifier, (NotNullLazyValue<Collection<PsiElement>>)notNullLazyValue));
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        JamPsiMethodMicronautBean methodBean;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null || psiMethod.isConstructor() || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract") || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass) && !MicronautBeanUtilsKt.isMicronautTest(containingClass)) {
            return;
        }
        if (psiMethod.getReturnType() instanceof PsiClassType && (methodBean = MicronautBeanUtilsKt.getMethodBeanJam(psiMethod)) != null && MicronautBeanUtilsKt.isFactoryClass(containingClass)) {
            PsiElement psiElement = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)methodBean.getAnnotation())));
            if (psiElement == null) {
                return;
            }
            PsiElement psiAnnotationIdentifier = psiElement;
            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)containingClass)) == null) {
                return;
            }
            NotNullLazyValue notNullLazyValue = NotNullLazyValue.lazy(() -> MnBeansLineMarkers.annotateMethod$lambda$0(this, psiMethod));
            Intrinsics.checkNotNullExpressionValue((Object)notNullLazyValue, (String)"lazy(...)");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)this.beanDefinitionMarker(psiAnnotationIdentifier, (NotNullLazyValue<Collection<PsiElement>>)notNullLazyValue));
        }
    }

    @Override
    protected void annotateMethodParameter(@NotNull UParameter uParameter, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (MicronautBeanUtilsKt.isInjectionPoint(uParameter)) {
            PsiElement psiElement = uParameter.getJavaPsi();
            PsiParameter psiParameter = psiElement instanceof PsiParameter ? (PsiParameter)psiElement : null;
            if (psiParameter == null) {
                return;
            }
            PsiParameter psiParameter2 = psiParameter;
            PsiElement psiElement2 = UElementKt.getSourcePsiElement((UElement)uParameter.getUastAnchor());
            if (psiElement2 == null) {
                return;
            }
            PsiElement identifier = psiElement2;
            this.addAutowiredMarker((PsiModifierListOwner)psiParameter2, identifier, result);
        }
    }

    @Override
    protected void annotateField(@NotNull UFieldEx uField, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        MnFieldBean fieldBean;
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiField psiField = uField.getJavaPsi();
        if (MicronautBeanUtilsKt.isInjectionPoint(uField)) {
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uField.getUastAnchor());
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            this.addAutowiredMarker((PsiModifierListOwner)psiField, identifier, result);
        } else if (uField.getType() instanceof PsiClassType && MicronautBeanUtilsKt.getBeanMapping(psiField.getContainingClass()) != null && (fieldBean = MicronautBeanUtilsKt.getFieldBeanJam(psiField)) != null) {
            PsiClass psiClass = psiField.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)containingClass)) == null) {
                return;
            }
            PsiElement psiElement = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)fieldBean.getAnnotation())));
            if (psiElement == null) {
                return;
            }
            PsiElement psiAnnotationIdentifier = psiElement;
            NotNullLazyValue notNullLazyValue = NotNullLazyValue.lazy(() -> MnBeansLineMarkers.annotateField$lambda$0(this, psiField));
            Intrinsics.checkNotNullExpressionValue((Object)notNullLazyValue, (String)"lazy(...)");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)this.beanDefinitionMarker(psiAnnotationIdentifier, (NotNullLazyValue<Collection<PsiElement>>)notNullLazyValue));
        }
    }

    private final void addAutowiredMarker(PsiModifierListOwner psiInjectedElement, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowAutowiredDependencies;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowAutowiredDependencies");
        NavigationGutterIconBuilder navigationGutterIconBuilder = MnLineMarkerBuilder.create(icon).setPopupTitle(MicronautBundle.message("micronaut.inject.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.inject.popup.empty", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> MnBeansLineMarkers.addAutowiredMarker$lambda$0(this, psiInjectedElement))).setTooltipText(MicronautBundle.message("micronaut.show.dependencies.tooltip.text", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"setTooltipText(...)");
        NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
        result.add((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiElement> findAutowiredDependencies(PsiModifierListOwner psiElement) {
        void $this$mapTo$iv$iv;
        if (!psiElement.isValid()) {
            return CollectionsKt.emptyList();
        }
        Collection<MnBeanDefinition> collection = MnBeansModel.findAutowiredDependencies(new MnInjectionPoint(psiElement));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findAutowiredDependencies(...)");
        Collection<MnBeanDefinition> dependencies = collection;
        Iterable $this$map$iv = dependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MnBeanDefinition mnBeanDefinition = (MnBeanDefinition)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getDefiningPsiElement().getNavigationElement());
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiElement> findAutowiredCandidates(PsiMember psiMember) {
        void $this$mapTo$iv$iv;
        if (!psiMember.isValid()) {
            return CollectionsKt.emptyList();
        }
        JamService jamService = JamService.getJamService((Project)psiMember.getProject());
        JamPsiMemberMicronautBean beanDefinition = (JamPsiMemberMicronautBean)jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiMember);
        Collection<MnInjectionPoint> collection = MnBeansModel.findAutowiredCandidates(beanDefinition);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findAutowiredCandidates(...)");
        Collection<MnInjectionPoint> candidates = collection;
        Iterable $this$map$iv = candidates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MnInjectionPoint mnInjectionPoint = (MnInjectionPoint)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getOwner().getNavigationElement());
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final RelatedItemLineMarkerInfo<PsiElement> beanDefinitionMarker(PsiElement identifier, NotNullLazyValue<Collection<PsiElement>> navigationTargets) {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowAutowiredCandidates;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowAutowiredCandidates");
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = MnLineMarkerBuilder.create(icon).setPopupTitle(MicronautBundle.message("micronaut.candidates.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.candidates.popup.empty", new Object[0])).setTooltipText(MicronautBundle.message("micronaut.show.candidates.tooltip.text", new Object[0])).setTargets(navigationTargets).setTargetRenderer(BeanInjectionTargetPresentationRenderer::new).createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
        return relatedItemLineMarkerInfo;
    }

    private final void annotateInDumbMode(List<? extends PsiElement> elements, Collection<? super LineMarkerInfo<?>> result) {
        Module module = DumbAwareLineMarkerUtilsKt.findModuleForElementWhenDumb((PsiElement)((PsiElement)CollectionsKt.firstOrNull(elements)));
        if (!MicronautUtils.hasMicronautLibrary(module)) {
            return;
        }
        Iterator<? extends PsiElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            PsiElement psiElement;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            UElement uElement = DumbAwareLineMarkerUtilsKt.getUParentForIdentifierDumbAware((PsiElement)psiElement, (boolean)true);
            if (uElement instanceof UClass) {
                if (!DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)((UDeclaration)uElement), (Collection)MnDumbModeLineMarkersKt.getBEAN_ANNOTATION_SHORT_NAMES())) continue;
                Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowAutowiredCandidates;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowAutowiredCandidates");
                result.add((LineMarkerInfo<?>)MnDumbModeLineMarkersKt.createDumbModeLineMarker(psiElement, icon, DumbModeBlockedFunctionality.GotoInjectionPoints, MicronautBundle.INSTANCE.getLazyMessage("micronaut.show.candidates.tooltip.text", new Object[0])));
                continue;
            }
            if (uElement instanceof UParameter) {
                UClass uClass;
                UElement uParent = ((UParameter)uElement).getUastParent();
                if (!(uParent instanceof UMethod) || (uClass = UastUtils.getContainingUClass((UElement)uParent)) == null || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)((UDeclaration)uClass), (Collection)MnDumbModeLineMarkersKt.getBEAN_ANNOTATION_SHORT_NAMES()) || !((UMethod)uParent).isConstructor() || ((UMethod)uParent).getJavaPsi().hasModifier(JvmModifier.PRIVATE)) continue;
                UMethod[] $this$count$iv = uClass.getMethods();
                boolean $i$f$count = false;
                int count$iv = 0;
                int n = $this$count$iv.length;
                for (int i = 0; i < n; ++i) {
                    UMethod element$iv;
                    UMethod it = element$iv = $this$count$iv[i];
                    boolean bl = false;
                    if (!it.isConstructor()) continue;
                    ++count$iv;
                }
                int constructorCount = count$iv;
                if (constructorCount != true) continue;
                Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowAutowiredDependencies;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowAutowiredDependencies");
                result.add((LineMarkerInfo<?>)MnDumbModeLineMarkersKt.createDumbModeLineMarker(psiElement, icon, DumbModeBlockedFunctionality.GotoBeanDeclarations, MicronautBundle.INSTANCE.getLazyMessage("gutter.navigate.method.injections.tooltip", new Object[0])));
                continue;
            }
            if (!(uElement instanceof UField) || !DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)((UDeclaration)uElement), (Collection)MnDumbModeLineMarkersKt.getINJECT_ANNOTATION_SHORT_NAMES())) continue;
            Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowAutowiredDependencies;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ShowAutowiredDependencies");
            result.add((LineMarkerInfo<?>)MnDumbModeLineMarkersKt.createDumbModeLineMarker(psiElement, icon, DumbModeBlockedFunctionality.GotoBeanDeclarations, MicronautBundle.INSTANCE.getLazyMessage("micronaut.show.dependencies.tooltip.text", new Object[0])));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection annotateClass$lambda$0(JamPsiMemberMicronautBean $beanJamElement) {
        void $this$mapTo$iv$iv;
        Collection<MnInjectionPoint> collection = MnBeansModel.findAutowiredCandidates($beanJamElement);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findAutowiredCandidates(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MnInjectionPoint mnInjectionPoint = (MnInjectionPoint)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getOwner());
        }
        return (List)destination$iv$iv;
    }

    private static final Collection annotateMethod$lambda$0(MnBeansLineMarkers this$0, PsiMethod $psiMethod) {
        return this$0.findAutowiredCandidates((PsiMember)$psiMethod);
    }

    private static final Collection annotateField$lambda$0(MnBeansLineMarkers this$0, PsiField $psiField) {
        return this$0.findAutowiredCandidates((PsiMember)$psiField);
    }

    private static final Collection addAutowiredMarker$lambda$0(MnBeansLineMarkers this$0, PsiModifierListOwner $psiInjectedElement) {
        return this$0.findAutowiredDependencies($psiInjectedElement);
    }
}

