/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.el;

import com.intellij.codeInsight.hint.api.impls.MethodParameterInfoHandler;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.micronaut.el.lexer.MnLexerElementTypes;
import com.intellij.micronaut.el.psi.MnELExpression;
import com.intellij.micronaut.el.psi.MnELMethodCallExpression;
import com.intellij.micronaut.el.psi.MnELNewExpression;
import com.intellij.micronaut.el.psi.MnELParameterList;
import com.intellij.micronaut.el.psi.MnELQualifiedType;
import com.intellij.micronaut.el.psi.MnELVariable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MnELParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<MnELParameterList, PsiMethod, ELExpression> {
    private static final Set<Class<?>> ALLOWED_PARENT_CLASSES = Set.of(MnELMethodCallExpression.class, MnELNewExpression.class);

    @Nullable
    public MnELParameterList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(0);
        }
        PsiElement elementAt = MnELParameterInfoHandler.findElement((ParameterInfoContext)context);
        MnELExpression contextElement = (MnELExpression)PsiTreeUtil.getContextOfType((PsiElement)elementAt, (Class[])new Class[]{MnELNewExpression.class, MnELMethodCallExpression.class});
        if (contextElement instanceof MnELNewExpression) {
            MnELNewExpression newExpression = (MnELNewExpression)contextElement;
            MnELQualifiedType qualifiedType = newExpression.getELQualifiedType();
            if (qualifiedType == null) {
                return null;
            }
            PsiClass fqn = PsiTypesUtil.getPsiClass((PsiType)qualifiedType.getType());
            if (fqn != null) {
                context.setItemsToShow((Object[])fqn.getConstructors());
            }
            return newExpression.getELParameterList();
        }
        if (contextElement instanceof MnELMethodCallExpression) {
            MnELMethodCallExpression methodCallExpression = (MnELMethodCallExpression)contextElement;
            ELVariable method = methodCallExpression.getMethod();
            if (method instanceof MnELVariable) {
                context.setItemsToShow((Object[])MnELParameterInfoHandler.getMethodsByName((MnELVariable)method));
            }
            return methodCallExpression.getELParameterList();
        }
        return null;
    }

    public void showParameterInfo(@NotNull MnELParameterList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public MnELParameterList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return (MnELParameterList)PsiTreeUtil.getParentOfType((PsiElement)MnELParameterInfoHandler.findElement((ParameterInfoContext)context), MnELParameterList.class);
    }

    public void updateParameterInfo(@NotNull MnELParameterList list, @NotNull UpdateParameterInfoContext context) {
        if (list == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType());
        context.setCurrentParameter(currentParameterIndex);
    }

    public void updateUI(PsiMethod p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(6);
        }
        MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)p, (PsiSubstitutor)PsiSubstitutor.EMPTY, (ParameterInfoUIContext)context);
    }

    public ELExpression @NotNull [] getActualParameters(@NotNull MnELParameterList o) {
        if (o == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(7);
        }
        ELExpression[] eLExpressionArray = o.getParameters();
        if (eLExpressionArray == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return eLExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = MnLexerElementTypes.MN_EL_COMMA;
        if (iElementType == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = MnLexerElementTypes.MN_EL_RPARENTH;
        if (iElementType == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = ALLOWED_PARENT_CLASSES;
        if (set == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set set = Collections.emptySet();
        if (set == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Class<MnELParameterList> getArgumentListClass() {
        return MnELParameterList.class;
    }

    @Nullable
    private static PsiElement findElement(@NotNull ParameterInfoContext context) {
        PsiFile file;
        if (context == null) {
            MnELParameterInfoHandler.$$$reportNull$$$0(13);
        }
        return (file = context.getFile()) != null ? file.findElementAt(context.getOffset()) : null;
    }

    private static PsiMethod[] getMethodsByName(MnELVariable variable) {
        SmartList candidates = new SmartList();
        for (PsiReference reference : variable.getReferences()) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results;
                for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (!(element instanceof PsiMethod)) continue;
                    candidates.add((PsiMethod)element);
                }
                continue;
            }
            PsiElement resolve = reference.resolve();
            if (!(resolve instanceof PsiMethod)) continue;
            candidates.add((PsiMethod)resolve);
        }
        return candidates.toArray(PsiMethod.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/el/MnELParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/el/MnELParameterInfoHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

