/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.panels;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.ui.JBUI;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\"B&\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001dH\u0014R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "host", "", "Lcom/intellij/openapi/util/NlsSafe;", "request", "Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;", "sshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "<init>", "(Ljava/lang/String;Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;Lcom/intellij/ssh/ui/unified/SshUiData;)V", "getHost", "()Ljava/lang/String;", "getRequest", "()Lcom/intellij/ssh/ui/SshPasswordPrompt$Request;", "passwordField", "Lcom/intellij/ui/components/JBPasswordField;", "saveOptionComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog$SaveOption;", "kotlin.jvm.PlatformType", "password", "", "getPassword", "()[C", "saveOption", "getSaveOption", "()Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog$SaveOption;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "doOKAction", "", "doCancelAction", "createCenterPanel", "SaveOption", "intellij.gateway.core"})
public final class AuthenticationDialog
extends DialogWrapper {
    @NotNull
    private final String host;
    @Nullable
    private final SshPasswordPrompt.Request request;
    @NotNull
    private final SshUiData sshUiData;
    @NotNull
    private JBPasswordField passwordField;
    @NotNull
    private ComboBox<SaveOption> saveOptionComboBox;

    /*
     * WARNING - void declaration
     */
    public AuthenticationDialog(@NotNull String host2, @Nullable SshPasswordPrompt.Request request, @NotNull SshUiData sshUiData) {
        void $this$saveOptionComboBox_u24lambda_u240;
        ComboBox comboBox2;
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)sshUiData, (String)"sshUiData");
        super(null);
        this.host = host2;
        this.request = request;
        this.sshUiData = sshUiData;
        this.passwordField = new JBPasswordField();
        ComboBox comboBox3 = comboBox2 = new ComboBox((Object[])SaveOption.values());
        AuthenticationDialog authenticationDialog = this;
        boolean bl = false;
        $this$saveOptionComboBox_u24lambda_u240.setRenderer(AuthenticationDialog::saveOptionComboBox$lambda$0$0);
        $this$saveOptionComboBox_u24lambda_u240.setSelectedIndex(ArraysKt.indexOf((Object[])SaveOption.values(), (Object)((Object)SaveOption.SAVE_UNTIL_NEXT_RESTART)));
        authenticationDialog.saveOptionComboBox = comboBox2;
        this.setTitle(GatewayBundle.INSTANCE.message("ssh.authentication", new Object[0]));
        this.setOKButtonText(GatewayBundle.INSTANCE.message("ssh.authenticate", new Object[0]));
        this.init();
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final SshPasswordPrompt.Request getRequest() {
        return this.request;
    }

    @NotNull
    public final char[] getPassword() {
        char[] cArray = this.passwordField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        return cArray;
    }

    private final SaveOption getSaveOption() {
        Object object = this.saveOptionComboBox.getModel().getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.gateway.ssh.panels.AuthenticationDialog.SaveOption");
        return (SaveOption)((Object)object);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.passwordField;
    }

    protected void doOKAction() {
        boolean savePassUntilRestart = this.getSaveOption() == SaveOption.SAVE_UNTIL_NEXT_RESTART;
        boolean notEmptyPassword = !(this.getPassword().length == 0);
        GatewayUsagesCollector.INSTANCE.onAuthenticateDialogOkClick(savePassUntilRestart, !notEmptyPassword);
        if (notEmptyPassword) {
            if (this.request instanceof SshPasswordPrompt.Request.Password) {
                this.sshUiData.setStorePassword(!savePassUntilRestart);
                this.sshUiData.setPassword(new String(this.getPassword()));
                this.sshUiData.setAuthType(AuthType.PASSWORD);
            } else if (this.request instanceof SshPasswordPrompt.Request.Key) {
                this.sshUiData.setStorePassphrase(!savePassUntilRestart);
                this.sshUiData.setPassphrase(new String(this.getPassword()));
                this.sshUiData.setAuthType(AuthType.KEY_PAIR);
                this.sshUiData.setPrivateKeyFile(((Object)((SshPasswordPrompt.Request.Key)this.request).getKeyFilePath()).toString());
            }
            this.sshUiData.saveAuthDataToPasswordSafe();
        }
        super.doOKAction();
    }

    public void doCancelAction() {
        boolean notEmptyPassword = !(this.getPassword().length == 0);
        boolean savePassUntilRestart = this.getSaveOption() == SaveOption.SAVE_UNTIL_NEXT_RESTART;
        GatewayUsagesCollector.INSTANCE.onAuthenticateDialogCancelClick(savePassUntilRestart, !notEmptyPassword);
        super.doCancelAction();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBPanel jBPanel = BuilderKt.panel(arg_0 -> AuthenticationDialog.createCenterPanel$lambda$0(this, arg_0)).withMinimumWidth(JBUI.scale((int)564));
        DialogPanel $this$createCenterPanel_u24lambda_u241 = (DialogPanel)jBPanel;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JBPanel jBPanel2 = jBPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel2, (String)"apply(...)");
        return (JComponent)jBPanel2;
    }

    private static final Component saveOptionComboBox$lambda$0$0(JList jList, SaveOption value, int n, boolean bl, boolean bl2) {
        return new JLabel(value.getMessage());
    }

    private static final Unit createCenterPanel$lambda$0(AuthenticationDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AuthenticationDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AuthenticationDialog.createCenterPanel$lambda$0$1(this$0, arg_0), (int)1, null).layout(RowLayout.INDEPENDENT);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(AuthenticationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("<html>" + GatewayBundle.INSTANCE.message("ssh.authenticate.to", new Object[0]) + "<br/>" + StringUtil.escapeXmlEntities((String)this$0.host) + "<html/>").align((Align)AlignX.LEFT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(AuthenticationDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SshPasswordPrompt.Request request = this$0.request;
        String label = request instanceof SshPasswordPrompt.Request.Password ? GatewayBundle.INSTANCE.message("ssh.password", new Object[0]) : (request instanceof SshPasswordPrompt.Request.Key ? GatewayBundle.INSTANCE.message("ssh.key.passphrase", new Object[0]) + " " + ((SshPasswordPrompt.Request.Key)this$0.request).getKeyFilePath() : (request instanceof SshPasswordPrompt.Request.KeyboardInteractive ? GatewayBundle.INSTANCE.message("ssh.one.time.password", new Object[0]) : new String()));
        $this$row.cell((JComponent)this$0.passwordField).align((Align)AlignX.FILL.INSTANCE).resizableColumn().label(label, LabelPosition.TOP);
        $this$row.cell((JComponent)this$0.saveOptionComboBox);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0016\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/gateway/ssh/panels/AuthenticationDialog$SaveOption;", "", "message", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "SAVE_UNTIL_NEXT_RESTART", "SAVE_PERMANENTLY", "intellij.gateway.core"})
    public static final class SaveOption
    extends Enum<SaveOption> {
        @NotNull
        private final String message;
        public static final /* enum */ SaveOption SAVE_UNTIL_NEXT_RESTART = new SaveOption(GatewayBundle.INSTANCE.message("save.until.next.restart", new Object[0]));
        public static final /* enum */ SaveOption SAVE_PERMANENTLY = new SaveOption(GatewayBundle.INSTANCE.message("save.permanently", new Object[0]));
        private static final /* synthetic */ SaveOption[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SaveOption(String message) {
            this.message = message;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static SaveOption[] values() {
            return (SaveOption[])$VALUES.clone();
        }

        public static SaveOption valueOf(String value) {
            return Enum.valueOf(SaveOption.class, value);
        }

        @NotNull
        public static EnumEntries<SaveOption> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = saveOptionArray = new SaveOption[]{SaveOption.SAVE_UNTIL_NEXT_RESTART, SaveOption.SAVE_PERMANENTLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

