/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.actions.RevisionFileOpener;
import org.jetbrains.qodana.highlight.QodanaRevisionData;
import org.jetbrains.qodana.highlight.QodanaRevisionDataKt;
import org.jetbrains.qodana.notifications.QodanaNotifications;
import org.jetbrains.qodana.problem.SarifProblem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/actions/OpenProblemWithRevisionAction;", "Lcom/intellij/notification/NotificationAction;", "sarifProblem", "Lorg/jetbrains/qodana/problem/SarifProblem;", "<init>", "(Lorg/jetbrains/qodana/problem/SarifProblem;)V", "getRevisionFileOpener", "Lorg/jetbrains/qodana/actions/RevisionFileOpener;", "project", "Lcom/intellij/openapi/project/Project;", "canBePerformed", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nOpenProblemWithRevisionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenProblemWithRevisionAction.kt\norg/jetbrains/qodana/actions/OpenProblemWithRevisionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class OpenProblemWithRevisionAction
extends NotificationAction {
    @NotNull
    private final SarifProblem sarifProblem;

    public OpenProblemWithRevisionAction(@NotNull SarifProblem sarifProblem) {
        Intrinsics.checkNotNullParameter((Object)sarifProblem, (String)"sarifProblem");
        super(QodanaBundle.message("notification.action.open.file.with.qodana.report.revision", new Object[0]));
        this.sarifProblem = sarifProblem;
    }

    private final RevisionFileOpener getRevisionFileOpener(Project project) {
        Document revisionDocument;
        VirtualFile revisionVirtualFile;
        block7: {
            String string;
            Object[] objectArray;
            block9: {
                block8: {
                    PsiFile revisionPsiFile;
                    Document document;
                    VirtualFile file2;
                    VirtualFile virtualFile = file2 = this.sarifProblem.getVirtualFile(project);
                    if (virtualFile != null) {
                        VirtualFile it = virtualFile;
                        boolean bl = false;
                        v1 = (Document)ActionsKt.runReadAction(() -> OpenProblemWithRevisionAction.getRevisionFileOpener$lambda$0$0(file2));
                    } else {
                        v1 = document = null;
                    }
                    if (document == null) {
                        Object[] bl = new Object[]{this.sarifProblem.getRelativePathToFile()};
                        String string2 = QodanaBundle.message("notification.content.cant.find.file", bl);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        String fileNotFoundMessage = string2;
                        return new RevisionFileOpener.Error(fileNotFoundMessage);
                    }
                    QodanaRevisionData revisionData = (QodanaRevisionData)document.getUserData(QodanaRevisionDataKt.getQODANA_REVISION_DATA());
                    if (revisionData == null || !(revisionData instanceof QodanaRevisionData.VCSInfo)) {
                        String unexpectedFailMessage = "";
                        return new RevisionFileOpener.Error(unexpectedFailMessage);
                    }
                    PsiFile psiFile2 = revisionPsiFile = ((QodanaRevisionData.VCSInfo)revisionData).getRevisionPsiFiles().get(this.sarifProblem.getRevisionId());
                    revisionVirtualFile = psiFile2 != null ? psiFile2.getVirtualFile() : null;
                    PsiFile psiFile3 = revisionPsiFile;
                    Document document2 = psiFile3 != null && (psiFile3 = psiFile3.getViewProvider()) != null ? psiFile3.getDocument() : (revisionDocument = null);
                    if (revisionVirtualFile != null && revisionDocument != null) break block7;
                    objectArray = new Object[2];
                    objectArray[0] = file2.getName();
                    string = this.sarifProblem.getRevisionId();
                    if (string == null) break block8;
                    String string3 = string.substring(0, 7);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    string = string3;
                    if (string3 != null) break block9;
                }
                string = "";
            }
            objectArray[1] = string;
            String string4 = QodanaBundle.message("notification.content.cant.find.file.in.revision", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            String noFileInRevisionMessage = string4;
            return new RevisionFileOpener.Error(noFileInRevisionMessage);
        }
        TextRange textRange = this.sarifProblem.getTextRangeInDocument(revisionDocument);
        Integer problemOffset = textRange != null ? Integer.valueOf(textRange.getStartOffset()) : null;
        Function0 revisionFileOpener = () -> OpenProblemWithRevisionAction.getRevisionFileOpener$lambda$1(project, problemOffset, revisionVirtualFile);
        return new RevisionFileOpener.Success((Function0<Unit>)revisionFileOpener);
    }

    public final boolean canBePerformed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getRevisionFileOpener(project) instanceof RevisionFileOpener.Success;
    }

    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        notification.expire();
        RevisionFileOpener revisionFileOpener = this.getRevisionFileOpener(project2);
        if (revisionFileOpener instanceof RevisionFileOpener.Success) {
            ((RevisionFileOpener.Success)revisionFileOpener).getAction().invoke();
        } else if (revisionFileOpener instanceof RevisionFileOpener.Error) {
            QodanaNotifications.notification$default(QodanaNotifications.General.INSTANCE, QodanaBundle.message("notification.title.failed.to.open.file.with.report.revision", new Object[0]), ((RevisionFileOpener.Error)revisionFileOpener).getMessage(), NotificationType.WARNING, false, 8, null).notify(project2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final Document getRevisionFileOpener$lambda$0$0(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    private static final Unit getRevisionFileOpener$lambda$1(Project $project, Integer $problemOffset, VirtualFile $revisionVirtualFile) {
        ActionsKt.invokeLater$default(null, () -> OpenProblemWithRevisionAction.getRevisionFileOpener$lambda$1$0($project, $problemOffset, $revisionVirtualFile), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getRevisionFileOpener$lambda$1$0(Project $project, Integer $problemOffset, VirtualFile $revisionVirtualFile) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)$project);
        Editor editor = $problemOffset == null ? fileEditorManager.openFile($revisionVirtualFile, true) : fileEditorManager.openTextEditor(new OpenFileDescriptor($project, $revisionVirtualFile, $problemOffset.intValue()), true);
        return Unit.INSTANCE;
    }
}

