/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.meta.key;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.json.psi.JsonFile;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.configurations.meta.key.KtorConfigKeyNameBinder;
import com.intellij.ktor.configurations.meta.key.parser.KtorMetaConfigKeyService;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.utils.MetaConfigFileUtilsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ktor/configurations/meta/key/KtorMetaConfigKeyManager;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager;", "<init>", "()V", "getAllMetaConfigKeys", "", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "module", "Lcom/intellij/openapi/module/Module;", "getConfigKeyNameBinder", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "collectKeysFromLibraries", "getConfigKeysForFile", "jsonFile", "Lcom/intellij/json/psi/JsonFile;", "collectPredefinedKeys", "Companion", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorMetaConfigKeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorMetaConfigKeyManager.kt\ncom/intellij/ktor/configurations/meta/key/KtorMetaConfigKeyManager\n+ 2 MetaConfigFileUtils.kt\ncom/intellij/microservices/jvm/config/utils/MetaConfigFileUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n30#2,2:53\n49#2:55\n1374#3:56\n1460#3,5:57\n*S KotlinDebug\n*F\n+ 1 KtorMetaConfigKeyManager.kt\ncom/intellij/ktor/configurations/meta/key/KtorMetaConfigKeyManager\n*L\n36#1:53,2\n36#1:55\n37#1:56\n37#1:57,5\n*E\n"})
public final class KtorMetaConfigKeyManager
extends MetaConfigKeyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public List<MetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (module == null || !KtorLibraryUtilKt.hasKtorServerLibrary(module)) {
            return CollectionsKt.emptyList();
        }
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> KtorMetaConfigKeyManager.getAllMetaConfigKeys$lambda$0(this, module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public MetaConfigKeyManager.ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return KtorConfigKeyNameBinder.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MetaConfigKey> collectKeysFromLibraries(Module module) {
        void $this$flatMapTo$iv$iv;
        void fileName$iv$iv;
        void scope$iv$iv;
        void fileName$iv;
        void module$iv;
        Module module2 = module;
        String string = "spring-configuration-metadata.json";
        boolean includeSubpackages$iv22 = true;
        boolean $i$f$findConfigFilesInMetaInf = false;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module$iv, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleRuntimeScope(...)");
        GlobalSearchScope moduleScope$iv = globalSearchScope;
        GlobalSearchScope globalSearchScope2 = moduleScope$iv;
        void var9_12 = fileName$iv;
        boolean includeSubpackages$iv$iv = includeSubpackages$iv22;
        boolean $i$f$findConfigFilesInMetaInf2 = false;
        List metaInfConfigFiles = MetaConfigFileUtilsKt.findConfigFilesInMetaInf((GlobalSearchScope)scope$iv$iv, (String)fileName$iv$iv, JsonFile.class, (boolean)includeSubpackages$iv$iv);
        Iterable $this$flatMap$iv = metaInfConfigFiles;
        boolean $i$f$flatMap = false;
        Iterable includeSubpackages$iv22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JsonFile configMetadataFile = (JsonFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getConfigKeysForFile(module, configMetadataFile);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.collectPredefinedKeys(module));
    }

    private final List<MetaConfigKey> getConfigKeysForFile(Module module, JsonFile jsonFile) {
        return KtorMetaConfigKeyService.Companion.getInstance().parseJsonFile(module, jsonFile);
    }

    private final List<MetaConfigKey> collectPredefinedKeys(Module module) {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/config/default-ktor-properties.json");
        if (uRL == null) {
            return CollectionsKt.emptyList();
        }
        URL url = uRL;
        KtorMetaConfigKeyService ktorMetaConfigKeyService = KtorMetaConfigKeyService.Companion.getInstance();
        InputStream inputStream = url.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
        return ktorMetaConfigKeyService.parseDefault(module, inputStream);
    }

    private static final CachedValueProvider.Result getAllMetaConfigKeys$lambda$0(KtorMetaConfigKeyManager this$0, Module $module) {
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)$module.getProject())};
        return CachedValueProvider.Result.create(this$0.collectKeysFromLibraries($module), (Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ktor/configurations/meta/key/KtorMetaConfigKeyManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ktor/configurations/meta/key/KtorMetaConfigKeyManager;", "intellij.ktor"})
    @SourceDebugExtension(value={"SMAP\nKtorMetaConfigKeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorMetaConfigKeyManager.kt\ncom/intellij/ktor/configurations/meta/key/KtorMetaConfigKeyManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,52:1\n30#2,2:53\n*S KotlinDebug\n*F\n+ 1 KtorMetaConfigKeyManager.kt\ncom/intellij/ktor/configurations/meta/key/KtorMetaConfigKeyManager$Companion\n*L\n22#1:53,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KtorMetaConfigKeyManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<KtorMetaConfigKeyManager> serviceClass$iv = KtorMetaConfigKeyManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KtorMetaConfigKeyManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

