/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.model.xml.Advisor;
import com.intellij.spring.aop.model.xml.BasicAdvice;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.NotNull;

public final class SpringAopErrorsInspection
extends BasicDomElementsInspection<Beans> {
    public SpringAopErrorsInspection() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(@NotNull DomFileElement<Beans> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        if (domFileElement == null) {
            SpringAopErrorsInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringAopErrorsInspection.$$$reportNull$$$0(1);
        }
        if (!SpringDomUtils.hasNamespace(domFileElement, (String)"Spring AOP namespace key")) {
            return;
        }
        super.checkFileElement(domFileElement, holder);
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        Advisor advisor;
        if (element == null) {
            SpringAopErrorsInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringAopErrorsInspection.$$$reportNull$$$0(3);
        }
        if (helper == null) {
            SpringAopErrorsInspection.$$$reportNull$$$0(4);
        }
        if (element instanceof BasicAdvice) {
            BasicAdvice advice = (BasicAdvice)element;
            if (!DomUtil.hasXml(advice.getPointcut()) && !DomUtil.hasXml(advice.getPointcutRef())) {
                SpringAopErrorsInspection.createPointcutProblem(element, holder);
            }
        } else if (element instanceof Advisor && !DomUtil.hasXml((advisor = (Advisor)element).getPointcut()) && !DomUtil.hasXml(advisor.getPointcutRef())) {
            SpringAopErrorsInspection.createPointcutProblem(element, holder);
        }
    }

    private static void createPointcutProblem(DomElement element, DomElementAnnotationHolder holder) {
        holder.createProblem(element, HighlightSeverity.ERROR, SpringAopBundle.message("error.pointcut.or.pointcut.ref.should.be.defined", new Object[0]), new LocalQuickFix[]{new DefineAttributeQuickFix("pointcut"), new DefineAttributeQuickFix("pointcut-ref")});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domFileElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/aop/highlighting/SpringAopErrorsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFileElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDomElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

