/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.inspections;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.inspections.SwMarkAsSpecificationFix;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/swagger/core/inspections/SwFileVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "stopIgnoringFileFix", "ignoreSpecificationFix", "findRootNode", "Lcom/intellij/psi/PsiElement;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwMaybeSpecificationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwMaybeSpecificationInspection.kt\ncom/intellij/swagger/core/inspections/SwFileVisitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,92:1\n19#2:93\n19#2:94\n*S KotlinDebug\n*F\n+ 1 SwMaybeSpecificationInspection.kt\ncom/intellij/swagger/core/inspections/SwFileVisitor\n*L\n77#1:93\n84#1:94\n*E\n"})
final class SwFileVisitor
extends PsiElementVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public SwFileVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!(SwSpecificationDetectionKt.detectPrimarySpecificationType(virtualFile2, psiFile) instanceof SwSpecificationType.UNKNOWN)) {
            return;
        }
        if (SwSpecificationDetectionKt.detectUserDefinedSpecificationType(psiFile) instanceof SwSpecificationType.IGNORED) {
            this.stopIgnoringFileFix(psiFile, this.holder);
        } else if (!(SwSpecificationDetectionKt.detectInheritedSpecificationType(psiFile) instanceof SwSpecificationType.UNKNOWN)) {
            this.ignoreSpecificationFix(psiFile, this.holder);
        }
    }

    private final void stopIgnoringFileFix(PsiFile psiFile, ProblemsHolder holder) {
        PsiElement psiElement = this.findRootNode(psiFile);
        if (psiElement == null) {
            return;
        }
        PsiElement rootNode = psiElement;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwMarkAsSpecificationFix(SwaggerBundle.message("action.SwMarkFileAsSpecificationIntention.name", new Object[0]), PriorityAction.Priority.LOW, SwSpecificationType.IGNORED.INSTANCE, SwSpecificationType.UNKNOWN.INSTANCE)};
        holder.registerProblem(rootNode, SwaggerBundle.message("inspection.maybe.specification.problem.spec.candidate.text", new Object[0]), ProblemHighlightType.WARNING, localQuickFixArray);
    }

    private final void ignoreSpecificationFix(PsiFile psiFile, ProblemsHolder holder) {
        PsiElement psiElement = this.findRootNode(psiFile);
        if (psiElement == null) {
            return;
        }
        PsiElement rootNode = psiElement;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SwMarkAsSpecificationFix(SwaggerBundle.message("actions.ignore.mark.as.specification.title", new Object[0]), PriorityAction.Priority.LOW, SwSpecificationType.UNKNOWN.INSTANCE, SwSpecificationType.IGNORED.INSTANCE)};
        holder.registerProblem(rootNode, SwaggerBundle.message("inspection.maybe.specification.problem.stop.considering.spec.text", new Object[0]), ProblemHighlightType.INFORMATION, localQuickFixArray);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findRootNode(PsiFile psiFile) {
        PsiElement psiElement;
        PsiFile psiFile2 = psiFile;
        if (psiFile2 instanceof YAMLFile) {
            PsiElement psiElement2;
            YAMLMapping yAMLMapping;
            YAMLDocument topLevelValue;
            List list = ((YAMLFile)psiFile).getDocuments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
            YAMLDocument yAMLDocument = (YAMLDocument)CollectionsKt.firstOrNull((List)list);
            if (yAMLDocument == null || (yAMLDocument = yAMLDocument.getTopLevelValue()) == null) {
                return (PsiElement)psiFile;
            }
            Object $this$asSafely$iv = topLevelValue = yAMLDocument;
            boolean $i$f$asSafely = false;
            YAMLDocument yAMLDocument2 = $this$asSafely$iv;
            if (!(yAMLDocument2 instanceof YAMLMapping)) {
                yAMLDocument2 = null;
            }
            psiElement = (yAMLMapping = (YAMLMapping)yAMLDocument2) != null && ($this$asSafely$iv = yAMLMapping.getKeyValues()) != null && ($i$f$asSafely = (YAMLKeyValue)CollectionsKt.firstOrNull((Iterable)((Iterable)$this$asSafely$iv))) != null && (psiElement2 = $i$f$asSafely.getKey()) != null ? psiElement2 : (PsiElement)topLevelValue;
        } else if (psiFile2 instanceof JsonFile) {
            void var3_4;
            JsonValue jsonValue;
            JsonProperty jsonProperty;
            List list;
            JsonObject jsonObject;
            JsonValue topLevelValue;
            JsonValue jsonValue2 = ((JsonFile)psiFile).getTopLevelValue();
            if (jsonValue2 == null) {
                return (PsiElement)psiFile;
            }
            JsonValue $this$asSafely$iv = topLevelValue = jsonValue2;
            boolean $i$f$asSafely = false;
            JsonValue jsonValue3 = $this$asSafely$iv;
            if (!(jsonValue3 instanceof JsonObject)) {
                jsonValue3 = null;
            }
            psiElement = (PsiElement)((jsonObject = (JsonObject)jsonValue3) != null && (list = jsonObject.getPropertyList()) != null && (jsonProperty = (JsonProperty)CollectionsKt.firstOrNull((List)list)) != null && (jsonValue = jsonProperty.getNameElement()) != null ? jsonValue : var3_4);
        } else {
            psiElement = null;
        }
        return psiElement;
    }
}

