/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.conversion;

import io.kubernetes.client.openapi.models.V1CronJob;
import io.kubernetes.client.openapi.models.V1CronJobSpec;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1JobSpec;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1OwnerReference;
import java.util.Arrays;
import java.util.HashMap;

public class Jobs {
    public static V1Job cronJobToJob(V1CronJob cronJob, String jobName) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        HashMap<String, String> labels = new HashMap<String, String>();
        V1JobSpec jobSpec = null;
        V1CronJobSpec cronJobSpec = cronJob.getSpec();
        if (cronJobSpec != null && cronJobSpec.getJobTemplate() != null) {
            V1ObjectMeta metadata = cronJobSpec.getJobTemplate().getMetadata();
            if (metadata != null) {
                if (metadata.getAnnotations() != null) {
                    annotations.putAll(metadata.getAnnotations());
                }
                if (metadata.getLabels() != null) {
                    labels.putAll(metadata.getLabels());
                }
            }
            jobSpec = cronJobSpec.getJobTemplate().getSpec();
        }
        annotations.put("cronjob.kubernetes.io/instantiate", "manual");
        V1OwnerReference v1OwnerReference = new V1OwnerReference();
        v1OwnerReference.setKind("CronJob");
        v1OwnerReference.setName(cronJob.getMetadata().getName());
        v1OwnerReference.setBlockOwnerDeletion(true);
        v1OwnerReference.setController(true);
        v1OwnerReference.setUid(cronJob.getMetadata().getUid());
        v1OwnerReference.setApiVersion("batch/v1beta1");
        V1ObjectMeta jobMetadata = new V1ObjectMeta();
        jobMetadata.setName(jobName != null ? jobName : cronJob.getMetadata().getName() + "-manual");
        jobMetadata.setAnnotations(annotations);
        jobMetadata.setLabels(labels);
        jobMetadata.setOwnerReferences(Arrays.asList(v1OwnerReference));
        V1Job job = new V1Job();
        job.setKind("Job");
        job.setApiVersion("batch/v1");
        job.setMetadata(jobMetadata);
        job.setSpec(jobSpec);
        return job;
    }
}

