/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.hibernate.converters;

import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.jpa.model.xml.GenericNamedValueConvertersRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.values.SpringValueConvertersProvider;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.persistence.integration.hibernate.HibernateIntegrationUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HibernatePropertyValueConverter
extends WrappingConverter
implements Condition<Pair<PsiType, GenericDomValue<?>>>,
SpringValueConvertersProvider {
    @NonNls
    private static final String HIBERNATE_PROPERTIES = "hibernateProperties";

    HibernatePropertyValueConverter() {
    }

    @Nullable
    public Converter<?> getConverter(@NotNull GenericDomValue domElement) {
        String value;
        Prop prop;
        if (domElement == null) {
            HibernatePropertyValueConverter.$$$reportNull$$$0(0);
        }
        if ((prop = (Prop)domElement.getParentOfType(Prop.class, false)) != null && (value = prop.getKey().getStringValue()) != null) {
            return GenericNamedValueConvertersRegistry.getConverter(Property.class, (String)value);
        }
        return null;
    }

    public boolean value(Pair<PsiType, GenericDomValue<?>> pair) {
        GenericDomValue domValue = (GenericDomValue)pair.getSecond();
        SpringProperty springProperty = (SpringProperty)domValue.getParentOfType(SpringProperty.class, false);
        return springProperty != null && HIBERNATE_PROPERTIES.equals(springProperty.getName().getStringValue()) && HibernateIntegrationUtil.isSessionFactoryBean((SpringBean)springProperty.getParentOfType(SpringBean.class, false), false, true);
    }

    public Converter<?> getConverter() {
        return this;
    }

    public Condition<Pair<PsiType, GenericDomValue<?>>> getCondition() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domElement", "com/intellij/spring/persistence/integration/hibernate/converters/HibernatePropertyValueConverter", "getConverter"));
    }
}

