/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.frontend.split.highlighting;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sh.ShFileType;
import com.intellij.sh.frontend.split.highlighting.ShFrontendHighlightingSuppressorKt;
import com.jetbrains.codeWithMe.model.SyntaxHighlighterModel;
import com.jetbrains.rd.ide.model.DefaultHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sh/frontend/split/highlighting/ShFrontendHighlightingSuppressor;", "Lcom/jetbrains/rdclient/daemon/FrontendHighlighterSuppressionHandler;", "<init>", "()V", "shouldSuppress", "", "highlighterModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "document", "Lcom/intellij/openapi/editor/Document;", "isShSyntaxHighlightingFromBackend", "highlighterId", "", "isParseError", "model", "isSpecialIgnoredHighlighterFromBackend", "intellij.sh.frontend.split"})
public final class ShFrontendHighlightingSuppressor
implements FrontendHighlighterSuppressionHandler {
    public boolean shouldSuppress(@NotNull HighlighterModel highlighterModel, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)highlighterModel, (String)"highlighterModel");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return !Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getFileType() : null), (Object)ShFileType.INSTANCE) ? false : (highlighterModel instanceof SyntaxHighlighterModel ? true : (this.isShSyntaxHighlightingFromBackend(highlighterModel.getProperties().getAttributeId()) ? true : (this.isSpecialIgnoredHighlighterFromBackend(highlighterModel) ? true : this.isParseError(highlighterModel))));
    }

    private final boolean isShSyntaxHighlightingFromBackend(String highlighterId) {
        return StringsKt.startsWith$default((String)highlighterId, (String)"IJ.BASH.", (boolean)false, (int)2, null);
    }

    private final boolean isParseError(HighlighterModel model) {
        Object object = model instanceof DefaultHighlighterModel ? (DefaultHighlighterModel)model : null;
        return object != null && (object = object.getInfo()) != null && (object = object.getToolId()) != null ? StringsKt.endsWith$default((String)object, (String)"DefaultHighlightVisitor", (boolean)false, (int)2, null) : false;
    }

    private final boolean isSpecialIgnoredHighlighterFromBackend(HighlighterModel model) {
        Object object = model.getTextAttributesKey();
        if (object == null || (object = object.getExternalName()) == null) {
            return false;
        }
        Object attributeName = object;
        return ShFrontendHighlightingSuppressorKt.access$getAttributesToSkip$p().contains(attributeName);
    }
}

