/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.highlighting;

import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.el.highlighting.SpringELHighlighter;
import com.intellij.spring.el.psi.SpringELParameterList;
import com.intellij.spring.el.psi.SpringELPropertyReference;
import com.intellij.spring.el.psi.SpringELQualifiedType;
import com.intellij.spring.el.psi.SpringELSelectExpression;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class SpringELHighlightingAnnotator
implements Annotator {
    private final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    SpringELHighlightingAnnotator() {
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringELHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringELHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof SpringELQualifiedType) {
            this.doAnnotate(holder, element, SpringELHighlighter.SPEL_QUALIFIED_TYPE);
        }
        if (element instanceof SpringELPropertyReference) {
            this.doAnnotate(holder, element, SpringELHighlighter.SPEL_PROPERTY_KEY);
        }
        if (element instanceof SpringELSelectExpression) {
            SpringELSelectExpression selectExpression = (SpringELSelectExpression)element;
            ELVariable variable = selectExpression.getField();
            if (variable == null) {
                return;
            }
            PsiReference reference = variable.getReference();
            if (reference == null) {
                return;
            }
            if (element.getNextSibling() instanceof SpringELParameterList) {
                this.doAnnotate(holder, (PsiElement)variable, SpringELHighlighter.SPEL_METHOD_CALL);
                return;
            }
            String name = variable.getName();
            if (StringUtil.containsAlphaCharacters((String)name) && name.toUpperCase(Locale.ROOT).equals(name)) {
                this.doAnnotate(holder, (PsiElement)variable, SpringELHighlighter.SPEL_STATIC_FIELD);
            }
        }
    }

    private void doAnnotate(AnnotationHolder holder, PsiElement element, TextAttributesKey key) {
        (this.DEBUG_MODE ? holder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(element).textAttributes(key).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/el/highlighting/SpringELHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

