/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.telepresence.TelepresenceConsoleFilterProviderKt;
import com.intellij.kubernetes.telepresence.TelepresenceLeaveInterceptionActionKt;
import com.intellij.kubernetes.telepresence.TelepresenceModelInterface;
import com.intellij.kubernetes.telepresence.TelepresenceObject;
import com.intellij.kubernetes.telepresence.TelepresenceUtilsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceLeaveInterceptionAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareAction;", "<init>", "()V", "update", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createConfirmationDialog", "Lcom/intellij/openapi/ui/OkCancelDialogBuilder;", "interceptName", "", "LeaveInterceptionService", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nTelepresenceLeaveInterceptionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceLeaveInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceLeaveInterceptionAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,84:1\n30#2,2:85\n*S KotlinDebug\n*F\n+ 1 TelepresenceLeaveInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceLeaveInterceptionAction\n*L\n46#1:85,2\n*E\n"})
public final class TelepresenceLeaveInterceptionAction
extends KubernetesModelBasedDumbAwareAction {
    protected void update(@NotNull KubernetesApiModelInterface apiModel2, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TelepresenceObject telepresenceObject = TelepresenceUtilsKt.getTelepresenceInterception((AnActionEvent)event);
        event.getPresentation().setEnabledAndVisible((telepresenceObject != null ? telepresenceObject.getInterceptName() : null) != null);
    }

    protected void actionPerformed(@NotNull KubernetesApiModelInterface apiModel2, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        TelepresenceObject telepresenceObject = TelepresenceUtilsKt.getTelepresenceInterception((AnActionEvent)event);
        Intrinsics.checkNotNull((Object)telepresenceObject);
        TelepresenceObject interception = telepresenceObject;
        String string = interception.getInterceptName();
        Intrinsics.checkNotNull((Object)string);
        String interceptionName = string;
        KubernetesUsageTriggerCollector.INSTANCE.getTELEPRESENCE_ACTION_TRIGGERED_EVENT().log(project2, (Object)"telepresence-leave");
        OkCancelDialogBuilder dialogBuilder = this.createConfirmationDialog(interceptionName);
        if (!dialogBuilder.ask(project2)) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<LeaveInterceptionService> serviceClass$iv = LeaveInterceptionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((LeaveInterceptionService)object).delete(apiModel2.getTelepresenceModel(), interception);
    }

    private final OkCancelDialogBuilder createConfirmationDialog(String interceptName) {
        String string = KubernetesBundle.message((String)"action.Telepresence.LeaveInterception.dialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{interceptName};
        String string2 = KubernetesBundle.message((String)"action.Telepresence.LeaveInterception.dialog.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        String string3 = KubernetesBundle.message((String)"action.Telepresence.LeaveInterception.dialog.yes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return (OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string3);
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceLeaveInterceptionAction$LeaveInterceptionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "delete", "Lkotlinx/coroutines/Deferred;", "", "telepresenceModel", "Lcom/intellij/kubernetes/telepresence/TelepresenceModelInterface;", "resource", "Lcom/intellij/kubernetes/telepresence/TelepresenceObject;", "intellij.clouds.kubernetes.backend"})
    @SourceDebugExtension(value={"SMAP\nTelepresenceLeaveInterceptionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceLeaveInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceLeaveInterceptionAction$LeaveInterceptionService\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,84:1\n47#2,4:85\n*S KotlinDebug\n*F\n+ 1 TelepresenceLeaveInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceLeaveInterceptionAction$LeaveInterceptionService\n*L\n67#1:85,4\n*E\n"})
    private static final class LeaveInterceptionService {
        @NotNull
        private final Project project;
        @NotNull
        private final CoroutineScope coroutineScope;

        public LeaveInterceptionService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.project = project;
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final Deferred<Unit> delete(@NotNull TelepresenceModelInterface telepresenceModel, @NotNull TelepresenceObject resource) {
            Intrinsics.checkNotNullParameter((Object)telepresenceModel, (String)"telepresenceModel");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            boolean $i$f$CoroutineExceptionHandler = false;
            CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
            return BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineExceptionHandler(key){

                public void handleException(CoroutineContext context2, Throwable exception) {
                    Throwable throwable = exception;
                    boolean bl = false;
                    TelepresenceLeaveInterceptionActionKt.access$getLOG$p().error(throwable);
                }
            }), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(telepresenceModel, resource, this, null){
                Object L$0;
                int label;
                final /* synthetic */ TelepresenceModelInterface $telepresenceModel;
                final /* synthetic */ TelepresenceObject $resource;
                final /* synthetic */ LeaveInterceptionService this$0;
                {
                    this.$telepresenceModel = $telepresenceModel;
                    this.$resource = $resource;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = this.$telepresenceModel.delete(this.$resource, (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (StringsKt.isBlank((CharSequence)(message = (String)v0)) == false) {
                                v1 = TelepresenceConsoleFilterProviderKt.getTelepresenceNotificationGroup();
                                v2 = KubernetesBundle.message((String)"TelepresenceNotificationGroup.title", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                                v1.createNotification(v2, message, NotificationType.WARNING).notify(LeaveInterceptionService.access$getProject$p(this.this$0));
                            }
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)message);
                            this.label = 2;
                            v3 = this.$telepresenceModel.refreshInterceptionsList((Continuation)this);
                            if (v3 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl28
                        }
                        case 2: {
                            message = (String)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl28:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public static final /* synthetic */ Project access$getProject$p(LeaveInterceptionService $this) {
            return $this.project;
        }
    }
}

