/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Spring Profile")
public class SpringProfileTarget
implements PomRenameableTarget<Object> {
    private final SmartPsiElementPointer<PsiElement> myElementPointer;
    private final int myNameOffset;
    private String myName;

    public SpringProfileTarget(@NotNull PsiElement element, @NotNull String name, int nameOffset) {
        if (element == null) {
            SpringProfileTarget.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SpringProfileTarget.$$$reportNull$$$0(1);
        }
        PsiFile containingFile = element.getContainingFile();
        Project project = containingFile == null ? element.getProject() : containingFile.getProject();
        this.myElementPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element, containingFile);
        this.myNameOffset = nameOffset;
        this.myName = name;
    }

    public boolean isWritable() {
        return true;
    }

    public Object setName(@NotNull String name) {
        if (name == null) {
            SpringProfileTarget.$$$reportNull$$$0(2);
        }
        this.myName = name;
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isValid() {
        return this.myElementPointer.getElement() != null;
    }

    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile;
        Segment elementRange = this.myElementPointer.getRange();
        if (elementRange == null) {
            return;
        }
        int offset = elementRange.getStartOffset();
        if (this.myNameOffset < elementRange.getEndOffset() - offset) {
            offset += this.myNameOffset;
        }
        if ((virtualFile = this.myElementPointer.getVirtualFile()) != null && virtualFile.isValid()) {
            PsiNavigationSupport.getInstance().createNavigatable(this.myElementPointer.getProject(), virtualFile, offset).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    public boolean canNavigateToSource() {
        if (this.myNameOffset < 0) {
            return false;
        }
        PsiElement element = this.myElementPointer.getElement();
        return element != null && PsiNavigationSupport.getInstance().canNavigate(element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringProfileTarget target = (SpringProfileTarget)o;
        return Objects.equals(this.myName, target.myName);
    }

    public int hashCode() {
        return this.myName == null ? 0 : this.myName.hashCode();
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElementPointer.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/profiles/SpringProfileTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

