/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.ui;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.profiler.ultimate.ui.JavaProjectCodeDetector;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0010H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u0018\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u0011\u0012\t\u0012\u00070\u0012\u00a2\u0006\u0002\b\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByPackage;", "Lcom/intellij/profiler/ultimate/ui/JavaProjectCodeDetector;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "getFileIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileIndex$delegate", "Lkotlin/Lazy;", "packageCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "", "isInProject", "node", "Lcom/intellij/profiler/ultimate/model/BaseJavaMethodCall;", "isInProjectFast", "packageName", "Companion", "intellij.profiler.ultimate"})
public final class ProjectCodeDetectorByPackage
implements JavaProjectCodeDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Lazy fileIndex$delegate;
    @NotNull
    private final Cache<String, Boolean> packageCache;

    public ProjectCodeDetectorByPackage(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.fileIndex$delegate = LazyKt.lazy(() -> ProjectCodeDetectorByPackage.fileIndex_delegate$lambda$0(this));
        Cache cache = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.packageCache = cache;
    }

    private final ProjectFileIndex getFileIndex() {
        Lazy lazy = this.fileIndex$delegate;
        return (ProjectFileIndex)lazy.getValue();
    }

    @Override
    public boolean isInProject(@NotNull BaseJavaMethodCall node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        String packageName = node.getFullPackageName();
        Object object = this.packageCache.get((Object)packageName, arg_0 -> ProjectCodeDetectorByPackage.isInProject$lambda$1(arg_0 -> ProjectCodeDetectorByPackage.isInProject$lambda$0(this, packageName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    @Override
    public boolean isInProjectFast(@NotNull BaseJavaMethodCall node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        String packageName = node.getFullPackageName();
        Object object = this.packageCache.get((Object)packageName, arg_0 -> ProjectCodeDetectorByPackage.isInProjectFast$lambda$1(arg_0 -> ProjectCodeDetectorByPackage.isInProjectFast$lambda$0(this, packageName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private final boolean isInProject(String packageName) {
        PackageIndex index = PackageIndex.getInstance((Project)this.project);
        return index.getDirsByPackageName(packageName, false).anyMatch(arg_0 -> ProjectCodeDetectorByPackage.isInProject$lambda$2((Function1)new Function1<VirtualFile, Boolean>((Object)this.getFileIndex()){

            public final Boolean invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ProjectFileIndex)this.receiver).isInContent(p0);
            }
        }, arg_0)) || index.getFilesByPackageName(packageName).anyMatch(arg_0 -> ProjectCodeDetectorByPackage.isInProject$lambda$3((Function1)new Function1<VirtualFile, Boolean>((Object)this.getFileIndex()){

            public final Boolean invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ProjectFileIndex)this.receiver).isInContent(p0);
            }
        }, arg_0));
    }

    private static final ProjectFileIndex fileIndex_delegate$lambda$0(ProjectCodeDetectorByPackage this$0) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this$0.project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        return projectFileIndex;
    }

    private static final Boolean isInProject$lambda$0(ProjectCodeDetectorByPackage this$0, String $packageName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)ActionsKt.runReadAction(() -> ProjectCodeDetectorByPackage.isInProject$lambda$0$0(this$0, $packageName));
    }

    private static final boolean isInProject$lambda$0$0(ProjectCodeDetectorByPackage this$0, String $packageName) {
        return this$0.isInProject($packageName);
    }

    private static final Boolean isInProject$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isInProjectFast$lambda$0(ProjectCodeDetectorByPackage this$0, String $packageName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)this$0.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $packageName, null){
            int label;
            final /* synthetic */ ProjectCodeDetectorByPackage this$0;
            final /* synthetic */ String $packageName;
            {
                this.this$0 = $receiver;
                this.$packageName = $packageName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.profiler.ultimate.jfr.ui.ProjectCodeDetectorByPackage java.lang.String ), ()Ljava/lang/Boolean;)((ProjectCodeDetectorByPackage)this.this$0, (String)this.$packageName), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        result = (Boolean)v0;
                        ProjectCodeDetectorByPackage.access$getPackageCache$p(this.this$0).put((Object)this.$packageName, (Object)Boxing.boxBoolean((boolean)(result != false)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(ProjectCodeDetectorByPackage this$0, String $packageName) {
                return ProjectCodeDetectorByPackage.access$isInProject(this$0, $packageName);
            }
        }), (int)2, null);
        Boolean bl = (Boolean)this$0.packageCache.getIfPresent((Object)$packageName);
        if (bl == null) {
            bl = false;
        }
        return bl;
    }

    private static final Boolean isInProjectFast$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isInProject$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isInProject$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Cache access$getPackageCache$p(ProjectCodeDetectorByPackage $this) {
        return $this.packageCache;
    }

    public static final /* synthetic */ boolean access$isInProject(ProjectCodeDetectorByPackage $this, String packageName) {
        return $this.isInProject(packageName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByPackage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByPackage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nJFRDumpView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JFRDumpView.kt\ncom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByPackage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,756:1\n30#2,2:757\n*S KotlinDebug\n*F\n+ 1 JFRDumpView.kt\ncom/intellij/profiler/ultimate/jfr/ui/ProjectCodeDetectorByPackage$Companion\n*L\n297#1:757,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectCodeDetectorByPackage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ProjectCodeDetectorByPackage> serviceClass$iv = ProjectCodeDetectorByPackage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ProjectCodeDetectorByPackage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

