/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.util;

import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;

public final class CssConstants {
    @NonNls
    public static final String AND = "and";
    @NonNls
    public static final String NOT = "not";
    @NonNls
    public static final String ANY = "any";
    @NonNls
    public static final String UNUSED = "unused";
    @NonNls
    public static final String ONLY = "only";
    @NonNls
    public static final String OR = "or";
    @NonNls
    public static final String SUPPORTS = "supports";
    @NonNls
    public static final String SEMICOLON = ";";
    @NonNls
    public static final String COLON = ":";
    @NonNls
    public static final String INHERIT_VALUE = "inherit";
    public static final CssMediaGroup[] DEFAULT_MEDIA_GROUPS = new CssMediaGroup[]{CssMediaGroup.ALL};
    @NonNls
    public static final String ATTR_FUNCTION_NAME = "attr";
    @NonNls
    public static final String CALC_FUNCTION_NAME = "calc";
    @NonNls
    public static final String ROUND_FUNCTION_NAME = "round";
    @NonNls
    public static final String MOD_FUNCTION_NAME = "mod";
    @NonNls
    public static final String REM_FUNCTION_NAME = "rem";
    @NonNls
    public static final String MAX_FUNCTION_NAME = "max";
    @NonNls
    public static final String MIN_FUNCTION_NAME = "min";
    @NonNls
    public static final String CLAMP_FUNCTION_NAME = "clamp";
    @NonNls
    public static final String TOGGLE_FUNCTION_NAME = "toggle";
    @NonNls
    public static final String VAR_FUNCTION_NAME = "var";
    @NonNls
    public static final String ENV_FUNCTION_NAME = "env";
    @NonNls
    public static final String IMAGE_FUNCTION_NAME = "image";
    @NonNls
    public static final String RECT_FUNCTION_NAME = "rect";
    @NonNls
    public static final String COUNTER_FUNCTION_NAME = "counter";
    @NonNls
    public static final String PART_FUNCTION_NAME = "part";
    @NonNls
    public static final String LOCAL = "local";
    @NonNls
    public static final String GLOBAL = "global";
    @NonNls
    public static final String COMPOSES = "composes";
    public static final Set<String> CONDITION_KEYWORDS = Set.of("and", "not", "any", "unused", "only", "or");
    public static final Set<String> EXPONENTIAL_FUNCTIONS = Set.of("pow", "sqrt", "hypot", "log", "exp");
    public static final Set<String> TRIG_FUNCTIONS = ContainerUtil.newHashSet((Object[])new String[]{"sin", "cos", "tan"});
    public static final Set<String> REVERSE_TRIG_FUNCTIONS = ContainerUtil.newHashSet((Object[])new String[]{"asin", "acos", "atan", "atan2"});
    public static final Set<String> OUTER_MATH_FUNCTIONS = Set.of("calc", "max", "min", "clamp", "round", "mod", "rem");
    public static final Set<String> MATH_FUNCTIONS = Stream.of(EXPONENTIAL_FUNCTIONS, TRIG_FUNCTIONS, REVERSE_TRIG_FUNCTIONS, OUTER_MATH_FUNCTIONS).flatMap(Collection::stream).collect(Collectors.toSet());
    public static final Set<String> COLOR_FUNCTIONS = ContainerUtil.newHashSet((Object[])new String[]{"rgb", "rgba", "hsl", "hsla", "gray", "hwb", "lab", "lch", "oklch", "color"});
    public static final Set<String> FUNCTIONS_OVER_COLOR = ContainerUtil.newHashSet((Object[])new String[]{"color", "blend", "blenda"});

    private CssConstants() {
    }
}

