/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.directoryManager;

import com.intellij.javaee.directoryManager.SystemBaseDirectoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class JavaeeSystemBaseDirectoryManagerProvider {
    private final Map<String, SystemBaseDirectoryManager> myManagers = new ConcurrentHashMap<String, SystemBaseDirectoryManager>();

    @NotNull
    public SystemBaseDirectoryManager getManager(@NotNull String parentDirectoryName) {
        if (parentDirectoryName == null) {
            JavaeeSystemBaseDirectoryManagerProvider.$$$reportNull$$$0(0);
        }
        SystemBaseDirectoryManager systemBaseDirectoryManager = this.myManagers.computeIfAbsent(parentDirectoryName, ManagerImpl::new);
        if (systemBaseDirectoryManager == null) {
            JavaeeSystemBaseDirectoryManagerProvider.$$$reportNull$$$0(1);
        }
        return systemBaseDirectoryManager;
    }

    public static SystemBaseDirectoryManager getManagerInstance(@NotNull String parentDirectoryName) {
        if (parentDirectoryName == null) {
            JavaeeSystemBaseDirectoryManagerProvider.$$$reportNull$$$0(2);
        }
        return ((JavaeeSystemBaseDirectoryManagerProvider)ApplicationManager.getApplication().getService(JavaeeSystemBaseDirectoryManagerProvider.class)).getManager(parentDirectoryName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectoryName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/directoryManager/JavaeeSystemBaseDirectoryManagerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/directoryManager/JavaeeSystemBaseDirectoryManagerProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getManagerInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ManagerImpl
    implements SystemBaseDirectoryManager {
        private final File myParentDirectory;
        private final Set<String> myUsedNames;

        private ManagerImpl(@NotNull String parentDirectoryName) {
            if (parentDirectoryName == null) {
                ManagerImpl.$$$reportNull$$$0(0);
            }
            this.myUsedNames = new HashSet<String>();
            this.myParentDirectory = ManagerImpl.getParentDirectory(parentDirectoryName);
            File[] children = this.myParentDirectory.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.myUsedNames.add(child.getName());
                }
            }
        }

        @NotNull
        private static File getParentDirectory(@NotNull String parentDirectoryName) {
            File file;
            if (parentDirectoryName == null) {
                ManagerImpl.$$$reportNull$$$0(1);
            }
            File directory = new File(PathManager.getSystemPath(), parentDirectoryName);
            try {
                file = directory.getCanonicalFile();
            }
            catch (IOException e) {
                File file2 = directory;
                if (file2 == null) {
                    ManagerImpl.$$$reportNull$$$0(3);
                }
                return file2;
            }
            if (file == null) {
                ManagerImpl.$$$reportNull$$$0(2);
            }
            return file;
        }

        @Override
        @NotNull
        public File getDirectory(@NotNull String directoryName) {
            if (directoryName == null) {
                ManagerImpl.$$$reportNull$$$0(4);
            }
            return new File(this.myParentDirectory, directoryName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public String suggestNewDirectoryName(@NotNull String prefix) {
            if (prefix == null) {
                ManagerImpl.$$$reportNull$$$0(5);
            }
            String baseName = UUID.randomUUID().toString();
            int i = 1;
            Object nameCandidate = baseName;
            Set<String> set = this.myUsedNames;
            synchronized (set) {
                while (this.myUsedNames.contains(nameCandidate) || new File(this.myParentDirectory, (String)nameCandidate).exists()) {
                    nameCandidate = baseName + "_" + ++i;
                }
                this.myUsedNames.add((String)nameCandidate);
            }
            Object object = nameCandidate;
            if (object == null) {
                ManagerImpl.$$$reportNull$$$0(6);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDirectoryName";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javaee/directoryManager/JavaeeSystemBaseDirectoryManagerProvider$ManagerImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directoryName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javaee/directoryManager/JavaeeSystemBaseDirectoryManagerProvider$ManagerImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentDirectory";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "suggestNewDirectoryName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentDirectory";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectory";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "suggestNewDirectoryName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 6 -> new IllegalStateException(string);
            };
        }
    }
}

