/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.ipykernel;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.execution.kernel.SeparateProcessKernelRunnableHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.sdk.PySdkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/connections/ipykernel/IPyKernelSdkListener;", "Lcom/jetbrains/python/sdk/PySdkListener;", "processHandler", "Lcom/intellij/jupyter/execution/kernel/SeparateProcessKernelRunnableHandler;", "<init>", "(Lcom/intellij/jupyter/execution/kernel/SeparateProcessKernelRunnableHandler;)V", "moduleSdkUpdated", "", "module", "Lcom/intellij/openapi/module/Module;", "prevSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "newSdk", "intellij.jupyter.py"})
public final class IPyKernelSdkListener
implements PySdkListener {
    @NotNull
    private final SeparateProcessKernelRunnableHandler processHandler;

    public IPyKernelSdkListener(@NotNull SeparateProcessKernelRunnableHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        this.processHandler = processHandler;
    }

    public void moduleSdkUpdated(@NotNull Module module, @Nullable Sdk prevSdk, @Nullable Sdk newSdk) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (prevSdk == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)newSdk, (Object)prevSdk)) {
            return;
        }
        this.processHandler.getProcess().destroyProcess();
        String string = this.processHandler.getNotebookVirtualFile().getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String filename = string;
        String title = JupyterBundle.message((String)"dialog.sdk.replaced.title", (Object[])new Object[0]);
        Object[] objectArray = new Object[]{filename};
        String content = JupyterBundle.message((String)"dialog.sdk.replaced.ipykernel.massage", (Object[])objectArray);
        Notification notification = new Notification("Jupyter", title, content, NotificationType.INFORMATION).setDisplayId("cell.execution.finished");
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        Notification notification2 = notification;
        Notifications.Bus.notify((Notification)notification2, (Project)module.getProject());
    }
}

