/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.JpaIcons;
import com.intellij.jpa.jpb.model.core.model.DbTypeIcon;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.ui.swing.SFieldWithActions;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.ClassUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpaUiUtil {
    @Contract(value="null -> null", pure=true)
    @Nullable
    public static Icon getDbPropertiesIcon(@Nullable DbProperties dbProperties) {
        return JpaUiUtil.getDbTypeIcon(dbProperties == null ? null : dbProperties.getType());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static Icon getDbTypeIcon(@Nullable DbType dbType) {
        return DbTypeIcon.getDbTypeIcon(dbType);
    }

    public static void setupPopupOnRightClick(final @NotNull JTree tree, final @NotNull ActionPopupMenu popupMenu) {
        if (tree == null) {
            JpaUiUtil.$$$reportNull$$$0(0);
        }
        if (popupMenu == null) {
            JpaUiUtil.$$$reportNull$$$0(1);
        }
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    TreePath treePath = tree.getClosestPathForLocation(e.getX(), e.getY());
                    tree.setSelectionPath(treePath);
                    popupMenu.getComponent().show(tree, e.getX(), e.getY());
                }
            }
        });
    }

    public static void setupPopupOnRightClick(final @NotNull JTable table, final @NotNull ActionPopupMenu popupMenu) {
        if (table == null) {
            JpaUiUtil.$$$reportNull$$$0(2);
        }
        if (popupMenu == null) {
            JpaUiUtil.$$$reportNull$$$0(3);
        }
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row;
                if (SwingUtilities.isRightMouseButton(e) && (row = table.rowAtPoint(e.getPoint())) != -1) {
                    TableUtil.selectRows((JTable)table, (int[])new int[]{row});
                    popupMenu.getComponent().show(table, e.getX(), e.getY());
                }
            }
        });
    }

    public static void setEnterKeyListener(@NotNull JComponent component, final @NotNull Runnable runnable) {
        if (component == null) {
            JpaUiUtil.$$$reportNull$$$0(4);
        }
        if (runnable == null) {
            JpaUiUtil.$$$reportNull$$$0(5);
        }
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    runnable.run();
                }
            }
        });
    }

    public static void addShowPasswordActionListener(@NotNull JPasswordField jPasswordField, @NotNull JCheckBox jCheckBox, char echoChar) {
        if (jPasswordField == null) {
            JpaUiUtil.$$$reportNull$$$0(6);
        }
        if (jCheckBox == null) {
            JpaUiUtil.$$$reportNull$$$0(7);
        }
        jCheckBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                jPasswordField.setEchoChar('\u0000');
            } else {
                jPasswordField.setEchoChar(echoChar);
            }
        });
    }

    public static ValidationInfo createValidationInfo(@NlsContexts.DialogMessage @NotNull String msg, @Nullable Object component) {
        if (msg == null) {
            JpaUiUtil.$$$reportNull$$$0(8);
        }
        JComponent targetComponent = null;
        if (component instanceof JComponent) {
            targetComponent = component instanceof SFieldWithActions ? ((SFieldWithActions)((Object)component)).getField() : (JComponent)component;
        }
        return new ValidationInfo(msg, targetComponent);
    }

    public static Icon getIconForEntity(Entity entity) {
        if (entity.isMappedSuperclass()) {
            return JpaIcons.MappedSuperclass;
        }
        if (entity.isEmbeddable()) {
            return JpaIcons.Embeddable;
        }
        return AllIcons.Javaee.PersistenceEntity;
    }

    @Nullable
    public static Icon getIconForEntity(PsiClass entity) {
        if (!EntityUtil.isEntity(entity)) {
            return null;
        }
        if (EntityUtil.isMappedSuperclass(entity)) {
            return JpaIcons.MappedSuperclass;
        }
        if (EntityUtil.isEmbeddable(entity)) {
            return JpaIcons.Embeddable;
        }
        return AllIcons.Javaee.PersistenceEntity;
    }

    @NotNull
    public static Icon getIconForRepositoryMethod(String methodName) {
        if (methodName.startsWith("findAll")) {
            Icon icon = JpaIcons.SpringData.FindCollection;
            if (icon == null) {
                JpaUiUtil.$$$reportNull$$$0(9);
            }
            return icon;
        }
        if (methodName.startsWith("delete")) {
            Icon icon = JpaIcons.SpringData.Delete;
            if (icon == null) {
                JpaUiUtil.$$$reportNull$$$0(10);
            }
            return icon;
        }
        if (methodName.startsWith("count")) {
            Icon icon = JpaIcons.SpringData.Count;
            if (icon == null) {
                JpaUiUtil.$$$reportNull$$$0(11);
            }
            return icon;
        }
        if (methodName.startsWith("update")) {
            Icon icon = JpaIcons.SpringData.Update;
            if (icon == null) {
                JpaUiUtil.$$$reportNull$$$0(12);
            }
            return icon;
        }
        if (methodName.startsWith("save")) {
            Icon icon = JpaIcons.SpringData.Save;
            if (icon == null) {
                JpaUiUtil.$$$reportNull$$$0(13);
            }
            return icon;
        }
        Icon icon = JpaIcons.SpringData.FindInstance;
        if (icon == null) {
            JpaUiUtil.$$$reportNull$$$0(14);
        }
        return icon;
    }

    public static JComponent wrapToHelpPanel(JComponent field, @NlsContexts.Tooltip String description) {
        BorderLayoutPanel panel = new BorderLayoutPanel(10, 4);
        panel.addToCenter((Component)field);
        panel.addToRight((Component)ContextHelpLabel.create((String)description));
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupMenu";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jPasswordField";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jCheckBox";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/util/JpaUiUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/util/JpaUiUtil";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForRepositoryMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupPopupOnRightClick";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEnterKeyListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addShowPasswordActionListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createValidationInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static class ClassAndPackageRenderer
    extends ColoredListCellRenderer<String> {
        protected void customizeCellRenderer(@NotNull JList<? extends String> list, String value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ClassAndPackageRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return;
            }
            this.append(ClassUtil.extractClassName((String)value));
            this.append(" " + ClassUtil.extractPackageName((String)value), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/jpa/jpb/model/util/JpaUiUtil$ClassAndPackageRenderer", "customizeCellRenderer"));
        }
    }
}

