/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.swing;

import com.intellij.jpa.jpb.model.ui.StudioMigPanel;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.util.NlsActions;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.jetbrains.annotations.Nullable;

public class SFieldWithActions<F extends JComponent>
extends StudioMigPanel {
    private final F field;
    private final Map<String, ActionButton> actionButtons = new HashMap<String, ActionButton>();

    public SFieldWithActions(F field, FieldAction ... fieldActions) {
        super(new LC().insets("0px").fill().hideMode(3).noGrid());
        this.field = field;
        this.add((Component)field, new CC().growX().growPrio(new int[]{200}).gap(new String[]{"0px"}).pushY());
        for (FieldAction fieldAction : fieldActions) {
            this.addAction(fieldAction);
        }
    }

    public F getField() {
        return this.field;
    }

    public void addAction(FieldAction fieldAction) {
        ActionButton actionButton = new ActionButton(fieldAction, fieldAction.getTemplatePresentation().clone(), "ActionField", this.getButtonMinimumSize()){

            public void updateUI() {
                AnActionEvent event = AnActionEvent.createEvent((DataContext)this.getDataContext(), (Presentation)this.myPresentation, (String)"SFieldWithAction", (ActionUiKind)ActionUiKind.TOOLBAR, null);
                ActionUtil.updateAction((AnAction)this.myAction, (AnActionEvent)event);
                this.setVisible(this.myPresentation.isVisible());
                super.updateUI();
            }
        };
        this.add((Component)actionButton, new CC().gap(new String[]{"2px"}));
        this.actionButtons.put(fieldAction.getId(), actionButton);
    }

    protected Dimension getButtonMinimumSize() {
        return ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE;
    }

    @Nullable
    public ActionButton getActionButton(String id) {
        return this.actionButtons.get(id);
    }

    public void removeActionButton(String id) {
        ActionButton actionButton = this.actionButtons.get(id);
        if (actionButton != null) {
            this.remove((Component)actionButton);
            this.actionButtons.remove(id);
        }
    }

    public void setEnabled(boolean enabled) {
        ((JComponent)this.field).setEnabled(enabled);
        this.actionButtons.values().forEach(actionButton -> actionButton.setEnabled(enabled));
    }

    public boolean isEnabled() {
        return ((Component)this.field).isEnabled();
    }

    public void updateActions() {
        for (ActionButton value : this.actionButtons.values()) {
            value.updateUI();
        }
    }

    public static abstract class FieldAction
    extends AnAction {
        private final String id;

        public FieldAction(String id, @NlsActions.ActionText String description, Icon icon) {
            super(description, null, icon);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

