/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation;

import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class Annotation {
    public static final String DEFAULT_PARAM_KEY = "value";

    public abstract boolean isInsert(@NotNull EntityAttribute var1, @NotNull Entity var2);

    public boolean isModify() {
        return true;
    }

    public AnnotationModel generateModel(EntityAttribute attr, Entity entity, Project project) {
        return this.generateModel(attr, entity, this.getAllParams(attr, entity.getModule()), project);
    }

    public AnnotationModel generateModel(EntityAttribute attr, Entity entity, LinkedHashMap<String, String> params, Project project) {
        AnnotationModelBuilder builder = AnnotationModel.builder(this.getFqn(project, entity.getModule()));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            builder.add(entry.getKey(), entry.getValue(), false);
        }
        return builder.build();
    }

    public LinkedHashMap<String, String> getParams(@NotNull EntityAttribute attribute, Module module) {
        if (attribute == null) {
            Annotation.$$$reportNull$$$0(0);
        }
        return new LinkedHashMap<String, String>();
    }

    public LinkedHashMap<String, String> getAllParams(EntityAttribute attribute, Module module) {
        LinkedHashMap<String, String> params = this.getParams(attribute, module);
        params.putAll(attribute.getAnnotationUnknownParams(this.getName()));
        return params;
    }

    public List<String> knownAttributes(EntityAttribute attribute) {
        return Collections.emptyList();
    }

    public abstract String getFqn(Project var1, Module var2);

    public abstract String getName();

    public boolean isChangeParams(@NotNull EntityAttribute attribute, LinkedHashMap<String, String> existingParams, LinkedHashMap<String, String> generateParams, Module module) {
        if (attribute == null) {
            Annotation.$$$reportNull$$$0(1);
        }
        if (existingParams.size() != generateParams.size()) {
            return true;
        }
        List<String> knownAttributes = this.knownAttributes(attribute);
        for (String knownAnnAttr : knownAttributes) {
            String generateValue;
            String existingValue = existingParams.get(knownAnnAttr);
            if (Objects.equals(existingValue, generateValue = generateParams.get(knownAnnAttr)) || this.equalsStaticValue(existingValue, generateValue)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsStaticValue(String existingValue, String generateValue) {
        if (existingValue == null || generateValue == null) {
            return false;
        }
        String[] splitGenerateValue = generateValue.split("\\.");
        if (splitGenerateValue.length != 2) {
            return false;
        }
        String firstPartGenerateValue = splitGenerateValue[0];
        return (firstPartGenerateValue.equals("TemporalType") || firstPartGenerateValue.equals("DeletePolicy") || firstPartGenerateValue.equals("FetchType")) && splitGenerateValue[1].equals(existingValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "attribute";
        objectArray2[1] = "com/intellij/jpa/jpb/model/backend/ed/annotation/Annotation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParams";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isChangeParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Vendor {
        JAVAX_JAKARTA_PERSISTENCE,
        JAVAX_JAKARTA_VALIDATION,
        SPRING,
        HIBERNATE,
        HIBERNATE_ENVERS,
        LOMBOK;

    }

    public static enum GenerationStrategy {
        JAVA("{", "}"),
        KOTLIN("[", "]");

        private final String startArrayToken;
        private final String endArrayToken;

        private GenerationStrategy(String startArrayToken, String endArrayToken) {
            this.startArrayToken = startArrayToken;
            this.endArrayToken = endArrayToken;
        }

        public String getStartArrayToken() {
            return this.startArrayToken;
        }

        public String getEndArrayToken() {
            return this.endArrayToken;
        }
    }
}

