/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.annotator;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSBundle;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.psi.impl.LessImportType;

public final class LessErrorsAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Language stylesheetLanguage;
        if (element == null) {
            LessErrorsAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            LessErrorsAnnotator.$$$reportNull$$$0(1);
        }
        if ((stylesheetLanguage = CssPsiUtilCore.getStylesheetLanguage((PsiElement)element)) == LESSLanguage.INSTANCE) {
            if (element instanceof LessImportType) {
                for (ASTNode typeNode : ((LessImportType)element).getImportTypeNodes()) {
                    if (LessImportType.KNOWN_IMPORT_TYPES.contains(typeNode.getText().trim())) continue;
                    holder.newAnnotation(HighlightSeverity.ERROR, LESSBundle.message("annotator.unknown.import.type", new Object[0])).range(typeNode).create();
                }
            } else if (element instanceof PsiComment) {
                CssInspectionsUtil.checkUnclosedComment((PsiComment)((PsiComment)element), (AnnotationHolder)holder);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/less/annotator/LessErrorsAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

