/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.protobuf.ide.highlighter.PbTextHighlightingLexer;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PbTextSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey ENUM_VALUE = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_ENUM_VALUE", (TextAttributesKey)DefaultLanguageHighlighterColors.CONSTANT);
    public static final TextAttributesKey LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey BRACES = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey DOT = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_SEMICOLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey BRACKETS = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    public static final TextAttributesKey COMMENT_DIRECTIVE = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_COMMENT_DIRECTIVE", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"PROTOTEXT_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    private static final Map<IElementType, TextAttributesKey> attributesKeyMap = PbTextSyntaxHighlighter.buildAttributesMap();

    private static Map<IElementType, TextAttributesKey> buildAttributesMap() {
        HashMap map = new HashMap();
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)IDENTIFIER, (IElementType[])new IElementType[]{ProtoTokenTypes.IDENTIFIER_LITERAL});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)NUMBER, (IElementType[])new IElementType[]{ProtoTokenTypes.INTEGER_LITERAL, ProtoTokenTypes.FLOAT_LITERAL});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)STRING, (IElementType[])new IElementType[]{ProtoTokenTypes.STRING_LITERAL});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)LINE_COMMENT, (IElementType[])new IElementType[]{ProtoTokenTypes.LINE_COMMENT});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)OPERATION_SIGN, (IElementType[])new IElementType[]{ProtoTokenTypes.COLON, ProtoTokenTypes.MINUS, ProtoTokenTypes.SLASH});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)BRACES, (IElementType[])new IElementType[]{ProtoTokenTypes.LBRACE, ProtoTokenTypes.RBRACE, ProtoTokenTypes.LT, ProtoTokenTypes.GT});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)BRACKETS, (IElementType[])new IElementType[]{ProtoTokenTypes.LBRACK, ProtoTokenTypes.RBRACK});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)DOT, (IElementType[])new IElementType[]{ProtoTokenTypes.DOT});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)SEMICOLON, (IElementType[])new IElementType[]{ProtoTokenTypes.SEMI});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)COMMA, (IElementType[])new IElementType[]{ProtoTokenTypes.COMMA});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)VALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
        PbTextSyntaxHighlighter.fillMap(map, (TextAttributesKey)BAD_CHARACTER, (IElementType[])new IElementType[]{TokenType.BAD_CHARACTER});
        return Collections.unmodifiableMap(map);
    }

    public static TextAttributesKey getTokenKey(IElementType token) {
        return attributesKeyMap.get(token);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new PbTextHighlightingLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = PbTextSyntaxHighlighter.pack((TextAttributesKey)attributesKeyMap.get(tokenType));
        if (textAttributesKeyArray == null) {
            PbTextSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/protobuf/ide/highlighter/PbTextSyntaxHighlighter", "getTokenHighlights"));
    }
}

