/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.extensions;

import com.intellij.codeInsight.daemon.impl.InjectedLanguageHighlightingRangeReducer;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.NotebookHighlightingFileManager;
import com.intellij.kotlin.jupyter.core.editor.highlighting.NotebookHighlightingService;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.util.FilesKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f*\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/extensions/KotlinNotebookInjectedRangeReducer;", "Lcom/intellij/codeInsight/daemon/impl/InjectedLanguageHighlightingRangeReducer;", "<init>", "()V", "reduceRange", "", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "ensureScriptConfigurations", "", "", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "manager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookInjectedRangeReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookInjectedRangeReducer.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/extensions/KotlinNotebookInjectedRangeReducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,65:1\n1869#2,2:66\n13#3:68\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookInjectedRangeReducer.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/extensions/KotlinNotebookInjectedRangeReducer\n*L\n56#1:66,2\n63#1:68\n*E\n"})
public final class KotlinNotebookInjectedRangeReducer
implements InjectedLanguageHighlightingRangeReducer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<TextRange> reduceRange(@NotNull PsiFile file, @NotNull Editor editor) {
        List list;
        List<JupyterPsiCell> list2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        JupyterFile jupyterFile = file instanceof JupyterFile ? (JupyterFile)file : null;
        if (jupyterFile == null) {
            return null;
        }
        JupyterFile jupyterFile2 = jupyterFile;
        Document document = FileDocumentManager.getInstance().getDocument(jupyterFile2.getVirtualFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (!NotebookCellLines.Companion.hasSupport(editor)) {
            return null;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = FilesKt.toKotlinNotebookBackedFile(jupyterFile2.getVirtualFile());
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        try {
            list2 = UtilKt.getNotebookCells(file);
        }
        catch (IllegalStateException ex) {
            LOG.debug("Can't get Notebook cells list: " + ex);
            list2 = null;
        }
        List<JupyterPsiCell> cells = list2;
        Project project = ((JupyterFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ProgressManager.checkCanceled();
        List<JupyterPsiCell> list3 = cells;
        if (list3 != null) {
            Collection collection = list3;
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"getInstance(...)");
            this.ensureScriptConfigurations(collection, injectedLanguageManager);
        }
        NotebookHighlightingFileManager highlightingManager = NotebookHighlightingService.Companion.getForFile(project2, notebookFile);
        Document document3 = document2;
        synchronized (document3) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)highlightingManager.getRangesToHighlight(file, editor, cells));
        }
        return list;
    }

    private final void ensureScriptConfigurations(Collection<? extends PsiLanguageInjectionHost> $this$ensureScriptConfigurations, InjectedLanguageManager manager) {
        if ($this$ensureScriptConfigurations == null) {
            return;
        }
        for (PsiLanguageInjectionHost psiLanguageInjectionHost : $this$ensureScriptConfigurations) {
            Iterable $this$forEach$iv = UtilKt.getInjectedKtFiles(psiLanguageInjectionHost, manager);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtFile ktFile = (KtFile)element$iv;
                boolean bl = false;
                Project project = ktFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                JupyterCompilerService jupyterCompilerService = JupyterCompilerService.Companion.getInstance(project);
                Project project2 = ktFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                jupyterCompilerService.ensureScriptConfiguration(project2, ktFile);
            }
        }
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/extensions/KotlinNotebookInjectedRangeReducer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

