/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.debug.variables;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.debug.descriptor.NotebookVariableDescriptorPositionResolver;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSession;
import com.intellij.kotlin.jupyter.core.debug.session.KotlinNotebookDebugSessionManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kotlin/jupyter/core/debug/variables/NotebookFieldSourcePositionProvider;", "Lcom/intellij/debugger/engine/SourcePositionProvider;", "<init>", "()V", "computeSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "descriptor", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "nearest", "", "intellij.kotlin.jupyter.core"})
public final class NotebookFieldSourcePositionProvider
extends SourcePositionProvider {
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof FieldDescriptor)) {
            return null;
        }
        KotlinNotebookDebugSession kotlinNotebookDebugSession = KotlinNotebookDebugSessionManager.Companion.getInstance(project).getByDebugProcessOrNull((DebugProcess)context.getDebugProcess());
        if (kotlinNotebookDebugSession == null) {
            return null;
        }
        KotlinNotebookDebugSession session = kotlinNotebookDebugSession;
        BackedNotebookVirtualFile notebookFile = session.getVirtualFile();
        return NotebookVariableDescriptorPositionResolver.INSTANCE.resolveTo(project, notebookFile, (FieldDescriptor)descriptor);
    }
}

