/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSectionDetector;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.JavaArrangementParseInfo;
import com.intellij.psi.codeStyle.arrangement.JavaElementArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.JavaSectionArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.formatter.java.JavaFormatterAnnotationUtil;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaArrangementVisitor
extends JavaRecursiveElementVisitor {
    private static final String NULL_CONTENT = "no content";
    private static final Map<String, ArrangementSettingsToken> MODIFIERS = new HashMap<String, ArrangementSettingsToken>();
    private static final ArrangementSettingsToken ANON_CLASS_PARAMETER_LIST;
    private static final ArrangementSettingsToken ANONYMOUS_CLASS_BODY;
    @NotNull
    private final Stack<JavaElementArrangementEntry> myStack;
    @NotNull
    private final JavaArrangementParseInfo myInfo;
    @NotNull
    private final Collection<? extends TextRange> myRanges;
    @NotNull
    private final Set<ArrangementSettingsToken> myGroupingRules;
    @NotNull
    private final MethodBodyProcessor myMethodBodyProcessor;
    private final boolean myCheckDeep;
    @NotNull
    private final ArrangementSectionDetector mySectionDetector;
    @Nullable
    private final Document myDocument;
    @NotNull
    private final HashMap<PsiClass, Set<PsiField>> myCachedClassFields;
    @NotNull
    private final Set<PsiComment> myProcessedSectionsComments;

    JavaArrangementVisitor(@NotNull JavaArrangementParseInfo infoHolder, @Nullable Document document, @NotNull Collection<? extends TextRange> ranges, @NotNull ArrangementSettings settings, boolean checkDeep) {
        if (infoHolder == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(2);
        }
        this.myStack = new Stack();
        this.myCachedClassFields = new HashMap();
        this.myProcessedSectionsComments = new HashSet<PsiComment>();
        this.myInfo = infoHolder;
        this.myDocument = document;
        this.myRanges = ranges;
        this.myGroupingRules = JavaArrangementVisitor.getGroupingRules(settings);
        this.myMethodBodyProcessor = new MethodBodyProcessor(infoHolder);
        this.myCheckDeep = checkDeep;
        this.mySectionDetector = new ArrangementSectionDetector(document, settings, data -> {
            TextRange range = data.getTextRange();
            JavaSectionArrangementEntry entry = new JavaSectionArrangementEntry((ArrangementEntry)this.getCurrent(), data.getToken(), range, data.getText(), true);
            this.registerEntry(entry);
        });
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(3);
        }
        if (this.myProcessedSectionsComments.contains(comment)) {
            return;
        }
        this.mySectionDetector.processComment(comment);
    }

    @NotNull
    private static Set<ArrangementSettingsToken> getGroupingRules(@NotNull ArrangementSettings settings) {
        if (settings == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(4);
        }
        HashSet<ArrangementSettingsToken> groupingRules = new HashSet<ArrangementSettingsToken>();
        for (ArrangementGroupingRule rule : settings.getGroupings()) {
            groupingRules.add(rule.getGroupingType());
        }
        HashSet<ArrangementSettingsToken> hashSet = groupingRules;
        if (hashSet == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private void createAndProcessAnonymousClassBodyEntry(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(6);
        }
        PsiElement lBrace = aClass.getLBrace();
        PsiElement rBrace = aClass.getRBrace();
        if (lBrace == null || rBrace == null) {
            return;
        }
        TextRange codeBlockRange = new TextRange(lBrace.getTextRange().getStartOffset(), rBrace.getTextRange().getEndOffset());
        JavaElementArrangementEntry entry = this.createNewEntry(codeBlockRange, ANONYMOUS_CLASS_BODY, aClass.getName());
        if (entry == null) {
            return;
        }
        this.processChildrenWithinEntryScope(entry, () -> {
            PsiElement current = lBrace;
            while (current != rBrace && (current = current.getNextSibling()) != null) {
                current.accept((PsiElementVisitor)this);
            }
        });
    }

    @Override
    public void visitClass(@NotNull PsiClass aClass) {
        boolean isSectionCommentsDetected;
        if (aClass == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(7);
        }
        TextRange range = (isSectionCommentsDetected = this.registerSectionComments(aClass)) ? JavaArrangementVisitor.getElementRangeWithoutComments(aClass) : aClass.getTextRange();
        ArrangementSettingsToken type = StdArrangementTokens.EntryType.CLASS;
        if (aClass.isEnum()) {
            type = StdArrangementTokens.EntryType.ENUM;
        } else if (aClass.isInterface()) {
            type = StdArrangementTokens.EntryType.INTERFACE;
        }
        JavaElementArrangementEntry entry = this.createNewEntry(range, type, aClass.getName());
        this.processEntry(entry, aClass, aClass);
    }

    @Override
    public void visitTypeParameter(@NotNull PsiTypeParameter parameter) {
        if (parameter == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(8);
        }
    }

    @Override
    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        JavaElementArrangementEntry entry;
        if (aClass == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(9);
        }
        if ((entry = this.createNewEntry(aClass.getTextRange(), StdArrangementTokens.EntryType.ANONYMOUS_CLASS, aClass.getName())) == null) {
            return;
        }
        this.processChildrenWithinEntryScope(entry, () -> {
            PsiExpressionList list = aClass.getArgumentList();
            if (list != null && list.getTextLength() > 0) {
                JavaElementArrangementEntry listEntry = this.createNewEntry(list.getTextRange(), ANON_CLASS_PARAMETER_LIST, aClass.getName());
                this.processEntry(listEntry, null, list);
            }
            this.createAndProcessAnonymousClassBodyEntry(aClass);
        });
    }

    @Override
    public void visitField(@NotNull PsiField field) {
        JavaElementArrangementEntry entry;
        if (field == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(10);
        }
        boolean isSectionCommentsDetected = this.registerSectionComments(field);
        PsiElement fieldPrev = JavaArrangementVisitor.getPreviousNonWsComment(field.getPrevSibling(), 0);
        if (PsiUtil.isJavaToken(fieldPrev, JavaTokenType.COMMA)) {
            return;
        }
        TextRange range = isSectionCommentsDetected ? JavaArrangementVisitor.getElementRangeWithoutComments(field) : field.getTextRange();
        PsiElement child = field.getLastChild();
        boolean needSpecialProcessing = true;
        if (JavaArrangementVisitor.isSemicolon(child)) {
            needSpecialProcessing = false;
        } else if (child instanceof PsiComment) {
            PsiElement prev = JavaArrangementVisitor.getPreviousNonWsComment(child, range.getStartOffset());
            boolean bl = needSpecialProcessing = prev != null && !JavaArrangementVisitor.isSemicolon(prev);
        }
        if (needSpecialProcessing) {
            for (PsiElement e = field.getNextSibling(); e != null; e = e.getNextSibling()) {
                if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
                if (e instanceof PsiJavaToken) {
                    if (((PsiJavaToken)e).getTokenType() != JavaTokenType.COMMA) break;
                    continue;
                }
                if (!(e instanceof PsiField)) break;
                PsiElement c = e.getLastChild();
                if (c != null) {
                    c = JavaArrangementVisitor.getPreviousNonWsComment(c, range.getStartOffset());
                }
                if (!(c instanceof PsiErrorElement) && !PsiUtil.isJavaToken(c, JavaTokenType.SEMICOLON)) continue;
                range = TextRange.create((int)range.getStartOffset(), (int)this.expandToCommentIfPossible(c));
                break;
            }
        }
        if ((entry = this.createNewEntry(range, StdArrangementTokens.EntryType.FIELD, field.getName())) == null) {
            return;
        }
        this.processEntry(entry, field, field.getInitializer());
        this.myInfo.onFieldEntryCreated(field, entry);
        ArrayList<PsiField> referencedFields = new ArrayList<PsiField>();
        for (PsiField adjacentField : JavaArrangementVisitor.getFieldWithSiblings(field)) {
            referencedFields.addAll(this.getReferencedFields(adjacentField));
        }
        for (PsiField referencedField : referencedFields) {
            this.myInfo.registerFieldInitializationDependency(field, referencedField);
        }
    }

    private static List<PsiField> getFieldWithSiblings(@NotNull PsiField field) {
        if (field == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(11);
        }
        ArrayList<PsiField> fields = new ArrayList<PsiField>();
        fields.add(field);
        PsiElement next = JavaArrangementVisitor.getNextAfterWsOrComment(field);
        while (next != null && PsiUtil.isJavaToken(next, JavaTokenType.COMMA) && (next = JavaArrangementVisitor.getNextAfterWsOrComment(next)) instanceof PsiField) {
            fields.add((PsiField)next);
            next = JavaArrangementVisitor.getNextAfterWsOrComment(next);
        }
        return fields;
    }

    @Nullable
    private static PsiElement getNextAfterWsOrComment(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(12);
        }
        PsiElement next = element.getNextSibling();
        while (next instanceof PsiWhiteSpace || next instanceof PsiComment) {
            next = next.getNextSibling();
        }
        return next;
    }

    @NotNull
    private List<PsiField> getReferencedFields(final @NotNull PsiField field) {
        if (field == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(13);
        }
        final ArrayList<PsiField> referencedElements = new ArrayList<PsiField>();
        PsiExpression fieldInitializer = field.getInitializer();
        PsiClass containingClass = field.getContainingClass();
        if (fieldInitializer == null || containingClass == null) {
            ArrayList<PsiField> arrayList = referencedElements;
            if (arrayList == null) {
                JavaArrangementVisitor.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        Set classFields = this.myCachedClassFields.get(containingClass);
        if (classFields == null) {
            classFields = ContainerUtil.map2Set((Object[])containingClass.getFields(), (Function)Functions.id());
            this.myCachedClassFields.put(containingClass, classFields);
        }
        final Set containingClassFields = classFields;
        fieldInitializer.accept(new JavaRecursiveElementVisitor(){
            int myCurrentMethodLookupDepth;
            private static final int MAX_METHOD_LOOKUP_DEPTH = 3;

            @Override
            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiElement ref;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((ref = expression.resolve()) instanceof PsiField && containingClassFields.contains(ref) && JavaArrangementVisitor.hasSameStaticModifier(field, (PsiField)ref)) {
                    referencedElements.add((PsiField)ref);
                } else if (ref instanceof PsiMethod && this.myCurrentMethodLookupDepth < 3) {
                    ++this.myCurrentMethodLookupDepth;
                    this.visitMethod((PsiMethod)ref);
                    --this.myCurrentMethodLookupDepth;
                }
                super.visitReferenceExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor$1", "visitReferenceExpression"));
            }
        });
        ArrayList<PsiField> arrayList = referencedElements;
        if (arrayList == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static boolean hasSameStaticModifier(@NotNull PsiField first, @NotNull PsiField second) {
        if (first == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(16);
        }
        if (second == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(17);
        }
        boolean isSecondFieldStatic = second.hasModifierProperty("static");
        return first.hasModifierProperty("static") == isSecondFieldStatic;
    }

    @Nullable
    private static PsiElement getPreviousNonWsComment(@Nullable PsiElement element, int minOffset) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element; e != null && e.getTextRange().getStartOffset() >= minOffset; e = e.getPrevSibling()) {
            if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
            return e;
        }
        return null;
    }

    private int expandToCommentIfPossible(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(18);
        }
        if (this.myDocument == null) {
            return element.getTextRange().getEndOffset();
        }
        CharSequence text = this.myDocument.getCharsSequence();
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiWhiteSpace) {
                if (!JavaArrangementVisitor.hasLineBreak(text, e.getTextRange())) continue;
                return element.getTextRange().getEndOffset();
            }
            if (e instanceof PsiComment) {
                if (JavaArrangementVisitor.hasLineBreak(text, e.getTextRange())) continue;
                return e.getTextRange().getEndOffset();
            }
            return element.getTextRange().getEndOffset();
        }
        return element.getTextRange().getEndOffset();
    }

    private static boolean hasLineBreak(@NotNull CharSequence text, @NotNull TextRange range) {
        if (text == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(19);
        }
        if (range == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(20);
        }
        int end = range.getEndOffset();
        for (int i = range.getStartOffset(); i < end; ++i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    private static boolean isSemicolon(@Nullable PsiElement e) {
        return PsiUtil.isJavaToken(e, JavaTokenType.SEMICOLON);
    }

    @Override
    public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
        JavaElementArrangementEntry entry;
        if (initializer == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(21);
        }
        if ((entry = this.createNewEntry(initializer.getTextRange(), StdArrangementTokens.EntryType.INIT_BLOCK, null)) == null) {
            return;
        }
        JavaArrangementVisitor.parseModifierListOwner(initializer, entry);
    }

    @NotNull
    private static TextRange getElementRangeWithoutComments(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(22);
        }
        PsiElement[] children = element.getChildren();
        assert (children.length > 1 && children[0] instanceof PsiComment);
        int i = 0;
        PsiElement child = children[i];
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = children[++i];
        }
        return new TextRange(child.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
    }

    @NotNull
    private static List<PsiComment> getComments(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(23);
        }
        PsiElement[] children = element.getChildren();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiElement e : children) {
            if (e instanceof PsiComment) {
                comments.add((PsiComment)e);
                continue;
            }
            if (e instanceof PsiWhiteSpace) continue;
            ArrayList<PsiComment> arrayList = comments;
            if (arrayList == null) {
                JavaArrangementVisitor.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        ArrayList<PsiComment> arrayList = comments;
        if (arrayList == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethod(@NotNull PsiMethod method) {
        ArrangementSettingsToken type;
        boolean isSectionCommentsDetected;
        TextRange range;
        JavaElementArrangementEntry entry;
        if (method == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(26);
        }
        if ((entry = this.createNewEntry(range = (isSectionCommentsDetected = this.registerSectionComments(method)) ? JavaArrangementVisitor.getElementRangeWithoutComments(method) : method.getTextRange(), type = method.isConstructor() ? StdArrangementTokens.EntryType.CONSTRUCTOR : StdArrangementTokens.EntryType.METHOD, method.getName())) == null) {
            return;
        }
        this.processEntry(entry, method, this.myCheckDeep ? method.getBody() : null);
        this.parseProperties(method, entry);
        this.myInfo.onMethodEntryCreated(method, entry);
        MethodSignatureBackedByPsiMethod overridden = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search(method, null, true, false).findFirst();
        if (overridden != null) {
            entry.addModifier(StdArrangementTokens.Modifier.OVERRIDDEN);
            this.myInfo.onOverriddenMethod(overridden.getMethod(), method);
        }
        boolean reset = this.myMethodBodyProcessor.setBaseMethod(method);
        try {
            method.accept(this.myMethodBodyProcessor);
        }
        finally {
            if (reset) {
                this.myMethodBodyProcessor.setBaseMethod(null);
            }
        }
    }

    private boolean registerSectionComments(@NotNull PsiElement element) {
        if (element == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(27);
        }
        List<PsiComment> comments = JavaArrangementVisitor.getComments(element);
        boolean isSectionCommentsDetected = false;
        for (PsiComment comment : comments) {
            if (!this.mySectionDetector.processComment(comment)) continue;
            isSectionCommentsDetected = true;
            this.myProcessedSectionsComments.add(comment);
        }
        return isSectionCommentsDetected;
    }

    private void parseProperties(PsiMethod method, JavaElementArrangementEntry entry) {
        String propertyName = null;
        boolean getter = true;
        if (PropertyUtilBase.isSimplePropertyGetter(method)) {
            entry.addModifier(StdArrangementTokens.Modifier.GETTER);
            propertyName = PropertyUtilBase.getPropertyNameByGetter(method);
        } else if (PropertyUtilBase.isSimplePropertySetter(method)) {
            entry.addModifier(StdArrangementTokens.Modifier.SETTER);
            propertyName = PropertyUtilBase.getPropertyNameBySetter(method);
            getter = false;
        }
        if (!this.myGroupingRules.contains(StdArrangementTokens.Grouping.GETTERS_AND_SETTERS) || propertyName == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        String className = null;
        if (containingClass != null) {
            className = containingClass.getQualifiedName();
        }
        if (className == null) {
            className = NULL_CONTENT;
        }
        if (getter) {
            this.myInfo.registerGetter(propertyName, className, entry);
        } else {
            this.myInfo.registerSetter(propertyName, className, entry);
        }
    }

    @Override
    public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
        if (enumConstant == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(28);
        }
    }

    private void processEntry(@Nullable JavaElementArrangementEntry entry, @Nullable PsiModifierListOwner modifier, @Nullable PsiElement nextPsiRoot) {
        if (entry == null) {
            return;
        }
        if (modifier != null) {
            JavaArrangementVisitor.parseModifierListOwner(modifier, entry);
        }
        if (nextPsiRoot == null) {
            return;
        }
        this.processChildrenWithinEntryScope(entry, () -> nextPsiRoot.acceptChildren((PsiElementVisitor)this));
    }

    private void processChildrenWithinEntryScope(@NotNull JavaElementArrangementEntry entry, @NotNull Runnable childrenProcessing) {
        if (entry == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(29);
        }
        if (childrenProcessing == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(30);
        }
        this.myStack.push((Object)entry);
        try {
            childrenProcessing.run();
        }
        finally {
            this.myStack.pop();
        }
    }

    private void registerEntry(@NotNull JavaElementArrangementEntry entry) {
        DefaultArrangementEntry current;
        if (entry == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(31);
        }
        if ((current = this.getCurrent()) == null) {
            this.myInfo.addEntry(entry);
        } else {
            current.addChild((ArrangementEntry)entry);
        }
    }

    @Nullable
    private JavaElementArrangementEntry createNewEntry(@NotNull TextRange range, @NotNull ArrangementSettingsToken type, @Nullable String name) {
        if (range == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(32);
        }
        if (type == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(33);
        }
        if (!this.isWithinBounds(range)) {
            return null;
        }
        DefaultArrangementEntry current = this.getCurrent();
        TextRange expandedRange = this.myDocument == null ? null : ArrangementUtil.expandToLineIfPossible((TextRange)range, (Document)this.myDocument);
        TextRange rangeToUse = expandedRange == null ? range : expandedRange;
        JavaElementArrangementEntry entry = new JavaElementArrangementEntry((ArrangementEntry)current, rangeToUse, type, name, true);
        this.registerEntry(entry);
        return entry;
    }

    private boolean isWithinBounds(@NotNull TextRange range) {
        if (range == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(34);
        }
        for (TextRange textRange : this.myRanges) {
            if (!textRange.intersects(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private DefaultArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (DefaultArrangementEntry)this.myStack.peek();
    }

    private static void parseModifierListOwner(@NotNull PsiModifierListOwner modifierListOwner, @NotNull JavaElementArrangementEntry entry) {
        PsiModifierList modifierList;
        if (modifierListOwner == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(35);
        }
        if (entry == null) {
            JavaArrangementVisitor.$$$reportNull$$$0(36);
        }
        if (JavaFormatterAnnotationUtil.isFieldWithAnnotations(modifierListOwner)) {
            entry.setHasAnnotation();
        }
        if ((modifierList = modifierListOwner.getModifierList()) == null) {
            return;
        }
        for (String modifier : PsiModifier.MODIFIERS) {
            ArrangementSettingsToken arrangementModifier;
            if (!modifierList.hasModifierProperty(modifier) || (arrangementModifier = MODIFIERS.get(modifier)) == null) continue;
            entry.addModifier(arrangementModifier);
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            entry.addModifier(StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
        }
    }

    static {
        MODIFIERS.put("public", StdArrangementTokens.Modifier.PUBLIC);
        MODIFIERS.put("protected", StdArrangementTokens.Modifier.PROTECTED);
        MODIFIERS.put("private", StdArrangementTokens.Modifier.PRIVATE);
        MODIFIERS.put("packageLocal", StdArrangementTokens.Modifier.PACKAGE_PRIVATE);
        MODIFIERS.put("static", StdArrangementTokens.Modifier.STATIC);
        MODIFIERS.put("final", StdArrangementTokens.Modifier.FINAL);
        MODIFIERS.put("transient", StdArrangementTokens.Modifier.TRANSIENT);
        MODIFIERS.put("volatile", StdArrangementTokens.Modifier.VOLATILE);
        MODIFIERS.put("synchronized", StdArrangementTokens.Modifier.SYNCHRONIZED);
        MODIFIERS.put("abstract", StdArrangementTokens.Modifier.ABSTRACT);
        ANON_CLASS_PARAMETER_LIST = new ArrangementSettingsToken("Dummy", "not matchable anon class argument list");
        ANONYMOUS_CLASS_BODY = new ArrangementSettingsToken("Dummy", "not matchable anonymous class body");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 14, 15, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: 
            case 18: 
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 29: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenProcessing";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupingRules";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedFields";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGroupingRules";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAndProcessAnonymousClassBodyEntry";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitAnonymousClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFieldWithSiblings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNextAfterWsOrComment";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasSameStaticModifier";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandToCommentIfPossible";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreak";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitClassInitializer";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getElementRangeWithoutComments";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getComments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitMethod";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerSectionComments";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumConstant";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processChildrenWithinEntryScope";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "registerEntry";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createNewEntry";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBounds";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "parseModifierListOwner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 14, 15, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static class MethodBodyProcessor
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final JavaArrangementParseInfo myInfo;
        @Nullable
        private PsiMethod myBaseMethod;

        MethodBodyProcessor(@NotNull JavaArrangementParseInfo info) {
            if (info == null) {
                MethodBodyProcessor.$$$reportNull$$$0(0);
            }
            this.myInfo = info;
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression psiMethodCallExpression) {
            PsiReference reference;
            if (psiMethodCallExpression == null) {
                MethodBodyProcessor.$$$reportNull$$$0(1);
            }
            if ((reference = psiMethodCallExpression.getMethodExpression().getReference()) == null) {
                return;
            }
            PsiElement e = reference.resolve();
            if (e instanceof PsiMethod) {
                PsiMethod m = (PsiMethod)e;
                assert (this.myBaseMethod != null);
                if (m.getContainingClass() == this.myBaseMethod.getContainingClass()) {
                    this.myInfo.registerMethodCallDependency(this.myBaseMethod, m);
                }
            }
            super.visitMethodCallExpression(psiMethodCallExpression);
        }

        @Override
        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            PsiMethod method;
            if (expression == null) {
                MethodBodyProcessor.$$$reportNull$$$0(2);
            }
            if ((method = (PsiMethod)ObjectUtils.tryCast((Object)expression.resolve(), PsiMethod.class)) == null) {
                return;
            }
            assert (this.myBaseMethod != null);
            if (method.getContainingClass() == this.myBaseMethod.getContainingClass()) {
                this.myInfo.registerMethodCallDependency(this.myBaseMethod, method);
            }
        }

        boolean setBaseMethod(@Nullable PsiMethod baseMethod) {
            if (baseMethod == null || this.myBaseMethod == null) {
                this.myBaseMethod = baseMethod;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/JavaArrangementVisitor$MethodBodyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

