/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GdslFileType;
import org.jetbrains.plugins.groovy.dsl.DslActivationStatus;
import org.jetbrains.plugins.groovy.dsl.DslErrorReporter;
import org.jetbrains.plugins.groovy.dsl.GdslScriptBase;
import org.jetbrains.plugins.groovy.dsl.GdslScriptProvider;
import org.jetbrains.plugins.groovy.dsl.GdslUtil;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslExecutor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslScript;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.holders.OriginAwareMembersHolder;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class GroovyDslFileIndex {
    private static final Key<Pair<GroovyDslExecutor, Long>> CACHED_EXECUTOR = Key.create((String)"CachedGdslExecutor");
    private static final Key<CachedValue<List<GroovyDslScript>>> SCRIPTS_CACHE = Key.create((String)"GdslScriptCache");
    private static final Logger LOG = Logger.getInstance(GroovyDslFileIndex.class);
    private static final MultiMap<String, LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>>> filesInProcessing = MultiMap.createConcurrent();
    private static final ExecutorService ourPool = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GroovyDSLIndex Pool", (int)4);
    private static final ClearableLazyValue<List<VirtualFile>> bundledGdslFiles = ClearableLazyValue.create(() -> {
        ArrayList result2 = new ArrayList();
        for (File file : GroovyDslFileIndex.getBundledScriptFolders()) {
            File[] children;
            if (!file.exists() || (children = file.listFiles()) == null) continue;
            for (File child : children) {
                String fileName = child.getName();
                if (!fileName.endsWith(".gdsl")) continue;
                String path = FileUtil.toSystemIndependentName((String)child.getPath());
                String url = VirtualFileManager.constructUrl((String)"file", (String)path);
                ContainerUtil.addIfNotNull(result2, (Object)VirtualFileManager.getInstance().refreshAndFindFileByUrl(url));
            }
        }
        return result2;
    });

    private GroovyDslFileIndex() {
    }

    @Nullable
    @NlsSafe
    public static String getError(VirtualFile file) {
        DslActivationStatus.Entry info = DslActivationStatus.getInstance().getGdslFileInfo(file);
        return info == null ? null : info.error;
    }

    public static boolean isActivated(@NotNull VirtualFile file) {
        if (file == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(0);
        }
        return GroovyDslFileIndex.getStatus(file) == DslActivationStatus.Status.ACTIVE;
    }

    public static void activate(VirtualFile vfile) {
        GroovyDslFileIndex.setStatusAndError(vfile, DslActivationStatus.Status.ACTIVE, null);
        GroovyDslFileIndex.clearScriptCache();
    }

    public static DslActivationStatus.Status getStatus(@NotNull VirtualFile file) {
        DslActivationStatus.Entry info;
        if (file == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(1);
        }
        return (info = DslActivationStatus.getInstance().getGdslFileInfo(file)) == null ? DslActivationStatus.Status.ACTIVE : info.status;
    }

    private static void clearScriptCache() {
        Application app = ApplicationManager.getApplication();
        app.invokeLater(() -> {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                project.putUserData(SCRIPTS_CACHE, null);
                PsiManagerEx.getInstanceEx((Project)project).dropPsiCaches();
            }
        }, app.getDisposed());
    }

    public static void disableFile(@NotNull VirtualFile vfile, @NotNull DslActivationStatus.Status status, @NlsSafe @Nullable String error) {
        if (vfile == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(2);
        }
        if (status == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(3);
        }
        assert (status != DslActivationStatus.Status.ACTIVE);
        GroovyDslFileIndex.setStatusAndError(vfile, status, error);
        vfile.putUserData(CACHED_EXECUTOR, null);
        GroovyDslFileIndex.clearScriptCache();
    }

    private static void setStatusAndError(@NotNull VirtualFile vfile, @NotNull DslActivationStatus.Status status, @NlsSafe @Nullable String error) {
        if (vfile == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(4);
        }
        if (status == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(5);
        }
        DslActivationStatus.Entry entry = DslActivationStatus.getInstance().getGdslFileInfoOrCreate(vfile);
        entry.status = status;
        entry.error = error;
    }

    @Nullable
    private static GroovyDslExecutor getCachedExecutor(@NotNull VirtualFile file, long stamp) {
        Pair pair;
        if (file == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(6);
        }
        if ((pair = (Pair)file.getUserData(CACHED_EXECUTOR)) == null || (Long)pair.second != stamp) {
            return null;
        }
        return (GroovyDslExecutor)pair.first;
    }

    @Nullable
    public static PsiClassType processScriptSuperClasses(@NotNull GroovyFile scriptFile) {
        if (scriptFile == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(7);
        }
        if (!scriptFile.isScript()) {
            return null;
        }
        VirtualFile virtualFile = scriptFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String filePath = virtualFile.getPath();
        ArrayList<Trinity> supers = new ArrayList<Trinity>();
        Project project = scriptFile.getProject();
        for (GroovyDslScript script : GroovyDslFileIndex.getDslScripts(project)) {
            MultiMap staticInfo = script.getStaticInfo();
            Collection infos = staticInfo.get((Object)"scriptSuperClass");
            for (Object info : infos) {
                if (!(info instanceof Map)) continue;
                @NonNls Map map2 = (Map)info;
                Object _pattern = map2.get("pattern");
                Object _superClass = map2.get("superClass");
                if (!(_pattern instanceof String)) continue;
                String pattern = (String)_pattern;
                if (!(_superClass instanceof String)) continue;
                String superClass = (String)_superClass;
                try {
                    if (!Pattern.matches(".*" + pattern, filePath)) continue;
                    supers.add(Trinity.create((Object)superClass, (Object)pattern, (Object)script));
                }
                catch (RuntimeException e) {
                    script.handleDslError(e);
                }
            }
        }
        if (!supers.isEmpty()) {
            GroovyDslScript script;
            String className = (String)((Trinity)supers.get((int)0)).first;
            script = (GroovyDslScript)((Trinity)supers.get((int)0)).third;
            try {
                return TypesUtil.createTypeByFQClassName(className, scriptFile);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                script.handleDslError(e);
                return null;
            }
        }
        return null;
    }

    public static boolean processExecutors(@NotNull PsiClassType psiType, @NotNull PsiElement place, @NotNull PairProcessor<? super CustomMembersHolder, ? super GroovyClassDescriptor> processor) {
        if (psiType == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(8);
        }
        if (place == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(10);
        }
        if (GroovyDslFileIndex.insideAnnotation(place)) {
            return true;
        }
        PsiFile placeFile = place.getContainingFile().getOriginalFile();
        PsiClass psiClass = psiType.resolve();
        if (psiClass == null) {
            return true;
        }
        for (GroovyDslScript script : GroovyDslFileIndex.getDslScripts(placeFile.getProject())) {
            GroovyClassDescriptor descriptor = new GroovyClassDescriptor((PsiType)psiType, psiClass, place, placeFile);
            CustomMembersHolder holder = script.processExecutor(descriptor);
            VirtualFile origin = script.getFile();
            if (origin != null) {
                holder = new OriginAwareMembersHolder(origin, holder);
            }
            if (processor.process((Object)holder, (Object)descriptor)) continue;
            return false;
        }
        return true;
    }

    private static boolean insideAnnotation(@Nullable PsiElement place) {
        while (place != null) {
            if (place instanceof PsiAnnotation) {
                return true;
            }
            if (place instanceof GrClosableBlock || place instanceof GrTypeDefinition || place instanceof PsiFile) {
                return false;
            }
            place = place.getParent();
        }
        return false;
    }

    private static List<VirtualFile> getGdslFiles(Project project) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>((Collection)bundledGdslFiles.getValue());
        if (TrustedProjects.isProjectTrusted((Project)project)) {
            result2.addAll(GroovyDslFileIndex.getProjectGdslFiles(project));
        }
        return result2;
    }

    static List<VirtualFile> getProjectGdslFiles(Project project) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        for (VirtualFile vfile : FileTypeIndex.getFiles((FileType)GdslFileType.INSTANCE, (GlobalSearchScope)scope)) {
            if (FileTypeRegistry.getInstance().getFileTypeByFileName(vfile.getNameSequence()) != GdslFileType.INSTANCE || !vfile.isValid() || fileIndex.isInLibrarySource(vfile) || !fileIndex.isInLibraryClasses(vfile) && (!fileIndex.isInSourceContent(vfile) || !GroovyDslFileIndex.isActivated(vfile))) continue;
            result2.add(vfile);
        }
        return result2;
    }

    @NotNull
    private static Set<File> getBundledScriptFolders() {
        Object[] extensions = (GdslScriptProvider[])GdslScriptProvider.EP_NAME.getExtensions();
        HashSet<Class<GdslScriptProvider>> classes = new HashSet<Class<GdslScriptProvider>>(ContainerUtil.map((Object[])extensions, Object::getClass));
        classes.add(GdslScriptProvider.class);
        LinkedHashSet<File> scriptFolders = new LinkedHashSet<File>();
        for (Class clazz : classes) {
            File jarPath = new File(PathUtil.getJarPathForClass((Class)clazz));
            if (jarPath.isFile()) {
                String relevantJarsRoot = PathManager.getArchivedCompliedClassesLocation();
                if (relevantJarsRoot != null && jarPath.toPath().startsWith(relevantJarsRoot)) {
                    jarPath = switch (jarPath.getParentFile().getName()) {
                        case "intellij.groovy.psi" -> new File(PathManager.getCommunityHomePath(), "plugins/groovy/groovy-psi/resources/");
                        case "intellij.groovy.grails" -> new File(PathManager.getHomePath(), "plugins/groovy/mvc/");
                        default -> jarPath.getParentFile();
                    };
                } else {
                    jarPath = jarPath.getParentFile();
                }
            }
            scriptFolders.add(new File(jarPath, "standardDsls"));
        }
        LinkedHashSet<File> linkedHashSet = scriptFolders;
        if (linkedHashSet == null) {
            GroovyDslFileIndex.$$$reportNull$$$0(11);
        }
        return linkedHashSet;
    }

    private static List<GroovyDslScript> getDslScripts(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, SCRIPTS_CACHE, () -> {
            if (GdslUtil.ourGdslStopped) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
            GdslScriptBase.getIdeaVersion();
            DslActivationStatus.getInstance();
            int count = 0;
            ArrayList<GroovyDslScript> result2 = new ArrayList<GroovyDslScript>();
            LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>> queue = new LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>>();
            for (VirtualFile vfile : GroovyDslFileIndex.getGdslFiles(project)) {
                long stamp;
                GroovyDslExecutor cached = GroovyDslFileIndex.getCachedExecutor(vfile, stamp = vfile.getModificationStamp());
                if (cached == null) {
                    GroovyDslFileIndex.scheduleParsing(queue, project, vfile, stamp, LoadTextUtil.loadText((VirtualFile)vfile).toString());
                    ++count;
                    continue;
                }
                result2.add(new GroovyDslScript(project, vfile, cached, vfile.getPath()));
            }
            try {
                while (count > 0 && !GdslUtil.ourGdslStopped) {
                    ProgressManager.checkCanceled();
                    Pair pair = (Pair)queue.poll(20L, TimeUnit.MILLISECONDS);
                    if (pair == null) continue;
                    --count;
                    if (pair.second == null) continue;
                    result2.add(new GroovyDslScript(project, (VirtualFile)pair.first, (GroovyDslExecutor)pair.second, ((VirtualFile)pair.first).getPath()));
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleParsing(LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>> queue, Project project, VirtualFile vfile, long stamp, String text) {
        String fileUrl = vfile.getUrl();
        Runnable parseScript = () -> {
            GroovyDslExecutor executor = GroovyDslFileIndex.getCachedExecutor(vfile, stamp);
            try {
                if (executor == null && GroovyDslFileIndex.isActivated(vfile)) {
                    executor = GroovyDslFileIndex.createExecutor(text, vfile, project);
                    vfile.putUserData(CACHED_EXECUTOR, (Object)Pair.create((Object)executor, (Object)stamp));
                    if (executor != null) {
                        GroovyDslFileIndex.setStatusAndError(vfile, DslActivationStatus.Status.ACTIVE, null);
                    }
                }
            }
            finally {
                MultiMap<String, LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>>> multiMap = filesInProcessing;
                synchronized (multiMap) {
                    for (LinkedBlockingQueue queue1 : filesInProcessing.remove((Object)fileUrl)) {
                        queue1.offer(Pair.create((Object)vfile, (Object)executor));
                    }
                }
            }
        };
        MultiMap<String, LinkedBlockingQueue<Pair<VirtualFile, GroovyDslExecutor>>> multiMap = filesInProcessing;
        synchronized (multiMap) {
            boolean isNewRequest = !filesInProcessing.containsKey((Object)fileUrl);
            filesInProcessing.putValue((Object)fileUrl, queue);
            if (isNewRequest) {
                ourPool.execute(parseScript);
            }
        }
    }

    @Nullable
    private static GroovyDslExecutor createExecutor(String text, VirtualFile vfile, Project project) {
        if (GdslUtil.ourGdslStopped) {
            return null;
        }
        try {
            return GroovyDslExecutor.createAndRunExecutor(text, vfile.getName());
        }
        catch (Throwable e) {
            if (project.isDisposed()) {
                LOG.error(e);
                return null;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(e);
                return null;
            }
            DslErrorReporter.getInstance().invokeDslErrorPopup(e, project, vfile);
            if (e instanceof OutOfMemoryError) {
                GdslUtil.stopGdsl();
                throw (Error)e;
            }
            if (e instanceof NoClassDefFoundError) {
                GdslUtil.stopGdsl();
                throw (NoClassDefFoundError)e;
            }
            return null;
        }
    }

    static {
        GdslScriptProvider.EP_NAME.addChangeListener(() -> bundledGdslFiles.drop(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledScriptFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActivated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "disableFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setStatusAndError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedExecutor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processScriptSuperClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processExecutors";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }

    public static class MyFileListener
    implements BulkFileListener {
        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyFileListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                VirtualFile file;
                if (!(vFileEvent instanceof VFileContentChangeEvent) || vFileEvent.isFromRefresh() || !GdslUtil.GDSL_FILTER.value((Object)(file = vFileEvent.getFile())) || GroovyDslFileIndex.getStatus(file) != DslActivationStatus.Status.ACTIVE) continue;
                GroovyDslFileIndex.disableFile(file, DslActivationStatus.Status.MODIFIED, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$MyFileListener", "after"));
        }
    }
}

