/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.SkipOverwriteChoice;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ui.JBUI;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b!\u0018\u0000 22\u00020\u0001:\u00012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0005H$J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H$J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002J\f\u0010\"\u001a\u00020\u0018*\u00020#H\u0014J\f\u0010$\u001a\u00020\u0018*\u00020#H\u0014J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u0004\u0018\u00010)*\u00020*2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0018\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "suggestedFilePath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSuggestedFilePath", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fileNameField", "Lcom/intellij/ui/EditorTextField;", "targetDirectoryField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "doOKAction", "", "doAction", "selectedFileUrl", "getFileNameIfExist", "dir", "fileNameWithoutExtension", "createDirIfNotExist", "dirPath", "createTargetDirField", "createFileNameField", "createFileTypeField", "Lcom/intellij/ui/dsl/builder/Panel;", "createSettingsComponents", "selectNameWithoutExtension", "dotIdx", "", "validateFileName", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "field", "getPsiTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "pathname", "writeFile", "fileUrl", "targetDirPath", "Companion", "intellij.markdown"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nMarkdownFileActionsBaseDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFileActionsBaseDialog.kt\norg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n11#2,2:206\n1#3:208\n*S KotlinDebug\n*F\n+ 1 MarkdownFileActionsBaseDialog.kt\norg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog\n*L\n113#1:206,2\n*E\n"})
public abstract class MarkdownFileActionsBaseDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String suggestedFilePath;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final EditorTextField fileNameField;
    @NotNull
    private final TextFieldWithHistoryWithBrowseButton targetDirectoryField;
    public static final int MAX_PATH_LENGTH = 70;
    @NotNull
    private static final String RECENT_KEYS = "ImportExportFile.TargetDir.RECENT_KEYS";

    public MarkdownFileActionsBaseDialog(@NotNull Project project, @NotNull String suggestedFilePath, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath, (String)"suggestedFilePath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(project, true);
        this.project = project;
        this.suggestedFilePath = suggestedFilePath;
        this.file = file;
        this.fileNameField = new EditorTextField();
        this.targetDirectoryField = new TextFieldWithHistoryWithBrowseButton();
        super.init();
        this.createFileNameField();
        this.createTargetDirField();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getSuggestedFilePath() {
        return this.suggestedFilePath;
    }

    @NotNull
    protected final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCenterPanel_u24lambda_u245 = dialogPanel = BuilderKt.panel(arg_0 -> MarkdownFileActionsBaseDialog.createCenterPanel$lambda$4(this, arg_0));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u245.setBorder((Border)JBUI.Borders.emptyLeft((int)3));
        return (JComponent)dialogPanel;
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.fileNameField;
    }

    protected void doOKAction() {
        Path path;
        String string = this.fileNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String fileName = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String targetDirPath = ((TextFieldWithHistory)this.targetDirectoryField.getChildComponent()).getText();
        String[] stringArray = new String[]{targetDirPath, fileName};
        String string2 = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
        String fileUrl = string2;
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(this.file);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiDirectory srcDirectory = psiFile.getContainingDirectory();
        Intrinsics.checkNotNull((Object)targetDirPath);
        String existedFileName = this.getFileNameIfExist(targetDirPath, fileName);
        if (existedFileName != null) {
            PsiDirectory psiDirectory = this.getPsiTargetDirectory(targetDirPath);
            if (psiDirectory == null) {
                return;
            }
            PsiDirectory psiTargetDir = psiDirectory;
            SkipOverwriteChoice skipOverwriteChoice = SkipOverwriteChoice.askUser((PsiDirectory)psiTargetDir, (String)fileName, (String)this.getTitle(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)skipOverwriteChoice, (String)"askUser(...)");
            SkipOverwriteChoice userChoice = skipOverwriteChoice;
            if (userChoice == SkipOverwriteChoice.OVERWRITE) {
                String[] stringArray2 = new String[]{targetDirPath, existedFileName};
                String string3 = FileUtil.join((String[])stringArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
                String pathname = string3;
                Path existedFilePath = new File(pathname).toPath();
                VirtualFile virtualFile = VfsUtil.findFile((Path)existedFilePath, (boolean)true);
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile virtualFile2 = virtualFile;
                ApplicationManager.getApplication().runWriteAction(() -> MarkdownFileActionsBaseDialog.doOKAction$lambda$6(this, virtualFile2));
                this.writeFile(fileUrl, targetDirPath);
            }
        } else {
            this.writeFile(fileUrl, targetDirPath);
        }
        if ((path = srcDirectory.getVirtualFile().getFileSystem().getNioPath(srcDirectory.getVirtualFile())) != null) {
            FileChooserUtil.setLastOpenedFile((Project)this.project, (Path)path);
        }
        RecentsManager.getInstance((Project)this.project).registerRecentEntry(RECENT_KEYS, targetDirPath);
        super.doOKAction();
    }

    protected abstract void doAction(@NotNull String var1);

    @Nullable
    protected abstract String getFileNameIfExist(@NotNull String var1, @NotNull String var2);

    /*
     * WARNING - void declaration
     */
    private final void createDirIfNotExist(String dirPath) {
        void name$iv;
        void project$iv;
        Ref.ObjectRef targetDirectory = new Ref.ObjectRef();
        Project project = this.project;
        String string = MarkdownBundle.message("markdown.import.export.dialog.create.directory", new Object[0]);
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(dirPath, targetDirectory, this){
            final /* synthetic */ String $dirPath$inlined;
            final /* synthetic */ Ref.ObjectRef $targetDirectory$inlined;
            final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
            {
                this.$dirPath$inlined = string;
                this.$targetDirectory$inlined = objectRef;
                this.this$0 = markdownFileActionsBaseDialog;
            }

            public final void run() {
                boolean bl = false;
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$dirPath$inlined, (Ref.ObjectRef<PsiDirectory>)this.$targetDirectory$inlined, this.this$0){
                    final /* synthetic */ String $dirPath;
                    final /* synthetic */ Ref.ObjectRef<PsiDirectory> $targetDirectory;
                    final /* synthetic */ MarkdownFileActionsBaseDialog this$0;
                    {
                        this.$dirPath = $dirPath;
                        this.$targetDirectory = $targetDirectory;
                        this.this$0 = $receiver;
                    }

                    public final void invoke() {
                        try {
                            String string = FileUtil.toSystemIndependentName((String)this.$dirPath);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
                            String path = string;
                            this.$targetDirectory.element = DirectoryUtil.mkdirs((PsiManager)PsiManager.getInstance((Project)this.this$0.getProject()), (String)path);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            // empty catch block
                        }
                    }
                }));
            }
        }, (String)name$iv, groupId$iv);
        if (targetDirectory.element == null) {
            Messages.showErrorDialog((Project)this.project, (String)RefactoringBundle.message((String)"cannot.create.directory"), (String)RefactoringBundle.message((String)"error.title"));
        }
    }

    private final void createTargetDirField() {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        TextFieldWithHistoryWithBrowseButton $this$createTargetDirField_u24lambda_u248 = textFieldWithHistoryWithBrowseButton = this.targetDirectoryField;
        boolean bl = false;
        $this$createTargetDirField_u24lambda_u248.setTextFieldPreferredWidth(70);
        List resDirRecent = RecentsManager.getInstance((Project)this.project).getRecentEntries(RECENT_KEYS);
        if (resDirRecent != null) {
            ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u248.getChildComponent()).setHistory(resDirRecent);
        }
        String string = this.file.getParent().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String suggestedDir = string;
        if (resDirRecent == null && ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u248.getChildComponent()).getHistory().isEmpty()) {
            ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u248.getChildComponent()).setHistory(CollectionsKt.listOf((Object)suggestedDir));
        }
        ((TextFieldWithHistory)$this$createTargetDirField_u24lambda_u248.getChildComponent()).setText(suggestedDir);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(MarkdownBundle.message("markdown.import.export.dialog.target.directory", new Object[0])).withDescription(MarkdownBundle.message("markdown.import.export.dialog.target.directory.description", new Object[0]));
        $this$createTargetDirField_u24lambda_u248.addBrowseFolderListener(this.project, descriptor, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    private final void createFileNameField() {
        File file = new File(this.suggestedFilePath);
        this.fileNameField.setText(FilesKt.getNameWithoutExtension((File)file));
        int endOfNameIdx = FilesKt.getNameWithoutExtension((File)file).length();
        if (endOfNameIdx > 0) {
            this.selectNameWithoutExtension(endOfNameIdx);
        }
    }

    protected void createFileTypeField(@NotNull Panel $this$createFileTypeField) {
        Intrinsics.checkNotNullParameter((Object)$this$createFileTypeField, (String)"<this>");
    }

    protected void createSettingsComponents(@NotNull Panel $this$createSettingsComponents) {
        Intrinsics.checkNotNullParameter((Object)$this$createSettingsComponents, (String)"<this>");
    }

    private final void selectNameWithoutExtension(int dotIdx) {
        ApplicationManager.getApplication().invokeLater(() -> MarkdownFileActionsBaseDialog.selectNameWithoutExtension$lambda$9(this, dotIdx));
    }

    private final ValidationInfo validateFileName(ValidationInfoBuilder $this$validateFileName, EditorTextField field) {
        ValidationInfo validationInfo;
        String string = field.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String fileName = string;
        if (field.isNull() || ((CharSequence)fileName).length() == 0) {
            String string2 = RefactoringBundle.message((String)"no.new.name.specified");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            validationInfo = $this$validateFileName.error(string2);
        } else if (!PathUtilRt.isValidFileName((String)fileName, (boolean)false)) {
            String string3 = RefactoringBundle.message((String)"name.is.not.a.valid.file.name");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            validationInfo = $this$validateFileName.error(string3);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private final PsiDirectory getPsiTargetDirectory(String pathname) {
        PsiDirectory psiDirectory;
        VirtualFile vfDirectory;
        Path dirPath = new File(pathname).toPath();
        VirtualFile virtualFile = vfDirectory = VfsUtil.findFile((Path)dirPath, (boolean)true);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiDirectory = PsiManager.getInstance((Project)this.project).findDirectory(it);
        } else {
            psiDirectory = null;
        }
        return psiDirectory;
    }

    private final void writeFile(String fileUrl, String targetDirPath) {
        this.createDirIfNotExist(targetDirPath);
        this.doAction(fileUrl);
    }

    private static final ValidationInfo createCenterPanel$lambda$4$lambda$1$lambda$0(MarkdownFileActionsBaseDialog this$0, ValidationInfoBuilder $this$validationOnApply, EditorTextField it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.validateFileName($this$validationOnApply, it);
    }

    private static final Unit createCenterPanel$lambda$4$lambda$1(MarkdownFileActionsBaseDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.fileNameField).align((Align)AlignX.FILL.INSTANCE).validationOnApply((arg_0, arg_1) -> MarkdownFileActionsBaseDialog.createCenterPanel$lambda$4$lambda$1$lambda$0(this$0, arg_0, arg_1)).focused();
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$4$lambda$3$lambda$2(ValidationInfoBuilder $this$validationOnApply, TextFieldWithHistoryWithBrowseButton it) {
        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MarkdownImportExportUtils.INSTANCE.validateTargetDir($this$validationOnApply, it);
    }

    private static final Unit createCenterPanel$lambda$4$lambda$3(MarkdownFileActionsBaseDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.targetDirectoryField).align((Align)AlignX.FILL.INSTANCE).validationOnApply(MarkdownFileActionsBaseDialog::createCenterPanel$lambda$4$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$4(MarkdownFileActionsBaseDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = MarkdownBundle.message("markdown.import.export.dialog.new.name.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> MarkdownFileActionsBaseDialog.createCenterPanel$lambda$4$lambda$1(this$0, arg_0));
        this$0.createFileTypeField($this$panel);
        String string2 = MarkdownBundle.message("markdown.import.export.dialog.target.directory.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> MarkdownFileActionsBaseDialog.createCenterPanel$lambda$4$lambda$3(this$0, arg_0));
        this$0.createSettingsComponents($this$panel);
        return Unit.INSTANCE;
    }

    private static final void doOKAction$lambda$6(MarkdownFileActionsBaseDialog this$0, VirtualFile $virtualFile) {
        PsiFile psiFile = PsiManager.getInstance((Project)this$0.project).findFile($virtualFile);
        Intrinsics.checkNotNull((Object)psiFile);
        psiFile.delete();
    }

    private static final void selectNameWithoutExtension$lambda$9(MarkdownFileActionsBaseDialog this$0, int $dotIdx) {
        Editor editor2 = this$0.fileNameField.getEditor();
        if (editor2 != null) {
            editor2.getSelectionModel().setSelection(0, $dotIdx);
            editor2.getCaretModel().moveToOffset($dotIdx);
        } else {
            this$0.fileNameField.selectAll();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog$Companion;", "", "<init>", "()V", "MAX_PATH_LENGTH", "", "RECENT_KEYS", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

