/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.openapi.GitRepositoryInitializer;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.ignore.GitIgnoreInStoreDirGenerator;
import git4idea.util.GitFileUtils;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class GitRepositoryInitializerImpl
implements GitRepositoryInitializer {
    GitRepositoryInitializerImpl() {
    }

    public void initRepository(@NotNull Project project, @NotNull VirtualFile root, boolean addFilesToVcs) {
        if (project == null) {
            GitRepositoryInitializerImpl.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitRepositoryInitializerImpl.$$$reportNull$$$0(1);
        }
        ProgressManager.progress2((String)GitBundle.message((String)"progress.title.creating.git.repository", (Object[])new Object[0]));
        GitCommandResult result2 = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
        if (!result2.success()) {
            VcsNotifier.getInstance((Project)project).notifyError("git.init.failed", GitBundle.message((String)"action.Git.Init.error", (Object[])new Object[0]), result2.getErrorOutputAsHtmlString(), true);
            return;
        }
        GitInit.configureVcsMappings(project, root);
        GitUtil.generateGitignoreFileIfNeeded(project, root);
        ((GitIgnoreInStoreDirGenerator)project.getService(GitIgnoreInStoreDirGenerator.class)).generateGitignoreInStoreDirIfNeededSync();
        if (addFilesToVcs) {
            StoreUtil.saveSettings((ComponentManager)project, (boolean)true);
            try {
                GitFileUtils.addFiles(project, root, Collections.singletonList(root));
                VcsDirtyScopeManager.getInstance((Project)project).rootDirty(root);
            }
            catch (VcsException e) {
                VcsNotifier.getInstance((Project)project).notifyError("git.init.stage.failed", GitBundle.message((String)"action.Git.Init.Stage.error", (Object[])new Object[0]), result2.getErrorOutputAsHtmlString(), true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
        }
        objectArray[1] = "git4idea/repo/GitRepositoryInitializerImpl";
        objectArray[2] = "initRepository";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

