/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.util.containers.Stack;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.utils.GraphUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.history.CommitFileState;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryRefinerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ<\u0010\u0015\u001a(\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u0017\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0006j\u0002`\u00130\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0014J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J(\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0002J&\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u00062\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140(H\u0002JB\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00160*2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryRefiner;", "", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "historyData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "<init>", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;Lcom/intellij/vcs/log/history/FileHistoryData;)V", "permanentCommitsInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentCommitsInfo;", "permanentLinearGraph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visibilityBuffer", "Lcom/intellij/vcs/log/graph/utils/impl/BitSetFlags;", "commitToFileStateMap", "Ljava/util/HashMap;", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "Lcom/intellij/vcs/log/history/CommitFileState;", "refine", "Lkotlin/Pair;", "", "", "row", "startFileState", "walk", "", "graph", "startNode", "getFileState", "currentNode", "previousNode", "previousFileState", "down", "", "findStateWithoutConflict", "nodeId", "stateGetter", "Lkotlin/Function1;", "getNextNodes", "", "visited", "currentPath", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryRefiner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryRefiner.kt\ncom/intellij/vcs/log/history/FileHistoryRefiner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1869#2,2:162\n827#2:165\n855#2,2:166\n1563#2:168\n1634#2,3:169\n1#3:164\n*S KotlinDebug\n*F\n+ 1 FileHistoryRefiner.kt\ncom/intellij/vcs/log/history/FileHistoryRefiner\n*L\n38#1:162,2\n137#1:165\n137#1:166,2\n137#1:168\n137#1:169,3\n*E\n"})
public final class FileHistoryRefiner {
    @NotNull
    private final LinearGraph visibleLinearGraph;
    @NotNull
    private final FileHistoryData historyData;
    @NotNull
    private final PermanentCommitsInfo<Integer> permanentCommitsInfo;
    @NotNull
    private final LiteLinearGraph permanentLinearGraph;
    @NotNull
    private final BitSetFlags visibilityBuffer;
    @NotNull
    private final HashMap<Integer, CommitFileState> commitToFileStateMap;

    public FileHistoryRefiner(@NotNull LinearGraph visibleLinearGraph, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo, @NotNull FileHistoryData historyData) {
        Intrinsics.checkNotNullParameter((Object)visibleLinearGraph, (String)"visibleLinearGraph");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        Intrinsics.checkNotNullParameter((Object)historyData, (String)"historyData");
        this.visibleLinearGraph = visibleLinearGraph;
        this.historyData = historyData;
        PermanentCommitsInfo<Integer> permanentCommitsInfo = permanentGraphInfo.getPermanentCommitsInfo();
        Intrinsics.checkNotNullExpressionValue(permanentCommitsInfo, (String)"getPermanentCommitsInfo(...)");
        this.permanentCommitsInfo = permanentCommitsInfo;
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(permanentGraphInfo.getLinearGraph());
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        this.permanentLinearGraph = liteLinearGraph;
        this.visibilityBuffer = new BitSetFlags(this.permanentLinearGraph.nodesCount());
        this.commitToFileStateMap = new HashMap();
    }

    @NotNull
    public final Pair<Map<Integer, CommitFileState>, Set<Integer>> refine(int row, @NotNull CommitFileState startFileState) {
        Intrinsics.checkNotNullParameter((Object)startFileState, (String)"startFileState");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(this.visibleLinearGraph);
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        this.walk(liteLinearGraph, row, startFileState);
        HashSet<Integer> excluded = new HashSet<Integer>();
        for (Map.Entry entry : ((Map)this.commitToFileStateMap).entrySet()) {
            CommitFileState path;
            int commit = ((Number)entry.getKey()).intValue();
            if (this.historyData.affects(commit, path = (CommitFileState)entry.getValue(), true)) continue;
            excluded.add(commit);
        }
        Iterable $this$forEach$iv = excluded;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.commitToFileStateMap.remove(it);
        }
        return new Pair(this.commitToFileStateMap, excluded);
    }

    private final void walk(LiteLinearGraph graph, int startNode, CommitFileState startFileState) {
        Pair pair;
        if (startNode < 0 || startNode >= graph.nodesCount()) {
            return;
        }
        BitSetFlags visited = new BitSetFlags(graph.nodesCount(), false);
        Pair $this$walk_u24lambda_u241 = pair = new LinkedList();
        boolean bl = false;
        $this$walk_u24lambda_u241.add(new Pair((Object)startNode, (Object)startFileState));
        Queue starts = (Queue)pair;
        while (!((Collection)starts).isEmpty()) {
            pair = (Pair)starts.poll();
            int nextStart = ((Number)pair.component1()).intValue();
            CommitFileState nextStartFileState = (CommitFileState)pair.component2();
            if (visited.get(nextStart)) continue;
            Pair[] pairArray = new Pair[]{new Pair((Object)nextStart, (Object)nextStartFileState)};
            Stack stack = new Stack((Object[])pairArray);
            block1: while (!stack.empty()) {
                CommitFileState nextFileState;
                int nextNode;
                pairArray = (Pair[])stack.peek();
                int currentNode = ((Number)pairArray.component1()).intValue();
                CommitFileState currentFileState = (CommitFileState)pairArray.component2();
                boolean down = FileHistoryRefinerKt.access$isDown(stack);
                if (!visited.get(currentNode)) {
                    visited.set(currentNode, true);
                    ((Map)this.commitToFileStateMap).put(this.permanentCommitsInfo.getCommitId(this.visibleLinearGraph.getNodeId(currentNode)), currentFileState);
                }
                for (Pair<Integer, CommitFileState> pair2 : this.getNextNodes(graph, visited, currentNode, currentFileState, down)) {
                    nextNode = ((Number)pair2.component1()).intValue();
                    nextFileState = (CommitFileState)pair2.component2();
                    if (!currentFileState.getDeleted() && nextFileState.getDeleted()) {
                        starts.add(new Pair((Object)nextNode, (Object)nextFileState));
                        continue;
                    }
                    stack.push((Object)new Pair((Object)nextNode, (Object)nextFileState));
                    continue block1;
                }
                for (Pair<Integer, CommitFileState> pair2 : this.getNextNodes(graph, visited, currentNode, currentFileState, !down)) {
                    nextNode = ((Number)pair2.component1()).intValue();
                    nextFileState = (CommitFileState)pair2.component2();
                    if (!currentFileState.getDeleted() && nextFileState.getDeleted()) {
                        starts.add(new Pair((Object)nextNode, (Object)nextFileState));
                        continue;
                    }
                    stack.push((Object)new Pair((Object)nextNode, (Object)nextFileState));
                    continue block1;
                }
                stack.pop();
            }
        }
    }

    private final CommitFileState getFileState(int currentNode, int previousNode, CommitFileState previousFileState, boolean down) {
        if (previousNode == -1) {
            return previousFileState;
        }
        int previousNodeId = this.visibleLinearGraph.getNodeId(previousNode);
        int currentNodeId = this.visibleLinearGraph.getNodeId(currentNode);
        if (down) {
            int previousCommit = ((Number)this.permanentCommitsInfo.getCommitId(previousNodeId)).intValue();
            Function1 stateGetter = arg_0 -> FileHistoryRefiner.getFileState$lambda$2(this, previousCommit, previousFileState, arg_0);
            CommitFileState state = this.findStateWithoutConflict(previousNodeId, (Function1<? super Integer, CommitFileState>)stateGetter);
            CommitFileState commitFileState = state;
            if (commitFileState == null) {
                commitFileState = (CommitFileState)stateGetter.invoke((Object)GraphUtilKt.getCorrespondingParent(this.permanentLinearGraph, previousNodeId, currentNodeId, this.visibilityBuffer));
            }
            return commitFileState;
        }
        int currentCommit = ((Number)this.permanentCommitsInfo.getCommitId(currentNodeId)).intValue();
        Function1 stateGetter = arg_0 -> FileHistoryRefiner.getFileState$lambda$3(this, currentCommit, previousFileState, arg_0);
        CommitFileState state = this.findStateWithoutConflict(currentNodeId, (Function1<? super Integer, CommitFileState>)stateGetter);
        CommitFileState commitFileState = state;
        if (commitFileState == null) {
            commitFileState = (CommitFileState)stateGetter.invoke((Object)GraphUtilKt.getCorrespondingParent(this.permanentLinearGraph, currentNodeId, previousNodeId, this.visibilityBuffer));
        }
        return commitFileState;
    }

    private final CommitFileState findStateWithoutConflict(int nodeId, Function1<? super Integer, CommitFileState> stateGetter) {
        Object v2;
        CommitFileState state;
        block3: {
            List<Integer> list = this.permanentLinearGraph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getNodes(...)");
            List<Integer> parents = list;
            Object object = CollectionsKt.first(parents);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            state = (CommitFileState)stateGetter.invoke(object);
            if (parents.size() == 1) {
                return state;
            }
            Iterable iterable = parents.subList(1, parents.size());
            for (Object t : iterable) {
                Integer it = (Integer)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!Intrinsics.areEqual((Object)stateGetter.invoke((Object)it), (Object)state))) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        if (v2 != null) {
            return null;
        }
        return state;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Integer, CommitFileState>> getNextNodes(LiteLinearGraph graph, BitSetFlags visited, int currentNode, CommitFileState currentPath, boolean down) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        List<Integer> list = graph.getNodes(currentNode, down ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getNodes(...)");
        List<Integer> nextNodes = list;
        Iterable $this$filterNot$iv = nextNodes;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            int p0 = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (visited.get(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            Integer p0 = (Integer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)node);
            collection.add(new Pair((Object)node, (Object)this.getFileState(node.intValue(), currentNode, currentPath, down)));
        }
        List nodesWithStates = (List)destination$iv$iv;
        return CollectionsKt.sortedWith((Iterable)nodesWithStates, (Comparator)new Comparator(currentPath){
            final /* synthetic */ CommitFileState $currentPath$inlined;
            {
                this.$currentPath$inlined = commitFileState;
            }

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                CommitFileState path = (CommitFileState)pair.component2();
                pair = (Pair)b;
                Comparable comparable = Intrinsics.areEqual((Object)path, (Object)this.$currentPath$inlined) ? (Comparable)Integer.valueOf(-1) : (path.getDeleted() ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(0));
                bl = false;
                path = (CommitFileState)pair.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(Intrinsics.areEqual((Object)path, (Object)this.$currentPath$inlined) ? (Comparable)Integer.valueOf(-1) : (path.getDeleted() ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(0))));
            }
        });
    }

    private static final CommitFileState getFileState$lambda$2(FileHistoryRefiner this$0, int $previousCommit, CommitFileState $previousFileState, int parentIndex) {
        return this$0.historyData.getFileStateInParentRevision($previousCommit, ((Number)this$0.permanentCommitsInfo.getCommitId(parentIndex)).intValue(), $previousFileState);
    }

    private static final CommitFileState getFileState$lambda$3(FileHistoryRefiner this$0, int $currentCommit, CommitFileState $previousFileState, int parentIndex) {
        return this$0.historyData.getFileStateInChildRevision($currentCommit, ((Number)this$0.permanentCommitsInfo.getCommitId(parentIndex)).intValue(), $previousFileState);
    }
}

