/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation;

import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.ReferencingNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class Abbreviation
extends Node
implements DoNotDecorate,
DoNotLinkDecorate,
ReferencingNode<AbbreviationRepository, AbbreviationBlock> {
    protected final BasedSequence abbreviation;

    public Abbreviation(BasedSequence chars, BasedSequence abbreviation) {
        super(chars);
        this.abbreviation = abbreviation;
    }

    public BasedSequence getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        this.astExtraChars(out);
    }

    @Override
    @NotNull
    protected String toStringAttributes() {
        return "text=" + this.getChars();
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    @NotNull
    public BasedSequence getReference() {
        return this.abbreviation;
    }

    @Override
    public AbbreviationBlock getReferenceNode(Document document) {
        return this.getReferenceNode(AbbreviationExtension.ABBREVIATIONS.get(document));
    }

    @Override
    public AbbreviationBlock getReferenceNode(AbbreviationRepository repository) {
        return (AbbreviationBlock)repository.get(this.getChars().toString());
    }
}

