/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.settings;

import com.intellij.kotlin.jupyter.core.projectModel.KotlinNotebookSessionLibrariesFilter;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookDependencies;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\"\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u00a8\u0006\u000f"}, d2={"findModule", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependencies;", "project", "Lcom/intellij/openapi/project/Project;", "getSuitableModules", "", "getSuitableLibraries", "", "Lcom/intellij/openapi/roots/libraries/Library;", "isAffectedBy", "", "changedLibrary", "changedModules", "", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookDependenciesProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookDependenciesProperty.kt\ncom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependenciesPropertyKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n24#2:186\n3829#3:187\n4344#3,2:188\n3829#3:191\n4344#3,2:192\n1056#4:190\n1761#4,3:194\n1761#4,3:197\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookDependenciesProperty.kt\ncom/intellij/kotlin/jupyter/core/settings/KotlinNotebookDependenciesPropertyKt\n*L\n135#1:186\n150#1:187\n150#1:188,2\n171#1:191\n171#1:192,2\n156#1:190\n182#1:194,3\n148#1:197,3\n*E\n"})
public final class KotlinNotebookDependenciesPropertyKt {
    @Nullable
    public static final Module findModule(@NotNull KotlinNotebookDependencies $this$findModule, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findModule, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!($this$findModule instanceof KotlinNotebookDependencies.SingleModule)) {
            return null;
        }
        Module module = ModuleManager.Companion.getInstance(project).findModuleByName(((KotlinNotebookDependencies.SingleModule)$this$findModule).getModuleName());
        if (module == null) {
            KotlinNotebookDependencies.SingleModule $this$findModule_u24lambda_u240 = (KotlinNotebookDependencies.SingleModule)$this$findModule;
            boolean bl = false;
            KotlinNotebookDependencies.SingleModule $this$thisLogger$iv = $this$findModule_u24lambda_u240;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(KotlinNotebookDependencies.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Could not find module by name " + $this$findModule_u24lambda_u240.getModuleName() + " in project " + project.getName());
            module = null;
        }
        return module;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<Module> getSuitableModules(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            boolean bl;
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl2 = false;
            if (KotlinNotebookDependenciesPropertyKt.getSuitableModules$isProbablyBuildSrc((Module)it)) {
                bl = false;
            } else if (ModuleRootManager.getInstance((Module)it).getSdk() == null) {
                bl = false;
            } else {
                Sdk sdk;
                boolean hasSdk = sdk.getSdkType() instanceof JavaSdkType;
                boolean hasSources = KotlinProjectStructureUtils.getProductionSourceInfo((Module)it) != null || KotlinProjectStructureUtils.getTestSourceInfo((Module)it) != null;
                bl = hasSdk && hasSources;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Module it = (Module)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Module)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Library> getSuitableLibraries(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Library[] projectLibraries;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable(project).getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
        Library[] $this$filter$iv = projectLibraries = libraryArray;
        boolean $i$f$filter = false;
        Library[] libraryArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)"Permanent Script Dependencies") && it.getName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List librariesCandidates = (List)destination$iv$iv;
        return KotlinNotebookSessionLibrariesFilter.Companion.filterSessionLibraries(project, librariesCandidates);
    }

    public static final boolean isAffectedBy(@NotNull KotlinNotebookDependencies $this$isAffectedBy, @Nullable Library changedLibrary, @NotNull Collection<? extends Module> changedModules) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)$this$isAffectedBy, (String)"<this>");
            Intrinsics.checkNotNullParameter(changedModules, (String)"changedModules");
            if (changedLibrary == null && changedModules.isEmpty()) {
                return false;
            }
            KotlinNotebookDependencies kotlinNotebookDependencies = $this$isAffectedBy;
            if (Intrinsics.areEqual((Object)kotlinNotebookDependencies, (Object)KotlinNotebookDependencies.None.INSTANCE)) {
                bl = false;
            } else if (Intrinsics.areEqual((Object)kotlinNotebookDependencies, (Object)KotlinNotebookDependencies.AllLibraries.INSTANCE)) {
                bl = changedLibrary != null;
            } else if (kotlinNotebookDependencies instanceof KotlinNotebookDependencies.SingleModule) {
                Iterable $this$any$iv = changedModules;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Module it = (Module)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)((KotlinNotebookDependencies.SingleModule)$this$isAffectedBy).getModuleName())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean getSuitableModules$isProbablyBuildSrc(Module $this$getSuitableModules_u24isProbablyBuildSrc) {
        boolean bl;
        block3: {
            String string = $this$getSuitableModules_u24isProbablyBuildSrc.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String[] stringArray = new String[]{"."};
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)"buildSrc")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

