/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.inlays.progress;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.fus.JupyterFusCellRunStatus;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\u0010\u001a\u00020\u00072\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "notifyCellExecutionFinished", "", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "status", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "sendNotification", "content", "", "notificationType", "Lcom/intellij/notification/NotificationType;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "createViewNotebookAction", "fusStatus", "Lcom/intellij/jupyter/core/fus/JupyterFusCellRunStatus;", "durationSeconds", "", "formatDuration", "diff", "Ljava/time/Duration;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterProgressStatusChangeNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterProgressStatusChangeNotificationService.kt\ncom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificationService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,116:1\n4135#2,11:117\n*S KotlinDebug\n*F\n+ 1 JupyterProgressStatusChangeNotificationService.kt\ncom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificationService\n*L\n90#1:117,11\n*E\n"})
public final class JupyterProgressStatusChangeNotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public JupyterProgressStatusChangeNotificationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @RequiresEdt
    public final void notifyCellExecutionFinished(@NotNull JupyterExecutionTask task2, @NotNull JupyterExecutionStatus status) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        NotebookIntervalPointer notebookIntervalPointer = task2.getOptions().getCellPointer();
        if (notebookIntervalPointer == null) {
            return;
        }
        NotebookIntervalPointer cellPointer = notebookIntervalPointer;
        BackedNotebookVirtualFile notebookVirtualFile2 = task2.getNotebookVirtualFile();
        this.notifyCellExecutionFinished(cellPointer, notebookVirtualFile2, status);
    }

    @RequiresEdt
    public final void notifyCellExecutionFinished(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook, @NotNull JupyterExecutionStatus status) {
        Pair pair;
        ZonedDateTime endTime;
        Duration duration;
        long durationSeconds;
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        if (JupyterConsoleUtil.INSTANCE.isJupyterConsoleView(notebook.getFile())) {
            return;
        }
        if (status == JupyterExecutionStatus.ABORTED) {
            return;
        }
        if (!JupyterSettings.Companion.getInstance().getNotifyCellExecution()) {
            return;
        }
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        JupyterCell cell = notebook.getNotebook().getCell(interval2.getOrdinal());
        ZonedDateTime zonedDateTime = cell.getExecutionStartTime();
        if (zonedDateTime == null) {
            return;
        }
        ZonedDateTime startTime = zonedDateTime;
        ZonedDateTime zonedDateTime2 = cell.getExecutionEndTime();
        if (zonedDateTime2 == null) {
            zonedDateTime2 = ZonedDateTime.now();
        }
        if ((durationSeconds = (duration = Duration.between(startTime, endTime = zonedDateTime2)).toSeconds()) < (long)JupyterSettings.Companion.getInstance().getCellNotificationTimeSec()) {
            return;
        }
        Intrinsics.checkNotNull((Object)duration);
        String durationStr = this.formatDuration(duration);
        if (WhenMappings.$EnumSwitchMapping$0[status.ordinal()] == 1) {
            var15_11 = new Object[]{durationStr};
            Pair pair2 = new Pair((Object)NotificationType.ERROR, (Object)JupyterBundle.message("notification.jupyter.cell.executed.err.title", var15_11));
            pair = pair2;
        } else {
            var15_11 = new Object[]{durationStr};
            Pair pair3 = new Pair((Object)NotificationType.INFORMATION, (Object)JupyterBundle.message("notification.jupyter.cell.executed.ok.title", var15_11));
            pair = pair3;
        }
        Pair pair4 = pair;
        NotificationType notificationType = (NotificationType)pair4.component1();
        String content = (String)pair4.component2();
        JupyterFusCellRunStatus fusStatus = switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> JupyterFusCellRunStatus.STOPPED_ERR;
            case 2 -> JupyterFusCellRunStatus.STOPPED_OK;
            default -> JupyterFusCellRunStatus.UNDEFINED;
        };
        JupyterFeaturesCollector.Companion.onCellFinishedNotificationShown(fusStatus, durationSeconds);
        AnAction action = this.createViewNotebookAction(notebook, cellPointer, fusStatus, durationSeconds);
        this.sendNotification(content, notificationType, action);
    }

    private final void sendNotification(@Nls String content, NotificationType notificationType, AnAction action) {
        Notification notification = new Notification("Jupyter", "", content, notificationType).setDisplayId("cell.execution.finished");
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        Notification notification2 = notification;
        notification2.addAction(action);
        Notifications.Bus.notify((Notification)notification2, (Project)this.project);
        SystemNotifications.getInstance().notify(NotificationGroupManager.getInstance().getNotificationGroup("Jupyter").getDisplayId(), JupyterBundle.message("notification.jupyter.cell.executed.system.notification.title", new Object[0]), content);
    }

    private final AnAction createViewNotebookAction(BackedNotebookVirtualFile notebook, NotebookIntervalPointer cellPointer, JupyterFusCellRunStatus fusStatus, long durationSeconds) {
        NotificationAction notificationAction = NotificationAction.createSimple((String)JupyterBundle.message("notification.jupyter.cell.view.notebook.action", new Object[0]), () -> JupyterProgressStatusChangeNotificationService.createViewNotebookAction$lambda$1(this, notebook, fusStatus, durationSeconds, cellPointer));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(...)");
        return (AnAction)notificationAction;
    }

    private final String formatDuration(Duration diff) {
        return diff.compareTo(Duration.ofMinutes(1L)) < 0 ? diff.toSeconds() + "s" : (diff.compareTo(Duration.ofHours(1L)) < 0 ? diff.toMinutes() + "m " + diff.toSecondsPart() + "s" : diff.toHours() + "h " + diff.toMinutesPart() + "m");
    }

    /*
     * WARNING - void declaration
     */
    private static final void createViewNotebookAction$lambda$1(JupyterProgressStatusChangeNotificationService this$0, BackedNotebookVirtualFile $notebook, JupyterFusCellRunStatus $fusStatus, long $durationSeconds, NotebookIntervalPointer $cellPointer) {
        block3: {
            TextEditor textEditor;
            void $this$filterIsInstanceTo$iv$iv;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this$0.project);
            FileEditor[] fileEditorArray = fileEditorManager.openFile($notebook.getFile(), true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            Object[] $this$filterIsInstance$iv = fileEditorArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TextEditor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            TextEditor textEditor2 = (TextEditor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            JupyterFeaturesCollector.Companion.onClickCellFinishedNotification($fusStatus, $durationSeconds);
            NotebookCellLines.Interval interval = $cellPointer.get();
            if (interval == null) break block3;
            NotebookCellLines.Interval interval2 = interval;
            boolean bl = false;
            int startLine = interval2.getLines().getFirst();
            LogicalPosition logicalPosition = new LogicalPosition(startLine, 0);
            TextEditor textEditor3 = textEditor2;
            if (textEditor3 != null && (textEditor3 = textEditor3.getEditor()) != null && (textEditor3 = textEditor3.getCaretModel()) != null) {
                textEditor3.moveToLogicalPosition(logicalPosition);
            }
            if ((textEditor = textEditor2) != null && (textEditor = textEditor.getEditor()) != null && (textEditor = textEditor.getScrollingModel()) != null) {
                textEditor.scrollToCaret(ScrollType.CENTER);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final JupyterProgressStatusChangeNotificationService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterProgressStatusChangeNotificationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterProgressStatusChangeNotificationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterProgressStatusChangeNotificationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionStatus.values().length];
            try {
                nArray[JupyterExecutionStatus.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

