/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.FocusEditorComponentCaretListener;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorState;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditorProvider;
import com.intellij.jupyter.core.jupyter.editor.SelectClickedCellEventDispatcher;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.ui.NotebookPositionKeeper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterDSFileEditorProvider;", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditorProvider;", "<init>", "()V", "createJupyterFileEditor", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getTextEditorProvider", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorProvider;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "Lcom/intellij/openapi/vfs/VirtualFile;", "writeState", "", "state", "targetElement", "customizeNotebookTextEditor", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "CustomEditorColorsScheme", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDSFileEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDSFileEditorProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterDSFileEditorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,182:1\n1#2:183\n1563#3:184\n1634#3,3:185\n1563#3:188\n1634#3,2:189\n1563#3:191\n1634#3,3:192\n1636#3:195\n1869#3,2:196\n1869#3:198\n1869#3,2:199\n1870#3:201\n40#4,3:202\n*S KotlinDebug\n*F\n+ 1 JupyterDSFileEditorProvider.kt\ncom/intellij/jupyter/core/jupyter/editor/JupyterDSFileEditorProvider\n*L\n51#1:184\n51#1:185,3\n54#1:188\n54#1:189,2\n59#1:191\n59#1:192,3\n54#1:195\n95#1:196,2\n103#1:198\n110#1:199,2\n103#1:201\n160#1:202,3\n*E\n"})
public final class JupyterDSFileEditorProvider
extends JupyterFileEditorProvider {
    @Override
    @NotNull
    public JupyterFileEditor createJupyterFileEditor(@NotNull Project project, @NotNull BackedNotebookVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TextEditor textEditor = (TextEditor)ReadAction.compute(() -> JupyterDSFileEditorProvider.createJupyterFileEditor$lambda$0(this, project, file));
        Intrinsics.checkNotNull((Object)textEditor);
        JupyterFileEditor jupyterFileEditor = JupyterFileEditor.Companion.createJupyterFileEditor(project, textEditor);
        try {
            this.customizeNotebookTextEditor(jupyterFileEditor);
        }
        catch (Throwable e) {
            Object $this$createJupyterFileEditor_u24lambda_u241;
            Object object = this;
            try {
                $this$createJupyterFileEditor_u24lambda_u241 = object;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)jupyterFileEditor));
                $this$createJupyterFileEditor_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$createJupyterFileEditor_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$createJupyterFileEditor_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable p0 = throwable;
                boolean bl = false;
                e.addSuppressed(p0);
            }
            throw e;
        }
        return jupyterFileEditor;
    }

    private final TextEditorProvider getTextEditorProvider() {
        return TextEditorProvider.Companion.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        NotebookPositionKeeper.Position position;
        Element element;
        List cellStates;
        Element element2;
        List collapsedSections;
        Iterable<Integer> iterable;
        Iterable<Integer> destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditorState textEditorState = this.getTextEditorProvider().readState(sourceElement, project, file);
        Element element3 = sourceElement.getChild("jupyter");
        if (element3 != null && (element3 = element3.getChild("collapsedSections")) != null) {
            void $this$mapTo$iv$iv;
            Element element4 = element3;
            boolean bl = false;
            List list = element4.getChildren("section");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element5 = (Element)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getAttribute("cellOrdinal").getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                iterable.add(Integer.parseInt(string));
            }
            v3 = (List)destination$iv$iv;
        } else {
            v3 = collapsedSections = CollectionsKt.emptyList();
        }
        if ((element2 = sourceElement.getChild("jupyter")) != null && (element2 = element2.getChild("cells")) != null) {
            void $this$mapTo$iv$iv;
            Element element6 = element2;
            boolean bl = false;
            List list = element6.getChildren("cell");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JupyterEditorState.OutputsState outputsState;
                void cellElement;
                iterable = (Element)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                if (cellElement.getChild("outputs") != null) {
                    Collection<JupyterEditorState.OutputState> collection2;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Element outputsElement;
                    boolean bl4 = false;
                    Object object = outputsElement.getAttribute("scrollingEnabled");
                    boolean bl5 = !(object != null && (object = object.getValue()) != null ? !Boolean.parseBoolean((String)object) : false);
                    List list2 = outputsElement.getChildren("output");
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
                    Iterable iterable3 = list2;
                    boolean bl6 = bl5;
                    boolean $i$f$map2 = false;
                    void var26_35 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        Object object2;
                        Object object3;
                        void it;
                        Element element7 = (Element)item$iv$iv2;
                        collection2 = destination$iv$iv3;
                        boolean bl7 = false;
                        Dimension size = it.getAttribute("width") != null && it.getAttribute("height") != null ? new Dimension(it.getAttribute("width").getIntValue(), it.getAttribute("height").getIntValue()) : null;
                        Object object4 = it.getAttribute("resized");
                        collection2.add(new JupyterEditorState.OutputState(size, object4 != null && (object4 = object4.getValue()) != null ? Boolean.parseBoolean((String)object4) : false, (object3 = it.getAttribute("collapsed")) != null && (object3 = object3.getValue()) != null ? Boolean.parseBoolean((String)object3) : false, (object2 = it.getAttribute("maximized")) != null && (object2 = object2.getValue()) != null ? Boolean.parseBoolean((String)object2) : false));
                    }
                    collection2 = (List)destination$iv$iv3;
                    List list3 = collection2;
                    boolean bl8 = bl6;
                    outputsState = new JupyterEditorState.OutputsState(bl8, list3);
                } else {
                    outputsState = null;
                }
                JupyterEditorState.OutputsState outputsState2 = outputsState;
                collection.add(new JupyterEditorState.CellState(outputsState2));
            }
            v13 = (List)destination$iv$iv2;
        } else {
            v13 = cellStates = CollectionsKt.emptyList();
        }
        if ((element = sourceElement.getChild("jupyter")) != null && (element = element.getChild("position")) != null) {
            Integer viewportShift;
            Element element8 = element;
            boolean bl = false;
            Attribute attribute = sourceElement.getAttribute("topLeftCornerOffset");
            Integer topLeftCornerOffset = attribute != null ? Integer.valueOf(attribute.getIntValue()) : null;
            Attribute attribute2 = sourceElement.getAttribute("viewportShift");
            Integer n = viewportShift = attribute2 != null ? Integer.valueOf(attribute2.getIntValue()) : null;
            position = topLeftCornerOffset != null && viewportShift != null ? new NotebookPositionKeeper.Position(topLeftCornerOffset.intValue(), viewportShift.intValue()) : null;
        } else {
            position = null;
        }
        NotebookPositionKeeper.Position position2 = position;
        return new JupyterEditorState(textEditorState, collapsedSections, cellStates, position2);
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        if (!(state instanceof JupyterEditorState)) {
            return;
        }
        this.getTextEditorProvider().writeState(((JupyterEditorState)state).getTextEditorState(), project, targetElement);
        Element jupyterElement = new Element("jupyter");
        if (!((Collection)((JupyterEditorState)state).getCollapsedSections()).isEmpty()) {
            Element e = new Element("collapsedSections");
            $this$forEach$iv = ((JupyterEditorState)state).getCollapsedSections();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                Element sectionElement = new Element("section");
                sectionElement.setAttribute("cellOrdinal", String.valueOf(it));
                e.addContent(sectionElement);
            }
            jupyterElement.addContent(e);
        }
        Element cellsElement = new Element("cells");
        $this$forEach$iv = ((JupyterEditorState)state).getCellStates();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterEditorState.CellState cell = (JupyterEditorState.CellState)element$iv;
            boolean bl = false;
            Element cellElement = new Element("cell");
            Element outputsElement = new Element("outputs");
            JupyterEditorState.OutputsState outputsState = cell.getOutputs();
            boolean scrollingEnabled = !(outputsState != null ? !outputsState.getScrollingEnabled() : false);
            outputsElement.setAttribute("scrollingEnabled", String.valueOf(scrollingEnabled));
            cellElement.addContent(outputsElement);
            cellsElement.addContent(cellElement);
            Object object = cell.getOutputs();
            if (object == null || (object = ((JupyterEditorState.OutputsState)object).getItems()) == null) continue;
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Dimension size;
                JupyterEditorState.OutputState it = (JupyterEditorState.OutputState)element$iv2;
                boolean bl2 = false;
                if (it.getSize() == null) continue;
                boolean bl3 = false;
                Element outputElement = new Element("output");
                outputElement.setAttribute("width", String.valueOf(size.width));
                outputElement.setAttribute("height", String.valueOf(size.height));
                outputElement.setAttribute("resized", String.valueOf(it.getResized()));
                outputElement.setAttribute("collapsed", String.valueOf(it.getCollapsed()));
                outputElement.setAttribute("maximized", String.valueOf(it.getMaximized()));
                outputsElement.addContent(outputElement);
            }
        }
        jupyterElement.addContent(cellsElement);
        if (((JupyterEditorState)state).getPosition() != null) {
            Element position = new Element("position");
            position.setAttribute("topLeftCornerOffset", String.valueOf(((JupyterEditorState)state).getPosition().getTopLeftCornerOffset()));
            position.setAttribute("viewportShift", String.valueOf(((JupyterEditorState)state).getPosition().getViewportShift()));
            jupyterElement.addContent(position);
        }
        targetElement.addContent(jupyterElement);
    }

    private final void customizeNotebookTextEditor(TextEditor textEditor) {
        EditorSettings editorSettings;
        Editor editor = textEditor.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorSettings $this$customizeNotebookTextEditor_u24lambda_u2413 = editorSettings = editor2.getSettings();
        boolean bl = false;
        $this$customizeNotebookTextEditor_u24lambda_u2413.setVariableInplaceRenameEnabled(true);
        $this$customizeNotebookTextEditor_u24lambda_u2413.setUseSoftWraps(true);
        $this$customizeNotebookTextEditor_u24lambda_u2413.setAdditionalPageAtBottom(true);
        $this$customizeNotebookTextEditor_u24lambda_u2413.setRightMarginShown(false);
        $this$customizeNotebookTextEditor_u24lambda_u2413.setVerticalScrollOffset(0);
        EditorColorsScheme editorColorsScheme = editor2.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        CustomEditorColorsScheme scheme = new CustomEditorColorsScheme(editorColorsScheme);
        editor2.setColorsScheme((EditorColorsScheme)scheme);
        EditorSettings $this$customizeNotebookTextEditor_u24lambda_u2414 = $this$customizeNotebookTextEditor_u24lambda_u2413 = editor2.getColorsScheme();
        boolean bl2 = false;
        $this$customizeNotebookTextEditor_u24lambda_u2414.setColor(EditorColors.RIGHT_MARGIN_COLOR, null);
        NotebookEditorUiUtilKt.bind((ObservableProperty)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)editor2).getCaretRowBackgroundColor(), (Disposable)((Disposable)textEditor), arg_0 -> JupyterDSFileEditorProvider.customizeNotebookTextEditor$lambda$15(editor2, arg_0));
        NotebookEditorUiUtilKt.bind((ObservableProperty)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)editor2).getEditorBackgroundColor(), (Disposable)((Disposable)textEditor), arg_0 -> JupyterDSFileEditorProvider.customizeNotebookTextEditor$lambda$16(editor2, scheme, arg_0));
        boolean $i$f$service = false;
        Class<SelectClickedCellEventDispatcher> serviceClass$iv = SelectClickedCellEventDispatcher.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((SelectClickedCellEventDispatcher)object).ensureInstalled();
        editor2.getCaretModel().addCaretListener((CaretListener)FocusEditorComponentCaretListener.INSTANCE);
    }

    private static final TextEditor createJupyterFileEditor$lambda$0(JupyterDSFileEditorProvider this$0, Project $project, BackedNotebookVirtualFile $file) {
        FileEditor fileEditor = this$0.getTextEditorProvider().createEditor($project, $file.getFile());
        Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        return (TextEditor)fileEditor;
    }

    private static final Unit customizeNotebookTextEditor$lambda$15(EditorEx $editor, Color it) {
        $editor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, it);
        return Unit.INSTANCE;
    }

    private static final Unit customizeNotebookTextEditor$lambda$16(EditorEx $editor, CustomEditorColorsScheme $scheme, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $editor.setBackgroundColor(it);
        $scheme.setBackgroundColor(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u0007H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/JupyterDSFileEditorProvider$CustomEditorColorsScheme;", "Lcom/intellij/openapi/editor/colors/impl/DelegateColorScheme;", "delegate", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "getDefaultBackground", "intellij.jupyter.core"})
    private static final class CustomEditorColorsScheme
    extends DelegateColorScheme {
        @NotNull
        private Color backgroundColor;

        public CustomEditorColorsScheme(@NotNull EditorColorsScheme delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate);
            Color color = delegate.getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
            this.backgroundColor = color;
        }

        @NotNull
        public final Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.backgroundColor = color;
        }

        @NotNull
        public Color getDefaultBackground() {
            return this.backgroundColor;
        }
    }
}

