/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "wasInMultilineString", "", "whiteSpaceAfterCaret", "", "isInBrace", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "hostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "offset", "postProcessEnter", "Companion", "kotlin.base.code-insight.minimal"})
@SourceDebugExtension(value={"SMAP\nKotlinMultilineStringEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMultilineStringEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,375:1\n648#2,5:376\n648#2,5:387\n827#3:381\n855#3,2:382\n2746#3,3:384\n*S KotlinDebug\n*F\n+ 1 KotlinMultilineStringEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler\n*L\n77#1:376,5\n201#1:387,5\n176#1:381\n176#1:382,2\n181#1:384,3\n*E\n"})
public final class KotlinMultilineStringEnterHandler
implements EnterHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean wasInMultilineString;
    @NotNull
    private String whiteSpaceAfterCaret = "";
    private boolean isInBrace;
    private static final char DEFAULT_TRIM_MARGIN_CHAR = '|';
    @NotNull
    private static final String TRIM_INDENT_CALL = "trimIndent";
    @NotNull
    private static final String TRIM_MARGIN_CALL = "trimMargin";
    @NotNull
    private static final String MULTILINE_QUOTE = "\"\"\"";

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int offset = ((Number)caretOffset.get()).intValue();
        if (!(editor instanceof EditorWindow)) {
            return this.preprocessEnter(file, editor, offset, originalHandler, dataContext);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.preprocessEnter(hostPosition2, originalHandler, dataContext);
    }

    private final EnterHandlerDelegate.Result preprocessEnter(Companion.HostPosition hostPosition, EditorActionHandler originalHandler, DataContext dataContext) {
        PsiFile file = hostPosition.component1();
        Editor editor = hostPosition.component2();
        int offset = hostPosition.component3();
        return this.preprocessEnter(file, editor, offset, originalHandler, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    private final EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, int offset, EditorActionHandler originalHandler, DataContext dataContext) {
        block6: {
            String string;
            String text;
            Document document;
            block5: {
                void $this$takeWhile$iv;
                if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                Document document2 = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
                document = document2;
                String string2 = document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                text = string2;
                if (offset == 0 || offset >= text.length()) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                PsiElement element = file.findElementAt(offset);
                if (!Companion.inMultilineString(element, offset)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                this.wasInMultilineString = true;
                String string3 = text.substring(offset);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String string4 = string3;
                KotlinMultilineStringEnterHandler kotlinMultilineStringEnterHandler = this;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char ch = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (ch == ' ' || ch == '\t') continue;
                    void var13_16 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string5 = var13_16.substring(n2, index$iv);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    break block5;
                }
                string = $this$takeWhile$iv;
            }
            kotlinMultilineStringEnterHandler.whiteSpaceAfterCaret = string;
            document.deleteString(offset, offset + this.whiteSpaceAfterCaret.length());
            char ch1 = text.charAt(offset - 1);
            char ch2 = text.charAt(offset);
            boolean bl = this.isInBrace = ch1 == '(' && ch2 == ')' || ch1 == '{' && ch2 == '}' || ch1 == '>' && ch2 == '<';
            if (!this.isInBrace || !CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
                return EnterHandlerDelegate.Result.Continue;
            }
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler == null) break block6;
            editorActionHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(editor instanceof EditorWindow)) {
            return this.postProcessEnter(file, editor);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.postProcessEnter(hostPosition2.getFile(), hostPosition2.getEditor());
    }

    private final EnterHandlerDelegate.Result postProcessEnter(PsiFile file, Editor editor) {
        Character c;
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!this.wasInMultilineString) {
            return EnterHandlerDelegate.Result.Continue;
        }
        this.wasInMultilineString = false;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        int offset = caretModel2.getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement element = psiElement;
        KtStringTemplateExpression ktStringTemplateExpression = Companion.findString(element, offset);
        if (ktStringTemplateExpression == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        KtStringTemplateExpression literal = ktStringTemplateExpression;
        boolean hasTrimIndentCallInChain = Companion.hasTrimIndentCallInChain(literal);
        if (hasTrimIndentCallInChain) {
            c = null;
        } else {
            c = Companion.getMarginCharFromTrimMarginCallsInChain(literal);
            if (c == null) {
                c = org.jetbrains.kotlin.idea.editor.KotlinMultilineStringEnterHandler$Companion.getMarginCharFromLiteral$default(Companion, literal, '\u0000', 2, null);
            }
        }
        Character marginChar = c;
        ActionsKt.runWriteAction(() -> KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5(file, document2, offset, literal, this, hasTrimIndentCallInChain, marginChar, caretModel2));
        return EnterHandlerDelegate.Result.Stop;
    }

    private static final int postProcessEnter$lambda$5$caretOffset(RangeMarker caretMarker) {
        return caretMarker.getEndOffset();
    }

    private static final boolean postProcessEnter$lambda$5$lambda$1(char it) {
        return it == ' ' || it == '\t';
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit postProcessEnter$lambda$5(PsiFile $file, Document $document, int $offset, KtStringTemplateExpression $literal, KotlinMultilineStringEnterHandler this$0, boolean $hasTrimIndentCallInChain, Character $marginChar, CaretModel $caretModel) {
        block25: {
            block23: {
                block26: {
                    block22: {
                        block24: {
                            settings = new Companion.MultilineSettings($file);
                            v0 = $document.createRangeMarker($offset, $offset);
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createRangeMarker(...)");
                            caretMarker = v0;
                            caretMarker.setGreedyToRight(true);
                            prevLineNumber = $document.getLineNumber($offset) - 1;
                            v1 = var11_11 = prevLineNumber >= 0;
                            if (_Assertions.ENABLED && !var11_11) {
                                var12_13 = "Assertion failed";
                                throw new AssertionError((Object)var12_13);
                            }
                            prevLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber, $document);
                            currentLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 1, $document);
                            nextLine = $document.getLineCount() > prevLineNumber + 2 ? KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 2, $document) : "";
                            v2 = $literal.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getText(...)");
                            v3 = StringsKt.indexOf$default((CharSequence)v2, (String)"\n", (int)0, (boolean)false, (int)6, null);
                            v4 = $literal.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getText(...)");
                            wasSingleLine = v3 == StringsKt.lastIndexOf$default((CharSequence)v4, (String)"\n", (int)0, (boolean)false, (int)6, null);
                            v5 = $literal.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getText(...)");
                            var16_17 = new String[]{"\n"};
                            lines = StringsKt.split$default((CharSequence)v5, (String[])var16_17, (boolean)false, (int)0, (int)6, null);
                            literalOffset = $literal.getTextRange().getStartOffset();
                            if (!wasSingleLine && (lines.size() != 3 || !this$0.isInBrace)) break block24;
                            v6 = shouldUseTrimIndent = $hasTrimIndentCallInChain != false || $marginChar == null && Intrinsics.areEqual((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)lines))).toString(), (Object)"\"\"\"") != false;
                            if (shouldUseTrimIndent) {
                                v7 = null;
                            } else {
                                v8 = $marginChar;
                                v7 = Character.valueOf(v8 != null ? v8.charValue() : '|');
                            }
                            newMarginChar = v7;
                            KotlinMultilineStringEnterHandler.Companion.insertTrimCall($document, $literal, shouldUseTrimIndent != false ? null : newMarginChar);
                            prevIndent = settings.indentLength(prevLine);
                            indentSize = prevIndent + settings.getMarginIndent();
                            KotlinMultilineStringEnterHandler.Companion.forceIndent(KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5$caretOffset(caretMarker), indentSize, newMarginChar, $document, settings);
                            v9 = $literal.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getText(...)");
                            var22_28 = v9;
                            var23_32 = $offset - literalOffset;
                            v10 = var22_28.substring(var23_32);
                            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"substring(...)");
                            isInLineEnd = Intrinsics.areEqual((Object)v10, (Object)"\"\"\"");
                            if (isInLineEnd) {
                                caretMarker.setGreedyToRight(false);
                                KotlinMultilineStringEnterHandler.Companion.insertNewLine(KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5$caretOffset(caretMarker), prevIndent, $document, settings);
                                caretMarker.setGreedyToRight(true);
                            }
                            if (this$0.isInBrace) {
                                KotlinMultilineStringEnterHandler.Companion.forceIndent(KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5$caretOffset(caretMarker) + 1, indentSize, newMarginChar, $document, settings);
                            }
                            break block25;
                        }
                        v11 = isPrevLineFirst = $document.getLineNumber(literalOffset) == prevLineNumber;
                        if (isPrevLineFirst) {
                            v12 = ((String)CollectionsKt.first((List)lines)).substring(3);
                            v13 = v12;
                            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"substring(...)");
                        } else {
                            v13 = prevLine;
                        }
                        indentInPreviousLine = KotlinMultilineStringEnterHandler.Companion.prefixLength(v13, (Function1<? super Character, Boolean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, postProcessEnter$lambda$5$lambda$1(char ), (Ljava/lang/Character;)Ljava/lang/Boolean;)());
                        if (isPrevLineFirst) {
                            v14 = ((String)CollectionsKt.first((List)lines)).substring(indentInPreviousLine + 3);
                            v15 = v14;
                            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"substring(...)");
                        } else {
                            v16 = prevLine.substring(indentInPreviousLine);
                            v15 = v16;
                            Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"substring(...)");
                        }
                        prefixStripped = v15;
                        $this$filterNot$iv = lines.subList(1, lines.size());
                        $i$f$filterNot = false;
                        var23_33 = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (String)element$iv$iv;
                            $i$a$-filterNot-KotlinMultilineStringEnterHandler$postProcessEnter$1$nonBlankNotFirstLines$1 = false;
                            if (StringsKt.isBlank((CharSequence)it) != false || Intrinsics.areEqual((Object)StringsKt.trimStart((CharSequence)it).toString(), (Object)"\"\"\"") != false) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        nonBlankNotFirstLines = (List)destination$iv$iv;
                        if ($marginChar == null || StringsKt.startsWith$default((CharSequence)prefixStripped, (char)$marginChar.charValue(), (boolean)false, (int)2, null) || !(((Collection)nonBlankNotFirstLines).isEmpty() == false)) ** GOTO lbl-1000
                        $this$none$iv = nonBlankNotFirstLines;
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            v17 = true;
                        } else {
                            for (E element$iv : $this$none$iv) {
                                it = (String)element$iv;
                                $i$a$-none-KotlinMultilineStringEnterHandler$postProcessEnter$1$marginCharToInsert$1 = false;
                                if (!StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)it).toString(), (char)$marginChar.charValue(), (boolean)false, (int)2, null)) continue;
                                v17 = false;
                                break block22;
                            }
                            v17 = true;
                        }
                    }
                    if (v17) {
                        v18 = null;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v18 = marginCharToInsert = $marginChar;
                    }
                    if (marginCharToInsert == null) break block26;
                    if (StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)currentLine).toString(), (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) break block25;
                }
                indentLength = this$0.isInBrace != false ? settings.indentLength(nextLine) : (isPrevLineFirst == false ? settings.indentLength(prevLine) : settings.indentLength(prevLine) + settings.getMarginIndent());
                KotlinMultilineStringEnterHandler.Companion.forceIndent(KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5$caretOffset(caretMarker), indentLength, marginCharToInsert, $document, settings);
                if (marginCharToInsert != null && StringsKt.startsWith$default((CharSequence)prefixStripped, (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) {
                    v19 = prefixStripped.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"substring(...)");
                    destination$iv$iv = v19;
                    $i$f$takeWhile = false;
                    var27_46 = $this$takeWhile$iv.length();
                    for (index$iv = 0; index$iv < var27_46; ++index$iv) {
                        it = $this$takeWhile$iv.charAt(index$iv);
                        $i$a$-takeWhile-KotlinMultilineStringEnterHandler$postProcessEnter$1$wsAfterMargin$1 = false;
                        if (it == ' ' || it == '\t') continue;
                        var28_49 = $this$takeWhile$iv;
                        var29_50 = 0;
                        v20 = var28_49.substring(var29_50, index$iv);
                        v21 = v20;
                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"substring(...)");
                        break block23;
                    }
                    v21 = $this$takeWhile$iv;
                } else {
                    v21 = "";
                }
            }
            wsAfterMargin = v21;
            $document.insertString(KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5$caretOffset(caretMarker), (CharSequence)wsAfterMargin);
            if (this$0.isInBrace) {
                nextLineOffset = $document.getLineStartOffset(prevLineNumber + 2);
                KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, 0, null, $document, settings);
                v22 = marginCharToInsert;
                if (v22 == null || (v22 = v22.toString()) == null) {
                    v22 = "";
                }
                $document.insertString(nextLineOffset, (CharSequence)((String)v22 + wsAfterMargin));
                KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, indentLength, null, $document, settings);
            }
        }
        $document.insertString(KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5$caretOffset(caretMarker), (CharSequence)this$0.whiteSpaceAfterCaret);
        $caretModel.moveToOffset(KotlinMultilineStringEnterHandler.postProcessEnter$lambda$5$caretOffset(caretMarker));
        caretMarker.dispose();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u000223B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%J5\u0010&\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\u00020\u000f*\u00020\u00072\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110*J%\u0010+\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010-J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion;", "", "<init>", "()V", "DEFAULT_TRIM_MARGIN_CHAR", "", "TRIM_INDENT_CALL", "", "TRIM_MARGIN_CALL", "MULTILINE_QUOTE", "findString", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "inMultilineString", "", "getMarginCharFromLiteral", "str", "marginChar", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;C)Ljava/lang/Character;", "getLiteralCalls", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getMarginCharFromTrimMarginCallsInChain", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)Ljava/lang/Character;", "hasTrimIndentCallInChain", "getLineByNumber", "number", "document", "Lcom/intellij/openapi/editor/Document;", "insertNewLine", "", "nlOffset", "indent", "settings", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "forceIndent", "(IILjava/lang/Character;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;)V", "prefixLength", "f", "Lkotlin/Function1;", "insertTrimCall", "literal", "(Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Ljava/lang/Character;)V", "getHostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "MultilineSettings", "HostPosition", "kotlin.base.code-insight.minimal"})
    @SourceDebugExtension(value={"SMAP\nKotlinMultilineStringEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMultilineStringEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,375:1\n18#2,2:376\n774#3:378\n865#3,2:379\n1740#3,3:381\n183#4,2:384\n1255#4,2:386\n1255#4,2:398\n648#5,5:388\n648#5,5:393\n*S KotlinDebug\n*F\n+ 1 KotlinMultilineStringEnterHandler.kt\norg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion\n*L\n271#1:376,2\n281#1:378\n281#1:379,2\n283#1:381,3\n308#1:384,2\n320#1:386,2\n347#1:398,2\n335#1:388,5\n343#1:393,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KtStringTemplateExpression findString(@Nullable PsiElement element, int offset) {
            Object v0;
            block6: {
                if (!(element instanceof LeafPsiElement)) {
                    return null;
                }
                IElementType iElementType = ((LeafPsiElement)element).getElementType();
                if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.REGULAR_STRING_PART)) {
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.CLOSING_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                        if (((LeafPsiElement)element).getStartOffset() != offset) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)element);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KtStringTemplateExpression)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean inMultilineString(@Nullable PsiElement element, int offset) {
            KtStringTemplateExpression ktStringTemplateExpression = this.findString(element, offset);
            return !(ktStringTemplateExpression != null ? KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)ktStringTemplateExpression) : true);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Character getMarginCharFromLiteral(@NotNull KtStringTemplateExpression str, char marginChar) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String string = str.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            List lines = StringsKt.lines((CharSequence)string);
            if (lines.size() <= 2) {
                return null;
            }
            Iterable $this$filter$iv = lines.subList(1, lines.size() - 1);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List middleNonBlank = (List)destination$iv$iv;
            if (!((Collection)middleNonBlank).isEmpty()) {
                boolean bl;
                block7: {
                    Iterable $this$all$iv = middleNonBlank;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)it)).toString(), (char)marginChar, (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return Character.valueOf(marginChar);
                }
            }
            return null;
        }

        public static /* synthetic */ Character getMarginCharFromLiteral$default(Companion companion, KtStringTemplateExpression ktStringTemplateExpression, char c, int n, Object object) {
            if ((n & 2) != 0) {
                c = (char)124;
            }
            return companion.getMarginCharFromLiteral(ktStringTemplateExpression, c);
        }

        private final Sequence<KtCallExpression> getLiteralCalls(KtStringTemplateExpression str) {
            Ref.ObjectRef previous = new Ref.ObjectRef();
            previous.element = str;
            return SequencesKt.mapNotNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)str)), arg_0 -> Companion.getLiteralCalls$lambda$2(previous, arg_0)), Companion::getLiteralCalls$lambda$3);
        }

        @Nullable
        public final Character getMarginCharFromTrimMarginCallsInChain(@NotNull KtStringTemplateExpression str) {
            Object v1;
            block5: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                Sequence<KtCallExpression> $this$firstOrNull$iv = this.getLiteralCalls(str);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtCallExpression call = (KtCallExpression)element$iv;
                    boolean bl = false;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)call));
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)KotlinMultilineStringEnterHandler.TRIM_MARGIN_CALL)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            KtCallExpression ktCallExpression = v1;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression literalCall = ktCallExpression;
            List list = literalCall.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)list, (int)0);
            if (ktValueArgument == null) {
                return Character.valueOf('|');
            }
            KtValueArgument firstArgument = ktValueArgument;
            Iterator iterator = firstArgument.getArgumentExpression();
            KtStringTemplateExpression ktStringTemplateExpression = iterator instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)iterator : null;
            if (ktStringTemplateExpression == null) {
                return Character.valueOf('|');
            }
            KtStringTemplateExpression argumentExpression = ktStringTemplateExpression;
            KtStringTemplateEntry[] ktStringTemplateEntryArray = argumentExpression.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
            Object object = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = object instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object : null;
            if (ktLiteralStringTemplateEntry == null) {
                return Character.valueOf('|');
            }
            KtLiteralStringTemplateEntry entry = ktLiteralStringTemplateEntry;
            Object object2 = entry.getText();
            return Character.valueOf(object2 != null && (object2 = StringsKt.singleOrNull((CharSequence)((CharSequence)object2))) != null ? ((Character)object2).charValue() : (char)'|');
        }

        public final boolean hasTrimIndentCallInChain(@NotNull KtStringTemplateExpression str) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                Sequence<KtCallExpression> $this$any$iv = this.getLiteralCalls(str);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    KtCallExpression call = (KtCallExpression)element$iv;
                    boolean bl2 = false;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)call));
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)KotlinMultilineStringEnterHandler.TRIM_INDENT_CALL)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String getLineByNumber(int number, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            String string = document.getText(new TextRange(document.getLineStartOffset(number), document.getLineEndOffset(number)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        public final void insertNewLine(int nlOffset, int indent, @NotNull Document document, @NotNull MultilineSettings settings) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            document.insertString(nlOffset, (CharSequence)"\n");
            this.forceIndent(nlOffset + 1, indent, null, document, settings);
        }

        public final void forceIndent(int offset, int indent, @Nullable Character marginChar, @NotNull Document document, @NotNull MultilineSettings settings) {
            String string;
            int lineStart;
            block2: {
                String line;
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                int lineNumber = document.getLineNumber(offset);
                lineStart = document.getLineStartOffset(lineNumber);
                String $this$takeWhile$iv = line = this.getLineByNumber(lineNumber, document);
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char c = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (c == ' ' || c == '\t') continue;
                    String string2 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string3 = string2.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block2;
                }
                string = $this$takeWhile$iv;
            }
            String wsPrefix = string;
            int n = lineStart + wsPrefix.length();
            String string4 = settings.getSmartSpaces(indent);
            Object object = marginChar;
            if (object == null || (object = ((Character)object).toString()) == null) {
                object = "";
            }
            document.replaceString(lineStart, n, (CharSequence)(string4 + (String)object));
        }

        /*
         * WARNING - void declaration
         */
        public final int prefixLength(@NotNull String $this$prefixLength, @NotNull Function1<? super Character, Boolean> f) {
            String string;
            block1: {
                void var3_3;
                Intrinsics.checkNotNullParameter((Object)$this$prefixLength, (String)"<this>");
                Intrinsics.checkNotNullParameter(f, (String)"f");
                String $this$takeWhile$iv = $this$prefixLength;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    if (((Boolean)f.invoke((Object)Character.valueOf($this$takeWhile$iv.charAt(index$iv)))).booleanValue()) continue;
                    String string2 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string3 = string2.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block1;
                }
                string = var3_3;
            }
            return ((CharSequence)string).length();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void insertTrimCall(@NotNull Document document, @NotNull KtStringTemplateExpression literal, @Nullable Character marginChar) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
            if (this.hasTrimIndentCallInChain(literal)) return;
            if (this.getMarginCharFromTrimMarginCallsInChain(literal) != null) {
                return;
            }
            Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)literal));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                boolean bl;
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (it instanceof KtAnnotationEntry) return;
                KtProperty ktProperty = it instanceof KtProperty ? (KtProperty)it : null;
                if (ktProperty != null) {
                    if (ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
                        return;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return;
            }
            boolean bl = false;
            if (bl) {
                return;
            }
            if (marginChar == null) {
                document.insertString(literal.getTextRange().getEndOffset(), (CharSequence)".trimIndent()");
                return;
            } else {
                char c = '|';
                document.insertString(literal.getTextRange().getEndOffset(), (CharSequence)(marginChar.charValue() == c ? ".trimMargin()" : ".trimMargin(\"" + marginChar + "\")"));
            }
        }

        private final HostPosition getHostPosition(DataContext dataContext) {
            Object object = CommonDataKeys.HOST_EDITOR.getData(dataContext);
            EditorEx editorEx = object instanceof EditorEx ? (EditorEx)object : null;
            if (editorEx == null) {
                return null;
            }
            EditorEx editor = editorEx;
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return null;
            }
            Project project2 = project;
            VirtualFile virtualFile = editor.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile2);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            return new HostPosition(psiFile2, (Editor)editor, editor.getCaretModel().getOffset());
        }

        private static final boolean getLiteralCalls$lambda$2(Ref.ObjectRef $previous, PsiElement parent) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (parent instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent).getReceiverExpression(), (Object)$previous.element)) {
                $previous.element = parent;
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private static final KtCallExpression getLiteralCalls$lambda$3(PsiElement qualified) {
            Intrinsics.checkNotNullParameter((Object)qualified, (String)"qualified");
            KtExpression ktExpression = ((KtQualifiedExpression)qualified).getSelectorExpression();
            return ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;I)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getOffset", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin.base.code-insight.minimal"})
        private static final class HostPosition {
            @NotNull
            private final PsiFile file;
            @NotNull
            private final Editor editor;
            private final int offset;

            public HostPosition(@NotNull PsiFile file, @NotNull Editor editor, int offset) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.file = file;
                this.editor = editor;
                this.offset = offset;
            }

            @NotNull
            public final PsiFile getFile() {
                return this.file;
            }

            @NotNull
            public final Editor getEditor() {
                return this.editor;
            }

            public final int getOffset() {
                return this.offset;
            }

            @NotNull
            public final PsiFile component1() {
                return this.file;
            }

            @NotNull
            public final Editor component2() {
                return this.editor;
            }

            public final int component3() {
                return this.offset;
            }

            @NotNull
            public final HostPosition copy(@NotNull PsiFile file, @NotNull Editor editor, int offset) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                return new HostPosition(file, editor, offset);
            }

            public static /* synthetic */ HostPosition copy$default(HostPosition hostPosition, PsiFile psiFile, Editor editor, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    psiFile = hostPosition.file;
                }
                if ((n2 & 2) != 0) {
                    editor = hostPosition.editor;
                }
                if ((n2 & 4) != 0) {
                    n = hostPosition.offset;
                }
                return hostPosition.copy(psiFile, editor, n);
            }

            @NotNull
            public String toString() {
                return "HostPosition(file=" + this.file + ", editor=" + this.editor + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                int result = this.file.hashCode();
                result = result * 31 + this.editor.hashCode();
                result = result * 31 + Integer.hashCode(this.offset);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HostPosition)) {
                    return false;
                }
                HostPosition hostPosition = (HostPosition)other;
                if (!Intrinsics.areEqual((Object)this.file, (Object)hostPosition.file)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.editor, (Object)hostPosition.editor)) {
                    return false;
                }
                return this.offset == hostPosition.offset;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0012R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "kotlinIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "Lorg/jetbrains/annotations/NotNull;", "useTabs", "", "tabSize", "", "regularIndent", "marginIndent", "getMarginIndent", "()I", "getSmartSpaces", "", "count", "indentLength", "line", "kotlin.base.code-insight.minimal"})
        public static final class MultilineSettings {
            @NotNull
            private final CommonCodeStyleSettings.IndentOptions kotlinIndentOptions;
            private final boolean useTabs;
            private final int tabSize;
            private final int regularIndent;
            private final int marginIndent;

            public MultilineSettings(@NotNull PsiFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
                this.kotlinIndentOptions = indentOptions;
                this.useTabs = this.kotlinIndentOptions.USE_TAB_CHARACTER;
                this.tabSize = this.kotlinIndentOptions.TAB_SIZE;
                this.marginIndent = this.regularIndent = this.kotlinIndentOptions.INDENT_SIZE;
            }

            public final int getMarginIndent() {
                return this.marginIndent;
            }

            @NotNull
            public final String getSmartSpaces(int count) {
                Object object;
                if (this.useTabs) {
                    object = StringUtil.repeat((String)"\t", (int)(count / this.tabSize)) + StringUtil.repeat((String)" ", (int)(count % this.tabSize));
                } else {
                    String string = StringUtil.repeat((String)" ", (int)count);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeat(...)");
                }
                return object;
            }

            public final int indentLength(@NotNull String line) {
                int n;
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                if (this.useTabs) {
                    int tabsCount = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)MultilineSettings::indentLength$lambda$0));
                    String string = line.substring(tabsCount);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    n = tabsCount * this.tabSize + Companion.prefixLength(string, (Function1<? super Character, Boolean>)((Function1)MultilineSettings::indentLength$lambda$1));
                } else {
                    n = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)MultilineSettings::indentLength$lambda$2));
                }
                return n;
            }

            private static final boolean indentLength$lambda$0(char it) {
                return it == '\t';
            }

            private static final boolean indentLength$lambda$1(char it) {
                return it == ' ';
            }

            private static final boolean indentLength$lambda$2(char it) {
                return it == ' ';
            }
        }
    }
}

