/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.CertificateAuthenticationData;
import org.jetbrains.idea.svn.auth.PasswordAuthenticationData;

public final class ProxySvnAuthentication {
    private ProxySvnAuthentication() {
    }

    public static AuthenticationData proxy(AuthenticationData in, boolean storeAuth) {
        if (in.isStorageAllowed() == storeAuth || !in.isStorageAllowed()) {
            return in;
        }
        return ProxySvnAuthentication.putPassedValueAsSave(in, storeAuth);
    }

    private static AuthenticationData putPassedValueAsSave(AuthenticationData in, boolean storeAuth) {
        if (in instanceof PasswordAuthenticationData) {
            return new PasswordAuthenticationData(((PasswordAuthenticationData)in).getCredentials(), storeAuth);
        }
        if (in instanceof CertificateAuthenticationData) {
            return new CertificateAuthenticationData(((CertificateAuthenticationData)in).getCertificate(), storeAuth);
        }
        return in;
    }
}

