// Code generated by dbus-codegen-go DO NOT EDIT.
package udisks2

import (
	"context"
	"errors"
	"fmt"
	"github.com/godbus/dbus/v5"
)

// Signal is a common interface for all signals.
type Signal interface {
	Name() string
	Interface() string
	Sender() string

	path() dbus.ObjectPath
	values() []interface{}
}

// ErrUnknownSignal is returned by LookupSignal when a signal cannot be resolved.
var ErrUnknownSignal = errors.New("unknown signal")

// LookupSignal converts the given raw D-Bus signal with variable body
// into one with typed structured body or returns ErrUnknownSignal error.
func LookupSignal(signal *dbus.Signal) (Signal, error) {
	switch signal.Name {
	case InterfaceJob + "." + "Completed":
		v0, ok := signal.Body[0].(bool)
		if !ok {
			return nil, fmt.Errorf("prop .Success is %T, not bool", signal.Body[0])
		}
		v1, ok := signal.Body[1].(string)
		if !ok {
			return nil, fmt.Errorf("prop .Message is %T, not string", signal.Body[1])
		}
		return &JobCompletedSignal{
			sender: signal.Sender,
			Path:   signal.Path,
			Body: &JobCompletedSignalBody{
				Success: v0,
				Message: v1,
			},
		}, nil
	default:
		return nil, ErrUnknownSignal
	}
}

// AddMatchSignal registers a match rule for the given signal,
// opts are appended to the automatically generated signal's rules.
func AddMatchSignal(conn *dbus.Conn, s Signal, opts ...dbus.MatchOption) error {
	return conn.AddMatchSignal(append([]dbus.MatchOption{
		dbus.WithMatchInterface(s.Interface()),
		dbus.WithMatchMember(s.Name()),
	}, opts...)...)
}

// RemoveMatchSignal unregisters the previously registered subscription.
func RemoveMatchSignal(conn *dbus.Conn, s Signal, opts ...dbus.MatchOption) error {
	return conn.RemoveMatchSignal(append([]dbus.MatchOption{
		dbus.WithMatchInterface(s.Interface()),
		dbus.WithMatchMember(s.Name()),
	}, opts...)...)
}

// Interface name constants.
const (
	InterfaceManager        = "org.freedesktop.UDisks2.Manager"
	InterfaceDrive          = "org.freedesktop.UDisks2.Drive"
	InterfaceDriveAta       = "org.freedesktop.UDisks2.Drive.Ata"
	InterfaceBlock          = "org.freedesktop.UDisks2.Block"
	InterfacePartitionTable = "org.freedesktop.UDisks2.PartitionTable"
	InterfacePartition      = "org.freedesktop.UDisks2.Partition"
	InterfaceFilesystem     = "org.freedesktop.UDisks2.Filesystem"
	InterfaceSwapspace      = "org.freedesktop.UDisks2.Swapspace"
	InterfaceEncrypted      = "org.freedesktop.UDisks2.Encrypted"
	InterfaceLoop           = "org.freedesktop.UDisks2.Loop"
	InterfaceMDRaid         = "org.freedesktop.UDisks2.MDRaid"
	InterfaceJob            = "org.freedesktop.UDisks2.Job"
)

// NewManager creates and allocates org.freedesktop.UDisks2.Manager.
func NewManager(object dbus.BusObject) *Manager {
	return &Manager{object}
}

// Manager implements org.freedesktop.UDisks2.Manager D-Bus interface.
type Manager struct {
	object dbus.BusObject
}

// CanFormat calls org.freedesktop.UDisks2.Manager.CanFormat method.
func (o *Manager) CanFormat(ctx context.Context, inType string) (available struct {
	V0 bool
	V1 string
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".CanFormat", 0, inType).Store(&available)
	return
}

// CanResize calls org.freedesktop.UDisks2.Manager.CanResize method.
func (o *Manager) CanResize(ctx context.Context, inType string) (available struct {
	V0 bool
	V1 uint64
	V2 string
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".CanResize", 0, inType).Store(&available)
	return
}

// CanCheck calls org.freedesktop.UDisks2.Manager.CanCheck method.
func (o *Manager) CanCheck(ctx context.Context, inType string) (available struct {
	V0 bool
	V1 string
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".CanCheck", 0, inType).Store(&available)
	return
}

// CanRepair calls org.freedesktop.UDisks2.Manager.CanRepair method.
func (o *Manager) CanRepair(ctx context.Context, inType string) (available struct {
	V0 bool
	V1 string
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".CanRepair", 0, inType).Store(&available)
	return
}

// LoopSetup calls org.freedesktop.UDisks2.Manager.LoopSetup method.
//
// Annotations:
//   @org.gtk.GDBus.C.UnixFD = 1
func (o *Manager) LoopSetup(ctx context.Context, fd dbus.UnixFD, options map[string]dbus.Variant) (resultingDevice dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".LoopSetup", 0, fd, options).Store(&resultingDevice)
	return
}

// MDRaidCreate calls org.freedesktop.UDisks2.Manager.MDRaidCreate method.
func (o *Manager) MDRaidCreate(ctx context.Context, blocks []dbus.ObjectPath, level string, name string, chunk uint64, options map[string]dbus.Variant) (resultingArray dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".MDRaidCreate", 0, blocks, level, name, chunk, options).Store(&resultingArray)
	return
}

// EnableModules calls org.freedesktop.UDisks2.Manager.EnableModules method.
//
// Deprecated will be removed later.
//
// Annotations:
//   @org.freedesktop.DBus.Deprecated = true
func (o *Manager) EnableModules(ctx context.Context, enable bool) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".EnableModules", 0, enable).Store()
	return
}

// EnableModule calls org.freedesktop.UDisks2.Manager.EnableModule method.
func (o *Manager) EnableModule(ctx context.Context, name string, enable bool) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".EnableModule", 0, name, enable).Store()
	return
}

// GetBlockDevices calls org.freedesktop.UDisks2.Manager.GetBlockDevices method.
func (o *Manager) GetBlockDevices(ctx context.Context, options map[string]dbus.Variant) (blockObjects []dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".GetBlockDevices", 0, options).Store(&blockObjects)
	return
}

// ResolveDevice calls org.freedesktop.UDisks2.Manager.ResolveDevice method.
func (o *Manager) ResolveDevice(ctx context.Context, devspec map[string]dbus.Variant, options map[string]dbus.Variant) (devices []dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, InterfaceManager+".ResolveDevice", 0, devspec, options).Store(&devices)
	return
}

// GetVersion gets org.freedesktop.UDisks2.Manager.Version property.
func (o *Manager) GetVersion(ctx context.Context) (version string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceManager, "Version").Store(&version)
	return
}

// GetSupportedFilesystems gets org.freedesktop.UDisks2.Manager.SupportedFilesystems property.
func (o *Manager) GetSupportedFilesystems(ctx context.Context) (supportedFilesystems []string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceManager, "SupportedFilesystems").Store(&supportedFilesystems)
	return
}

// GetSupportedEncryptionTypes gets org.freedesktop.UDisks2.Manager.SupportedEncryptionTypes property.
func (o *Manager) GetSupportedEncryptionTypes(ctx context.Context) (supportedEncryptionTypes []string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceManager, "SupportedEncryptionTypes").Store(&supportedEncryptionTypes)
	return
}

// GetDefaultEncryptionType gets org.freedesktop.UDisks2.Manager.DefaultEncryptionType property.
func (o *Manager) GetDefaultEncryptionType(ctx context.Context) (defaultEncryptionType string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceManager, "DefaultEncryptionType").Store(&defaultEncryptionType)
	return
}

// NewDrive creates and allocates org.freedesktop.UDisks2.Drive.
func NewDrive(object dbus.BusObject) *Drive {
	return &Drive{object}
}

// Drive implements org.freedesktop.UDisks2.Drive D-Bus interface.
type Drive struct {
	object dbus.BusObject
}

// Eject calls org.freedesktop.UDisks2.Drive.Eject method.
func (o *Drive) Eject(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDrive+".Eject", 0, options).Store()
	return
}

// SetConfiguration calls org.freedesktop.UDisks2.Drive.SetConfiguration method.
func (o *Drive) SetConfiguration(ctx context.Context, value map[string]dbus.Variant, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDrive+".SetConfiguration", 0, value, options).Store()
	return
}

// PowerOff calls org.freedesktop.UDisks2.Drive.PowerOff method.
func (o *Drive) PowerOff(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDrive+".PowerOff", 0, options).Store()
	return
}

// GetVendor gets org.freedesktop.UDisks2.Drive.Vendor property.
func (o *Drive) GetVendor(ctx context.Context) (vendor string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Vendor").Store(&vendor)
	return
}

// GetModel gets org.freedesktop.UDisks2.Drive.Model property.
func (o *Drive) GetModel(ctx context.Context) (model string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Model").Store(&model)
	return
}

// GetRevision gets org.freedesktop.UDisks2.Drive.Revision property.
func (o *Drive) GetRevision(ctx context.Context) (revision string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Revision").Store(&revision)
	return
}

// GetSerial gets org.freedesktop.UDisks2.Drive.Serial property.
func (o *Drive) GetSerial(ctx context.Context) (serial string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Serial").Store(&serial)
	return
}

// GetWWN gets org.freedesktop.UDisks2.Drive.WWN property.
func (o *Drive) GetWWN(ctx context.Context) (wWN string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "WWN").Store(&wWN)
	return
}

// GetId gets org.freedesktop.UDisks2.Drive.Id property.
func (o *Drive) GetId(ctx context.Context) (id string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Id").Store(&id)
	return
}

// GetConfiguration gets org.freedesktop.UDisks2.Drive.Configuration property.
func (o *Drive) GetConfiguration(ctx context.Context) (configuration map[string]dbus.Variant, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Configuration").Store(&configuration)
	return
}

// GetMedia gets org.freedesktop.UDisks2.Drive.Media property.
func (o *Drive) GetMedia(ctx context.Context) (media string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Media").Store(&media)
	return
}

// GetMediaCompatibility gets org.freedesktop.UDisks2.Drive.MediaCompatibility property.
func (o *Drive) GetMediaCompatibility(ctx context.Context) (mediaCompatibility []string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "MediaCompatibility").Store(&mediaCompatibility)
	return
}

// GetMediaRemovable gets org.freedesktop.UDisks2.Drive.MediaRemovable property.
func (o *Drive) GetMediaRemovable(ctx context.Context) (mediaRemovable bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "MediaRemovable").Store(&mediaRemovable)
	return
}

// GetMediaAvailable gets org.freedesktop.UDisks2.Drive.MediaAvailable property.
func (o *Drive) GetMediaAvailable(ctx context.Context) (mediaAvailable bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "MediaAvailable").Store(&mediaAvailable)
	return
}

// GetMediaChangeDetected gets org.freedesktop.UDisks2.Drive.MediaChangeDetected property.
func (o *Drive) GetMediaChangeDetected(ctx context.Context) (mediaChangeDetected bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "MediaChangeDetected").Store(&mediaChangeDetected)
	return
}

// GetSize gets org.freedesktop.UDisks2.Drive.Size property.
func (o *Drive) GetSize(ctx context.Context) (size uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Size").Store(&size)
	return
}

// GetTimeDetected gets org.freedesktop.UDisks2.Drive.TimeDetected property.
func (o *Drive) GetTimeDetected(ctx context.Context) (timeDetected uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "TimeDetected").Store(&timeDetected)
	return
}

// GetTimeMediaDetected gets org.freedesktop.UDisks2.Drive.TimeMediaDetected property.
func (o *Drive) GetTimeMediaDetected(ctx context.Context) (timeMediaDetected uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "TimeMediaDetected").Store(&timeMediaDetected)
	return
}

// GetOptical gets org.freedesktop.UDisks2.Drive.Optical property.
func (o *Drive) GetOptical(ctx context.Context) (optical bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Optical").Store(&optical)
	return
}

// GetOpticalBlank gets org.freedesktop.UDisks2.Drive.OpticalBlank property.
func (o *Drive) GetOpticalBlank(ctx context.Context) (opticalBlank bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "OpticalBlank").Store(&opticalBlank)
	return
}

// GetOpticalNumTracks gets org.freedesktop.UDisks2.Drive.OpticalNumTracks property.
func (o *Drive) GetOpticalNumTracks(ctx context.Context) (opticalNumTracks uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "OpticalNumTracks").Store(&opticalNumTracks)
	return
}

// GetOpticalNumAudioTracks gets org.freedesktop.UDisks2.Drive.OpticalNumAudioTracks property.
func (o *Drive) GetOpticalNumAudioTracks(ctx context.Context) (opticalNumAudioTracks uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "OpticalNumAudioTracks").Store(&opticalNumAudioTracks)
	return
}

// GetOpticalNumDataTracks gets org.freedesktop.UDisks2.Drive.OpticalNumDataTracks property.
func (o *Drive) GetOpticalNumDataTracks(ctx context.Context) (opticalNumDataTracks uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "OpticalNumDataTracks").Store(&opticalNumDataTracks)
	return
}

// GetOpticalNumSessions gets org.freedesktop.UDisks2.Drive.OpticalNumSessions property.
func (o *Drive) GetOpticalNumSessions(ctx context.Context) (opticalNumSessions uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "OpticalNumSessions").Store(&opticalNumSessions)
	return
}

// GetRotationRate gets org.freedesktop.UDisks2.Drive.RotationRate property.
func (o *Drive) GetRotationRate(ctx context.Context) (rotationRate int32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "RotationRate").Store(&rotationRate)
	return
}

// GetConnectionBus gets org.freedesktop.UDisks2.Drive.ConnectionBus property.
func (o *Drive) GetConnectionBus(ctx context.Context) (connectionBus string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "ConnectionBus").Store(&connectionBus)
	return
}

// GetSeat gets org.freedesktop.UDisks2.Drive.Seat property.
func (o *Drive) GetSeat(ctx context.Context) (seat string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Seat").Store(&seat)
	return
}

// GetRemovable gets org.freedesktop.UDisks2.Drive.Removable property.
func (o *Drive) GetRemovable(ctx context.Context) (removable bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Removable").Store(&removable)
	return
}

// GetEjectable gets org.freedesktop.UDisks2.Drive.Ejectable property.
func (o *Drive) GetEjectable(ctx context.Context) (ejectable bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "Ejectable").Store(&ejectable)
	return
}

// GetSortKey gets org.freedesktop.UDisks2.Drive.SortKey property.
func (o *Drive) GetSortKey(ctx context.Context) (sortKey string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "SortKey").Store(&sortKey)
	return
}

// GetCanPowerOff gets org.freedesktop.UDisks2.Drive.CanPowerOff property.
func (o *Drive) GetCanPowerOff(ctx context.Context) (canPowerOff bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "CanPowerOff").Store(&canPowerOff)
	return
}

// GetSiblingId gets org.freedesktop.UDisks2.Drive.SiblingId property.
func (o *Drive) GetSiblingId(ctx context.Context) (siblingId string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDrive, "SiblingId").Store(&siblingId)
	return
}

// NewDriveAta creates and allocates org.freedesktop.UDisks2.Drive.Ata.
func NewDriveAta(object dbus.BusObject) *DriveAta {
	return &DriveAta{object}
}

// DriveAta implements org.freedesktop.UDisks2.Drive.Ata D-Bus interface.
type DriveAta struct {
	object dbus.BusObject
}

// SmartUpdate calls org.freedesktop.UDisks2.Drive.Ata.SmartUpdate method.
func (o *DriveAta) SmartUpdate(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".SmartUpdate", 0, options).Store()
	return
}

// SmartGetAttributes calls org.freedesktop.UDisks2.Drive.Ata.SmartGetAttributes method.
func (o *DriveAta) SmartGetAttributes(ctx context.Context, options map[string]dbus.Variant) (attributes []struct {
	V0 byte
	V1 string
	V2 uint16
	V3 int32
	V4 int32
	V5 int32
	V6 int64
	V7 int32
	V8 map[string]dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".SmartGetAttributes", 0, options).Store(&attributes)
	return
}

// SmartSelftestStart calls org.freedesktop.UDisks2.Drive.Ata.SmartSelftestStart method.
func (o *DriveAta) SmartSelftestStart(ctx context.Context, inType string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".SmartSelftestStart", 0, inType, options).Store()
	return
}

// SmartSelftestAbort calls org.freedesktop.UDisks2.Drive.Ata.SmartSelftestAbort method.
func (o *DriveAta) SmartSelftestAbort(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".SmartSelftestAbort", 0, options).Store()
	return
}

// SmartSetEnabled calls org.freedesktop.UDisks2.Drive.Ata.SmartSetEnabled method.
func (o *DriveAta) SmartSetEnabled(ctx context.Context, value bool, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".SmartSetEnabled", 0, value, options).Store()
	return
}

// PmGetState calls org.freedesktop.UDisks2.Drive.Ata.PmGetState method.
func (o *DriveAta) PmGetState(ctx context.Context, options map[string]dbus.Variant) (state byte, err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".PmGetState", 0, options).Store(&state)
	return
}

// PmStandby calls org.freedesktop.UDisks2.Drive.Ata.PmStandby method.
func (o *DriveAta) PmStandby(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".PmStandby", 0, options).Store()
	return
}

// PmWakeup calls org.freedesktop.UDisks2.Drive.Ata.PmWakeup method.
func (o *DriveAta) PmWakeup(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".PmWakeup", 0, options).Store()
	return
}

// SecurityEraseUnit calls org.freedesktop.UDisks2.Drive.Ata.SecurityEraseUnit method.
func (o *DriveAta) SecurityEraseUnit(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceDriveAta+".SecurityEraseUnit", 0, options).Store()
	return
}

// GetSmartSupported gets org.freedesktop.UDisks2.Drive.Ata.SmartSupported property.
func (o *DriveAta) GetSmartSupported(ctx context.Context) (smartSupported bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartSupported").Store(&smartSupported)
	return
}

// GetSmartEnabled gets org.freedesktop.UDisks2.Drive.Ata.SmartEnabled property.
func (o *DriveAta) GetSmartEnabled(ctx context.Context) (smartEnabled bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartEnabled").Store(&smartEnabled)
	return
}

// GetSmartUpdated gets org.freedesktop.UDisks2.Drive.Ata.SmartUpdated property.
func (o *DriveAta) GetSmartUpdated(ctx context.Context) (smartUpdated uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartUpdated").Store(&smartUpdated)
	return
}

// GetSmartFailing gets org.freedesktop.UDisks2.Drive.Ata.SmartFailing property.
func (o *DriveAta) GetSmartFailing(ctx context.Context) (smartFailing bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartFailing").Store(&smartFailing)
	return
}

// GetSmartPowerOnSeconds gets org.freedesktop.UDisks2.Drive.Ata.SmartPowerOnSeconds property.
func (o *DriveAta) GetSmartPowerOnSeconds(ctx context.Context) (smartPowerOnSeconds uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartPowerOnSeconds").Store(&smartPowerOnSeconds)
	return
}

// GetSmartTemperature gets org.freedesktop.UDisks2.Drive.Ata.SmartTemperature property.
func (o *DriveAta) GetSmartTemperature(ctx context.Context) (smartTemperature float64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartTemperature").Store(&smartTemperature)
	return
}

// GetSmartNumAttributesFailing gets org.freedesktop.UDisks2.Drive.Ata.SmartNumAttributesFailing property.
func (o *DriveAta) GetSmartNumAttributesFailing(ctx context.Context) (smartNumAttributesFailing int32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartNumAttributesFailing").Store(&smartNumAttributesFailing)
	return
}

// GetSmartNumAttributesFailedInThePast gets org.freedesktop.UDisks2.Drive.Ata.SmartNumAttributesFailedInThePast property.
func (o *DriveAta) GetSmartNumAttributesFailedInThePast(ctx context.Context) (smartNumAttributesFailedInThePast int32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartNumAttributesFailedInThePast").Store(&smartNumAttributesFailedInThePast)
	return
}

// GetSmartNumBadSectors gets org.freedesktop.UDisks2.Drive.Ata.SmartNumBadSectors property.
func (o *DriveAta) GetSmartNumBadSectors(ctx context.Context) (smartNumBadSectors int64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartNumBadSectors").Store(&smartNumBadSectors)
	return
}

// GetSmartSelftestStatus gets org.freedesktop.UDisks2.Drive.Ata.SmartSelftestStatus property.
func (o *DriveAta) GetSmartSelftestStatus(ctx context.Context) (smartSelftestStatus string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartSelftestStatus").Store(&smartSelftestStatus)
	return
}

// GetSmartSelftestPercentRemaining gets org.freedesktop.UDisks2.Drive.Ata.SmartSelftestPercentRemaining property.
func (o *DriveAta) GetSmartSelftestPercentRemaining(ctx context.Context) (smartSelftestPercentRemaining int32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SmartSelftestPercentRemaining").Store(&smartSelftestPercentRemaining)
	return
}

// GetPmSupported gets org.freedesktop.UDisks2.Drive.Ata.PmSupported property.
func (o *DriveAta) GetPmSupported(ctx context.Context) (pmSupported bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "PmSupported").Store(&pmSupported)
	return
}

// GetPmEnabled gets org.freedesktop.UDisks2.Drive.Ata.PmEnabled property.
func (o *DriveAta) GetPmEnabled(ctx context.Context) (pmEnabled bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "PmEnabled").Store(&pmEnabled)
	return
}

// GetApmSupported gets org.freedesktop.UDisks2.Drive.Ata.ApmSupported property.
func (o *DriveAta) GetApmSupported(ctx context.Context) (apmSupported bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "ApmSupported").Store(&apmSupported)
	return
}

// GetApmEnabled gets org.freedesktop.UDisks2.Drive.Ata.ApmEnabled property.
func (o *DriveAta) GetApmEnabled(ctx context.Context) (apmEnabled bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "ApmEnabled").Store(&apmEnabled)
	return
}

// GetAamSupported gets org.freedesktop.UDisks2.Drive.Ata.AamSupported property.
func (o *DriveAta) GetAamSupported(ctx context.Context) (aamSupported bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "AamSupported").Store(&aamSupported)
	return
}

// GetAamEnabled gets org.freedesktop.UDisks2.Drive.Ata.AamEnabled property.
func (o *DriveAta) GetAamEnabled(ctx context.Context) (aamEnabled bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "AamEnabled").Store(&aamEnabled)
	return
}

// GetAamVendorRecommendedValue gets org.freedesktop.UDisks2.Drive.Ata.AamVendorRecommendedValue property.
func (o *DriveAta) GetAamVendorRecommendedValue(ctx context.Context) (aamVendorRecommendedValue int32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "AamVendorRecommendedValue").Store(&aamVendorRecommendedValue)
	return
}

// GetWriteCacheSupported gets org.freedesktop.UDisks2.Drive.Ata.WriteCacheSupported property.
func (o *DriveAta) GetWriteCacheSupported(ctx context.Context) (writeCacheSupported bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "WriteCacheSupported").Store(&writeCacheSupported)
	return
}

// GetWriteCacheEnabled gets org.freedesktop.UDisks2.Drive.Ata.WriteCacheEnabled property.
func (o *DriveAta) GetWriteCacheEnabled(ctx context.Context) (writeCacheEnabled bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "WriteCacheEnabled").Store(&writeCacheEnabled)
	return
}

// GetReadLookaheadSupported gets org.freedesktop.UDisks2.Drive.Ata.ReadLookaheadSupported property.
func (o *DriveAta) GetReadLookaheadSupported(ctx context.Context) (readLookaheadSupported bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "ReadLookaheadSupported").Store(&readLookaheadSupported)
	return
}

// GetReadLookaheadEnabled gets org.freedesktop.UDisks2.Drive.Ata.ReadLookaheadEnabled property.
func (o *DriveAta) GetReadLookaheadEnabled(ctx context.Context) (readLookaheadEnabled bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "ReadLookaheadEnabled").Store(&readLookaheadEnabled)
	return
}

// GetSecurityEraseUnitMinutes gets org.freedesktop.UDisks2.Drive.Ata.SecurityEraseUnitMinutes property.
func (o *DriveAta) GetSecurityEraseUnitMinutes(ctx context.Context) (securityEraseUnitMinutes int32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SecurityEraseUnitMinutes").Store(&securityEraseUnitMinutes)
	return
}

// GetSecurityEnhancedEraseUnitMinutes gets org.freedesktop.UDisks2.Drive.Ata.SecurityEnhancedEraseUnitMinutes property.
func (o *DriveAta) GetSecurityEnhancedEraseUnitMinutes(ctx context.Context) (securityEnhancedEraseUnitMinutes int32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SecurityEnhancedEraseUnitMinutes").Store(&securityEnhancedEraseUnitMinutes)
	return
}

// GetSecurityFrozen gets org.freedesktop.UDisks2.Drive.Ata.SecurityFrozen property.
func (o *DriveAta) GetSecurityFrozen(ctx context.Context) (securityFrozen bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceDriveAta, "SecurityFrozen").Store(&securityFrozen)
	return
}

// NewBlock creates and allocates org.freedesktop.UDisks2.Block.
func NewBlock(object dbus.BusObject) *Block {
	return &Block{object}
}

// Block implements org.freedesktop.UDisks2.Block D-Bus interface.
type Block struct {
	object dbus.BusObject
}

// AddConfigurationItem calls org.freedesktop.UDisks2.Block.AddConfigurationItem method.
func (o *Block) AddConfigurationItem(ctx context.Context, item struct {
	V0 string
	V1 map[string]dbus.Variant
}, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".AddConfigurationItem", 0, item, options).Store()
	return
}

// RemoveConfigurationItem calls org.freedesktop.UDisks2.Block.RemoveConfigurationItem method.
func (o *Block) RemoveConfigurationItem(ctx context.Context, item struct {
	V0 string
	V1 map[string]dbus.Variant
}, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".RemoveConfigurationItem", 0, item, options).Store()
	return
}

// UpdateConfigurationItem calls org.freedesktop.UDisks2.Block.UpdateConfigurationItem method.
func (o *Block) UpdateConfigurationItem(ctx context.Context, oldItem struct {
	V0 string
	V1 map[string]dbus.Variant
}, newItem struct {
	V0 string
	V1 map[string]dbus.Variant
}, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".UpdateConfigurationItem", 0, oldItem, newItem, options).Store()
	return
}

// GetSecretConfiguration calls org.freedesktop.UDisks2.Block.GetSecretConfiguration method.
func (o *Block) GetSecretConfiguration(ctx context.Context, options map[string]dbus.Variant) (configuration []struct {
	V0 string
	V1 map[string]dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".GetSecretConfiguration", 0, options).Store(&configuration)
	return
}

// Format calls org.freedesktop.UDisks2.Block.Format method.
func (o *Block) Format(ctx context.Context, inType string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".Format", 0, inType, options).Store()
	return
}

// OpenForBackup calls org.freedesktop.UDisks2.Block.OpenForBackup method.
//
// Annotations:
//   @org.gtk.GDBus.C.UnixFD = 1
func (o *Block) OpenForBackup(ctx context.Context, options map[string]dbus.Variant) (fd dbus.UnixFD, err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".OpenForBackup", 0, options).Store(&fd)
	return
}

// OpenForRestore calls org.freedesktop.UDisks2.Block.OpenForRestore method.
//
// Annotations:
//   @org.gtk.GDBus.C.UnixFD = 1
func (o *Block) OpenForRestore(ctx context.Context, options map[string]dbus.Variant) (fd dbus.UnixFD, err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".OpenForRestore", 0, options).Store(&fd)
	return
}

// OpenForBenchmark calls org.freedesktop.UDisks2.Block.OpenForBenchmark method.
//
// Annotations:
//   @org.gtk.GDBus.C.UnixFD = 1
func (o *Block) OpenForBenchmark(ctx context.Context, options map[string]dbus.Variant) (fd dbus.UnixFD, err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".OpenForBenchmark", 0, options).Store(&fd)
	return
}

// OpenDevice calls org.freedesktop.UDisks2.Block.OpenDevice method.
//
// Annotations:
//   @org.gtk.GDBus.C.UnixFD = 1
func (o *Block) OpenDevice(ctx context.Context, mode string, options map[string]dbus.Variant) (fd dbus.UnixFD, err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".OpenDevice", 0, mode, options).Store(&fd)
	return
}

// Rescan calls org.freedesktop.UDisks2.Block.Rescan method.
func (o *Block) Rescan(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceBlock+".Rescan", 0, options).Store()
	return
}

// GetDevice gets org.freedesktop.UDisks2.Block.Device property.
func (o *Block) GetDevice(ctx context.Context) (device []byte, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "Device").Store(&device)
	return
}

// GetPreferredDevice gets org.freedesktop.UDisks2.Block.PreferredDevice property.
func (o *Block) GetPreferredDevice(ctx context.Context) (preferredDevice []byte, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "PreferredDevice").Store(&preferredDevice)
	return
}

// GetSymlinks gets org.freedesktop.UDisks2.Block.Symlinks property.
func (o *Block) GetSymlinks(ctx context.Context) (symlinks [][]byte, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "Symlinks").Store(&symlinks)
	return
}

// GetDeviceNumber gets org.freedesktop.UDisks2.Block.DeviceNumber property.
func (o *Block) GetDeviceNumber(ctx context.Context) (deviceNumber uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "DeviceNumber").Store(&deviceNumber)
	return
}

// GetId gets org.freedesktop.UDisks2.Block.Id property.
func (o *Block) GetId(ctx context.Context) (id string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "Id").Store(&id)
	return
}

// GetSize gets org.freedesktop.UDisks2.Block.Size property.
func (o *Block) GetSize(ctx context.Context) (size uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "Size").Store(&size)
	return
}

// GetReadOnly gets org.freedesktop.UDisks2.Block.ReadOnly property.
func (o *Block) GetReadOnly(ctx context.Context) (readOnly bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "ReadOnly").Store(&readOnly)
	return
}

// GetDrive gets org.freedesktop.UDisks2.Block.Drive property.
func (o *Block) GetDrive(ctx context.Context) (drive dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "Drive").Store(&drive)
	return
}

// GetMDRaid gets org.freedesktop.UDisks2.Block.MDRaid property.
func (o *Block) GetMDRaid(ctx context.Context) (mDRaid dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "MDRaid").Store(&mDRaid)
	return
}

// GetMDRaidMember gets org.freedesktop.UDisks2.Block.MDRaidMember property.
func (o *Block) GetMDRaidMember(ctx context.Context) (mDRaidMember dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "MDRaidMember").Store(&mDRaidMember)
	return
}

// GetIdUsage gets org.freedesktop.UDisks2.Block.IdUsage property.
func (o *Block) GetIdUsage(ctx context.Context) (idUsage string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "IdUsage").Store(&idUsage)
	return
}

// GetIdType gets org.freedesktop.UDisks2.Block.IdType property.
func (o *Block) GetIdType(ctx context.Context) (idType string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "IdType").Store(&idType)
	return
}

// GetIdVersion gets org.freedesktop.UDisks2.Block.IdVersion property.
func (o *Block) GetIdVersion(ctx context.Context) (idVersion string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "IdVersion").Store(&idVersion)
	return
}

// GetIdLabel gets org.freedesktop.UDisks2.Block.IdLabel property.
func (o *Block) GetIdLabel(ctx context.Context) (idLabel string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "IdLabel").Store(&idLabel)
	return
}

// GetIdUUID gets org.freedesktop.UDisks2.Block.IdUUID property.
func (o *Block) GetIdUUID(ctx context.Context) (idUUID string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "IdUUID").Store(&idUUID)
	return
}

// GetConfiguration gets org.freedesktop.UDisks2.Block.Configuration property.
func (o *Block) GetConfiguration(ctx context.Context) (configuration []struct {
	V0 string
	V1 map[string]dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "Configuration").Store(&configuration)
	return
}

// GetCryptoBackingDevice gets org.freedesktop.UDisks2.Block.CryptoBackingDevice property.
func (o *Block) GetCryptoBackingDevice(ctx context.Context) (cryptoBackingDevice dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "CryptoBackingDevice").Store(&cryptoBackingDevice)
	return
}

// GetHintPartitionable gets org.freedesktop.UDisks2.Block.HintPartitionable property.
func (o *Block) GetHintPartitionable(ctx context.Context) (hintPartitionable bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "HintPartitionable").Store(&hintPartitionable)
	return
}

// GetHintSystem gets org.freedesktop.UDisks2.Block.HintSystem property.
func (o *Block) GetHintSystem(ctx context.Context) (hintSystem bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "HintSystem").Store(&hintSystem)
	return
}

// GetHintIgnore gets org.freedesktop.UDisks2.Block.HintIgnore property.
func (o *Block) GetHintIgnore(ctx context.Context) (hintIgnore bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "HintIgnore").Store(&hintIgnore)
	return
}

// GetHintAuto gets org.freedesktop.UDisks2.Block.HintAuto property.
func (o *Block) GetHintAuto(ctx context.Context) (hintAuto bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "HintAuto").Store(&hintAuto)
	return
}

// GetHintName gets org.freedesktop.UDisks2.Block.HintName property.
func (o *Block) GetHintName(ctx context.Context) (hintName string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "HintName").Store(&hintName)
	return
}

// GetHintIconName gets org.freedesktop.UDisks2.Block.HintIconName property.
func (o *Block) GetHintIconName(ctx context.Context) (hintIconName string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "HintIconName").Store(&hintIconName)
	return
}

// GetHintSymbolicIconName gets org.freedesktop.UDisks2.Block.HintSymbolicIconName property.
func (o *Block) GetHintSymbolicIconName(ctx context.Context) (hintSymbolicIconName string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "HintSymbolicIconName").Store(&hintSymbolicIconName)
	return
}

// GetUserspaceMountOptions gets org.freedesktop.UDisks2.Block.UserspaceMountOptions property.
func (o *Block) GetUserspaceMountOptions(ctx context.Context) (userspaceMountOptions []string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceBlock, "UserspaceMountOptions").Store(&userspaceMountOptions)
	return
}

// NewPartitionTable creates and allocates org.freedesktop.UDisks2.PartitionTable.
func NewPartitionTable(object dbus.BusObject) *PartitionTable {
	return &PartitionTable{object}
}

// PartitionTable implements org.freedesktop.UDisks2.PartitionTable D-Bus interface.
type PartitionTable struct {
	object dbus.BusObject
}

// CreatePartition calls org.freedesktop.UDisks2.PartitionTable.CreatePartition method.
func (o *PartitionTable) CreatePartition(ctx context.Context, offset uint64, size uint64, inType string, name string, options map[string]dbus.Variant) (createdPartition dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, InterfacePartitionTable+".CreatePartition", 0, offset, size, inType, name, options).Store(&createdPartition)
	return
}

// CreatePartitionAndFormat calls org.freedesktop.UDisks2.PartitionTable.CreatePartitionAndFormat method.
func (o *PartitionTable) CreatePartitionAndFormat(ctx context.Context, offset uint64, size uint64, inType string, name string, options map[string]dbus.Variant, formatType string, formatOptions map[string]dbus.Variant) (createdPartition dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, InterfacePartitionTable+".CreatePartitionAndFormat", 0, offset, size, inType, name, options, formatType, formatOptions).Store(&createdPartition)
	return
}

// GetPartitions gets org.freedesktop.UDisks2.PartitionTable.Partitions property.
func (o *PartitionTable) GetPartitions(ctx context.Context) (partitions []dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartitionTable, "Partitions").Store(&partitions)
	return
}

// GetType gets org.freedesktop.UDisks2.PartitionTable.Type property.
func (o *PartitionTable) GetType(ctx context.Context) (vType string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartitionTable, "Type").Store(&vType)
	return
}

// NewPartition creates and allocates org.freedesktop.UDisks2.Partition.
func NewPartition(object dbus.BusObject) *Partition {
	return &Partition{object}
}

// Partition implements org.freedesktop.UDisks2.Partition D-Bus interface.
type Partition struct {
	object dbus.BusObject
}

// SetType calls org.freedesktop.UDisks2.Partition.SetType method.
func (o *Partition) SetType(ctx context.Context, inType string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfacePartition+".SetType", 0, inType, options).Store()
	return
}

// SetName calls org.freedesktop.UDisks2.Partition.SetName method.
func (o *Partition) SetName(ctx context.Context, name string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfacePartition+".SetName", 0, name, options).Store()
	return
}

// SetFlags calls org.freedesktop.UDisks2.Partition.SetFlags method.
func (o *Partition) SetFlags(ctx context.Context, flags uint64, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfacePartition+".SetFlags", 0, flags, options).Store()
	return
}

// Resize calls org.freedesktop.UDisks2.Partition.Resize method.
func (o *Partition) Resize(ctx context.Context, size uint64, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfacePartition+".Resize", 0, size, options).Store()
	return
}

// Delete calls org.freedesktop.UDisks2.Partition.Delete method.
func (o *Partition) Delete(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfacePartition+".Delete", 0, options).Store()
	return
}

// GetNumber gets org.freedesktop.UDisks2.Partition.Number property.
func (o *Partition) GetNumber(ctx context.Context) (number uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "Number").Store(&number)
	return
}

// GetType gets org.freedesktop.UDisks2.Partition.Type property.
func (o *Partition) GetType(ctx context.Context) (vType string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "Type").Store(&vType)
	return
}

// GetFlags gets org.freedesktop.UDisks2.Partition.Flags property.
func (o *Partition) GetFlags(ctx context.Context) (flags uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "Flags").Store(&flags)
	return
}

// GetOffset gets org.freedesktop.UDisks2.Partition.Offset property.
func (o *Partition) GetOffset(ctx context.Context) (offset uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "Offset").Store(&offset)
	return
}

// GetSize gets org.freedesktop.UDisks2.Partition.Size property.
func (o *Partition) GetSize(ctx context.Context) (size uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "Size").Store(&size)
	return
}

// GetName gets org.freedesktop.UDisks2.Partition.Name property.
func (o *Partition) GetName(ctx context.Context) (name string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "Name").Store(&name)
	return
}

// GetUUID gets org.freedesktop.UDisks2.Partition.UUID property.
func (o *Partition) GetUUID(ctx context.Context) (uUID string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "UUID").Store(&uUID)
	return
}

// GetTable gets org.freedesktop.UDisks2.Partition.Table property.
func (o *Partition) GetTable(ctx context.Context) (table dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "Table").Store(&table)
	return
}

// GetIsContainer gets org.freedesktop.UDisks2.Partition.IsContainer property.
func (o *Partition) GetIsContainer(ctx context.Context) (isContainer bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "IsContainer").Store(&isContainer)
	return
}

// GetIsContained gets org.freedesktop.UDisks2.Partition.IsContained property.
func (o *Partition) GetIsContained(ctx context.Context) (isContained bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfacePartition, "IsContained").Store(&isContained)
	return
}

// NewFilesystem creates and allocates org.freedesktop.UDisks2.Filesystem.
func NewFilesystem(object dbus.BusObject) *Filesystem {
	return &Filesystem{object}
}

// Filesystem implements org.freedesktop.UDisks2.Filesystem D-Bus interface.
type Filesystem struct {
	object dbus.BusObject
}

// SetLabel calls org.freedesktop.UDisks2.Filesystem.SetLabel method.
func (o *Filesystem) SetLabel(ctx context.Context, label string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceFilesystem+".SetLabel", 0, label, options).Store()
	return
}

// Mount calls org.freedesktop.UDisks2.Filesystem.Mount method.
func (o *Filesystem) Mount(ctx context.Context, options map[string]dbus.Variant) (mountPath string, err error) {
	err = o.object.CallWithContext(ctx, InterfaceFilesystem+".Mount", 0, options).Store(&mountPath)
	return
}

// Unmount calls org.freedesktop.UDisks2.Filesystem.Unmount method.
func (o *Filesystem) Unmount(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceFilesystem+".Unmount", 0, options).Store()
	return
}

// Resize calls org.freedesktop.UDisks2.Filesystem.Resize method.
func (o *Filesystem) Resize(ctx context.Context, size uint64, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceFilesystem+".Resize", 0, size, options).Store()
	return
}

// Check calls org.freedesktop.UDisks2.Filesystem.Check method.
func (o *Filesystem) Check(ctx context.Context, options map[string]dbus.Variant) (consistent bool, err error) {
	err = o.object.CallWithContext(ctx, InterfaceFilesystem+".Check", 0, options).Store(&consistent)
	return
}

// Repair calls org.freedesktop.UDisks2.Filesystem.Repair method.
func (o *Filesystem) Repair(ctx context.Context, options map[string]dbus.Variant) (repaired bool, err error) {
	err = o.object.CallWithContext(ctx, InterfaceFilesystem+".Repair", 0, options).Store(&repaired)
	return
}

// TakeOwnership calls org.freedesktop.UDisks2.Filesystem.TakeOwnership method.
func (o *Filesystem) TakeOwnership(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceFilesystem+".TakeOwnership", 0, options).Store()
	return
}

// GetMountPoints gets org.freedesktop.UDisks2.Filesystem.MountPoints property.
func (o *Filesystem) GetMountPoints(ctx context.Context) (mountPoints [][]byte, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceFilesystem, "MountPoints").Store(&mountPoints)
	return
}

// GetSize gets org.freedesktop.UDisks2.Filesystem.Size property.
func (o *Filesystem) GetSize(ctx context.Context) (size uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceFilesystem, "Size").Store(&size)
	return
}

// NewSwapspace creates and allocates org.freedesktop.UDisks2.Swapspace.
func NewSwapspace(object dbus.BusObject) *Swapspace {
	return &Swapspace{object}
}

// Swapspace implements org.freedesktop.UDisks2.Swapspace D-Bus interface.
type Swapspace struct {
	object dbus.BusObject
}

// Start calls org.freedesktop.UDisks2.Swapspace.Start method.
func (o *Swapspace) Start(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceSwapspace+".Start", 0, options).Store()
	return
}

// Stop calls org.freedesktop.UDisks2.Swapspace.Stop method.
func (o *Swapspace) Stop(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceSwapspace+".Stop", 0, options).Store()
	return
}

// SetLabel calls org.freedesktop.UDisks2.Swapspace.SetLabel method.
func (o *Swapspace) SetLabel(ctx context.Context, label string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceSwapspace+".SetLabel", 0, label, options).Store()
	return
}

// GetActive gets org.freedesktop.UDisks2.Swapspace.Active property.
func (o *Swapspace) GetActive(ctx context.Context) (active bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceSwapspace, "Active").Store(&active)
	return
}

// NewEncrypted creates and allocates org.freedesktop.UDisks2.Encrypted.
func NewEncrypted(object dbus.BusObject) *Encrypted {
	return &Encrypted{object}
}

// Encrypted implements org.freedesktop.UDisks2.Encrypted D-Bus interface.
type Encrypted struct {
	object dbus.BusObject
}

// Unlock calls org.freedesktop.UDisks2.Encrypted.Unlock method.
func (o *Encrypted) Unlock(ctx context.Context, passphrase string, options map[string]dbus.Variant) (cleartextDevice dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, InterfaceEncrypted+".Unlock", 0, passphrase, options).Store(&cleartextDevice)
	return
}

// Lock calls org.freedesktop.UDisks2.Encrypted.Lock method.
func (o *Encrypted) Lock(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceEncrypted+".Lock", 0, options).Store()
	return
}

// ChangePassphrase calls org.freedesktop.UDisks2.Encrypted.ChangePassphrase method.
func (o *Encrypted) ChangePassphrase(ctx context.Context, passphrase string, newPassphrase string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceEncrypted+".ChangePassphrase", 0, passphrase, newPassphrase, options).Store()
	return
}

// Resize calls org.freedesktop.UDisks2.Encrypted.Resize method.
func (o *Encrypted) Resize(ctx context.Context, size uint64, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceEncrypted+".Resize", 0, size, options).Store()
	return
}

// GetChildConfiguration gets org.freedesktop.UDisks2.Encrypted.ChildConfiguration property.
func (o *Encrypted) GetChildConfiguration(ctx context.Context) (childConfiguration []struct {
	V0 string
	V1 map[string]dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceEncrypted, "ChildConfiguration").Store(&childConfiguration)
	return
}

// GetHintEncryptionType gets org.freedesktop.UDisks2.Encrypted.HintEncryptionType property.
func (o *Encrypted) GetHintEncryptionType(ctx context.Context) (hintEncryptionType string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceEncrypted, "HintEncryptionType").Store(&hintEncryptionType)
	return
}

// GetMetadataSize gets org.freedesktop.UDisks2.Encrypted.MetadataSize property.
func (o *Encrypted) GetMetadataSize(ctx context.Context) (metadataSize uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceEncrypted, "MetadataSize").Store(&metadataSize)
	return
}

// GetCleartextDevice gets org.freedesktop.UDisks2.Encrypted.CleartextDevice property.
func (o *Encrypted) GetCleartextDevice(ctx context.Context) (cleartextDevice dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceEncrypted, "CleartextDevice").Store(&cleartextDevice)
	return
}

// NewLoop creates and allocates org.freedesktop.UDisks2.Loop.
func NewLoop(object dbus.BusObject) *Loop {
	return &Loop{object}
}

// Loop implements org.freedesktop.UDisks2.Loop D-Bus interface.
type Loop struct {
	object dbus.BusObject
}

// Delete calls org.freedesktop.UDisks2.Loop.Delete method.
func (o *Loop) Delete(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceLoop+".Delete", 0, options).Store()
	return
}

// SetAutoclear calls org.freedesktop.UDisks2.Loop.SetAutoclear method.
func (o *Loop) SetAutoclear(ctx context.Context, value bool, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceLoop+".SetAutoclear", 0, value, options).Store()
	return
}

// GetBackingFile gets org.freedesktop.UDisks2.Loop.BackingFile property.
func (o *Loop) GetBackingFile(ctx context.Context) (backingFile []byte, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceLoop, "BackingFile").Store(&backingFile)
	return
}

// GetAutoclear gets org.freedesktop.UDisks2.Loop.Autoclear property.
func (o *Loop) GetAutoclear(ctx context.Context) (autoclear bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceLoop, "Autoclear").Store(&autoclear)
	return
}

// GetSetupByUID gets org.freedesktop.UDisks2.Loop.SetupByUID property.
func (o *Loop) GetSetupByUID(ctx context.Context) (setupByUID uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceLoop, "SetupByUID").Store(&setupByUID)
	return
}

// NewMDRaid creates and allocates org.freedesktop.UDisks2.MDRaid.
func NewMDRaid(object dbus.BusObject) *MDRaid {
	return &MDRaid{object}
}

// MDRaid implements org.freedesktop.UDisks2.MDRaid D-Bus interface.
type MDRaid struct {
	object dbus.BusObject
}

// Start calls org.freedesktop.UDisks2.MDRaid.Start method.
func (o *MDRaid) Start(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceMDRaid+".Start", 0, options).Store()
	return
}

// Stop calls org.freedesktop.UDisks2.MDRaid.Stop method.
func (o *MDRaid) Stop(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceMDRaid+".Stop", 0, options).Store()
	return
}

// RemoveDevice calls org.freedesktop.UDisks2.MDRaid.RemoveDevice method.
func (o *MDRaid) RemoveDevice(ctx context.Context, device dbus.ObjectPath, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceMDRaid+".RemoveDevice", 0, device, options).Store()
	return
}

// AddDevice calls org.freedesktop.UDisks2.MDRaid.AddDevice method.
func (o *MDRaid) AddDevice(ctx context.Context, device dbus.ObjectPath, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceMDRaid+".AddDevice", 0, device, options).Store()
	return
}

// SetBitmapLocation calls org.freedesktop.UDisks2.MDRaid.SetBitmapLocation method.
func (o *MDRaid) SetBitmapLocation(ctx context.Context, value []byte, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceMDRaid+".SetBitmapLocation", 0, value, options).Store()
	return
}

// RequestSyncAction calls org.freedesktop.UDisks2.MDRaid.RequestSyncAction method.
func (o *MDRaid) RequestSyncAction(ctx context.Context, syncAction string, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceMDRaid+".RequestSyncAction", 0, syncAction, options).Store()
	return
}

// Delete calls org.freedesktop.UDisks2.MDRaid.Delete method.
func (o *MDRaid) Delete(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceMDRaid+".Delete", 0, options).Store()
	return
}

// GetUUID gets org.freedesktop.UDisks2.MDRaid.UUID property.
func (o *MDRaid) GetUUID(ctx context.Context) (uUID string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "UUID").Store(&uUID)
	return
}

// GetName gets org.freedesktop.UDisks2.MDRaid.Name property.
func (o *MDRaid) GetName(ctx context.Context) (name string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "Name").Store(&name)
	return
}

// GetLevel gets org.freedesktop.UDisks2.MDRaid.Level property.
func (o *MDRaid) GetLevel(ctx context.Context) (level string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "Level").Store(&level)
	return
}

// GetNumDevices gets org.freedesktop.UDisks2.MDRaid.NumDevices property.
func (o *MDRaid) GetNumDevices(ctx context.Context) (numDevices uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "NumDevices").Store(&numDevices)
	return
}

// GetSize gets org.freedesktop.UDisks2.MDRaid.Size property.
func (o *MDRaid) GetSize(ctx context.Context) (size uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "Size").Store(&size)
	return
}

// GetSyncAction gets org.freedesktop.UDisks2.MDRaid.SyncAction property.
func (o *MDRaid) GetSyncAction(ctx context.Context) (syncAction string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "SyncAction").Store(&syncAction)
	return
}

// GetSyncCompleted gets org.freedesktop.UDisks2.MDRaid.SyncCompleted property.
func (o *MDRaid) GetSyncCompleted(ctx context.Context) (syncCompleted float64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "SyncCompleted").Store(&syncCompleted)
	return
}

// GetSyncRate gets org.freedesktop.UDisks2.MDRaid.SyncRate property.
func (o *MDRaid) GetSyncRate(ctx context.Context) (syncRate uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "SyncRate").Store(&syncRate)
	return
}

// GetSyncRemainingTime gets org.freedesktop.UDisks2.MDRaid.SyncRemainingTime property.
func (o *MDRaid) GetSyncRemainingTime(ctx context.Context) (syncRemainingTime uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "SyncRemainingTime").Store(&syncRemainingTime)
	return
}

// GetDegraded gets org.freedesktop.UDisks2.MDRaid.Degraded property.
func (o *MDRaid) GetDegraded(ctx context.Context) (degraded uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "Degraded").Store(&degraded)
	return
}

// GetBitmapLocation gets org.freedesktop.UDisks2.MDRaid.BitmapLocation property.
func (o *MDRaid) GetBitmapLocation(ctx context.Context) (bitmapLocation []byte, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "BitmapLocation").Store(&bitmapLocation)
	return
}

// GetChunkSize gets org.freedesktop.UDisks2.MDRaid.ChunkSize property.
func (o *MDRaid) GetChunkSize(ctx context.Context) (chunkSize uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "ChunkSize").Store(&chunkSize)
	return
}

// GetActiveDevices gets org.freedesktop.UDisks2.MDRaid.ActiveDevices property.
func (o *MDRaid) GetActiveDevices(ctx context.Context) (activeDevices []struct {
	V0 dbus.ObjectPath
	V1 int32
	V2 []string
	V3 uint64
	V4 map[string]dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "ActiveDevices").Store(&activeDevices)
	return
}

// GetChildConfiguration gets org.freedesktop.UDisks2.MDRaid.ChildConfiguration property.
func (o *MDRaid) GetChildConfiguration(ctx context.Context) (childConfiguration []struct {
	V0 string
	V1 map[string]dbus.Variant
}, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "ChildConfiguration").Store(&childConfiguration)
	return
}

// GetRunning gets org.freedesktop.UDisks2.MDRaid.Running property.
func (o *MDRaid) GetRunning(ctx context.Context) (running bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceMDRaid, "Running").Store(&running)
	return
}

// NewJob creates and allocates org.freedesktop.UDisks2.Job.
func NewJob(object dbus.BusObject) *Job {
	return &Job{object}
}

// Job implements org.freedesktop.UDisks2.Job D-Bus interface.
type Job struct {
	object dbus.BusObject
}

// Cancel calls org.freedesktop.UDisks2.Job.Cancel method.
func (o *Job) Cancel(ctx context.Context, options map[string]dbus.Variant) (err error) {
	err = o.object.CallWithContext(ctx, InterfaceJob+".Cancel", 0, options).Store()
	return
}

// GetOperation gets org.freedesktop.UDisks2.Job.Operation property.
func (o *Job) GetOperation(ctx context.Context) (operation string, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "Operation").Store(&operation)
	return
}

// GetProgress gets org.freedesktop.UDisks2.Job.Progress property.
func (o *Job) GetProgress(ctx context.Context) (progress float64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "Progress").Store(&progress)
	return
}

// GetProgressValid gets org.freedesktop.UDisks2.Job.ProgressValid property.
func (o *Job) GetProgressValid(ctx context.Context) (progressValid bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "ProgressValid").Store(&progressValid)
	return
}

// GetBytes gets org.freedesktop.UDisks2.Job.Bytes property.
func (o *Job) GetBytes(ctx context.Context) (bytes uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "Bytes").Store(&bytes)
	return
}

// GetRate gets org.freedesktop.UDisks2.Job.Rate property.
func (o *Job) GetRate(ctx context.Context) (rate uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "Rate").Store(&rate)
	return
}

// GetStartTime gets org.freedesktop.UDisks2.Job.StartTime property.
func (o *Job) GetStartTime(ctx context.Context) (startTime uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "StartTime").Store(&startTime)
	return
}

// GetExpectedEndTime gets org.freedesktop.UDisks2.Job.ExpectedEndTime property.
func (o *Job) GetExpectedEndTime(ctx context.Context) (expectedEndTime uint64, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "ExpectedEndTime").Store(&expectedEndTime)
	return
}

// GetObjects gets org.freedesktop.UDisks2.Job.Objects property.
func (o *Job) GetObjects(ctx context.Context) (objects []dbus.ObjectPath, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "Objects").Store(&objects)
	return
}

// GetStartedByUID gets org.freedesktop.UDisks2.Job.StartedByUID property.
func (o *Job) GetStartedByUID(ctx context.Context) (startedByUID uint32, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "StartedByUID").Store(&startedByUID)
	return
}

// GetCancelable gets org.freedesktop.UDisks2.Job.Cancelable property.
func (o *Job) GetCancelable(ctx context.Context) (cancelable bool, err error) {
	err = o.object.CallWithContext(ctx, "org.freedesktop.DBus.Properties.Get", 0, InterfaceJob, "Cancelable").Store(&cancelable)
	return
}

// JobCompletedSignal represents org.freedesktop.UDisks2.Job.Completed signal.
type JobCompletedSignal struct {
	sender string
	Path   dbus.ObjectPath
	Body   *JobCompletedSignalBody
}

// Name returns the signal's name.
func (s *JobCompletedSignal) Name() string {
	return "Completed"
}

// Interface returns the signal's interface.
func (s *JobCompletedSignal) Interface() string {
	return InterfaceJob
}

// Sender returns the signal's sender unique name.
func (s *JobCompletedSignal) Sender() string {
	return s.sender
}

func (s *JobCompletedSignal) path() dbus.ObjectPath {
	return s.Path
}

func (s *JobCompletedSignal) values() []interface{} {
	return []interface{}{s.Body.Success, s.Body.Message}
}

// JobCompletedSignalBody is body container.
type JobCompletedSignalBody struct {
	Success bool
	Message string
}
