/*
 *  This file is part of Garuda Settings Manager.
 *
 *  Ramon Buldó <ramon@manjaro.org>
 *
 *  Garuda Settings Manager is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Garuda Settings Manager is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Garuda Settings Manager.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LANGUAGELISTVIEWDELEGATE_H
#define LANGUAGELISTVIEWDELEGATE_H

#include <QtGui/QPainter>
#include <QtWidgets/QStyledItemDelegate>

class LanguageListViewDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit LanguageListViewDelegate( QObject* parent = 0 );
    virtual ~LanguageListViewDelegate();

    void paint( QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index ) const;
    QSize sizeHint( const QStyleOptionViewItem& option, const QModelIndex& index ) const;

signals:

public slots:

};

#endif // LANGUAGELISTVIEWDELEGATE_H
