/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <sys/wait.h>
#include <langinfo.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#define GAME_HUB_UTILS_NAME_CHARS_TO_STRIP "!@#$%^&*()-_+=:~`;?'\"<>,./\\|’“”„«»™℠®©"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*GameHubUtilsFuture) (gpointer user_data);
typedef void (*GameHubUtilsFutureBoolean) (gboolean _result_, gpointer user_data);
typedef void (*GameHubUtilsFutureResult) (gconstpointer _result_, gpointer user_data);
typedef void (*GameHubUtilsFutureResult2) (gconstpointer t, gconstpointer t2, gpointer user_data);
typedef GNotification* (*GameHubUtilsNotificationConfigureDelegate) (GNotification* notification, gpointer user_data);

#define GAME_HUB_UTILS_TYPE_WORKER (game_hub_utils_worker_get_type ())
#define GAME_HUB_UTILS_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_WORKER, GameHubUtilsWorker))
#define GAME_HUB_UTILS_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_WORKER, GameHubUtilsWorkerClass))
#define GAME_HUB_UTILS_IS_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_WORKER))
#define GAME_HUB_UTILS_IS_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_WORKER))
#define GAME_HUB_UTILS_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_WORKER, GameHubUtilsWorkerClass))

typedef struct _GameHubUtilsWorker GameHubUtilsWorker;
typedef struct _GameHubUtilsWorkerClass GameHubUtilsWorkerClass;
typedef struct _GameHubUtilsWorkerPrivate GameHubUtilsWorkerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GameHubUtilsParamSpecWorker GameHubUtilsParamSpecWorker;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GAME_HUB_UTILS_TYPE_RUN_TASK (game_hub_utils_run_task_get_type ())
#define GAME_HUB_UTILS_RUN_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTask))
#define GAME_HUB_UTILS_RUN_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTaskClass))
#define GAME_HUB_UTILS_IS_RUN_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK))
#define GAME_HUB_UTILS_IS_RUN_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_RUN_TASK))
#define GAME_HUB_UTILS_RUN_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTaskClass))

typedef struct _GameHubUtilsRunTask GameHubUtilsRunTask;
typedef struct _GameHubUtilsRunTaskClass GameHubUtilsRunTaskClass;
typedef struct _GameHubUtilsRunTaskPrivate GameHubUtilsRunTaskPrivate;

#define GAME_HUB_DATA_TWEAKS_TYPE_TWEAK (game_hub_data_tweaks_tweak_get_type ())
#define GAME_HUB_DATA_TWEAKS_TWEAK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweak))
#define GAME_HUB_DATA_TWEAKS_TWEAK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweakClass))
#define GAME_HUB_DATA_TWEAKS_IS_TWEAK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK))
#define GAME_HUB_DATA_TWEAKS_IS_TWEAK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK))
#define GAME_HUB_DATA_TWEAKS_TWEAK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweakClass))

typedef struct _GameHubDataTweaksTweak GameHubDataTweaksTweak;
typedef struct _GameHubDataTweaksTweakClass GameHubDataTweaksTweakClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT (game_hub_utils_run_task_result_get_type ())
#define GAME_HUB_UTILS_RUN_TASK_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResult))
#define GAME_HUB_UTILS_RUN_TASK_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResultClass))
#define GAME_HUB_UTILS_RUN_TASK_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT))
#define GAME_HUB_UTILS_RUN_TASK_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT))
#define GAME_HUB_UTILS_RUN_TASK_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResultClass))

typedef struct _GameHubUtilsRunTaskResult GameHubUtilsRunTaskResult;
typedef struct _GameHubUtilsRunTaskResultClass GameHubUtilsRunTaskResultClass;
#define _game_hub_utils_run_task_result_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_run_task_result_unref (var), NULL)))
#define _game_hub_utils_run_task_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_run_task_unref (var), NULL)))
typedef struct _Block121Data Block121Data;
typedef struct _GameHubUtilsRunTaskRunSyncThreadData GameHubUtilsRunTaskRunSyncThreadData;
typedef struct _Block122Data Block122Data;
typedef struct _GameHubUtilsRunTaskRunAsyncData GameHubUtilsRunTaskRunAsyncData;
typedef struct _GameHubUtilsRunTaskResultPrivate GameHubUtilsRunTaskResultPrivate;
typedef struct _GameHubUtilsRunTaskParamSpecResult GameHubUtilsRunTaskParamSpecResult;
typedef struct _GameHubUtilsParamSpecRunTask GameHubUtilsParamSpecRunTask;
#define _game_hub_utils_worker_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_worker_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block123Data Block123Data;
typedef struct _GameHubUtilsSleepAsyncData GameHubUtilsSleepAsyncData;
typedef struct _Block124Data Block124Data;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
typedef struct _GameHubUtilsComputeFileChecksumData GameHubUtilsComputeFileChecksumData;

#define GAME_HUB_TYPE_APPLICATION (game_hub_application_get_type ())
#define GAME_HUB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_TYPE_APPLICATION, GameHubApplication))
#define GAME_HUB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_TYPE_APPLICATION, GameHubApplicationClass))
#define GAME_HUB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_TYPE_APPLICATION))
#define GAME_HUB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_TYPE_APPLICATION))
#define GAME_HUB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_TYPE_APPLICATION, GameHubApplicationClass))

typedef struct _GameHubApplication GameHubApplication;
typedef struct _GameHubApplicationClass GameHubApplicationClass;

#define GAME_HUB_UTILS_TYPE_LOGGER (game_hub_utils_logger_get_type ())
#define GAME_HUB_UTILS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_LOGGER, GameHubUtilsLogger))
#define GAME_HUB_UTILS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_LOGGER, GameHubUtilsLoggerClass))
#define GAME_HUB_UTILS_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_LOGGER))
#define GAME_HUB_UTILS_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_LOGGER))
#define GAME_HUB_UTILS_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_LOGGER, GameHubUtilsLoggerClass))

typedef struct _GameHubUtilsLogger GameHubUtilsLogger;
typedef struct _GameHubUtilsLoggerClass GameHubUtilsLoggerClass;
typedef struct _GameHubUtilsLoggerPrivate GameHubUtilsLoggerPrivate;
enum  {
	GAME_HUB_UTILS_LOGGER_0_PROPERTY,
	GAME_HUB_UTILS_LOGGER_NUM_PROPERTIES
};
static GParamSpec* game_hub_utils_logger_properties[GAME_HUB_UTILS_LOGGER_NUM_PROPERTIES];
typedef enum  {
	GAME_HUB_UTILS_LOGGER_LOG_LEVEL_DEBUG,
	GAME_HUB_UTILS_LOGGER_LOG_LEVEL_INFO,
	GAME_HUB_UTILS_LOGGER_LOG_LEVEL_NOTIFY,
	GAME_HUB_UTILS_LOGGER_LOG_LEVEL_WARN,
	GAME_HUB_UTILS_LOGGER_LOG_LEVEL_ERROR,
	GAME_HUB_UTILS_LOGGER_LOG_LEVEL_FATAL
} GameHubUtilsLoggerLogLevel;

#define GAME_HUB_UTILS_LOGGER_TYPE_LOG_LEVEL (game_hub_utils_logger_log_level_get_type ())
typedef enum  {
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLACK,
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_RED,
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_GREEN,
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_YELLOW,
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLUE,
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_MAGENTA,
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_CYAN,
	GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_WHITE
} GameHubUtilsLoggerConsoleColor;

#define GAME_HUB_UTILS_LOGGER_TYPE_CONSOLE_COLOR (game_hub_utils_logger_console_color_get_type ())

struct _GameHubUtilsWorker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubUtilsWorkerPrivate * priv;
	gchar* name;
	GameHubUtilsFuture worker;
	gpointer worker_target;
	GDestroyNotify worker_target_destroy_notify;
	gboolean log;
};

struct _GameHubUtilsWorkerClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubUtilsWorker *self);
};

struct _GameHubUtilsParamSpecWorker {
	GParamSpec parent_instance;
};

struct _GameHubUtilsRunTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubUtilsRunTaskPrivate * priv;
};

struct _GameHubUtilsRunTaskClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubUtilsRunTask *self);
};

struct _GameHubUtilsRunTaskPrivate {
	gchar** _cmd;
	gint _cmd_length1;
	gint __cmd_size_;
	gchar* _dir;
	gchar** _env;
	gint _env_length1;
	gint __env_size_;
	gboolean _override_runtime;
	gboolean _log;
	GameHubDataTweaksTweak** _tweaks;
	gint _tweaks_length1;
	gint __tweaks_size_;
	gboolean _expanded;
};

struct _Block121Data {
	int _ref_count_;
	GameHubUtilsRunTask* self;
	GameHubUtilsRunTaskResult* _result_;
	gboolean capture_output;
	gpointer _async_data_;
};

struct _GameHubUtilsRunTaskRunSyncThreadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubUtilsRunTask* self;
	gboolean capture_output;
	GameHubUtilsRunTaskResult* result;
	Block121Data* _data121_;
	GameHubUtilsRunTaskResult* _tmp0_;
};

struct _Block122Data {
	int _ref_count_;
	GameHubUtilsRunTask* self;
	GameHubUtilsRunTaskResult* _result_;
	gpointer _async_data_;
};

struct _GameHubUtilsRunTaskRunAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubUtilsRunTask* self;
	gboolean wait;
	GameHubUtilsRunTaskResult* result;
	Block122Data* _data122_;
	GPid pid;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GPid _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GameHubUtilsRunTaskResult* _tmp6_;
	GameHubUtilsRunTaskResult* _tmp7_;
	GError* _inner_error0_;
};

struct _GameHubUtilsRunTaskResult {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubUtilsRunTaskResultPrivate * priv;
	gint* status;
	gint* exit_code;
	gchar* output;
	gchar* errors;
};

struct _GameHubUtilsRunTaskResultClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubUtilsRunTaskResult *self);
};

struct _GameHubUtilsRunTaskParamSpecResult {
	GParamSpec parent_instance;
};

struct _GameHubUtilsParamSpecRunTask {
	GParamSpec parent_instance;
};

struct _Block123Data {
	int _ref_count_;
	gpointer _async_data_;
};

struct _GameHubUtilsSleepAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	guint interval;
	gint priority;
	Block123Data* _data123_;
};

struct _Block124Data {
	int _ref_count_;
	gchar* hash;
	GFile* file;
	GChecksumType type;
	gpointer _async_data_;
};

struct _GameHubUtilsComputeFileChecksumData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	GChecksumType type;
	gchar* result;
	Block124Data* _data124_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
};

struct _GameHubUtilsLogger {
	GObject parent_instance;
	GameHubUtilsLoggerPrivate * priv;
};

struct _GameHubUtilsLoggerClass {
	GObjectClass parent_class;
};

static gpointer game_hub_utils_worker_parent_class = NULL;
VALA_EXTERN gboolean game_hub_application_log_workers;
VALA_EXTERN GThreadPool* game_hub_utils_threadpool;
GThreadPool* game_hub_utils_threadpool = NULL;
static gint GameHubUtilsRunTask_private_offset;
static gpointer game_hub_utils_run_task_parent_class = NULL;
VALA_EXTERN gboolean game_hub_application_log_verbose;
static gpointer game_hub_utils_run_task_result_parent_class = NULL;
VALA_EXTERN gint game_hub_application_worker_threads;
VALA_EXTERN gchar* game_hub_utils_distro;
VALA_EXTERN GameHubApplication* game_hub_application_instance;
gchar* game_hub_utils_distro = NULL;
static gpointer game_hub_utils_logger_parent_class = NULL;
static GameHubUtilsLoggerLogLevel game_hub_utils_logger__DisplayLevel;
static GameHubUtilsLoggerLogLevel game_hub_utils_logger__DisplayLevel = GAME_HUB_UTILS_LOGGER_LOG_LEVEL_WARN;
static GMutex game_hub_utils_logger_write_mutex;
static GMutex game_hub_utils_logger_write_mutex = {0};
static GRegex* game_hub_utils_logger_msg_file_regex;
static GRegex* game_hub_utils_logger_msg_file_regex = NULL;
static GRegex* game_hub_utils_logger_msg_string_regex;
static GRegex* game_hub_utils_logger_msg_string_regex = NULL;
static GRegex* game_hub_utils_logger_msg_block_regex;
static GRegex* game_hub_utils_logger_msg_block_regex = NULL;
VALA_EXTERN gboolean game_hub_application_log_no_filters;

VALA_EXTERN gpointer game_hub_utils_worker_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_worker_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_param_spec_worker (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void game_hub_utils_value_set_worker (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void game_hub_utils_value_take_worker (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_value_get_worker (const GValue* value);
VALA_EXTERN GType game_hub_utils_worker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsWorker, game_hub_utils_worker_unref)
VALA_EXTERN GameHubUtilsWorker* game_hub_utils_worker_new (const gchar* name,
                                               GameHubUtilsFuture worker,
                                               gpointer worker_target,
                                               GDestroyNotify worker_target_destroy_notify,
                                               gboolean log);
VALA_EXTERN GameHubUtilsWorker* game_hub_utils_worker_construct (GType object_type,
                                                     const gchar* name,
                                                     GameHubUtilsFuture worker,
                                                     gpointer worker_target,
                                                     GDestroyNotify worker_target_destroy_notify,
                                                     gboolean log);
VALA_EXTERN void game_hub_utils_worker_run (GameHubUtilsWorker* self);
static void game_hub_utils_worker_finalize (GameHubUtilsWorker * obj);
static GType game_hub_utils_worker_get_type_once (void);
VALA_EXTERN void game_hub_utils_open_uri (const gchar* uri);
VALA_EXTERN gchar** game_hub_utils_parse_args (const gchar* args,
                                   gint* result_length1);
VALA_EXTERN gpointer game_hub_utils_run_task_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_run_task_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_param_spec_run_task (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void game_hub_utils_value_set_run_task (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void game_hub_utils_value_take_run_task (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_value_get_run_task (const GValue* value);
VALA_EXTERN GType game_hub_utils_run_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsRunTask, game_hub_utils_run_task_unref)
VALA_EXTERN GType game_hub_data_tweaks_tweak_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataTweaksTweak, g_object_unref)
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_new (gchar** cmd,
                                                  gint cmd_length1);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_construct (GType object_type,
                                                        gchar** cmd,
                                                        gint cmd_length1);
static gchar** _vala_array_dup47 (gchar** self,
                           gssize length);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_cmd (GameHubUtilsRunTask* self,
                                                  gchar** cmd,
                                                  gint cmd_length1);
static gchar** _vala_array_dup48 (gchar** self,
                           gssize length);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_dir (GameHubUtilsRunTask* self,
                                                  const gchar* dir);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_env (GameHubUtilsRunTask* self,
                                                  gchar** env,
                                                  gint env_length1);
static gchar** _vala_array_dup49 (gchar** self,
                           gssize length);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_override_runtime (GameHubUtilsRunTask* self,
                                                               gboolean override_runtime);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_log (GameHubUtilsRunTask* self,
                                                  gboolean log);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_tweaks (GameHubUtilsRunTask* self,
                                                     GameHubDataTweaksTweak** tweaks,
                                                     gint tweaks_length1);
static GameHubDataTweaksTweak** _vala_array_dup50 (GameHubDataTweaksTweak** self,
                                            gssize length);
static void game_hub_utils_run_task_expand (GameHubUtilsRunTask* self);
static gchar** _vala_array_dup51 (gchar** self,
                           gssize length);
VALA_EXTERN GeeHashMap* game_hub_data_tweaks_tweak_get_env (GameHubDataTweaksTweak* self);
static gchar** _vala_array_dup52 (gchar** self,
                           gssize length);
static gchar** _vala_array_dup53 (gchar** self,
                           gssize length);
VALA_EXTERN const gchar* game_hub_data_tweaks_tweak_get_command (GameHubDataTweaksTweak* self);
static gchar** _vala_array_dup54 (gchar** self,
                           gssize length);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add59 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add60 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup55 (gchar** self,
                           gssize length);
static void _vala_array_add61 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN gpointer game_hub_utils_run_task_result_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_run_task_result_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_run_task_param_spec_result (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_utils_run_task_value_set_result (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_utils_run_task_value_take_result (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_run_task_value_get_result (const GValue* value);
VALA_EXTERN GType game_hub_utils_run_task_result_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsRunTaskResult, game_hub_utils_run_task_result_unref)
VALA_EXTERN GameHubUtilsRunTaskResult* game_hub_utils_run_task_run_sync (GameHubUtilsRunTask* self,
                                                             gboolean capture_output);
VALA_EXTERN GameHubUtilsRunTaskResult* game_hub_utils_run_task_result_new (gint* status,
                                                               const gchar* output,
                                                               const gchar* errors);
VALA_EXTERN GameHubUtilsRunTaskResult* game_hub_utils_run_task_result_construct (GType object_type,
                                                                     gint* status,
                                                                     const gchar* output,
                                                                     const gchar* errors);
static void game_hub_utils_run_task_run_sync_thread_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_run_task_run_sync_thread (GameHubUtilsRunTask* self,
                                              gboolean capture_output,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN GameHubUtilsRunTaskResult* game_hub_utils_run_task_run_sync_thread_finish (GameHubUtilsRunTask* self,
                                                                           GAsyncResult* _res_);
static gboolean game_hub_utils_run_task_run_sync_thread_co (GameHubUtilsRunTaskRunSyncThreadData* _data_);
static Block121Data* block121_data_ref (Block121Data* _data121_);
static void block121_data_unref (void * _userdata_);
VALA_EXTERN void game_hub_utils_thread (const gchar* name,
                            GameHubUtilsFuture worker,
                            gpointer worker_target,
                            GDestroyNotify worker_target_destroy_notify,
                            gboolean log);
static void __lambda21_ (Block121Data* _data121_);
static gboolean _game_hub_utils_run_task_run_sync_thread_co_gsource_func (gpointer self);
static void ___lambda21__game_hub_utils_future (gpointer self);
static void game_hub_utils_run_task_run_async_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_run_task_run_async (GameHubUtilsRunTask* self,
                                        gboolean wait,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN GameHubUtilsRunTaskResult* game_hub_utils_run_task_run_finish (GameHubUtilsRunTask* self,
                                                               GAsyncResult* _res_);
static gboolean game_hub_utils_run_task_run_async_co (GameHubUtilsRunTaskRunAsyncData* _data_);
static Block122Data* block122_data_ref (Block122Data* _data122_);
static void block122_data_unref (void * _userdata_);
static void ___lambda46_ (Block122Data* _data122_,
                   GPid pid,
                   gint status);
static gboolean _game_hub_utils_run_task_run_async_co_gsource_func (gpointer self);
static void ____lambda46__gchild_watch_func (GPid pid,
                                      gint wait_status,
                                      gpointer self);
static gint* _int_dup (gint* self);
VALA_EXTERN gboolean game_hub_utils_run_task_result_check_status (GameHubUtilsRunTaskResult* self,
                                                      GError** error);
static void game_hub_utils_run_task_result_finalize (GameHubUtilsRunTaskResult * obj);
static GType game_hub_utils_run_task_result_get_type_once (void);
static void game_hub_utils_run_task_finalize (GameHubUtilsRunTask * obj);
static GType game_hub_utils_run_task_get_type_once (void);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run (gchar** cmd,
                                         gint cmd_length1);
VALA_EXTERN GFile* game_hub_utils_find_executable (const gchar* name);
static void ____lambda8_ (GameHubUtilsWorker* w);
static void _____lambda8__gfunc (gpointer data,
                          gpointer self);
VALA_EXTERN gchar* game_hub_utils_get_distro (void);
VALA_EXTERN gchar* game_hub_utils_get_desktop_environment (void);
VALA_EXTERN gchar* game_hub_utils_get_language_name (void);
VALA_EXTERN gboolean game_hub_utils_is_package_installed (const gchar* package);
static void game_hub_utils_sleep_async_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_sleep_async (guint interval,
                                 gint priority,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void game_hub_utils_sleep_finish (GAsyncResult* _res_);
static gboolean game_hub_utils_sleep_async_co (GameHubUtilsSleepAsyncData* _data_);
static Block123Data* block123_data_ref (Block123Data* _data123_);
static void block123_data_unref (void * _userdata_);
static gboolean __lambda22_ (Block123Data* _data123_);
static gboolean ___lambda22__gsource_func (gpointer self);
VALA_EXTERN gchar* game_hub_utils_md5 (const gchar* s);
static void game_hub_utils_compute_file_checksum_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_compute_file_checksum (GFile* file,
                                           GChecksumType type,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN gchar* game_hub_utils_compute_file_checksum_finish (GAsyncResult* _res_);
static gboolean game_hub_utils_compute_file_checksum_co (GameHubUtilsComputeFileChecksumData* _data_);
static Block124Data* block124_data_ref (Block124Data* _data124_);
static void block124_data_unref (void * _userdata_);
static void __lambda44_ (Block124Data* _data124_);
static gboolean _game_hub_utils_compute_file_checksum_co_gsource_func (gpointer self);
static void ___lambda44__game_hub_utils_future (gpointer self);
VALA_EXTERN gchar* game_hub_utils_get_relative_datetime (GDateTime* date_time);
VALA_EXTERN gchar* game_hub_utils_minutes_to_string (gint64 min);
VALA_EXTERN gchar* game_hub_utils_seconds_to_string (gint64 sec);
VALA_EXTERN void game_hub_utils_notify (const gchar* title,
                            const gchar* body,
                            GNotificationPriority priority,
                            GameHubUtilsNotificationConfigureDelegate config,
                            gpointer config_target);
VALA_EXTERN GType game_hub_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubApplication, g_object_unref)
VALA_EXTERN gchar* game_hub_utils_strip_name (const gchar* name,
                                  const gchar* keep,
                                  gboolean move_the);
VALA_EXTERN gchar* game_hub_utils_replace_prefix (const gchar* str,
                                      const gchar* prefix,
                                      const gchar* replacement);
VALA_EXTERN gint* game_hub_utils_compare_versions (gint* v1,
                                       gint v1_length1,
                                       gint* v2,
                                       gint v2_length1);
VALA_EXTERN gint* game_hub_utils_parse_version (const gchar* version,
                                    const gchar* delimiter,
                                    gint* result_length1);
static void _vala_array_add62 (gint* * array,
                        gint* length,
                        gint* size,
                        gint value);
VALA_EXTERN gchar* game_hub_utils_format_version (gint* version,
                                      gint version_length1,
                                      const gchar* delimiter);
static void _vala_array_add63 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN gchar* game_hub_utils_accel_to_string (const gchar* accel);
static void _vala_array_add64 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add65 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add66 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add67 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add68 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add69 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add70 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add71 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add72 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add73 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN gchar* game_hub_utils_markup_accel_tooltip (gchar** accels,
                                            gint accels_length1,
                                            const gchar* description);
static void _vala_array_add74 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add75 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add76 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void game_hub_utils_set_accel_tooltip (GtkWidget* widget,
                                       const gchar* tooltip,
                                       const gchar* accel);
VALA_EXTERN GType game_hub_utils_logger_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsLogger, g_object_unref)
VALA_EXTERN GType game_hub_utils_logger_log_level_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_utils_logger_console_color_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void game_hub_utils_logger_init (void);
static void game_hub_utils_logger_glib_log_func (const gchar* d,
                                          GLogLevelFlags flags,
                                          const gchar* msg);
static void game_hub_utils_logger_write (GameHubUtilsLoggerLogLevel level,
                                  gchar* msg);
VALA_EXTERN GameHubUtilsLoggerLogLevel game_hub_utils_logger_get_DisplayLevel (void);
static void game_hub_utils_logger_set_color_for_level (GameHubUtilsLoggerLogLevel level);
static void game_hub_utils_logger_reset_color (void);
static void game_hub_utils_logger_set_foreground (GameHubUtilsLoggerConsoleColor color);
static void game_hub_utils_logger_set_background (GameHubUtilsLoggerConsoleColor color);
static void game_hub_utils_logger_set_color (GameHubUtilsLoggerConsoleColor c,
                                      gboolean foreground);
static gchar* game_hub_utils_logger_color (GameHubUtilsLoggerConsoleColor c,
                                    gboolean foreground);
static gboolean game_hub_utils_logger_log_filter (const gchar* d,
                                           GLogLevelFlags flags,
                                           const gchar* msg);
VALA_EXTERN GameHubUtilsLogger* game_hub_utils_logger_new (void);
VALA_EXTERN GameHubUtilsLogger* game_hub_utils_logger_construct (GType object_type);
VALA_EXTERN void game_hub_utils_logger_set_DisplayLevel (GameHubUtilsLoggerLogLevel value);
static void game_hub_utils_logger_finalize (GObject * obj);
static GType game_hub_utils_logger_get_type_once (void);
static void _vala_game_hub_utils_logger_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_game_hub_utils_logger_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* GAME_HUB_UTILS_LOGGER_LOG_LEVEL_TO_STRING[6] = {"[DEBUG]\x001b[0m ", "[INFO]\x001b[0m  ", "[NOTIFY]\x001b[0m", "[WARN]\x001b[0m  ", "[ERROR]\x001b[0m ", "[FATAL]\x001b[0m "};
static const gchar* GAME_HUB_UTILS_LOGGER_HIDDEN_DOMAINS[4] = {"GLib", "GLib-GIO", "GdkPixbuf", "Manette"};
static const gchar* GAME_HUB_UTILS_LOGGER_HIDDEN_MESSAGES[1] = {"Loading settings from schema"};

GameHubUtilsWorker*
game_hub_utils_worker_construct (GType object_type,
                                 const gchar* name,
                                 GameHubUtilsFuture worker,
                                 gpointer worker_target,
                                 GDestroyNotify worker_target_destroy_notify,
                                 gboolean log)
{
	GameHubUtilsWorker* self = NULL;
	gchar* _tmp0_;
	GameHubUtilsFuture _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
#line 37 "../src/utils/Utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 37 "../src/utils/Utils.vala"
	self = (GameHubUtilsWorker*) g_type_create_instance (object_type);
#line 39 "../src/utils/Utils.vala"
	_tmp0_ = g_strdup (name);
#line 39 "../src/utils/Utils.vala"
	_g_free0 (self->name);
#line 39 "../src/utils/Utils.vala"
	self->name = _tmp0_;
#line 40 "../src/utils/Utils.vala"
	_tmp1_ = worker;
#line 40 "../src/utils/Utils.vala"
	_tmp1__target = worker_target;
#line 40 "../src/utils/Utils.vala"
	_tmp1__target_destroy_notify = worker_target_destroy_notify;
#line 40 "../src/utils/Utils.vala"
	worker = NULL;
#line 40 "../src/utils/Utils.vala"
	worker_target = NULL;
#line 40 "../src/utils/Utils.vala"
	worker_target_destroy_notify = NULL;
#line 40 "../src/utils/Utils.vala"
	(self->worker_target_destroy_notify == NULL) ? NULL : (self->worker_target_destroy_notify (self->worker_target), NULL);
#line 40 "../src/utils/Utils.vala"
	self->worker = NULL;
#line 40 "../src/utils/Utils.vala"
	self->worker_target = NULL;
#line 40 "../src/utils/Utils.vala"
	self->worker_target_destroy_notify = NULL;
#line 40 "../src/utils/Utils.vala"
	self->worker = _tmp1_;
#line 40 "../src/utils/Utils.vala"
	self->worker_target = _tmp1__target;
#line 40 "../src/utils/Utils.vala"
	self->worker_target_destroy_notify = _tmp1__target_destroy_notify;
#line 41 "../src/utils/Utils.vala"
	self->log = log;
#line 37 "../src/utils/Utils.vala"
	(worker_target_destroy_notify == NULL) ? NULL : (worker_target_destroy_notify (worker_target), NULL);
#line 37 "../src/utils/Utils.vala"
	worker = NULL;
#line 37 "../src/utils/Utils.vala"
	worker_target = NULL;
#line 37 "../src/utils/Utils.vala"
	worker_target_destroy_notify = NULL;
#line 37 "../src/utils/Utils.vala"
	return self;
#line 774 "Utils.c"
}

GameHubUtilsWorker*
game_hub_utils_worker_new (const gchar* name,
                           GameHubUtilsFuture worker,
                           gpointer worker_target,
                           GDestroyNotify worker_target_destroy_notify,
                           gboolean log)
{
#line 37 "../src/utils/Utils.vala"
	return game_hub_utils_worker_construct (GAME_HUB_UTILS_TYPE_WORKER, name, worker, worker_target, worker_target_destroy_notify, log);
#line 786 "Utils.c"
}

void
game_hub_utils_worker_run (GameHubUtilsWorker* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean dbg = FALSE;
	GameHubUtilsFuture _tmp4_;
	gpointer _tmp4__target;
#line 43 "../src/utils/Utils.vala"
	g_return_if_fail (self != NULL);
#line 45 "../src/utils/Utils.vala"
	if (game_hub_application_log_workers) {
#line 45 "../src/utils/Utils.vala"
		_tmp1_ = self->log;
#line 803 "Utils.c"
	} else {
#line 45 "../src/utils/Utils.vala"
		_tmp1_ = FALSE;
#line 807 "Utils.c"
	}
#line 45 "../src/utils/Utils.vala"
	if (_tmp1_) {
#line 811 "Utils.c"
		const gchar* _tmp2_;
#line 45 "../src/utils/Utils.vala"
		_tmp2_ = self->name;
#line 45 "../src/utils/Utils.vala"
		_tmp0_ = !g_str_has_prefix (_tmp2_, "Merging-");
#line 817 "Utils.c"
	} else {
#line 45 "../src/utils/Utils.vala"
		_tmp0_ = FALSE;
#line 821 "Utils.c"
	}
#line 45 "../src/utils/Utils.vala"
	dbg = _tmp0_;
#line 46 "../src/utils/Utils.vala"
	if (dbg) {
#line 827 "Utils.c"
		const gchar* _tmp3_;
#line 46 "../src/utils/Utils.vala"
		_tmp3_ = self->name;
#line 46 "../src/utils/Utils.vala"
		g_debug ("Utils.vala:46: [Worker] %s started", _tmp3_);
#line 833 "Utils.c"
	}
#line 47 "../src/utils/Utils.vala"
	_tmp4_ = self->worker;
#line 47 "../src/utils/Utils.vala"
	_tmp4__target = self->worker_target;
#line 47 "../src/utils/Utils.vala"
	_tmp4_ (_tmp4__target);
#line 48 "../src/utils/Utils.vala"
	if (dbg) {
#line 843 "Utils.c"
		const gchar* _tmp5_;
#line 48 "../src/utils/Utils.vala"
		_tmp5_ = self->name;
#line 48 "../src/utils/Utils.vala"
		g_debug ("Utils.vala:48: [Worker] %s finished", _tmp5_);
#line 849 "Utils.c"
	}
}

static void
game_hub_utils_value_worker_init (GValue* value)
{
#line 32 "../src/utils/Utils.vala"
	value->data[0].v_pointer = NULL;
#line 858 "Utils.c"
}

static void
game_hub_utils_value_worker_free_value (GValue* value)
{
#line 32 "../src/utils/Utils.vala"
	if (value->data[0].v_pointer) {
#line 32 "../src/utils/Utils.vala"
		game_hub_utils_worker_unref (value->data[0].v_pointer);
#line 868 "Utils.c"
	}
}

static void
game_hub_utils_value_worker_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 32 "../src/utils/Utils.vala"
	if (src_value->data[0].v_pointer) {
#line 32 "../src/utils/Utils.vala"
		dest_value->data[0].v_pointer = game_hub_utils_worker_ref (src_value->data[0].v_pointer);
#line 880 "Utils.c"
	} else {
#line 32 "../src/utils/Utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 884 "Utils.c"
	}
}

static gpointer
game_hub_utils_value_worker_peek_pointer (const GValue* value)
{
#line 32 "../src/utils/Utils.vala"
	return value->data[0].v_pointer;
#line 893 "Utils.c"
}

static gchar*
game_hub_utils_value_worker_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 32 "../src/utils/Utils.vala"
	if (collect_values[0].v_pointer) {
#line 904 "Utils.c"
		GameHubUtilsWorker * object;
		object = collect_values[0].v_pointer;
#line 32 "../src/utils/Utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 32 "../src/utils/Utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 911 "Utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 32 "../src/utils/Utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 915 "Utils.c"
		}
#line 32 "../src/utils/Utils.vala"
		value->data[0].v_pointer = game_hub_utils_worker_ref (object);
#line 919 "Utils.c"
	} else {
#line 32 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 923 "Utils.c"
	}
#line 32 "../src/utils/Utils.vala"
	return NULL;
#line 927 "Utils.c"
}

static gchar*
game_hub_utils_value_worker_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GameHubUtilsWorker ** object_p;
	object_p = collect_values[0].v_pointer;
#line 32 "../src/utils/Utils.vala"
	if (!object_p) {
#line 32 "../src/utils/Utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 942 "Utils.c"
	}
#line 32 "../src/utils/Utils.vala"
	if (!value->data[0].v_pointer) {
#line 32 "../src/utils/Utils.vala"
		*object_p = NULL;
#line 948 "Utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 32 "../src/utils/Utils.vala"
		*object_p = value->data[0].v_pointer;
#line 952 "Utils.c"
	} else {
#line 32 "../src/utils/Utils.vala"
		*object_p = game_hub_utils_worker_ref (value->data[0].v_pointer);
#line 956 "Utils.c"
	}
#line 32 "../src/utils/Utils.vala"
	return NULL;
#line 960 "Utils.c"
}

GParamSpec*
game_hub_utils_param_spec_worker (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GameHubUtilsParamSpecWorker* spec;
#line 32 "../src/utils/Utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GAME_HUB_UTILS_TYPE_WORKER), NULL);
#line 32 "../src/utils/Utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 32 "../src/utils/Utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 32 "../src/utils/Utils.vala"
	return G_PARAM_SPEC (spec);
#line 979 "Utils.c"
}

gpointer
game_hub_utils_value_get_worker (const GValue* value)
{
#line 32 "../src/utils/Utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_WORKER), NULL);
#line 32 "../src/utils/Utils.vala"
	return value->data[0].v_pointer;
#line 989 "Utils.c"
}

void
game_hub_utils_value_set_worker (GValue* value,
                                 gpointer v_object)
{
	GameHubUtilsWorker * old;
#line 32 "../src/utils/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_WORKER));
#line 32 "../src/utils/Utils.vala"
	old = value->data[0].v_pointer;
#line 32 "../src/utils/Utils.vala"
	if (v_object) {
#line 32 "../src/utils/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_WORKER));
#line 32 "../src/utils/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 32 "../src/utils/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 32 "../src/utils/Utils.vala"
		game_hub_utils_worker_ref (value->data[0].v_pointer);
#line 1011 "Utils.c"
	} else {
#line 32 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 1015 "Utils.c"
	}
#line 32 "../src/utils/Utils.vala"
	if (old) {
#line 32 "../src/utils/Utils.vala"
		game_hub_utils_worker_unref (old);
#line 1021 "Utils.c"
	}
}

void
game_hub_utils_value_take_worker (GValue* value,
                                  gpointer v_object)
{
	GameHubUtilsWorker * old;
#line 32 "../src/utils/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_WORKER));
#line 32 "../src/utils/Utils.vala"
	old = value->data[0].v_pointer;
#line 32 "../src/utils/Utils.vala"
	if (v_object) {
#line 32 "../src/utils/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_WORKER));
#line 32 "../src/utils/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 32 "../src/utils/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 1042 "Utils.c"
	} else {
#line 32 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 1046 "Utils.c"
	}
#line 32 "../src/utils/Utils.vala"
	if (old) {
#line 32 "../src/utils/Utils.vala"
		game_hub_utils_worker_unref (old);
#line 1052 "Utils.c"
	}
}

static void
game_hub_utils_worker_class_init (GameHubUtilsWorkerClass * klass,
                                  gpointer klass_data)
{
#line 32 "../src/utils/Utils.vala"
	game_hub_utils_worker_parent_class = g_type_class_peek_parent (klass);
#line 32 "../src/utils/Utils.vala"
	((GameHubUtilsWorkerClass *) klass)->finalize = game_hub_utils_worker_finalize;
#line 1064 "Utils.c"
}

static void
game_hub_utils_worker_instance_init (GameHubUtilsWorker * self,
                                     gpointer klass)
{
#line 32 "../src/utils/Utils.vala"
	self->ref_count = 1;
#line 1073 "Utils.c"
}

static void
game_hub_utils_worker_finalize (GameHubUtilsWorker * obj)
{
	GameHubUtilsWorker * self;
#line 32 "../src/utils/Utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_TYPE_WORKER, GameHubUtilsWorker);
#line 32 "../src/utils/Utils.vala"
	g_signal_handlers_destroy (self);
#line 34 "../src/utils/Utils.vala"
	_g_free0 (self->name);
#line 35 "../src/utils/Utils.vala"
	(self->worker_target_destroy_notify == NULL) ? NULL : (self->worker_target_destroy_notify (self->worker_target), NULL);
#line 35 "../src/utils/Utils.vala"
	self->worker = NULL;
#line 35 "../src/utils/Utils.vala"
	self->worker_target = NULL;
#line 35 "../src/utils/Utils.vala"
	self->worker_target_destroy_notify = NULL;
#line 1094 "Utils.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_worker_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_hub_utils_value_worker_init, game_hub_utils_value_worker_free_value, game_hub_utils_value_worker_copy_value, game_hub_utils_value_worker_peek_pointer, "p", game_hub_utils_value_worker_collect_value, "p", game_hub_utils_value_worker_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsWorker), 0, (GInstanceInitFunc) game_hub_utils_worker_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_hub_utils_worker_type_id;
	game_hub_utils_worker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameHubUtilsWorker", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return game_hub_utils_worker_type_id;
}

GType
game_hub_utils_worker_get_type (void)
{
	static volatile gsize game_hub_utils_worker_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_worker_type_id__once)) {
		GType game_hub_utils_worker_type_id;
		game_hub_utils_worker_type_id = game_hub_utils_worker_get_type_once ();
		g_once_init_leave (&game_hub_utils_worker_type_id__once, game_hub_utils_worker_type_id);
	}
	return game_hub_utils_worker_type_id__once;
}

gpointer
game_hub_utils_worker_ref (gpointer instance)
{
	GameHubUtilsWorker * self;
	self = instance;
#line 32 "../src/utils/Utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 32 "../src/utils/Utils.vala"
	return instance;
#line 1129 "Utils.c"
}

void
game_hub_utils_worker_unref (gpointer instance)
{
	GameHubUtilsWorker * self;
	self = instance;
#line 32 "../src/utils/Utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 32 "../src/utils/Utils.vala"
		GAME_HUB_UTILS_WORKER_GET_CLASS (self)->finalize (self);
#line 32 "../src/utils/Utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1143 "Utils.c"
	}
}

void
game_hub_utils_open_uri (const gchar* uri)
{
	GError* _inner_error0_ = NULL;
#line 54 "../src/utils/Utils.vala"
	g_return_if_fail (uri != NULL);
#line 1153 "Utils.c"
	{
#line 58 "../src/utils/Utils.vala"
		g_app_info_launch_default_for_uri (uri, NULL, &_inner_error0_);
#line 58 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1159 "Utils.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
#line 56 "../src/utils/Utils.vala"
		e = _inner_error0_;
#line 56 "../src/utils/Utils.vala"
		_inner_error0_ = NULL;
#line 62 "../src/utils/Utils.vala"
		_tmp0_ = e;
#line 62 "../src/utils/Utils.vala"
		_tmp1_ = _tmp0_->message;
#line 62 "../src/utils/Utils.vala"
		g_warning ("Utils.vala:62: [Utils.open_uri] Error while opening '%s': %s", uri, _tmp1_);
#line 56 "../src/utils/Utils.vala"
		_g_error_free0 (e);
#line 1181 "Utils.c"
	}
	__finally0:
#line 56 "../src/utils/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "../src/utils/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 56 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 56 "../src/utils/Utils.vala"
		return;
#line 1192 "Utils.c"
	}
}

gchar**
game_hub_utils_parse_args (const gchar* args,
                           gint* result_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
#line 68 "../src/utils/Utils.vala"
	if (args != NULL) {
#line 1207 "Utils.c"
		gint _tmp1_;
		gint _tmp2_;
#line 68 "../src/utils/Utils.vala"
		_tmp1_ = strlen (args);
#line 68 "../src/utils/Utils.vala"
		_tmp2_ = _tmp1_;
#line 68 "../src/utils/Utils.vala"
		_tmp0_ = _tmp2_ > 0;
#line 1216 "Utils.c"
	} else {
#line 68 "../src/utils/Utils.vala"
		_tmp0_ = FALSE;
#line 1220 "Utils.c"
	}
#line 68 "../src/utils/Utils.vala"
	if (_tmp0_) {
#line 1224 "Utils.c"
		{
			gchar** argv = NULL;
			gint argv_length1;
			gint _argv_size_;
			gchar** _tmp3_ = NULL;
			gint _tmp4_ = 0;
			gchar** _tmp5_;
			gint _tmp5__length1;
#line 72 "../src/utils/Utils.vala"
			argv = NULL;
#line 72 "../src/utils/Utils.vala"
			argv_length1 = 0;
#line 72 "../src/utils/Utils.vala"
			_argv_size_ = argv_length1;
#line 73 "../src/utils/Utils.vala"
			g_shell_parse_argv (args, &_tmp4_, &_tmp3_, &_inner_error0_);
#line 73 "../src/utils/Utils.vala"
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 73 "../src/utils/Utils.vala"
			argv = _tmp3_;
#line 73 "../src/utils/Utils.vala"
			argv_length1 = _tmp4_;
#line 73 "../src/utils/Utils.vala"
			_argv_size_ = argv_length1;
#line 73 "../src/utils/Utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "../src/utils/Utils.vala"
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 73 "../src/utils/Utils.vala"
				if (_inner_error0_->domain == G_SHELL_ERROR) {
#line 1255 "Utils.c"
					goto __catch0_g_shell_error;
				}
#line 73 "../src/utils/Utils.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 73 "../src/utils/Utils.vala"
				g_clear_error (&_inner_error0_);
#line 73 "../src/utils/Utils.vala"
				return NULL;
#line 1264 "Utils.c"
			}
#line 74 "../src/utils/Utils.vala"
			_tmp5_ = argv;
#line 74 "../src/utils/Utils.vala"
			_tmp5__length1 = argv_length1;
#line 74 "../src/utils/Utils.vala"
			if (result_length1) {
#line 74 "../src/utils/Utils.vala"
				*result_length1 = _tmp5__length1;
#line 1274 "Utils.c"
			}
#line 74 "../src/utils/Utils.vala"
			result = _tmp5_;
#line 74 "../src/utils/Utils.vala"
			return result;
#line 1280 "Utils.c"
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
#line 70 "../src/utils/Utils.vala"
			e = _inner_error0_;
#line 70 "../src/utils/Utils.vala"
			_inner_error0_ = NULL;
#line 78 "../src/utils/Utils.vala"
			_tmp6_ = e;
#line 78 "../src/utils/Utils.vala"
			_tmp7_ = _tmp6_->message;
#line 78 "../src/utils/Utils.vala"
			g_warning ("Utils.vala:78: [Utils.parse_args] Error parsing args: %s", _tmp7_);
#line 70 "../src/utils/Utils.vala"
			_g_error_free0 (e);
#line 1300 "Utils.c"
		}
		__finally0:
#line 70 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 70 "../src/utils/Utils.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 70 "../src/utils/Utils.vala"
			g_clear_error (&_inner_error0_);
#line 70 "../src/utils/Utils.vala"
			return NULL;
#line 1311 "Utils.c"
		}
	}
#line 81 "../src/utils/Utils.vala"
	_tmp8_ = NULL;
#line 81 "../src/utils/Utils.vala"
	_tmp8__length1 = 0;
#line 81 "../src/utils/Utils.vala"
	if (result_length1) {
#line 81 "../src/utils/Utils.vala"
		*result_length1 = _tmp8__length1;
#line 1322 "Utils.c"
	}
#line 81 "../src/utils/Utils.vala"
	result = _tmp8_;
#line 81 "../src/utils/Utils.vala"
	return result;
#line 1328 "Utils.c"
}

static inline gpointer
game_hub_utils_run_task_get_instance_private (GameHubUtilsRunTask* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubUtilsRunTask_private_offset);
}

static gchar**
_vala_array_dup47 (gchar** self,
                   gssize length)
{
#line 93 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 1343 "Utils.c"
		gchar** result;
		gssize i;
#line 93 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 93 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 1350 "Utils.c"
			gchar* _tmp0_;
#line 93 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 93 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 1356 "Utils.c"
		}
#line 93 "../src/utils/Utils.vala"
		return result;
#line 1360 "Utils.c"
	}
#line 93 "../src/utils/Utils.vala"
	return NULL;
#line 1364 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_construct (GType object_type,
                                   gchar** cmd,
                                   gint cmd_length1)
{
	GameHubUtilsRunTask* self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
#line 93 "../src/utils/Utils.vala"
	self = (GameHubUtilsRunTask*) g_type_create_instance (object_type);
#line 93 "../src/utils/Utils.vala"
	_tmp0_ = (cmd != NULL) ? _vala_array_dup47 (cmd, cmd_length1) : cmd;
#line 93 "../src/utils/Utils.vala"
	_tmp0__length1 = cmd_length1;
#line 93 "../src/utils/Utils.vala"
	self->priv->_cmd = (_vala_array_free (self->priv->_cmd, self->priv->_cmd_length1, (GDestroyNotify) g_free), NULL);
#line 93 "../src/utils/Utils.vala"
	self->priv->_cmd = _tmp0_;
#line 93 "../src/utils/Utils.vala"
	self->priv->_cmd_length1 = _tmp0__length1;
#line 93 "../src/utils/Utils.vala"
	self->priv->__cmd_size_ = self->priv->_cmd_length1;
#line 93 "../src/utils/Utils.vala"
	return self;
#line 1391 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_new (gchar** cmd,
                             gint cmd_length1)
{
#line 93 "../src/utils/Utils.vala"
	return game_hub_utils_run_task_construct (GAME_HUB_UTILS_TYPE_RUN_TASK, cmd, cmd_length1);
#line 1400 "Utils.c"
}

static gchar**
_vala_array_dup48 (gchar** self,
                   gssize length)
{
#line 95 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 1409 "Utils.c"
		gchar** result;
		gssize i;
#line 95 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 95 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 1416 "Utils.c"
			gchar* _tmp0_;
#line 95 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 95 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 1422 "Utils.c"
		}
#line 95 "../src/utils/Utils.vala"
		return result;
#line 1426 "Utils.c"
	}
#line 95 "../src/utils/Utils.vala"
	return NULL;
#line 1430 "Utils.c"
}

static gpointer
_game_hub_utils_run_task_ref0 (gpointer self)
{
#line 95 "../src/utils/Utils.vala"
	return self ? game_hub_utils_run_task_ref (self) : NULL;
#line 1438 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_cmd (GameHubUtilsRunTask* self,
                             gchar** cmd,
                             gint cmd_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	GameHubUtilsRunTask* _tmp1_;
	GameHubUtilsRunTask* result;
#line 95 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "../src/utils/Utils.vala"
	_tmp0_ = (cmd != NULL) ? _vala_array_dup48 (cmd, cmd_length1) : cmd;
#line 95 "../src/utils/Utils.vala"
	_tmp0__length1 = cmd_length1;
#line 95 "../src/utils/Utils.vala"
	self->priv->_cmd = (_vala_array_free (self->priv->_cmd, self->priv->_cmd_length1, (GDestroyNotify) g_free), NULL);
#line 95 "../src/utils/Utils.vala"
	self->priv->_cmd = _tmp0_;
#line 95 "../src/utils/Utils.vala"
	self->priv->_cmd_length1 = _tmp0__length1;
#line 95 "../src/utils/Utils.vala"
	self->priv->__cmd_size_ = self->priv->_cmd_length1;
#line 95 "../src/utils/Utils.vala"
	_tmp1_ = _game_hub_utils_run_task_ref0 (self);
#line 95 "../src/utils/Utils.vala"
	result = _tmp1_;
#line 95 "../src/utils/Utils.vala"
	return result;
#line 1470 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_dir (GameHubUtilsRunTask* self,
                             const gchar* dir)
{
	gchar* _tmp0_;
	GameHubUtilsRunTask* _tmp1_;
	GameHubUtilsRunTask* result;
#line 96 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "../src/utils/Utils.vala"
	_tmp0_ = g_strdup (dir);
#line 96 "../src/utils/Utils.vala"
	_g_free0 (self->priv->_dir);
#line 96 "../src/utils/Utils.vala"
	self->priv->_dir = _tmp0_;
#line 96 "../src/utils/Utils.vala"
	_tmp1_ = _game_hub_utils_run_task_ref0 (self);
#line 96 "../src/utils/Utils.vala"
	result = _tmp1_;
#line 96 "../src/utils/Utils.vala"
	return result;
#line 1494 "Utils.c"
}

static gchar**
_vala_array_dup49 (gchar** self,
                   gssize length)
{
#line 97 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 1503 "Utils.c"
		gchar** result;
		gssize i;
#line 97 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 97 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 1510 "Utils.c"
			gchar* _tmp0_;
#line 97 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 97 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 1516 "Utils.c"
		}
#line 97 "../src/utils/Utils.vala"
		return result;
#line 1520 "Utils.c"
	}
#line 97 "../src/utils/Utils.vala"
	return NULL;
#line 1524 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_env (GameHubUtilsRunTask* self,
                             gchar** env,
                             gint env_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	GameHubUtilsRunTask* _tmp1_;
	GameHubUtilsRunTask* result;
#line 97 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "../src/utils/Utils.vala"
	_tmp0_ = (env != NULL) ? _vala_array_dup49 (env, env_length1) : env;
#line 97 "../src/utils/Utils.vala"
	_tmp0__length1 = env_length1;
#line 97 "../src/utils/Utils.vala"
	self->priv->_env = (_vala_array_free (self->priv->_env, self->priv->_env_length1, (GDestroyNotify) g_free), NULL);
#line 97 "../src/utils/Utils.vala"
	self->priv->_env = _tmp0_;
#line 97 "../src/utils/Utils.vala"
	self->priv->_env_length1 = _tmp0__length1;
#line 97 "../src/utils/Utils.vala"
	self->priv->__env_size_ = self->priv->_env_length1;
#line 97 "../src/utils/Utils.vala"
	_tmp1_ = _game_hub_utils_run_task_ref0 (self);
#line 97 "../src/utils/Utils.vala"
	result = _tmp1_;
#line 97 "../src/utils/Utils.vala"
	return result;
#line 1556 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_override_runtime (GameHubUtilsRunTask* self,
                                          gboolean override_runtime)
{
	GameHubUtilsRunTask* _tmp0_;
	GameHubUtilsRunTask* result;
#line 98 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 98 "../src/utils/Utils.vala"
	self->priv->_override_runtime = override_runtime;
#line 98 "../src/utils/Utils.vala"
	_tmp0_ = _game_hub_utils_run_task_ref0 (self);
#line 98 "../src/utils/Utils.vala"
	result = _tmp0_;
#line 98 "../src/utils/Utils.vala"
	return result;
#line 1575 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_log (GameHubUtilsRunTask* self,
                             gboolean log)
{
	GameHubUtilsRunTask* _tmp0_;
	GameHubUtilsRunTask* result;
#line 99 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 99 "../src/utils/Utils.vala"
	self->priv->_log = log;
#line 99 "../src/utils/Utils.vala"
	_tmp0_ = _game_hub_utils_run_task_ref0 (self);
#line 99 "../src/utils/Utils.vala"
	result = _tmp0_;
#line 99 "../src/utils/Utils.vala"
	return result;
#line 1594 "Utils.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 100 "../src/utils/Utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 1602 "Utils.c"
}

static GameHubDataTweaksTweak**
_vala_array_dup50 (GameHubDataTweaksTweak** self,
                   gssize length)
{
#line 100 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 1611 "Utils.c"
		GameHubDataTweaksTweak** result;
		gssize i;
#line 100 "../src/utils/Utils.vala"
		result = g_new0 (GameHubDataTweaksTweak*, length + 1);
#line 100 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 1618 "Utils.c"
			GameHubDataTweaksTweak* _tmp0_;
#line 100 "../src/utils/Utils.vala"
			_tmp0_ = _g_object_ref0 (self[i]);
#line 100 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 1624 "Utils.c"
		}
#line 100 "../src/utils/Utils.vala"
		return result;
#line 1628 "Utils.c"
	}
#line 100 "../src/utils/Utils.vala"
	return NULL;
#line 1632 "Utils.c"
}

GameHubUtilsRunTask*
game_hub_utils_run_task_tweaks (GameHubUtilsRunTask* self,
                                GameHubDataTweaksTweak** tweaks,
                                gint tweaks_length1)
{
	GameHubDataTweaksTweak** _tmp0_;
	gint _tmp0__length1;
	GameHubUtilsRunTask* _tmp1_;
	GameHubUtilsRunTask* result;
#line 100 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "../src/utils/Utils.vala"
	_tmp0_ = (tweaks != NULL) ? _vala_array_dup50 (tweaks, tweaks_length1) : tweaks;
#line 100 "../src/utils/Utils.vala"
	_tmp0__length1 = tweaks_length1;
#line 100 "../src/utils/Utils.vala"
	self->priv->_tweaks = (_vala_array_free (self->priv->_tweaks, self->priv->_tweaks_length1, (GDestroyNotify) g_object_unref), NULL);
#line 100 "../src/utils/Utils.vala"
	self->priv->_tweaks = _tmp0_;
#line 100 "../src/utils/Utils.vala"
	self->priv->_tweaks_length1 = _tmp0__length1;
#line 100 "../src/utils/Utils.vala"
	self->priv->__tweaks_size_ = self->priv->_tweaks_length1;
#line 100 "../src/utils/Utils.vala"
	_tmp1_ = _game_hub_utils_run_task_ref0 (self);
#line 100 "../src/utils/Utils.vala"
	result = _tmp1_;
#line 100 "../src/utils/Utils.vala"
	return result;
#line 1664 "Utils.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 1678 "Utils.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 1682 "Utils.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 1688 "Utils.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 1693 "Utils.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 1699 "Utils.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 1703 "Utils.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 1707 "Utils.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 1711 "Utils.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1715 "Utils.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1719 "Utils.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 1734 "Utils.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 1743 "Utils.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 1750 "Utils.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 1756 "Utils.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 1764 "Utils.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 1768 "Utils.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 1774 "Utils.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 1779 "Utils.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 1785 "Utils.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 1789 "Utils.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 1793 "Utils.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 1799 "Utils.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 1805 "Utils.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1817 "Utils.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1821 "Utils.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1825 "Utils.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 1830 "Utils.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 1838 "Utils.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 1856 "Utils.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 1862 "Utils.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 1866 "Utils.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 1874 "Utils.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 1883 "Utils.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 1892 "Utils.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 1898 "Utils.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 1906 "Utils.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 1918 "Utils.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 1924 "Utils.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 1928 "Utils.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 1936 "Utils.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 1947 "Utils.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 1956 "Utils.c"
	}
}

static gchar**
_vala_array_dup51 (gchar** self,
                   gssize length)
{
#line 113 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 1966 "Utils.c"
		gchar** result;
		gssize i;
#line 113 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 113 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 1973 "Utils.c"
			gchar* _tmp0_;
#line 113 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 113 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 1979 "Utils.c"
		}
#line 113 "../src/utils/Utils.vala"
		return result;
#line 1983 "Utils.c"
	}
#line 113 "../src/utils/Utils.vala"
	return NULL;
#line 1987 "Utils.c"
}

static gchar**
_vala_array_dup52 (gchar** self,
                   gssize length)
{
#line 130 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 1996 "Utils.c"
		gchar** result;
		gssize i;
#line 130 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 130 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 2003 "Utils.c"
			gchar* _tmp0_;
#line 130 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 130 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 2009 "Utils.c"
		}
#line 130 "../src/utils/Utils.vala"
		return result;
#line 2013 "Utils.c"
	}
#line 130 "../src/utils/Utils.vala"
	return NULL;
#line 2017 "Utils.c"
}

static gchar**
_vala_array_dup53 (gchar** self,
                   gssize length)
{
#line 134 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 2026 "Utils.c"
		gchar** result;
		gssize i;
#line 134 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 134 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 2033 "Utils.c"
			gchar* _tmp0_;
#line 134 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 134 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 2039 "Utils.c"
		}
#line 134 "../src/utils/Utils.vala"
		return result;
#line 2043 "Utils.c"
	}
#line 134 "../src/utils/Utils.vala"
	return NULL;
#line 2047 "Utils.c"
}

static gchar**
_vala_array_dup54 (gchar** self,
                   gssize length)
{
#line 141 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 2056 "Utils.c"
		gchar** result;
		gssize i;
#line 141 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 141 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 2063 "Utils.c"
			gchar* _tmp0_;
#line 141 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 141 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 2069 "Utils.c"
		}
#line 141 "../src/utils/Utils.vala"
		return result;
#line 2073 "Utils.c"
	}
#line 141 "../src/utils/Utils.vala"
	return NULL;
#line 2077 "Utils.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 145 "../src/utils/Utils.vala"
	for (i = 0; i < stack_length; i++) {
#line 145 "../src/utils/Utils.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 145 "../src/utils/Utils.vala"
			return TRUE;
#line 2092 "Utils.c"
		}
	}
#line 145 "../src/utils/Utils.vala"
	return FALSE;
#line 2097 "Utils.c"
}

static void
_vala_array_add59 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 155 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 155 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 155 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2112 "Utils.c"
	}
#line 155 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 155 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 2118 "Utils.c"
}

static void
_vala_array_add60 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 160 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 160 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 160 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2133 "Utils.c"
	}
#line 160 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 160 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 2139 "Utils.c"
}

static gchar**
_vala_array_dup55 (gchar** self,
                   gssize length)
{
#line 165 "../src/utils/Utils.vala"
	if (length >= 0) {
#line 2148 "Utils.c"
		gchar** result;
		gssize i;
#line 165 "../src/utils/Utils.vala"
		result = g_new0 (gchar*, length + 1);
#line 165 "../src/utils/Utils.vala"
		for (i = 0; i < length; i++) {
#line 2155 "Utils.c"
			gchar* _tmp0_;
#line 165 "../src/utils/Utils.vala"
			_tmp0_ = g_strdup (self[i]);
#line 165 "../src/utils/Utils.vala"
			result[i] = _tmp0_;
#line 2161 "Utils.c"
		}
#line 165 "../src/utils/Utils.vala"
		return result;
#line 2165 "Utils.c"
	}
#line 165 "../src/utils/Utils.vala"
	return NULL;
#line 2169 "Utils.c"
}

static void
_vala_array_add61 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 195 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 195 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 195 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2184 "Utils.c"
	}
#line 195 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 195 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 2190 "Utils.c"
}

static void
game_hub_utils_run_task_expand (GameHubUtilsRunTask* self)
{
	gboolean cmd_expanded = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp7__length1;
	gint __tmp7__size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GameHubDataTweaksTweak** _tmp13_;
	gint _tmp13__length1;
	gboolean _tmp84_ = FALSE;
#line 103 "../src/utils/Utils.vala"
	g_return_if_fail (self != NULL);
#line 105 "../src/utils/Utils.vala"
	if (self->priv->_expanded) {
#line 105 "../src/utils/Utils.vala"
		return;
#line 2218 "Utils.c"
	}
#line 106 "../src/utils/Utils.vala"
	self->priv->_expanded = TRUE;
#line 108 "../src/utils/Utils.vala"
	cmd_expanded = FALSE;
#line 110 "../src/utils/Utils.vala"
	if (self->priv->_log) {
#line 2226 "Utils.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 110 "../src/utils/Utils.vala"
		_tmp0_ = self->priv->_cmd;
#line 110 "../src/utils/Utils.vala"
		_tmp0__length1 = self->priv->_cmd_length1;
#line 110 "../src/utils/Utils.vala"
		_tmp1_ = _vala_g_strjoinv ("' '", _tmp0_, (gint) _tmp0__length1);
#line 110 "../src/utils/Utils.vala"
		_tmp2_ = _tmp1_;
#line 110 "../src/utils/Utils.vala"
		g_debug ("Utils.vala:110: [RunTask] {'%s'}", _tmp2_);
#line 110 "../src/utils/Utils.vala"
		_g_free0 (_tmp2_);
#line 2243 "Utils.c"
	}
#line 112 "../src/utils/Utils.vala"
	_tmp4_ = self->priv->_dir;
#line 112 "../src/utils/Utils.vala"
	_tmp3_ = _tmp4_;
#line 112 "../src/utils/Utils.vala"
	if (_tmp3_ == NULL) {
#line 2251 "Utils.c"
		const gchar* _tmp5_;
#line 112 "../src/utils/Utils.vala"
		_tmp5_ = g_get_home_dir ();
#line 112 "../src/utils/Utils.vala"
		_tmp3_ = _tmp5_;
#line 2257 "Utils.c"
	}
#line 112 "../src/utils/Utils.vala"
	_tmp6_ = g_strdup (_tmp3_);
#line 112 "../src/utils/Utils.vala"
	_g_free0 (self->priv->_dir);
#line 112 "../src/utils/Utils.vala"
	self->priv->_dir = _tmp6_;
#line 113 "../src/utils/Utils.vala"
	_tmp8_ = self->priv->_env;
#line 113 "../src/utils/Utils.vala"
	_tmp8__length1 = self->priv->_env_length1;
#line 113 "../src/utils/Utils.vala"
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup51 (_tmp8_, _tmp8__length1) : _tmp8_;
#line 113 "../src/utils/Utils.vala"
	_tmp9__length1 = _tmp8__length1;
#line 113 "../src/utils/Utils.vala"
	_tmp7_ = _tmp9_;
#line 113 "../src/utils/Utils.vala"
	_tmp7__length1 = _tmp9__length1;
#line 113 "../src/utils/Utils.vala"
	__tmp7__size_ = _tmp7__length1;
#line 113 "../src/utils/Utils.vala"
	if (_tmp7_ == NULL) {
#line 2281 "Utils.c"
		gchar** _tmp10_;
		gchar** _tmp11_;
#line 113 "../src/utils/Utils.vala"
		_tmp11_ = _tmp10_ = g_get_environ ();
#line 113 "../src/utils/Utils.vala"
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 113 "../src/utils/Utils.vala"
		_tmp7_ = _tmp11_;
#line 113 "../src/utils/Utils.vala"
		_tmp7__length1 = _vala_array_length (_tmp10_);
#line 113 "../src/utils/Utils.vala"
		__tmp7__size_ = _tmp7__length1;
#line 2294 "Utils.c"
	}
#line 113 "../src/utils/Utils.vala"
	_tmp12_ = _tmp7_;
#line 113 "../src/utils/Utils.vala"
	_tmp12__length1 = _tmp7__length1;
#line 113 "../src/utils/Utils.vala"
	_tmp7_ = NULL;
#line 113 "../src/utils/Utils.vala"
	_tmp7__length1 = 0;
#line 113 "../src/utils/Utils.vala"
	self->priv->_env = (_vala_array_free (self->priv->_env, self->priv->_env_length1, (GDestroyNotify) g_free), NULL);
#line 113 "../src/utils/Utils.vala"
	self->priv->_env = _tmp12_;
#line 113 "../src/utils/Utils.vala"
	self->priv->_env_length1 = _tmp12__length1;
#line 113 "../src/utils/Utils.vala"
	self->priv->__env_size_ = self->priv->_env_length1;
#line 120 "../src/utils/Utils.vala"
	_tmp13_ = self->priv->_tweaks;
#line 120 "../src/utils/Utils.vala"
	_tmp13__length1 = self->priv->_tweaks_length1;
#line 120 "../src/utils/Utils.vala"
	if (_tmp13_ != NULL) {
#line 2318 "Utils.c"
		GameHubDataTweaksTweak** _tmp14_;
		gint _tmp14__length1;
#line 122 "../src/utils/Utils.vala"
		_tmp14_ = self->priv->_tweaks;
#line 122 "../src/utils/Utils.vala"
		_tmp14__length1 = self->priv->_tweaks_length1;
#line 2325 "Utils.c"
		{
			GameHubDataTweaksTweak** tweak_collection = NULL;
			gint tweak_collection_length1 = 0;
			gint _tweak_collection_size_ = 0;
			gint tweak_it = 0;
#line 122 "../src/utils/Utils.vala"
			tweak_collection = _tmp14_;
#line 122 "../src/utils/Utils.vala"
			tweak_collection_length1 = _tmp14__length1;
#line 122 "../src/utils/Utils.vala"
			for (tweak_it = 0; tweak_it < tweak_collection_length1; tweak_it = tweak_it + 1) {
#line 2337 "Utils.c"
				GameHubDataTweaksTweak* _tmp15_;
				GameHubDataTweaksTweak* tweak = NULL;
#line 122 "../src/utils/Utils.vala"
				_tmp15_ = _g_object_ref0 (tweak_collection[tweak_it]);
#line 122 "../src/utils/Utils.vala"
				tweak = _tmp15_;
#line 2344 "Utils.c"
				{
					GameHubDataTweaksTweak* _tmp16_;
					GeeHashMap* _tmp17_;
					GeeHashMap* _tmp18_;
					gboolean _tmp50_ = FALSE;
					GameHubDataTweaksTweak* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
#line 124 "../src/utils/Utils.vala"
					_tmp16_ = tweak;
#line 124 "../src/utils/Utils.vala"
					_tmp17_ = game_hub_data_tweaks_tweak_get_env (_tmp16_);
#line 124 "../src/utils/Utils.vala"
					_tmp18_ = _tmp17_;
#line 124 "../src/utils/Utils.vala"
					if (_tmp18_ != NULL) {
#line 2361 "Utils.c"
						{
							GeeIterator* _env_var_it = NULL;
							GameHubDataTweaksTweak* _tmp19_;
							GeeHashMap* _tmp20_;
							GeeHashMap* _tmp21_;
							GeeSet* _tmp22_;
							GeeSet* _tmp23_;
							GeeSet* _tmp24_;
							GeeIterator* _tmp25_;
							GeeIterator* _tmp26_;
#line 126 "../src/utils/Utils.vala"
							_tmp19_ = tweak;
#line 126 "../src/utils/Utils.vala"
							_tmp20_ = game_hub_data_tweaks_tweak_get_env (_tmp19_);
#line 126 "../src/utils/Utils.vala"
							_tmp21_ = _tmp20_;
#line 126 "../src/utils/Utils.vala"
							_tmp22_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp21_);
#line 126 "../src/utils/Utils.vala"
							_tmp23_ = _tmp22_;
#line 126 "../src/utils/Utils.vala"
							_tmp24_ = _tmp23_;
#line 126 "../src/utils/Utils.vala"
							_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
#line 126 "../src/utils/Utils.vala"
							_tmp26_ = _tmp25_;
#line 126 "../src/utils/Utils.vala"
							_g_object_unref0 (_tmp24_);
#line 126 "../src/utils/Utils.vala"
							_env_var_it = _tmp26_;
#line 126 "../src/utils/Utils.vala"
							while (TRUE) {
#line 2394 "Utils.c"
								GeeIterator* _tmp27_;
								GeeMapEntry* env_var = NULL;
								GeeIterator* _tmp28_;
								gpointer _tmp29_;
								GeeMapEntry* _tmp30_;
								gconstpointer _tmp31_;
								gconstpointer _tmp32_;
#line 126 "../src/utils/Utils.vala"
								_tmp27_ = _env_var_it;
#line 126 "../src/utils/Utils.vala"
								if (!gee_iterator_next (_tmp27_)) {
#line 126 "../src/utils/Utils.vala"
									break;
#line 2408 "Utils.c"
								}
#line 126 "../src/utils/Utils.vala"
								_tmp28_ = _env_var_it;
#line 126 "../src/utils/Utils.vala"
								_tmp29_ = gee_iterator_get (_tmp28_);
#line 126 "../src/utils/Utils.vala"
								env_var = (GeeMapEntry*) _tmp29_;
#line 128 "../src/utils/Utils.vala"
								_tmp30_ = env_var;
#line 128 "../src/utils/Utils.vala"
								_tmp31_ = gee_map_entry_get_value (_tmp30_);
#line 128 "../src/utils/Utils.vala"
								_tmp32_ = _tmp31_;
#line 128 "../src/utils/Utils.vala"
								if (((const gchar*) _tmp32_) != NULL) {
#line 2424 "Utils.c"
									gchar** _tmp33_;
									gint _tmp33__length1;
									gchar** _tmp34_;
									gint _tmp34__length1;
									GeeMapEntry* _tmp35_;
									gconstpointer _tmp36_;
									gconstpointer _tmp37_;
									GeeMapEntry* _tmp38_;
									gconstpointer _tmp39_;
									gconstpointer _tmp40_;
									gchar** _tmp41_;
									gchar** _tmp42_;
#line 130 "../src/utils/Utils.vala"
									_tmp33_ = self->priv->_env;
#line 130 "../src/utils/Utils.vala"
									_tmp33__length1 = self->priv->_env_length1;
#line 130 "../src/utils/Utils.vala"
									_tmp34_ = (_tmp33_ != NULL) ? _vala_array_dup52 (_tmp33_, _tmp33__length1) : _tmp33_;
#line 130 "../src/utils/Utils.vala"
									_tmp34__length1 = _tmp33__length1;
#line 130 "../src/utils/Utils.vala"
									_tmp35_ = env_var;
#line 130 "../src/utils/Utils.vala"
									_tmp36_ = gee_map_entry_get_key (_tmp35_);
#line 130 "../src/utils/Utils.vala"
									_tmp37_ = _tmp36_;
#line 130 "../src/utils/Utils.vala"
									_tmp38_ = env_var;
#line 130 "../src/utils/Utils.vala"
									_tmp39_ = gee_map_entry_get_value (_tmp38_);
#line 130 "../src/utils/Utils.vala"
									_tmp40_ = _tmp39_;
#line 130 "../src/utils/Utils.vala"
									_tmp42_ = _tmp41_ = g_environ_setenv (_tmp34_, (const gchar*) _tmp37_, (const gchar*) _tmp40_, TRUE);
#line 130 "../src/utils/Utils.vala"
									self->priv->_env = (_vala_array_free (self->priv->_env, self->priv->_env_length1, (GDestroyNotify) g_free), NULL);
#line 130 "../src/utils/Utils.vala"
									self->priv->_env = _tmp42_;
#line 130 "../src/utils/Utils.vala"
									self->priv->_env_length1 = _vala_array_length (_tmp41_);
#line 130 "../src/utils/Utils.vala"
									self->priv->__env_size_ = self->priv->_env_length1;
#line 2467 "Utils.c"
								} else {
									gchar** _tmp43_;
									gint _tmp43__length1;
									gchar** _tmp44_;
									gint _tmp44__length1;
									GeeMapEntry* _tmp45_;
									gconstpointer _tmp46_;
									gconstpointer _tmp47_;
									gchar** _tmp48_;
									gchar** _tmp49_;
#line 134 "../src/utils/Utils.vala"
									_tmp43_ = self->priv->_env;
#line 134 "../src/utils/Utils.vala"
									_tmp43__length1 = self->priv->_env_length1;
#line 134 "../src/utils/Utils.vala"
									_tmp44_ = (_tmp43_ != NULL) ? _vala_array_dup53 (_tmp43_, _tmp43__length1) : _tmp43_;
#line 134 "../src/utils/Utils.vala"
									_tmp44__length1 = _tmp43__length1;
#line 134 "../src/utils/Utils.vala"
									_tmp45_ = env_var;
#line 134 "../src/utils/Utils.vala"
									_tmp46_ = gee_map_entry_get_key (_tmp45_);
#line 134 "../src/utils/Utils.vala"
									_tmp47_ = _tmp46_;
#line 134 "../src/utils/Utils.vala"
									_tmp49_ = _tmp48_ = g_environ_unsetenv (_tmp44_, (const gchar*) _tmp47_);
#line 134 "../src/utils/Utils.vala"
									self->priv->_env = (_vala_array_free (self->priv->_env, self->priv->_env_length1, (GDestroyNotify) g_free), NULL);
#line 134 "../src/utils/Utils.vala"
									self->priv->_env = _tmp49_;
#line 134 "../src/utils/Utils.vala"
									self->priv->_env_length1 = _vala_array_length (_tmp48_);
#line 134 "../src/utils/Utils.vala"
									self->priv->__env_size_ = self->priv->_env_length1;
#line 2502 "Utils.c"
								}
#line 126 "../src/utils/Utils.vala"
								_g_object_unref0 (env_var);
#line 2506 "Utils.c"
							}
#line 126 "../src/utils/Utils.vala"
							_g_object_unref0 (_env_var_it);
#line 2510 "Utils.c"
						}
					}
#line 139 "../src/utils/Utils.vala"
					_tmp51_ = tweak;
#line 139 "../src/utils/Utils.vala"
					_tmp52_ = game_hub_data_tweaks_tweak_get_command (_tmp51_);
#line 139 "../src/utils/Utils.vala"
					_tmp53_ = _tmp52_;
#line 139 "../src/utils/Utils.vala"
					if (_tmp53_ != NULL) {
#line 2521 "Utils.c"
						GameHubDataTweaksTweak* _tmp54_;
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						gint _tmp57_;
						gint _tmp58_;
#line 139 "../src/utils/Utils.vala"
						_tmp54_ = tweak;
#line 139 "../src/utils/Utils.vala"
						_tmp55_ = game_hub_data_tweaks_tweak_get_command (_tmp54_);
#line 139 "../src/utils/Utils.vala"
						_tmp56_ = _tmp55_;
#line 139 "../src/utils/Utils.vala"
						_tmp57_ = strlen (_tmp56_);
#line 139 "../src/utils/Utils.vala"
						_tmp58_ = _tmp57_;
#line 139 "../src/utils/Utils.vala"
						_tmp50_ = _tmp58_ > 0;
#line 2539 "Utils.c"
					} else {
#line 139 "../src/utils/Utils.vala"
						_tmp50_ = FALSE;
#line 2543 "Utils.c"
					}
#line 139 "../src/utils/Utils.vala"
					if (_tmp50_) {
#line 2547 "Utils.c"
						gchar** tweaked_cmd = NULL;
						gchar** _tmp59_;
						gint _tmp59__length1;
						gchar** _tmp60_;
						gint _tmp60__length1;
						gint tweaked_cmd_length1;
						gint _tweaked_cmd_size_;
						gchar** tweak_cmd = NULL;
						GameHubDataTweaksTweak* _tmp61_;
						const gchar* _tmp62_;
						const gchar* _tmp63_;
						gint _tmp64_ = 0;
						gchar** _tmp65_;
						gint tweak_cmd_length1;
						gint _tweak_cmd_size_;
						gchar** _tmp66_;
						gint _tmp66__length1;
						gchar** _tmp82_;
						gint _tmp82__length1;
						gchar** _tmp83_;
						gint _tmp83__length1;
#line 141 "../src/utils/Utils.vala"
						_tmp59_ = self->priv->_cmd;
#line 141 "../src/utils/Utils.vala"
						_tmp59__length1 = self->priv->_cmd_length1;
#line 141 "../src/utils/Utils.vala"
						_tmp60_ = (_tmp59_ != NULL) ? _vala_array_dup54 (_tmp59_, _tmp59__length1) : _tmp59_;
#line 141 "../src/utils/Utils.vala"
						_tmp60__length1 = _tmp59__length1;
#line 141 "../src/utils/Utils.vala"
						tweaked_cmd = _tmp60_;
#line 141 "../src/utils/Utils.vala"
						tweaked_cmd_length1 = _tmp60__length1;
#line 141 "../src/utils/Utils.vala"
						_tweaked_cmd_size_ = tweaked_cmd_length1;
#line 142 "../src/utils/Utils.vala"
						_tmp61_ = tweak;
#line 142 "../src/utils/Utils.vala"
						_tmp62_ = game_hub_data_tweaks_tweak_get_command (_tmp61_);
#line 142 "../src/utils/Utils.vala"
						_tmp63_ = _tmp62_;
#line 142 "../src/utils/Utils.vala"
						_tmp65_ = game_hub_utils_parse_args (_tmp63_, &_tmp64_);
#line 142 "../src/utils/Utils.vala"
						tweak_cmd = _tmp65_;
#line 142 "../src/utils/Utils.vala"
						tweak_cmd_length1 = _tmp64_;
#line 142 "../src/utils/Utils.vala"
						_tweak_cmd_size_ = tweak_cmd_length1;
#line 143 "../src/utils/Utils.vala"
						_tmp66_ = tweak_cmd;
#line 143 "../src/utils/Utils.vala"
						_tmp66__length1 = tweak_cmd_length1;
#line 143 "../src/utils/Utils.vala"
						if (_tmp66_ != NULL) {
#line 2603 "Utils.c"
							gboolean _tmp67_ = FALSE;
							gchar** _tmp68_;
							gint _tmp68__length1;
							gchar** _tmp71_;
							gint _tmp71__length1;
#line 145 "../src/utils/Utils.vala"
							_tmp68_ = tweak_cmd;
#line 145 "../src/utils/Utils.vala"
							_tmp68__length1 = tweak_cmd_length1;
#line 145 "../src/utils/Utils.vala"
							if (_vala_string_array_contains (_tmp68_, _tmp68__length1, "$command")) {
#line 145 "../src/utils/Utils.vala"
								_tmp67_ = TRUE;
#line 2617 "Utils.c"
							} else {
								gchar** _tmp69_;
								gint _tmp69__length1;
#line 145 "../src/utils/Utils.vala"
								_tmp69_ = tweak_cmd;
#line 145 "../src/utils/Utils.vala"
								_tmp69__length1 = tweak_cmd_length1;
#line 145 "../src/utils/Utils.vala"
								_tmp67_ = _vala_string_array_contains (_tmp69_, _tmp69__length1, "${command}");
#line 2627 "Utils.c"
							}
#line 145 "../src/utils/Utils.vala"
							if (_tmp67_) {
#line 2631 "Utils.c"
								gchar** _tmp70_;
#line 147 "../src/utils/Utils.vala"
								_tmp70_ = g_new0 (gchar*, 0 + 1);
#line 147 "../src/utils/Utils.vala"
								tweaked_cmd = (_vala_array_free (tweaked_cmd, tweaked_cmd_length1, (GDestroyNotify) g_free), NULL);
#line 147 "../src/utils/Utils.vala"
								tweaked_cmd = _tmp70_;
#line 147 "../src/utils/Utils.vala"
								tweaked_cmd_length1 = 0;
#line 147 "../src/utils/Utils.vala"
								_tweaked_cmd_size_ = tweaked_cmd_length1;
#line 2643 "Utils.c"
							}
#line 149 "../src/utils/Utils.vala"
							_tmp71_ = tweak_cmd;
#line 149 "../src/utils/Utils.vala"
							_tmp71__length1 = tweak_cmd_length1;
#line 2649 "Utils.c"
							{
								gchar** arg_collection = NULL;
								gint arg_collection_length1 = 0;
								gint _arg_collection_size_ = 0;
								gint arg_it = 0;
#line 149 "../src/utils/Utils.vala"
								arg_collection = _tmp71_;
#line 149 "../src/utils/Utils.vala"
								arg_collection_length1 = _tmp71__length1;
#line 149 "../src/utils/Utils.vala"
								for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
#line 2661 "Utils.c"
									gchar* _tmp72_;
									gchar* arg = NULL;
#line 149 "../src/utils/Utils.vala"
									_tmp72_ = g_strdup (arg_collection[arg_it]);
#line 149 "../src/utils/Utils.vala"
									arg = _tmp72_;
#line 2668 "Utils.c"
									{
										gboolean _tmp73_ = FALSE;
										const gchar* _tmp74_;
#line 151 "../src/utils/Utils.vala"
										_tmp74_ = arg;
#line 151 "../src/utils/Utils.vala"
										if (g_strcmp0 (_tmp74_, "$command") == 0) {
#line 151 "../src/utils/Utils.vala"
											_tmp73_ = TRUE;
#line 2678 "Utils.c"
										} else {
											const gchar* _tmp75_;
#line 151 "../src/utils/Utils.vala"
											_tmp75_ = arg;
#line 151 "../src/utils/Utils.vala"
											_tmp73_ = g_strcmp0 (_tmp75_, "${command}") == 0;
#line 2685 "Utils.c"
										}
#line 151 "../src/utils/Utils.vala"
										if (_tmp73_) {
#line 2689 "Utils.c"
											gchar** _tmp76_;
											gint _tmp76__length1;
#line 153 "../src/utils/Utils.vala"
											_tmp76_ = self->priv->_cmd;
#line 153 "../src/utils/Utils.vala"
											_tmp76__length1 = self->priv->_cmd_length1;
#line 2696 "Utils.c"
											{
												gchar** a_collection = NULL;
												gint a_collection_length1 = 0;
												gint _a_collection_size_ = 0;
												gint a_it = 0;
#line 153 "../src/utils/Utils.vala"
												a_collection = _tmp76_;
#line 153 "../src/utils/Utils.vala"
												a_collection_length1 = _tmp76__length1;
#line 153 "../src/utils/Utils.vala"
												for (a_it = 0; a_it < a_collection_length1; a_it = a_it + 1) {
#line 2708 "Utils.c"
													gchar* _tmp77_;
													gchar* a = NULL;
#line 153 "../src/utils/Utils.vala"
													_tmp77_ = g_strdup (a_collection[a_it]);
#line 153 "../src/utils/Utils.vala"
													a = _tmp77_;
#line 2715 "Utils.c"
													{
														const gchar* _tmp78_;
														gchar* _tmp79_;
#line 155 "../src/utils/Utils.vala"
														_tmp78_ = a;
#line 155 "../src/utils/Utils.vala"
														_tmp79_ = g_strdup (_tmp78_);
#line 155 "../src/utils/Utils.vala"
														_vala_array_add59 (&tweaked_cmd, &tweaked_cmd_length1, &_tweaked_cmd_size_, _tmp79_);
#line 153 "../src/utils/Utils.vala"
														_g_free0 (a);
#line 2727 "Utils.c"
													}
												}
											}
										} else {
											const gchar* _tmp80_;
											gchar* _tmp81_;
#line 160 "../src/utils/Utils.vala"
											_tmp80_ = arg;
#line 160 "../src/utils/Utils.vala"
											_tmp81_ = g_strdup (_tmp80_);
#line 160 "../src/utils/Utils.vala"
											_vala_array_add60 (&tweaked_cmd, &tweaked_cmd_length1, &_tweaked_cmd_size_, _tmp81_);
#line 2740 "Utils.c"
										}
#line 149 "../src/utils/Utils.vala"
										_g_free0 (arg);
#line 2744 "Utils.c"
									}
								}
							}
#line 163 "../src/utils/Utils.vala"
							cmd_expanded = TRUE;
#line 2750 "Utils.c"
						}
#line 165 "../src/utils/Utils.vala"
						_tmp82_ = tweaked_cmd;
#line 165 "../src/utils/Utils.vala"
						_tmp82__length1 = tweaked_cmd_length1;
#line 165 "../src/utils/Utils.vala"
						_tmp83_ = (_tmp82_ != NULL) ? _vala_array_dup55 (_tmp82_, _tmp82__length1) : _tmp82_;
#line 165 "../src/utils/Utils.vala"
						_tmp83__length1 = _tmp82__length1;
#line 165 "../src/utils/Utils.vala"
						self->priv->_cmd = (_vala_array_free (self->priv->_cmd, self->priv->_cmd_length1, (GDestroyNotify) g_free), NULL);
#line 165 "../src/utils/Utils.vala"
						self->priv->_cmd = _tmp83_;
#line 165 "../src/utils/Utils.vala"
						self->priv->_cmd_length1 = _tmp83__length1;
#line 165 "../src/utils/Utils.vala"
						self->priv->__cmd_size_ = self->priv->_cmd_length1;
#line 139 "../src/utils/Utils.vala"
						tweak_cmd = (_vala_array_free (tweak_cmd, tweak_cmd_length1, (GDestroyNotify) g_free), NULL);
#line 139 "../src/utils/Utils.vala"
						tweaked_cmd = (_vala_array_free (tweaked_cmd, tweaked_cmd_length1, (GDestroyNotify) g_free), NULL);
#line 2772 "Utils.c"
					}
#line 122 "../src/utils/Utils.vala"
					_g_object_unref0 (tweak);
#line 2776 "Utils.c"
				}
			}
		}
	}
#line 184 "../src/utils/Utils.vala"
	if (self->priv->_log) {
#line 184 "../src/utils/Utils.vala"
		_tmp84_ = game_hub_application_log_verbose;
#line 2785 "Utils.c"
	} else {
#line 184 "../src/utils/Utils.vala"
		_tmp84_ = FALSE;
#line 2789 "Utils.c"
	}
#line 184 "../src/utils/Utils.vala"
	if (_tmp84_) {
#line 2793 "Utils.c"
		const gchar* _tmp88_;
		gchar** env_diff = NULL;
		gchar** _tmp89_;
		gint env_diff_length1;
		gint _env_diff_size_;
		gchar** env_clean = NULL;
		gchar** _tmp90_;
		gchar** _tmp91_;
		gint env_clean_length1;
		gint _env_clean_size_;
		gchar** _tmp92_;
		gint _tmp92__length1;
		gchar** _tmp98_;
		gint _tmp98__length1;
#line 186 "../src/utils/Utils.vala"
		if (cmd_expanded) {
#line 2810 "Utils.c"
			gchar** _tmp85_;
			gint _tmp85__length1;
			gchar* _tmp86_;
			gchar* _tmp87_;
#line 186 "../src/utils/Utils.vala"
			_tmp85_ = self->priv->_cmd;
#line 186 "../src/utils/Utils.vala"
			_tmp85__length1 = self->priv->_cmd_length1;
#line 186 "../src/utils/Utils.vala"
			_tmp86_ = _vala_g_strjoinv ("' '", _tmp85_, (gint) _tmp85__length1);
#line 186 "../src/utils/Utils.vala"
			_tmp87_ = _tmp86_;
#line 186 "../src/utils/Utils.vala"
			g_debug ("Utils.vala:186:      cmd: {'%s'}", _tmp87_);
#line 186 "../src/utils/Utils.vala"
			_g_free0 (_tmp87_);
#line 2827 "Utils.c"
		}
#line 187 "../src/utils/Utils.vala"
		_tmp88_ = self->priv->_dir;
#line 187 "../src/utils/Utils.vala"
		g_debug ("Utils.vala:187:      dir: '%s'", _tmp88_);
#line 189 "../src/utils/Utils.vala"
		_tmp89_ = g_new0 (gchar*, 0 + 1);
#line 189 "../src/utils/Utils.vala"
		env_diff = _tmp89_;
#line 189 "../src/utils/Utils.vala"
		env_diff_length1 = 0;
#line 189 "../src/utils/Utils.vala"
		_env_diff_size_ = env_diff_length1;
#line 190 "../src/utils/Utils.vala"
		_tmp91_ = _tmp90_ = g_get_environ ();
#line 190 "../src/utils/Utils.vala"
		env_clean = _tmp91_;
#line 190 "../src/utils/Utils.vala"
		env_clean_length1 = _vala_array_length (_tmp90_);
#line 190 "../src/utils/Utils.vala"
		_env_clean_size_ = env_clean_length1;
#line 191 "../src/utils/Utils.vala"
		_tmp92_ = self->priv->_env;
#line 191 "../src/utils/Utils.vala"
		_tmp92__length1 = self->priv->_env_length1;
#line 2853 "Utils.c"
		{
			gchar** env_var_collection = NULL;
			gint env_var_collection_length1 = 0;
			gint _env_var_collection_size_ = 0;
			gint env_var_it = 0;
#line 191 "../src/utils/Utils.vala"
			env_var_collection = _tmp92_;
#line 191 "../src/utils/Utils.vala"
			env_var_collection_length1 = _tmp92__length1;
#line 191 "../src/utils/Utils.vala"
			for (env_var_it = 0; env_var_it < env_var_collection_length1; env_var_it = env_var_it + 1) {
#line 2865 "Utils.c"
				gchar* _tmp93_;
				gchar* env_var = NULL;
#line 191 "../src/utils/Utils.vala"
				_tmp93_ = g_strdup (env_var_collection[env_var_it]);
#line 191 "../src/utils/Utils.vala"
				env_var = _tmp93_;
#line 2872 "Utils.c"
				{
					const gchar* _tmp94_;
					gchar** _tmp95_;
					gint _tmp95__length1;
#line 193 "../src/utils/Utils.vala"
					_tmp94_ = env_var;
#line 193 "../src/utils/Utils.vala"
					_tmp95_ = env_clean;
#line 193 "../src/utils/Utils.vala"
					_tmp95__length1 = env_clean_length1;
#line 193 "../src/utils/Utils.vala"
					if (!_vala_string_array_contains (_tmp95_, _tmp95__length1, _tmp94_)) {
#line 2885 "Utils.c"
						const gchar* _tmp96_;
						gchar* _tmp97_;
#line 195 "../src/utils/Utils.vala"
						_tmp96_ = env_var;
#line 195 "../src/utils/Utils.vala"
						_tmp97_ = g_strdup (_tmp96_);
#line 195 "../src/utils/Utils.vala"
						_vala_array_add61 (&env_diff, &env_diff_length1, &_env_diff_size_, _tmp97_);
#line 2894 "Utils.c"
					}
#line 191 "../src/utils/Utils.vala"
					_g_free0 (env_var);
#line 2898 "Utils.c"
				}
			}
		}
#line 198 "../src/utils/Utils.vala"
		_tmp98_ = env_diff;
#line 198 "../src/utils/Utils.vala"
		_tmp98__length1 = env_diff_length1;
#line 198 "../src/utils/Utils.vala"
		if (_tmp98__length1 > 0) {
#line 2908 "Utils.c"
			gchar** _tmp99_;
			gint _tmp99__length1;
			gchar* _tmp100_;
			gchar* _tmp101_;
#line 200 "../src/utils/Utils.vala"
			_tmp99_ = env_diff;
#line 200 "../src/utils/Utils.vala"
			_tmp99__length1 = env_diff_length1;
#line 200 "../src/utils/Utils.vala"
			_tmp100_ = _vala_g_strjoinv ("'\n                  '", _tmp99_, (gint) _tmp99__length1);
#line 200 "../src/utils/Utils.vala"
			_tmp101_ = _tmp100_;
#line 200 "../src/utils/Utils.vala"
			g_debug ("Utils.vala:200:      env: {\n                  '%s'\n              }", _tmp101_);
#line 200 "../src/utils/Utils.vala"
			_g_free0 (_tmp101_);
#line 2925 "Utils.c"
		}
#line 184 "../src/utils/Utils.vala"
		env_clean = (_vala_array_free (env_clean, env_clean_length1, (GDestroyNotify) g_free), NULL);
#line 184 "../src/utils/Utils.vala"
		env_diff = (_vala_array_free (env_diff, env_diff_length1, (GDestroyNotify) g_free), NULL);
#line 2931 "Utils.c"
	}
#line 103 "../src/utils/Utils.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 2935 "Utils.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 2956 "Utils.c"
}

GameHubUtilsRunTaskResult*
game_hub_utils_run_task_run_sync (GameHubUtilsRunTask* self,
                                  gboolean capture_output)
{
	gboolean is_called_from_thread = FALSE;
	GError* _inner_error0_ = NULL;
	GameHubUtilsRunTaskResult* result;
#line 206 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 208 "../src/utils/Utils.vala"
	is_called_from_thread = self->priv->_expanded;
#line 209 "../src/utils/Utils.vala"
	game_hub_utils_run_task_expand (self);
#line 2972 "Utils.c"
	{
		gboolean _tmp0_ = FALSE;
		gint status = 0;
#line 212 "../src/utils/Utils.vala"
		if (self->priv->_log) {
#line 212 "../src/utils/Utils.vala"
			_tmp0_ = !is_called_from_thread;
#line 2980 "Utils.c"
		} else {
#line 212 "../src/utils/Utils.vala"
			_tmp0_ = FALSE;
#line 2984 "Utils.c"
		}
#line 212 "../src/utils/Utils.vala"
		if (_tmp0_) {
#line 212 "../src/utils/Utils.vala"
			g_debug ("Utils.vala:212:      .run_sync()");
#line 2990 "Utils.c"
		}
#line 214 "../src/utils/Utils.vala"
		if (capture_output) {
#line 2994 "Utils.c"
			gchar* sout = NULL;
			gchar* serr = NULL;
			const gchar* _tmp1_;
			gchar** _tmp2_;
			gint _tmp2__length1;
			gchar** _tmp3_;
			gint _tmp3__length1;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			GameHubUtilsRunTaskResult* _tmp23_;
#line 218 "../src/utils/Utils.vala"
			_tmp1_ = self->priv->_dir;
#line 218 "../src/utils/Utils.vala"
			_tmp2_ = self->priv->_cmd;
#line 218 "../src/utils/Utils.vala"
			_tmp2__length1 = self->priv->_cmd_length1;
#line 218 "../src/utils/Utils.vala"
			_tmp3_ = self->priv->_env;
#line 218 "../src/utils/Utils.vala"
			_tmp3__length1 = self->priv->_env_length1;
#line 218 "../src/utils/Utils.vala"
			g_spawn_sync (_tmp1_, _tmp2_, _tmp3_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, &_tmp5_, &_tmp6_, &_inner_error0_);
#line 218 "../src/utils/Utils.vala"
			_g_free0 (sout);
#line 218 "../src/utils/Utils.vala"
			sout = _tmp4_;
#line 218 "../src/utils/Utils.vala"
			_g_free0 (serr);
#line 218 "../src/utils/Utils.vala"
			serr = _tmp5_;
#line 218 "../src/utils/Utils.vala"
			status = _tmp6_;
#line 218 "../src/utils/Utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 218 "../src/utils/Utils.vala"
				_g_free0 (serr);
#line 218 "../src/utils/Utils.vala"
				_g_free0 (sout);
#line 3040 "Utils.c"
				goto __catch0_g_error;
			}
#line 219 "../src/utils/Utils.vala"
			_tmp7_ = sout;
#line 219 "../src/utils/Utils.vala"
			_tmp8_ = string_strip (_tmp7_);
#line 219 "../src/utils/Utils.vala"
			_g_free0 (sout);
#line 219 "../src/utils/Utils.vala"
			sout = _tmp8_;
#line 220 "../src/utils/Utils.vala"
			_tmp9_ = serr;
#line 220 "../src/utils/Utils.vala"
			_tmp10_ = string_strip (_tmp9_);
#line 220 "../src/utils/Utils.vala"
			_g_free0 (serr);
#line 220 "../src/utils/Utils.vala"
			serr = _tmp10_;
#line 221 "../src/utils/Utils.vala"
			if (self->priv->_log) {
#line 3061 "Utils.c"
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
#line 223 "../src/utils/Utils.vala"
				_tmp11_ = sout;
#line 223 "../src/utils/Utils.vala"
				_tmp12_ = strlen (_tmp11_);
#line 223 "../src/utils/Utils.vala"
				_tmp13_ = _tmp12_;
#line 223 "../src/utils/Utils.vala"
				if (_tmp13_ > 0) {
#line 3076 "Utils.c"
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
#line 223 "../src/utils/Utils.vala"
					_tmp14_ = sout;
#line 223 "../src/utils/Utils.vala"
					_tmp15_ = g_strconcat (_tmp14_, "\n", NULL);
#line 223 "../src/utils/Utils.vala"
					_tmp16_ = _tmp15_;
#line 223 "../src/utils/Utils.vala"
					g_print ("%s", _tmp16_);
#line 223 "../src/utils/Utils.vala"
					_g_free0 (_tmp16_);
#line 3090 "Utils.c"
				}
#line 224 "../src/utils/Utils.vala"
				_tmp17_ = serr;
#line 224 "../src/utils/Utils.vala"
				_tmp18_ = strlen (_tmp17_);
#line 224 "../src/utils/Utils.vala"
				_tmp19_ = _tmp18_;
#line 224 "../src/utils/Utils.vala"
				if (_tmp19_ > 0) {
#line 3100 "Utils.c"
					const gchar* _tmp20_;
#line 224 "../src/utils/Utils.vala"
					_tmp20_ = serr;
#line 224 "../src/utils/Utils.vala"
					g_warning ("Utils.vala:224: %s", _tmp20_);
#line 3106 "Utils.c"
				}
			}
#line 226 "../src/utils/Utils.vala"
			_tmp21_ = sout;
#line 226 "../src/utils/Utils.vala"
			_tmp22_ = serr;
#line 226 "../src/utils/Utils.vala"
			_tmp23_ = game_hub_utils_run_task_result_new (&status, _tmp21_, _tmp22_);
#line 226 "../src/utils/Utils.vala"
			result = _tmp23_;
#line 226 "../src/utils/Utils.vala"
			_g_free0 (serr);
#line 226 "../src/utils/Utils.vala"
			_g_free0 (sout);
#line 226 "../src/utils/Utils.vala"
			return result;
#line 3123 "Utils.c"
		} else {
			const gchar* _tmp24_;
			gchar** _tmp25_;
			gint _tmp25__length1;
			gchar** _tmp26_;
			gint _tmp26__length1;
			gint _tmp27_ = 0;
			GameHubUtilsRunTaskResult* _tmp28_;
#line 230 "../src/utils/Utils.vala"
			_tmp24_ = self->priv->_dir;
#line 230 "../src/utils/Utils.vala"
			_tmp25_ = self->priv->_cmd;
#line 230 "../src/utils/Utils.vala"
			_tmp25__length1 = self->priv->_cmd_length1;
#line 230 "../src/utils/Utils.vala"
			_tmp26_ = self->priv->_env;
#line 230 "../src/utils/Utils.vala"
			_tmp26__length1 = self->priv->_env_length1;
#line 230 "../src/utils/Utils.vala"
			g_spawn_sync (_tmp24_, _tmp25_, _tmp26_, (G_SPAWN_SEARCH_PATH | G_SPAWN_CHILD_INHERITS_STDIN) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, NULL, NULL, &_tmp27_, &_inner_error0_);
#line 230 "../src/utils/Utils.vala"
			status = _tmp27_;
#line 230 "../src/utils/Utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3148 "Utils.c"
				goto __catch0_g_error;
			}
#line 231 "../src/utils/Utils.vala"
			_tmp28_ = game_hub_utils_run_task_result_new (&status, NULL, NULL);
#line 231 "../src/utils/Utils.vala"
			result = _tmp28_;
#line 231 "../src/utils/Utils.vala"
			return result;
#line 3157 "Utils.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
#line 210 "../src/utils/Utils.vala"
		e = _inner_error0_;
#line 210 "../src/utils/Utils.vala"
		_inner_error0_ = NULL;
#line 236 "../src/utils/Utils.vala"
		_tmp29_ = e;
#line 236 "../src/utils/Utils.vala"
		_tmp30_ = _tmp29_->message;
#line 236 "../src/utils/Utils.vala"
		g_warning ("Utils.vala:236: [RunTask.run_sync] %s", _tmp30_);
#line 210 "../src/utils/Utils.vala"
		_g_error_free0 (e);
#line 3178 "Utils.c"
	}
	__finally0:
#line 210 "../src/utils/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 210 "../src/utils/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 210 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 210 "../src/utils/Utils.vala"
		return NULL;
#line 3189 "Utils.c"
	}
#line 238 "../src/utils/Utils.vala"
	result = NULL;
#line 238 "../src/utils/Utils.vala"
	return result;
#line 3195 "Utils.c"
}

static void
game_hub_utils_run_task_run_sync_thread_data_free (gpointer _data)
{
	GameHubUtilsRunTaskRunSyncThreadData* _data_;
	_data_ = _data;
#line 84 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_result_unref0 (_data_->result);
#line 84 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_unref0 (_data_->self);
#line 84 "../src/utils/Utils.vala"
	g_slice_free (GameHubUtilsRunTaskRunSyncThreadData, _data_);
#line 3209 "Utils.c"
}

void
game_hub_utils_run_task_run_sync_thread (GameHubUtilsRunTask* self,
                                         gboolean capture_output,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GameHubUtilsRunTaskRunSyncThreadData* _data_;
	GameHubUtilsRunTask* _tmp0_;
#line 84 "../src/utils/Utils.vala"
	g_return_if_fail (self != NULL);
#line 84 "../src/utils/Utils.vala"
	_data_ = g_slice_new0 (GameHubUtilsRunTaskRunSyncThreadData);
#line 84 "../src/utils/Utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 84 "../src/utils/Utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_run_task_run_sync_thread_data_free);
#line 84 "../src/utils/Utils.vala"
	_tmp0_ = _game_hub_utils_run_task_ref0 (self);
#line 84 "../src/utils/Utils.vala"
	_data_->self = _tmp0_;
#line 84 "../src/utils/Utils.vala"
	_data_->capture_output = capture_output;
#line 84 "../src/utils/Utils.vala"
	game_hub_utils_run_task_run_sync_thread_co (_data_);
#line 3236 "Utils.c"
}

GameHubUtilsRunTaskResult*
game_hub_utils_run_task_run_sync_thread_finish (GameHubUtilsRunTask* self,
                                                GAsyncResult* _res_)
{
	GameHubUtilsRunTaskResult* result;
	GameHubUtilsRunTaskRunSyncThreadData* _data_;
#line 84 "../src/utils/Utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 84 "../src/utils/Utils.vala"
	result = _data_->result;
#line 84 "../src/utils/Utils.vala"
	_data_->result = NULL;
#line 84 "../src/utils/Utils.vala"
	return result;
#line 3253 "Utils.c"
}

static Block121Data*
block121_data_ref (Block121Data* _data121_)
{
#line 241 "../src/utils/Utils.vala"
	g_atomic_int_inc (&_data121_->_ref_count_);
#line 241 "../src/utils/Utils.vala"
	return _data121_;
#line 3263 "Utils.c"
}

static void
block121_data_unref (void * _userdata_)
{
	Block121Data* _data121_;
	_data121_ = (Block121Data*) _userdata_;
#line 241 "../src/utils/Utils.vala"
	if (g_atomic_int_dec_and_test (&_data121_->_ref_count_)) {
#line 3273 "Utils.c"
		GameHubUtilsRunTask* self;
#line 241 "../src/utils/Utils.vala"
		self = _data121_->self;
#line 241 "../src/utils/Utils.vala"
		_game_hub_utils_run_task_result_unref0 (_data121_->_result_);
#line 241 "../src/utils/Utils.vala"
		_game_hub_utils_run_task_unref0 (self);
#line 241 "../src/utils/Utils.vala"
		g_slice_free (Block121Data, _data121_);
#line 3283 "Utils.c"
	}
}

static gboolean
_game_hub_utils_run_task_run_sync_thread_co_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hub_utils_run_task_run_sync_thread_co (self);
#line 248 "../src/utils/Utils.vala"
	return result;
#line 3294 "Utils.c"
}

static void
__lambda21_ (Block121Data* _data121_)
{
	GameHubUtilsRunTask* self;
	GameHubUtilsRunTaskResult* _tmp0_;
#line 245 "../src/utils/Utils.vala"
	self = _data121_->self;
#line 246 "../src/utils/Utils.vala"
	if (self->priv->_log) {
#line 246 "../src/utils/Utils.vala"
		g_debug ("Utils.vala:246:      .run_sync_thread()");
#line 3308 "Utils.c"
	}
#line 247 "../src/utils/Utils.vala"
	_tmp0_ = game_hub_utils_run_task_run_sync (self, _data121_->capture_output);
#line 247 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_result_unref0 (_data121_->_result_);
#line 247 "../src/utils/Utils.vala"
	_data121_->_result_ = _tmp0_;
#line 248 "../src/utils/Utils.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _game_hub_utils_run_task_run_sync_thread_co_gsource_func, _data121_->_async_data_, NULL);
#line 3318 "Utils.c"
}

static void
___lambda21__game_hub_utils_future (gpointer self)
{
#line 245 "../src/utils/Utils.vala"
	__lambda21_ (self);
#line 3326 "Utils.c"
}

static gpointer
_game_hub_utils_run_task_result_ref0 (gpointer self)
{
#line 251 "../src/utils/Utils.vala"
	return self ? game_hub_utils_run_task_result_ref (self) : NULL;
#line 3334 "Utils.c"
}

static gboolean
game_hub_utils_run_task_run_sync_thread_co (GameHubUtilsRunTaskRunSyncThreadData* _data_)
{
#line 241 "../src/utils/Utils.vala"
	switch (_data_->_state_) {
#line 241 "../src/utils/Utils.vala"
		case 0:
#line 3344 "Utils.c"
		goto _state_0;
#line 241 "../src/utils/Utils.vala"
		case 1:
#line 3348 "Utils.c"
		goto _state_1;
		default:
#line 241 "../src/utils/Utils.vala"
		g_assert_not_reached ();
#line 3353 "Utils.c"
	}
	_state_0:
#line 241 "../src/utils/Utils.vala"
	_data_->_data121_ = g_slice_new0 (Block121Data);
#line 241 "../src/utils/Utils.vala"
	_data_->_data121_->_ref_count_ = 1;
#line 241 "../src/utils/Utils.vala"
	_data_->_data121_->self = game_hub_utils_run_task_ref (_data_->self);
#line 241 "../src/utils/Utils.vala"
	_data_->_data121_->capture_output = _data_->capture_output;
#line 241 "../src/utils/Utils.vala"
	_data_->_data121_->_async_data_ = _data_;
#line 243 "../src/utils/Utils.vala"
	game_hub_utils_run_task_expand (_data_->self);
#line 244 "../src/utils/Utils.vala"
	_data_->_data121_->_result_ = NULL;
#line 245 "../src/utils/Utils.vala"
	game_hub_utils_thread ("RunTask.run_sync_thread", ___lambda21__game_hub_utils_future, block121_data_ref (_data_->_data121_), block121_data_unref, _data_->self->priv->_log);
#line 250 "../src/utils/Utils.vala"
	_data_->_state_ = 1;
#line 250 "../src/utils/Utils.vala"
	return FALSE;
#line 3376 "Utils.c"
	_state_1:
	;
#line 251 "../src/utils/Utils.vala"
	_data_->_tmp0_ = _game_hub_utils_run_task_result_ref0 (_data_->_data121_->_result_);
#line 251 "../src/utils/Utils.vala"
	_data_->result = _data_->_tmp0_;
#line 251 "../src/utils/Utils.vala"
	block121_data_unref (_data_->_data121_);
#line 251 "../src/utils/Utils.vala"
	_data_->_data121_ = NULL;
#line 251 "../src/utils/Utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 251 "../src/utils/Utils.vala"
	if (_data_->_state_ != 0) {
#line 251 "../src/utils/Utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 251 "../src/utils/Utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3395 "Utils.c"
		}
	}
#line 251 "../src/utils/Utils.vala"
	g_object_unref (_data_->_async_result);
#line 251 "../src/utils/Utils.vala"
	return FALSE;
#line 3402 "Utils.c"
}

static void
game_hub_utils_run_task_run_async_data_free (gpointer _data)
{
	GameHubUtilsRunTaskRunAsyncData* _data_;
	_data_ = _data;
#line 84 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_result_unref0 (_data_->result);
#line 84 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_unref0 (_data_->self);
#line 84 "../src/utils/Utils.vala"
	g_slice_free (GameHubUtilsRunTaskRunAsyncData, _data_);
#line 3416 "Utils.c"
}

void
game_hub_utils_run_task_run_async (GameHubUtilsRunTask* self,
                                   gboolean wait,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GameHubUtilsRunTaskRunAsyncData* _data_;
	GameHubUtilsRunTask* _tmp0_;
#line 84 "../src/utils/Utils.vala"
	g_return_if_fail (self != NULL);
#line 84 "../src/utils/Utils.vala"
	_data_ = g_slice_new0 (GameHubUtilsRunTaskRunAsyncData);
#line 84 "../src/utils/Utils.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 84 "../src/utils/Utils.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_run_task_run_async_data_free);
#line 84 "../src/utils/Utils.vala"
	_tmp0_ = _game_hub_utils_run_task_ref0 (self);
#line 84 "../src/utils/Utils.vala"
	_data_->self = _tmp0_;
#line 84 "../src/utils/Utils.vala"
	_data_->wait = wait;
#line 84 "../src/utils/Utils.vala"
	game_hub_utils_run_task_run_async_co (_data_);
#line 3443 "Utils.c"
}

GameHubUtilsRunTaskResult*
game_hub_utils_run_task_run_finish (GameHubUtilsRunTask* self,
                                    GAsyncResult* _res_)
{
	GameHubUtilsRunTaskResult* result;
	GameHubUtilsRunTaskRunAsyncData* _data_;
#line 84 "../src/utils/Utils.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 84 "../src/utils/Utils.vala"
	result = _data_->result;
#line 84 "../src/utils/Utils.vala"
	_data_->result = NULL;
#line 84 "../src/utils/Utils.vala"
	return result;
#line 3460 "Utils.c"
}

static Block122Data*
block122_data_ref (Block122Data* _data122_)
{
#line 254 "../src/utils/Utils.vala"
	g_atomic_int_inc (&_data122_->_ref_count_);
#line 254 "../src/utils/Utils.vala"
	return _data122_;
#line 3470 "Utils.c"
}

static void
block122_data_unref (void * _userdata_)
{
	Block122Data* _data122_;
	_data122_ = (Block122Data*) _userdata_;
#line 254 "../src/utils/Utils.vala"
	if (g_atomic_int_dec_and_test (&_data122_->_ref_count_)) {
#line 3480 "Utils.c"
		GameHubUtilsRunTask* self;
#line 254 "../src/utils/Utils.vala"
		self = _data122_->self;
#line 254 "../src/utils/Utils.vala"
		_game_hub_utils_run_task_result_unref0 (_data122_->_result_);
#line 254 "../src/utils/Utils.vala"
		_game_hub_utils_run_task_unref0 (self);
#line 254 "../src/utils/Utils.vala"
		g_slice_free (Block122Data, _data122_);
#line 3490 "Utils.c"
	}
}

static gboolean
_game_hub_utils_run_task_run_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hub_utils_run_task_run_async_co (self);
#line 266 "../src/utils/Utils.vala"
	return result;
#line 3501 "Utils.c"
}

static void
___lambda46_ (Block122Data* _data122_,
              GPid pid,
              gint status)
{
	GameHubUtilsRunTask* self;
	GameHubUtilsRunTaskResult* _tmp0_;
#line 263 "../src/utils/Utils.vala"
	self = _data122_->self;
#line 264 "../src/utils/Utils.vala"
	g_spawn_close_pid (pid);
#line 265 "../src/utils/Utils.vala"
	_tmp0_ = game_hub_utils_run_task_result_new (&status, NULL, NULL);
#line 265 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_result_unref0 (_data122_->_result_);
#line 265 "../src/utils/Utils.vala"
	_data122_->_result_ = _tmp0_;
#line 266 "../src/utils/Utils.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _game_hub_utils_run_task_run_async_co_gsource_func, _data122_->_async_data_, NULL);
#line 3523 "Utils.c"
}

static void
____lambda46__gchild_watch_func (GPid pid,
                                 gint wait_status,
                                 gpointer self)
{
#line 263 "../src/utils/Utils.vala"
	___lambda46_ (self, pid, wait_status);
#line 3533 "Utils.c"
}

static gboolean
game_hub_utils_run_task_run_async_co (GameHubUtilsRunTaskRunAsyncData* _data_)
{
#line 254 "../src/utils/Utils.vala"
	switch (_data_->_state_) {
#line 254 "../src/utils/Utils.vala"
		case 0:
#line 3543 "Utils.c"
		goto _state_0;
#line 254 "../src/utils/Utils.vala"
		case 1:
#line 3547 "Utils.c"
		goto _state_1;
		default:
#line 254 "../src/utils/Utils.vala"
		g_assert_not_reached ();
#line 3552 "Utils.c"
	}
	_state_0:
#line 254 "../src/utils/Utils.vala"
	_data_->_data122_ = g_slice_new0 (Block122Data);
#line 254 "../src/utils/Utils.vala"
	_data_->_data122_->_ref_count_ = 1;
#line 254 "../src/utils/Utils.vala"
	_data_->_data122_->self = game_hub_utils_run_task_ref (_data_->self);
#line 254 "../src/utils/Utils.vala"
	_data_->_data122_->_async_data_ = _data_;
#line 256 "../src/utils/Utils.vala"
	game_hub_utils_run_task_expand (_data_->self);
#line 257 "../src/utils/Utils.vala"
	_data_->_data122_->_result_ = NULL;
#line 3567 "Utils.c"
	{
#line 260 "../src/utils/Utils.vala"
		if (_data_->self->priv->_log) {
#line 260 "../src/utils/Utils.vala"
			g_debug ("Utils.vala:260:      .run_async()");
#line 3573 "Utils.c"
		}
#line 262 "../src/utils/Utils.vala"
		_data_->_tmp0_ = _data_->self->priv->_dir;
#line 262 "../src/utils/Utils.vala"
		_data_->_tmp1_ = _data_->self->priv->_cmd;
#line 262 "../src/utils/Utils.vala"
		_data_->_tmp1__length1 = _data_->self->priv->_cmd_length1;
#line 262 "../src/utils/Utils.vala"
		_data_->_tmp2_ = _data_->self->priv->_env;
#line 262 "../src/utils/Utils.vala"
		_data_->_tmp2__length1 = _data_->self->priv->_env_length1;
#line 262 "../src/utils/Utils.vala"
		_data_->_tmp3_ = 0;
#line 262 "../src/utils/Utils.vala"
		g_spawn_async (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_data_->_tmp3_, &_data_->_inner_error0_);
#line 262 "../src/utils/Utils.vala"
		_data_->pid = _data_->_tmp3_;
#line 262 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 3593 "Utils.c"
			goto __catch0_g_error;
		}
#line 263 "../src/utils/Utils.vala"
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _data_->pid, ____lambda46__gchild_watch_func, block122_data_ref (_data_->_data122_), block122_data_unref);
#line 3598 "Utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 258 "../src/utils/Utils.vala"
		_data_->e = _data_->_inner_error0_;
#line 258 "../src/utils/Utils.vala"
		_data_->_inner_error0_ = NULL;
#line 271 "../src/utils/Utils.vala"
		_data_->_tmp4_ = _data_->e;
#line 271 "../src/utils/Utils.vala"
		_data_->_tmp5_ = _data_->_tmp4_->message;
#line 271 "../src/utils/Utils.vala"
		g_warning ("Utils.vala:271: [RunTask.run_async] %s", _data_->_tmp5_);
#line 258 "../src/utils/Utils.vala"
		_g_error_free0 (_data_->e);
#line 3615 "Utils.c"
	}
	__finally0:
#line 258 "../src/utils/Utils.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 258 "../src/utils/Utils.vala"
		block122_data_unref (_data_->_data122_);
#line 258 "../src/utils/Utils.vala"
		_data_->_data122_ = NULL;
#line 258 "../src/utils/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 258 "../src/utils/Utils.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 258 "../src/utils/Utils.vala"
		g_object_unref (_data_->_async_result);
#line 258 "../src/utils/Utils.vala"
		return FALSE;
#line 3632 "Utils.c"
	}
#line 273 "../src/utils/Utils.vala"
	if (_data_->wait) {
#line 273 "../src/utils/Utils.vala"
		_data_->_state_ = 1;
#line 273 "../src/utils/Utils.vala"
		return FALSE;
#line 3640 "Utils.c"
		_state_1:
		;
	}
#line 274 "../src/utils/Utils.vala"
	_data_->_tmp6_ = _data_->_data122_->_result_;
#line 274 "../src/utils/Utils.vala"
	_data_->_tmp7_ = _game_hub_utils_run_task_result_ref0 (_data_->_tmp6_);
#line 274 "../src/utils/Utils.vala"
	_data_->result = _data_->_tmp7_;
#line 274 "../src/utils/Utils.vala"
	block122_data_unref (_data_->_data122_);
#line 274 "../src/utils/Utils.vala"
	_data_->_data122_ = NULL;
#line 274 "../src/utils/Utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 274 "../src/utils/Utils.vala"
	if (_data_->_state_ != 0) {
#line 274 "../src/utils/Utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 274 "../src/utils/Utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3662 "Utils.c"
		}
	}
#line 274 "../src/utils/Utils.vala"
	g_object_unref (_data_->_async_result);
#line 274 "../src/utils/Utils.vala"
	return FALSE;
#line 3669 "Utils.c"
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
#line 286 "../src/utils/Utils.vala"
	dup = g_new0 (gint, 1);
#line 286 "../src/utils/Utils.vala"
	memcpy (dup, self, sizeof (gint));
#line 286 "../src/utils/Utils.vala"
	return dup;
#line 3682 "Utils.c"
}

static gpointer
__int_dup0 (gpointer self)
{
#line 286 "../src/utils/Utils.vala"
	return self ? _int_dup (self) : NULL;
#line 3690 "Utils.c"
}

GameHubUtilsRunTaskResult*
game_hub_utils_run_task_result_construct (GType object_type,
                                          gint* status,
                                          const gchar* output,
                                          const gchar* errors)
{
	GameHubUtilsRunTaskResult* self = NULL;
	gint* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint* _tmp3_;
#line 284 "../src/utils/Utils.vala"
	self = (GameHubUtilsRunTaskResult*) g_type_create_instance (object_type);
#line 286 "../src/utils/Utils.vala"
	_tmp0_ = __int_dup0 (status);
#line 286 "../src/utils/Utils.vala"
	_g_free0 (self->status);
#line 286 "../src/utils/Utils.vala"
	self->status = _tmp0_;
#line 287 "../src/utils/Utils.vala"
	_tmp1_ = g_strdup (output);
#line 287 "../src/utils/Utils.vala"
	_g_free0 (self->output);
#line 287 "../src/utils/Utils.vala"
	self->output = _tmp1_;
#line 288 "../src/utils/Utils.vala"
	_tmp2_ = g_strdup (errors);
#line 288 "../src/utils/Utils.vala"
	_g_free0 (self->errors);
#line 288 "../src/utils/Utils.vala"
	self->errors = _tmp2_;
#line 289 "../src/utils/Utils.vala"
	_tmp3_ = self->status;
#line 289 "../src/utils/Utils.vala"
	if (_tmp3_ != NULL) {
#line 3728 "Utils.c"
		gint* _tmp4_;
		gint _tmp5_;
		gint* _tmp6_;
#line 291 "../src/utils/Utils.vala"
		_tmp4_ = self->status;
#line 291 "../src/utils/Utils.vala"
		_tmp5_ = WEXITSTATUS (*_tmp4_);
#line 291 "../src/utils/Utils.vala"
		_tmp6_ = __int_dup0 (&_tmp5_);
#line 291 "../src/utils/Utils.vala"
		_g_free0 (self->exit_code);
#line 291 "../src/utils/Utils.vala"
		self->exit_code = _tmp6_;
#line 3742 "Utils.c"
	}
#line 284 "../src/utils/Utils.vala"
	return self;
#line 3746 "Utils.c"
}

GameHubUtilsRunTaskResult*
game_hub_utils_run_task_result_new (gint* status,
                                    const gchar* output,
                                    const gchar* errors)
{
#line 284 "../src/utils/Utils.vala"
	return game_hub_utils_run_task_result_construct (GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, status, output, errors);
#line 3756 "Utils.c"
}

gboolean
game_hub_utils_run_task_result_check_status (GameHubUtilsRunTaskResult* self,
                                             GError** error)
{
	gint* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 295 "../src/utils/Utils.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 297 "../src/utils/Utils.vala"
	_tmp0_ = self->status;
#line 297 "../src/utils/Utils.vala"
	if (_tmp0_ != NULL) {
#line 3772 "Utils.c"
		gboolean _tmp1_ = FALSE;
		gint* _tmp2_;
#line 299 "../src/utils/Utils.vala"
		_tmp2_ = self->status;
#line 299 "../src/utils/Utils.vala"
		_tmp1_ = g_spawn_check_exit_status (*_tmp2_, &_inner_error0_);
#line 299 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3781 "Utils.c"
			gboolean _tmp3_ = FALSE;
#line 299 "../src/utils/Utils.vala"
			g_propagate_error (error, _inner_error0_);
#line 299 "../src/utils/Utils.vala"
			return _tmp3_;
#line 3787 "Utils.c"
		}
#line 299 "../src/utils/Utils.vala"
		result = _tmp1_;
#line 299 "../src/utils/Utils.vala"
		return result;
#line 3793 "Utils.c"
	}
#line 301 "../src/utils/Utils.vala"
	result = TRUE;
#line 301 "../src/utils/Utils.vala"
	return result;
#line 3799 "Utils.c"
}

static void
game_hub_utils_run_task_value_result_init (GValue* value)
{
#line 277 "../src/utils/Utils.vala"
	value->data[0].v_pointer = NULL;
#line 3807 "Utils.c"
}

static void
game_hub_utils_run_task_value_result_free_value (GValue* value)
{
#line 277 "../src/utils/Utils.vala"
	if (value->data[0].v_pointer) {
#line 277 "../src/utils/Utils.vala"
		game_hub_utils_run_task_result_unref (value->data[0].v_pointer);
#line 3817 "Utils.c"
	}
}

static void
game_hub_utils_run_task_value_result_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
#line 277 "../src/utils/Utils.vala"
	if (src_value->data[0].v_pointer) {
#line 277 "../src/utils/Utils.vala"
		dest_value->data[0].v_pointer = game_hub_utils_run_task_result_ref (src_value->data[0].v_pointer);
#line 3829 "Utils.c"
	} else {
#line 277 "../src/utils/Utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3833 "Utils.c"
	}
}

static gpointer
game_hub_utils_run_task_value_result_peek_pointer (const GValue* value)
{
#line 277 "../src/utils/Utils.vala"
	return value->data[0].v_pointer;
#line 3842 "Utils.c"
}

static gchar*
game_hub_utils_run_task_value_result_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
#line 277 "../src/utils/Utils.vala"
	if (collect_values[0].v_pointer) {
#line 3853 "Utils.c"
		GameHubUtilsRunTaskResult * object;
		object = collect_values[0].v_pointer;
#line 277 "../src/utils/Utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 277 "../src/utils/Utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3860 "Utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 277 "../src/utils/Utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3864 "Utils.c"
		}
#line 277 "../src/utils/Utils.vala"
		value->data[0].v_pointer = game_hub_utils_run_task_result_ref (object);
#line 3868 "Utils.c"
	} else {
#line 277 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 3872 "Utils.c"
	}
#line 277 "../src/utils/Utils.vala"
	return NULL;
#line 3876 "Utils.c"
}

static gchar*
game_hub_utils_run_task_value_result_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	GameHubUtilsRunTaskResult ** object_p;
	object_p = collect_values[0].v_pointer;
#line 277 "../src/utils/Utils.vala"
	if (!object_p) {
#line 277 "../src/utils/Utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3891 "Utils.c"
	}
#line 277 "../src/utils/Utils.vala"
	if (!value->data[0].v_pointer) {
#line 277 "../src/utils/Utils.vala"
		*object_p = NULL;
#line 3897 "Utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 277 "../src/utils/Utils.vala"
		*object_p = value->data[0].v_pointer;
#line 3901 "Utils.c"
	} else {
#line 277 "../src/utils/Utils.vala"
		*object_p = game_hub_utils_run_task_result_ref (value->data[0].v_pointer);
#line 3905 "Utils.c"
	}
#line 277 "../src/utils/Utils.vala"
	return NULL;
#line 3909 "Utils.c"
}

GParamSpec*
game_hub_utils_run_task_param_spec_result (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	GameHubUtilsRunTaskParamSpecResult* spec;
#line 277 "../src/utils/Utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT), NULL);
#line 277 "../src/utils/Utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 277 "../src/utils/Utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 277 "../src/utils/Utils.vala"
	return G_PARAM_SPEC (spec);
#line 3928 "Utils.c"
}

gpointer
game_hub_utils_run_task_value_get_result (const GValue* value)
{
#line 277 "../src/utils/Utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT), NULL);
#line 277 "../src/utils/Utils.vala"
	return value->data[0].v_pointer;
#line 3938 "Utils.c"
}

void
game_hub_utils_run_task_value_set_result (GValue* value,
                                          gpointer v_object)
{
	GameHubUtilsRunTaskResult * old;
#line 277 "../src/utils/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT));
#line 277 "../src/utils/Utils.vala"
	old = value->data[0].v_pointer;
#line 277 "../src/utils/Utils.vala"
	if (v_object) {
#line 277 "../src/utils/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT));
#line 277 "../src/utils/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 277 "../src/utils/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 277 "../src/utils/Utils.vala"
		game_hub_utils_run_task_result_ref (value->data[0].v_pointer);
#line 3960 "Utils.c"
	} else {
#line 277 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 3964 "Utils.c"
	}
#line 277 "../src/utils/Utils.vala"
	if (old) {
#line 277 "../src/utils/Utils.vala"
		game_hub_utils_run_task_result_unref (old);
#line 3970 "Utils.c"
	}
}

void
game_hub_utils_run_task_value_take_result (GValue* value,
                                           gpointer v_object)
{
	GameHubUtilsRunTaskResult * old;
#line 277 "../src/utils/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT));
#line 277 "../src/utils/Utils.vala"
	old = value->data[0].v_pointer;
#line 277 "../src/utils/Utils.vala"
	if (v_object) {
#line 277 "../src/utils/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT));
#line 277 "../src/utils/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 277 "../src/utils/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 3991 "Utils.c"
	} else {
#line 277 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 3995 "Utils.c"
	}
#line 277 "../src/utils/Utils.vala"
	if (old) {
#line 277 "../src/utils/Utils.vala"
		game_hub_utils_run_task_result_unref (old);
#line 4001 "Utils.c"
	}
}

static void
game_hub_utils_run_task_result_class_init (GameHubUtilsRunTaskResultClass * klass,
                                           gpointer klass_data)
{
#line 277 "../src/utils/Utils.vala"
	game_hub_utils_run_task_result_parent_class = g_type_class_peek_parent (klass);
#line 277 "../src/utils/Utils.vala"
	((GameHubUtilsRunTaskResultClass *) klass)->finalize = game_hub_utils_run_task_result_finalize;
#line 4013 "Utils.c"
}

static void
game_hub_utils_run_task_result_instance_init (GameHubUtilsRunTaskResult * self,
                                              gpointer klass)
{
#line 277 "../src/utils/Utils.vala"
	self->ref_count = 1;
#line 4022 "Utils.c"
}

static void
game_hub_utils_run_task_result_finalize (GameHubUtilsRunTaskResult * obj)
{
	GameHubUtilsRunTaskResult * self;
#line 277 "../src/utils/Utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResult);
#line 277 "../src/utils/Utils.vala"
	g_signal_handlers_destroy (self);
#line 279 "../src/utils/Utils.vala"
	_g_free0 (self->status);
#line 280 "../src/utils/Utils.vala"
	_g_free0 (self->exit_code);
#line 281 "../src/utils/Utils.vala"
	_g_free0 (self->output);
#line 282 "../src/utils/Utils.vala"
	_g_free0 (self->errors);
#line 4041 "Utils.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_run_task_result_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_hub_utils_run_task_value_result_init, game_hub_utils_run_task_value_result_free_value, game_hub_utils_run_task_value_result_copy_value, game_hub_utils_run_task_value_result_peek_pointer, "p", game_hub_utils_run_task_value_result_collect_value, "p", game_hub_utils_run_task_value_result_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsRunTaskResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_run_task_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsRunTaskResult), 0, (GInstanceInitFunc) game_hub_utils_run_task_result_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_hub_utils_run_task_result_type_id;
	game_hub_utils_run_task_result_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameHubUtilsRunTaskResult", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return game_hub_utils_run_task_result_type_id;
}

GType
game_hub_utils_run_task_result_get_type (void)
{
	static volatile gsize game_hub_utils_run_task_result_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_run_task_result_type_id__once)) {
		GType game_hub_utils_run_task_result_type_id;
		game_hub_utils_run_task_result_type_id = game_hub_utils_run_task_result_get_type_once ();
		g_once_init_leave (&game_hub_utils_run_task_result_type_id__once, game_hub_utils_run_task_result_type_id);
	}
	return game_hub_utils_run_task_result_type_id__once;
}

gpointer
game_hub_utils_run_task_result_ref (gpointer instance)
{
	GameHubUtilsRunTaskResult * self;
	self = instance;
#line 277 "../src/utils/Utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 277 "../src/utils/Utils.vala"
	return instance;
#line 4076 "Utils.c"
}

void
game_hub_utils_run_task_result_unref (gpointer instance)
{
	GameHubUtilsRunTaskResult * self;
	self = instance;
#line 277 "../src/utils/Utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 277 "../src/utils/Utils.vala"
		GAME_HUB_UTILS_RUN_TASK_RESULT_GET_CLASS (self)->finalize (self);
#line 277 "../src/utils/Utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4090 "Utils.c"
	}
}

static void
game_hub_utils_value_run_task_init (GValue* value)
{
#line 84 "../src/utils/Utils.vala"
	value->data[0].v_pointer = NULL;
#line 4099 "Utils.c"
}

static void
game_hub_utils_value_run_task_free_value (GValue* value)
{
#line 84 "../src/utils/Utils.vala"
	if (value->data[0].v_pointer) {
#line 84 "../src/utils/Utils.vala"
		game_hub_utils_run_task_unref (value->data[0].v_pointer);
#line 4109 "Utils.c"
	}
}

static void
game_hub_utils_value_run_task_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 84 "../src/utils/Utils.vala"
	if (src_value->data[0].v_pointer) {
#line 84 "../src/utils/Utils.vala"
		dest_value->data[0].v_pointer = game_hub_utils_run_task_ref (src_value->data[0].v_pointer);
#line 4121 "Utils.c"
	} else {
#line 84 "../src/utils/Utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4125 "Utils.c"
	}
}

static gpointer
game_hub_utils_value_run_task_peek_pointer (const GValue* value)
{
#line 84 "../src/utils/Utils.vala"
	return value->data[0].v_pointer;
#line 4134 "Utils.c"
}

static gchar*
game_hub_utils_value_run_task_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 84 "../src/utils/Utils.vala"
	if (collect_values[0].v_pointer) {
#line 4145 "Utils.c"
		GameHubUtilsRunTask * object;
		object = collect_values[0].v_pointer;
#line 84 "../src/utils/Utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 84 "../src/utils/Utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4152 "Utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 84 "../src/utils/Utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4156 "Utils.c"
		}
#line 84 "../src/utils/Utils.vala"
		value->data[0].v_pointer = game_hub_utils_run_task_ref (object);
#line 4160 "Utils.c"
	} else {
#line 84 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 4164 "Utils.c"
	}
#line 84 "../src/utils/Utils.vala"
	return NULL;
#line 4168 "Utils.c"
}

static gchar*
game_hub_utils_value_run_task_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	GameHubUtilsRunTask ** object_p;
	object_p = collect_values[0].v_pointer;
#line 84 "../src/utils/Utils.vala"
	if (!object_p) {
#line 84 "../src/utils/Utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4183 "Utils.c"
	}
#line 84 "../src/utils/Utils.vala"
	if (!value->data[0].v_pointer) {
#line 84 "../src/utils/Utils.vala"
		*object_p = NULL;
#line 4189 "Utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 84 "../src/utils/Utils.vala"
		*object_p = value->data[0].v_pointer;
#line 4193 "Utils.c"
	} else {
#line 84 "../src/utils/Utils.vala"
		*object_p = game_hub_utils_run_task_ref (value->data[0].v_pointer);
#line 4197 "Utils.c"
	}
#line 84 "../src/utils/Utils.vala"
	return NULL;
#line 4201 "Utils.c"
}

GParamSpec*
game_hub_utils_param_spec_run_task (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	GameHubUtilsParamSpecRunTask* spec;
#line 84 "../src/utils/Utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GAME_HUB_UTILS_TYPE_RUN_TASK), NULL);
#line 84 "../src/utils/Utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 84 "../src/utils/Utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 84 "../src/utils/Utils.vala"
	return G_PARAM_SPEC (spec);
#line 4220 "Utils.c"
}

gpointer
game_hub_utils_value_get_run_task (const GValue* value)
{
#line 84 "../src/utils/Utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_RUN_TASK), NULL);
#line 84 "../src/utils/Utils.vala"
	return value->data[0].v_pointer;
#line 4230 "Utils.c"
}

void
game_hub_utils_value_set_run_task (GValue* value,
                                   gpointer v_object)
{
	GameHubUtilsRunTask * old;
#line 84 "../src/utils/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_RUN_TASK));
#line 84 "../src/utils/Utils.vala"
	old = value->data[0].v_pointer;
#line 84 "../src/utils/Utils.vala"
	if (v_object) {
#line 84 "../src/utils/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_RUN_TASK));
#line 84 "../src/utils/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 84 "../src/utils/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 84 "../src/utils/Utils.vala"
		game_hub_utils_run_task_ref (value->data[0].v_pointer);
#line 4252 "Utils.c"
	} else {
#line 84 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 4256 "Utils.c"
	}
#line 84 "../src/utils/Utils.vala"
	if (old) {
#line 84 "../src/utils/Utils.vala"
		game_hub_utils_run_task_unref (old);
#line 4262 "Utils.c"
	}
}

void
game_hub_utils_value_take_run_task (GValue* value,
                                    gpointer v_object)
{
	GameHubUtilsRunTask * old;
#line 84 "../src/utils/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_RUN_TASK));
#line 84 "../src/utils/Utils.vala"
	old = value->data[0].v_pointer;
#line 84 "../src/utils/Utils.vala"
	if (v_object) {
#line 84 "../src/utils/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_RUN_TASK));
#line 84 "../src/utils/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 84 "../src/utils/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 4283 "Utils.c"
	} else {
#line 84 "../src/utils/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 4287 "Utils.c"
	}
#line 84 "../src/utils/Utils.vala"
	if (old) {
#line 84 "../src/utils/Utils.vala"
		game_hub_utils_run_task_unref (old);
#line 4293 "Utils.c"
	}
}

static void
game_hub_utils_run_task_class_init (GameHubUtilsRunTaskClass * klass,
                                    gpointer klass_data)
{
#line 84 "../src/utils/Utils.vala"
	game_hub_utils_run_task_parent_class = g_type_class_peek_parent (klass);
#line 84 "../src/utils/Utils.vala"
	((GameHubUtilsRunTaskClass *) klass)->finalize = game_hub_utils_run_task_finalize;
#line 84 "../src/utils/Utils.vala"
	g_type_class_adjust_private_offset (klass, &GameHubUtilsRunTask_private_offset);
#line 4307 "Utils.c"
}

static void
game_hub_utils_run_task_instance_init (GameHubUtilsRunTask * self,
                                       gpointer klass)
{
#line 84 "../src/utils/Utils.vala"
	self->priv = game_hub_utils_run_task_get_instance_private (self);
#line 87 "../src/utils/Utils.vala"
	self->priv->_dir = NULL;
#line 88 "../src/utils/Utils.vala"
	self->priv->_env = NULL;
#line 88 "../src/utils/Utils.vala"
	self->priv->_env_length1 = 0;
#line 88 "../src/utils/Utils.vala"
	self->priv->__env_size_ = self->priv->_env_length1;
#line 89 "../src/utils/Utils.vala"
	self->priv->_override_runtime = FALSE;
#line 90 "../src/utils/Utils.vala"
	self->priv->_log = TRUE;
#line 91 "../src/utils/Utils.vala"
	self->priv->_tweaks = NULL;
#line 91 "../src/utils/Utils.vala"
	self->priv->_tweaks_length1 = 0;
#line 91 "../src/utils/Utils.vala"
	self->priv->__tweaks_size_ = self->priv->_tweaks_length1;
#line 102 "../src/utils/Utils.vala"
	self->priv->_expanded = FALSE;
#line 84 "../src/utils/Utils.vala"
	self->ref_count = 1;
#line 4338 "Utils.c"
}

static void
game_hub_utils_run_task_finalize (GameHubUtilsRunTask * obj)
{
	GameHubUtilsRunTask * self;
#line 84 "../src/utils/Utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTask);
#line 84 "../src/utils/Utils.vala"
	g_signal_handlers_destroy (self);
#line 86 "../src/utils/Utils.vala"
	self->priv->_cmd = (_vala_array_free (self->priv->_cmd, self->priv->_cmd_length1, (GDestroyNotify) g_free), NULL);
#line 87 "../src/utils/Utils.vala"
	_g_free0 (self->priv->_dir);
#line 88 "../src/utils/Utils.vala"
	self->priv->_env = (_vala_array_free (self->priv->_env, self->priv->_env_length1, (GDestroyNotify) g_free), NULL);
#line 91 "../src/utils/Utils.vala"
	self->priv->_tweaks = (_vala_array_free (self->priv->_tweaks, self->priv->_tweaks_length1, (GDestroyNotify) g_object_unref), NULL);
#line 4357 "Utils.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_run_task_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_hub_utils_value_run_task_init, game_hub_utils_value_run_task_free_value, game_hub_utils_value_run_task_copy_value, game_hub_utils_value_run_task_peek_pointer, "p", game_hub_utils_value_run_task_collect_value, "p", game_hub_utils_value_run_task_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsRunTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_run_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsRunTask), 0, (GInstanceInitFunc) game_hub_utils_run_task_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_hub_utils_run_task_type_id;
	game_hub_utils_run_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameHubUtilsRunTask", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GameHubUtilsRunTask_private_offset = g_type_add_instance_private (game_hub_utils_run_task_type_id, sizeof (GameHubUtilsRunTaskPrivate));
	return game_hub_utils_run_task_type_id;
}

GType
game_hub_utils_run_task_get_type (void)
{
	static volatile gsize game_hub_utils_run_task_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_run_task_type_id__once)) {
		GType game_hub_utils_run_task_type_id;
		game_hub_utils_run_task_type_id = game_hub_utils_run_task_get_type_once ();
		g_once_init_leave (&game_hub_utils_run_task_type_id__once, game_hub_utils_run_task_type_id);
	}
	return game_hub_utils_run_task_type_id__once;
}

gpointer
game_hub_utils_run_task_ref (gpointer instance)
{
	GameHubUtilsRunTask * self;
	self = instance;
#line 84 "../src/utils/Utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 84 "../src/utils/Utils.vala"
	return instance;
#line 4393 "Utils.c"
}

void
game_hub_utils_run_task_unref (gpointer instance)
{
	GameHubUtilsRunTask * self;
	self = instance;
#line 84 "../src/utils/Utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 84 "../src/utils/Utils.vala"
		GAME_HUB_UTILS_RUN_TASK_GET_CLASS (self)->finalize (self);
#line 84 "../src/utils/Utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4407 "Utils.c"
	}
}

GameHubUtilsRunTask*
game_hub_utils_run (gchar** cmd,
                    gint cmd_length1)
{
	GameHubUtilsRunTask* _tmp0_;
	GameHubUtilsRunTask* result;
#line 308 "../src/utils/Utils.vala"
	_tmp0_ = game_hub_utils_run_task_new (cmd, cmd_length1);
#line 308 "../src/utils/Utils.vala"
	result = _tmp0_;
#line 308 "../src/utils/Utils.vala"
	return result;
#line 4423 "Utils.c"
}

GFile*
game_hub_utils_find_executable (const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* which = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	GFile* result;
#line 313 "../src/utils/Utils.vala"
	if (name == NULL) {
#line 313 "../src/utils/Utils.vala"
		_tmp0_ = TRUE;
#line 4444 "Utils.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 313 "../src/utils/Utils.vala"
		_tmp1_ = strlen (name);
#line 313 "../src/utils/Utils.vala"
		_tmp2_ = _tmp1_;
#line 313 "../src/utils/Utils.vala"
		_tmp0_ = _tmp2_ == 0;
#line 4454 "Utils.c"
	}
#line 313 "../src/utils/Utils.vala"
	if (_tmp0_) {
#line 313 "../src/utils/Utils.vala"
		result = NULL;
#line 313 "../src/utils/Utils.vala"
		return result;
#line 4462 "Utils.c"
	}
#line 314 "../src/utils/Utils.vala"
	_tmp4_ = g_find_program_in_path (name);
#line 314 "../src/utils/Utils.vala"
	_tmp3_ = _tmp4_;
#line 314 "../src/utils/Utils.vala"
	if (_tmp3_ == NULL) {
#line 4470 "Utils.c"
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		GameHubUtilsRunTask* _tmp9_;
		GameHubUtilsRunTask* _tmp10_;
		GameHubUtilsRunTask* _tmp11_;
		GameHubUtilsRunTask* _tmp12_;
		GameHubUtilsRunTaskResult* _tmp13_;
		GameHubUtilsRunTaskResult* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
#line 314 "../src/utils/Utils.vala"
		_tmp5_ = g_strdup ("which");
#line 314 "../src/utils/Utils.vala"
		_tmp6_ = g_strdup (name);
#line 314 "../src/utils/Utils.vala"
		_tmp7_ = g_new0 (gchar*, 2 + 1);
#line 314 "../src/utils/Utils.vala"
		_tmp7_[0] = _tmp5_;
#line 314 "../src/utils/Utils.vala"
		_tmp7_[1] = _tmp6_;
#line 314 "../src/utils/Utils.vala"
		_tmp8_ = _tmp7_;
#line 314 "../src/utils/Utils.vala"
		_tmp8__length1 = 2;
#line 314 "../src/utils/Utils.vala"
		_tmp9_ = game_hub_utils_run (_tmp8_, (gint) 2);
#line 314 "../src/utils/Utils.vala"
		_tmp10_ = _tmp9_;
#line 314 "../src/utils/Utils.vala"
		_tmp11_ = game_hub_utils_run_task_log (_tmp10_, FALSE);
#line 314 "../src/utils/Utils.vala"
		_tmp12_ = _tmp11_;
#line 314 "../src/utils/Utils.vala"
		_tmp13_ = game_hub_utils_run_task_run_sync (_tmp12_, TRUE);
#line 314 "../src/utils/Utils.vala"
		_tmp14_ = _tmp13_;
#line 314 "../src/utils/Utils.vala"
		_tmp15_ = _tmp14_->output;
#line 314 "../src/utils/Utils.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 314 "../src/utils/Utils.vala"
		_g_free0 (_tmp3_);
#line 314 "../src/utils/Utils.vala"
		_tmp3_ = _tmp16_;
#line 314 "../src/utils/Utils.vala"
		_game_hub_utils_run_task_result_unref0 (_tmp14_);
#line 314 "../src/utils/Utils.vala"
		_game_hub_utils_run_task_unref0 (_tmp12_);
#line 314 "../src/utils/Utils.vala"
		_game_hub_utils_run_task_unref0 (_tmp10_);
#line 314 "../src/utils/Utils.vala"
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
#line 4526 "Utils.c"
	}
#line 314 "../src/utils/Utils.vala"
	_tmp17_ = _tmp3_;
#line 314 "../src/utils/Utils.vala"
	_tmp3_ = NULL;
#line 314 "../src/utils/Utils.vala"
	which = _tmp17_;
#line 315 "../src/utils/Utils.vala"
	_tmp20_ = which;
#line 315 "../src/utils/Utils.vala"
	if (_tmp20_ == NULL) {
#line 315 "../src/utils/Utils.vala"
		_tmp19_ = TRUE;
#line 4540 "Utils.c"
	} else {
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
#line 315 "../src/utils/Utils.vala"
		_tmp21_ = which;
#line 315 "../src/utils/Utils.vala"
		_tmp22_ = strlen (_tmp21_);
#line 315 "../src/utils/Utils.vala"
		_tmp23_ = _tmp22_;
#line 315 "../src/utils/Utils.vala"
		_tmp19_ = _tmp23_ == 0;
#line 4553 "Utils.c"
	}
#line 315 "../src/utils/Utils.vala"
	if (_tmp19_) {
#line 315 "../src/utils/Utils.vala"
		_tmp18_ = TRUE;
#line 4559 "Utils.c"
	} else {
		const gchar* _tmp24_;
#line 315 "../src/utils/Utils.vala"
		_tmp24_ = which;
#line 315 "../src/utils/Utils.vala"
		_tmp18_ = !g_str_has_prefix (_tmp24_, "/");
#line 4566 "Utils.c"
	}
#line 315 "../src/utils/Utils.vala"
	if (_tmp18_) {
#line 317 "../src/utils/Utils.vala"
		result = NULL;
#line 317 "../src/utils/Utils.vala"
		_g_free0 (which);
#line 317 "../src/utils/Utils.vala"
		_g_free0 (_tmp3_);
#line 317 "../src/utils/Utils.vala"
		return result;
#line 4578 "Utils.c"
	}
#line 319 "../src/utils/Utils.vala"
	_tmp25_ = which;
#line 319 "../src/utils/Utils.vala"
	_tmp26_ = g_file_new_for_path (_tmp25_);
#line 319 "../src/utils/Utils.vala"
	result = _tmp26_;
#line 319 "../src/utils/Utils.vala"
	_g_free0 (which);
#line 319 "../src/utils/Utils.vala"
	_g_free0 (_tmp3_);
#line 319 "../src/utils/Utils.vala"
	return result;
#line 4592 "Utils.c"
}

static void
____lambda8_ (GameHubUtilsWorker* w)
{
#line 328 "../src/utils/Utils.vala"
	g_return_if_fail (w != NULL);
#line 328 "../src/utils/Utils.vala"
	game_hub_utils_worker_run (w);
#line 328 "../src/utils/Utils.vala"
	_game_hub_utils_worker_unref0 (w);
#line 4604 "Utils.c"
}

static void
_____lambda8__gfunc (gpointer data,
                     gpointer self)
{
#line 328 "../src/utils/Utils.vala"
	____lambda8_ ((GameHubUtilsWorker*) data);
#line 4613 "Utils.c"
}

void
game_hub_utils_thread (const gchar* name,
                       GameHubUtilsFuture worker,
                       gpointer worker_target,
                       GDestroyNotify worker_target_destroy_notify,
                       gboolean log)
{
	GError* _inner_error0_ = NULL;
#line 322 "../src/utils/Utils.vala"
	g_return_if_fail (name != NULL);
#line 4626 "Utils.c"
	{
		GThreadPool* _tmp0_;
		GThreadPool* _tmp4_;
		GameHubUtilsFuture _tmp5_;
		gpointer _tmp5__target;
		GDestroyNotify _tmp5__target_destroy_notify;
		GameHubUtilsWorker* _tmp6_;
#line 326 "../src/utils/Utils.vala"
		_tmp0_ = game_hub_utils_threadpool;
#line 326 "../src/utils/Utils.vala"
		if (_tmp0_ == NULL) {
#line 4638 "Utils.c"
			GThreadPool* _tmp1_ = NULL;
			GThreadPool* _tmp2_;
			GThreadPool* _tmp3_;
#line 328 "../src/utils/Utils.vala"
			_tmp2_ = g_thread_pool_new (_____lambda8__gfunc, NULL, game_hub_application_worker_threads, FALSE, &_inner_error0_);
#line 328 "../src/utils/Utils.vala"
			_tmp1_ = _tmp2_;
#line 328 "../src/utils/Utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4648 "Utils.c"
				goto __catch0_g_error;
			}
#line 328 "../src/utils/Utils.vala"
			_tmp3_ = _tmp1_;
#line 328 "../src/utils/Utils.vala"
			_tmp1_ = NULL;
#line 328 "../src/utils/Utils.vala"
			_g_thread_pool_free0 (game_hub_utils_threadpool);
#line 328 "../src/utils/Utils.vala"
			game_hub_utils_threadpool = _tmp3_;
#line 326 "../src/utils/Utils.vala"
			_g_thread_pool_free0 (_tmp1_);
#line 4661 "Utils.c"
		}
#line 330 "../src/utils/Utils.vala"
		_tmp4_ = game_hub_utils_threadpool;
#line 330 "../src/utils/Utils.vala"
		_tmp5_ = worker;
#line 330 "../src/utils/Utils.vala"
		_tmp5__target = worker_target;
#line 330 "../src/utils/Utils.vala"
		_tmp5__target_destroy_notify = worker_target_destroy_notify;
#line 330 "../src/utils/Utils.vala"
		worker = NULL;
#line 330 "../src/utils/Utils.vala"
		worker_target = NULL;
#line 330 "../src/utils/Utils.vala"
		worker_target_destroy_notify = NULL;
#line 330 "../src/utils/Utils.vala"
		_tmp6_ = game_hub_utils_worker_new (name, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify, log);
#line 330 "../src/utils/Utils.vala"
		g_thread_pool_push (_tmp4_, _tmp6_, &_inner_error0_);
#line 330 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4683 "Utils.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 324 "../src/utils/Utils.vala"
		e = _inner_error0_;
#line 324 "../src/utils/Utils.vala"
		_inner_error0_ = NULL;
#line 334 "../src/utils/Utils.vala"
		_tmp7_ = e;
#line 334 "../src/utils/Utils.vala"
		_tmp8_ = _tmp7_->message;
#line 334 "../src/utils/Utils.vala"
		g_warning ("Utils.vala:334: %s", _tmp8_);
#line 324 "../src/utils/Utils.vala"
		_g_error_free0 (e);
#line 4705 "Utils.c"
	}
	__finally0:
#line 324 "../src/utils/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 324 "../src/utils/Utils.vala"
		(worker_target_destroy_notify == NULL) ? NULL : (worker_target_destroy_notify (worker_target), NULL);
#line 324 "../src/utils/Utils.vala"
		worker = NULL;
#line 324 "../src/utils/Utils.vala"
		worker_target = NULL;
#line 324 "../src/utils/Utils.vala"
		worker_target_destroy_notify = NULL;
#line 324 "../src/utils/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 324 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 324 "../src/utils/Utils.vala"
		return;
#line 4724 "Utils.c"
	}
#line 322 "../src/utils/Utils.vala"
	(worker_target_destroy_notify == NULL) ? NULL : (worker_target_destroy_notify (worker_target), NULL);
#line 322 "../src/utils/Utils.vala"
	worker = NULL;
#line 322 "../src/utils/Utils.vala"
	worker_target = NULL;
#line 322 "../src/utils/Utils.vala"
	worker_target_destroy_notify = NULL;
#line 4734 "Utils.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 4756 "Utils.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 4760 "Utils.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 4766 "Utils.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 4770 "Utils.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 4774 "Utils.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 4782 "Utils.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 4810 "Utils.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 4819 "Utils.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 4833 "Utils.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 4842 "Utils.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 4856 "Utils.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 4865 "Utils.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 4874 "Utils.c"
}

gchar*
game_hub_utils_get_distro (void)
{
	const gchar* _tmp0_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GameHubUtilsRunTask* _tmp8_;
	GameHubUtilsRunTask* _tmp9_;
	GameHubUtilsRunTask* _tmp10_;
	GameHubUtilsRunTask* _tmp11_;
	GameHubUtilsRunTaskResult* _tmp12_;
	GameHubUtilsRunTaskResult* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result;
#line 340 "../src/utils/Utils.vala"
	_tmp0_ = game_hub_utils_distro;
#line 340 "../src/utils/Utils.vala"
	if (_tmp0_ != NULL) {
#line 4902 "Utils.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 340 "../src/utils/Utils.vala"
		_tmp1_ = game_hub_utils_distro;
#line 340 "../src/utils/Utils.vala"
		_tmp2_ = g_strdup (_tmp1_);
#line 340 "../src/utils/Utils.vala"
		result = _tmp2_;
#line 340 "../src/utils/Utils.vala"
		return result;
#line 4913 "Utils.c"
	}
#line 343 "../src/utils/Utils.vala"
	_tmp3_ = g_strdup ("bash");
#line 343 "../src/utils/Utils.vala"
	_tmp4_ = g_strdup ("-c");
#line 343 "../src/utils/Utils.vala"
	_tmp5_ = g_strdup ("lsb_release -ds 2>/dev/null || cat /etc/*release 2>/dev/null | head -n" \
"1 || uname -om");
#line 343 "../src/utils/Utils.vala"
	_tmp6_ = g_new0 (gchar*, 3 + 1);
#line 343 "../src/utils/Utils.vala"
	_tmp6_[0] = _tmp3_;
#line 343 "../src/utils/Utils.vala"
	_tmp6_[1] = _tmp4_;
#line 343 "../src/utils/Utils.vala"
	_tmp6_[2] = _tmp5_;
#line 343 "../src/utils/Utils.vala"
	_tmp7_ = _tmp6_;
#line 343 "../src/utils/Utils.vala"
	_tmp7__length1 = 3;
#line 343 "../src/utils/Utils.vala"
	_tmp8_ = game_hub_utils_run (_tmp7_, (gint) 3);
#line 343 "../src/utils/Utils.vala"
	_tmp9_ = _tmp8_;
#line 343 "../src/utils/Utils.vala"
	_tmp10_ = game_hub_utils_run_task_log (_tmp9_, FALSE);
#line 343 "../src/utils/Utils.vala"
	_tmp11_ = _tmp10_;
#line 343 "../src/utils/Utils.vala"
	_tmp12_ = game_hub_utils_run_task_run_sync (_tmp11_, TRUE);
#line 343 "../src/utils/Utils.vala"
	_tmp13_ = _tmp12_;
#line 343 "../src/utils/Utils.vala"
	_tmp14_ = _tmp13_->output;
#line 343 "../src/utils/Utils.vala"
	_tmp15_ = string_replace (_tmp14_, "\"", "");
#line 343 "../src/utils/Utils.vala"
	_g_free0 (game_hub_utils_distro);
#line 343 "../src/utils/Utils.vala"
	game_hub_utils_distro = _tmp15_;
#line 343 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_result_unref0 (_tmp13_);
#line 343 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_unref0 (_tmp11_);
#line 343 "../src/utils/Utils.vala"
	_game_hub_utils_run_task_unref0 (_tmp9_);
#line 343 "../src/utils/Utils.vala"
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
#line 357 "../src/utils/Utils.vala"
	_tmp16_ = game_hub_utils_distro;
#line 357 "../src/utils/Utils.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 357 "../src/utils/Utils.vala"
	result = _tmp17_;
#line 357 "../src/utils/Utils.vala"
	return result;
#line 4969 "Utils.c"
}

gchar*
game_hub_utils_get_desktop_environment (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 388 "../src/utils/Utils.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 388 "../src/utils/Utils.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 388 "../src/utils/Utils.vala"
	result = _tmp1_;
#line 388 "../src/utils/Utils.vala"
	return result;
#line 4986 "Utils.c"
}

gchar*
game_hub_utils_get_language_name (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 394 "../src/utils/Utils.vala"
	_tmp0_ = nl_langinfo ((nl_item) 786439);
#line 394 "../src/utils/Utils.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 394 "../src/utils/Utils.vala"
	result = _tmp1_;
#line 394 "../src/utils/Utils.vala"
	return result;
#line 5003 "Utils.c"
}

gboolean
game_hub_utils_is_package_installed (const gchar* package)
{
	gboolean result;
#line 400 "../src/utils/Utils.vala"
	g_return_val_if_fail (package != NULL, FALSE);
#line 408 "../src/utils/Utils.vala"
	result = FALSE;
#line 408 "../src/utils/Utils.vala"
	return result;
#line 5016 "Utils.c"
}

static void
game_hub_utils_sleep_async_data_free (gpointer _data)
{
	GameHubUtilsSleepAsyncData* _data_;
	_data_ = _data;
	g_slice_free (GameHubUtilsSleepAsyncData, _data_);
}

void
game_hub_utils_sleep_async (guint interval,
                            gint priority,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	GameHubUtilsSleepAsyncData* _data_;
	_data_ = g_slice_new0 (GameHubUtilsSleepAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_sleep_async_data_free);
	_data_->interval = interval;
	_data_->priority = priority;
	game_hub_utils_sleep_async_co (_data_);
}

void
game_hub_utils_sleep_finish (GAsyncResult* _res_)
{
	GameHubUtilsSleepAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block123Data*
block123_data_ref (Block123Data* _data123_)
{
#line 412 "../src/utils/Utils.vala"
	g_atomic_int_inc (&_data123_->_ref_count_);
#line 412 "../src/utils/Utils.vala"
	return _data123_;
#line 5056 "Utils.c"
}

static void
block123_data_unref (void * _userdata_)
{
	Block123Data* _data123_;
	_data123_ = (Block123Data*) _userdata_;
#line 412 "../src/utils/Utils.vala"
	if (g_atomic_int_dec_and_test (&_data123_->_ref_count_)) {
#line 412 "../src/utils/Utils.vala"
		g_slice_free (Block123Data, _data123_);
#line 5068 "Utils.c"
	}
}

static gboolean
__lambda22_ (Block123Data* _data123_)
{
	gboolean result;
#line 415 "../src/utils/Utils.vala"
	game_hub_utils_sleep_async_co (_data123_->_async_data_);
#line 416 "../src/utils/Utils.vala"
	result = FALSE;
#line 416 "../src/utils/Utils.vala"
	return result;
#line 5082 "Utils.c"
}

static gboolean
___lambda22__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda22_ (self);
#line 414 "../src/utils/Utils.vala"
	return result;
#line 5092 "Utils.c"
}

static gboolean
game_hub_utils_sleep_async_co (GameHubUtilsSleepAsyncData* _data_)
{
#line 412 "../src/utils/Utils.vala"
	switch (_data_->_state_) {
#line 412 "../src/utils/Utils.vala"
		case 0:
#line 5102 "Utils.c"
		goto _state_0;
#line 412 "../src/utils/Utils.vala"
		case 1:
#line 5106 "Utils.c"
		goto _state_1;
		default:
#line 412 "../src/utils/Utils.vala"
		g_assert_not_reached ();
#line 5111 "Utils.c"
	}
	_state_0:
#line 412 "../src/utils/Utils.vala"
	_data_->_data123_ = g_slice_new0 (Block123Data);
#line 412 "../src/utils/Utils.vala"
	_data_->_data123_->_ref_count_ = 1;
#line 412 "../src/utils/Utils.vala"
	_data_->_data123_->_async_data_ = _data_;
#line 414 "../src/utils/Utils.vala"
	g_timeout_add_full (_data_->priority, _data_->interval, ___lambda22__gsource_func, block123_data_ref (_data_->_data123_), block123_data_unref);
#line 418 "../src/utils/Utils.vala"
	_data_->_state_ = 1;
#line 418 "../src/utils/Utils.vala"
	return FALSE;
#line 5126 "Utils.c"
	_state_1:
	;
#line 412 "../src/utils/Utils.vala"
	block123_data_unref (_data_->_data123_);
#line 412 "../src/utils/Utils.vala"
	_data_->_data123_ = NULL;
#line 412 "../src/utils/Utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 412 "../src/utils/Utils.vala"
	if (_data_->_state_ != 0) {
#line 412 "../src/utils/Utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 412 "../src/utils/Utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5141 "Utils.c"
		}
	}
#line 412 "../src/utils/Utils.vala"
	g_object_unref (_data_->_async_result);
#line 412 "../src/utils/Utils.vala"
	return FALSE;
#line 5148 "Utils.c"
}

gchar*
game_hub_utils_md5 (const gchar* s)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* result;
#line 421 "../src/utils/Utils.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 423 "../src/utils/Utils.vala"
	_tmp0_ = strlen (s);
#line 423 "../src/utils/Utils.vala"
	_tmp1_ = _tmp0_;
#line 423 "../src/utils/Utils.vala"
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, s, (gsize) _tmp1_);
#line 423 "../src/utils/Utils.vala"
	result = _tmp2_;
#line 423 "../src/utils/Utils.vala"
	return result;
#line 5170 "Utils.c"
}

static void
game_hub_utils_compute_file_checksum_data_free (gpointer _data)
{
	GameHubUtilsComputeFileChecksumData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	g_slice_free (GameHubUtilsComputeFileChecksumData, _data_);
}

void
game_hub_utils_compute_file_checksum (GFile* file,
                                      GChecksumType type,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GameHubUtilsComputeFileChecksumData* _data_;
	GFile* _tmp0_;
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GameHubUtilsComputeFileChecksumData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_compute_file_checksum_data_free);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp0_;
	_data_->type = type;
	game_hub_utils_compute_file_checksum_co (_data_);
}

gchar*
game_hub_utils_compute_file_checksum_finish (GAsyncResult* _res_)
{
	gchar* result;
	GameHubUtilsComputeFileChecksumData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block124Data*
block124_data_ref (Block124Data* _data124_)
{
#line 426 "../src/utils/Utils.vala"
	g_atomic_int_inc (&_data124_->_ref_count_);
#line 426 "../src/utils/Utils.vala"
	return _data124_;
#line 5219 "Utils.c"
}

static void
block124_data_unref (void * _userdata_)
{
	Block124Data* _data124_;
	_data124_ = (Block124Data*) _userdata_;
#line 426 "../src/utils/Utils.vala"
	if (g_atomic_int_dec_and_test (&_data124_->_ref_count_)) {
#line 426 "../src/utils/Utils.vala"
		_g_free0 (_data124_->hash);
#line 426 "../src/utils/Utils.vala"
		_g_object_unref0 (_data124_->file);
#line 426 "../src/utils/Utils.vala"
		g_slice_free (Block124Data, _data124_);
#line 5235 "Utils.c"
	}
}

static gboolean
_game_hub_utils_compute_file_checksum_co_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hub_utils_compute_file_checksum_co (self);
#line 439 "../src/utils/Utils.vala"
	return result;
#line 5246 "Utils.c"
}

static void
__lambda44_ (Block124Data* _data124_)
{
	GChecksum* checksum = NULL;
	GChecksum* _tmp0_;
	FILE* stream = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	guint8 buf[4096] = {0};
	gsize size = 0UL;
	GChecksum* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
#line 430 "../src/utils/Utils.vala"
	_tmp0_ = g_checksum_new (_data124_->type);
#line 430 "../src/utils/Utils.vala"
	checksum = _tmp0_;
#line 431 "../src/utils/Utils.vala"
	_tmp1_ = g_file_get_path (_data124_->file);
#line 431 "../src/utils/Utils.vala"
	_tmp2_ = _tmp1_;
#line 431 "../src/utils/Utils.vala"
	_tmp3_ = g_fopen (_tmp2_, "rb");
#line 431 "../src/utils/Utils.vala"
	_tmp4_ = _tmp3_;
#line 431 "../src/utils/Utils.vala"
	_g_free0 (_tmp2_);
#line 431 "../src/utils/Utils.vala"
	stream = _tmp4_;
#line 434 "../src/utils/Utils.vala"
	while (TRUE) {
#line 5282 "Utils.c"
		FILE* _tmp5_;
		GChecksum* _tmp6_;
#line 434 "../src/utils/Utils.vala"
		_tmp5_ = stream;
#line 434 "../src/utils/Utils.vala"
		size = fread (buf, (gsize) 1, (gint) 4096, _tmp5_);
#line 434 "../src/utils/Utils.vala"
		if (!(size > ((gsize) 0))) {
#line 434 "../src/utils/Utils.vala"
			break;
#line 5293 "Utils.c"
		}
#line 436 "../src/utils/Utils.vala"
		_tmp6_ = checksum;
#line 436 "../src/utils/Utils.vala"
		g_checksum_update (_tmp6_, buf, size);
#line 5299 "Utils.c"
	}
#line 438 "../src/utils/Utils.vala"
	_tmp7_ = checksum;
#line 438 "../src/utils/Utils.vala"
	_tmp8_ = g_checksum_get_string (_tmp7_);
#line 438 "../src/utils/Utils.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 438 "../src/utils/Utils.vala"
	_g_free0 (_data124_->hash);
#line 438 "../src/utils/Utils.vala"
	_data124_->hash = _tmp9_;
#line 439 "../src/utils/Utils.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _game_hub_utils_compute_file_checksum_co_gsource_func, _data124_->_async_data_, NULL);
#line 429 "../src/utils/Utils.vala"
	_fclose0 (stream);
#line 429 "../src/utils/Utils.vala"
	_g_checksum_free0 (checksum);
#line 5317 "Utils.c"
}

static void
___lambda44__game_hub_utils_future (gpointer self)
{
#line 429 "../src/utils/Utils.vala"
	__lambda44_ (self);
#line 5325 "Utils.c"
}

static gboolean
game_hub_utils_compute_file_checksum_co (GameHubUtilsComputeFileChecksumData* _data_)
{
#line 426 "../src/utils/Utils.vala"
	switch (_data_->_state_) {
#line 426 "../src/utils/Utils.vala"
		case 0:
#line 5335 "Utils.c"
		goto _state_0;
#line 426 "../src/utils/Utils.vala"
		case 1:
#line 5339 "Utils.c"
		goto _state_1;
		default:
#line 426 "../src/utils/Utils.vala"
		g_assert_not_reached ();
#line 5344 "Utils.c"
	}
	_state_0:
#line 426 "../src/utils/Utils.vala"
	_data_->_data124_ = g_slice_new0 (Block124Data);
#line 426 "../src/utils/Utils.vala"
	_data_->_data124_->_ref_count_ = 1;
#line 426 "../src/utils/Utils.vala"
	_g_object_unref0 (_data_->_data124_->file);
#line 426 "../src/utils/Utils.vala"
	_data_->_data124_->file = _data_->file;
#line 426 "../src/utils/Utils.vala"
	_data_->_data124_->type = _data_->type;
#line 426 "../src/utils/Utils.vala"
	_data_->_data124_->_async_data_ = _data_;
#line 428 "../src/utils/Utils.vala"
	_data_->_data124_->hash = NULL;
#line 429 "../src/utils/Utils.vala"
	_data_->_tmp0_ = g_file_get_path (_data_->_data124_->file);
#line 429 "../src/utils/Utils.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 429 "../src/utils/Utils.vala"
	_data_->_tmp2_ = game_hub_utils_md5 (_data_->_tmp1_);
#line 429 "../src/utils/Utils.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 429 "../src/utils/Utils.vala"
	_data_->_tmp4_ = g_strconcat ("Checksum-", _data_->_tmp3_, NULL);
#line 429 "../src/utils/Utils.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 429 "../src/utils/Utils.vala"
	game_hub_utils_thread (_data_->_tmp5_, ___lambda44__game_hub_utils_future, block124_data_ref (_data_->_data124_), block124_data_unref, TRUE);
#line 429 "../src/utils/Utils.vala"
	_g_free0 (_data_->_tmp5_);
#line 429 "../src/utils/Utils.vala"
	_g_free0 (_data_->_tmp3_);
#line 429 "../src/utils/Utils.vala"
	_g_free0 (_data_->_tmp1_);
#line 441 "../src/utils/Utils.vala"
	_data_->_state_ = 1;
#line 441 "../src/utils/Utils.vala"
	return FALSE;
#line 5385 "Utils.c"
	_state_1:
	;
#line 442 "../src/utils/Utils.vala"
	_data_->_tmp6_ = g_strdup (_data_->_data124_->hash);
#line 442 "../src/utils/Utils.vala"
	_data_->result = _data_->_tmp6_;
#line 442 "../src/utils/Utils.vala"
	block124_data_unref (_data_->_data124_);
#line 442 "../src/utils/Utils.vala"
	_data_->_data124_ = NULL;
#line 442 "../src/utils/Utils.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 442 "../src/utils/Utils.vala"
	if (_data_->_state_ != 0) {
#line 442 "../src/utils/Utils.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 442 "../src/utils/Utils.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5404 "Utils.c"
		}
	}
#line 442 "../src/utils/Utils.vala"
	g_object_unref (_data_->_async_result);
#line 442 "../src/utils/Utils.vala"
	return FALSE;
#line 5411 "Utils.c"
}

gchar*
game_hub_utils_get_relative_datetime (GDateTime* date_time)
{
	gchar* _tmp0_;
	gchar* result;
#line 445 "../src/utils/Utils.vala"
	g_return_val_if_fail (date_time != NULL, NULL);
#line 447 "../src/utils/Utils.vala"
	_tmp0_ = g_date_time_format (date_time, "%x %R");
#line 447 "../src/utils/Utils.vala"
	result = _tmp0_;
#line 447 "../src/utils/Utils.vala"
	return result;
#line 5427 "Utils.c"
}

gchar*
game_hub_utils_minutes_to_string (gint64 min)
{
	gint h = 0;
	gint m = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
#line 452 "../src/utils/Utils.vala"
	h = ((gint) min) / 60;
#line 453 "../src/utils/Utils.vala"
	m = ((gint) min) - (h * 60);
#line 454 "../src/utils/Utils.vala"
	if (h > 0) {
#line 5447 "Utils.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 454 "../src/utils/Utils.vala"
		_tmp1_ = g_strdup_printf (C_ ("time", "%dh"), h);
#line 454 "../src/utils/Utils.vala"
		_tmp2_ = _tmp1_;
#line 454 "../src/utils/Utils.vala"
		_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
#line 454 "../src/utils/Utils.vala"
		_g_free0 (_tmp0_);
#line 454 "../src/utils/Utils.vala"
		_tmp0_ = _tmp3_;
#line 454 "../src/utils/Utils.vala"
		_g_free0 (_tmp2_);
#line 5463 "Utils.c"
	} else {
		gchar* _tmp4_;
#line 454 "../src/utils/Utils.vala"
		_tmp4_ = g_strdup ("");
#line 454 "../src/utils/Utils.vala"
		_g_free0 (_tmp0_);
#line 454 "../src/utils/Utils.vala"
		_tmp0_ = _tmp4_;
#line 5472 "Utils.c"
	}
#line 454 "../src/utils/Utils.vala"
	_tmp5_ = g_strdup_printf (C_ ("time", "%dm"), m);
#line 454 "../src/utils/Utils.vala"
	_tmp6_ = _tmp5_;
#line 454 "../src/utils/Utils.vala"
	_tmp7_ = g_strconcat (_tmp0_, _tmp6_, NULL);
#line 454 "../src/utils/Utils.vala"
	_tmp8_ = _tmp7_;
#line 454 "../src/utils/Utils.vala"
	_g_free0 (_tmp6_);
#line 454 "../src/utils/Utils.vala"
	result = _tmp8_;
#line 454 "../src/utils/Utils.vala"
	_g_free0 (_tmp0_);
#line 454 "../src/utils/Utils.vala"
	return result;
#line 5490 "Utils.c"
}

gchar*
game_hub_utils_seconds_to_string (gint64 sec)
{
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
#line 459 "../src/utils/Utils.vala"
	h = ((gint) sec) / 3600;
#line 460 "../src/utils/Utils.vala"
	m = ((gint) (sec - (h * 3600))) / 60;
#line 461 "../src/utils/Utils.vala"
	s = (((gint) sec) - (h * 3600)) - (m * 60);
#line 462 "../src/utils/Utils.vala"
	if (h > 0) {
#line 5516 "Utils.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 462 "../src/utils/Utils.vala"
		_tmp1_ = g_strdup_printf (C_ ("time", "%dh"), h);
#line 462 "../src/utils/Utils.vala"
		_tmp2_ = _tmp1_;
#line 462 "../src/utils/Utils.vala"
		_tmp3_ = g_strconcat (_tmp2_, " ", NULL);
#line 462 "../src/utils/Utils.vala"
		_g_free0 (_tmp0_);
#line 462 "../src/utils/Utils.vala"
		_tmp0_ = _tmp3_;
#line 462 "../src/utils/Utils.vala"
		_g_free0 (_tmp2_);
#line 5532 "Utils.c"
	} else {
		gchar* _tmp4_;
#line 462 "../src/utils/Utils.vala"
		_tmp4_ = g_strdup ("");
#line 462 "../src/utils/Utils.vala"
		_g_free0 (_tmp0_);
#line 462 "../src/utils/Utils.vala"
		_tmp0_ = _tmp4_;
#line 5541 "Utils.c"
	}
#line 462 "../src/utils/Utils.vala"
	if (m > 0) {
#line 5545 "Utils.c"
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 462 "../src/utils/Utils.vala"
		_tmp6_ = g_strdup_printf (C_ ("time", "%dm"), m);
#line 462 "../src/utils/Utils.vala"
		_tmp7_ = _tmp6_;
#line 462 "../src/utils/Utils.vala"
		_tmp8_ = g_strconcat (_tmp7_, " ", NULL);
#line 462 "../src/utils/Utils.vala"
		_g_free0 (_tmp5_);
#line 462 "../src/utils/Utils.vala"
		_tmp5_ = _tmp8_;
#line 462 "../src/utils/Utils.vala"
		_g_free0 (_tmp7_);
#line 5561 "Utils.c"
	} else {
		gchar* _tmp9_;
#line 462 "../src/utils/Utils.vala"
		_tmp9_ = g_strdup ("");
#line 462 "../src/utils/Utils.vala"
		_g_free0 (_tmp5_);
#line 462 "../src/utils/Utils.vala"
		_tmp5_ = _tmp9_;
#line 5570 "Utils.c"
	}
#line 462 "../src/utils/Utils.vala"
	_tmp10_ = g_strconcat (_tmp0_, _tmp5_, NULL);
#line 462 "../src/utils/Utils.vala"
	_tmp11_ = _tmp10_;
#line 462 "../src/utils/Utils.vala"
	_tmp12_ = g_strdup_printf (C_ ("time", "%ds"), s);
#line 462 "../src/utils/Utils.vala"
	_tmp13_ = _tmp12_;
#line 462 "../src/utils/Utils.vala"
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
#line 462 "../src/utils/Utils.vala"
	_tmp15_ = _tmp14_;
#line 462 "../src/utils/Utils.vala"
	_g_free0 (_tmp13_);
#line 462 "../src/utils/Utils.vala"
	_g_free0 (_tmp11_);
#line 462 "../src/utils/Utils.vala"
	result = _tmp15_;
#line 462 "../src/utils/Utils.vala"
	_g_free0 (_tmp5_);
#line 462 "../src/utils/Utils.vala"
	_g_free0 (_tmp0_);
#line 462 "../src/utils/Utils.vala"
	return result;
#line 5596 "Utils.c"
}

void
game_hub_utils_notify (const gchar* title,
                       const gchar* body,
                       GNotificationPriority priority,
                       GameHubUtilsNotificationConfigureDelegate config,
                       gpointer config_target)
{
	GNotification* notification = NULL;
	GNotification* _tmp0_;
	GNotification* _tmp1_;
	GNotification* _tmp2_;
	GameHubApplication* _tmp5_;
	GNotification* _tmp6_;
#line 465 "../src/utils/Utils.vala"
	g_return_if_fail (title != NULL);
#line 467 "../src/utils/Utils.vala"
	_tmp0_ = g_notification_new (title);
#line 467 "../src/utils/Utils.vala"
	notification = _tmp0_;
#line 468 "../src/utils/Utils.vala"
	_tmp1_ = notification;
#line 468 "../src/utils/Utils.vala"
	g_notification_set_body (_tmp1_, body);
#line 469 "../src/utils/Utils.vala"
	_tmp2_ = notification;
#line 469 "../src/utils/Utils.vala"
	g_notification_set_priority (_tmp2_, priority);
#line 470 "../src/utils/Utils.vala"
	if (config != NULL) {
#line 5628 "Utils.c"
		GNotification* _tmp3_;
		GNotification* _tmp4_;
#line 472 "../src/utils/Utils.vala"
		_tmp3_ = notification;
#line 472 "../src/utils/Utils.vala"
		_tmp4_ = config (_tmp3_, config_target);
#line 472 "../src/utils/Utils.vala"
		_g_object_unref0 (notification);
#line 472 "../src/utils/Utils.vala"
		notification = _tmp4_;
#line 5639 "Utils.c"
	}
#line 474 "../src/utils/Utils.vala"
	_tmp5_ = game_hub_application_instance;
#line 474 "../src/utils/Utils.vala"
	_tmp6_ = notification;
#line 474 "../src/utils/Utils.vala"
	g_application_send_notification ((GApplication*) _tmp5_, NULL, _tmp6_);
#line 465 "../src/utils/Utils.vala"
	_g_object_unref0 (notification);
#line 5649 "Utils.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 5672 "Utils.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 5681 "Utils.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 5700 "Utils.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 5704 "Utils.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 5710 "Utils.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 5720 "Utils.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 5728 "Utils.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 5732 "Utils.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 5738 "Utils.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 5748 "Utils.c"
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
#line 1302 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1303 "glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1304 "glib-2.0.vapi"
	if (_vala_c != ((gunichar) 0)) {
#line 5764 "Utils.c"
		gchar* _tmp0_;
#line 1305 "glib-2.0.vapi"
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1305 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1306 "glib-2.0.vapi"
		result = TRUE;
#line 1306 "glib-2.0.vapi"
		if (c) {
#line 1306 "glib-2.0.vapi"
			*c = _vala_c;
#line 5776 "Utils.c"
		}
#line 1306 "glib-2.0.vapi"
		return result;
#line 5780 "Utils.c"
	} else {
#line 1308 "glib-2.0.vapi"
		result = FALSE;
#line 1308 "glib-2.0.vapi"
		if (c) {
#line 1308 "glib-2.0.vapi"
			*c = _vala_c;
#line 5788 "Utils.c"
		}
#line 1308 "glib-2.0.vapi"
		return result;
#line 5792 "Utils.c"
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1122 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1122 "glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1123 "glib-2.0.vapi"
	g_unichar_to_utf8 (self, str);
#line 1124 "glib-2.0.vapi"
	result = str;
#line 1124 "glib-2.0.vapi"
	return result;
#line 5812 "Utils.c"
}

gchar*
game_hub_utils_strip_name (const gchar* name,
                           const gchar* keep,
                           gboolean move_the)
{
	gchar* n = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gunichar c = 0U;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 478 "../src/utils/Utils.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 480 "../src/utils/Utils.vala"
	if (name == NULL) {
#line 5835 "Utils.c"
		gchar* _tmp0_;
#line 480 "../src/utils/Utils.vala"
		_tmp0_ = g_strdup (name);
#line 480 "../src/utils/Utils.vala"
		result = _tmp0_;
#line 480 "../src/utils/Utils.vala"
		return result;
#line 5843 "Utils.c"
	}
#line 481 "../src/utils/Utils.vala"
	_tmp1_ = string_strip (name);
#line 481 "../src/utils/Utils.vala"
	n = _tmp1_;
#line 482 "../src/utils/Utils.vala"
	_tmp2_ = n;
#line 482 "../src/utils/Utils.vala"
	_tmp3_ = strlen (_tmp2_);
#line 482 "../src/utils/Utils.vala"
	_tmp4_ = _tmp3_;
#line 482 "../src/utils/Utils.vala"
	if (_tmp4_ == 0) {
#line 482 "../src/utils/Utils.vala"
		result = n;
#line 482 "../src/utils/Utils.vala"
		return result;
#line 5861 "Utils.c"
	}
#line 483 "../src/utils/Utils.vala"
	if (move_the) {
#line 5865 "Utils.c"
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
#line 483 "../src/utils/Utils.vala"
		_tmp6_ = n;
#line 483 "../src/utils/Utils.vala"
		_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
#line 483 "../src/utils/Utils.vala"
		_tmp8_ = _tmp7_;
#line 483 "../src/utils/Utils.vala"
		_tmp5_ = g_str_has_prefix (_tmp8_, "the ");
#line 483 "../src/utils/Utils.vala"
		_g_free0 (_tmp8_);
#line 5879 "Utils.c"
	} else {
#line 483 "../src/utils/Utils.vala"
		_tmp5_ = FALSE;
#line 5883 "Utils.c"
	}
#line 483 "../src/utils/Utils.vala"
	if (_tmp5_) {
#line 5887 "Utils.c"
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 485 "../src/utils/Utils.vala"
		_tmp9_ = n;
#line 485 "../src/utils/Utils.vala"
		_tmp10_ = string_substring (_tmp9_, (glong) 4, (glong) -1);
#line 485 "../src/utils/Utils.vala"
		_tmp11_ = _tmp10_;
#line 485 "../src/utils/Utils.vala"
		_tmp12_ = g_strconcat (_tmp11_, ", The", NULL);
#line 485 "../src/utils/Utils.vala"
		_g_free0 (n);
#line 485 "../src/utils/Utils.vala"
		n = _tmp12_;
#line 485 "../src/utils/Utils.vala"
		_g_free0 (_tmp11_);
#line 5906 "Utils.c"
	}
	{
		gint i = 0;
#line 488 "../src/utils/Utils.vala"
		i = 0;
#line 5912 "Utils.c"
		{
			gboolean _tmp13_ = FALSE;
#line 488 "../src/utils/Utils.vala"
			_tmp13_ = TRUE;
#line 488 "../src/utils/Utils.vala"
			while (TRUE) {
#line 5919 "Utils.c"
				gunichar _tmp14_ = 0U;
				gboolean _tmp15_;
				gboolean _tmp16_ = FALSE;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
#line 488 "../src/utils/Utils.vala"
				if (!_tmp13_) {
#line 5929 "Utils.c"
				}
#line 488 "../src/utils/Utils.vala"
				_tmp13_ = FALSE;
#line 488 "../src/utils/Utils.vala"
				_tmp15_ = string_get_next_char (GAME_HUB_UTILS_NAME_CHARS_TO_STRIP, &i, &_tmp14_);
#line 488 "../src/utils/Utils.vala"
				c = _tmp14_;
#line 488 "../src/utils/Utils.vala"
				if (!_tmp15_) {
#line 488 "../src/utils/Utils.vala"
					break;
#line 5941 "Utils.c"
				}
#line 490 "../src/utils/Utils.vala"
				if (keep != NULL) {
#line 490 "../src/utils/Utils.vala"
					_tmp16_ = g_strcmp0 (keep, "") != 0;
#line 5947 "Utils.c"
				} else {
#line 490 "../src/utils/Utils.vala"
					_tmp16_ = FALSE;
#line 5951 "Utils.c"
				}
#line 490 "../src/utils/Utils.vala"
				if (_tmp16_) {
#line 5955 "Utils.c"
					gunichar k = 0U;
					{
						gint j = 0;
#line 493 "../src/utils/Utils.vala"
						j = 0;
#line 5961 "Utils.c"
						{
							gboolean _tmp17_ = FALSE;
#line 493 "../src/utils/Utils.vala"
							_tmp17_ = TRUE;
#line 493 "../src/utils/Utils.vala"
							while (TRUE) {
#line 5968 "Utils.c"
								gunichar _tmp18_ = 0U;
								gboolean _tmp19_;
#line 493 "../src/utils/Utils.vala"
								if (!_tmp17_) {
#line 5973 "Utils.c"
								}
#line 493 "../src/utils/Utils.vala"
								_tmp17_ = FALSE;
#line 493 "../src/utils/Utils.vala"
								_tmp19_ = string_get_next_char (keep, &j, &_tmp18_);
#line 493 "../src/utils/Utils.vala"
								k = _tmp18_;
#line 493 "../src/utils/Utils.vala"
								if (!_tmp19_) {
#line 493 "../src/utils/Utils.vala"
									break;
#line 5985 "Utils.c"
								}
#line 495 "../src/utils/Utils.vala"
								if (k == c) {
#line 495 "../src/utils/Utils.vala"
									break;
#line 5991 "Utils.c"
								}
							}
						}
					}
#line 497 "../src/utils/Utils.vala"
					if (k == c) {
#line 497 "../src/utils/Utils.vala"
						continue;
#line 6000 "Utils.c"
					}
				}
#line 499 "../src/utils/Utils.vala"
				_tmp20_ = n;
#line 499 "../src/utils/Utils.vala"
				_tmp21_ = g_unichar_to_string (c);
#line 499 "../src/utils/Utils.vala"
				_tmp22_ = _tmp21_;
#line 499 "../src/utils/Utils.vala"
				_tmp23_ = string_replace (_tmp20_, _tmp22_, "");
#line 499 "../src/utils/Utils.vala"
				_g_free0 (n);
#line 499 "../src/utils/Utils.vala"
				n = _tmp23_;
#line 499 "../src/utils/Utils.vala"
				_g_free0 (_tmp22_);
#line 6017 "Utils.c"
			}
		}
	}
	{
		GRegex* _tmp24_ = NULL;
		GRegex* _tmp25_;
		gchar* _tmp26_ = NULL;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
#line 503 "../src/utils/Utils.vala"
		_tmp25_ = g_regex_new (" {2,}", 0, 0, &_inner_error0_);
#line 503 "../src/utils/Utils.vala"
		_tmp24_ = _tmp25_;
#line 503 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 6037 "Utils.c"
			goto __catch0_g_error;
		}
#line 503 "../src/utils/Utils.vala"
		_tmp27_ = n;
#line 503 "../src/utils/Utils.vala"
		_tmp28_ = n;
#line 503 "../src/utils/Utils.vala"
		_tmp29_ = strlen (_tmp28_);
#line 503 "../src/utils/Utils.vala"
		_tmp30_ = _tmp29_;
#line 503 "../src/utils/Utils.vala"
		_tmp31_ = g_regex_replace (_tmp24_, _tmp27_, (gssize) _tmp30_, 0, " ", 0, &_inner_error0_);
#line 503 "../src/utils/Utils.vala"
		_tmp26_ = _tmp31_;
#line 503 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 503 "../src/utils/Utils.vala"
			_g_regex_unref0 (_tmp24_);
#line 6056 "Utils.c"
			goto __catch0_g_error;
		}
#line 503 "../src/utils/Utils.vala"
		_tmp32_ = _tmp26_;
#line 503 "../src/utils/Utils.vala"
		_tmp26_ = NULL;
#line 503 "../src/utils/Utils.vala"
		_g_free0 (n);
#line 503 "../src/utils/Utils.vala"
		n = _tmp32_;
#line 501 "../src/utils/Utils.vala"
		_g_free0 (_tmp26_);
#line 501 "../src/utils/Utils.vala"
		_g_regex_unref0 (_tmp24_);
#line 6071 "Utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 501 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 6078 "Utils.c"
	}
	__finally0:
#line 501 "../src/utils/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 501 "../src/utils/Utils.vala"
		_g_free0 (n);
#line 501 "../src/utils/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 501 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 501 "../src/utils/Utils.vala"
		return NULL;
#line 6091 "Utils.c"
	}
#line 506 "../src/utils/Utils.vala"
	_tmp33_ = n;
#line 506 "../src/utils/Utils.vala"
	_tmp34_ = string_strip (_tmp33_);
#line 506 "../src/utils/Utils.vala"
	result = _tmp34_;
#line 506 "../src/utils/Utils.vala"
	_g_free0 (n);
#line 506 "../src/utils/Utils.vala"
	return result;
#line 6103 "Utils.c"
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
#line 1333 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1334 "glib-2.0.vapi"
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
#line 1334 "glib-2.0.vapi"
	result = (gint) (_tmp0_ - ((gchar*) self));
#line 1334 "glib-2.0.vapi"
	return result;
#line 6120 "Utils.c"
}

gchar*
game_hub_utils_replace_prefix (const gchar* str,
                               const gchar* prefix,
                               const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
#line 509 "../src/utils/Utils.vala"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 511 "../src/utils/Utils.vala"
	if (str == NULL) {
#line 511 "../src/utils/Utils.vala"
		_tmp1_ = TRUE;
#line 6143 "Utils.c"
	} else {
#line 511 "../src/utils/Utils.vala"
		_tmp1_ = prefix == NULL;
#line 6147 "Utils.c"
	}
#line 511 "../src/utils/Utils.vala"
	if (_tmp1_) {
#line 511 "../src/utils/Utils.vala"
		_tmp0_ = TRUE;
#line 6153 "Utils.c"
	} else {
#line 511 "../src/utils/Utils.vala"
		_tmp0_ = !g_str_has_prefix (str, prefix);
#line 6157 "Utils.c"
	}
#line 511 "../src/utils/Utils.vala"
	if (_tmp0_) {
#line 6161 "Utils.c"
		gchar* _tmp2_;
#line 513 "../src/utils/Utils.vala"
		_tmp2_ = g_strdup (str);
#line 513 "../src/utils/Utils.vala"
		result = _tmp2_;
#line 513 "../src/utils/Utils.vala"
		return result;
#line 6169 "Utils.c"
	}
#line 515 "../src/utils/Utils.vala"
	_tmp3_ = strlen (prefix);
#line 515 "../src/utils/Utils.vala"
	_tmp4_ = _tmp3_;
#line 515 "../src/utils/Utils.vala"
	_tmp5_ = string_substring (str, (glong) string_index_of_nth_char (str, (glong) _tmp4_), (glong) -1);
#line 515 "../src/utils/Utils.vala"
	_tmp6_ = _tmp5_;
#line 515 "../src/utils/Utils.vala"
	_tmp7_ = g_strconcat (replacement, _tmp6_, NULL);
#line 515 "../src/utils/Utils.vala"
	_tmp8_ = _tmp7_;
#line 515 "../src/utils/Utils.vala"
	_g_free0 (_tmp6_);
#line 515 "../src/utils/Utils.vala"
	result = _tmp8_;
#line 515 "../src/utils/Utils.vala"
	return result;
#line 6189 "Utils.c"
}

gint*
game_hub_utils_compare_versions (gint* v1,
                                 gint v1_length1,
                                 gint* v2,
                                 gint v2_length1)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp17_;
	gint* _tmp18_;
	gint* result;
#line 520 "../src/utils/Utils.vala"
	if (v1 == NULL) {
#line 520 "../src/utils/Utils.vala"
		_tmp2_ = TRUE;
#line 6208 "Utils.c"
	} else {
#line 520 "../src/utils/Utils.vala"
		_tmp2_ = v2 == NULL;
#line 6212 "Utils.c"
	}
#line 520 "../src/utils/Utils.vala"
	if (_tmp2_) {
#line 520 "../src/utils/Utils.vala"
		_tmp1_ = TRUE;
#line 6218 "Utils.c"
	} else {
#line 520 "../src/utils/Utils.vala"
		_tmp1_ = v1_length1 == 0;
#line 6222 "Utils.c"
	}
#line 520 "../src/utils/Utils.vala"
	if (_tmp1_) {
#line 520 "../src/utils/Utils.vala"
		_tmp0_ = TRUE;
#line 6228 "Utils.c"
	} else {
#line 520 "../src/utils/Utils.vala"
		_tmp0_ = v2_length1 == 0;
#line 6232 "Utils.c"
	}
#line 520 "../src/utils/Utils.vala"
	if (_tmp0_) {
#line 520 "../src/utils/Utils.vala"
		result = NULL;
#line 520 "../src/utils/Utils.vala"
		return result;
#line 6240 "Utils.c"
	}
	{
		gint i = 0;
#line 522 "../src/utils/Utils.vala"
		i = 0;
#line 6246 "Utils.c"
		{
			gboolean _tmp3_ = FALSE;
#line 522 "../src/utils/Utils.vala"
			_tmp3_ = TRUE;
#line 522 "../src/utils/Utils.vala"
			while (TRUE) {
#line 6253 "Utils.c"
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp9_;
				gint _tmp10_;
#line 522 "../src/utils/Utils.vala"
				if (!_tmp3_) {
#line 6260 "Utils.c"
					gint _tmp4_;
#line 522 "../src/utils/Utils.vala"
					_tmp4_ = i;
#line 522 "../src/utils/Utils.vala"
					i = _tmp4_ + 1;
#line 6266 "Utils.c"
				}
#line 522 "../src/utils/Utils.vala"
				_tmp3_ = FALSE;
#line 522 "../src/utils/Utils.vala"
				if (!(i < MIN (v1_length1, v2_length1))) {
#line 522 "../src/utils/Utils.vala"
					break;
#line 6274 "Utils.c"
				}
#line 524 "../src/utils/Utils.vala"
				_tmp5_ = v1[i];
#line 524 "../src/utils/Utils.vala"
				_tmp6_ = v2[i];
#line 524 "../src/utils/Utils.vala"
				if (_tmp5_ > _tmp6_) {
#line 6282 "Utils.c"
					gint _tmp7_;
					gint* _tmp8_;
#line 524 "../src/utils/Utils.vala"
					_tmp7_ = 1;
#line 524 "../src/utils/Utils.vala"
					_tmp8_ = __int_dup0 (&_tmp7_);
#line 524 "../src/utils/Utils.vala"
					result = _tmp8_;
#line 524 "../src/utils/Utils.vala"
					return result;
#line 6293 "Utils.c"
				}
#line 525 "../src/utils/Utils.vala"
				_tmp9_ = v1[i];
#line 525 "../src/utils/Utils.vala"
				_tmp10_ = v2[i];
#line 525 "../src/utils/Utils.vala"
				if (_tmp9_ < _tmp10_) {
#line 6301 "Utils.c"
					gint _tmp11_;
					gint* _tmp12_;
#line 525 "../src/utils/Utils.vala"
					_tmp11_ = -1;
#line 525 "../src/utils/Utils.vala"
					_tmp12_ = __int_dup0 (&_tmp11_);
#line 525 "../src/utils/Utils.vala"
					result = _tmp12_;
#line 525 "../src/utils/Utils.vala"
					return result;
#line 6312 "Utils.c"
				}
			}
		}
	}
#line 528 "../src/utils/Utils.vala"
	if (v1_length1 > v2_length1) {
#line 6319 "Utils.c"
		gint _tmp13_;
		gint* _tmp14_;
#line 528 "../src/utils/Utils.vala"
		_tmp13_ = 1;
#line 528 "../src/utils/Utils.vala"
		_tmp14_ = __int_dup0 (&_tmp13_);
#line 528 "../src/utils/Utils.vala"
		result = _tmp14_;
#line 528 "../src/utils/Utils.vala"
		return result;
#line 6330 "Utils.c"
	}
#line 529 "../src/utils/Utils.vala"
	if (v1_length1 < v2_length1) {
#line 6334 "Utils.c"
		gint _tmp15_;
		gint* _tmp16_;
#line 529 "../src/utils/Utils.vala"
		_tmp15_ = -1;
#line 529 "../src/utils/Utils.vala"
		_tmp16_ = __int_dup0 (&_tmp15_);
#line 529 "../src/utils/Utils.vala"
		result = _tmp16_;
#line 529 "../src/utils/Utils.vala"
		return result;
#line 6345 "Utils.c"
	}
#line 531 "../src/utils/Utils.vala"
	_tmp17_ = 0;
#line 531 "../src/utils/Utils.vala"
	_tmp18_ = __int_dup0 (&_tmp17_);
#line 531 "../src/utils/Utils.vala"
	result = _tmp18_;
#line 531 "../src/utils/Utils.vala"
	return result;
#line 6355 "Utils.c"
}

static void
_vala_array_add62 (gint* * array,
                   gint* length,
                   gint* size,
                   gint value)
{
#line 541 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 541 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 541 "../src/utils/Utils.vala"
		*array = g_renew (gint, *array, *size);
#line 6370 "Utils.c"
	}
#line 541 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 6374 "Utils.c"
}

gint*
game_hub_utils_parse_version (const gchar* version,
                              const gchar* delimiter,
                              gint* result_length1)
{
	gboolean _tmp0_ = FALSE;
	gint* ver = NULL;
	gint* _tmp6_;
	gint ver_length1;
	gint _ver_size_;
	gchar** parts = NULL;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint* result;
#line 534 "../src/utils/Utils.vala"
	g_return_val_if_fail (delimiter != NULL, NULL);
#line 536 "../src/utils/Utils.vala"
	if (version == NULL) {
#line 536 "../src/utils/Utils.vala"
		_tmp0_ = TRUE;
#line 6403 "Utils.c"
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 536 "../src/utils/Utils.vala"
		_tmp1_ = string_strip (version);
#line 536 "../src/utils/Utils.vala"
		_tmp2_ = _tmp1_;
#line 536 "../src/utils/Utils.vala"
		_tmp3_ = strlen (_tmp2_);
#line 536 "../src/utils/Utils.vala"
		_tmp4_ = _tmp3_;
#line 536 "../src/utils/Utils.vala"
		_tmp0_ = _tmp4_ == 0;
#line 536 "../src/utils/Utils.vala"
		_g_free0 (_tmp2_);
#line 6421 "Utils.c"
	}
#line 536 "../src/utils/Utils.vala"
	if (_tmp0_) {
#line 6425 "Utils.c"
		gint* _tmp5_;
		gint _tmp5__length1;
#line 536 "../src/utils/Utils.vala"
		_tmp5_ = NULL;
#line 536 "../src/utils/Utils.vala"
		_tmp5__length1 = 0;
#line 536 "../src/utils/Utils.vala"
		if (result_length1) {
#line 536 "../src/utils/Utils.vala"
			*result_length1 = _tmp5__length1;
#line 6436 "Utils.c"
		}
#line 536 "../src/utils/Utils.vala"
		result = _tmp5_;
#line 536 "../src/utils/Utils.vala"
		return result;
#line 6442 "Utils.c"
	}
#line 537 "../src/utils/Utils.vala"
	_tmp6_ = g_new0 (gint, 0);
#line 537 "../src/utils/Utils.vala"
	ver = _tmp6_;
#line 537 "../src/utils/Utils.vala"
	ver_length1 = 0;
#line 537 "../src/utils/Utils.vala"
	_ver_size_ = ver_length1;
#line 538 "../src/utils/Utils.vala"
	_tmp8_ = _tmp7_ = g_strsplit (version, delimiter, 0);
#line 538 "../src/utils/Utils.vala"
	parts = _tmp8_;
#line 538 "../src/utils/Utils.vala"
	parts_length1 = _vala_array_length (_tmp7_);
#line 538 "../src/utils/Utils.vala"
	_parts_size_ = parts_length1;
#line 539 "../src/utils/Utils.vala"
	_tmp9_ = parts;
#line 539 "../src/utils/Utils.vala"
	_tmp9__length1 = parts_length1;
#line 6464 "Utils.c"
	{
		gchar** part_collection = NULL;
		gint part_collection_length1 = 0;
		gint _part_collection_size_ = 0;
		gint part_it = 0;
#line 539 "../src/utils/Utils.vala"
		part_collection = _tmp9_;
#line 539 "../src/utils/Utils.vala"
		part_collection_length1 = _tmp9__length1;
#line 539 "../src/utils/Utils.vala"
		for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
#line 6476 "Utils.c"
			gchar* _tmp10_;
			gchar* part = NULL;
#line 539 "../src/utils/Utils.vala"
			_tmp10_ = g_strdup (part_collection[part_it]);
#line 539 "../src/utils/Utils.vala"
			part = _tmp10_;
#line 6483 "Utils.c"
			{
				const gchar* _tmp11_;
#line 541 "../src/utils/Utils.vala"
				_tmp11_ = part;
#line 541 "../src/utils/Utils.vala"
				_vala_array_add62 (&ver, &ver_length1, &_ver_size_, atoi (_tmp11_));
#line 539 "../src/utils/Utils.vala"
				_g_free0 (part);
#line 6492 "Utils.c"
			}
		}
	}
#line 543 "../src/utils/Utils.vala"
	_tmp12_ = ver;
#line 543 "../src/utils/Utils.vala"
	_tmp12__length1 = ver_length1;
#line 543 "../src/utils/Utils.vala"
	if (result_length1) {
#line 543 "../src/utils/Utils.vala"
		*result_length1 = _tmp12__length1;
#line 6504 "Utils.c"
	}
#line 543 "../src/utils/Utils.vala"
	result = _tmp12_;
#line 543 "../src/utils/Utils.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 543 "../src/utils/Utils.vala"
	return result;
#line 6512 "Utils.c"
}

static void
_vala_array_add63 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 552 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 552 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 552 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6527 "Utils.c"
	}
#line 552 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 552 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6533 "Utils.c"
}

gchar*
game_hub_utils_format_version (gint* version,
                               gint version_length1,
                               const gchar* delimiter)
{
	gboolean _tmp0_ = FALSE;
	gchar** ver = NULL;
	gchar** _tmp1_;
	gint ver_length1;
	gint _ver_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* result;
#line 546 "../src/utils/Utils.vala"
	g_return_val_if_fail (delimiter != NULL, NULL);
#line 548 "../src/utils/Utils.vala"
	if (version == NULL) {
#line 548 "../src/utils/Utils.vala"
		_tmp0_ = TRUE;
#line 6556 "Utils.c"
	} else {
#line 548 "../src/utils/Utils.vala"
		_tmp0_ = version_length1 == 0;
#line 6560 "Utils.c"
	}
#line 548 "../src/utils/Utils.vala"
	if (_tmp0_) {
#line 548 "../src/utils/Utils.vala"
		result = NULL;
#line 548 "../src/utils/Utils.vala"
		return result;
#line 6568 "Utils.c"
	}
#line 549 "../src/utils/Utils.vala"
	_tmp1_ = g_new0 (gchar*, 0 + 1);
#line 549 "../src/utils/Utils.vala"
	ver = _tmp1_;
#line 549 "../src/utils/Utils.vala"
	ver_length1 = 0;
#line 549 "../src/utils/Utils.vala"
	_ver_size_ = ver_length1;
#line 6578 "Utils.c"
	{
		gint* part_collection = NULL;
		gint part_collection_length1 = 0;
		gint _part_collection_size_ = 0;
		gint part_it = 0;
#line 550 "../src/utils/Utils.vala"
		part_collection = version;
#line 550 "../src/utils/Utils.vala"
		part_collection_length1 = version_length1;
#line 550 "../src/utils/Utils.vala"
		for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
#line 6590 "Utils.c"
			gint part = 0;
#line 550 "../src/utils/Utils.vala"
			part = part_collection[part_it];
#line 6594 "Utils.c"
			{
				gchar* _tmp2_;
#line 552 "../src/utils/Utils.vala"
				_tmp2_ = g_strdup_printf ("%i", part);
#line 552 "../src/utils/Utils.vala"
				_vala_array_add63 (&ver, &ver_length1, &_ver_size_, _tmp2_);
#line 6601 "Utils.c"
			}
		}
	}
#line 554 "../src/utils/Utils.vala"
	_tmp3_ = ver;
#line 554 "../src/utils/Utils.vala"
	_tmp3__length1 = ver_length1;
#line 554 "../src/utils/Utils.vala"
	_tmp4_ = _vala_g_strjoinv (delimiter, _tmp3_, (gint) _tmp3__length1);
#line 554 "../src/utils/Utils.vala"
	result = _tmp4_;
#line 554 "../src/utils/Utils.vala"
	ver = (_vala_array_free (ver, ver_length1, (GDestroyNotify) g_free), NULL);
#line 554 "../src/utils/Utils.vala"
	return result;
#line 6617 "Utils.c"
}

static void
_vala_array_add64 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 564 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 564 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 564 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6632 "Utils.c"
	}
#line 564 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 564 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6638 "Utils.c"
}

static void
_vala_array_add65 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 565 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 565 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 565 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6653 "Utils.c"
	}
#line 565 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 565 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6659 "Utils.c"
}

static void
_vala_array_add66 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 566 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 566 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 566 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6674 "Utils.c"
	}
#line 566 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 566 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6680 "Utils.c"
}

static void
_vala_array_add67 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 567 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 567 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 567 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6695 "Utils.c"
	}
#line 567 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 567 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6701 "Utils.c"
}

static void
_vala_array_add68 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 572 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 572 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 572 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6716 "Utils.c"
	}
#line 572 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 572 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6722 "Utils.c"
}

static void
_vala_array_add69 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 575 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 575 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 575 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6737 "Utils.c"
	}
#line 575 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 575 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6743 "Utils.c"
}

static void
_vala_array_add70 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 578 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 578 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 578 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6758 "Utils.c"
	}
#line 578 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 578 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6764 "Utils.c"
}

static void
_vala_array_add71 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 581 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 581 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 581 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6779 "Utils.c"
	}
#line 581 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 581 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6785 "Utils.c"
}

static void
_vala_array_add72 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 584 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 584 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 584 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6800 "Utils.c"
	}
#line 584 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 584 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6806 "Utils.c"
}

static void
_vala_array_add73 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 587 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 587 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 587 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 6821 "Utils.c"
	}
#line 587 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 587 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 6827 "Utils.c"
}

gchar*
game_hub_utils_accel_to_string (const gchar* accel)
{
	guint accel_key = 0U;
	GdkModifierType accel_mods = 0U;
	guint _tmp0_ = 0U;
	GdkModifierType _tmp1_ = 0U;
	gchar** arr = NULL;
	gchar** _tmp2_;
	gint arr_length1;
	gint _arr_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar* result;
#line 557 "../src/utils/Utils.vala"
	g_return_val_if_fail (accel != NULL, NULL);
#line 561 "../src/utils/Utils.vala"
	gtk_accelerator_parse (accel, &_tmp0_, &_tmp1_);
#line 561 "../src/utils/Utils.vala"
	accel_key = _tmp0_;
#line 561 "../src/utils/Utils.vala"
	accel_mods = _tmp1_;
#line 563 "../src/utils/Utils.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 563 "../src/utils/Utils.vala"
	arr = _tmp2_;
#line 563 "../src/utils/Utils.vala"
	arr_length1 = 0;
#line 563 "../src/utils/Utils.vala"
	_arr_size_ = arr_length1;
#line 564 "../src/utils/Utils.vala"
	if ((accel_mods & GDK_SUPER_MASK) == GDK_SUPER_MASK) {
#line 6863 "Utils.c"
		gchar* _tmp3_;
#line 564 "../src/utils/Utils.vala"
		_tmp3_ = g_strdup ("Super");
#line 564 "../src/utils/Utils.vala"
		_vala_array_add64 (&arr, &arr_length1, &_arr_size_, _tmp3_);
#line 6869 "Utils.c"
	}
#line 565 "../src/utils/Utils.vala"
	if ((accel_mods & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
#line 6873 "Utils.c"
		gchar* _tmp4_;
#line 565 "../src/utils/Utils.vala"
		_tmp4_ = g_strdup ("Shift");
#line 565 "../src/utils/Utils.vala"
		_vala_array_add65 (&arr, &arr_length1, &_arr_size_, _tmp4_);
#line 6879 "Utils.c"
	}
#line 566 "../src/utils/Utils.vala"
	if ((accel_mods & GDK_CONTROL_MASK) == GDK_CONTROL_MASK) {
#line 6883 "Utils.c"
		gchar* _tmp5_;
#line 566 "../src/utils/Utils.vala"
		_tmp5_ = g_strdup ("Ctrl");
#line 566 "../src/utils/Utils.vala"
		_vala_array_add66 (&arr, &arr_length1, &_arr_size_, _tmp5_);
#line 6889 "Utils.c"
	}
#line 567 "../src/utils/Utils.vala"
	if ((accel_mods & GDK_MOD1_MASK) == GDK_MOD1_MASK) {
#line 6893 "Utils.c"
		gchar* _tmp6_;
#line 567 "../src/utils/Utils.vala"
		_tmp6_ = g_strdup ("Alt");
#line 567 "../src/utils/Utils.vala"
		_vala_array_add67 (&arr, &arr_length1, &_arr_size_, _tmp6_);
#line 6899 "Utils.c"
	}
#line 569 "../src/utils/Utils.vala"
	switch (accel_key) {
#line 569 "../src/utils/Utils.vala"
		case GDK_KEY_Up:
#line 6905 "Utils.c"
		{
			gchar* _tmp7_;
#line 572 "../src/utils/Utils.vala"
			_tmp7_ = g_strdup ("↑");
#line 572 "../src/utils/Utils.vala"
			_vala_array_add68 (&arr, &arr_length1, &_arr_size_, _tmp7_);
#line 573 "../src/utils/Utils.vala"
			break;
#line 6914 "Utils.c"
		}
#line 569 "../src/utils/Utils.vala"
		case GDK_KEY_Down:
#line 6918 "Utils.c"
		{
			gchar* _tmp8_;
#line 575 "../src/utils/Utils.vala"
			_tmp8_ = g_strdup ("↓");
#line 575 "../src/utils/Utils.vala"
			_vala_array_add69 (&arr, &arr_length1, &_arr_size_, _tmp8_);
#line 576 "../src/utils/Utils.vala"
			break;
#line 6927 "Utils.c"
		}
#line 569 "../src/utils/Utils.vala"
		case GDK_KEY_Left:
#line 6931 "Utils.c"
		{
			gchar* _tmp9_;
#line 578 "../src/utils/Utils.vala"
			_tmp9_ = g_strdup ("←");
#line 578 "../src/utils/Utils.vala"
			_vala_array_add70 (&arr, &arr_length1, &_arr_size_, _tmp9_);
#line 579 "../src/utils/Utils.vala"
			break;
#line 6940 "Utils.c"
		}
#line 569 "../src/utils/Utils.vala"
		case GDK_KEY_Right:
#line 6944 "Utils.c"
		{
			gchar* _tmp10_;
#line 581 "../src/utils/Utils.vala"
			_tmp10_ = g_strdup ("→");
#line 581 "../src/utils/Utils.vala"
			_vala_array_add71 (&arr, &arr_length1, &_arr_size_, _tmp10_);
#line 582 "../src/utils/Utils.vala"
			break;
#line 6953 "Utils.c"
		}
#line 569 "../src/utils/Utils.vala"
		case GDK_KEY_Return:
#line 6957 "Utils.c"
		{
			gchar* _tmp11_;
#line 584 "../src/utils/Utils.vala"
			_tmp11_ = g_strdup ("Enter");
#line 584 "../src/utils/Utils.vala"
			_vala_array_add72 (&arr, &arr_length1, &_arr_size_, _tmp11_);
#line 585 "../src/utils/Utils.vala"
			break;
#line 6966 "Utils.c"
		}
		default:
		{
			gchar* _tmp12_;
#line 587 "../src/utils/Utils.vala"
			_tmp12_ = gtk_accelerator_get_label (accel_key, 0);
#line 587 "../src/utils/Utils.vala"
			_vala_array_add73 (&arr, &arr_length1, &_arr_size_, _tmp12_);
#line 588 "../src/utils/Utils.vala"
			break;
#line 6977 "Utils.c"
		}
	}
#line 590 "../src/utils/Utils.vala"
	_tmp13_ = arr;
#line 590 "../src/utils/Utils.vala"
	_tmp13__length1 = arr_length1;
#line 590 "../src/utils/Utils.vala"
	_tmp14_ = _vala_g_strjoinv (" + ", _tmp13_, (gint) _tmp13__length1);
#line 590 "../src/utils/Utils.vala"
	result = _tmp14_;
#line 590 "../src/utils/Utils.vala"
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 590 "../src/utils/Utils.vala"
	return result;
#line 6992 "Utils.c"
}

static void
_vala_array_add74 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 598 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 598 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 598 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 7007 "Utils.c"
	}
#line 598 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 598 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 7013 "Utils.c"
}

static void
_vala_array_add75 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 608 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 608 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 608 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 7028 "Utils.c"
	}
#line 608 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 608 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 7034 "Utils.c"
}

static void
_vala_array_add76 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 614 "../src/utils/Utils.vala"
	if ((*length) == (*size)) {
#line 614 "../src/utils/Utils.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 614 "../src/utils/Utils.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 7049 "Utils.c"
	}
#line 614 "../src/utils/Utils.vala"
	(*array)[(*length)++] = value;
#line 614 "../src/utils/Utils.vala"
	(*array)[*length] = NULL;
#line 7055 "Utils.c"
}

gchar*
game_hub_utils_markup_accel_tooltip (gchar** accels,
                                     gint accels_length1,
                                     const gchar* description)
{
	gchar** parts = NULL;
	gchar** _tmp0_;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_;
	gchar* result;
#line 595 "../src/utils/Utils.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 595 "../src/utils/Utils.vala"
	parts = _tmp0_;
#line 595 "../src/utils/Utils.vala"
	parts_length1 = 0;
#line 595 "../src/utils/Utils.vala"
	_parts_size_ = parts_length1;
#line 596 "../src/utils/Utils.vala"
	if (description != NULL) {
#line 596 "../src/utils/Utils.vala"
		_tmp1_ = g_strcmp0 (description, "") != 0;
#line 7085 "Utils.c"
	} else {
#line 596 "../src/utils/Utils.vala"
		_tmp1_ = FALSE;
#line 7089 "Utils.c"
	}
#line 596 "../src/utils/Utils.vala"
	if (_tmp1_) {
#line 7093 "Utils.c"
		gchar* _tmp2_;
#line 598 "../src/utils/Utils.vala"
		_tmp2_ = g_strdup (description);
#line 598 "../src/utils/Utils.vala"
		_vala_array_add74 (&parts, &parts_length1, &_parts_size_, _tmp2_);
#line 7099 "Utils.c"
	}
#line 600 "../src/utils/Utils.vala"
	if (accels != NULL) {
#line 600 "../src/utils/Utils.vala"
		_tmp3_ = accels_length1 > 0;
#line 7105 "Utils.c"
	} else {
#line 600 "../src/utils/Utils.vala"
		_tmp3_ = FALSE;
#line 7109 "Utils.c"
	}
#line 600 "../src/utils/Utils.vala"
	if (_tmp3_) {
#line 7113 "Utils.c"
		gchar** unique_accels = NULL;
		gchar** _tmp4_;
		gint unique_accels_length1;
		gint _unique_accels_size_;
		gchar** _tmp14_;
		gint _tmp14__length1;
#line 602 "../src/utils/Utils.vala"
		_tmp4_ = g_new0 (gchar*, 0 + 1);
#line 602 "../src/utils/Utils.vala"
		unique_accels = _tmp4_;
#line 602 "../src/utils/Utils.vala"
		unique_accels_length1 = 0;
#line 602 "../src/utils/Utils.vala"
		_unique_accels_size_ = unique_accels_length1;
#line 7128 "Utils.c"
		{
			gint i = 0;
#line 603 "../src/utils/Utils.vala"
			i = 0;
#line 7133 "Utils.c"
			{
				gboolean _tmp5_ = FALSE;
#line 603 "../src/utils/Utils.vala"
				_tmp5_ = TRUE;
#line 603 "../src/utils/Utils.vala"
				while (TRUE) {
#line 7140 "Utils.c"
					const gchar* _tmp7_;
					gchar* accel_string = NULL;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gint _tmp11__length1;
#line 603 "../src/utils/Utils.vala"
					if (!_tmp5_) {
#line 7150 "Utils.c"
						gint _tmp6_;
#line 603 "../src/utils/Utils.vala"
						_tmp6_ = i;
#line 603 "../src/utils/Utils.vala"
						i = _tmp6_ + 1;
#line 7156 "Utils.c"
					}
#line 603 "../src/utils/Utils.vala"
					_tmp5_ = FALSE;
#line 603 "../src/utils/Utils.vala"
					if (!(i < accels_length1)) {
#line 603 "../src/utils/Utils.vala"
						break;
#line 7164 "Utils.c"
					}
#line 605 "../src/utils/Utils.vala"
					_tmp7_ = accels[i];
#line 605 "../src/utils/Utils.vala"
					if (g_strcmp0 (_tmp7_, "") == 0) {
#line 605 "../src/utils/Utils.vala"
						continue;
#line 7172 "Utils.c"
					}
#line 606 "../src/utils/Utils.vala"
					_tmp8_ = accels[i];
#line 606 "../src/utils/Utils.vala"
					_tmp9_ = game_hub_utils_accel_to_string (_tmp8_);
#line 606 "../src/utils/Utils.vala"
					accel_string = _tmp9_;
#line 607 "../src/utils/Utils.vala"
					_tmp10_ = accel_string;
#line 607 "../src/utils/Utils.vala"
					_tmp11_ = unique_accels;
#line 607 "../src/utils/Utils.vala"
					_tmp11__length1 = unique_accels_length1;
#line 607 "../src/utils/Utils.vala"
					if (!_vala_string_array_contains (_tmp11_, _tmp11__length1, _tmp10_)) {
#line 7188 "Utils.c"
						const gchar* _tmp12_;
						gchar* _tmp13_;
#line 608 "../src/utils/Utils.vala"
						_tmp12_ = accel_string;
#line 608 "../src/utils/Utils.vala"
						_tmp13_ = g_strdup (_tmp12_);
#line 608 "../src/utils/Utils.vala"
						_vala_array_add75 (&unique_accels, &unique_accels_length1, &_unique_accels_size_, _tmp13_);
#line 7197 "Utils.c"
					}
#line 603 "../src/utils/Utils.vala"
					_g_free0 (accel_string);
#line 7201 "Utils.c"
				}
			}
		}
#line 610 "../src/utils/Utils.vala"
		_tmp14_ = unique_accels;
#line 610 "../src/utils/Utils.vala"
		_tmp14__length1 = unique_accels_length1;
#line 610 "../src/utils/Utils.vala"
		if (_tmp14__length1 > 0) {
#line 7211 "Utils.c"
			gchar* accel_label = NULL;
			gchar** _tmp15_;
			gint _tmp15__length1;
			gchar* _tmp16_;
			gchar* accel_markup = NULL;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
#line 612 "../src/utils/Utils.vala"
			_tmp15_ = unique_accels;
#line 612 "../src/utils/Utils.vala"
			_tmp15__length1 = unique_accels_length1;
#line 612 "../src/utils/Utils.vala"
			_tmp16_ = _vala_g_strjoinv (", ", _tmp15_, (gint) _tmp15__length1);
#line 612 "../src/utils/Utils.vala"
			accel_label = _tmp16_;
#line 613 "../src/utils/Utils.vala"
			_tmp17_ = accel_label;
#line 613 "../src/utils/Utils.vala"
			_tmp18_ = g_strdup_printf ("<span weight=\"600\" size=\"smaller\" alpha=\"75%\">%s</span>", _tmp17_);
#line 613 "../src/utils/Utils.vala"
			accel_markup = _tmp18_;
#line 614 "../src/utils/Utils.vala"
			_tmp19_ = accel_markup;
#line 614 "../src/utils/Utils.vala"
			_tmp20_ = g_strdup (_tmp19_);
#line 614 "../src/utils/Utils.vala"
			_vala_array_add76 (&parts, &parts_length1, &_parts_size_, _tmp20_);
#line 610 "../src/utils/Utils.vala"
			_g_free0 (accel_markup);
#line 610 "../src/utils/Utils.vala"
			_g_free0 (accel_label);
#line 7245 "Utils.c"
		}
#line 600 "../src/utils/Utils.vala"
		unique_accels = (_vala_array_free (unique_accels, unique_accels_length1, (GDestroyNotify) g_free), NULL);
#line 7249 "Utils.c"
	}
#line 617 "../src/utils/Utils.vala"
	_tmp21_ = parts;
#line 617 "../src/utils/Utils.vala"
	_tmp21__length1 = parts_length1;
#line 617 "../src/utils/Utils.vala"
	_tmp22_ = _vala_g_strjoinv ("\n", _tmp21_, (gint) _tmp21__length1);
#line 617 "../src/utils/Utils.vala"
	result = _tmp22_;
#line 617 "../src/utils/Utils.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 617 "../src/utils/Utils.vala"
	return result;
#line 7263 "Utils.c"
}

void
game_hub_utils_set_accel_tooltip (GtkWidget* widget,
                                  const gchar* tooltip,
                                  const gchar* accel)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 620 "../src/utils/Utils.vala"
	g_return_if_fail (widget != NULL);
#line 620 "../src/utils/Utils.vala"
	g_return_if_fail (tooltip != NULL);
#line 620 "../src/utils/Utils.vala"
	g_return_if_fail (accel != NULL);
#line 622 "../src/utils/Utils.vala"
	_tmp0_ = g_strdup (accel);
#line 622 "../src/utils/Utils.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 622 "../src/utils/Utils.vala"
	_tmp1_[0] = _tmp0_;
#line 622 "../src/utils/Utils.vala"
	_tmp2_ = _tmp1_;
#line 622 "../src/utils/Utils.vala"
	_tmp2__length1 = 1;
#line 622 "../src/utils/Utils.vala"
	_tmp3_ = game_hub_utils_markup_accel_tooltip (_tmp2_, (gint) 1, tooltip);
#line 622 "../src/utils/Utils.vala"
	_tmp4_ = _tmp3_;
#line 622 "../src/utils/Utils.vala"
	gtk_widget_set_tooltip_markup (widget, _tmp4_);
#line 622 "../src/utils/Utils.vala"
	_g_free0 (_tmp4_);
#line 622 "../src/utils/Utils.vala"
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
#line 7303 "Utils.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_logger_log_level_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_HUB_UTILS_LOGGER_LOG_LEVEL_DEBUG, "GAME_HUB_UTILS_LOGGER_LOG_LEVEL_DEBUG", "debug"}, {GAME_HUB_UTILS_LOGGER_LOG_LEVEL_INFO, "GAME_HUB_UTILS_LOGGER_LOG_LEVEL_INFO", "info"}, {GAME_HUB_UTILS_LOGGER_LOG_LEVEL_NOTIFY, "GAME_HUB_UTILS_LOGGER_LOG_LEVEL_NOTIFY", "notify"}, {GAME_HUB_UTILS_LOGGER_LOG_LEVEL_WARN, "GAME_HUB_UTILS_LOGGER_LOG_LEVEL_WARN", "warn"}, {GAME_HUB_UTILS_LOGGER_LOG_LEVEL_ERROR, "GAME_HUB_UTILS_LOGGER_LOG_LEVEL_ERROR", "error"}, {GAME_HUB_UTILS_LOGGER_LOG_LEVEL_FATAL, "GAME_HUB_UTILS_LOGGER_LOG_LEVEL_FATAL", "fatal"}, {0, NULL, NULL}};
	GType game_hub_utils_logger_log_level_type_id;
	game_hub_utils_logger_log_level_type_id = g_enum_register_static ("GameHubUtilsLoggerLogLevel", values);
	return game_hub_utils_logger_log_level_type_id;
}

GType
game_hub_utils_logger_log_level_get_type (void)
{
	static volatile gsize game_hub_utils_logger_log_level_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_logger_log_level_type_id__once)) {
		GType game_hub_utils_logger_log_level_type_id;
		game_hub_utils_logger_log_level_type_id = game_hub_utils_logger_log_level_get_type_once ();
		g_once_init_leave (&game_hub_utils_logger_log_level_type_id__once, game_hub_utils_logger_log_level_type_id);
	}
	return game_hub_utils_logger_log_level_type_id__once;
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_logger_console_color_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLACK, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLACK", "black"}, {GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_RED, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_RED", "red"}, {GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_GREEN, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_GREEN", "green"}, {GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_YELLOW, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_YELLOW", "yellow"}, {GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLUE, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLUE", "blue"}, {GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_MAGENTA, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_MAGENTA", "magenta"}, {GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_CYAN, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_CYAN", "cyan"}, {GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_WHITE, "GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_WHITE", "white"}, {0, NULL, NULL}};
	GType game_hub_utils_logger_console_color_type_id;
	game_hub_utils_logger_console_color_type_id = g_enum_register_static ("GameHubUtilsLoggerConsoleColor", values);
	return game_hub_utils_logger_console_color_type_id;
}

GType
game_hub_utils_logger_console_color_get_type (void)
{
	static volatile gsize game_hub_utils_logger_console_color_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_logger_console_color_type_id__once)) {
		GType game_hub_utils_logger_console_color_type_id;
		game_hub_utils_logger_console_color_type_id = game_hub_utils_logger_console_color_get_type_once ();
		g_once_init_leave (&game_hub_utils_logger_console_color_type_id__once, game_hub_utils_logger_console_color_type_id);
	}
	return game_hub_utils_logger_console_color_type_id__once;
}

void
game_hub_utils_logger_init (void)
{
	GError* _inner_error0_ = NULL;
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_ = NULL;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
#line 657 "../src/utils/Utils.vala"
		_tmp1_ = g_regex_new ("^.*\\.vala:\\d+: ", 0, 0, &_inner_error0_);
#line 657 "../src/utils/Utils.vala"
		_tmp0_ = _tmp1_;
#line 657 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 7368 "Utils.c"
			goto __catch0_g_error;
		}
#line 657 "../src/utils/Utils.vala"
		_tmp2_ = _tmp0_;
#line 657 "../src/utils/Utils.vala"
		_tmp0_ = NULL;
#line 657 "../src/utils/Utils.vala"
		_g_regex_unref0 (game_hub_utils_logger_msg_file_regex);
#line 657 "../src/utils/Utils.vala"
		game_hub_utils_logger_msg_file_regex = _tmp2_;
#line 658 "../src/utils/Utils.vala"
		_tmp4_ = g_regex_new ("(['\"`].*?['\"`])", 0, 0, &_inner_error0_);
#line 658 "../src/utils/Utils.vala"
		_tmp3_ = _tmp4_;
#line 658 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 658 "../src/utils/Utils.vala"
			_g_regex_unref0 (_tmp0_);
#line 7387 "Utils.c"
			goto __catch0_g_error;
		}
#line 658 "../src/utils/Utils.vala"
		_tmp5_ = _tmp3_;
#line 658 "../src/utils/Utils.vala"
		_tmp3_ = NULL;
#line 658 "../src/utils/Utils.vala"
		_g_regex_unref0 (game_hub_utils_logger_msg_string_regex);
#line 658 "../src/utils/Utils.vala"
		game_hub_utils_logger_msg_string_regex = _tmp5_;
#line 659 "../src/utils/Utils.vala"
		_tmp7_ = g_regex_new ("^(\\[.*?\\])", 0, 0, &_inner_error0_);
#line 659 "../src/utils/Utils.vala"
		_tmp6_ = _tmp7_;
#line 659 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 659 "../src/utils/Utils.vala"
			_g_regex_unref0 (_tmp3_);
#line 659 "../src/utils/Utils.vala"
			_g_regex_unref0 (_tmp0_);
#line 7408 "Utils.c"
			goto __catch0_g_error;
		}
#line 659 "../src/utils/Utils.vala"
		_tmp8_ = _tmp6_;
#line 659 "../src/utils/Utils.vala"
		_tmp6_ = NULL;
#line 659 "../src/utils/Utils.vala"
		_g_regex_unref0 (game_hub_utils_logger_msg_block_regex);
#line 659 "../src/utils/Utils.vala"
		game_hub_utils_logger_msg_block_regex = _tmp8_;
#line 655 "../src/utils/Utils.vala"
		_g_regex_unref0 (_tmp6_);
#line 655 "../src/utils/Utils.vala"
		_g_regex_unref0 (_tmp3_);
#line 655 "../src/utils/Utils.vala"
		_g_regex_unref0 (_tmp0_);
#line 7425 "Utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 655 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 7432 "Utils.c"
	}
	__finally0:
#line 655 "../src/utils/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 655 "../src/utils/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 655 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 655 "../src/utils/Utils.vala"
		return;
#line 7443 "Utils.c"
	}
#line 662 "../src/utils/Utils.vala"
	g_log_set_default_handler ((GLogFunc) game_hub_utils_logger_glib_log_func, NULL);
#line 7447 "Utils.c"
}

static void
game_hub_utils_logger_write (GameHubUtilsLoggerLogLevel level,
                             gchar* msg)
{
	GameHubUtilsLoggerLogLevel _tmp0_;
	GameHubUtilsLoggerLogLevel _tmp1_;
	FILE* _tmp2_;
	const gchar* _tmp3_;
	FILE* _tmp4_;
#line 665 "../src/utils/Utils.vala"
	g_return_if_fail (msg != NULL);
#line 667 "../src/utils/Utils.vala"
	_tmp0_ = game_hub_utils_logger_get_DisplayLevel ();
#line 667 "../src/utils/Utils.vala"
	_tmp1_ = _tmp0_;
#line 667 "../src/utils/Utils.vala"
	if (level < _tmp1_) {
#line 667 "../src/utils/Utils.vala"
		_g_free0 (msg);
#line 667 "../src/utils/Utils.vala"
		return;
#line 7471 "Utils.c"
	}
#line 669 "../src/utils/Utils.vala"
	g_mutex_lock (&game_hub_utils_logger_write_mutex);
#line 670 "../src/utils/Utils.vala"
	game_hub_utils_logger_set_color_for_level (level);
#line 671 "../src/utils/Utils.vala"
	_tmp2_ = stdout;
#line 671 "../src/utils/Utils.vala"
	_tmp3_ = GAME_HUB_UTILS_LOGGER_LOG_LEVEL_TO_STRING[level];
#line 671 "../src/utils/Utils.vala"
	fprintf (_tmp2_, "%s", _tmp3_);
#line 673 "../src/utils/Utils.vala"
	game_hub_utils_logger_reset_color ();
#line 674 "../src/utils/Utils.vala"
	_tmp4_ = stdout;
#line 674 "../src/utils/Utils.vala"
	fprintf (_tmp4_, " %s\n", msg);
#line 676 "../src/utils/Utils.vala"
	g_mutex_unlock (&game_hub_utils_logger_write_mutex);
#line 665 "../src/utils/Utils.vala"
	_g_free0 (msg);
#line 7493 "Utils.c"
}

static void
game_hub_utils_logger_set_color_for_level (GameHubUtilsLoggerLogLevel level)
{
#line 681 "../src/utils/Utils.vala"
	switch (level) {
#line 681 "../src/utils/Utils.vala"
		case GAME_HUB_UTILS_LOGGER_LOG_LEVEL_DEBUG:
#line 7503 "Utils.c"
		{
#line 684 "../src/utils/Utils.vala"
			game_hub_utils_logger_set_foreground (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_GREEN);
#line 685 "../src/utils/Utils.vala"
			break;
#line 7509 "Utils.c"
		}
#line 681 "../src/utils/Utils.vala"
		case GAME_HUB_UTILS_LOGGER_LOG_LEVEL_INFO:
#line 7513 "Utils.c"
		{
#line 687 "../src/utils/Utils.vala"
			game_hub_utils_logger_set_foreground (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLUE);
#line 688 "../src/utils/Utils.vala"
			break;
#line 7519 "Utils.c"
		}
#line 681 "../src/utils/Utils.vala"
		case GAME_HUB_UTILS_LOGGER_LOG_LEVEL_NOTIFY:
#line 7523 "Utils.c"
		{
#line 690 "../src/utils/Utils.vala"
			game_hub_utils_logger_set_foreground (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_MAGENTA);
#line 691 "../src/utils/Utils.vala"
			break;
#line 7529 "Utils.c"
		}
#line 681 "../src/utils/Utils.vala"
		case GAME_HUB_UTILS_LOGGER_LOG_LEVEL_WARN:
#line 7533 "Utils.c"
		{
#line 693 "../src/utils/Utils.vala"
			game_hub_utils_logger_set_foreground (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_YELLOW);
#line 694 "../src/utils/Utils.vala"
			break;
#line 7539 "Utils.c"
		}
#line 681 "../src/utils/Utils.vala"
		case GAME_HUB_UTILS_LOGGER_LOG_LEVEL_ERROR:
#line 7543 "Utils.c"
		{
#line 696 "../src/utils/Utils.vala"
			game_hub_utils_logger_set_foreground (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_RED);
#line 697 "../src/utils/Utils.vala"
			break;
#line 7549 "Utils.c"
		}
#line 681 "../src/utils/Utils.vala"
		case GAME_HUB_UTILS_LOGGER_LOG_LEVEL_FATAL:
#line 7553 "Utils.c"
		{
#line 699 "../src/utils/Utils.vala"
			game_hub_utils_logger_set_background (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_RED);
#line 700 "../src/utils/Utils.vala"
			game_hub_utils_logger_set_foreground (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_WHITE);
#line 701 "../src/utils/Utils.vala"
			break;
#line 7561 "Utils.c"
		}
		default:
#line 681 "../src/utils/Utils.vala"
		break;
#line 7566 "Utils.c"
	}
}

static void
game_hub_utils_logger_reset_color (void)
{
	FILE* _tmp0_;
#line 707 "../src/utils/Utils.vala"
	_tmp0_ = stdout;
#line 707 "../src/utils/Utils.vala"
	fprintf (_tmp0_, "\x001b[0m");
#line 7578 "Utils.c"
}

static void
game_hub_utils_logger_set_foreground (GameHubUtilsLoggerConsoleColor color)
{
#line 712 "../src/utils/Utils.vala"
	game_hub_utils_logger_set_color (color, TRUE);
#line 7586 "Utils.c"
}

static void
game_hub_utils_logger_set_background (GameHubUtilsLoggerConsoleColor color)
{
#line 717 "../src/utils/Utils.vala"
	game_hub_utils_logger_set_color (color, FALSE);
#line 7594 "Utils.c"
}

static gchar*
game_hub_utils_logger_color (GameHubUtilsLoggerConsoleColor c,
                             gboolean foreground)
{
	GameHubUtilsLoggerConsoleColor color_code = 0;
	gchar* _tmp0_;
	gchar* result;
#line 722 "../src/utils/Utils.vala"
	color_code = (c + 30) + 60;
#line 723 "../src/utils/Utils.vala"
	if (!foreground) {
#line 723 "../src/utils/Utils.vala"
		color_code += 10;
#line 7610 "Utils.c"
	}
#line 724 "../src/utils/Utils.vala"
	_tmp0_ = g_strdup_printf ("\x001b[%dm", (gint) color_code);
#line 724 "../src/utils/Utils.vala"
	result = _tmp0_;
#line 724 "../src/utils/Utils.vala"
	return result;
#line 7618 "Utils.c"
}

static void
game_hub_utils_logger_set_color (GameHubUtilsLoggerConsoleColor c,
                                 gboolean foreground)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 729 "../src/utils/Utils.vala"
	_tmp0_ = stdout;
#line 729 "../src/utils/Utils.vala"
	_tmp1_ = game_hub_utils_logger_color (c, foreground);
#line 729 "../src/utils/Utils.vala"
	_tmp2_ = _tmp1_;
#line 729 "../src/utils/Utils.vala"
	fprintf (_tmp0_, "%s", _tmp2_);
#line 729 "../src/utils/Utils.vala"
	_g_free0 (_tmp2_);
#line 7638 "Utils.c"
}

static void
game_hub_utils_logger_glib_log_func (const gchar* d,
                                     GLogLevelFlags flags,
                                     const gchar* msg)
{
	gchar* domain = NULL;
	gchar* message = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GameHubUtilsLoggerLogLevel level = 0;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _inner_error0_ = NULL;
#line 732 "../src/utils/Utils.vala"
	g_return_if_fail (msg != NULL);
#line 734 "../src/utils/Utils.vala"
	if (!game_hub_utils_logger_log_filter (d, flags, msg)) {
#line 734 "../src/utils/Utils.vala"
		return;
#line 7663 "Utils.c"
	}
#line 737 "../src/utils/Utils.vala"
	if (d != NULL) {
#line 7667 "Utils.c"
		gchar* _tmp0_;
#line 738 "../src/utils/Utils.vala"
		_tmp0_ = g_strdup_printf ("[%s] ", d);
#line 738 "../src/utils/Utils.vala"
		_g_free0 (domain);
#line 738 "../src/utils/Utils.vala"
		domain = _tmp0_;
#line 7675 "Utils.c"
	} else {
		gchar* _tmp1_;
#line 740 "../src/utils/Utils.vala"
		_tmp1_ = g_strdup ("");
#line 740 "../src/utils/Utils.vala"
		_g_free0 (domain);
#line 740 "../src/utils/Utils.vala"
		domain = _tmp1_;
#line 7684 "Utils.c"
	}
#line 742 "../src/utils/Utils.vala"
	_tmp2_ = domain;
#line 742 "../src/utils/Utils.vala"
	_tmp3_ = string_strip (msg);
#line 742 "../src/utils/Utils.vala"
	_tmp4_ = _tmp3_;
#line 742 "../src/utils/Utils.vala"
	_tmp5_ = g_strdup_printf ("%s%s", _tmp2_, _tmp4_);
#line 742 "../src/utils/Utils.vala"
	_tmp6_ = _tmp5_;
#line 742 "../src/utils/Utils.vala"
	_g_free0 (_tmp4_);
#line 742 "../src/utils/Utils.vala"
	message = _tmp6_;
#line 7700 "Utils.c"
	{
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		GRegex* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_ = NULL;
		GRegex* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
#line 746 "../src/utils/Utils.vala"
		_tmp8_ = game_hub_utils_logger_msg_file_regex;
#line 746 "../src/utils/Utils.vala"
		_tmp9_ = message;
#line 746 "../src/utils/Utils.vala"
		_tmp10_ = g_regex_replace_literal (_tmp8_, _tmp9_, (gssize) -1, 0, "", 0, &_inner_error0_);
#line 746 "../src/utils/Utils.vala"
		_tmp7_ = _tmp10_;
#line 746 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 7737 "Utils.c"
			goto __catch0_g_error;
		}
#line 746 "../src/utils/Utils.vala"
		_tmp11_ = _tmp7_;
#line 746 "../src/utils/Utils.vala"
		_tmp7_ = NULL;
#line 746 "../src/utils/Utils.vala"
		_g_free0 (message);
#line 746 "../src/utils/Utils.vala"
		message = _tmp11_;
#line 747 "../src/utils/Utils.vala"
		_tmp13_ = game_hub_utils_logger_msg_string_regex;
#line 747 "../src/utils/Utils.vala"
		_tmp14_ = message;
#line 747 "../src/utils/Utils.vala"
		_tmp15_ = game_hub_utils_logger_color (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_WHITE, TRUE);
#line 747 "../src/utils/Utils.vala"
		_tmp16_ = _tmp15_;
#line 747 "../src/utils/Utils.vala"
		_tmp17_ = g_strconcat (_tmp16_, "\\1\x001b[0m", NULL);
#line 747 "../src/utils/Utils.vala"
		_tmp18_ = _tmp17_;
#line 747 "../src/utils/Utils.vala"
		_tmp19_ = g_regex_replace (_tmp13_, _tmp14_, (gssize) -1, 0, _tmp18_, 0, &_inner_error0_);
#line 747 "../src/utils/Utils.vala"
		_tmp20_ = _tmp19_;
#line 747 "../src/utils/Utils.vala"
		_g_free0 (_tmp18_);
#line 747 "../src/utils/Utils.vala"
		_g_free0 (_tmp16_);
#line 747 "../src/utils/Utils.vala"
		_tmp12_ = _tmp20_;
#line 747 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 747 "../src/utils/Utils.vala"
			_g_free0 (_tmp7_);
#line 7774 "Utils.c"
			goto __catch0_g_error;
		}
#line 747 "../src/utils/Utils.vala"
		_tmp21_ = _tmp12_;
#line 747 "../src/utils/Utils.vala"
		_tmp12_ = NULL;
#line 747 "../src/utils/Utils.vala"
		_g_free0 (message);
#line 747 "../src/utils/Utils.vala"
		message = _tmp21_;
#line 748 "../src/utils/Utils.vala"
		_tmp23_ = game_hub_utils_logger_msg_block_regex;
#line 748 "../src/utils/Utils.vala"
		_tmp24_ = message;
#line 748 "../src/utils/Utils.vala"
		_tmp25_ = game_hub_utils_logger_color (GAME_HUB_UTILS_LOGGER_CONSOLE_COLOR_BLACK, TRUE);
#line 748 "../src/utils/Utils.vala"
		_tmp26_ = _tmp25_;
#line 748 "../src/utils/Utils.vala"
		_tmp27_ = g_strconcat (_tmp26_, "\\1\x001b[0m", NULL);
#line 748 "../src/utils/Utils.vala"
		_tmp28_ = _tmp27_;
#line 748 "../src/utils/Utils.vala"
		_tmp29_ = g_regex_replace (_tmp23_, _tmp24_, (gssize) -1, 0, _tmp28_, 0, &_inner_error0_);
#line 748 "../src/utils/Utils.vala"
		_tmp30_ = _tmp29_;
#line 748 "../src/utils/Utils.vala"
		_g_free0 (_tmp28_);
#line 748 "../src/utils/Utils.vala"
		_g_free0 (_tmp26_);
#line 748 "../src/utils/Utils.vala"
		_tmp22_ = _tmp30_;
#line 748 "../src/utils/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 748 "../src/utils/Utils.vala"
			_g_free0 (_tmp12_);
#line 748 "../src/utils/Utils.vala"
			_g_free0 (_tmp7_);
#line 7813 "Utils.c"
			goto __catch0_g_error;
		}
#line 748 "../src/utils/Utils.vala"
		_tmp31_ = _tmp22_;
#line 748 "../src/utils/Utils.vala"
		_tmp22_ = NULL;
#line 748 "../src/utils/Utils.vala"
		_g_free0 (message);
#line 748 "../src/utils/Utils.vala"
		message = _tmp31_;
#line 744 "../src/utils/Utils.vala"
		_g_free0 (_tmp22_);
#line 744 "../src/utils/Utils.vala"
		_g_free0 (_tmp12_);
#line 744 "../src/utils/Utils.vala"
		_g_free0 (_tmp7_);
#line 7830 "Utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 744 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 7837 "Utils.c"
	}
	__finally0:
#line 744 "../src/utils/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 744 "../src/utils/Utils.vala"
		_g_free0 (message);
#line 744 "../src/utils/Utils.vala"
		_g_free0 (domain);
#line 744 "../src/utils/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 744 "../src/utils/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 744 "../src/utils/Utils.vala"
		return;
#line 7852 "Utils.c"
	}
#line 755 "../src/utils/Utils.vala"
	flags = flags & G_LOG_LEVEL_MASK;
#line 757 "../src/utils/Utils.vala"
	switch (flags) {
#line 757 "../src/utils/Utils.vala"
		case G_LOG_LEVEL_CRITICAL:
#line 7860 "Utils.c"
		{
#line 760 "../src/utils/Utils.vala"
			level = GAME_HUB_UTILS_LOGGER_LOG_LEVEL_FATAL;
#line 761 "../src/utils/Utils.vala"
			break;
#line 7866 "Utils.c"
		}
#line 757 "../src/utils/Utils.vala"
		case G_LOG_LEVEL_ERROR:
#line 7870 "Utils.c"
		{
#line 764 "../src/utils/Utils.vala"
			level = GAME_HUB_UTILS_LOGGER_LOG_LEVEL_ERROR;
#line 765 "../src/utils/Utils.vala"
			break;
#line 7876 "Utils.c"
		}
#line 757 "../src/utils/Utils.vala"
		case G_LOG_LEVEL_INFO:
#line 757 "../src/utils/Utils.vala"
		case G_LOG_LEVEL_MESSAGE:
#line 7882 "Utils.c"
		{
#line 769 "../src/utils/Utils.vala"
			level = GAME_HUB_UTILS_LOGGER_LOG_LEVEL_INFO;
#line 770 "../src/utils/Utils.vala"
			break;
#line 7888 "Utils.c"
		}
#line 757 "../src/utils/Utils.vala"
		case G_LOG_LEVEL_DEBUG:
#line 7892 "Utils.c"
		{
#line 773 "../src/utils/Utils.vala"
			level = GAME_HUB_UTILS_LOGGER_LOG_LEVEL_DEBUG;
#line 774 "../src/utils/Utils.vala"
			break;
#line 7898 "Utils.c"
		}
		default:
#line 757 "../src/utils/Utils.vala"
		case G_LOG_LEVEL_WARNING:
#line 7903 "Utils.c"
		{
#line 778 "../src/utils/Utils.vala"
			level = GAME_HUB_UTILS_LOGGER_LOG_LEVEL_WARN;
#line 779 "../src/utils/Utils.vala"
			break;
#line 7909 "Utils.c"
		}
	}
#line 782 "../src/utils/Utils.vala"
	_tmp32_ = message;
#line 782 "../src/utils/Utils.vala"
	_tmp33_ = g_strdup (_tmp32_);
#line 782 "../src/utils/Utils.vala"
	game_hub_utils_logger_write (level, _tmp33_);
#line 732 "../src/utils/Utils.vala"
	_g_free0 (message);
#line 732 "../src/utils/Utils.vala"
	_g_free0 (domain);
#line 7922 "Utils.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 7941 "Utils.c"
}

static gboolean
game_hub_utils_logger_log_filter (const gchar* d,
                                  GLogLevelFlags flags,
                                  const gchar* msg)
{
	gboolean result;
#line 785 "../src/utils/Utils.vala"
	g_return_val_if_fail (msg != NULL, FALSE);
#line 787 "../src/utils/Utils.vala"
	if (!game_hub_application_log_no_filters) {
#line 7954 "Utils.c"
		gboolean _tmp0_ = FALSE;
#line 789 "../src/utils/Utils.vala"
		if (g_strcmp0 (d, "GLib-GIO") == 0) {
#line 789 "../src/utils/Utils.vala"
			_tmp0_ = g_str_has_prefix (msg, "Settings schema '");
#line 7960 "Utils.c"
		} else {
#line 789 "../src/utils/Utils.vala"
			_tmp0_ = FALSE;
#line 7964 "Utils.c"
		}
#line 789 "../src/utils/Utils.vala"
		if (_tmp0_) {
#line 789 "../src/utils/Utils.vala"
			result = TRUE;
#line 789 "../src/utils/Utils.vala"
			return result;
#line 7972 "Utils.c"
		}
#line 790 "../src/utils/Utils.vala"
		if (_vala_string_array_contains (GAME_HUB_UTILS_LOGGER_HIDDEN_DOMAINS, G_N_ELEMENTS (GAME_HUB_UTILS_LOGGER_HIDDEN_DOMAINS), d)) {
#line 790 "../src/utils/Utils.vala"
			result = FALSE;
#line 790 "../src/utils/Utils.vala"
			return result;
#line 7980 "Utils.c"
		}
		{
			const gchar** hidden_msg_collection = NULL;
			gint hidden_msg_collection_length1 = 0;
			gint _hidden_msg_collection_size_ = 0;
			gint hidden_msg_it = 0;
#line 791 "../src/utils/Utils.vala"
			hidden_msg_collection = GAME_HUB_UTILS_LOGGER_HIDDEN_MESSAGES;
#line 791 "../src/utils/Utils.vala"
			hidden_msg_collection_length1 = G_N_ELEMENTS (GAME_HUB_UTILS_LOGGER_HIDDEN_MESSAGES);
#line 791 "../src/utils/Utils.vala"
			for (hidden_msg_it = 0; hidden_msg_it < hidden_msg_collection_length1; hidden_msg_it = hidden_msg_it + 1) {
#line 7993 "Utils.c"
				const gchar* hidden_msg = NULL;
#line 791 "../src/utils/Utils.vala"
				hidden_msg = hidden_msg_collection[hidden_msg_it];
#line 7997 "Utils.c"
				{
					const gchar* _tmp1_;
#line 793 "../src/utils/Utils.vala"
					_tmp1_ = hidden_msg;
#line 793 "../src/utils/Utils.vala"
					if (string_contains (msg, _tmp1_)) {
#line 793 "../src/utils/Utils.vala"
						result = FALSE;
#line 793 "../src/utils/Utils.vala"
						return result;
#line 8008 "Utils.c"
					}
				}
			}
		}
	}
#line 796 "../src/utils/Utils.vala"
	result = TRUE;
#line 796 "../src/utils/Utils.vala"
	return result;
#line 8018 "Utils.c"
}

GameHubUtilsLogger*
game_hub_utils_logger_construct (GType object_type)
{
	GameHubUtilsLogger * self = NULL;
#line 628 "../src/utils/Utils.vala"
	self = (GameHubUtilsLogger*) g_object_new (object_type, NULL);
#line 628 "../src/utils/Utils.vala"
	return self;
#line 8029 "Utils.c"
}

GameHubUtilsLogger*
game_hub_utils_logger_new (void)
{
#line 628 "../src/utils/Utils.vala"
	return game_hub_utils_logger_construct (GAME_HUB_UTILS_TYPE_LOGGER);
#line 8037 "Utils.c"
}

GameHubUtilsLoggerLogLevel
game_hub_utils_logger_get_DisplayLevel (void)
{
	GameHubUtilsLoggerLogLevel result;
#line 633 "../src/utils/Utils.vala"
	result = game_hub_utils_logger__DisplayLevel;
#line 633 "../src/utils/Utils.vala"
	return result;
#line 8048 "Utils.c"
}

void
game_hub_utils_logger_set_DisplayLevel (GameHubUtilsLoggerLogLevel value)
{
#line 633 "../src/utils/Utils.vala"
	game_hub_utils_logger__DisplayLevel = value;
#line 8056 "Utils.c"
}

static void
game_hub_utils_logger_class_init (GameHubUtilsLoggerClass * klass,
                                  gpointer klass_data)
{
#line 628 "../src/utils/Utils.vala"
	game_hub_utils_logger_parent_class = g_type_class_peek_parent (klass);
#line 628 "../src/utils/Utils.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_utils_logger_get_property;
#line 628 "../src/utils/Utils.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_utils_logger_set_property;
#line 628 "../src/utils/Utils.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_utils_logger_finalize;
#line 8071 "Utils.c"
}

static void
game_hub_utils_logger_instance_init (GameHubUtilsLogger * self,
                                     gpointer klass)
{
}

static void
game_hub_utils_logger_finalize (GObject * obj)
{
	GameHubUtilsLogger * self;
#line 628 "../src/utils/Utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_TYPE_LOGGER, GameHubUtilsLogger);
#line 628 "../src/utils/Utils.vala"
	G_OBJECT_CLASS (game_hub_utils_logger_parent_class)->finalize (obj);
#line 8088 "Utils.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_logger_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsLoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsLogger), 0, (GInstanceInitFunc) game_hub_utils_logger_instance_init, NULL };
	GType game_hub_utils_logger_type_id;
	game_hub_utils_logger_type_id = g_type_register_static (G_TYPE_OBJECT, "GameHubUtilsLogger", &g_define_type_info, 0);
	return game_hub_utils_logger_type_id;
}

GType
game_hub_utils_logger_get_type (void)
{
	static volatile gsize game_hub_utils_logger_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_logger_type_id__once)) {
		GType game_hub_utils_logger_type_id;
		game_hub_utils_logger_type_id = game_hub_utils_logger_get_type_once ();
		g_once_init_leave (&game_hub_utils_logger_type_id__once, game_hub_utils_logger_type_id);
	}
	return game_hub_utils_logger_type_id__once;
}

static void
_vala_game_hub_utils_logger_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GameHubUtilsLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UTILS_TYPE_LOGGER, GameHubUtilsLogger);
#line 628 "../src/utils/Utils.vala"
	switch (property_id) {
#line 8122 "Utils.c"
		default:
#line 628 "../src/utils/Utils.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 628 "../src/utils/Utils.vala"
		break;
#line 8128 "Utils.c"
	}
}

static void
_vala_game_hub_utils_logger_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GameHubUtilsLogger * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UTILS_TYPE_LOGGER, GameHubUtilsLogger);
#line 628 "../src/utils/Utils.vala"
	switch (property_id) {
#line 8142 "Utils.c"
		default:
#line 628 "../src/utils/Utils.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 628 "../src/utils/Utils.vala"
		break;
#line 8148 "Utils.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

