/* Parser.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Parser.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <libsoup/soup.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <json-glib/json-glib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/HTMLtree.h>
#include <libxml/HTMLparser.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_UTILS_TYPE_PARSER (game_hub_utils_parser_get_type ())
#define GAME_HUB_UTILS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_PARSER, GameHubUtilsParser))
#define GAME_HUB_UTILS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_PARSER, GameHubUtilsParserClass))
#define GAME_HUB_UTILS_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_PARSER))
#define GAME_HUB_UTILS_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_PARSER))
#define GAME_HUB_UTILS_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_PARSER, GameHubUtilsParserClass))

typedef struct _GameHubUtilsParser GameHubUtilsParser;
typedef struct _GameHubUtilsParserClass GameHubUtilsParserClass;
typedef struct _GameHubUtilsParserPrivate GameHubUtilsParserPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_SoupMultipart_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMultipart_free (var), NULL)))
typedef struct _Block125Data Block125Data;
typedef struct _GameHubUtilsParserLoadRemoteFileAsyncData GameHubUtilsParserLoadRemoteFileAsyncData;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _GameHubUtilsParserParseRemoteJsonFileAsyncData GameHubUtilsParserParseRemoteJsonFileAsyncData;
typedef struct _GameHubUtilsParserParseRemoteVdfFileAsyncData GameHubUtilsParserParseRemoteVdfFileAsyncData;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GameHubUtilsParserParseRemoteXmlFileAsyncData GameHubUtilsParserParseRemoteXmlFileAsyncData;
typedef struct _GameHubUtilsParserParseRemoteHtmlFileAsyncData GameHubUtilsParserParseRemoteHtmlFileAsyncData;
#define _xmlBufferFree0(var) ((var == NULL) ? NULL : (var = (xmlBufferFree (var), NULL)))
typedef void (*GameHubUtilsParserJsonBulderDelegate) (JsonBuilder* builder, gpointer user_data);
typedef struct _GameHubUtilsParamSpecParser GameHubUtilsParamSpecParser;

struct _GameHubUtilsParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubUtilsParserPrivate * priv;
};

struct _GameHubUtilsParserClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubUtilsParser *self);
};

struct _Block125Data {
	int _ref_count_;
	guint status_code;
	gchar* _result_;
	gpointer _async_data_;
};

struct _GameHubUtilsParserLoadRemoteFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* method;
	gchar* auth;
	GeeHashMap* headers;
	GeeHashMap* data;
	guint status;
	gchar* result;
	Block125Data* _data125_;
	gchar* _tmp0_;
	SoupMessage* message;
	SoupMessage* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	gchar* _tmp4_;
};

struct _GameHubUtilsParserParseRemoteJsonFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* method;
	gchar* auth;
	GeeHashMap* headers;
	GeeHashMap* data;
	guint status;
	JsonNode* result;
	guint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
};

struct _GameHubUtilsParserParseRemoteVdfFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* method;
	gchar* auth;
	GeeHashMap* headers;
	GeeHashMap* data;
	guint status;
	JsonNode* result;
	guint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
};

struct _GameHubUtilsParserParseRemoteXmlFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* method;
	gchar* auth;
	GeeHashMap* headers;
	GeeHashMap* data;
	xmlDoc* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
};

struct _GameHubUtilsParserParseRemoteHtmlFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* url;
	gchar* method;
	gchar* auth;
	GeeHashMap* headers;
	GeeHashMap* data;
	xmlDoc* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
};

struct _GameHubUtilsParamSpecParser {
	GParamSpec parent_instance;
};

static gpointer game_hub_utils_parser_parent_class = NULL;
static SoupSession* game_hub_utils_parser_session;
static SoupSession* game_hub_utils_parser_session = NULL;

VALA_EXTERN gpointer game_hub_utils_parser_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_param_spec_parser (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void game_hub_utils_value_set_parser (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void game_hub_utils_value_take_parser (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_value_get_parser (const GValue* value);
VALA_EXTERN GType game_hub_utils_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsParser, game_hub_utils_parser_unref)
VALA_EXTERN gchar* game_hub_utils_parser_load_file (const gchar* path,
                                        const gchar* file);
VALA_EXTERN GFile* game_hub_utils_fs_utils_file (const gchar* path,
                                     const gchar* file,
                                     GeeHashMap* variables);
static SoupMessage* game_hub_utils_parser_prepare_message (const gchar* url,
                                                    const gchar* method,
                                                    const gchar* auth,
                                                    GeeHashMap* headers,
                                                    GeeHashMap* data);
static void _vala_SoupMultipart_free (SoupMultipart* self);
VALA_EXTERN gchar* game_hub_utils_parser_load_remote_file (const gchar* url,
                                               const gchar* method,
                                               const gchar* auth,
                                               GeeHashMap* headers,
                                               GeeHashMap* data,
                                               guint* status);
static void game_hub_utils_parser_load_remote_file_async_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_parser_load_remote_file_async (const gchar* url,
                                                   const gchar* method,
                                                   const gchar* auth,
                                                   GeeHashMap* headers,
                                                   GeeHashMap* data,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar* game_hub_utils_parser_load_remote_file_finish (GAsyncResult* _res_,
                                                      guint* status);
static gboolean game_hub_utils_parser_load_remote_file_async_co (GameHubUtilsParserLoadRemoteFileAsyncData* _data_);
static Block125Data* block125_data_ref (Block125Data* _data125_);
static void block125_data_unref (void * _userdata_);
static void __lambda6_ (Block125Data* _data125_,
                 SoupSession* s,
                 SoupMessage* m);
static void ___lambda6__soup_session_callback (SoupSession* session,
                                        SoupMessage* msg,
                                        gpointer self);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_json (const gchar* json);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_vdf (const gchar* vdf);
static gchar* game_hub_utils_parser_vdf_to_json (const gchar* vdf_data);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_json_file (const gchar* path,
                                                 const gchar* file);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_vdf_file (const gchar* path,
                                                const gchar* file);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_remote_json_file (const gchar* url,
                                                        const gchar* method,
                                                        const gchar* auth,
                                                        GeeHashMap* headers,
                                                        GeeHashMap* data,
                                                        guint* status);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_remote_vdf_file (const gchar* url,
                                                       const gchar* method,
                                                       const gchar* auth,
                                                       GeeHashMap* headers,
                                                       GeeHashMap* data,
                                                       guint* status);
static void _vala_JsonNode_free (JsonNode* self);
static void game_hub_utils_parser_parse_remote_json_file_async_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_parser_parse_remote_json_file_async (const gchar* url,
                                                         const gchar* method,
                                                         const gchar* auth,
                                                         GeeHashMap* headers,
                                                         GeeHashMap* data,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_remote_json_file_finish (GAsyncResult* _res_,
                                                               guint* status);
static gboolean game_hub_utils_parser_parse_remote_json_file_async_co (GameHubUtilsParserParseRemoteJsonFileAsyncData* _data_);
static void game_hub_utils_parser_parse_remote_json_file_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void game_hub_utils_parser_parse_remote_vdf_file_async_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_parser_parse_remote_vdf_file_async (const gchar* url,
                                                        const gchar* method,
                                                        const gchar* auth,
                                                        GeeHashMap* headers,
                                                        GeeHashMap* data,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_remote_vdf_file_finish (GAsyncResult* _res_,
                                                              guint* status);
static gboolean game_hub_utils_parser_parse_remote_vdf_file_async_co (GameHubUtilsParserParseRemoteVdfFileAsyncData* _data_);
static void game_hub_utils_parser_parse_remote_vdf_file_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
VALA_EXTERN JsonObject* game_hub_utils_parser_json_object (JsonNode* root,
                                               gchar** keys,
                                               gint keys_length1);
VALA_EXTERN JsonObject* game_hub_utils_parser_json_nested_object (JsonObject* root,
                                                      gchar** keys,
                                                      gint keys_length1);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_xml (const gchar* xml);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_html (const gchar* html,
                                          const gchar* url);
VALA_EXTERN xmlNode* game_hub_utils_parser_html_node (xmlNode* root,
                                          gchar** tags,
                                          gint tags_length1);
VALA_EXTERN xmlNode* game_hub_utils_parser_html_subnode (xmlNode* root,
                                             const gchar* name);
VALA_EXTERN xmlNode* game_hub_utils_parser_xml_subnode (xmlNode* root,
                                            const gchar* name);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_xml_file (const gchar* path,
                                              const gchar* file);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_remote_xml_file (const gchar* url,
                                                     const gchar* method,
                                                     const gchar* auth,
                                                     GeeHashMap* headers,
                                                     GeeHashMap* data);
static void game_hub_utils_parser_parse_remote_xml_file_async_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_parser_parse_remote_xml_file_async (const gchar* url,
                                                        const gchar* method,
                                                        const gchar* auth,
                                                        GeeHashMap* headers,
                                                        GeeHashMap* data,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_remote_xml_file_finish (GAsyncResult* _res_);
static gboolean game_hub_utils_parser_parse_remote_xml_file_async_co (GameHubUtilsParserParseRemoteXmlFileAsyncData* _data_);
static void game_hub_utils_parser_parse_remote_xml_file_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_html_file (const gchar* path,
                                               const gchar* file);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_remote_html_file (const gchar* url,
                                                      const gchar* method,
                                                      const gchar* auth,
                                                      GeeHashMap* headers,
                                                      GeeHashMap* data);
static void game_hub_utils_parser_parse_remote_html_file_async_data_free (gpointer _data);
VALA_EXTERN void game_hub_utils_parser_parse_remote_html_file_async (const gchar* url,
                                                         const gchar* method,
                                                         const gchar* auth,
                                                         GeeHashMap* headers,
                                                         GeeHashMap* data,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_remote_html_file_finish (GAsyncResult* _res_);
static gboolean game_hub_utils_parser_parse_remote_html_file_async_co (GameHubUtilsParserParseRemoteHtmlFileAsyncData* _data_);
static void game_hub_utils_parser_parse_remote_html_file_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
VALA_EXTERN gchar* game_hub_utils_parser_xml_node_to_string (xmlNode* node);
VALA_EXTERN JsonNode* game_hub_utils_parser_json (GameHubUtilsParserJsonBulderDelegate d,
                                      gpointer d_target);
VALA_EXTERN GameHubUtilsParser* game_hub_utils_parser_new (void);
VALA_EXTERN GameHubUtilsParser* game_hub_utils_parser_construct (GType object_type);
static void game_hub_utils_parser_finalize (GameHubUtilsParser * obj);
static GType game_hub_utils_parser_get_type_once (void);

gchar*
game_hub_utils_parser_load_file (const gchar* path,
                                 const gchar* file)
{
	GFile* f = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* data = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 29 "../src/utils/Parser.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 29 "../src/utils/Parser.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 31 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_fs_utils_file (path, file, NULL);
#line 31 "../src/utils/Parser.vala"
	f = _tmp0_;
#line 32 "../src/utils/Parser.vala"
	_tmp1_ = f;
#line 32 "../src/utils/Parser.vala"
	if (!g_file_query_exists (_tmp1_, NULL)) {
#line 387 "Parser.c"
		gchar* _tmp2_;
#line 32 "../src/utils/Parser.vala"
		_tmp2_ = g_strdup ("");
#line 32 "../src/utils/Parser.vala"
		result = _tmp2_;
#line 32 "../src/utils/Parser.vala"
		_g_object_unref0 (f);
#line 32 "../src/utils/Parser.vala"
		return result;
#line 397 "Parser.c"
	}
	{
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
#line 36 "../src/utils/Parser.vala"
		_tmp3_ = f;
#line 36 "../src/utils/Parser.vala"
		_tmp4_ = g_file_get_path (_tmp3_);
#line 36 "../src/utils/Parser.vala"
		_tmp5_ = _tmp4_;
#line 36 "../src/utils/Parser.vala"
		g_file_get_contents (_tmp5_, &_tmp6_, NULL, &_inner_error0_);
#line 36 "../src/utils/Parser.vala"
		_g_free0 (data);
#line 36 "../src/utils/Parser.vala"
		data = _tmp6_;
#line 36 "../src/utils/Parser.vala"
		_g_free0 (_tmp5_);
#line 36 "../src/utils/Parser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 420 "Parser.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 34 "../src/utils/Parser.vala"
		e = _inner_error0_;
#line 34 "../src/utils/Parser.vala"
		_inner_error0_ = NULL;
#line 40 "../src/utils/Parser.vala"
		_tmp7_ = e;
#line 40 "../src/utils/Parser.vala"
		_tmp8_ = _tmp7_->message;
#line 40 "../src/utils/Parser.vala"
		g_warning ("Parser.vala:40: %s", _tmp8_);
#line 34 "../src/utils/Parser.vala"
		_g_error_free0 (e);
#line 442 "Parser.c"
	}
	__finally0:
#line 34 "../src/utils/Parser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 34 "../src/utils/Parser.vala"
		_g_free0 (data);
#line 34 "../src/utils/Parser.vala"
		_g_object_unref0 (f);
#line 34 "../src/utils/Parser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 34 "../src/utils/Parser.vala"
		g_clear_error (&_inner_error0_);
#line 34 "../src/utils/Parser.vala"
		return NULL;
#line 457 "Parser.c"
	}
#line 42 "../src/utils/Parser.vala"
	result = data;
#line 42 "../src/utils/Parser.vala"
	_g_object_unref0 (f);
#line 42 "../src/utils/Parser.vala"
	return result;
#line 465 "Parser.c"
}

static void
_vala_SoupMultipart_free (SoupMultipart* self)
{
#line 70 "../src/utils/Parser.vala"
	g_boxed_free (soup_multipart_get_type (), self);
#line 473 "Parser.c"
}

static SoupMessage*
game_hub_utils_parser_prepare_message (const gchar* url,
                                       const gchar* method,
                                       const gchar* auth,
                                       GeeHashMap* headers,
                                       GeeHashMap* data)
{
	SoupSession* _tmp0_;
	SoupMessage* message = NULL;
	SoupMessage* _tmp5_;
	SoupMessage* result;
#line 45 "../src/utils/Parser.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 45 "../src/utils/Parser.vala"
	g_return_val_if_fail (method != NULL, NULL);
#line 47 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_session;
#line 47 "../src/utils/Parser.vala"
	if (_tmp0_ == NULL) {
#line 495 "Parser.c"
		SoupSession* _tmp1_;
		SoupSession* _tmp2_;
		SoupSession* _tmp3_;
		SoupSession* _tmp4_;
#line 49 "../src/utils/Parser.vala"
		_tmp1_ = soup_session_new ();
#line 49 "../src/utils/Parser.vala"
		_g_object_unref0 (game_hub_utils_parser_session);
#line 49 "../src/utils/Parser.vala"
		game_hub_utils_parser_session = _tmp1_;
#line 50 "../src/utils/Parser.vala"
		_tmp2_ = game_hub_utils_parser_session;
#line 50 "../src/utils/Parser.vala"
		g_object_set (_tmp2_, "timeout", (guint) 5, NULL);
#line 51 "../src/utils/Parser.vala"
		_tmp3_ = game_hub_utils_parser_session;
#line 51 "../src/utils/Parser.vala"
		g_object_set (_tmp3_, "max-conns", 256, NULL);
#line 52 "../src/utils/Parser.vala"
		_tmp4_ = game_hub_utils_parser_session;
#line 52 "../src/utils/Parser.vala"
		g_object_set (_tmp4_, "max-conns-per-host", 256, NULL);
#line 518 "Parser.c"
	}
#line 55 "../src/utils/Parser.vala"
	_tmp5_ = soup_message_new (method, url);
#line 55 "../src/utils/Parser.vala"
	message = _tmp5_;
#line 57 "../src/utils/Parser.vala"
	if (auth != NULL) {
#line 526 "Parser.c"
		SoupMessage* _tmp6_;
		SoupMessageHeaders* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 59 "../src/utils/Parser.vala"
		_tmp6_ = message;
#line 59 "../src/utils/Parser.vala"
		_tmp7_ = _tmp6_->request_headers;
#line 59 "../src/utils/Parser.vala"
		_tmp8_ = g_strconcat ("Bearer ", auth, NULL);
#line 59 "../src/utils/Parser.vala"
		_tmp9_ = _tmp8_;
#line 59 "../src/utils/Parser.vala"
		soup_message_headers_append (_tmp7_, "Authorization", _tmp9_);
#line 59 "../src/utils/Parser.vala"
		_g_free0 (_tmp9_);
#line 543 "Parser.c"
	}
#line 62 "../src/utils/Parser.vala"
	if (headers != NULL) {
#line 547 "Parser.c"
		{
			GeeIterator* _header_it = NULL;
			GeeSet* _tmp10_;
			GeeSet* _tmp11_;
			GeeSet* _tmp12_;
			GeeIterator* _tmp13_;
			GeeIterator* _tmp14_;
#line 64 "../src/utils/Parser.vala"
			_tmp10_ = gee_abstract_map_get_entries ((GeeAbstractMap*) headers);
#line 64 "../src/utils/Parser.vala"
			_tmp11_ = _tmp10_;
#line 64 "../src/utils/Parser.vala"
			_tmp12_ = _tmp11_;
#line 64 "../src/utils/Parser.vala"
			_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
#line 64 "../src/utils/Parser.vala"
			_tmp14_ = _tmp13_;
#line 64 "../src/utils/Parser.vala"
			_g_object_unref0 (_tmp12_);
#line 64 "../src/utils/Parser.vala"
			_header_it = _tmp14_;
#line 64 "../src/utils/Parser.vala"
			while (TRUE) {
#line 571 "Parser.c"
				GeeIterator* _tmp15_;
				GeeMapEntry* header = NULL;
				GeeIterator* _tmp16_;
				gpointer _tmp17_;
				SoupMessage* _tmp18_;
				SoupMessageHeaders* _tmp19_;
				GeeMapEntry* _tmp20_;
				gconstpointer _tmp21_;
				gconstpointer _tmp22_;
				GeeMapEntry* _tmp23_;
				gconstpointer _tmp24_;
				gconstpointer _tmp25_;
#line 64 "../src/utils/Parser.vala"
				_tmp15_ = _header_it;
#line 64 "../src/utils/Parser.vala"
				if (!gee_iterator_next (_tmp15_)) {
#line 64 "../src/utils/Parser.vala"
					break;
#line 590 "Parser.c"
				}
#line 64 "../src/utils/Parser.vala"
				_tmp16_ = _header_it;
#line 64 "../src/utils/Parser.vala"
				_tmp17_ = gee_iterator_get (_tmp16_);
#line 64 "../src/utils/Parser.vala"
				header = (GeeMapEntry*) _tmp17_;
#line 66 "../src/utils/Parser.vala"
				_tmp18_ = message;
#line 66 "../src/utils/Parser.vala"
				_tmp19_ = _tmp18_->request_headers;
#line 66 "../src/utils/Parser.vala"
				_tmp20_ = header;
#line 66 "../src/utils/Parser.vala"
				_tmp21_ = gee_map_entry_get_key (_tmp20_);
#line 66 "../src/utils/Parser.vala"
				_tmp22_ = _tmp21_;
#line 66 "../src/utils/Parser.vala"
				_tmp23_ = header;
#line 66 "../src/utils/Parser.vala"
				_tmp24_ = gee_map_entry_get_value (_tmp23_);
#line 66 "../src/utils/Parser.vala"
				_tmp25_ = _tmp24_;
#line 66 "../src/utils/Parser.vala"
				soup_message_headers_append (_tmp19_, (const gchar*) _tmp22_, (const gchar*) _tmp25_);
#line 64 "../src/utils/Parser.vala"
				_g_object_unref0 (header);
#line 618 "Parser.c"
			}
#line 64 "../src/utils/Parser.vala"
			_g_object_unref0 (_header_it);
#line 622 "Parser.c"
		}
	}
#line 70 "../src/utils/Parser.vala"
	if (data != NULL) {
#line 627 "Parser.c"
		SoupMultipart* multipart = NULL;
		SoupMultipart* _tmp26_;
		SoupMultipart* _tmp42_;
		SoupMessage* _tmp43_;
		SoupMessageHeaders* _tmp44_;
		SoupMessage* _tmp45_;
		SoupMessageBody* _tmp46_;
#line 72 "../src/utils/Parser.vala"
		_tmp26_ = soup_multipart_new ("multipart/form-data");
#line 72 "../src/utils/Parser.vala"
		multipart = _tmp26_;
#line 639 "Parser.c"
		{
			GeeIterator* _v_it = NULL;
			GeeSet* _tmp27_;
			GeeSet* _tmp28_;
			GeeSet* _tmp29_;
			GeeIterator* _tmp30_;
			GeeIterator* _tmp31_;
#line 73 "../src/utils/Parser.vala"
			_tmp27_ = gee_abstract_map_get_entries ((GeeAbstractMap*) data);
#line 73 "../src/utils/Parser.vala"
			_tmp28_ = _tmp27_;
#line 73 "../src/utils/Parser.vala"
			_tmp29_ = _tmp28_;
#line 73 "../src/utils/Parser.vala"
			_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
#line 73 "../src/utils/Parser.vala"
			_tmp31_ = _tmp30_;
#line 73 "../src/utils/Parser.vala"
			_g_object_unref0 (_tmp29_);
#line 73 "../src/utils/Parser.vala"
			_v_it = _tmp31_;
#line 73 "../src/utils/Parser.vala"
			while (TRUE) {
#line 663 "Parser.c"
				GeeIterator* _tmp32_;
				GeeMapEntry* v = NULL;
				GeeIterator* _tmp33_;
				gpointer _tmp34_;
				SoupMultipart* _tmp35_;
				GeeMapEntry* _tmp36_;
				gconstpointer _tmp37_;
				gconstpointer _tmp38_;
				GeeMapEntry* _tmp39_;
				gconstpointer _tmp40_;
				gconstpointer _tmp41_;
#line 73 "../src/utils/Parser.vala"
				_tmp32_ = _v_it;
#line 73 "../src/utils/Parser.vala"
				if (!gee_iterator_next (_tmp32_)) {
#line 73 "../src/utils/Parser.vala"
					break;
#line 681 "Parser.c"
				}
#line 73 "../src/utils/Parser.vala"
				_tmp33_ = _v_it;
#line 73 "../src/utils/Parser.vala"
				_tmp34_ = gee_iterator_get (_tmp33_);
#line 73 "../src/utils/Parser.vala"
				v = (GeeMapEntry*) _tmp34_;
#line 75 "../src/utils/Parser.vala"
				_tmp35_ = multipart;
#line 75 "../src/utils/Parser.vala"
				_tmp36_ = v;
#line 75 "../src/utils/Parser.vala"
				_tmp37_ = gee_map_entry_get_key (_tmp36_);
#line 75 "../src/utils/Parser.vala"
				_tmp38_ = _tmp37_;
#line 75 "../src/utils/Parser.vala"
				_tmp39_ = v;
#line 75 "../src/utils/Parser.vala"
				_tmp40_ = gee_map_entry_get_value (_tmp39_);
#line 75 "../src/utils/Parser.vala"
				_tmp41_ = _tmp40_;
#line 75 "../src/utils/Parser.vala"
				soup_multipart_append_form_string (_tmp35_, (const gchar*) _tmp38_, (const gchar*) _tmp41_);
#line 73 "../src/utils/Parser.vala"
				_g_object_unref0 (v);
#line 707 "Parser.c"
			}
#line 73 "../src/utils/Parser.vala"
			_g_object_unref0 (_v_it);
#line 711 "Parser.c"
		}
#line 77 "../src/utils/Parser.vala"
		_tmp42_ = multipart;
#line 77 "../src/utils/Parser.vala"
		_tmp43_ = message;
#line 77 "../src/utils/Parser.vala"
		_tmp44_ = _tmp43_->request_headers;
#line 77 "../src/utils/Parser.vala"
		_tmp45_ = message;
#line 77 "../src/utils/Parser.vala"
		_tmp46_ = _tmp45_->request_body;
#line 77 "../src/utils/Parser.vala"
		soup_multipart_to_message (_tmp42_, _tmp44_, _tmp46_);
#line 70 "../src/utils/Parser.vala"
		__vala_SoupMultipart_free0 (multipart);
#line 727 "Parser.c"
	}
#line 80 "../src/utils/Parser.vala"
	result = message;
#line 80 "../src/utils/Parser.vala"
	return result;
#line 733 "Parser.c"
}

gchar*
game_hub_utils_parser_load_remote_file (const gchar* url,
                                        const gchar* method,
                                        const gchar* auth,
                                        GeeHashMap* headers,
                                        GeeHashMap* data,
                                        guint* status)
{
	guint _vala_status = 0U;
	SoupMessage* message = NULL;
	SoupMessage* _tmp0_;
	SoupSession* _tmp1_;
	SoupMessageBody* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* result;
#line 83 "../src/utils/Parser.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 83 "../src/utils/Parser.vala"
	g_return_val_if_fail (method != NULL, NULL);
#line 85 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_prepare_message (url, method, auth, headers, data);
#line 85 "../src/utils/Parser.vala"
	message = _tmp0_;
#line 87 "../src/utils/Parser.vala"
	_tmp1_ = game_hub_utils_parser_session;
#line 87 "../src/utils/Parser.vala"
	_vala_status = soup_session_send_message (_tmp1_, message);
#line 88 "../src/utils/Parser.vala"
	_tmp2_ = message->response_body;
#line 88 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_->data;
#line 88 "../src/utils/Parser.vala"
	_tmp3__length1 = _tmp2_->length;
#line 88 "../src/utils/Parser.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 88 "../src/utils/Parser.vala"
	result = _tmp4_;
#line 88 "../src/utils/Parser.vala"
	_g_object_unref0 (message);
#line 88 "../src/utils/Parser.vala"
	if (status) {
#line 88 "../src/utils/Parser.vala"
		*status = _vala_status;
#line 781 "Parser.c"
	}
#line 88 "../src/utils/Parser.vala"
	return result;
#line 785 "Parser.c"
}

static void
game_hub_utils_parser_load_remote_file_async_data_free (gpointer _data)
{
	GameHubUtilsParserLoadRemoteFileAsyncData* _data_;
	_data_ = _data;
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->result);
#line 25 "../src/utils/Parser.vala"
	g_slice_free (GameHubUtilsParserLoadRemoteFileAsyncData, _data_);
#line 807 "Parser.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 25 "../src/utils/Parser.vala"
	return self ? g_object_ref (self) : NULL;
#line 815 "Parser.c"
}

void
game_hub_utils_parser_load_remote_file_async (const gchar* url,
                                              const gchar* method,
                                              const gchar* auth,
                                              GeeHashMap* headers,
                                              GeeHashMap* data,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GameHubUtilsParserLoadRemoteFileAsyncData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (url != NULL);
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (method != NULL);
#line 25 "../src/utils/Parser.vala"
	_data_ = g_slice_new0 (GameHubUtilsParserLoadRemoteFileAsyncData);
#line 25 "../src/utils/Parser.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 25 "../src/utils/Parser.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_parser_load_remote_file_async_data_free);
#line 25 "../src/utils/Parser.vala"
	_tmp0_ = g_strdup (url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_data_->url = _tmp0_;
#line 25 "../src/utils/Parser.vala"
	_tmp1_ = g_strdup (method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_data_->method = _tmp1_;
#line 25 "../src/utils/Parser.vala"
	_tmp2_ = g_strdup (auth);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_data_->auth = _tmp2_;
#line 25 "../src/utils/Parser.vala"
	_tmp3_ = _g_object_ref0 (headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_data_->headers = _tmp3_;
#line 25 "../src/utils/Parser.vala"
	_tmp4_ = _g_object_ref0 (data);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	_data_->data = _tmp4_;
#line 25 "../src/utils/Parser.vala"
	game_hub_utils_parser_load_remote_file_async_co (_data_);
#line 875 "Parser.c"
}

gchar*
game_hub_utils_parser_load_remote_file_finish (GAsyncResult* _res_,
                                               guint* status)
{
	gchar* result;
	GameHubUtilsParserLoadRemoteFileAsyncData* _data_;
#line 25 "../src/utils/Parser.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 25 "../src/utils/Parser.vala"
	if (status) {
#line 25 "../src/utils/Parser.vala"
		*status = _data_->status;
#line 890 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	result = _data_->result;
#line 25 "../src/utils/Parser.vala"
	_data_->result = NULL;
#line 25 "../src/utils/Parser.vala"
	return result;
#line 898 "Parser.c"
}

static Block125Data*
block125_data_ref (Block125Data* _data125_)
{
#line 91 "../src/utils/Parser.vala"
	g_atomic_int_inc (&_data125_->_ref_count_);
#line 91 "../src/utils/Parser.vala"
	return _data125_;
#line 908 "Parser.c"
}

static void
block125_data_unref (void * _userdata_)
{
	Block125Data* _data125_;
	_data125_ = (Block125Data*) _userdata_;
#line 91 "../src/utils/Parser.vala"
	if (g_atomic_int_dec_and_test (&_data125_->_ref_count_)) {
#line 91 "../src/utils/Parser.vala"
		_g_free0 (_data125_->_result_);
#line 91 "../src/utils/Parser.vala"
		g_slice_free (Block125Data, _data125_);
#line 922 "Parser.c"
	}
}

static void
__lambda6_ (Block125Data* _data125_,
            SoupSession* s,
            SoupMessage* m)
{
	guint _tmp0_;
	guint _tmp1_;
	SoupMessageBody* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
#line 97 "../src/utils/Parser.vala"
	g_return_if_fail (s != NULL);
#line 97 "../src/utils/Parser.vala"
	g_return_if_fail (m != NULL);
#line 98 "../src/utils/Parser.vala"
	g_object_get (m, "status-code", &_tmp0_, NULL);
#line 98 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 98 "../src/utils/Parser.vala"
	_data125_->status_code = _tmp1_;
#line 99 "../src/utils/Parser.vala"
	_tmp2_ = m->response_body;
#line 99 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_->data;
#line 99 "../src/utils/Parser.vala"
	_tmp3__length1 = _tmp2_->length;
#line 99 "../src/utils/Parser.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 99 "../src/utils/Parser.vala"
	_g_free0 (_data125_->_result_);
#line 99 "../src/utils/Parser.vala"
	_data125_->_result_ = _tmp4_;
#line 100 "../src/utils/Parser.vala"
	game_hub_utils_parser_load_remote_file_async_co (_data125_->_async_data_);
#line 961 "Parser.c"
}

static void
___lambda6__soup_session_callback (SoupSession* session,
                                   SoupMessage* msg,
                                   gpointer self)
{
#line 97 "../src/utils/Parser.vala"
	__lambda6_ (self, session, msg);
#line 97 "../src/utils/Parser.vala"
	block125_data_unref (self);
#line 973 "Parser.c"
}

static gboolean
game_hub_utils_parser_load_remote_file_async_co (GameHubUtilsParserLoadRemoteFileAsyncData* _data_)
{
#line 91 "../src/utils/Parser.vala"
	switch (_data_->_state_) {
#line 91 "../src/utils/Parser.vala"
		case 0:
#line 983 "Parser.c"
		goto _state_0;
#line 91 "../src/utils/Parser.vala"
		case 1:
#line 987 "Parser.c"
		goto _state_1;
		default:
#line 91 "../src/utils/Parser.vala"
		g_assert_not_reached ();
#line 992 "Parser.c"
	}
	_state_0:
#line 91 "../src/utils/Parser.vala"
	_data_->_data125_ = g_slice_new0 (Block125Data);
#line 91 "../src/utils/Parser.vala"
	_data_->_data125_->_ref_count_ = 1;
#line 91 "../src/utils/Parser.vala"
	_data_->_data125_->_async_data_ = _data_;
#line 93 "../src/utils/Parser.vala"
	_data_->_data125_->status_code = (guint) 0;
#line 94 "../src/utils/Parser.vala"
	_data_->_tmp0_ = g_strdup ("");
#line 94 "../src/utils/Parser.vala"
	_data_->_data125_->_result_ = _data_->_tmp0_;
#line 95 "../src/utils/Parser.vala"
	_data_->_tmp1_ = game_hub_utils_parser_prepare_message (_data_->url, _data_->method, _data_->auth, _data_->headers, _data_->data);
#line 95 "../src/utils/Parser.vala"
	_data_->message = _data_->_tmp1_;
#line 97 "../src/utils/Parser.vala"
	_data_->_tmp2_ = game_hub_utils_parser_session;
#line 97 "../src/utils/Parser.vala"
	_data_->_tmp3_ = _g_object_ref0 (_data_->message);
#line 97 "../src/utils/Parser.vala"
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp3_, ___lambda6__soup_session_callback, block125_data_ref (_data_->_data125_));
#line 102 "../src/utils/Parser.vala"
	_data_->_state_ = 1;
#line 102 "../src/utils/Parser.vala"
	return FALSE;
#line 1021 "Parser.c"
	_state_1:
	;
#line 103 "../src/utils/Parser.vala"
	_data_->status = _data_->_data125_->status_code;
#line 104 "../src/utils/Parser.vala"
	_data_->_tmp4_ = g_strdup (_data_->_data125_->_result_);
#line 104 "../src/utils/Parser.vala"
	_data_->result = _data_->_tmp4_;
#line 104 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->message);
#line 104 "../src/utils/Parser.vala"
	block125_data_unref (_data_->_data125_);
#line 104 "../src/utils/Parser.vala"
	_data_->_data125_ = NULL;
#line 104 "../src/utils/Parser.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 104 "../src/utils/Parser.vala"
	if (_data_->_state_ != 0) {
#line 104 "../src/utils/Parser.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 104 "../src/utils/Parser.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1044 "Parser.c"
		}
	}
#line 104 "../src/utils/Parser.vala"
	g_object_unref (_data_->_async_result);
#line 104 "../src/utils/Parser.vala"
	return FALSE;
#line 1051 "Parser.c"
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
#line 114 "../src/utils/Parser.vala"
	return g_boxed_copy (json_node_get_type (), self);
#line 1059 "Parser.c"
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
#line 114 "../src/utils/Parser.vala"
	return self ? _vala_JsonNode_copy (self) : NULL;
#line 1067 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_json (const gchar* json)
{
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp11_;
	GError* _inner_error0_ = NULL;
	JsonNode* result;
#line 109 "../src/utils/Parser.vala"
	if (json == NULL) {
#line 109 "../src/utils/Parser.vala"
		_tmp0_ = TRUE;
#line 1081 "Parser.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 109 "../src/utils/Parser.vala"
		_tmp1_ = strlen (json);
#line 109 "../src/utils/Parser.vala"
		_tmp2_ = _tmp1_;
#line 109 "../src/utils/Parser.vala"
		_tmp0_ = _tmp2_ == 0;
#line 1091 "Parser.c"
	}
#line 109 "../src/utils/Parser.vala"
	if (_tmp0_) {
#line 1095 "Parser.c"
		JsonNode* _tmp3_;
#line 109 "../src/utils/Parser.vala"
		_tmp3_ = json_node_new (JSON_NODE_NULL);
#line 109 "../src/utils/Parser.vala"
		result = _tmp3_;
#line 109 "../src/utils/Parser.vala"
		return result;
#line 1103 "Parser.c"
	}
	{
		JsonParser* parser = NULL;
		JsonParser* _tmp4_;
		JsonParser* _tmp5_;
		JsonParser* _tmp6_;
		JsonNode* _tmp7_;
		JsonNode* _tmp8_;
#line 112 "../src/utils/Parser.vala"
		_tmp4_ = json_parser_new ();
#line 112 "../src/utils/Parser.vala"
		parser = _tmp4_;
#line 113 "../src/utils/Parser.vala"
		_tmp5_ = parser;
#line 113 "../src/utils/Parser.vala"
		json_parser_load_from_data (_tmp5_, json, (gssize) -1, &_inner_error0_);
#line 113 "../src/utils/Parser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 113 "../src/utils/Parser.vala"
			_g_object_unref0 (parser);
#line 1124 "Parser.c"
			goto __catch0_g_error;
		}
#line 114 "../src/utils/Parser.vala"
		_tmp6_ = parser;
#line 114 "../src/utils/Parser.vala"
		_tmp7_ = json_parser_get_root (_tmp6_);
#line 114 "../src/utils/Parser.vala"
		_tmp8_ = __vala_JsonNode_copy0 (_tmp7_);
#line 114 "../src/utils/Parser.vala"
		result = _tmp8_;
#line 114 "../src/utils/Parser.vala"
		_g_object_unref0 (parser);
#line 114 "../src/utils/Parser.vala"
		return result;
#line 1139 "Parser.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 110 "../src/utils/Parser.vala"
		e = _inner_error0_;
#line 110 "../src/utils/Parser.vala"
		_inner_error0_ = NULL;
#line 118 "../src/utils/Parser.vala"
		_tmp9_ = e;
#line 118 "../src/utils/Parser.vala"
		_tmp10_ = _tmp9_->message;
#line 118 "../src/utils/Parser.vala"
		g_warning ("Parser.vala:118: %s", _tmp10_);
#line 110 "../src/utils/Parser.vala"
		_g_error_free0 (e);
#line 1159 "Parser.c"
	}
	__finally0:
#line 110 "../src/utils/Parser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 110 "../src/utils/Parser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 110 "../src/utils/Parser.vala"
		g_clear_error (&_inner_error0_);
#line 110 "../src/utils/Parser.vala"
		return NULL;
#line 1170 "Parser.c"
	}
#line 120 "../src/utils/Parser.vala"
	_tmp11_ = json_node_new (JSON_NODE_NULL);
#line 120 "../src/utils/Parser.vala"
	result = _tmp11_;
#line 120 "../src/utils/Parser.vala"
	return result;
#line 1178 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_vdf (const gchar* vdf)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	JsonNode* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* result;
#line 123 "../src/utils/Parser.vala"
	g_return_val_if_fail (vdf != NULL, NULL);
#line 125 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_vdf_to_json (vdf);
#line 125 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 125 "../src/utils/Parser.vala"
	_tmp2_ = game_hub_utils_parser_parse_json (_tmp1_);
#line 125 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_;
#line 125 "../src/utils/Parser.vala"
	_g_free0 (_tmp1_);
#line 125 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 125 "../src/utils/Parser.vala"
	return result;
#line 1205 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_json_file (const gchar* path,
                                       const gchar* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	JsonNode* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* result;
#line 128 "../src/utils/Parser.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 128 "../src/utils/Parser.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 130 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_load_file (path, file);
#line 130 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 130 "../src/utils/Parser.vala"
	_tmp2_ = game_hub_utils_parser_parse_json (_tmp1_);
#line 130 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_;
#line 130 "../src/utils/Parser.vala"
	_g_free0 (_tmp1_);
#line 130 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 130 "../src/utils/Parser.vala"
	return result;
#line 1235 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_vdf_file (const gchar* path,
                                      const gchar* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	JsonNode* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* result;
#line 133 "../src/utils/Parser.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 133 "../src/utils/Parser.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 135 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_load_file (path, file);
#line 135 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 135 "../src/utils/Parser.vala"
	_tmp2_ = game_hub_utils_parser_parse_vdf (_tmp1_);
#line 135 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_;
#line 135 "../src/utils/Parser.vala"
	_g_free0 (_tmp1_);
#line 135 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 135 "../src/utils/Parser.vala"
	return result;
#line 1265 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_remote_json_file (const gchar* url,
                                              const gchar* method,
                                              const gchar* auth,
                                              GeeHashMap* headers,
                                              GeeHashMap* data,
                                              guint* status)
{
	guint _vala_status = 0U;
	guint _tmp0_ = 0U;
	gchar* _tmp1_;
	gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* result;
#line 138 "../src/utils/Parser.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 138 "../src/utils/Parser.vala"
	g_return_val_if_fail (method != NULL, NULL);
#line 140 "../src/utils/Parser.vala"
	_tmp1_ = game_hub_utils_parser_load_remote_file (url, method, auth, headers, data, &_tmp0_);
#line 140 "../src/utils/Parser.vala"
	_vala_status = _tmp0_;
#line 140 "../src/utils/Parser.vala"
	_tmp2_ = _tmp1_;
#line 140 "../src/utils/Parser.vala"
	_tmp3_ = game_hub_utils_parser_parse_json (_tmp2_);
#line 140 "../src/utils/Parser.vala"
	_tmp4_ = _tmp3_;
#line 140 "../src/utils/Parser.vala"
	_g_free0 (_tmp2_);
#line 140 "../src/utils/Parser.vala"
	result = _tmp4_;
#line 140 "../src/utils/Parser.vala"
	if (status) {
#line 140 "../src/utils/Parser.vala"
		*status = _vala_status;
#line 1305 "Parser.c"
	}
#line 140 "../src/utils/Parser.vala"
	return result;
#line 1309 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_remote_vdf_file (const gchar* url,
                                             const gchar* method,
                                             const gchar* auth,
                                             GeeHashMap* headers,
                                             GeeHashMap* data,
                                             guint* status)
{
	guint _vala_status = 0U;
	guint _tmp0_ = 0U;
	gchar* _tmp1_;
	gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	JsonNode* result;
#line 143 "../src/utils/Parser.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 143 "../src/utils/Parser.vala"
	g_return_val_if_fail (method != NULL, NULL);
#line 145 "../src/utils/Parser.vala"
	_tmp1_ = game_hub_utils_parser_load_remote_file (url, method, auth, headers, data, &_tmp0_);
#line 145 "../src/utils/Parser.vala"
	_vala_status = _tmp0_;
#line 145 "../src/utils/Parser.vala"
	_tmp2_ = _tmp1_;
#line 145 "../src/utils/Parser.vala"
	_tmp3_ = game_hub_utils_parser_parse_vdf (_tmp2_);
#line 145 "../src/utils/Parser.vala"
	_tmp4_ = _tmp3_;
#line 145 "../src/utils/Parser.vala"
	_g_free0 (_tmp2_);
#line 145 "../src/utils/Parser.vala"
	result = _tmp4_;
#line 145 "../src/utils/Parser.vala"
	if (status) {
#line 145 "../src/utils/Parser.vala"
		*status = _vala_status;
#line 1349 "Parser.c"
	}
#line 145 "../src/utils/Parser.vala"
	return result;
#line 1353 "Parser.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 25 "../src/utils/Parser.vala"
	g_boxed_free (json_node_get_type (), self);
#line 1361 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_json_file_async_data_free (gpointer _data)
{
	GameHubUtilsParserParseRemoteJsonFileAsyncData* _data_;
	_data_ = _data;
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	__vala_JsonNode_free0 (_data_->result);
#line 25 "../src/utils/Parser.vala"
	g_slice_free (GameHubUtilsParserParseRemoteJsonFileAsyncData, _data_);
#line 1383 "Parser.c"
}

void
game_hub_utils_parser_parse_remote_json_file_async (const gchar* url,
                                                    const gchar* method,
                                                    const gchar* auth,
                                                    GeeHashMap* headers,
                                                    GeeHashMap* data,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteJsonFileAsyncData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (url != NULL);
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (method != NULL);
#line 25 "../src/utils/Parser.vala"
	_data_ = g_slice_new0 (GameHubUtilsParserParseRemoteJsonFileAsyncData);
#line 25 "../src/utils/Parser.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 25 "../src/utils/Parser.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_parser_parse_remote_json_file_async_data_free);
#line 25 "../src/utils/Parser.vala"
	_tmp0_ = g_strdup (url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_data_->url = _tmp0_;
#line 25 "../src/utils/Parser.vala"
	_tmp1_ = g_strdup (method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_data_->method = _tmp1_;
#line 25 "../src/utils/Parser.vala"
	_tmp2_ = g_strdup (auth);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_data_->auth = _tmp2_;
#line 25 "../src/utils/Parser.vala"
	_tmp3_ = _g_object_ref0 (headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_data_->headers = _tmp3_;
#line 25 "../src/utils/Parser.vala"
	_tmp4_ = _g_object_ref0 (data);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	_data_->data = _tmp4_;
#line 25 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_json_file_async_co (_data_);
#line 1443 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_remote_json_file_finish (GAsyncResult* _res_,
                                                     guint* status)
{
	JsonNode* result;
	GameHubUtilsParserParseRemoteJsonFileAsyncData* _data_;
#line 25 "../src/utils/Parser.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 25 "../src/utils/Parser.vala"
	if (status) {
#line 25 "../src/utils/Parser.vala"
		*status = _data_->status;
#line 1458 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	result = _data_->result;
#line 25 "../src/utils/Parser.vala"
	_data_->result = NULL;
#line 25 "../src/utils/Parser.vala"
	return result;
#line 1466 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_json_file_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteJsonFileAsyncData* _data_;
#line 150 "../src/utils/Parser.vala"
	_data_ = _user_data_;
#line 150 "../src/utils/Parser.vala"
	_data_->_source_object_ = source_object;
#line 150 "../src/utils/Parser.vala"
	_data_->_res_ = _res_;
#line 150 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_json_file_async_co (_data_);
#line 1483 "Parser.c"
}

static gboolean
game_hub_utils_parser_parse_remote_json_file_async_co (GameHubUtilsParserParseRemoteJsonFileAsyncData* _data_)
{
#line 148 "../src/utils/Parser.vala"
	switch (_data_->_state_) {
#line 148 "../src/utils/Parser.vala"
		case 0:
#line 1493 "Parser.c"
		goto _state_0;
#line 148 "../src/utils/Parser.vala"
		case 1:
#line 1497 "Parser.c"
		goto _state_1;
		default:
#line 148 "../src/utils/Parser.vala"
		g_assert_not_reached ();
#line 1502 "Parser.c"
	}
	_state_0:
#line 150 "../src/utils/Parser.vala"
	_data_->_tmp0_ = 0U;
#line 150 "../src/utils/Parser.vala"
	_data_->_state_ = 1;
#line 150 "../src/utils/Parser.vala"
	game_hub_utils_parser_load_remote_file_async (_data_->url, _data_->method, _data_->auth, _data_->headers, _data_->data, game_hub_utils_parser_parse_remote_json_file_async_ready, _data_);
#line 150 "../src/utils/Parser.vala"
	return FALSE;
#line 1513 "Parser.c"
	_state_1:
#line 150 "../src/utils/Parser.vala"
	_data_->_tmp1_ = game_hub_utils_parser_load_remote_file_finish (_data_->_res_, &_data_->_tmp0_);
#line 150 "../src/utils/Parser.vala"
	_data_->status = _data_->_tmp0_;
#line 150 "../src/utils/Parser.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 150 "../src/utils/Parser.vala"
	_data_->_tmp3_ = game_hub_utils_parser_parse_json (_data_->_tmp2_);
#line 150 "../src/utils/Parser.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 150 "../src/utils/Parser.vala"
	_g_free0 (_data_->_tmp2_);
#line 150 "../src/utils/Parser.vala"
	_data_->result = _data_->_tmp4_;
#line 150 "../src/utils/Parser.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 150 "../src/utils/Parser.vala"
	if (_data_->_state_ != 0) {
#line 150 "../src/utils/Parser.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 150 "../src/utils/Parser.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1537 "Parser.c"
		}
	}
#line 150 "../src/utils/Parser.vala"
	g_object_unref (_data_->_async_result);
#line 150 "../src/utils/Parser.vala"
	return FALSE;
#line 1544 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_vdf_file_async_data_free (gpointer _data)
{
	GameHubUtilsParserParseRemoteVdfFileAsyncData* _data_;
	_data_ = _data;
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	__vala_JsonNode_free0 (_data_->result);
#line 25 "../src/utils/Parser.vala"
	g_slice_free (GameHubUtilsParserParseRemoteVdfFileAsyncData, _data_);
#line 1566 "Parser.c"
}

void
game_hub_utils_parser_parse_remote_vdf_file_async (const gchar* url,
                                                   const gchar* method,
                                                   const gchar* auth,
                                                   GeeHashMap* headers,
                                                   GeeHashMap* data,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteVdfFileAsyncData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (url != NULL);
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (method != NULL);
#line 25 "../src/utils/Parser.vala"
	_data_ = g_slice_new0 (GameHubUtilsParserParseRemoteVdfFileAsyncData);
#line 25 "../src/utils/Parser.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 25 "../src/utils/Parser.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_parser_parse_remote_vdf_file_async_data_free);
#line 25 "../src/utils/Parser.vala"
	_tmp0_ = g_strdup (url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_data_->url = _tmp0_;
#line 25 "../src/utils/Parser.vala"
	_tmp1_ = g_strdup (method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_data_->method = _tmp1_;
#line 25 "../src/utils/Parser.vala"
	_tmp2_ = g_strdup (auth);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_data_->auth = _tmp2_;
#line 25 "../src/utils/Parser.vala"
	_tmp3_ = _g_object_ref0 (headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_data_->headers = _tmp3_;
#line 25 "../src/utils/Parser.vala"
	_tmp4_ = _g_object_ref0 (data);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	_data_->data = _tmp4_;
#line 25 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_vdf_file_async_co (_data_);
#line 1626 "Parser.c"
}

JsonNode*
game_hub_utils_parser_parse_remote_vdf_file_finish (GAsyncResult* _res_,
                                                    guint* status)
{
	JsonNode* result;
	GameHubUtilsParserParseRemoteVdfFileAsyncData* _data_;
#line 25 "../src/utils/Parser.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 25 "../src/utils/Parser.vala"
	if (status) {
#line 25 "../src/utils/Parser.vala"
		*status = _data_->status;
#line 1641 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	result = _data_->result;
#line 25 "../src/utils/Parser.vala"
	_data_->result = NULL;
#line 25 "../src/utils/Parser.vala"
	return result;
#line 1649 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_vdf_file_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteVdfFileAsyncData* _data_;
#line 155 "../src/utils/Parser.vala"
	_data_ = _user_data_;
#line 155 "../src/utils/Parser.vala"
	_data_->_source_object_ = source_object;
#line 155 "../src/utils/Parser.vala"
	_data_->_res_ = _res_;
#line 155 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_vdf_file_async_co (_data_);
#line 1666 "Parser.c"
}

static gboolean
game_hub_utils_parser_parse_remote_vdf_file_async_co (GameHubUtilsParserParseRemoteVdfFileAsyncData* _data_)
{
#line 153 "../src/utils/Parser.vala"
	switch (_data_->_state_) {
#line 153 "../src/utils/Parser.vala"
		case 0:
#line 1676 "Parser.c"
		goto _state_0;
#line 153 "../src/utils/Parser.vala"
		case 1:
#line 1680 "Parser.c"
		goto _state_1;
		default:
#line 153 "../src/utils/Parser.vala"
		g_assert_not_reached ();
#line 1685 "Parser.c"
	}
	_state_0:
#line 155 "../src/utils/Parser.vala"
	_data_->_tmp0_ = 0U;
#line 155 "../src/utils/Parser.vala"
	_data_->_state_ = 1;
#line 155 "../src/utils/Parser.vala"
	game_hub_utils_parser_load_remote_file_async (_data_->url, _data_->method, _data_->auth, _data_->headers, _data_->data, game_hub_utils_parser_parse_remote_vdf_file_async_ready, _data_);
#line 155 "../src/utils/Parser.vala"
	return FALSE;
#line 1696 "Parser.c"
	_state_1:
#line 155 "../src/utils/Parser.vala"
	_data_->_tmp1_ = game_hub_utils_parser_load_remote_file_finish (_data_->_res_, &_data_->_tmp0_);
#line 155 "../src/utils/Parser.vala"
	_data_->status = _data_->_tmp0_;
#line 155 "../src/utils/Parser.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 155 "../src/utils/Parser.vala"
	_data_->_tmp3_ = game_hub_utils_parser_parse_vdf (_data_->_tmp2_);
#line 155 "../src/utils/Parser.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 155 "../src/utils/Parser.vala"
	_g_free0 (_data_->_tmp2_);
#line 155 "../src/utils/Parser.vala"
	_data_->result = _data_->_tmp4_;
#line 155 "../src/utils/Parser.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 155 "../src/utils/Parser.vala"
	if (_data_->_state_ != 0) {
#line 155 "../src/utils/Parser.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 155 "../src/utils/Parser.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1720 "Parser.c"
		}
	}
#line 155 "../src/utils/Parser.vala"
	g_object_unref (_data_->_async_result);
#line 155 "../src/utils/Parser.vala"
	return FALSE;
#line 1727 "Parser.c"
}

JsonObject*
game_hub_utils_parser_json_object (JsonNode* root,
                                   gchar** keys,
                                   gint keys_length1)
{
	gboolean _tmp0_ = FALSE;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* result;
#line 160 "../src/utils/Parser.vala"
	if (root == NULL) {
#line 160 "../src/utils/Parser.vala"
		_tmp0_ = TRUE;
#line 1743 "Parser.c"
	} else {
#line 160 "../src/utils/Parser.vala"
		_tmp0_ = json_node_get_node_type (root) != JSON_NODE_OBJECT;
#line 1747 "Parser.c"
	}
#line 160 "../src/utils/Parser.vala"
	if (_tmp0_) {
#line 160 "../src/utils/Parser.vala"
		result = NULL;
#line 160 "../src/utils/Parser.vala"
		return result;
#line 1755 "Parser.c"
	}
#line 161 "../src/utils/Parser.vala"
	_tmp1_ = json_node_get_object (root);
#line 161 "../src/utils/Parser.vala"
	_tmp2_ = game_hub_utils_parser_json_nested_object (_tmp1_, keys, (gint) keys_length1);
#line 161 "../src/utils/Parser.vala"
	result = _tmp2_;
#line 161 "../src/utils/Parser.vala"
	return result;
#line 1765 "Parser.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 167 "../src/utils/Parser.vala"
	return self ? json_object_ref (self) : NULL;
#line 1773 "Parser.c"
}

JsonObject*
game_hub_utils_parser_json_nested_object (JsonObject* root,
                                          gchar** keys,
                                          gint keys_length1)
{
	JsonObject* obj = NULL;
	JsonObject* _tmp0_;
	JsonObject* result;
#line 166 "../src/utils/Parser.vala"
	if (root == NULL) {
#line 166 "../src/utils/Parser.vala"
		result = NULL;
#line 166 "../src/utils/Parser.vala"
		return result;
#line 1790 "Parser.c"
	}
#line 167 "../src/utils/Parser.vala"
	_tmp0_ = _json_object_ref0 (root);
#line 167 "../src/utils/Parser.vala"
	obj = _tmp0_;
#line 1796 "Parser.c"
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
#line 169 "../src/utils/Parser.vala"
		key_collection = keys;
#line 169 "../src/utils/Parser.vala"
		key_collection_length1 = keys_length1;
#line 169 "../src/utils/Parser.vala"
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
#line 1808 "Parser.c"
			gchar* _tmp1_;
			gchar* key = NULL;
#line 169 "../src/utils/Parser.vala"
			_tmp1_ = g_strdup (key_collection[key_it]);
#line 169 "../src/utils/Parser.vala"
			key = _tmp1_;
#line 1815 "Parser.c"
			{
				gboolean _tmp2_ = FALSE;
				JsonObject* _tmp3_;
				JsonObject* _tmp16_;
#line 171 "../src/utils/Parser.vala"
				_tmp3_ = obj;
#line 171 "../src/utils/Parser.vala"
				if (_tmp3_ != NULL) {
#line 1824 "Parser.c"
					JsonObject* _tmp4_;
					const gchar* _tmp5_;
#line 171 "../src/utils/Parser.vala"
					_tmp4_ = obj;
#line 171 "../src/utils/Parser.vala"
					_tmp5_ = key;
#line 171 "../src/utils/Parser.vala"
					_tmp2_ = json_object_has_member (_tmp4_, _tmp5_);
#line 1833 "Parser.c"
				} else {
#line 171 "../src/utils/Parser.vala"
					_tmp2_ = FALSE;
#line 1837 "Parser.c"
				}
#line 171 "../src/utils/Parser.vala"
				if (_tmp2_) {
#line 1841 "Parser.c"
					JsonNode* member = NULL;
					JsonObject* _tmp6_;
					const gchar* _tmp7_;
					JsonNode* _tmp8_;
					JsonNode* _tmp9_;
					gboolean _tmp10_ = FALSE;
					JsonNode* _tmp11_;
#line 173 "../src/utils/Parser.vala"
					_tmp6_ = obj;
#line 173 "../src/utils/Parser.vala"
					_tmp7_ = key;
#line 173 "../src/utils/Parser.vala"
					_tmp8_ = json_object_get_member (_tmp6_, _tmp7_);
#line 173 "../src/utils/Parser.vala"
					_tmp9_ = __vala_JsonNode_copy0 (_tmp8_);
#line 173 "../src/utils/Parser.vala"
					member = _tmp9_;
#line 174 "../src/utils/Parser.vala"
					_tmp11_ = member;
#line 174 "../src/utils/Parser.vala"
					if (_tmp11_ != NULL) {
#line 1863 "Parser.c"
						JsonNode* _tmp12_;
#line 174 "../src/utils/Parser.vala"
						_tmp12_ = member;
#line 174 "../src/utils/Parser.vala"
						_tmp10_ = json_node_get_node_type (_tmp12_) == JSON_NODE_OBJECT;
#line 1869 "Parser.c"
					} else {
#line 174 "../src/utils/Parser.vala"
						_tmp10_ = FALSE;
#line 1873 "Parser.c"
					}
#line 174 "../src/utils/Parser.vala"
					if (_tmp10_) {
#line 1877 "Parser.c"
						JsonNode* _tmp13_;
						JsonObject* _tmp14_;
						JsonObject* _tmp15_;
#line 176 "../src/utils/Parser.vala"
						_tmp13_ = member;
#line 176 "../src/utils/Parser.vala"
						_tmp14_ = json_node_get_object (_tmp13_);
#line 176 "../src/utils/Parser.vala"
						_tmp15_ = _json_object_ref0 (_tmp14_);
#line 176 "../src/utils/Parser.vala"
						_json_object_unref0 (obj);
#line 176 "../src/utils/Parser.vala"
						obj = _tmp15_;
#line 1891 "Parser.c"
					} else {
#line 178 "../src/utils/Parser.vala"
						_json_object_unref0 (obj);
#line 178 "../src/utils/Parser.vala"
						obj = NULL;
#line 1897 "Parser.c"
					}
#line 171 "../src/utils/Parser.vala"
					__vala_JsonNode_free0 (member);
#line 1901 "Parser.c"
				} else {
#line 180 "../src/utils/Parser.vala"
					_json_object_unref0 (obj);
#line 180 "../src/utils/Parser.vala"
					obj = NULL;
#line 1907 "Parser.c"
				}
#line 182 "../src/utils/Parser.vala"
				_tmp16_ = obj;
#line 182 "../src/utils/Parser.vala"
				if (_tmp16_ == NULL) {
#line 182 "../src/utils/Parser.vala"
					_g_free0 (key);
#line 182 "../src/utils/Parser.vala"
					break;
#line 1917 "Parser.c"
				}
#line 169 "../src/utils/Parser.vala"
				_g_free0 (key);
#line 1921 "Parser.c"
			}
		}
	}
#line 185 "../src/utils/Parser.vala"
	result = obj;
#line 185 "../src/utils/Parser.vala"
	return result;
#line 1929 "Parser.c"
}

static gchar*
game_hub_utils_parser_vdf_to_json (const gchar* vdf_data)
{
	gchar* json = NULL;
	gchar* _tmp0_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 188 "../src/utils/Parser.vala"
	g_return_val_if_fail (vdf_data != NULL, NULL);
#line 190 "../src/utils/Parser.vala"
	_tmp0_ = g_strdup (vdf_data);
#line 190 "../src/utils/Parser.vala"
	json = _tmp0_;
#line 1950 "Parser.c"
	{
		GRegex* nl_commas = NULL;
		GRegex* _tmp1_;
		GRegex* semicolons = NULL;
		GRegex* _tmp2_;
		gchar* _tmp3_ = NULL;
		GRegex* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 194 "../src/utils/Parser.vala"
		_tmp1_ = g_regex_new ("(\"|\\})(\\s*?\\r?\\n\\s*?\")", 0, 0, &_inner_error0_);
#line 194 "../src/utils/Parser.vala"
		nl_commas = _tmp1_;
#line 194 "../src/utils/Parser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1978 "Parser.c"
			goto __catch0_g_error;
		}
#line 195 "../src/utils/Parser.vala"
		_tmp2_ = g_regex_new ("\"(\\s*?\\r?\\n?\\s*?(?:\"|\\{))", 0, 0, &_inner_error0_);
#line 195 "../src/utils/Parser.vala"
		semicolons = _tmp2_;
#line 195 "../src/utils/Parser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 195 "../src/utils/Parser.vala"
			_g_regex_unref0 (nl_commas);
#line 1989 "Parser.c"
			goto __catch0_g_error;
		}
#line 197 "../src/utils/Parser.vala"
		_tmp4_ = nl_commas;
#line 197 "../src/utils/Parser.vala"
		_tmp5_ = json;
#line 197 "../src/utils/Parser.vala"
		_tmp6_ = json;
#line 197 "../src/utils/Parser.vala"
		_tmp7_ = strlen (_tmp6_);
#line 197 "../src/utils/Parser.vala"
		_tmp8_ = _tmp7_;
#line 197 "../src/utils/Parser.vala"
		_tmp9_ = g_regex_replace (_tmp4_, _tmp5_, (gssize) _tmp8_, 0, "\\g<1>,\\g<2>", 0, &_inner_error0_);
#line 197 "../src/utils/Parser.vala"
		_tmp3_ = _tmp9_;
#line 197 "../src/utils/Parser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 197 "../src/utils/Parser.vala"
			_g_regex_unref0 (semicolons);
#line 197 "../src/utils/Parser.vala"
			_g_regex_unref0 (nl_commas);
#line 2012 "Parser.c"
			goto __catch0_g_error;
		}
#line 197 "../src/utils/Parser.vala"
		_tmp10_ = _tmp3_;
#line 197 "../src/utils/Parser.vala"
		_tmp3_ = NULL;
#line 197 "../src/utils/Parser.vala"
		_g_free0 (json);
#line 197 "../src/utils/Parser.vala"
		json = _tmp10_;
#line 198 "../src/utils/Parser.vala"
		_tmp12_ = semicolons;
#line 198 "../src/utils/Parser.vala"
		_tmp13_ = json;
#line 198 "../src/utils/Parser.vala"
		_tmp14_ = json;
#line 198 "../src/utils/Parser.vala"
		_tmp15_ = strlen (_tmp14_);
#line 198 "../src/utils/Parser.vala"
		_tmp16_ = _tmp15_;
#line 198 "../src/utils/Parser.vala"
		_tmp17_ = g_regex_replace (_tmp12_, _tmp13_, (gssize) _tmp16_, 0, "\":\\g<1>", 0, &_inner_error0_);
#line 198 "../src/utils/Parser.vala"
		_tmp11_ = _tmp17_;
#line 198 "../src/utils/Parser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 198 "../src/utils/Parser.vala"
			_g_free0 (_tmp3_);
#line 198 "../src/utils/Parser.vala"
			_g_regex_unref0 (semicolons);
#line 198 "../src/utils/Parser.vala"
			_g_regex_unref0 (nl_commas);
#line 2045 "Parser.c"
			goto __catch0_g_error;
		}
#line 198 "../src/utils/Parser.vala"
		_tmp18_ = _tmp11_;
#line 198 "../src/utils/Parser.vala"
		_tmp11_ = NULL;
#line 198 "../src/utils/Parser.vala"
		_g_free0 (json);
#line 198 "../src/utils/Parser.vala"
		json = _tmp18_;
#line 192 "../src/utils/Parser.vala"
		_g_free0 (_tmp11_);
#line 192 "../src/utils/Parser.vala"
		_g_free0 (_tmp3_);
#line 192 "../src/utils/Parser.vala"
		_g_regex_unref0 (semicolons);
#line 192 "../src/utils/Parser.vala"
		_g_regex_unref0 (nl_commas);
#line 2064 "Parser.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
#line 192 "../src/utils/Parser.vala"
		e = _inner_error0_;
#line 192 "../src/utils/Parser.vala"
		_inner_error0_ = NULL;
#line 202 "../src/utils/Parser.vala"
		_tmp19_ = e;
#line 202 "../src/utils/Parser.vala"
		_tmp20_ = _tmp19_->message;
#line 202 "../src/utils/Parser.vala"
		g_warning ("Parser.vala:202: %s", _tmp20_);
#line 192 "../src/utils/Parser.vala"
		_g_error_free0 (e);
#line 2084 "Parser.c"
	}
	__finally0:
#line 192 "../src/utils/Parser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 192 "../src/utils/Parser.vala"
		_g_free0 (json);
#line 192 "../src/utils/Parser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 192 "../src/utils/Parser.vala"
		g_clear_error (&_inner_error0_);
#line 192 "../src/utils/Parser.vala"
		return NULL;
#line 2097 "Parser.c"
	}
#line 205 "../src/utils/Parser.vala"
	_tmp21_ = json;
#line 205 "../src/utils/Parser.vala"
	_tmp22_ = g_strconcat ("{", _tmp21_, NULL);
#line 205 "../src/utils/Parser.vala"
	_tmp23_ = _tmp22_;
#line 205 "../src/utils/Parser.vala"
	_tmp24_ = g_strconcat (_tmp23_, "}", NULL);
#line 205 "../src/utils/Parser.vala"
	_tmp25_ = _tmp24_;
#line 205 "../src/utils/Parser.vala"
	_g_free0 (_tmp23_);
#line 205 "../src/utils/Parser.vala"
	result = _tmp25_;
#line 205 "../src/utils/Parser.vala"
	_g_free0 (json);
#line 205 "../src/utils/Parser.vala"
	return result;
#line 2117 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_xml (const gchar* xml)
{
	gboolean _tmp0_ = FALSE;
	xmlDoc* _tmp3_;
	xmlDoc* result;
#line 210 "../src/utils/Parser.vala"
	if (xml == NULL) {
#line 210 "../src/utils/Parser.vala"
		_tmp0_ = TRUE;
#line 2130 "Parser.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 210 "../src/utils/Parser.vala"
		_tmp1_ = strlen (xml);
#line 210 "../src/utils/Parser.vala"
		_tmp2_ = _tmp1_;
#line 210 "../src/utils/Parser.vala"
		_tmp0_ = _tmp2_ == 0;
#line 2140 "Parser.c"
	}
#line 210 "../src/utils/Parser.vala"
	if (_tmp0_) {
#line 210 "../src/utils/Parser.vala"
		result = NULL;
#line 210 "../src/utils/Parser.vala"
		return result;
#line 2148 "Parser.c"
	}
#line 211 "../src/utils/Parser.vala"
	_tmp3_ = xmlParseDoc ((xmlChar*) xml);
#line 211 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 211 "../src/utils/Parser.vala"
	return result;
#line 2156 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_html (const gchar* html,
                                  const gchar* url)
{
	gboolean _tmp0_ = FALSE;
	xmlDoc* _tmp3_;
	xmlDoc* result;
#line 214 "../src/utils/Parser.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 216 "../src/utils/Parser.vala"
	if (html == NULL) {
#line 216 "../src/utils/Parser.vala"
		_tmp0_ = TRUE;
#line 2172 "Parser.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 216 "../src/utils/Parser.vala"
		_tmp1_ = strlen (html);
#line 216 "../src/utils/Parser.vala"
		_tmp2_ = _tmp1_;
#line 216 "../src/utils/Parser.vala"
		_tmp0_ = _tmp2_ == 0;
#line 2182 "Parser.c"
	}
#line 216 "../src/utils/Parser.vala"
	if (_tmp0_) {
#line 216 "../src/utils/Parser.vala"
		result = NULL;
#line 216 "../src/utils/Parser.vala"
		return result;
#line 2190 "Parser.c"
	}
#line 217 "../src/utils/Parser.vala"
	_tmp3_ = htmlReadDoc ((xmlChar*) html, url, NULL, (gint) (((HTML_PARSE_NOERROR | HTML_PARSE_NOWARNING) | HTML_PARSE_RECOVER) | HTML_PARSE_NONET));
#line 217 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 217 "../src/utils/Parser.vala"
	return result;
#line 2198 "Parser.c"
}

xmlNode*
game_hub_utils_parser_html_node (xmlNode* root,
                                 gchar** tags,
                                 gint tags_length1)
{
	xmlNode* obj = NULL;
	xmlNode* _tmp6_;
	xmlNode* result;
#line 222 "../src/utils/Parser.vala"
	if (root == NULL) {
#line 222 "../src/utils/Parser.vala"
		result = NULL;
#line 222 "../src/utils/Parser.vala"
		return result;
#line 2215 "Parser.c"
	}
#line 223 "../src/utils/Parser.vala"
	obj = root;
#line 2219 "Parser.c"
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
#line 225 "../src/utils/Parser.vala"
		tag_collection = tags;
#line 225 "../src/utils/Parser.vala"
		tag_collection_length1 = tags_length1;
#line 225 "../src/utils/Parser.vala"
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
#line 2231 "Parser.c"
			gchar* _tmp0_;
			gchar* tag = NULL;
#line 225 "../src/utils/Parser.vala"
			_tmp0_ = g_strdup (tag_collection[tag_it]);
#line 225 "../src/utils/Parser.vala"
			tag = _tmp0_;
#line 2238 "Parser.c"
			{
				xmlNode* _tmp1_;
				xmlNode* _tmp5_;
#line 227 "../src/utils/Parser.vala"
				_tmp1_ = obj;
#line 227 "../src/utils/Parser.vala"
				if (_tmp1_ != NULL) {
#line 2246 "Parser.c"
					xmlNode* _tmp2_;
					const gchar* _tmp3_;
					xmlNode* _tmp4_;
#line 229 "../src/utils/Parser.vala"
					_tmp2_ = obj;
#line 229 "../src/utils/Parser.vala"
					_tmp3_ = tag;
#line 229 "../src/utils/Parser.vala"
					_tmp4_ = game_hub_utils_parser_html_subnode (_tmp2_, _tmp3_);
#line 229 "../src/utils/Parser.vala"
					obj = _tmp4_;
#line 2258 "Parser.c"
				} else {
#line 231 "../src/utils/Parser.vala"
					obj = NULL;
#line 2262 "Parser.c"
				}
#line 233 "../src/utils/Parser.vala"
				_tmp5_ = obj;
#line 233 "../src/utils/Parser.vala"
				if (_tmp5_ == NULL) {
#line 233 "../src/utils/Parser.vala"
					_g_free0 (tag);
#line 233 "../src/utils/Parser.vala"
					break;
#line 2272 "Parser.c"
				}
#line 225 "../src/utils/Parser.vala"
				_g_free0 (tag);
#line 2276 "Parser.c"
			}
		}
	}
#line 236 "../src/utils/Parser.vala"
	_tmp6_ = obj;
#line 236 "../src/utils/Parser.vala"
	result = _tmp6_;
#line 236 "../src/utils/Parser.vala"
	return result;
#line 2286 "Parser.c"
}

xmlNode*
game_hub_utils_parser_xml_subnode (xmlNode* root,
                                   const gchar* name)
{
	xmlNode* result;
#line 239 "../src/utils/Parser.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 2296 "Parser.c"
	{
		xmlNode* iter = NULL;
		xmlNode* _tmp0_;
#line 241 "../src/utils/Parser.vala"
		_tmp0_ = root->children;
#line 241 "../src/utils/Parser.vala"
		iter = _tmp0_;
#line 2304 "Parser.c"
		{
			gboolean _tmp1_ = FALSE;
#line 241 "../src/utils/Parser.vala"
			_tmp1_ = TRUE;
#line 241 "../src/utils/Parser.vala"
			while (TRUE) {
#line 2311 "Parser.c"
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
#line 241 "../src/utils/Parser.vala"
				if (!_tmp1_) {
#line 2316 "Parser.c"
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
#line 241 "../src/utils/Parser.vala"
					_tmp2_ = iter;
#line 241 "../src/utils/Parser.vala"
					_tmp3_ = _tmp2_->next;
#line 241 "../src/utils/Parser.vala"
					iter = _tmp3_;
#line 2325 "Parser.c"
				}
#line 241 "../src/utils/Parser.vala"
				_tmp1_ = FALSE;
#line 241 "../src/utils/Parser.vala"
				_tmp4_ = iter;
#line 241 "../src/utils/Parser.vala"
				if (!(_tmp4_ != NULL)) {
#line 241 "../src/utils/Parser.vala"
					break;
#line 2335 "Parser.c"
				}
#line 243 "../src/utils/Parser.vala"
				_tmp5_ = iter;
#line 243 "../src/utils/Parser.vala"
				if (_tmp5_->type == XML_ELEMENT_NODE) {
#line 2341 "Parser.c"
					xmlNode* _tmp6_;
					const gchar* _tmp7_;
#line 245 "../src/utils/Parser.vala"
					_tmp6_ = iter;
#line 245 "../src/utils/Parser.vala"
					_tmp7_ = _tmp6_->name;
#line 245 "../src/utils/Parser.vala"
					if (g_strcmp0 (_tmp7_, name) == 0) {
#line 2350 "Parser.c"
						xmlNode* _tmp8_;
#line 247 "../src/utils/Parser.vala"
						_tmp8_ = iter;
#line 247 "../src/utils/Parser.vala"
						result = (xmlNode*) _tmp8_;
#line 247 "../src/utils/Parser.vala"
						return result;
#line 2358 "Parser.c"
					}
				}
			}
		}
	}
#line 251 "../src/utils/Parser.vala"
	result = NULL;
#line 251 "../src/utils/Parser.vala"
	return result;
#line 2368 "Parser.c"
}

xmlNode*
game_hub_utils_parser_html_subnode (xmlNode* root,
                                    const gchar* name)
{
	xmlNode* _tmp0_;
	xmlNode* result;
#line 254 "../src/utils/Parser.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 256 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_xml_subnode (root, name);
#line 256 "../src/utils/Parser.vala"
	result = (xmlNode*) _tmp0_;
#line 256 "../src/utils/Parser.vala"
	return result;
#line 2385 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_xml_file (const gchar* path,
                                      const gchar* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlDoc* result;
#line 259 "../src/utils/Parser.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 259 "../src/utils/Parser.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 261 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_load_file (path, file);
#line 261 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 261 "../src/utils/Parser.vala"
	_tmp2_ = game_hub_utils_parser_parse_xml (_tmp1_);
#line 261 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_;
#line 261 "../src/utils/Parser.vala"
	_g_free0 (_tmp1_);
#line 261 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 261 "../src/utils/Parser.vala"
	return result;
#line 2415 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_remote_xml_file (const gchar* url,
                                             const gchar* method,
                                             const gchar* auth,
                                             GeeHashMap* headers,
                                             GeeHashMap* data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlDoc* result;
#line 264 "../src/utils/Parser.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 264 "../src/utils/Parser.vala"
	g_return_val_if_fail (method != NULL, NULL);
#line 266 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_load_remote_file (url, method, auth, headers, data, NULL);
#line 266 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 266 "../src/utils/Parser.vala"
	_tmp2_ = game_hub_utils_parser_parse_xml (_tmp1_);
#line 266 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_;
#line 266 "../src/utils/Parser.vala"
	_g_free0 (_tmp1_);
#line 266 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 266 "../src/utils/Parser.vala"
	return result;
#line 2448 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_xml_file_async_data_free (gpointer _data)
{
	GameHubUtilsParserParseRemoteXmlFileAsyncData* _data_;
	_data_ = _data;
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	g_slice_free (GameHubUtilsParserParseRemoteXmlFileAsyncData, _data_);
#line 2468 "Parser.c"
}

void
game_hub_utils_parser_parse_remote_xml_file_async (const gchar* url,
                                                   const gchar* method,
                                                   const gchar* auth,
                                                   GeeHashMap* headers,
                                                   GeeHashMap* data,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteXmlFileAsyncData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (url != NULL);
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (method != NULL);
#line 25 "../src/utils/Parser.vala"
	_data_ = g_slice_new0 (GameHubUtilsParserParseRemoteXmlFileAsyncData);
#line 25 "../src/utils/Parser.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 25 "../src/utils/Parser.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_parser_parse_remote_xml_file_async_data_free);
#line 25 "../src/utils/Parser.vala"
	_tmp0_ = g_strdup (url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_data_->url = _tmp0_;
#line 25 "../src/utils/Parser.vala"
	_tmp1_ = g_strdup (method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_data_->method = _tmp1_;
#line 25 "../src/utils/Parser.vala"
	_tmp2_ = g_strdup (auth);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_data_->auth = _tmp2_;
#line 25 "../src/utils/Parser.vala"
	_tmp3_ = _g_object_ref0 (headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_data_->headers = _tmp3_;
#line 25 "../src/utils/Parser.vala"
	_tmp4_ = _g_object_ref0 (data);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	_data_->data = _tmp4_;
#line 25 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_xml_file_async_co (_data_);
#line 2528 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_remote_xml_file_finish (GAsyncResult* _res_)
{
	xmlDoc* result;
	GameHubUtilsParserParseRemoteXmlFileAsyncData* _data_;
#line 25 "../src/utils/Parser.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 25 "../src/utils/Parser.vala"
	result = _data_->result;
#line 25 "../src/utils/Parser.vala"
	_data_->result = NULL;
#line 25 "../src/utils/Parser.vala"
	return result;
#line 2544 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_xml_file_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteXmlFileAsyncData* _data_;
#line 271 "../src/utils/Parser.vala"
	_data_ = _user_data_;
#line 271 "../src/utils/Parser.vala"
	_data_->_source_object_ = source_object;
#line 271 "../src/utils/Parser.vala"
	_data_->_res_ = _res_;
#line 271 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_xml_file_async_co (_data_);
#line 2561 "Parser.c"
}

static gboolean
game_hub_utils_parser_parse_remote_xml_file_async_co (GameHubUtilsParserParseRemoteXmlFileAsyncData* _data_)
{
#line 269 "../src/utils/Parser.vala"
	switch (_data_->_state_) {
#line 269 "../src/utils/Parser.vala"
		case 0:
#line 2571 "Parser.c"
		goto _state_0;
#line 269 "../src/utils/Parser.vala"
		case 1:
#line 2575 "Parser.c"
		goto _state_1;
		default:
#line 269 "../src/utils/Parser.vala"
		g_assert_not_reached ();
#line 2580 "Parser.c"
	}
	_state_0:
#line 271 "../src/utils/Parser.vala"
	_data_->_state_ = 1;
#line 271 "../src/utils/Parser.vala"
	game_hub_utils_parser_load_remote_file_async (_data_->url, _data_->method, _data_->auth, _data_->headers, _data_->data, game_hub_utils_parser_parse_remote_xml_file_async_ready, _data_);
#line 271 "../src/utils/Parser.vala"
	return FALSE;
#line 2589 "Parser.c"
	_state_1:
#line 271 "../src/utils/Parser.vala"
	_data_->_tmp0_ = game_hub_utils_parser_load_remote_file_finish (_data_->_res_, NULL);
#line 271 "../src/utils/Parser.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 271 "../src/utils/Parser.vala"
	_data_->_tmp2_ = game_hub_utils_parser_parse_xml (_data_->_tmp1_);
#line 271 "../src/utils/Parser.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 271 "../src/utils/Parser.vala"
	_g_free0 (_data_->_tmp1_);
#line 271 "../src/utils/Parser.vala"
	_data_->result = _data_->_tmp3_;
#line 271 "../src/utils/Parser.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 271 "../src/utils/Parser.vala"
	if (_data_->_state_ != 0) {
#line 271 "../src/utils/Parser.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 271 "../src/utils/Parser.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2611 "Parser.c"
		}
	}
#line 271 "../src/utils/Parser.vala"
	g_object_unref (_data_->_async_result);
#line 271 "../src/utils/Parser.vala"
	return FALSE;
#line 2618 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_html_file (const gchar* path,
                                       const gchar* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	xmlDoc* _tmp4_;
	xmlDoc* _tmp5_;
	xmlDoc* result;
#line 274 "../src/utils/Parser.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 274 "../src/utils/Parser.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 276 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_load_file (path, file);
#line 276 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 276 "../src/utils/Parser.vala"
	_tmp2_ = g_strconcat ("file://", path, NULL);
#line 276 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_;
#line 276 "../src/utils/Parser.vala"
	_tmp4_ = game_hub_utils_parser_parse_html (_tmp1_, _tmp3_);
#line 276 "../src/utils/Parser.vala"
	_tmp5_ = _tmp4_;
#line 276 "../src/utils/Parser.vala"
	_g_free0 (_tmp3_);
#line 276 "../src/utils/Parser.vala"
	_g_free0 (_tmp1_);
#line 276 "../src/utils/Parser.vala"
	result = _tmp5_;
#line 276 "../src/utils/Parser.vala"
	return result;
#line 2656 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_remote_html_file (const gchar* url,
                                              const gchar* method,
                                              const gchar* auth,
                                              GeeHashMap* headers,
                                              GeeHashMap* data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp3_;
	xmlDoc* result;
#line 279 "../src/utils/Parser.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 279 "../src/utils/Parser.vala"
	g_return_val_if_fail (method != NULL, NULL);
#line 281 "../src/utils/Parser.vala"
	_tmp0_ = game_hub_utils_parser_load_remote_file (url, method, auth, headers, data, NULL);
#line 281 "../src/utils/Parser.vala"
	_tmp1_ = _tmp0_;
#line 281 "../src/utils/Parser.vala"
	_tmp2_ = game_hub_utils_parser_parse_html (_tmp1_, url);
#line 281 "../src/utils/Parser.vala"
	_tmp3_ = _tmp2_;
#line 281 "../src/utils/Parser.vala"
	_g_free0 (_tmp1_);
#line 281 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 281 "../src/utils/Parser.vala"
	return result;
#line 2689 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_html_file_async_data_free (gpointer _data)
{
	GameHubUtilsParserParseRemoteHtmlFileAsyncData* _data_;
	_data_ = _data;
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	g_slice_free (GameHubUtilsParserParseRemoteHtmlFileAsyncData, _data_);
#line 2709 "Parser.c"
}

void
game_hub_utils_parser_parse_remote_html_file_async (const gchar* url,
                                                    const gchar* method,
                                                    const gchar* auth,
                                                    GeeHashMap* headers,
                                                    GeeHashMap* data,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteHtmlFileAsyncData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (url != NULL);
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (method != NULL);
#line 25 "../src/utils/Parser.vala"
	_data_ = g_slice_new0 (GameHubUtilsParserParseRemoteHtmlFileAsyncData);
#line 25 "../src/utils/Parser.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 25 "../src/utils/Parser.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_utils_parser_parse_remote_html_file_async_data_free);
#line 25 "../src/utils/Parser.vala"
	_tmp0_ = g_strdup (url);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->url);
#line 25 "../src/utils/Parser.vala"
	_data_->url = _tmp0_;
#line 25 "../src/utils/Parser.vala"
	_tmp1_ = g_strdup (method);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->method);
#line 25 "../src/utils/Parser.vala"
	_data_->method = _tmp1_;
#line 25 "../src/utils/Parser.vala"
	_tmp2_ = g_strdup (auth);
#line 25 "../src/utils/Parser.vala"
	_g_free0 (_data_->auth);
#line 25 "../src/utils/Parser.vala"
	_data_->auth = _tmp2_;
#line 25 "../src/utils/Parser.vala"
	_tmp3_ = _g_object_ref0 (headers);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->headers);
#line 25 "../src/utils/Parser.vala"
	_data_->headers = _tmp3_;
#line 25 "../src/utils/Parser.vala"
	_tmp4_ = _g_object_ref0 (data);
#line 25 "../src/utils/Parser.vala"
	_g_object_unref0 (_data_->data);
#line 25 "../src/utils/Parser.vala"
	_data_->data = _tmp4_;
#line 25 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_html_file_async_co (_data_);
#line 2769 "Parser.c"
}

xmlDoc*
game_hub_utils_parser_parse_remote_html_file_finish (GAsyncResult* _res_)
{
	xmlDoc* result;
	GameHubUtilsParserParseRemoteHtmlFileAsyncData* _data_;
#line 25 "../src/utils/Parser.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 25 "../src/utils/Parser.vala"
	result = _data_->result;
#line 25 "../src/utils/Parser.vala"
	_data_->result = NULL;
#line 25 "../src/utils/Parser.vala"
	return result;
#line 2785 "Parser.c"
}

static void
game_hub_utils_parser_parse_remote_html_file_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GameHubUtilsParserParseRemoteHtmlFileAsyncData* _data_;
#line 286 "../src/utils/Parser.vala"
	_data_ = _user_data_;
#line 286 "../src/utils/Parser.vala"
	_data_->_source_object_ = source_object;
#line 286 "../src/utils/Parser.vala"
	_data_->_res_ = _res_;
#line 286 "../src/utils/Parser.vala"
	game_hub_utils_parser_parse_remote_html_file_async_co (_data_);
#line 2802 "Parser.c"
}

static gboolean
game_hub_utils_parser_parse_remote_html_file_async_co (GameHubUtilsParserParseRemoteHtmlFileAsyncData* _data_)
{
#line 284 "../src/utils/Parser.vala"
	switch (_data_->_state_) {
#line 284 "../src/utils/Parser.vala"
		case 0:
#line 2812 "Parser.c"
		goto _state_0;
#line 284 "../src/utils/Parser.vala"
		case 1:
#line 2816 "Parser.c"
		goto _state_1;
		default:
#line 284 "../src/utils/Parser.vala"
		g_assert_not_reached ();
#line 2821 "Parser.c"
	}
	_state_0:
#line 286 "../src/utils/Parser.vala"
	_data_->_state_ = 1;
#line 286 "../src/utils/Parser.vala"
	game_hub_utils_parser_load_remote_file_async (_data_->url, _data_->method, _data_->auth, _data_->headers, _data_->data, game_hub_utils_parser_parse_remote_html_file_async_ready, _data_);
#line 286 "../src/utils/Parser.vala"
	return FALSE;
#line 2830 "Parser.c"
	_state_1:
#line 286 "../src/utils/Parser.vala"
	_data_->_tmp0_ = game_hub_utils_parser_load_remote_file_finish (_data_->_res_, NULL);
#line 286 "../src/utils/Parser.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 286 "../src/utils/Parser.vala"
	_data_->_tmp2_ = game_hub_utils_parser_parse_html (_data_->_tmp1_, _data_->url);
#line 286 "../src/utils/Parser.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 286 "../src/utils/Parser.vala"
	_g_free0 (_data_->_tmp1_);
#line 286 "../src/utils/Parser.vala"
	_data_->result = _data_->_tmp3_;
#line 286 "../src/utils/Parser.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 286 "../src/utils/Parser.vala"
	if (_data_->_state_ != 0) {
#line 286 "../src/utils/Parser.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 286 "../src/utils/Parser.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2852 "Parser.c"
		}
	}
#line 286 "../src/utils/Parser.vala"
	g_object_unref (_data_->_async_result);
#line 286 "../src/utils/Parser.vala"
	return FALSE;
#line 2859 "Parser.c"
}

gchar*
game_hub_utils_parser_xml_node_to_string (xmlNode* node)
{
	xmlBuffer* buf = NULL;
	xmlBuffer* _tmp0_;
	xmlDoc* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
#line 291 "../src/utils/Parser.vala"
	_tmp0_ = xmlBufferCreate ();
#line 291 "../src/utils/Parser.vala"
	buf = _tmp0_;
#line 292 "../src/utils/Parser.vala"
	_tmp1_ = node->doc;
#line 292 "../src/utils/Parser.vala"
	xmlNodeDump (buf, _tmp1_, node, 0, 1);
#line 293 "../src/utils/Parser.vala"
	_tmp2_ = xmlBufferContent (buf);
#line 293 "../src/utils/Parser.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 293 "../src/utils/Parser.vala"
	result = _tmp3_;
#line 293 "../src/utils/Parser.vala"
	_xmlBufferFree0 (buf);
#line 293 "../src/utils/Parser.vala"
	return result;
#line 2889 "Parser.c"
}

JsonNode*
game_hub_utils_parser_json (GameHubUtilsParserJsonBulderDelegate d,
                            gpointer d_target)
{
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp0_;
	JsonBuilder* _tmp1_;
	JsonBuilder* _tmp3_;
	JsonBuilder* _tmp4_;
	JsonNode* _tmp5_;
	JsonNode* result;
#line 299 "../src/utils/Parser.vala"
	_tmp0_ = json_builder_new ();
#line 299 "../src/utils/Parser.vala"
	builder = _tmp0_;
#line 300 "../src/utils/Parser.vala"
	_tmp1_ = builder;
#line 300 "../src/utils/Parser.vala"
	json_builder_begin_object (_tmp1_);
#line 301 "../src/utils/Parser.vala"
	if (d != NULL) {
#line 2913 "Parser.c"
		JsonBuilder* _tmp2_;
#line 303 "../src/utils/Parser.vala"
		_tmp2_ = builder;
#line 303 "../src/utils/Parser.vala"
		d (_tmp2_, d_target);
#line 2919 "Parser.c"
	}
#line 305 "../src/utils/Parser.vala"
	_tmp3_ = builder;
#line 305 "../src/utils/Parser.vala"
	json_builder_end_object (_tmp3_);
#line 306 "../src/utils/Parser.vala"
	_tmp4_ = builder;
#line 306 "../src/utils/Parser.vala"
	_tmp5_ = json_builder_get_root (_tmp4_);
#line 306 "../src/utils/Parser.vala"
	result = _tmp5_;
#line 306 "../src/utils/Parser.vala"
	_g_object_unref0 (builder);
#line 306 "../src/utils/Parser.vala"
	return result;
#line 2935 "Parser.c"
}

GameHubUtilsParser*
game_hub_utils_parser_construct (GType object_type)
{
	GameHubUtilsParser* self = NULL;
#line 25 "../src/utils/Parser.vala"
	self = (GameHubUtilsParser*) g_type_create_instance (object_type);
#line 25 "../src/utils/Parser.vala"
	return self;
#line 2946 "Parser.c"
}

GameHubUtilsParser*
game_hub_utils_parser_new (void)
{
#line 25 "../src/utils/Parser.vala"
	return game_hub_utils_parser_construct (GAME_HUB_UTILS_TYPE_PARSER);
#line 2954 "Parser.c"
}

static void
game_hub_utils_value_parser_init (GValue* value)
{
#line 25 "../src/utils/Parser.vala"
	value->data[0].v_pointer = NULL;
#line 2962 "Parser.c"
}

static void
game_hub_utils_value_parser_free_value (GValue* value)
{
#line 25 "../src/utils/Parser.vala"
	if (value->data[0].v_pointer) {
#line 25 "../src/utils/Parser.vala"
		game_hub_utils_parser_unref (value->data[0].v_pointer);
#line 2972 "Parser.c"
	}
}

static void
game_hub_utils_value_parser_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 25 "../src/utils/Parser.vala"
	if (src_value->data[0].v_pointer) {
#line 25 "../src/utils/Parser.vala"
		dest_value->data[0].v_pointer = game_hub_utils_parser_ref (src_value->data[0].v_pointer);
#line 2984 "Parser.c"
	} else {
#line 25 "../src/utils/Parser.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2988 "Parser.c"
	}
}

static gpointer
game_hub_utils_value_parser_peek_pointer (const GValue* value)
{
#line 25 "../src/utils/Parser.vala"
	return value->data[0].v_pointer;
#line 2997 "Parser.c"
}

static gchar*
game_hub_utils_value_parser_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 25 "../src/utils/Parser.vala"
	if (collect_values[0].v_pointer) {
#line 3008 "Parser.c"
		GameHubUtilsParser * object;
		object = collect_values[0].v_pointer;
#line 25 "../src/utils/Parser.vala"
		if (object->parent_instance.g_class == NULL) {
#line 25 "../src/utils/Parser.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3015 "Parser.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 25 "../src/utils/Parser.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3019 "Parser.c"
		}
#line 25 "../src/utils/Parser.vala"
		value->data[0].v_pointer = game_hub_utils_parser_ref (object);
#line 3023 "Parser.c"
	} else {
#line 25 "../src/utils/Parser.vala"
		value->data[0].v_pointer = NULL;
#line 3027 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	return NULL;
#line 3031 "Parser.c"
}

static gchar*
game_hub_utils_value_parser_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GameHubUtilsParser ** object_p;
	object_p = collect_values[0].v_pointer;
#line 25 "../src/utils/Parser.vala"
	if (!object_p) {
#line 25 "../src/utils/Parser.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3046 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	if (!value->data[0].v_pointer) {
#line 25 "../src/utils/Parser.vala"
		*object_p = NULL;
#line 3052 "Parser.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 25 "../src/utils/Parser.vala"
		*object_p = value->data[0].v_pointer;
#line 3056 "Parser.c"
	} else {
#line 25 "../src/utils/Parser.vala"
		*object_p = game_hub_utils_parser_ref (value->data[0].v_pointer);
#line 3060 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	return NULL;
#line 3064 "Parser.c"
}

GParamSpec*
game_hub_utils_param_spec_parser (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GameHubUtilsParamSpecParser* spec;
#line 25 "../src/utils/Parser.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GAME_HUB_UTILS_TYPE_PARSER), NULL);
#line 25 "../src/utils/Parser.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 25 "../src/utils/Parser.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 25 "../src/utils/Parser.vala"
	return G_PARAM_SPEC (spec);
#line 3083 "Parser.c"
}

gpointer
game_hub_utils_value_get_parser (const GValue* value)
{
#line 25 "../src/utils/Parser.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_PARSER), NULL);
#line 25 "../src/utils/Parser.vala"
	return value->data[0].v_pointer;
#line 3093 "Parser.c"
}

void
game_hub_utils_value_set_parser (GValue* value,
                                 gpointer v_object)
{
	GameHubUtilsParser * old;
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_PARSER));
#line 25 "../src/utils/Parser.vala"
	old = value->data[0].v_pointer;
#line 25 "../src/utils/Parser.vala"
	if (v_object) {
#line 25 "../src/utils/Parser.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_PARSER));
#line 25 "../src/utils/Parser.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "../src/utils/Parser.vala"
		value->data[0].v_pointer = v_object;
#line 25 "../src/utils/Parser.vala"
		game_hub_utils_parser_ref (value->data[0].v_pointer);
#line 3115 "Parser.c"
	} else {
#line 25 "../src/utils/Parser.vala"
		value->data[0].v_pointer = NULL;
#line 3119 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	if (old) {
#line 25 "../src/utils/Parser.vala"
		game_hub_utils_parser_unref (old);
#line 3125 "Parser.c"
	}
}

void
game_hub_utils_value_take_parser (GValue* value,
                                  gpointer v_object)
{
	GameHubUtilsParser * old;
#line 25 "../src/utils/Parser.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAME_HUB_UTILS_TYPE_PARSER));
#line 25 "../src/utils/Parser.vala"
	old = value->data[0].v_pointer;
#line 25 "../src/utils/Parser.vala"
	if (v_object) {
#line 25 "../src/utils/Parser.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAME_HUB_UTILS_TYPE_PARSER));
#line 25 "../src/utils/Parser.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "../src/utils/Parser.vala"
		value->data[0].v_pointer = v_object;
#line 3146 "Parser.c"
	} else {
#line 25 "../src/utils/Parser.vala"
		value->data[0].v_pointer = NULL;
#line 3150 "Parser.c"
	}
#line 25 "../src/utils/Parser.vala"
	if (old) {
#line 25 "../src/utils/Parser.vala"
		game_hub_utils_parser_unref (old);
#line 3156 "Parser.c"
	}
}

static void
game_hub_utils_parser_class_init (GameHubUtilsParserClass * klass,
                                  gpointer klass_data)
{
#line 25 "../src/utils/Parser.vala"
	game_hub_utils_parser_parent_class = g_type_class_peek_parent (klass);
#line 25 "../src/utils/Parser.vala"
	((GameHubUtilsParserClass *) klass)->finalize = game_hub_utils_parser_finalize;
#line 3168 "Parser.c"
}

static void
game_hub_utils_parser_instance_init (GameHubUtilsParser * self,
                                     gpointer klass)
{
#line 25 "../src/utils/Parser.vala"
	self->ref_count = 1;
#line 3177 "Parser.c"
}

static void
game_hub_utils_parser_finalize (GameHubUtilsParser * obj)
{
	GameHubUtilsParser * self;
#line 25 "../src/utils/Parser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_TYPE_PARSER, GameHubUtilsParser);
#line 25 "../src/utils/Parser.vala"
	g_signal_handlers_destroy (self);
#line 3188 "Parser.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { game_hub_utils_value_parser_init, game_hub_utils_value_parser_free_value, game_hub_utils_value_parser_copy_value, game_hub_utils_value_parser_peek_pointer, "p", game_hub_utils_value_parser_collect_value, "p", game_hub_utils_value_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsParser), 0, (GInstanceInitFunc) game_hub_utils_parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType game_hub_utils_parser_type_id;
	game_hub_utils_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GameHubUtilsParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return game_hub_utils_parser_type_id;
}

GType
game_hub_utils_parser_get_type (void)
{
	static volatile gsize game_hub_utils_parser_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_parser_type_id__once)) {
		GType game_hub_utils_parser_type_id;
		game_hub_utils_parser_type_id = game_hub_utils_parser_get_type_once ();
		g_once_init_leave (&game_hub_utils_parser_type_id__once, game_hub_utils_parser_type_id);
	}
	return game_hub_utils_parser_type_id__once;
}

gpointer
game_hub_utils_parser_ref (gpointer instance)
{
	GameHubUtilsParser * self;
	self = instance;
#line 25 "../src/utils/Parser.vala"
	g_atomic_int_inc (&self->ref_count);
#line 25 "../src/utils/Parser.vala"
	return instance;
#line 3223 "Parser.c"
}

void
game_hub_utils_parser_unref (gpointer instance)
{
	GameHubUtilsParser * self;
	self = instance;
#line 25 "../src/utils/Parser.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 25 "../src/utils/Parser.vala"
		GAME_HUB_UTILS_PARSER_GET_CLASS (self)->finalize (self);
#line 25 "../src/utils/Parser.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3237 "Parser.c"
	}
}

