/* Gamepad.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Gamepad.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>
#include <X11/extensions/XTest.h>

#define GAME_HUB_UTILS_GAMEPAD_KEY_EVENT_EMIT_INTERVAL 50000
#define GAME_HUB_UTILS_GAMEPAD_KEY_UP_EMIT_TIMEOUT 50000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON (game_hub_utils_gamepad_button_get_type ())
#define GAME_HUB_UTILS_GAMEPAD_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, GameHubUtilsGamepadButton))
#define GAME_HUB_UTILS_GAMEPAD_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, GameHubUtilsGamepadButtonClass))
#define GAME_HUB_UTILS_GAMEPAD_IS_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON))
#define GAME_HUB_UTILS_GAMEPAD_IS_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON))
#define GAME_HUB_UTILS_GAMEPAD_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, GameHubUtilsGamepadButtonClass))

typedef struct _GameHubUtilsGamepadButton GameHubUtilsGamepadButton;
typedef struct _GameHubUtilsGamepadButtonClass GameHubUtilsGamepadButtonClass;

#define GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS (game_hub_utils_gamepad_axis_get_type ())
#define GAME_HUB_UTILS_GAMEPAD_AXIS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, GameHubUtilsGamepadAxis))
#define GAME_HUB_UTILS_GAMEPAD_AXIS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, GameHubUtilsGamepadAxisClass))
#define GAME_HUB_UTILS_GAMEPAD_IS_AXIS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS))
#define GAME_HUB_UTILS_GAMEPAD_IS_AXIS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS))
#define GAME_HUB_UTILS_GAMEPAD_AXIS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, GameHubUtilsGamepadAxisClass))

typedef struct _GameHubUtilsGamepadAxis GameHubUtilsGamepadAxis;
typedef struct _GameHubUtilsGamepadAxisClass GameHubUtilsGamepadAxisClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GameHubUtilsGamepadButtonPrivate GameHubUtilsGamepadButtonPrivate;
enum  {
	GAME_HUB_UTILS_GAMEPAD_BUTTON_0_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_BUTTON_CODE_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_BUTTON_NAME_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_BUTTON_LONG_NAME_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_BUTTON_NUM_PROPERTIES
};
static GParamSpec* game_hub_utils_gamepad_button_properties[GAME_HUB_UTILS_GAMEPAD_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GameHubUtilsGamepadAxisPrivate GameHubUtilsGamepadAxisPrivate;
enum  {
	GAME_HUB_UTILS_GAMEPAD_AXIS_0_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_CODE_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_NAME_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_LONG_NAME_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_NEGATIVE_KEY_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_POSITIVE_KEY_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_KEY_THRESHOLD_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_VALUE_PROPERTY,
	GAME_HUB_UTILS_GAMEPAD_AXIS_NUM_PROPERTIES
};
static GParamSpec* game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _GameHubUtilsGamepadButton {
	GObject parent_instance;
	GameHubUtilsGamepadButtonPrivate * priv;
	guint* keys;
	gint keys_length1;
};

struct _GameHubUtilsGamepadButtonClass {
	GObjectClass parent_class;
};

struct _GameHubUtilsGamepadButtonPrivate {
	guint16 _code;
	gchar* _name;
	gchar* _long_name;
	gboolean pressed;
};

struct _GameHubUtilsGamepadAxis {
	GObject parent_instance;
	GameHubUtilsGamepadAxisPrivate * priv;
};

struct _GameHubUtilsGamepadAxisClass {
	GObjectClass parent_class;
};

struct _GameHubUtilsGamepadAxisPrivate {
	guint16 _code;
	gchar* _name;
	gchar* _long_name;
	guint _negative_key;
	guint _positive_key;
	gdouble _key_threshold;
	gdouble _value;
	gint _value_sign;
	gint _pressed_sign;
	gboolean _sign_changed;
	GTimer* timer;
};

VALA_EXTERN GeeHashMap* game_hub_utils_gamepad_Buttons;
GeeHashMap* game_hub_utils_gamepad_Buttons = NULL;
VALA_EXTERN GeeHashMap* game_hub_utils_gamepad_Axes;
GeeHashMap* game_hub_utils_gamepad_Axes = NULL;
VALA_EXTERN gboolean game_hub_utils_gamepad_ButtonPressed;
gboolean game_hub_utils_gamepad_ButtonPressed = FALSE;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_A;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_A = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_B;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_B = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_C;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_C = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_X;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_X = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_Y;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_Y = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_Z;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_Z = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BUMPER_LEFT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BUMPER_LEFT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BUMPER_RIGHT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BUMPER_RIGHT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_TRIGGER_LEFT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_TRIGGER_LEFT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_TRIGGER_RIGHT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_TRIGGER_RIGHT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_STICK_LEFT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_STICK_LEFT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_STICK_RIGHT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_STICK_RIGHT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_SELECT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_SELECT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_START;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_START = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_GUIDE;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_BTN_GUIDE = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_UP;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_UP = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_DOWN;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_DOWN = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_LEFT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_LEFT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_RIGHT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_DPAD_RIGHT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_PAD_TAP_LEFT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_PAD_TAP_LEFT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_PAD_TAP_RIGHT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_PAD_TAP_RIGHT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_GRIP_LEFT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_GRIP_LEFT = NULL;
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_GRIP_RIGHT;
GameHubUtilsGamepadButton* game_hub_utils_gamepad_SC_GRIP_RIGHT = NULL;
VALA_EXTERN GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_LS_X;
GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_LS_X = NULL;
VALA_EXTERN GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_LS_Y;
GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_LS_Y = NULL;
VALA_EXTERN GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_RS_X;
GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_RS_X = NULL;
VALA_EXTERN GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_RS_Y;
GameHubUtilsGamepadAxis* game_hub_utils_gamepad_AXIS_RS_Y = NULL;
static gint GameHubUtilsGamepadButton_private_offset;
static gpointer game_hub_utils_gamepad_button_parent_class = NULL;
static gint GameHubUtilsGamepadAxis_private_offset;
static gpointer game_hub_utils_gamepad_axis_parent_class = NULL;

VALA_EXTERN GType game_hub_utils_gamepad_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsGamepadButton, g_object_unref)
VALA_EXTERN GType game_hub_utils_gamepad_axis_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsGamepadAxis, g_object_unref)
VALA_EXTERN void game_hub_utils_gamepad_init (void);
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_b (guint16 code,
                                                     const gchar* name,
                                                     const gchar* long_name,
                                                     guint* keys,
                                                     gint keys_length1);
VALA_EXTERN GameHubUtilsGamepadAxis* game_hub_utils_gamepad_a (guint16 code,
                                                   const gchar* name,
                                                   const gchar* long_name,
                                                   guint negative_key,
                                                   guint positive_key,
                                                   gdouble key_threshold);
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_button_new (guint16 code,
                                                              const gchar* name,
                                                              const gchar* long_name,
                                                              guint* keys,
                                                              gint keys_length1);
VALA_EXTERN GameHubUtilsGamepadButton* game_hub_utils_gamepad_button_construct (GType object_type,
                                                                    guint16 code,
                                                                    const gchar* name,
                                                                    const gchar* long_name,
                                                                    guint* keys,
                                                                    gint keys_length1);
VALA_EXTERN GameHubUtilsGamepadAxis* game_hub_utils_gamepad_axis_new (guint16 code,
                                                          const gchar* name,
                                                          const gchar* long_name,
                                                          guint negative_key,
                                                          guint positive_key,
                                                          gdouble key_threshold);
VALA_EXTERN GameHubUtilsGamepadAxis* game_hub_utils_gamepad_axis_construct (GType object_type,
                                                                guint16 code,
                                                                const gchar* name,
                                                                const gchar* long_name,
                                                                guint negative_key,
                                                                guint positive_key,
                                                                gdouble key_threshold);
static guint* _vala_array_dup65 (guint* self,
                          gssize length);
VALA_EXTERN void game_hub_utils_gamepad_button_emit_key_event (GameHubUtilsGamepadButton* self,
                                                   gboolean press);
VALA_EXTERN void game_hub_utils_gamepad_emit_key_event (guint key_code,
                                            gboolean press);
VALA_EXTERN void game_hub_utils_gamepad_button_reset (GameHubUtilsGamepadButton* self);
VALA_EXTERN guint16 game_hub_utils_gamepad_button_get_code (GameHubUtilsGamepadButton* self);
static void game_hub_utils_gamepad_button_set_code (GameHubUtilsGamepadButton* self,
                                             guint16 value);
VALA_EXTERN const gchar* game_hub_utils_gamepad_button_get_name (GameHubUtilsGamepadButton* self);
static void game_hub_utils_gamepad_button_set_name (GameHubUtilsGamepadButton* self,
                                             const gchar* value);
VALA_EXTERN const gchar* game_hub_utils_gamepad_button_get_long_name (GameHubUtilsGamepadButton* self);
static void game_hub_utils_gamepad_button_set_long_name (GameHubUtilsGamepadButton* self,
                                                  const gchar* value);
static void game_hub_utils_gamepad_button_finalize (GObject * obj);
static GType game_hub_utils_gamepad_button_get_type_once (void);
static void _vala_game_hub_utils_gamepad_button_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_game_hub_utils_gamepad_button_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
VALA_EXTERN void game_hub_utils_gamepad_axis_emit_key_event (GameHubUtilsGamepadAxis* self);
VALA_EXTERN guint game_hub_utils_gamepad_axis_get_negative_key (GameHubUtilsGamepadAxis* self);
VALA_EXTERN guint game_hub_utils_gamepad_axis_get_positive_key (GameHubUtilsGamepadAxis* self);
VALA_EXTERN void game_hub_utils_gamepad_axis_reset (GameHubUtilsGamepadAxis* self);
VALA_EXTERN void game_hub_utils_gamepad_axis_set_value (GameHubUtilsGamepadAxis* self,
                                            gdouble value);
VALA_EXTERN guint16 game_hub_utils_gamepad_axis_get_code (GameHubUtilsGamepadAxis* self);
static void game_hub_utils_gamepad_axis_set_code (GameHubUtilsGamepadAxis* self,
                                           guint16 value);
VALA_EXTERN const gchar* game_hub_utils_gamepad_axis_get_name (GameHubUtilsGamepadAxis* self);
static void game_hub_utils_gamepad_axis_set_name (GameHubUtilsGamepadAxis* self,
                                           const gchar* value);
VALA_EXTERN const gchar* game_hub_utils_gamepad_axis_get_long_name (GameHubUtilsGamepadAxis* self);
static void game_hub_utils_gamepad_axis_set_long_name (GameHubUtilsGamepadAxis* self,
                                                const gchar* value);
static void game_hub_utils_gamepad_axis_set_negative_key (GameHubUtilsGamepadAxis* self,
                                                   guint value);
static void game_hub_utils_gamepad_axis_set_positive_key (GameHubUtilsGamepadAxis* self,
                                                   guint value);
VALA_EXTERN gdouble game_hub_utils_gamepad_axis_get_key_threshold (GameHubUtilsGamepadAxis* self);
static void game_hub_utils_gamepad_axis_set_key_threshold (GameHubUtilsGamepadAxis* self,
                                                    gdouble value);
VALA_EXTERN gdouble game_hub_utils_gamepad_axis_get_value (GameHubUtilsGamepadAxis* self);
static void game_hub_utils_gamepad_axis_finalize (GObject * obj);
static GType game_hub_utils_gamepad_axis_get_type_once (void);
static void _vala_game_hub_utils_gamepad_axis_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_game_hub_utils_gamepad_axis_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
VALA_EXTERN void game_hub_utils_gamepad_reset (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
game_hub_utils_gamepad_init (void)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	guint* _tmp2_;
	guint* _tmp3_;
	gint _tmp3__length1;
	GameHubUtilsGamepadButton* _tmp4_;
	guint* _tmp5_;
	guint* _tmp6_;
	gint _tmp6__length1;
	GameHubUtilsGamepadButton* _tmp7_;
	guint* _tmp8_;
	guint* _tmp9_;
	gint _tmp9__length1;
	GameHubUtilsGamepadButton* _tmp10_;
	guint* _tmp11_;
	guint* _tmp12_;
	gint _tmp12__length1;
	GameHubUtilsGamepadButton* _tmp13_;
	guint* _tmp14_;
	guint* _tmp15_;
	gint _tmp15__length1;
	GameHubUtilsGamepadButton* _tmp16_;
	guint* _tmp17_;
	guint* _tmp18_;
	gint _tmp18__length1;
	GameHubUtilsGamepadButton* _tmp19_;
	guint* _tmp20_;
	guint* _tmp21_;
	gint _tmp21__length1;
	GameHubUtilsGamepadButton* _tmp22_;
	guint* _tmp23_;
	guint* _tmp24_;
	gint _tmp24__length1;
	GameHubUtilsGamepadButton* _tmp25_;
	guint* _tmp26_;
	guint* _tmp27_;
	gint _tmp27__length1;
	GameHubUtilsGamepadButton* _tmp28_;
	guint* _tmp29_;
	guint* _tmp30_;
	gint _tmp30__length1;
	GameHubUtilsGamepadButton* _tmp31_;
	guint* _tmp32_;
	guint* _tmp33_;
	gint _tmp33__length1;
	GameHubUtilsGamepadButton* _tmp34_;
	guint* _tmp35_;
	guint* _tmp36_;
	gint _tmp36__length1;
	GameHubUtilsGamepadButton* _tmp37_;
	guint* _tmp38_;
	guint* _tmp39_;
	gint _tmp39__length1;
	GameHubUtilsGamepadButton* _tmp40_;
	guint* _tmp41_;
	guint* _tmp42_;
	gint _tmp42__length1;
	GameHubUtilsGamepadButton* _tmp43_;
	guint* _tmp44_;
	guint* _tmp45_;
	gint _tmp45__length1;
	GameHubUtilsGamepadButton* _tmp46_;
	guint* _tmp47_;
	guint* _tmp48_;
	gint _tmp48__length1;
	GameHubUtilsGamepadButton* _tmp49_;
	guint* _tmp50_;
	guint* _tmp51_;
	gint _tmp51__length1;
	GameHubUtilsGamepadButton* _tmp52_;
	guint* _tmp53_;
	guint* _tmp54_;
	gint _tmp54__length1;
	GameHubUtilsGamepadButton* _tmp55_;
	guint* _tmp56_;
	guint* _tmp57_;
	gint _tmp57__length1;
	GameHubUtilsGamepadButton* _tmp58_;
	guint* _tmp59_;
	guint* _tmp60_;
	gint _tmp60__length1;
	GameHubUtilsGamepadButton* _tmp61_;
	guint* _tmp62_;
	guint* _tmp63_;
	gint _tmp63__length1;
	GameHubUtilsGamepadButton* _tmp64_;
	guint* _tmp65_;
	guint* _tmp66_;
	gint _tmp66__length1;
	GameHubUtilsGamepadButton* _tmp67_;
	guint* _tmp68_;
	guint* _tmp69_;
	gint _tmp69__length1;
	GameHubUtilsGamepadButton* _tmp70_;
	GameHubUtilsGamepadAxis* _tmp71_;
	GameHubUtilsGamepadAxis* _tmp72_;
	GameHubUtilsGamepadAxis* _tmp73_;
	GameHubUtilsGamepadAxis* _tmp74_;
#line 69 "../src/utils/Gamepad.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 69 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_Buttons);
#line 69 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_Buttons = _tmp0_;
#line 70 "../src/utils/Gamepad.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 70 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_Axes);
#line 70 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_Axes = _tmp1_;
#line 72 "../src/utils/Gamepad.vala"
	_tmp2_ = g_new0 (guint, 1);
#line 72 "../src/utils/Gamepad.vala"
	_tmp2_[0] = GDK_KEY_Return;
#line 72 "../src/utils/Gamepad.vala"
	_tmp3_ = _tmp2_;
#line 72 "../src/utils/Gamepad.vala"
	_tmp3__length1 = 1;
#line 72 "../src/utils/Gamepad.vala"
	_tmp4_ = game_hub_utils_gamepad_b ((guint16) 0x130, "A", NULL, _tmp3_, (gint) 1);
#line 72 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_A);
#line 72 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_A = _tmp4_;
#line 72 "../src/utils/Gamepad.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 73 "../src/utils/Gamepad.vala"
	_tmp5_ = g_new0 (guint, 1);
#line 73 "../src/utils/Gamepad.vala"
	_tmp5_[0] = GDK_KEY_Escape;
#line 73 "../src/utils/Gamepad.vala"
	_tmp6_ = _tmp5_;
#line 73 "../src/utils/Gamepad.vala"
	_tmp6__length1 = 1;
#line 73 "../src/utils/Gamepad.vala"
	_tmp7_ = game_hub_utils_gamepad_b ((guint16) 0x131, "B", NULL, _tmp6_, (gint) 1);
#line 73 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_B);
#line 73 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_B = _tmp7_;
#line 73 "../src/utils/Gamepad.vala"
	_tmp6_ = (g_free (_tmp6_), NULL);
#line 74 "../src/utils/Gamepad.vala"
	_tmp8_ = g_new0 (guint, 0);
#line 74 "../src/utils/Gamepad.vala"
	_tmp9_ = _tmp8_;
#line 74 "../src/utils/Gamepad.vala"
	_tmp9__length1 = 0;
#line 74 "../src/utils/Gamepad.vala"
	_tmp10_ = game_hub_utils_gamepad_b ((guint16) 0x132, "C", NULL, _tmp9_, (gint) 0);
#line 74 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_C);
#line 74 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_C = _tmp10_;
#line 74 "../src/utils/Gamepad.vala"
	_tmp9_ = (g_free (_tmp9_), NULL);
#line 75 "../src/utils/Gamepad.vala"
	_tmp11_ = g_new0 (guint, 1);
#line 75 "../src/utils/Gamepad.vala"
	_tmp11_[0] = GDK_KEY_Menu;
#line 75 "../src/utils/Gamepad.vala"
	_tmp12_ = _tmp11_;
#line 75 "../src/utils/Gamepad.vala"
	_tmp12__length1 = 1;
#line 75 "../src/utils/Gamepad.vala"
	_tmp13_ = game_hub_utils_gamepad_b ((guint16) 0x133, "X", NULL, _tmp12_, (gint) 1);
#line 75 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_X);
#line 75 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_X = _tmp13_;
#line 75 "../src/utils/Gamepad.vala"
	_tmp12_ = (g_free (_tmp12_), NULL);
#line 76 "../src/utils/Gamepad.vala"
	_tmp14_ = g_new0 (guint, 2);
#line 76 "../src/utils/Gamepad.vala"
	_tmp14_[0] = GDK_KEY_Alt_L;
#line 76 "../src/utils/Gamepad.vala"
	_tmp14_[1] = GDK_KEY_F;
#line 76 "../src/utils/Gamepad.vala"
	_tmp15_ = _tmp14_;
#line 76 "../src/utils/Gamepad.vala"
	_tmp15__length1 = 2;
#line 76 "../src/utils/Gamepad.vala"
	_tmp16_ = game_hub_utils_gamepad_b ((guint16) 0x134, "Y", NULL, _tmp15_, (gint) 2);
#line 76 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_Y);
#line 76 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_Y = _tmp16_;
#line 76 "../src/utils/Gamepad.vala"
	_tmp15_ = (g_free (_tmp15_), NULL);
#line 77 "../src/utils/Gamepad.vala"
	_tmp17_ = g_new0 (guint, 0);
#line 77 "../src/utils/Gamepad.vala"
	_tmp18_ = _tmp17_;
#line 77 "../src/utils/Gamepad.vala"
	_tmp18__length1 = 0;
#line 77 "../src/utils/Gamepad.vala"
	_tmp19_ = game_hub_utils_gamepad_b ((guint16) 0x135, "Z", NULL, _tmp18_, (gint) 0);
#line 77 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_Z);
#line 77 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_Z = _tmp19_;
#line 77 "../src/utils/Gamepad.vala"
	_tmp18_ = (g_free (_tmp18_), NULL);
#line 79 "../src/utils/Gamepad.vala"
	_tmp20_ = g_new0 (guint, 1);
#line 79 "../src/utils/Gamepad.vala"
	_tmp20_[0] = GDK_KEY_F1;
#line 79 "../src/utils/Gamepad.vala"
	_tmp21_ = _tmp20_;
#line 79 "../src/utils/Gamepad.vala"
	_tmp21__length1 = 1;
#line 79 "../src/utils/Gamepad.vala"
	_tmp22_ = game_hub_utils_gamepad_b ((guint16) 0x136, "LB", "Left Bumper", _tmp21_, (gint) 1);
#line 79 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BUMPER_LEFT);
#line 79 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BUMPER_LEFT = _tmp22_;
#line 79 "../src/utils/Gamepad.vala"
	_tmp21_ = (g_free (_tmp21_), NULL);
#line 80 "../src/utils/Gamepad.vala"
	_tmp23_ = g_new0 (guint, 1);
#line 80 "../src/utils/Gamepad.vala"
	_tmp23_[0] = GDK_KEY_F2;
#line 80 "../src/utils/Gamepad.vala"
	_tmp24_ = _tmp23_;
#line 80 "../src/utils/Gamepad.vala"
	_tmp24__length1 = 1;
#line 80 "../src/utils/Gamepad.vala"
	_tmp25_ = game_hub_utils_gamepad_b ((guint16) 0x137, "RB", "Right Bumper", _tmp24_, (gint) 1);
#line 80 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BUMPER_RIGHT);
#line 80 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BUMPER_RIGHT = _tmp25_;
#line 80 "../src/utils/Gamepad.vala"
	_tmp24_ = (g_free (_tmp24_), NULL);
#line 82 "../src/utils/Gamepad.vala"
	_tmp26_ = g_new0 (guint, 2);
#line 82 "../src/utils/Gamepad.vala"
	_tmp26_[0] = GDK_KEY_Shift_L;
#line 82 "../src/utils/Gamepad.vala"
	_tmp26_[1] = GDK_KEY_Tab;
#line 82 "../src/utils/Gamepad.vala"
	_tmp27_ = _tmp26_;
#line 82 "../src/utils/Gamepad.vala"
	_tmp27__length1 = 2;
#line 82 "../src/utils/Gamepad.vala"
	_tmp28_ = game_hub_utils_gamepad_b ((guint16) 0x138, "LT", "Left Trigger", _tmp27_, (gint) 2);
#line 82 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_TRIGGER_LEFT);
#line 82 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_TRIGGER_LEFT = _tmp28_;
#line 82 "../src/utils/Gamepad.vala"
	_tmp27_ = (g_free (_tmp27_), NULL);
#line 83 "../src/utils/Gamepad.vala"
	_tmp29_ = g_new0 (guint, 1);
#line 83 "../src/utils/Gamepad.vala"
	_tmp29_[0] = GDK_KEY_Tab;
#line 83 "../src/utils/Gamepad.vala"
	_tmp30_ = _tmp29_;
#line 83 "../src/utils/Gamepad.vala"
	_tmp30__length1 = 1;
#line 83 "../src/utils/Gamepad.vala"
	_tmp31_ = game_hub_utils_gamepad_b ((guint16) 0x139, "RT", "Right Trigger", _tmp30_, (gint) 1);
#line 83 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_TRIGGER_RIGHT);
#line 83 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_TRIGGER_RIGHT = _tmp31_;
#line 83 "../src/utils/Gamepad.vala"
	_tmp30_ = (g_free (_tmp30_), NULL);
#line 85 "../src/utils/Gamepad.vala"
	_tmp32_ = g_new0 (guint, 1);
#line 85 "../src/utils/Gamepad.vala"
	_tmp32_[0] = GDK_KEY_F5;
#line 85 "../src/utils/Gamepad.vala"
	_tmp33_ = _tmp32_;
#line 85 "../src/utils/Gamepad.vala"
	_tmp33__length1 = 1;
#line 85 "../src/utils/Gamepad.vala"
	_tmp34_ = game_hub_utils_gamepad_b ((guint16) 0x13a, "Select", NULL, _tmp33_, (gint) 1);
#line 85 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_SELECT);
#line 85 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_SELECT = _tmp34_;
#line 85 "../src/utils/Gamepad.vala"
	_tmp33_ = (g_free (_tmp33_), NULL);
#line 86 "../src/utils/Gamepad.vala"
	_tmp35_ = g_new0 (guint, 1);
#line 86 "../src/utils/Gamepad.vala"
	_tmp35_[0] = GDK_KEY_F6;
#line 86 "../src/utils/Gamepad.vala"
	_tmp36_ = _tmp35_;
#line 86 "../src/utils/Gamepad.vala"
	_tmp36__length1 = 1;
#line 86 "../src/utils/Gamepad.vala"
	_tmp37_ = game_hub_utils_gamepad_b ((guint16) 0x13b, "Start", NULL, _tmp36_, (gint) 1);
#line 86 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_START);
#line 86 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_START = _tmp37_;
#line 86 "../src/utils/Gamepad.vala"
	_tmp36_ = (g_free (_tmp36_), NULL);
#line 87 "../src/utils/Gamepad.vala"
	_tmp38_ = g_new0 (guint, 1);
#line 87 "../src/utils/Gamepad.vala"
	_tmp38_[0] = GDK_KEY_Shift_L;
#line 87 "../src/utils/Gamepad.vala"
	_tmp39_ = _tmp38_;
#line 87 "../src/utils/Gamepad.vala"
	_tmp39__length1 = 1;
#line 87 "../src/utils/Gamepad.vala"
	_tmp40_ = game_hub_utils_gamepad_b ((guint16) 0x13c, "Guide", NULL, _tmp39_, (gint) 1);
#line 87 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_BTN_GUIDE);
#line 87 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_BTN_GUIDE = _tmp40_;
#line 87 "../src/utils/Gamepad.vala"
	_tmp39_ = (g_free (_tmp39_), NULL);
#line 89 "../src/utils/Gamepad.vala"
	_tmp41_ = g_new0 (guint, 0);
#line 89 "../src/utils/Gamepad.vala"
	_tmp42_ = _tmp41_;
#line 89 "../src/utils/Gamepad.vala"
	_tmp42__length1 = 0;
#line 89 "../src/utils/Gamepad.vala"
	_tmp43_ = game_hub_utils_gamepad_b ((guint16) 0x13d, "LS", "Left Stick", _tmp42_, (gint) 0);
#line 89 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_STICK_LEFT);
#line 89 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_STICK_LEFT = _tmp43_;
#line 89 "../src/utils/Gamepad.vala"
	_tmp42_ = (g_free (_tmp42_), NULL);
#line 90 "../src/utils/Gamepad.vala"
	_tmp44_ = g_new0 (guint, 0);
#line 90 "../src/utils/Gamepad.vala"
	_tmp45_ = _tmp44_;
#line 90 "../src/utils/Gamepad.vala"
	_tmp45__length1 = 0;
#line 90 "../src/utils/Gamepad.vala"
	_tmp46_ = game_hub_utils_gamepad_b ((guint16) 0x13e, "RS", "Right Stick", _tmp45_, (gint) 0);
#line 90 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_STICK_RIGHT);
#line 90 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_STICK_RIGHT = _tmp46_;
#line 90 "../src/utils/Gamepad.vala"
	_tmp45_ = (g_free (_tmp45_), NULL);
#line 92 "../src/utils/Gamepad.vala"
	_tmp47_ = g_new0 (guint, 1);
#line 92 "../src/utils/Gamepad.vala"
	_tmp47_[0] = GDK_KEY_Up;
#line 92 "../src/utils/Gamepad.vala"
	_tmp48_ = _tmp47_;
#line 92 "../src/utils/Gamepad.vala"
	_tmp48__length1 = 1;
#line 92 "../src/utils/Gamepad.vala"
	_tmp49_ = game_hub_utils_gamepad_b ((guint16) 0x220, "Up", "D-Pad Up", _tmp48_, (gint) 1);
#line 92 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_DPAD_UP);
#line 92 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_DPAD_UP = _tmp49_;
#line 92 "../src/utils/Gamepad.vala"
	_tmp48_ = (g_free (_tmp48_), NULL);
#line 93 "../src/utils/Gamepad.vala"
	_tmp50_ = g_new0 (guint, 1);
#line 93 "../src/utils/Gamepad.vala"
	_tmp50_[0] = GDK_KEY_Down;
#line 93 "../src/utils/Gamepad.vala"
	_tmp51_ = _tmp50_;
#line 93 "../src/utils/Gamepad.vala"
	_tmp51__length1 = 1;
#line 93 "../src/utils/Gamepad.vala"
	_tmp52_ = game_hub_utils_gamepad_b ((guint16) 0x221, "Down", "D-Pad Down", _tmp51_, (gint) 1);
#line 93 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_DPAD_DOWN);
#line 93 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_DPAD_DOWN = _tmp52_;
#line 93 "../src/utils/Gamepad.vala"
	_tmp51_ = (g_free (_tmp51_), NULL);
#line 94 "../src/utils/Gamepad.vala"
	_tmp53_ = g_new0 (guint, 1);
#line 94 "../src/utils/Gamepad.vala"
	_tmp53_[0] = GDK_KEY_Left;
#line 94 "../src/utils/Gamepad.vala"
	_tmp54_ = _tmp53_;
#line 94 "../src/utils/Gamepad.vala"
	_tmp54__length1 = 1;
#line 94 "../src/utils/Gamepad.vala"
	_tmp55_ = game_hub_utils_gamepad_b ((guint16) 0x222, "Left", "D-Pad Left", _tmp54_, (gint) 1);
#line 94 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_DPAD_LEFT);
#line 94 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_DPAD_LEFT = _tmp55_;
#line 94 "../src/utils/Gamepad.vala"
	_tmp54_ = (g_free (_tmp54_), NULL);
#line 95 "../src/utils/Gamepad.vala"
	_tmp56_ = g_new0 (guint, 1);
#line 95 "../src/utils/Gamepad.vala"
	_tmp56_[0] = GDK_KEY_Right;
#line 95 "../src/utils/Gamepad.vala"
	_tmp57_ = _tmp56_;
#line 95 "../src/utils/Gamepad.vala"
	_tmp57__length1 = 1;
#line 95 "../src/utils/Gamepad.vala"
	_tmp58_ = game_hub_utils_gamepad_b ((guint16) 0x223, "Right", "D-Pad Right", _tmp57_, (gint) 1);
#line 95 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_DPAD_RIGHT);
#line 95 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_DPAD_RIGHT = _tmp58_;
#line 95 "../src/utils/Gamepad.vala"
	_tmp57_ = (g_free (_tmp57_), NULL);
#line 97 "../src/utils/Gamepad.vala"
	_tmp59_ = g_new0 (guint, 0);
#line 97 "../src/utils/Gamepad.vala"
	_tmp60_ = _tmp59_;
#line 97 "../src/utils/Gamepad.vala"
	_tmp60__length1 = 0;
#line 97 "../src/utils/Gamepad.vala"
	_tmp61_ = game_hub_utils_gamepad_b ((guint16) 0x121, "L", "Left Trackpad Touch", _tmp60_, (gint) 0);
#line 97 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_SC_PAD_TAP_LEFT);
#line 97 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_SC_PAD_TAP_LEFT = _tmp61_;
#line 97 "../src/utils/Gamepad.vala"
	_tmp60_ = (g_free (_tmp60_), NULL);
#line 98 "../src/utils/Gamepad.vala"
	_tmp62_ = g_new0 (guint, 0);
#line 98 "../src/utils/Gamepad.vala"
	_tmp63_ = _tmp62_;
#line 98 "../src/utils/Gamepad.vala"
	_tmp63__length1 = 0;
#line 98 "../src/utils/Gamepad.vala"
	_tmp64_ = game_hub_utils_gamepad_b ((guint16) 0x122, "R", "Right Trackpad Touch", _tmp63_, (gint) 0);
#line 98 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_SC_PAD_TAP_RIGHT);
#line 98 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_SC_PAD_TAP_RIGHT = _tmp64_;
#line 98 "../src/utils/Gamepad.vala"
	_tmp63_ = (g_free (_tmp63_), NULL);
#line 100 "../src/utils/Gamepad.vala"
	_tmp65_ = g_new0 (guint, 0);
#line 100 "../src/utils/Gamepad.vala"
	_tmp66_ = _tmp65_;
#line 100 "../src/utils/Gamepad.vala"
	_tmp66__length1 = 0;
#line 100 "../src/utils/Gamepad.vala"
	_tmp67_ = game_hub_utils_gamepad_b ((guint16) 0x150, "LG", "Left Grip", _tmp66_, (gint) 0);
#line 100 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_SC_GRIP_LEFT);
#line 100 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_SC_GRIP_LEFT = _tmp67_;
#line 100 "../src/utils/Gamepad.vala"
	_tmp66_ = (g_free (_tmp66_), NULL);
#line 101 "../src/utils/Gamepad.vala"
	_tmp68_ = g_new0 (guint, 0);
#line 101 "../src/utils/Gamepad.vala"
	_tmp69_ = _tmp68_;
#line 101 "../src/utils/Gamepad.vala"
	_tmp69__length1 = 0;
#line 101 "../src/utils/Gamepad.vala"
	_tmp70_ = game_hub_utils_gamepad_b ((guint16) 0x151, "RG", "Right Grip", _tmp69_, (gint) 0);
#line 101 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_SC_GRIP_RIGHT);
#line 101 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_SC_GRIP_RIGHT = _tmp70_;
#line 101 "../src/utils/Gamepad.vala"
	_tmp69_ = (g_free (_tmp69_), NULL);
#line 103 "../src/utils/Gamepad.vala"
	_tmp71_ = game_hub_utils_gamepad_a ((guint16) 0x0, "LS X", "Left Stick X", GDK_KEY_Left, GDK_KEY_Right, 0.5);
#line 103 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_AXIS_LS_X);
#line 103 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_AXIS_LS_X = _tmp71_;
#line 104 "../src/utils/Gamepad.vala"
	_tmp72_ = game_hub_utils_gamepad_a ((guint16) 0x1, "LS Y", "Left Stick Y", GDK_KEY_Up, GDK_KEY_Down, 0.5);
#line 104 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_AXIS_LS_Y);
#line 104 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_AXIS_LS_Y = _tmp72_;
#line 105 "../src/utils/Gamepad.vala"
	_tmp73_ = game_hub_utils_gamepad_a ((guint16) 0x2, "RS X", "Right Stick X", (guint) 0, (guint) 0, 0.5);
#line 105 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_AXIS_RS_X);
#line 105 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_AXIS_RS_X = _tmp73_;
#line 106 "../src/utils/Gamepad.vala"
	_tmp74_ = game_hub_utils_gamepad_a ((guint16) 0x3, "RS Y", "Right Stick Y", (guint) 0, (guint) 0, 0.5);
#line 106 "../src/utils/Gamepad.vala"
	_g_object_unref0 (game_hub_utils_gamepad_AXIS_RS_Y);
#line 106 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_AXIS_RS_Y = _tmp74_;
#line 806 "Gamepad.c"
}

GameHubUtilsGamepadButton*
game_hub_utils_gamepad_b (guint16 code,
                          const gchar* name,
                          const gchar* long_name,
                          guint* keys,
                          gint keys_length1)
{
	GameHubUtilsGamepadButton* btn = NULL;
	GameHubUtilsGamepadButton* _tmp0_;
	GeeHashMap* _tmp1_;
	GameHubUtilsGamepadButton* result;
#line 109 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 111 "../src/utils/Gamepad.vala"
	_tmp0_ = game_hub_utils_gamepad_button_new (code, name, long_name, keys, keys_length1);
#line 111 "../src/utils/Gamepad.vala"
	btn = _tmp0_;
#line 112 "../src/utils/Gamepad.vala"
	_tmp1_ = game_hub_utils_gamepad_Buttons;
#line 112 "../src/utils/Gamepad.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) code), btn);
#line 113 "../src/utils/Gamepad.vala"
	result = btn;
#line 113 "../src/utils/Gamepad.vala"
	return result;
#line 834 "Gamepad.c"
}

GameHubUtilsGamepadAxis*
game_hub_utils_gamepad_a (guint16 code,
                          const gchar* name,
                          const gchar* long_name,
                          guint negative_key,
                          guint positive_key,
                          gdouble key_threshold)
{
	GameHubUtilsGamepadAxis* axis = NULL;
	GameHubUtilsGamepadAxis* _tmp0_;
	GeeHashMap* _tmp1_;
	GameHubUtilsGamepadAxis* result;
#line 116 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 118 "../src/utils/Gamepad.vala"
	_tmp0_ = game_hub_utils_gamepad_axis_new (code, name, long_name, negative_key, positive_key, key_threshold);
#line 118 "../src/utils/Gamepad.vala"
	axis = _tmp0_;
#line 119 "../src/utils/Gamepad.vala"
	_tmp1_ = game_hub_utils_gamepad_Axes;
#line 119 "../src/utils/Gamepad.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) code), axis);
#line 120 "../src/utils/Gamepad.vala"
	result = axis;
#line 120 "../src/utils/Gamepad.vala"
	return result;
#line 863 "Gamepad.c"
}

static inline gpointer
game_hub_utils_gamepad_button_get_instance_private (GameHubUtilsGamepadButton* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubUtilsGamepadButton_private_offset);
}

static guint*
_vala_array_dup65 (guint* self,
                   gssize length)
{
#line 135 "../src/utils/Gamepad.vala"
	if (length > 0) {
#line 135 "../src/utils/Gamepad.vala"
		return _vala_memdup2 (self, length * sizeof (guint));
#line 880 "Gamepad.c"
	}
#line 135 "../src/utils/Gamepad.vala"
	return NULL;
#line 884 "Gamepad.c"
}

GameHubUtilsGamepadButton*
game_hub_utils_gamepad_button_construct (GType object_type,
                                         guint16 code,
                                         const gchar* name,
                                         const gchar* long_name,
                                         guint* keys,
                                         gint keys_length1)
{
	GameHubUtilsGamepadButton * self = NULL;
	const gchar* _tmp0_ = NULL;
	guint* _tmp1_;
	gint _tmp1__length1;
#line 132 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 134 "../src/utils/Gamepad.vala"
	_tmp0_ = long_name;
#line 134 "../src/utils/Gamepad.vala"
	if (_tmp0_ == NULL) {
#line 134 "../src/utils/Gamepad.vala"
		_tmp0_ = name;
#line 907 "Gamepad.c"
	}
#line 134 "../src/utils/Gamepad.vala"
	self = (GameHubUtilsGamepadButton*) g_object_new (object_type, "code", code, "name", name, "long-name", _tmp0_, NULL);
#line 135 "../src/utils/Gamepad.vala"
	_tmp1_ = (keys != NULL) ? _vala_array_dup65 (keys, keys_length1) : keys;
#line 135 "../src/utils/Gamepad.vala"
	_tmp1__length1 = keys_length1;
#line 135 "../src/utils/Gamepad.vala"
	self->keys = (g_free (self->keys), NULL);
#line 135 "../src/utils/Gamepad.vala"
	self->keys = _tmp1_;
#line 135 "../src/utils/Gamepad.vala"
	self->keys_length1 = _tmp1__length1;
#line 132 "../src/utils/Gamepad.vala"
	return self;
#line 923 "Gamepad.c"
}

GameHubUtilsGamepadButton*
game_hub_utils_gamepad_button_new (guint16 code,
                                   const gchar* name,
                                   const gchar* long_name,
                                   guint* keys,
                                   gint keys_length1)
{
#line 132 "../src/utils/Gamepad.vala"
	return game_hub_utils_gamepad_button_construct (GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, code, name, long_name, keys, keys_length1);
#line 935 "Gamepad.c"
}

void
game_hub_utils_gamepad_button_emit_key_event (GameHubUtilsGamepadButton* self,
                                              gboolean press)
{
	guint* _tmp0_;
	gint _tmp0__length1;
#line 138 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 140 "../src/utils/Gamepad.vala"
	_tmp0_ = self->keys;
#line 140 "../src/utils/Gamepad.vala"
	_tmp0__length1 = self->keys_length1;
#line 950 "Gamepad.c"
	{
		guint* key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
#line 140 "../src/utils/Gamepad.vala"
		key_collection = _tmp0_;
#line 140 "../src/utils/Gamepad.vala"
		key_collection_length1 = _tmp0__length1;
#line 140 "../src/utils/Gamepad.vala"
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
#line 962 "Gamepad.c"
			guint key = 0U;
#line 140 "../src/utils/Gamepad.vala"
			key = key_collection[key_it];
#line 966 "Gamepad.c"
			{
#line 142 "../src/utils/Gamepad.vala"
				game_hub_utils_gamepad_emit_key_event (key, press);
#line 970 "Gamepad.c"
			}
		}
	}
#line 144 "../src/utils/Gamepad.vala"
	self->priv->pressed = press;
#line 976 "Gamepad.c"
}

void
game_hub_utils_gamepad_button_reset (GameHubUtilsGamepadButton* self)
{
#line 147 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 149 "../src/utils/Gamepad.vala"
	if (self->priv->pressed) {
#line 151 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_button_emit_key_event (self, FALSE);
#line 988 "Gamepad.c"
	}
}

guint16
game_hub_utils_gamepad_button_get_code (GameHubUtilsGamepadButton* self)
{
	guint16 result;
#line 125 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 125 "../src/utils/Gamepad.vala"
	result = self->priv->_code;
#line 125 "../src/utils/Gamepad.vala"
	return result;
#line 1002 "Gamepad.c"
}

static void
game_hub_utils_gamepad_button_set_code (GameHubUtilsGamepadButton* self,
                                        guint16 value)
{
	guint16 old_value;
#line 125 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 125 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_button_get_code (self);
#line 125 "../src/utils/Gamepad.vala"
	if (old_value != value) {
#line 125 "../src/utils/Gamepad.vala"
		self->priv->_code = value;
#line 125 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_button_properties[GAME_HUB_UTILS_GAMEPAD_BUTTON_CODE_PROPERTY]);
#line 1020 "Gamepad.c"
	}
}

const gchar*
game_hub_utils_gamepad_button_get_name (GameHubUtilsGamepadButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 126 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 126 "../src/utils/Gamepad.vala"
	_tmp0_ = self->priv->_name;
#line 126 "../src/utils/Gamepad.vala"
	result = _tmp0_;
#line 126 "../src/utils/Gamepad.vala"
	return result;
#line 1037 "Gamepad.c"
}

static void
game_hub_utils_gamepad_button_set_name (GameHubUtilsGamepadButton* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 126 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 126 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_button_get_name (self);
#line 126 "../src/utils/Gamepad.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1051 "Gamepad.c"
		gchar* _tmp0_;
#line 126 "../src/utils/Gamepad.vala"
		_tmp0_ = g_strdup (value);
#line 126 "../src/utils/Gamepad.vala"
		_g_free0 (self->priv->_name);
#line 126 "../src/utils/Gamepad.vala"
		self->priv->_name = _tmp0_;
#line 126 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_button_properties[GAME_HUB_UTILS_GAMEPAD_BUTTON_NAME_PROPERTY]);
#line 1061 "Gamepad.c"
	}
}

const gchar*
game_hub_utils_gamepad_button_get_long_name (GameHubUtilsGamepadButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 127 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 127 "../src/utils/Gamepad.vala"
	_tmp0_ = self->priv->_long_name;
#line 127 "../src/utils/Gamepad.vala"
	result = _tmp0_;
#line 127 "../src/utils/Gamepad.vala"
	return result;
#line 1078 "Gamepad.c"
}

static void
game_hub_utils_gamepad_button_set_long_name (GameHubUtilsGamepadButton* self,
                                             const gchar* value)
{
	gchar* old_value;
#line 127 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 127 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_button_get_long_name (self);
#line 127 "../src/utils/Gamepad.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1092 "Gamepad.c"
		gchar* _tmp0_;
#line 127 "../src/utils/Gamepad.vala"
		_tmp0_ = g_strdup (value);
#line 127 "../src/utils/Gamepad.vala"
		_g_free0 (self->priv->_long_name);
#line 127 "../src/utils/Gamepad.vala"
		self->priv->_long_name = _tmp0_;
#line 127 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_button_properties[GAME_HUB_UTILS_GAMEPAD_BUTTON_LONG_NAME_PROPERTY]);
#line 1102 "Gamepad.c"
	}
}

static void
game_hub_utils_gamepad_button_class_init (GameHubUtilsGamepadButtonClass * klass,
                                          gpointer klass_data)
{
#line 123 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_button_parent_class = g_type_class_peek_parent (klass);
#line 123 "../src/utils/Gamepad.vala"
	g_type_class_adjust_private_offset (klass, &GameHubUtilsGamepadButton_private_offset);
#line 123 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_utils_gamepad_button_get_property;
#line 123 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_utils_gamepad_button_set_property;
#line 123 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_utils_gamepad_button_finalize;
#line 123 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_BUTTON_CODE_PROPERTY, game_hub_utils_gamepad_button_properties[GAME_HUB_UTILS_GAMEPAD_BUTTON_CODE_PROPERTY] = g_param_spec_uint ("code", "code", "code", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 123 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_BUTTON_NAME_PROPERTY, game_hub_utils_gamepad_button_properties[GAME_HUB_UTILS_GAMEPAD_BUTTON_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 123 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_BUTTON_LONG_NAME_PROPERTY, game_hub_utils_gamepad_button_properties[GAME_HUB_UTILS_GAMEPAD_BUTTON_LONG_NAME_PROPERTY] = g_param_spec_string ("long-name", "long-name", "long-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1126 "Gamepad.c"
}

static void
game_hub_utils_gamepad_button_instance_init (GameHubUtilsGamepadButton * self,
                                             gpointer klass)
{
#line 123 "../src/utils/Gamepad.vala"
	self->priv = game_hub_utils_gamepad_button_get_instance_private (self);
#line 130 "../src/utils/Gamepad.vala"
	self->priv->pressed = FALSE;
#line 1137 "Gamepad.c"
}

static void
game_hub_utils_gamepad_button_finalize (GObject * obj)
{
	GameHubUtilsGamepadButton * self;
#line 123 "../src/utils/Gamepad.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, GameHubUtilsGamepadButton);
#line 126 "../src/utils/Gamepad.vala"
	_g_free0 (self->priv->_name);
#line 127 "../src/utils/Gamepad.vala"
	_g_free0 (self->priv->_long_name);
#line 128 "../src/utils/Gamepad.vala"
	self->keys = (g_free (self->keys), NULL);
#line 123 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (game_hub_utils_gamepad_button_parent_class)->finalize (obj);
#line 1154 "Gamepad.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_gamepad_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsGamepadButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_gamepad_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsGamepadButton), 0, (GInstanceInitFunc) game_hub_utils_gamepad_button_instance_init, NULL };
	GType game_hub_utils_gamepad_button_type_id;
	game_hub_utils_gamepad_button_type_id = g_type_register_static (G_TYPE_OBJECT, "GameHubUtilsGamepadButton", &g_define_type_info, 0);
	GameHubUtilsGamepadButton_private_offset = g_type_add_instance_private (game_hub_utils_gamepad_button_type_id, sizeof (GameHubUtilsGamepadButtonPrivate));
	return game_hub_utils_gamepad_button_type_id;
}

GType
game_hub_utils_gamepad_button_get_type (void)
{
	static volatile gsize game_hub_utils_gamepad_button_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_gamepad_button_type_id__once)) {
		GType game_hub_utils_gamepad_button_type_id;
		game_hub_utils_gamepad_button_type_id = game_hub_utils_gamepad_button_get_type_once ();
		g_once_init_leave (&game_hub_utils_gamepad_button_type_id__once, game_hub_utils_gamepad_button_type_id);
	}
	return game_hub_utils_gamepad_button_type_id__once;
}

static void
_vala_game_hub_utils_gamepad_button_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GameHubUtilsGamepadButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, GameHubUtilsGamepadButton);
#line 123 "../src/utils/Gamepad.vala"
	switch (property_id) {
#line 123 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_BUTTON_CODE_PROPERTY:
#line 123 "../src/utils/Gamepad.vala"
		g_value_set_uint (value, game_hub_utils_gamepad_button_get_code (self));
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 123 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_BUTTON_NAME_PROPERTY:
#line 123 "../src/utils/Gamepad.vala"
		g_value_set_string (value, game_hub_utils_gamepad_button_get_name (self));
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 123 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_BUTTON_LONG_NAME_PROPERTY:
#line 123 "../src/utils/Gamepad.vala"
		g_value_set_string (value, game_hub_utils_gamepad_button_get_long_name (self));
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 1207 "Gamepad.c"
		default:
#line 123 "../src/utils/Gamepad.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 1213 "Gamepad.c"
	}
}

static void
_vala_game_hub_utils_gamepad_button_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GameHubUtilsGamepadButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UTILS_GAMEPAD_TYPE_BUTTON, GameHubUtilsGamepadButton);
#line 123 "../src/utils/Gamepad.vala"
	switch (property_id) {
#line 123 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_BUTTON_CODE_PROPERTY:
#line 123 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_button_set_code (self, g_value_get_uint (value));
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 123 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_BUTTON_NAME_PROPERTY:
#line 123 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_button_set_name (self, g_value_get_string (value));
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 123 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_BUTTON_LONG_NAME_PROPERTY:
#line 123 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_button_set_long_name (self, g_value_get_string (value));
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 1245 "Gamepad.c"
		default:
#line 123 "../src/utils/Gamepad.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 123 "../src/utils/Gamepad.vala"
		break;
#line 1251 "Gamepad.c"
	}
}

static inline gpointer
game_hub_utils_gamepad_axis_get_instance_private (GameHubUtilsGamepadAxis* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubUtilsGamepadAxis_private_offset);
}

GameHubUtilsGamepadAxis*
game_hub_utils_gamepad_axis_construct (GType object_type,
                                       guint16 code,
                                       const gchar* name,
                                       const gchar* long_name,
                                       guint negative_key,
                                       guint positive_key,
                                       gdouble key_threshold)
{
	GameHubUtilsGamepadAxis * self = NULL;
	const gchar* _tmp0_ = NULL;
#line 187 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 189 "../src/utils/Gamepad.vala"
	_tmp0_ = long_name;
#line 189 "../src/utils/Gamepad.vala"
	if (_tmp0_ == NULL) {
#line 189 "../src/utils/Gamepad.vala"
		_tmp0_ = name;
#line 1280 "Gamepad.c"
	}
#line 189 "../src/utils/Gamepad.vala"
	self = (GameHubUtilsGamepadAxis*) g_object_new (object_type, "code", code, "name", name, "long-name", _tmp0_, "negative-key", negative_key, "positive-key", positive_key, "key-threshold", key_threshold, NULL);
#line 187 "../src/utils/Gamepad.vala"
	return self;
#line 1286 "Gamepad.c"
}

GameHubUtilsGamepadAxis*
game_hub_utils_gamepad_axis_new (guint16 code,
                                 const gchar* name,
                                 const gchar* long_name,
                                 guint negative_key,
                                 guint positive_key,
                                 gdouble key_threshold)
{
#line 187 "../src/utils/Gamepad.vala"
	return game_hub_utils_gamepad_axis_construct (GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, code, name, long_name, negative_key, positive_key, key_threshold);
#line 1299 "Gamepad.c"
}

void
game_hub_utils_gamepad_axis_emit_key_event (GameHubUtilsGamepadAxis* self)
{
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gulong last_update = 0UL;
	GTimer* _tmp3_;
	gulong _tmp4_ = 0UL;
	gboolean _tmp5_ = FALSE;
	GTimer* _tmp15_;
#line 192 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 194 "../src/utils/Gamepad.vala"
	_tmp1_ = self->priv->_negative_key;
#line 194 "../src/utils/Gamepad.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 1318 "Gamepad.c"
		guint _tmp2_;
#line 194 "../src/utils/Gamepad.vala"
		_tmp2_ = self->priv->_positive_key;
#line 194 "../src/utils/Gamepad.vala"
		_tmp0_ = _tmp2_ == ((guint) 0);
#line 1324 "Gamepad.c"
	} else {
#line 194 "../src/utils/Gamepad.vala"
		_tmp0_ = FALSE;
#line 1328 "Gamepad.c"
	}
#line 194 "../src/utils/Gamepad.vala"
	if (_tmp0_) {
#line 194 "../src/utils/Gamepad.vala"
		return;
#line 1334 "Gamepad.c"
	}
#line 197 "../src/utils/Gamepad.vala"
	_tmp3_ = self->priv->timer;
#line 197 "../src/utils/Gamepad.vala"
	g_timer_elapsed (_tmp3_, &_tmp4_);
#line 197 "../src/utils/Gamepad.vala"
	last_update = _tmp4_;
#line 198 "../src/utils/Gamepad.vala"
	if (self->priv->_value_sign == 0) {
#line 198 "../src/utils/Gamepad.vala"
		_tmp5_ = last_update >= ((gulong) GAME_HUB_UTILS_GAMEPAD_KEY_UP_EMIT_TIMEOUT);
#line 1346 "Gamepad.c"
	} else {
#line 198 "../src/utils/Gamepad.vala"
		_tmp5_ = FALSE;
#line 1350 "Gamepad.c"
	}
#line 198 "../src/utils/Gamepad.vala"
	if (_tmp5_) {
#line 1354 "Gamepad.c"
		GTimer* _tmp8_;
#line 200 "../src/utils/Gamepad.vala"
		if (self->priv->_pressed_sign < 0) {
#line 1358 "Gamepad.c"
			guint _tmp6_;
#line 200 "../src/utils/Gamepad.vala"
			_tmp6_ = self->priv->_negative_key;
#line 200 "../src/utils/Gamepad.vala"
			game_hub_utils_gamepad_emit_key_event (_tmp6_, FALSE);
#line 1364 "Gamepad.c"
		}
#line 201 "../src/utils/Gamepad.vala"
		if (self->priv->_pressed_sign > 0) {
#line 1368 "Gamepad.c"
			guint _tmp7_;
#line 201 "../src/utils/Gamepad.vala"
			_tmp7_ = self->priv->_positive_key;
#line 201 "../src/utils/Gamepad.vala"
			game_hub_utils_gamepad_emit_key_event (_tmp7_, FALSE);
#line 1374 "Gamepad.c"
		}
#line 202 "../src/utils/Gamepad.vala"
		_tmp8_ = self->priv->timer;
#line 202 "../src/utils/Gamepad.vala"
		g_timer_stop (_tmp8_);
#line 203 "../src/utils/Gamepad.vala"
		self->priv->_value = (gdouble) 0;
#line 204 "../src/utils/Gamepad.vala"
		self->priv->_value_sign = 0;
#line 205 "../src/utils/Gamepad.vala"
		self->priv->_pressed_sign = 0;
#line 206 "../src/utils/Gamepad.vala"
		self->priv->_sign_changed = FALSE;
#line 207 "../src/utils/Gamepad.vala"
		return;
#line 1390 "Gamepad.c"
	}
#line 210 "../src/utils/Gamepad.vala"
	if (!self->priv->_sign_changed) {
#line 210 "../src/utils/Gamepad.vala"
		return;
#line 1396 "Gamepad.c"
	}
#line 212 "../src/utils/Gamepad.vala"
	if (self->priv->_value_sign < 0) {
#line 1400 "Gamepad.c"
		guint _tmp9_;
		guint _tmp10_;
#line 214 "../src/utils/Gamepad.vala"
		_tmp9_ = self->priv->_positive_key;
#line 214 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_emit_key_event (_tmp9_, FALSE);
#line 215 "../src/utils/Gamepad.vala"
		_tmp10_ = self->priv->_negative_key;
#line 215 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_emit_key_event (_tmp10_, TRUE);
#line 216 "../src/utils/Gamepad.vala"
		self->priv->_pressed_sign = -1;
#line 1413 "Gamepad.c"
	} else {
#line 218 "../src/utils/Gamepad.vala"
		if (self->priv->_value_sign > 0) {
#line 1417 "Gamepad.c"
			guint _tmp11_;
			guint _tmp12_;
#line 220 "../src/utils/Gamepad.vala"
			_tmp11_ = self->priv->_negative_key;
#line 220 "../src/utils/Gamepad.vala"
			game_hub_utils_gamepad_emit_key_event (_tmp11_, FALSE);
#line 221 "../src/utils/Gamepad.vala"
			_tmp12_ = self->priv->_positive_key;
#line 221 "../src/utils/Gamepad.vala"
			game_hub_utils_gamepad_emit_key_event (_tmp12_, TRUE);
#line 222 "../src/utils/Gamepad.vala"
			self->priv->_pressed_sign = 1;
#line 1430 "Gamepad.c"
		} else {
#line 226 "../src/utils/Gamepad.vala"
			if (self->priv->_pressed_sign < 0) {
#line 1434 "Gamepad.c"
				guint _tmp13_;
#line 226 "../src/utils/Gamepad.vala"
				_tmp13_ = self->priv->_negative_key;
#line 226 "../src/utils/Gamepad.vala"
				game_hub_utils_gamepad_emit_key_event (_tmp13_, FALSE);
#line 1440 "Gamepad.c"
			}
#line 227 "../src/utils/Gamepad.vala"
			if (self->priv->_pressed_sign > 0) {
#line 1444 "Gamepad.c"
				guint _tmp14_;
#line 227 "../src/utils/Gamepad.vala"
				_tmp14_ = self->priv->_positive_key;
#line 227 "../src/utils/Gamepad.vala"
				game_hub_utils_gamepad_emit_key_event (_tmp14_, FALSE);
#line 1450 "Gamepad.c"
			}
#line 228 "../src/utils/Gamepad.vala"
			self->priv->_pressed_sign = 0;
#line 1454 "Gamepad.c"
		}
	}
#line 231 "../src/utils/Gamepad.vala"
	self->priv->_sign_changed = FALSE;
#line 232 "../src/utils/Gamepad.vala"
	_tmp15_ = self->priv->timer;
#line 232 "../src/utils/Gamepad.vala"
	g_timer_start (_tmp15_);
#line 1463 "Gamepad.c"
}

void
game_hub_utils_gamepad_axis_reset (GameHubUtilsGamepadAxis* self)
{
#line 235 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 237 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_axis_set_value (self, (gdouble) 0);
#line 238 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_axis_emit_key_event (self);
#line 1475 "Gamepad.c"
}

guint16
game_hub_utils_gamepad_axis_get_code (GameHubUtilsGamepadAxis* self)
{
	guint16 result;
#line 158 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 158 "../src/utils/Gamepad.vala"
	result = self->priv->_code;
#line 158 "../src/utils/Gamepad.vala"
	return result;
#line 1488 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_set_code (GameHubUtilsGamepadAxis* self,
                                      guint16 value)
{
	guint16 old_value;
#line 158 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 158 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_axis_get_code (self);
#line 158 "../src/utils/Gamepad.vala"
	if (old_value != value) {
#line 158 "../src/utils/Gamepad.vala"
		self->priv->_code = value;
#line 158 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_CODE_PROPERTY]);
#line 1506 "Gamepad.c"
	}
}

const gchar*
game_hub_utils_gamepad_axis_get_name (GameHubUtilsGamepadAxis* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 159 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 159 "../src/utils/Gamepad.vala"
	_tmp0_ = self->priv->_name;
#line 159 "../src/utils/Gamepad.vala"
	result = _tmp0_;
#line 159 "../src/utils/Gamepad.vala"
	return result;
#line 1523 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_set_name (GameHubUtilsGamepadAxis* self,
                                      const gchar* value)
{
	gchar* old_value;
#line 159 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 159 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_axis_get_name (self);
#line 159 "../src/utils/Gamepad.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1537 "Gamepad.c"
		gchar* _tmp0_;
#line 159 "../src/utils/Gamepad.vala"
		_tmp0_ = g_strdup (value);
#line 159 "../src/utils/Gamepad.vala"
		_g_free0 (self->priv->_name);
#line 159 "../src/utils/Gamepad.vala"
		self->priv->_name = _tmp0_;
#line 159 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_NAME_PROPERTY]);
#line 1547 "Gamepad.c"
	}
}

const gchar*
game_hub_utils_gamepad_axis_get_long_name (GameHubUtilsGamepadAxis* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 160 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "../src/utils/Gamepad.vala"
	_tmp0_ = self->priv->_long_name;
#line 160 "../src/utils/Gamepad.vala"
	result = _tmp0_;
#line 160 "../src/utils/Gamepad.vala"
	return result;
#line 1564 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_set_long_name (GameHubUtilsGamepadAxis* self,
                                           const gchar* value)
{
	gchar* old_value;
#line 160 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 160 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_axis_get_long_name (self);
#line 160 "../src/utils/Gamepad.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1578 "Gamepad.c"
		gchar* _tmp0_;
#line 160 "../src/utils/Gamepad.vala"
		_tmp0_ = g_strdup (value);
#line 160 "../src/utils/Gamepad.vala"
		_g_free0 (self->priv->_long_name);
#line 160 "../src/utils/Gamepad.vala"
		self->priv->_long_name = _tmp0_;
#line 160 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_LONG_NAME_PROPERTY]);
#line 1588 "Gamepad.c"
	}
}

guint
game_hub_utils_gamepad_axis_get_negative_key (GameHubUtilsGamepadAxis* self)
{
	guint result;
#line 161 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 161 "../src/utils/Gamepad.vala"
	result = self->priv->_negative_key;
#line 161 "../src/utils/Gamepad.vala"
	return result;
#line 1602 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_set_negative_key (GameHubUtilsGamepadAxis* self,
                                              guint value)
{
	guint old_value;
#line 161 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 161 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_axis_get_negative_key (self);
#line 161 "../src/utils/Gamepad.vala"
	if (old_value != value) {
#line 161 "../src/utils/Gamepad.vala"
		self->priv->_negative_key = value;
#line 161 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_NEGATIVE_KEY_PROPERTY]);
#line 1620 "Gamepad.c"
	}
}

guint
game_hub_utils_gamepad_axis_get_positive_key (GameHubUtilsGamepadAxis* self)
{
	guint result;
#line 162 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 162 "../src/utils/Gamepad.vala"
	result = self->priv->_positive_key;
#line 162 "../src/utils/Gamepad.vala"
	return result;
#line 1634 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_set_positive_key (GameHubUtilsGamepadAxis* self,
                                              guint value)
{
	guint old_value;
#line 162 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 162 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_axis_get_positive_key (self);
#line 162 "../src/utils/Gamepad.vala"
	if (old_value != value) {
#line 162 "../src/utils/Gamepad.vala"
		self->priv->_positive_key = value;
#line 162 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_POSITIVE_KEY_PROPERTY]);
#line 1652 "Gamepad.c"
	}
}

gdouble
game_hub_utils_gamepad_axis_get_key_threshold (GameHubUtilsGamepadAxis* self)
{
	gdouble result;
#line 163 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 163 "../src/utils/Gamepad.vala"
	result = self->priv->_key_threshold;
#line 163 "../src/utils/Gamepad.vala"
	return result;
#line 1666 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_set_key_threshold (GameHubUtilsGamepadAxis* self,
                                               gdouble value)
{
	gdouble old_value;
#line 163 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 163 "../src/utils/Gamepad.vala"
	old_value = game_hub_utils_gamepad_axis_get_key_threshold (self);
#line 163 "../src/utils/Gamepad.vala"
	if (old_value != value) {
#line 163 "../src/utils/Gamepad.vala"
		self->priv->_key_threshold = value;
#line 163 "../src/utils/Gamepad.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_KEY_THRESHOLD_PROPERTY]);
#line 1684 "Gamepad.c"
	}
}

gdouble
game_hub_utils_gamepad_axis_get_value (GameHubUtilsGamepadAxis* self)
{
	gdouble result;
#line 174 "../src/utils/Gamepad.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 176 "../src/utils/Gamepad.vala"
	result = self->priv->_value;
#line 176 "../src/utils/Gamepad.vala"
	return result;
#line 1698 "Gamepad.c"
}

void
game_hub_utils_gamepad_axis_set_value (GameHubUtilsGamepadAxis* self,
                                       gdouble value)
{
	gint _tmp0_ = 0;
	gdouble _tmp1_;
	gint sign = 0;
#line 178 "../src/utils/Gamepad.vala"
	g_return_if_fail (self != NULL);
#line 180 "../src/utils/Gamepad.vala"
	_tmp1_ = self->priv->_key_threshold;
#line 180 "../src/utils/Gamepad.vala"
	if (value < (-_tmp1_)) {
#line 180 "../src/utils/Gamepad.vala"
		_tmp0_ = -1;
#line 1716 "Gamepad.c"
	} else {
		gint _tmp2_ = 0;
		gdouble _tmp3_;
#line 180 "../src/utils/Gamepad.vala"
		_tmp3_ = self->priv->_key_threshold;
#line 180 "../src/utils/Gamepad.vala"
		if (value > _tmp3_) {
#line 180 "../src/utils/Gamepad.vala"
			_tmp2_ = 1;
#line 1726 "Gamepad.c"
		} else {
#line 180 "../src/utils/Gamepad.vala"
			_tmp2_ = 0;
#line 1730 "Gamepad.c"
		}
#line 180 "../src/utils/Gamepad.vala"
		_tmp0_ = _tmp2_;
#line 1734 "Gamepad.c"
	}
#line 180 "../src/utils/Gamepad.vala"
	sign = _tmp0_;
#line 181 "../src/utils/Gamepad.vala"
	self->priv->_sign_changed = self->priv->_value_sign == sign;
#line 182 "../src/utils/Gamepad.vala"
	self->priv->_value_sign = sign;
#line 183 "../src/utils/Gamepad.vala"
	self->priv->_value = value;
#line 178 "../src/utils/Gamepad.vala"
	g_object_notify_by_pspec ((GObject *) self, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_VALUE_PROPERTY]);
#line 1746 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_class_init (GameHubUtilsGamepadAxisClass * klass,
                                        gpointer klass_data)
{
#line 156 "../src/utils/Gamepad.vala"
	game_hub_utils_gamepad_axis_parent_class = g_type_class_peek_parent (klass);
#line 156 "../src/utils/Gamepad.vala"
	g_type_class_adjust_private_offset (klass, &GameHubUtilsGamepadAxis_private_offset);
#line 156 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_utils_gamepad_axis_get_property;
#line 156 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_utils_gamepad_axis_set_property;
#line 156 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_utils_gamepad_axis_finalize;
#line 156 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_AXIS_CODE_PROPERTY, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_CODE_PROPERTY] = g_param_spec_uint ("code", "code", "code", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 156 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_AXIS_NAME_PROPERTY, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 156 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_AXIS_LONG_NAME_PROPERTY, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_LONG_NAME_PROPERTY] = g_param_spec_string ("long-name", "long-name", "long-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 156 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_AXIS_NEGATIVE_KEY_PROPERTY, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_NEGATIVE_KEY_PROPERTY] = g_param_spec_uint ("negative-key", "negative-key", "negative-key", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 156 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_AXIS_POSITIVE_KEY_PROPERTY, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_POSITIVE_KEY_PROPERTY] = g_param_spec_uint ("positive-key", "positive-key", "positive-key", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 156 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_AXIS_KEY_THRESHOLD_PROPERTY, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_KEY_THRESHOLD_PROPERTY] = g_param_spec_double ("key-threshold", "key-threshold", "key-threshold", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 156 "../src/utils/Gamepad.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UTILS_GAMEPAD_AXIS_VALUE_PROPERTY, game_hub_utils_gamepad_axis_properties[GAME_HUB_UTILS_GAMEPAD_AXIS_VALUE_PROPERTY] = g_param_spec_double ("value", "value", "value", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1777 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_instance_init (GameHubUtilsGamepadAxis * self,
                                           gpointer klass)
{
	GTimer* _tmp0_;
#line 156 "../src/utils/Gamepad.vala"
	self->priv = game_hub_utils_gamepad_axis_get_instance_private (self);
#line 165 "../src/utils/Gamepad.vala"
	self->priv->_value = (gdouble) 0;
#line 166 "../src/utils/Gamepad.vala"
	self->priv->_value_sign = 0;
#line 167 "../src/utils/Gamepad.vala"
	self->priv->_pressed_sign = 0;
#line 168 "../src/utils/Gamepad.vala"
	self->priv->_sign_changed = FALSE;
#line 170 "../src/utils/Gamepad.vala"
	_tmp0_ = g_timer_new ();
#line 170 "../src/utils/Gamepad.vala"
	self->priv->timer = _tmp0_;
#line 1799 "Gamepad.c"
}

static void
game_hub_utils_gamepad_axis_finalize (GObject * obj)
{
	GameHubUtilsGamepadAxis * self;
#line 156 "../src/utils/Gamepad.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, GameHubUtilsGamepadAxis);
#line 159 "../src/utils/Gamepad.vala"
	_g_free0 (self->priv->_name);
#line 160 "../src/utils/Gamepad.vala"
	_g_free0 (self->priv->_long_name);
#line 170 "../src/utils/Gamepad.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 156 "../src/utils/Gamepad.vala"
	G_OBJECT_CLASS (game_hub_utils_gamepad_axis_parent_class)->finalize (obj);
#line 1816 "Gamepad.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_utils_gamepad_axis_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUtilsGamepadAxisClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_utils_gamepad_axis_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUtilsGamepadAxis), 0, (GInstanceInitFunc) game_hub_utils_gamepad_axis_instance_init, NULL };
	GType game_hub_utils_gamepad_axis_type_id;
	game_hub_utils_gamepad_axis_type_id = g_type_register_static (G_TYPE_OBJECT, "GameHubUtilsGamepadAxis", &g_define_type_info, 0);
	GameHubUtilsGamepadAxis_private_offset = g_type_add_instance_private (game_hub_utils_gamepad_axis_type_id, sizeof (GameHubUtilsGamepadAxisPrivate));
	return game_hub_utils_gamepad_axis_type_id;
}

GType
game_hub_utils_gamepad_axis_get_type (void)
{
	static volatile gsize game_hub_utils_gamepad_axis_type_id__once = 0;
	if (g_once_init_enter (&game_hub_utils_gamepad_axis_type_id__once)) {
		GType game_hub_utils_gamepad_axis_type_id;
		game_hub_utils_gamepad_axis_type_id = game_hub_utils_gamepad_axis_get_type_once ();
		g_once_init_leave (&game_hub_utils_gamepad_axis_type_id__once, game_hub_utils_gamepad_axis_type_id);
	}
	return game_hub_utils_gamepad_axis_type_id__once;
}

static void
_vala_game_hub_utils_gamepad_axis_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GameHubUtilsGamepadAxis * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, GameHubUtilsGamepadAxis);
#line 156 "../src/utils/Gamepad.vala"
	switch (property_id) {
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_CODE_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		g_value_set_uint (value, game_hub_utils_gamepad_axis_get_code (self));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_NAME_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		g_value_set_string (value, game_hub_utils_gamepad_axis_get_name (self));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_LONG_NAME_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		g_value_set_string (value, game_hub_utils_gamepad_axis_get_long_name (self));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_NEGATIVE_KEY_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		g_value_set_uint (value, game_hub_utils_gamepad_axis_get_negative_key (self));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_POSITIVE_KEY_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		g_value_set_uint (value, game_hub_utils_gamepad_axis_get_positive_key (self));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_KEY_THRESHOLD_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		g_value_set_double (value, game_hub_utils_gamepad_axis_get_key_threshold (self));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_VALUE_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		g_value_set_double (value, game_hub_utils_gamepad_axis_get_value (self));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 1893 "Gamepad.c"
		default:
#line 156 "../src/utils/Gamepad.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 1899 "Gamepad.c"
	}
}

static void
_vala_game_hub_utils_gamepad_axis_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GameHubUtilsGamepadAxis * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UTILS_GAMEPAD_TYPE_AXIS, GameHubUtilsGamepadAxis);
#line 156 "../src/utils/Gamepad.vala"
	switch (property_id) {
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_CODE_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_axis_set_code (self, g_value_get_uint (value));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_NAME_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_axis_set_name (self, g_value_get_string (value));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_LONG_NAME_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_axis_set_long_name (self, g_value_get_string (value));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_NEGATIVE_KEY_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_axis_set_negative_key (self, g_value_get_uint (value));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_POSITIVE_KEY_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_axis_set_positive_key (self, g_value_get_uint (value));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_KEY_THRESHOLD_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_axis_set_key_threshold (self, g_value_get_double (value));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 156 "../src/utils/Gamepad.vala"
		case GAME_HUB_UTILS_GAMEPAD_AXIS_VALUE_PROPERTY:
#line 156 "../src/utils/Gamepad.vala"
		game_hub_utils_gamepad_axis_set_value (self, g_value_get_double (value));
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 1955 "Gamepad.c"
		default:
#line 156 "../src/utils/Gamepad.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 156 "../src/utils/Gamepad.vala"
		break;
#line 1961 "Gamepad.c"
	}
}

void
game_hub_utils_gamepad_reset (void)
{
	{
		GeeIterator* _button_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 244 "../src/utils/Gamepad.vala"
		_tmp0_ = game_hub_utils_gamepad_Buttons;
#line 244 "../src/utils/Gamepad.vala"
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
#line 244 "../src/utils/Gamepad.vala"
		_tmp2_ = _tmp1_;
#line 244 "../src/utils/Gamepad.vala"
		_tmp3_ = _tmp2_;
#line 244 "../src/utils/Gamepad.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 244 "../src/utils/Gamepad.vala"
		_tmp5_ = _tmp4_;
#line 244 "../src/utils/Gamepad.vala"
		_g_object_unref0 (_tmp3_);
#line 244 "../src/utils/Gamepad.vala"
		_button_it = _tmp5_;
#line 244 "../src/utils/Gamepad.vala"
		while (TRUE) {
#line 1994 "Gamepad.c"
			GeeIterator* _tmp6_;
			GameHubUtilsGamepadButton* button = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GameHubUtilsGamepadButton* _tmp9_;
#line 244 "../src/utils/Gamepad.vala"
			_tmp6_ = _button_it;
#line 244 "../src/utils/Gamepad.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 244 "../src/utils/Gamepad.vala"
				break;
#line 2006 "Gamepad.c"
			}
#line 244 "../src/utils/Gamepad.vala"
			_tmp7_ = _button_it;
#line 244 "../src/utils/Gamepad.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 244 "../src/utils/Gamepad.vala"
			button = (GameHubUtilsGamepadButton*) _tmp8_;
#line 246 "../src/utils/Gamepad.vala"
			_tmp9_ = button;
#line 246 "../src/utils/Gamepad.vala"
			game_hub_utils_gamepad_button_reset (_tmp9_);
#line 244 "../src/utils/Gamepad.vala"
			_g_object_unref0 (button);
#line 2020 "Gamepad.c"
		}
#line 244 "../src/utils/Gamepad.vala"
		_g_object_unref0 (_button_it);
#line 2024 "Gamepad.c"
	}
	{
		GeeIterator* _axis_it = NULL;
		GeeHashMap* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		GeeIterator* _tmp14_;
		GeeIterator* _tmp15_;
#line 248 "../src/utils/Gamepad.vala"
		_tmp10_ = game_hub_utils_gamepad_Axes;
#line 248 "../src/utils/Gamepad.vala"
		_tmp11_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp10_);
#line 248 "../src/utils/Gamepad.vala"
		_tmp12_ = _tmp11_;
#line 248 "../src/utils/Gamepad.vala"
		_tmp13_ = _tmp12_;
#line 248 "../src/utils/Gamepad.vala"
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
#line 248 "../src/utils/Gamepad.vala"
		_tmp15_ = _tmp14_;
#line 248 "../src/utils/Gamepad.vala"
		_g_object_unref0 (_tmp13_);
#line 248 "../src/utils/Gamepad.vala"
		_axis_it = _tmp15_;
#line 248 "../src/utils/Gamepad.vala"
		while (TRUE) {
#line 2052 "Gamepad.c"
			GeeIterator* _tmp16_;
			GameHubUtilsGamepadAxis* axis = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			GameHubUtilsGamepadAxis* _tmp19_;
#line 248 "../src/utils/Gamepad.vala"
			_tmp16_ = _axis_it;
#line 248 "../src/utils/Gamepad.vala"
			if (!gee_iterator_next (_tmp16_)) {
#line 248 "../src/utils/Gamepad.vala"
				break;
#line 2064 "Gamepad.c"
			}
#line 248 "../src/utils/Gamepad.vala"
			_tmp17_ = _axis_it;
#line 248 "../src/utils/Gamepad.vala"
			_tmp18_ = gee_iterator_get (_tmp17_);
#line 248 "../src/utils/Gamepad.vala"
			axis = (GameHubUtilsGamepadAxis*) _tmp18_;
#line 250 "../src/utils/Gamepad.vala"
			_tmp19_ = axis;
#line 250 "../src/utils/Gamepad.vala"
			game_hub_utils_gamepad_axis_reset (_tmp19_);
#line 248 "../src/utils/Gamepad.vala"
			_g_object_unref0 (axis);
#line 2078 "Gamepad.c"
		}
#line 248 "../src/utils/Gamepad.vala"
		_g_object_unref0 (_axis_it);
#line 2082 "Gamepad.c"
	}
}

void
game_hub_utils_gamepad_emit_key_event (guint key_code,
                                       gboolean press)
{
	GList* _tmp0_;
#line 257 "../src/utils/Gamepad.vala"
	if (key_code == ((guint) 0)) {
#line 257 "../src/utils/Gamepad.vala"
		return;
#line 2095 "Gamepad.c"
	}
#line 258 "../src/utils/Gamepad.vala"
	_tmp0_ = gtk_window_list_toplevels ();
#line 2099 "Gamepad.c"
	{
		GList* wnd_collection = NULL;
		GList* wnd_it = NULL;
#line 258 "../src/utils/Gamepad.vala"
		wnd_collection = _tmp0_;
#line 258 "../src/utils/Gamepad.vala"
		for (wnd_it = wnd_collection; wnd_it != NULL; wnd_it = wnd_it->next) {
#line 2107 "Gamepad.c"
			GtkWindow* wnd = NULL;
#line 258 "../src/utils/Gamepad.vala"
			wnd = (GtkWindow*) wnd_it->data;
#line 2111 "Gamepad.c"
			{
				GtkWindow* _tmp1_;
				gboolean _tmp2_;
				gboolean _tmp3_;
#line 260 "../src/utils/Gamepad.vala"
				_tmp1_ = wnd;
#line 260 "../src/utils/Gamepad.vala"
				g_object_get (_tmp1_, "is-active", &_tmp2_, NULL);
#line 260 "../src/utils/Gamepad.vala"
				_tmp3_ = _tmp2_;
#line 260 "../src/utils/Gamepad.vala"
				if (_tmp3_) {
#line 2124 "Gamepad.c"
					Display* xdisplay = NULL;
					GtkWindow* _tmp4_;
					GdkScreen* _tmp5_;
					GdkScreen* _tmp6_;
					GdkDisplay* _tmp7_;
					Display* _tmp8_;
					Display* _tmp9_;
					Display* _tmp10_;
#line 262 "../src/utils/Gamepad.vala"
					_tmp4_ = wnd;
#line 262 "../src/utils/Gamepad.vala"
					_tmp5_ = gtk_window_get_screen (_tmp4_);
#line 262 "../src/utils/Gamepad.vala"
					_tmp6_ = _tmp5_;
#line 262 "../src/utils/Gamepad.vala"
					_tmp7_ = gdk_screen_get_display (_tmp6_);
#line 262 "../src/utils/Gamepad.vala"
					_tmp8_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp7_) : NULL);
#line 262 "../src/utils/Gamepad.vala"
					xdisplay = _tmp8_;
#line 263 "../src/utils/Gamepad.vala"
					_tmp9_ = xdisplay;
#line 263 "../src/utils/Gamepad.vala"
					_tmp10_ = xdisplay;
#line 263 "../src/utils/Gamepad.vala"
					XTestFakeKeyEvent (_tmp9_, (guint) XKeysymToKeycode (_tmp10_, (gulong) key_code), press, CurrentTime);
#line 264 "../src/utils/Gamepad.vala"
					game_hub_utils_gamepad_ButtonPressed = TRUE;
#line 265 "../src/utils/Gamepad.vala"
					break;
#line 2155 "Gamepad.c"
				}
			}
		}
#line 258 "../src/utils/Gamepad.vala"
		(wnd_collection == NULL) ? NULL : (wnd_collection = (g_list_free (wnd_collection), NULL));
#line 2161 "Gamepad.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

