/* FileChooserEntry.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FileChooserEntry.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY (game_hub_ui_widgets_file_chooser_entry_get_type ())
#define GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, GameHubUIWidgetsFileChooserEntry))
#define GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, GameHubUIWidgetsFileChooserEntryClass))
#define GAME_HUB_UI_WIDGETS_IS_FILE_CHOOSER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY))
#define GAME_HUB_UI_WIDGETS_IS_FILE_CHOOSER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY))
#define GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, GameHubUIWidgetsFileChooserEntryClass))

typedef struct _GameHubUIWidgetsFileChooserEntry GameHubUIWidgetsFileChooserEntry;
typedef struct _GameHubUIWidgetsFileChooserEntryClass GameHubUIWidgetsFileChooserEntryClass;
typedef struct _GameHubUIWidgetsFileChooserEntryPrivate GameHubUIWidgetsFileChooserEntryPrivate;
enum  {
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_0_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_TITLE_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ACTION_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_URL_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_EXECUTABLE_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_CHOOSER_PROPERTY,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_NUM_PROPERTIES
};
static GParamSpec* game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GAME_HUB_UI_WINDOWS_TYPE_MAIN_WINDOW (game_hub_ui_windows_main_window_get_type ())
#define GAME_HUB_UI_WINDOWS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UI_WINDOWS_TYPE_MAIN_WINDOW, GameHubUIWindowsMainWindow))
#define GAME_HUB_UI_WINDOWS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UI_WINDOWS_TYPE_MAIN_WINDOW, GameHubUIWindowsMainWindowClass))
#define GAME_HUB_UI_WINDOWS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UI_WINDOWS_TYPE_MAIN_WINDOW))
#define GAME_HUB_UI_WINDOWS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UI_WINDOWS_TYPE_MAIN_WINDOW))
#define GAME_HUB_UI_WINDOWS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UI_WINDOWS_TYPE_MAIN_WINDOW, GameHubUIWindowsMainWindowClass))

typedef struct _GameHubUIWindowsMainWindow GameHubUIWindowsMainWindow;
typedef struct _GameHubUIWindowsMainWindowClass GameHubUIWindowsMainWindowClass;
enum  {
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_SET_SIGNAL,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_SET_SIGNAL,
	GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_NUM_SIGNALS
};
static guint game_hub_ui_widgets_file_chooser_entry_signals[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_NUM_SIGNALS] = {0};

struct _GameHubUIWidgetsFileChooserEntry {
	GtkEntry parent_instance;
	GameHubUIWidgetsFileChooserEntryPrivate * priv;
};

struct _GameHubUIWidgetsFileChooserEntryClass {
	GtkEntryClass parent_class;
};

struct _GameHubUIWidgetsFileChooserEntryPrivate {
	GFile* _file;
	gchar* _uri;
	gchar* _title;
	GtkFileChooserAction _action;
	gboolean _allow_url;
	gboolean _allow_executable;
	GtkFileChooser* _chooser;
};

static gint GameHubUIWidgetsFileChooserEntry_private_offset;
static gpointer game_hub_ui_widgets_file_chooser_entry_parent_class = NULL;
VALA_EXTERN GameHubUIWindowsMainWindow* game_hub_ui_windows_main_window_instance;

VALA_EXTERN GType game_hub_ui_widgets_file_chooser_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUIWidgetsFileChooserEntry, g_object_unref)
VALA_EXTERN GameHubUIWidgetsFileChooserEntry* game_hub_ui_widgets_file_chooser_entry_new (const gchar* title,
                                                                              GtkFileChooserAction action,
                                                                              const gchar* icon,
                                                                              const gchar* hint,
                                                                              gboolean allow_url,
                                                                              gboolean allow_executable);
VALA_EXTERN GameHubUIWidgetsFileChooserEntry* game_hub_ui_widgets_file_chooser_entry_construct (GType object_type,
                                                                                    const gchar* title,
                                                                                    GtkFileChooserAction action,
                                                                                    const gchar* icon,
                                                                                    const gchar* hint,
                                                                                    gboolean allow_url,
                                                                                    gboolean allow_executable);
static gboolean game_hub_ui_widgets_file_chooser_entry_get_directory_mode (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN void game_hub_ui_widgets_file_chooser_entry_select_file_path (GameHubUIWidgetsFileChooserEntry* self,
                                                              const gchar* path_or_uri);
VALA_EXTERN GtkFileChooser* game_hub_ui_widgets_file_chooser_entry_get_chooser (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN void game_hub_ui_widgets_file_chooser_entry_set_file (GameHubUIWidgetsFileChooserEntry* self,
                                                      GFile* value);
VALA_EXTERN void game_hub_ui_widgets_file_chooser_entry_set_uri (GameHubUIWidgetsFileChooserEntry* self,
                                                     const gchar* value);
VALA_EXTERN gboolean game_hub_ui_widgets_file_chooser_entry_get_allow_url (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN const gchar* game_hub_ui_widgets_file_chooser_entry_get_uri (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN GFile* game_hub_utils_fs_utils_file (const gchar* path,
                                     const gchar* file,
                                     GeeHashMap* variables);
VALA_EXTERN GFile* game_hub_ui_widgets_file_chooser_entry_get_file (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN gboolean game_hub_ui_widgets_file_chooser_entry_get_allow_executable (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN GFile* game_hub_utils_find_executable (const gchar* name);
static void game_hub_ui_widgets_file_chooser_entry_scroll_to_end (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN void game_hub_ui_widgets_file_chooser_entry_select_file (GameHubUIWidgetsFileChooserEntry* self,
                                                         GFile* f);
VALA_EXTERN void game_hub_ui_widgets_file_chooser_entry_set_default_directory (GameHubUIWidgetsFileChooserEntry* self,
                                                                   GFile* directory);
VALA_EXTERN void game_hub_ui_widgets_file_chooser_entry_reset (GameHubUIWidgetsFileChooserEntry* self);
static gint game_hub_ui_widgets_file_chooser_entry_run_chooser (GameHubUIWidgetsFileChooserEntry* self);
VALA_EXTERN const gchar* game_hub_ui_widgets_file_chooser_entry_get_title (GameHubUIWidgetsFileChooserEntry* self);
static void game_hub_ui_widgets_file_chooser_entry_set_title (GameHubUIWidgetsFileChooserEntry* self,
                                                       const gchar* value);
VALA_EXTERN GtkFileChooserAction game_hub_ui_widgets_file_chooser_entry_get_action (GameHubUIWidgetsFileChooserEntry* self);
static void game_hub_ui_widgets_file_chooser_entry_set_action (GameHubUIWidgetsFileChooserEntry* self,
                                                        GtkFileChooserAction value);
static void game_hub_ui_widgets_file_chooser_entry_set_allow_url (GameHubUIWidgetsFileChooserEntry* self,
                                                           gboolean value);
static void game_hub_ui_widgets_file_chooser_entry_set_allow_executable (GameHubUIWidgetsFileChooserEntry* self,
                                                                  gboolean value);
VALA_EXTERN void game_hub_ui_widgets_file_chooser_entry_set_chooser (GameHubUIWidgetsFileChooserEntry* self,
                                                         GtkFileChooser* value);
static GObject * game_hub_ui_widgets_file_chooser_entry_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
VALA_EXTERN GType game_hub_ui_windows_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUIWindowsMainWindow, g_object_unref)
static void _game_hub_ui_widgets_file_chooser_entry___lambda70_ (GameHubUIWidgetsFileChooserEntry* self);
static void __game_hub_ui_widgets_file_chooser_entry___lambda70__gtk_entry_activate (GtkEntry* _sender,
                                                                              gpointer self);
static gboolean _game_hub_ui_widgets_file_chooser_entry___lambda71_ (GameHubUIWidgetsFileChooserEntry* self);
static gboolean __game_hub_ui_widgets_file_chooser_entry___lambda71__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                          GdkEventFocus* event,
                                                                                          gpointer self);
static void _game_hub_ui_widgets_file_chooser_entry___lambda72_ (GameHubUIWidgetsFileChooserEntry* self,
                                                          GtkEntryIconPosition icon,
                                                          GdkEvent* event);
static void __game_hub_ui_widgets_file_chooser_entry___lambda72__gtk_entry_icon_press (GtkEntry* _sender,
                                                                                GtkEntryIconPosition icon_pos,
                                                                                GdkEvent* event,
                                                                                gpointer self);
static void game_hub_ui_widgets_file_chooser_entry_finalize (GObject * obj);
static GType game_hub_ui_widgets_file_chooser_entry_get_type_once (void);
static void _vala_game_hub_ui_widgets_file_chooser_entry_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_game_hub_ui_widgets_file_chooser_entry_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);

static inline gpointer
game_hub_ui_widgets_file_chooser_entry_get_instance_private (GameHubUIWidgetsFileChooserEntry* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubUIWidgetsFileChooserEntry_private_offset);
}

GameHubUIWidgetsFileChooserEntry*
game_hub_ui_widgets_file_chooser_entry_construct (GType object_type,
                                                  const gchar* title,
                                                  GtkFileChooserAction action,
                                                  const gchar* icon,
                                                  const gchar* hint,
                                                  gboolean allow_url,
                                                  gboolean allow_executable)
{
	GameHubUIWidgetsFileChooserEntry * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_;
	gboolean _tmp6_;
#line 43 "../src/ui/widgets/FileChooserEntry.vala"
	self = (GameHubUIWidgetsFileChooserEntry*) g_object_new (object_type, "title", title, "action", action, "allow-url", allow_url, "allow-executable", allow_executable, NULL);
#line 44 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_set ((GtkEntry*) self, "primary-icon-tooltip-text", hint, NULL);
#line 44 "../src/ui/widgets/FileChooserEntry.vala"
	gtk_entry_set_placeholder_text ((GtkEntry*) self, hint);
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = icon;
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp0_ == NULL) {
#line 226 "FileChooserEntry.c"
		const gchar* _tmp1_ = NULL;
		gboolean _tmp2_;
		gboolean _tmp3_;
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp2_ = game_hub_ui_widgets_file_chooser_entry_get_directory_mode (self);
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp3_ = _tmp2_;
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
		if (_tmp3_) {
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp1_ = "folder";
#line 238 "FileChooserEntry.c"
		} else {
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp1_ = "application-x-executable";
#line 242 "FileChooserEntry.c"
		}
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = _tmp1_;
#line 246 "FileChooserEntry.c"
	}
#line 45 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_set ((GtkEntry*) self, "primary-icon-name", _tmp0_, NULL);
#line 46 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_set ((GtkEntry*) self, "primary-icon-activatable", FALSE, NULL);
#line 47 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_set ((GtkEntry*) self, "secondary-icon-name", "folder-symbolic", NULL);
#line 48 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_set ((GtkEntry*) self, "secondary-icon-activatable", TRUE, NULL);
#line 49 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp5_ = game_hub_ui_widgets_file_chooser_entry_get_directory_mode (self);
#line 49 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp6_ = _tmp5_;
#line 49 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp6_) {
#line 49 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp4_ = _ ("Select directory");
#line 264 "FileChooserEntry.c"
	} else {
#line 49 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp4_ = _ ("Select file");
#line 268 "FileChooserEntry.c"
	}
#line 49 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_set ((GtkEntry*) self, "secondary-icon-tooltip-text", _tmp4_, NULL);
#line 41 "../src/ui/widgets/FileChooserEntry.vala"
	return self;
#line 274 "FileChooserEntry.c"
}

GameHubUIWidgetsFileChooserEntry*
game_hub_ui_widgets_file_chooser_entry_new (const gchar* title,
                                            GtkFileChooserAction action,
                                            const gchar* icon,
                                            const gchar* hint,
                                            gboolean allow_url,
                                            gboolean allow_executable)
{
#line 41 "../src/ui/widgets/FileChooserEntry.vala"
	return game_hub_ui_widgets_file_chooser_entry_construct (GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, title, action, icon, hint, allow_url, allow_executable);
#line 287 "FileChooserEntry.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 308 "FileChooserEntry.c"
}

void
game_hub_ui_widgets_file_chooser_entry_select_file_path (GameHubUIWidgetsFileChooserEntry* self,
                                                         const gchar* path_or_uri)
{
	gboolean _tmp0_ = FALSE;
	gchar* path = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	GFile* _tmp49_;
	gboolean _tmp59_;
	GError* _inner_error0_ = NULL;
#line 79 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
	if (path_or_uri == NULL) {
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = TRUE;
#line 329 "FileChooserEntry.c"
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp1_ = string_strip (path_or_uri);
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp2_ = _tmp1_;
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp3_ = strlen (_tmp2_);
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp4_ = _tmp3_;
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = _tmp4_ == 0;
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
		_g_free0 (_tmp2_);
#line 347 "FileChooserEntry.c"
	}
#line 81 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp0_) {
#line 351 "FileChooserEntry.c"
		GtkFileChooser* _tmp5_;
#line 83 "../src/ui/widgets/FileChooserEntry.vala"
		gtk_entry_set_text ((GtkEntry*) self, "");
#line 84 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp5_ = self->priv->_chooser;
#line 84 "../src/ui/widgets/FileChooserEntry.vala"
		gtk_file_chooser_unselect_all (_tmp5_);
#line 85 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_file (self, NULL);
#line 86 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_uri (self, NULL);
#line 87 "../src/ui/widgets/FileChooserEntry.vala"
		g_signal_emit (self, game_hub_ui_widgets_file_chooser_entry_signals[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_SET_SIGNAL], 0);
#line 88 "../src/ui/widgets/FileChooserEntry.vala"
		g_signal_emit (self, game_hub_ui_widgets_file_chooser_entry_signals[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_SET_SIGNAL], 0);
#line 89 "../src/ui/widgets/FileChooserEntry.vala"
		return;
#line 369 "FileChooserEntry.c"
	}
#line 92 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp6_ = string_strip (path_or_uri);
#line 92 "../src/ui/widgets/FileChooserEntry.vala"
	path = _tmp6_;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp8_ = self->priv->_allow_url;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp8_) {
#line 379 "FileChooserEntry.c"
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp12_ = path;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
		if (g_str_has_prefix (_tmp12_, "file://")) {
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp11_ = TRUE;
#line 390 "FileChooserEntry.c"
		} else {
			const gchar* _tmp13_;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp13_ = path;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp11_ = g_str_has_prefix (_tmp13_, "https://");
#line 397 "FileChooserEntry.c"
		}
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
		if (_tmp11_) {
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp10_ = TRUE;
#line 403 "FileChooserEntry.c"
		} else {
			const gchar* _tmp14_;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp14_ = path;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp10_ = g_str_has_prefix (_tmp14_, "http://");
#line 410 "FileChooserEntry.c"
		}
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
		if (_tmp10_) {
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp9_ = TRUE;
#line 416 "FileChooserEntry.c"
		} else {
			const gchar* _tmp15_;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp15_ = path;
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp9_ = g_str_has_prefix (_tmp15_, "ftp://");
#line 423 "FileChooserEntry.c"
		}
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp7_ = _tmp9_;
#line 427 "FileChooserEntry.c"
	} else {
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp7_ = FALSE;
#line 431 "FileChooserEntry.c"
	}
#line 94 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp7_) {
#line 435 "FileChooserEntry.c"
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 96 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp16_ = path;
#line 96 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_uri (self, _tmp16_);
#line 97 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp17_ = gtk_entry_get_text ((GtkEntry*) self);
#line 97 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp18_ = _tmp17_;
#line 97 "../src/ui/widgets/FileChooserEntry.vala"
		if (g_str_has_prefix (_tmp18_, "file://")) {
#line 449 "FileChooserEntry.c"
			const gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
#line 99 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp19_ = self->priv->_uri;
#line 99 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp20_ = g_file_new_for_uri (_tmp19_);
#line 99 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp21_ = _tmp20_;
#line 99 "../src/ui/widgets/FileChooserEntry.vala"
			game_hub_ui_widgets_file_chooser_entry_set_file (self, _tmp21_);
#line 99 "../src/ui/widgets/FileChooserEntry.vala"
			_g_object_unref0 (_tmp21_);
#line 463 "FileChooserEntry.c"
		}
	} else {
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_;
#line 102 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp23_ = path;
#line 102 "../src/ui/widgets/FileChooserEntry.vala"
		if (g_str_has_prefix (_tmp23_, "/")) {
#line 102 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp22_ = TRUE;
#line 474 "FileChooserEntry.c"
		} else {
			const gchar* _tmp24_;
#line 102 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp24_ = path;
#line 102 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp22_ = g_str_has_prefix (_tmp24_, "~");
#line 481 "FileChooserEntry.c"
		}
#line 102 "../src/ui/widgets/FileChooserEntry.vala"
		if (_tmp22_) {
#line 485 "FileChooserEntry.c"
			const gchar* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
#line 104 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp25_ = path;
#line 104 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp26_ = game_hub_utils_fs_utils_file (_tmp25_, NULL, NULL);
#line 104 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp27_ = _tmp26_;
#line 104 "../src/ui/widgets/FileChooserEntry.vala"
			game_hub_ui_widgets_file_chooser_entry_set_file (self, _tmp27_);
#line 104 "../src/ui/widgets/FileChooserEntry.vala"
			_g_object_unref0 (_tmp27_);
#line 105 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp28_ = self->priv->_file;
#line 105 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp29_ = g_file_get_uri (_tmp28_);
#line 105 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp30_ = _tmp29_;
#line 105 "../src/ui/widgets/FileChooserEntry.vala"
			game_hub_ui_widgets_file_chooser_entry_set_uri (self, _tmp30_);
#line 105 "../src/ui/widgets/FileChooserEntry.vala"
			_g_free0 (_tmp30_);
#line 512 "FileChooserEntry.c"
		} else {
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_;
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp32_ = self->priv->_allow_executable;
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
			if (_tmp32_) {
#line 520 "FileChooserEntry.c"
				const gchar* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp33_ = path;
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp34_ = strlen (_tmp33_);
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp35_ = _tmp34_;
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp31_ = _tmp35_ > 0;
#line 532 "FileChooserEntry.c"
			} else {
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp31_ = FALSE;
#line 536 "FileChooserEntry.c"
			}
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
			if (_tmp31_) {
#line 540 "FileChooserEntry.c"
				GFile* executable = NULL;
				const gchar* _tmp36_;
				GFile* _tmp37_;
				gboolean _tmp38_ = FALSE;
				GFile* _tmp39_;
				GFile* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
#line 109 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp36_ = path;
#line 109 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp37_ = game_hub_utils_find_executable (_tmp36_);
#line 109 "../src/ui/widgets/FileChooserEntry.vala"
				executable = _tmp37_;
#line 110 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp39_ = executable;
#line 110 "../src/ui/widgets/FileChooserEntry.vala"
				if (_tmp39_ != NULL) {
#line 559 "FileChooserEntry.c"
					GFile* _tmp40_;
#line 110 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp40_ = executable;
#line 110 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp38_ = g_file_query_exists (_tmp40_, NULL);
#line 565 "FileChooserEntry.c"
				} else {
#line 110 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp38_ = FALSE;
#line 569 "FileChooserEntry.c"
				}
#line 110 "../src/ui/widgets/FileChooserEntry.vala"
				if (_tmp38_) {
#line 573 "FileChooserEntry.c"
					GFile* _tmp41_;
#line 112 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp41_ = executable;
#line 112 "../src/ui/widgets/FileChooserEntry.vala"
					game_hub_ui_widgets_file_chooser_entry_set_file (self, _tmp41_);
#line 579 "FileChooserEntry.c"
				} else {
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					GFile* _tmp44_;
					GFile* _tmp45_;
#line 116 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp42_ = gtk_entry_get_text ((GtkEntry*) self);
#line 116 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp43_ = _tmp42_;
#line 116 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp44_ = game_hub_utils_fs_utils_file ("/usr/bin", _tmp43_, NULL);
#line 116 "../src/ui/widgets/FileChooserEntry.vala"
					_tmp45_ = _tmp44_;
#line 116 "../src/ui/widgets/FileChooserEntry.vala"
					game_hub_ui_widgets_file_chooser_entry_set_file (self, _tmp45_);
#line 116 "../src/ui/widgets/FileChooserEntry.vala"
					_g_object_unref0 (_tmp45_);
#line 597 "FileChooserEntry.c"
				}
#line 118 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp46_ = self->priv->_file;
#line 118 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp47_ = g_file_get_uri (_tmp46_);
#line 118 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp48_ = _tmp47_;
#line 118 "../src/ui/widgets/FileChooserEntry.vala"
				game_hub_ui_widgets_file_chooser_entry_set_uri (self, _tmp48_);
#line 118 "../src/ui/widgets/FileChooserEntry.vala"
				_g_free0 (_tmp48_);
#line 107 "../src/ui/widgets/FileChooserEntry.vala"
				_g_object_unref0 (executable);
#line 611 "FileChooserEntry.c"
			}
		}
	}
#line 121 "../src/ui/widgets/FileChooserEntry.vala"
	gtk_entry_set_text ((GtkEntry*) self, "");
#line 123 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp49_ = self->priv->_file;
#line 123 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp49_ != NULL) {
#line 621 "FileChooserEntry.c"
		GFile* _tmp50_;
		GFile* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
#line 125 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp50_ = self->priv->_file;
#line 125 "../src/ui/widgets/FileChooserEntry.vala"
		if (g_file_query_exists (_tmp50_, NULL)) {
#line 630 "FileChooserEntry.c"
			{
				GtkFileChooser* _tmp51_;
				GFile* _tmp52_;
#line 129 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp51_ = self->priv->_chooser;
#line 129 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp52_ = self->priv->_file;
#line 129 "../src/ui/widgets/FileChooserEntry.vala"
				gtk_file_chooser_select_file (_tmp51_, _tmp52_, &_inner_error0_);
#line 129 "../src/ui/widgets/FileChooserEntry.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 642 "FileChooserEntry.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp53_;
				const gchar* _tmp54_;
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
				e = _inner_error0_;
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
				_inner_error0_ = NULL;
#line 133 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp53_ = e;
#line 133 "../src/ui/widgets/FileChooserEntry.vala"
				_tmp54_ = _tmp53_->message;
#line 133 "../src/ui/widgets/FileChooserEntry.vala"
				g_warning ("FileChooserEntry.vala:133: [FileChooserEntry.select_file_path] %s", _tmp54_);
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
				_g_error_free0 (e);
#line 664 "FileChooserEntry.c"
			}
			__finally0:
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
				_g_free0 (path);
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
				g_clear_error (&_inner_error0_);
#line 127 "../src/ui/widgets/FileChooserEntry.vala"
				return;
#line 677 "FileChooserEntry.c"
			}
		} else {
			GtkFileChooser* _tmp55_;
#line 138 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp55_ = self->priv->_chooser;
#line 138 "../src/ui/widgets/FileChooserEntry.vala"
			gtk_file_chooser_unselect_all (_tmp55_);
#line 685 "FileChooserEntry.c"
		}
#line 140 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp56_ = self->priv->_file;
#line 140 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp57_ = g_file_get_path (_tmp56_);
#line 140 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp58_ = _tmp57_;
#line 140 "../src/ui/widgets/FileChooserEntry.vala"
		gtk_entry_set_text ((GtkEntry*) self, _tmp58_);
#line 140 "../src/ui/widgets/FileChooserEntry.vala"
		_g_free0 (_tmp58_);
#line 697 "FileChooserEntry.c"
	}
#line 143 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp59_ = self->priv->_allow_url;
#line 143 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp59_) {
#line 703 "FileChooserEntry.c"
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_;
#line 145 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp61_ = self->priv->_uri;
#line 145 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp60_ = _tmp61_;
#line 145 "../src/ui/widgets/FileChooserEntry.vala"
		if (_tmp60_ == NULL) {
#line 145 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp60_ = "";
#line 714 "FileChooserEntry.c"
		}
#line 145 "../src/ui/widgets/FileChooserEntry.vala"
		gtk_entry_set_text ((GtkEntry*) self, _tmp60_);
#line 718 "FileChooserEntry.c"
	}
#line 148 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_scroll_to_end (self);
#line 150 "../src/ui/widgets/FileChooserEntry.vala"
	g_signal_emit (self, game_hub_ui_widgets_file_chooser_entry_signals[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_SET_SIGNAL], 0);
#line 151 "../src/ui/widgets/FileChooserEntry.vala"
	g_signal_emit (self, game_hub_ui_widgets_file_chooser_entry_signals[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_SET_SIGNAL], 0);
#line 79 "../src/ui/widgets/FileChooserEntry.vala"
	_g_free0 (path);
#line 728 "FileChooserEntry.c"
}

void
game_hub_ui_widgets_file_chooser_entry_select_file (GameHubUIWidgetsFileChooserEntry* self,
                                                    GFile* f)
{
	gchar* _tmp0_ = NULL;
#line 154 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 156 "../src/ui/widgets/FileChooserEntry.vala"
	if (f != NULL) {
#line 740 "FileChooserEntry.c"
		gchar* _tmp1_;
#line 156 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp1_ = g_file_get_path (f);
#line 156 "../src/ui/widgets/FileChooserEntry.vala"
		_g_free0 (_tmp0_);
#line 156 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = _tmp1_;
#line 748 "FileChooserEntry.c"
	} else {
#line 156 "../src/ui/widgets/FileChooserEntry.vala"
		_g_free0 (_tmp0_);
#line 156 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = NULL;
#line 754 "FileChooserEntry.c"
	}
#line 156 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_select_file_path (self, _tmp0_);
#line 154 "../src/ui/widgets/FileChooserEntry.vala"
	_g_free0 (_tmp0_);
#line 760 "FileChooserEntry.c"
}

void
game_hub_ui_widgets_file_chooser_entry_set_default_directory (GameHubUIWidgetsFileChooserEntry* self,
                                                              GFile* directory)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 159 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 161 "../src/ui/widgets/FileChooserEntry.vala"
	if (directory != NULL) {
#line 161 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = g_file_query_exists (directory, NULL);
#line 775 "FileChooserEntry.c"
	} else {
#line 161 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = FALSE;
#line 779 "FileChooserEntry.c"
	}
#line 161 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp0_) {
#line 783 "FileChooserEntry.c"
		{
			GtkFileChooser* _tmp1_;
#line 165 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp1_ = self->priv->_chooser;
#line 165 "../src/ui/widgets/FileChooserEntry.vala"
			gtk_file_chooser_set_current_folder_file (_tmp1_, directory, &_inner_error0_);
#line 165 "../src/ui/widgets/FileChooserEntry.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 792 "FileChooserEntry.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
#line 163 "../src/ui/widgets/FileChooserEntry.vala"
			e = _inner_error0_;
#line 163 "../src/ui/widgets/FileChooserEntry.vala"
			_inner_error0_ = NULL;
#line 169 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp2_ = e;
#line 169 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp3_ = _tmp2_->message;
#line 169 "../src/ui/widgets/FileChooserEntry.vala"
			g_warning ("FileChooserEntry.vala:169: [FileChooserEntry.set_default_directory] %s", _tmp3_);
#line 163 "../src/ui/widgets/FileChooserEntry.vala"
			_g_error_free0 (e);
#line 814 "FileChooserEntry.c"
		}
		__finally0:
#line 163 "../src/ui/widgets/FileChooserEntry.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 163 "../src/ui/widgets/FileChooserEntry.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 163 "../src/ui/widgets/FileChooserEntry.vala"
			g_clear_error (&_inner_error0_);
#line 163 "../src/ui/widgets/FileChooserEntry.vala"
			return;
#line 825 "FileChooserEntry.c"
		}
	}
}

void
game_hub_ui_widgets_file_chooser_entry_reset (GameHubUIWidgetsFileChooserEntry* self)
{
#line 174 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 176 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_select_file_path (self, NULL);
#line 837 "FileChooserEntry.c"
}

static gint
game_hub_ui_widgets_file_chooser_entry_run_chooser (GameHubUIWidgetsFileChooserEntry* self)
{
	GtkFileChooser* _tmp0_;
	gint result;
#line 179 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 182 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = self->priv->_chooser;
#line 182 "../src/ui/widgets/FileChooserEntry.vala"
	result = gtk_native_dialog_run ((GtkNativeDialog*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_file_chooser_native_get_type ()) ? ((GtkFileChooserNative*) _tmp0_) : NULL));
#line 182 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 853 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_scroll_to_end (GameHubUIWidgetsFileChooserEntry* self)
{
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
#line 188 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 190 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_get ((GtkEntry*) self, "cursor-position", &_tmp0_, NULL);
#line 190 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp1_ = _tmp0_;
#line 190 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) self);
#line 190 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp3_ = _tmp2_;
#line 190 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp4_ = strlen (_tmp3_);
#line 190 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp5_ = _tmp4_;
#line 190 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp1_ < _tmp5_) {
#line 192 "../src/ui/widgets/FileChooserEntry.vala"
		g_signal_emit_by_name ((GtkEntry*) self, "move-cursor", GTK_MOVEMENT_BUFFER_ENDS, 1, FALSE);
#line 883 "FileChooserEntry.c"
	}
}

GFile*
game_hub_ui_widgets_file_chooser_entry_get_file (GameHubUIWidgetsFileChooserEntry* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = self->priv->_file;
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	result = _tmp0_;
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 900 "FileChooserEntry.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	return self ? g_object_ref (self) : NULL;
#line 908 "FileChooserEntry.c"
}

void
game_hub_ui_widgets_file_chooser_entry_set_file (GameHubUIWidgetsFileChooserEntry* self,
                                                 GFile* value)
{
	GFile* old_value;
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	old_value = game_hub_ui_widgets_file_chooser_entry_get_file (self);
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	if (old_value != value) {
#line 922 "FileChooserEntry.c"
		GFile* _tmp0_;
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
		_g_object_unref0 (self->priv->_file);
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
		self->priv->_file = _tmp0_;
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_PROPERTY]);
#line 932 "FileChooserEntry.c"
	}
}

const gchar*
game_hub_ui_widgets_file_chooser_entry_get_uri (GameHubUIWidgetsFileChooserEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = self->priv->_uri;
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	result = _tmp0_;
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 949 "FileChooserEntry.c"
}

void
game_hub_ui_widgets_file_chooser_entry_set_uri (GameHubUIWidgetsFileChooserEntry* self,
                                                const gchar* value)
{
	gchar* old_value;
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	old_value = game_hub_ui_widgets_file_chooser_entry_get_uri (self);
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 963 "FileChooserEntry.c"
		gchar* _tmp0_;
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = g_strdup (value);
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
		_g_free0 (self->priv->_uri);
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
		self->priv->_uri = _tmp0_;
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_PROPERTY]);
#line 973 "FileChooserEntry.c"
	}
}

const gchar*
game_hub_ui_widgets_file_chooser_entry_get_title (GameHubUIWidgetsFileChooserEntry* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = self->priv->_title;
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	result = _tmp0_;
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 990 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_set_title (GameHubUIWidgetsFileChooserEntry* self,
                                                  const gchar* value)
{
	gchar* old_value;
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	old_value = game_hub_ui_widgets_file_chooser_entry_get_title (self);
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1004 "FileChooserEntry.c"
		gchar* _tmp0_;
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = g_strdup (value);
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
		_g_free0 (self->priv->_title);
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
		self->priv->_title = _tmp0_;
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_TITLE_PROPERTY]);
#line 1014 "FileChooserEntry.c"
	}
}

GtkFileChooserAction
game_hub_ui_widgets_file_chooser_entry_get_action (GameHubUIWidgetsFileChooserEntry* self)
{
	GtkFileChooserAction result;
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
	result = self->priv->_action;
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 1028 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_set_action (GameHubUIWidgetsFileChooserEntry* self,
                                                   GtkFileChooserAction value)
{
	GtkFileChooserAction old_value;
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
	old_value = game_hub_ui_widgets_file_chooser_entry_get_action (self);
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
	if (old_value != value) {
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
		self->priv->_action = value;
#line 35 "../src/ui/widgets/FileChooserEntry.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ACTION_PROPERTY]);
#line 1046 "FileChooserEntry.c"
	}
}

gboolean
game_hub_ui_widgets_file_chooser_entry_get_allow_url (GameHubUIWidgetsFileChooserEntry* self)
{
	gboolean result;
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
	result = self->priv->_allow_url;
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 1060 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_set_allow_url (GameHubUIWidgetsFileChooserEntry* self,
                                                      gboolean value)
{
	gboolean old_value;
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
	old_value = game_hub_ui_widgets_file_chooser_entry_get_allow_url (self);
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
	if (old_value != value) {
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
		self->priv->_allow_url = value;
#line 36 "../src/ui/widgets/FileChooserEntry.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_URL_PROPERTY]);
#line 1078 "FileChooserEntry.c"
	}
}

gboolean
game_hub_ui_widgets_file_chooser_entry_get_allow_executable (GameHubUIWidgetsFileChooserEntry* self)
{
	gboolean result;
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
	result = self->priv->_allow_executable;
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 1092 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_set_allow_executable (GameHubUIWidgetsFileChooserEntry* self,
                                                             gboolean value)
{
	gboolean old_value;
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
	old_value = game_hub_ui_widgets_file_chooser_entry_get_allow_executable (self);
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
	if (old_value != value) {
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
		self->priv->_allow_executable = value;
#line 37 "../src/ui/widgets/FileChooserEntry.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_EXECUTABLE_PROPERTY]);
#line 1110 "FileChooserEntry.c"
	}
}

GtkFileChooser*
game_hub_ui_widgets_file_chooser_entry_get_chooser (GameHubUIWidgetsFileChooserEntry* self)
{
	GtkFileChooser* result;
	GtkFileChooser* _tmp0_;
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = self->priv->_chooser;
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	result = _tmp0_;
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 1127 "FileChooserEntry.c"
}

void
game_hub_ui_widgets_file_chooser_entry_set_chooser (GameHubUIWidgetsFileChooserEntry* self,
                                                    GtkFileChooser* value)
{
	GtkFileChooser* old_value;
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (self != NULL);
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	old_value = game_hub_ui_widgets_file_chooser_entry_get_chooser (self);
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	if (old_value != value) {
#line 1141 "FileChooserEntry.c"
		GtkFileChooser* _tmp0_;
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
		_g_object_unref0 (self->priv->_chooser);
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
		self->priv->_chooser = _tmp0_;
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_CHOOSER_PROPERTY]);
#line 1151 "FileChooserEntry.c"
	}
}

static gboolean
game_hub_ui_widgets_file_chooser_entry_get_directory_mode (GameHubUIWidgetsFileChooserEntry* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GtkFileChooserAction _tmp1_;
#line 198 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 200 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp1_ = self->priv->_action;
#line 200 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp1_ == GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER) {
#line 200 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = TRUE;
#line 1169 "FileChooserEntry.c"
	} else {
		GtkFileChooserAction _tmp2_;
#line 200 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp2_ = self->priv->_action;
#line 200 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = _tmp2_ == GTK_FILE_CHOOSER_ACTION_CREATE_FOLDER;
#line 1176 "FileChooserEntry.c"
	}
#line 200 "../src/ui/widgets/FileChooserEntry.vala"
	result = _tmp0_;
#line 200 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 1182 "FileChooserEntry.c"
}

static void
_game_hub_ui_widgets_file_chooser_entry___lambda70_ (GameHubUIWidgetsFileChooserEntry* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 61 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
#line 61 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp1_ = _tmp0_;
#line 61 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_select_file_path (self, _tmp1_);
#line 1196 "FileChooserEntry.c"
}

static void
__game_hub_ui_widgets_file_chooser_entry___lambda70__gtk_entry_activate (GtkEntry* _sender,
                                                                         gpointer self)
{
#line 60 "../src/ui/widgets/FileChooserEntry.vala"
	_game_hub_ui_widgets_file_chooser_entry___lambda70_ ((GameHubUIWidgetsFileChooserEntry*) self);
#line 1205 "FileChooserEntry.c"
}

static gboolean
_game_hub_ui_widgets_file_chooser_entry___lambda71_ (GameHubUIWidgetsFileChooserEntry* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
#line 64 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) self);
#line 64 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp1_ = _tmp0_;
#line 64 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_select_file_path (self, _tmp1_);
#line 65 "../src/ui/widgets/FileChooserEntry.vala"
	result = FALSE;
#line 65 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 1224 "FileChooserEntry.c"
}

static gboolean
__game_hub_ui_widgets_file_chooser_entry___lambda71__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                 GdkEventFocus* event,
                                                                                 gpointer self)
{
	gboolean result;
	result = _game_hub_ui_widgets_file_chooser_entry___lambda71_ ((GameHubUIWidgetsFileChooserEntry*) self);
#line 63 "../src/ui/widgets/FileChooserEntry.vala"
	return result;
#line 1236 "FileChooserEntry.c"
}

static void
_game_hub_ui_widgets_file_chooser_entry___lambda72_ (GameHubUIWidgetsFileChooserEntry* self,
                                                     GtkEntryIconPosition icon,
                                                     GdkEvent* event)
{
	gboolean _tmp0_ = FALSE;
#line 68 "../src/ui/widgets/FileChooserEntry.vala"
	g_return_if_fail (event != NULL);
#line 69 "../src/ui/widgets/FileChooserEntry.vala"
	if (icon == GTK_ENTRY_ICON_SECONDARY) {
#line 69 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = ((GdkEventButton*) event)->button == ((guint) 1);
#line 1251 "FileChooserEntry.c"
	} else {
#line 69 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = FALSE;
#line 1255 "FileChooserEntry.c"
	}
#line 69 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp0_) {
#line 71 "../src/ui/widgets/FileChooserEntry.vala"
		if (game_hub_ui_widgets_file_chooser_entry_run_chooser (self) == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 1261 "FileChooserEntry.c"
			GtkFileChooser* _tmp1_;
			GFile* _tmp2_;
			GFile* _tmp3_;
#line 73 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp1_ = self->priv->_chooser;
#line 73 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp2_ = gtk_file_chooser_get_file (_tmp1_);
#line 73 "../src/ui/widgets/FileChooserEntry.vala"
			_tmp3_ = _tmp2_;
#line 73 "../src/ui/widgets/FileChooserEntry.vala"
			game_hub_ui_widgets_file_chooser_entry_select_file (self, _tmp3_);
#line 73 "../src/ui/widgets/FileChooserEntry.vala"
			_g_object_unref0 (_tmp3_);
#line 1275 "FileChooserEntry.c"
		}
	}
}

static void
__game_hub_ui_widgets_file_chooser_entry___lambda72__gtk_entry_icon_press (GtkEntry* _sender,
                                                                           GtkEntryIconPosition icon_pos,
                                                                           GdkEvent* event,
                                                                           gpointer self)
{
#line 68 "../src/ui/widgets/FileChooserEntry.vala"
	_game_hub_ui_widgets_file_chooser_entry___lambda72_ ((GameHubUIWidgetsFileChooserEntry*) self, icon_pos, event);
#line 1288 "FileChooserEntry.c"
}

static GObject *
game_hub_ui_widgets_file_chooser_entry_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameHubUIWidgetsFileChooserEntry * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GameHubUIWindowsMainWindow* _tmp2_;
	GtkFileChooserAction _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkFileChooserNative* _tmp5_;
#line 52 "../src/ui/widgets/FileChooserEntry.vala"
	parent_class = G_OBJECT_CLASS (game_hub_ui_widgets_file_chooser_entry_parent_class);
#line 52 "../src/ui/widgets/FileChooserEntry.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 52 "../src/ui/widgets/FileChooserEntry.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, GameHubUIWidgetsFileChooserEntry);
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp1_ = self->priv->_title;
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp0_ = _tmp1_;
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	if (_tmp0_ == NULL) {
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
		_tmp0_ = _ ("Select file");
#line 1319 "FileChooserEntry.c"
	}
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp2_ = game_hub_ui_windows_main_window_instance;
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp3_ = self->priv->_action;
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp4_ = gtk_file_chooser_native_new (_tmp0_, (GtkWindow*) _tmp2_, _tmp3_, _ ("Select"), _ ("Cancel"));
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	_tmp5_ = _tmp4_;
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_set_chooser (self, (GtkFileChooser*) _tmp5_);
#line 55 "../src/ui/widgets/FileChooserEntry.vala"
	_g_object_unref0 (_tmp5_);
#line 60 "../src/ui/widgets/FileChooserEntry.vala"
	g_signal_connect_object ((GtkEntry*) self, "activate", (GCallback) __game_hub_ui_widgets_file_chooser_entry___lambda70__gtk_entry_activate, self, 0);
#line 63 "../src/ui/widgets/FileChooserEntry.vala"
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) __game_hub_ui_widgets_file_chooser_entry___lambda71__gtk_widget_focus_out_event, self, 0);
#line 68 "../src/ui/widgets/FileChooserEntry.vala"
	g_signal_connect_object ((GtkEntry*) self, "icon-press", (GCallback) __game_hub_ui_widgets_file_chooser_entry___lambda72__gtk_entry_icon_press, self, 0);
#line 52 "../src/ui/widgets/FileChooserEntry.vala"
	return obj;
#line 1341 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_class_init (GameHubUIWidgetsFileChooserEntryClass * klass,
                                                   gpointer klass_data)
{
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_parent_class = g_type_class_peek_parent (klass);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_type_class_adjust_private_offset (klass, &GameHubUIWidgetsFileChooserEntry_private_offset);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_ui_widgets_file_chooser_entry_get_property;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_ui_widgets_file_chooser_entry_set_property;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	G_OBJECT_CLASS (klass)->constructor = game_hub_ui_widgets_file_chooser_entry_constructor;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_ui_widgets_file_chooser_entry_finalize;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_PROPERTY, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_PROPERTY, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_TITLE_PROPERTY, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ACTION_PROPERTY, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ACTION_PROPERTY] = g_param_spec_enum ("action", "action", "action", gtk_file_chooser_action_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_URL_PROPERTY, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_URL_PROPERTY] = g_param_spec_boolean ("allow-url", "allow-url", "allow-url", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_EXECUTABLE_PROPERTY, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_EXECUTABLE_PROPERTY] = g_param_spec_boolean ("allow-executable", "allow-executable", "allow-executable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_CHOOSER_PROPERTY, game_hub_ui_widgets_file_chooser_entry_properties[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_CHOOSER_PROPERTY] = g_param_spec_object ("chooser", "chooser", "chooser", gtk_file_chooser_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_signals[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_SET_SIGNAL] = g_signal_new ("file-set", GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	game_hub_ui_widgets_file_chooser_entry_signals[GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_SET_SIGNAL] = g_signal_new ("uri-set", GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1378 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_instance_init (GameHubUIWidgetsFileChooserEntry * self,
                                                      gpointer klass)
{
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	self->priv = game_hub_ui_widgets_file_chooser_entry_get_instance_private (self);
#line 1387 "FileChooserEntry.c"
}

static void
game_hub_ui_widgets_file_chooser_entry_finalize (GObject * obj)
{
	GameHubUIWidgetsFileChooserEntry * self;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, GameHubUIWidgetsFileChooserEntry);
#line 31 "../src/ui/widgets/FileChooserEntry.vala"
	_g_object_unref0 (self->priv->_file);
#line 32 "../src/ui/widgets/FileChooserEntry.vala"
	_g_free0 (self->priv->_uri);
#line 34 "../src/ui/widgets/FileChooserEntry.vala"
	_g_free0 (self->priv->_title);
#line 39 "../src/ui/widgets/FileChooserEntry.vala"
	_g_object_unref0 (self->priv->_chooser);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	G_OBJECT_CLASS (game_hub_ui_widgets_file_chooser_entry_parent_class)->finalize (obj);
#line 1406 "FileChooserEntry.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_ui_widgets_file_chooser_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubUIWidgetsFileChooserEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_ui_widgets_file_chooser_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubUIWidgetsFileChooserEntry), 0, (GInstanceInitFunc) game_hub_ui_widgets_file_chooser_entry_instance_init, NULL };
	GType game_hub_ui_widgets_file_chooser_entry_type_id;
	game_hub_ui_widgets_file_chooser_entry_type_id = g_type_register_static (gtk_entry_get_type (), "GameHubUIWidgetsFileChooserEntry", &g_define_type_info, 0);
	GameHubUIWidgetsFileChooserEntry_private_offset = g_type_add_instance_private (game_hub_ui_widgets_file_chooser_entry_type_id, sizeof (GameHubUIWidgetsFileChooserEntryPrivate));
	return game_hub_ui_widgets_file_chooser_entry_type_id;
}

GType
game_hub_ui_widgets_file_chooser_entry_get_type (void)
{
	static volatile gsize game_hub_ui_widgets_file_chooser_entry_type_id__once = 0;
	if (g_once_init_enter (&game_hub_ui_widgets_file_chooser_entry_type_id__once)) {
		GType game_hub_ui_widgets_file_chooser_entry_type_id;
		game_hub_ui_widgets_file_chooser_entry_type_id = game_hub_ui_widgets_file_chooser_entry_get_type_once ();
		g_once_init_leave (&game_hub_ui_widgets_file_chooser_entry_type_id__once, game_hub_ui_widgets_file_chooser_entry_type_id);
	}
	return game_hub_ui_widgets_file_chooser_entry_type_id__once;
}

static void
_vala_game_hub_ui_widgets_file_chooser_entry_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GameHubUIWidgetsFileChooserEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, GameHubUIWidgetsFileChooserEntry);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	switch (property_id) {
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		g_value_set_object (value, game_hub_ui_widgets_file_chooser_entry_get_file (self));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		g_value_set_string (value, game_hub_ui_widgets_file_chooser_entry_get_uri (self));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_TITLE_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		g_value_set_string (value, game_hub_ui_widgets_file_chooser_entry_get_title (self));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ACTION_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		g_value_set_enum (value, game_hub_ui_widgets_file_chooser_entry_get_action (self));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_URL_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		g_value_set_boolean (value, game_hub_ui_widgets_file_chooser_entry_get_allow_url (self));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_EXECUTABLE_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		g_value_set_boolean (value, game_hub_ui_widgets_file_chooser_entry_get_allow_executable (self));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_CHOOSER_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		g_value_set_object (value, game_hub_ui_widgets_file_chooser_entry_get_chooser (self));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 1483 "FileChooserEntry.c"
		default:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 1489 "FileChooserEntry.c"
	}
}

static void
_vala_game_hub_ui_widgets_file_chooser_entry_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GameHubUIWidgetsFileChooserEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_UI_WIDGETS_TYPE_FILE_CHOOSER_ENTRY, GameHubUIWidgetsFileChooserEntry);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
	switch (property_id) {
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_FILE_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_file (self, g_value_get_object (value));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_URI_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_uri (self, g_value_get_string (value));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_TITLE_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_title (self, g_value_get_string (value));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ACTION_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_action (self, g_value_get_enum (value));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_URL_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_allow_url (self, g_value_get_boolean (value));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_ALLOW_EXECUTABLE_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_allow_executable (self, g_value_get_boolean (value));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		case GAME_HUB_UI_WIDGETS_FILE_CHOOSER_ENTRY_CHOOSER_PROPERTY:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		game_hub_ui_widgets_file_chooser_entry_set_chooser (self, g_value_get_object (value));
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 1545 "FileChooserEntry.c"
		default:
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "../src/ui/widgets/FileChooserEntry.vala"
		break;
#line 1551 "FileChooserEntry.c"
	}
}

