/* SteamGame.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SteamGame.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <sqlite3.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_DATA_TYPE_RUNNABLE (game_hub_data_runnable_get_type ())
#define GAME_HUB_DATA_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnable))
#define GAME_HUB_DATA_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))
#define GAME_HUB_DATA_IS_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_IS_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_RUNNABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))

typedef struct _GameHubDataRunnable GameHubDataRunnable;
typedef struct _GameHubDataRunnableClass GameHubDataRunnableClass;
typedef struct _GameHubDataRunnablePrivate GameHubDataRunnablePrivate;
typedef enum  {
	GAME_HUB_DATA_PLATFORM_LINUX,
	GAME_HUB_DATA_PLATFORM_WINDOWS,
	GAME_HUB_DATA_PLATFORM_MACOS,
	GAME_HUB_DATA_PLATFORM_EMULATED
} GameHubDataPlatform;

#define GAME_HUB_DATA_TYPE_PLATFORM (game_hub_data_platform_get_type ())
typedef enum  {
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_INTERACTIVE,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC_DOWNLOAD
} GameHubDataRunnableInstallerInstallMode;

#define GAME_HUB_DATA_RUNNABLE_INSTALLER_TYPE_INSTALL_MODE (game_hub_data_runnable_installer_install_mode_get_type ())

#define GAME_HUB_DATA_TYPE_GAME (game_hub_data_game_get_type ())
#define GAME_HUB_DATA_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGame))
#define GAME_HUB_DATA_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))
#define GAME_HUB_DATA_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))

typedef struct _GameHubDataGame GameHubDataGame;
typedef struct _GameHubDataGameClass GameHubDataGameClass;
typedef struct _GameHubDataGamePrivate GameHubDataGamePrivate;

#define GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT (game_hub_data_game_achievement_get_type ())
#define GAME_HUB_DATA_GAME_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievement))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))

typedef struct _GameHubDataGameAchievement GameHubDataGameAchievement;
typedef struct _GameHubDataGameAchievementClass GameHubDataGameAchievementClass;

#define GAME_HUB_DATA_GAME_TYPE_STATUS (game_hub_data_game_status_get_type ())
#define GAME_HUB_DATA_GAME_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatus))
#define GAME_HUB_DATA_GAME_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))
#define GAME_HUB_DATA_GAME_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))

typedef struct _GameHubDataGameStatus GameHubDataGameStatus;
typedef struct _GameHubDataGameStatusClass GameHubDataGameStatusClass;

#define GAME_HUB_DATA_GAME_TYPE_OVERLAY (game_hub_data_game_overlay_get_type ())
#define GAME_HUB_DATA_GAME_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay))
#define GAME_HUB_DATA_GAME_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))
#define GAME_HUB_DATA_GAME_IS_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_IS_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))

typedef struct _GameHubDataGameOverlay GameHubDataGameOverlay;
typedef struct _GameHubDataGameOverlayClass GameHubDataGameOverlayClass;

#define GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME (game_hub_data_sources_steam_steam_game_get_type ())
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGame))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGameClass))
#define GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME))
#define GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGameClass))

typedef struct _GameHubDataSourcesSteamSteamGame GameHubDataSourcesSteamSteamGame;
typedef struct _GameHubDataSourcesSteamSteamGameClass GameHubDataSourcesSteamSteamGameClass;
typedef struct _GameHubDataSourcesSteamSteamGamePrivate GameHubDataSourcesSteamSteamGamePrivate;
enum  {
	GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_0_PROPERTY,
	GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_UPDATING_PROPERTY,
	GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_SCREENSHOTS_DIR_PROPERTY,
	GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_NUM_PROPERTIES
};
static GParamSpec* game_hub_data_sources_steam_steam_game_properties[GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAME_HUB_DATA_TYPE_GAME_SOURCE (game_hub_data_game_source_get_type ())
#define GAME_HUB_DATA_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSource))
#define GAME_HUB_DATA_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))
#define GAME_HUB_DATA_IS_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_IS_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_GAME_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))

typedef struct _GameHubDataGameSource GameHubDataGameSource;
typedef struct _GameHubDataGameSourceClass GameHubDataGameSourceClass;

#define GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM (game_hub_data_sources_steam_steam_get_type ())
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM, GameHubDataSourcesSteamSteam))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM, GameHubDataSourcesSteamSteamClass))
#define GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM))
#define GAME_HUB_DATA_SOURCES_STEAM_IS_STEAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM, GameHubDataSourcesSteamSteamClass))

typedef struct _GameHubDataSourcesSteamSteam GameHubDataSourcesSteamSteam;
typedef struct _GameHubDataSourcesSteamSteamClass GameHubDataSourcesSteamSteamClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define GAME_HUB_DATA_DB_TABLE_TYPE_FIELD (game_hub_data_db_table_field_get_type ())
#define GAME_HUB_DATA_DB_TABLE_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableField))
#define GAME_HUB_DATA_DB_TABLE_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))

typedef struct _GameHubDataDBTableField GameHubDataDBTableField;
typedef struct _GameHubDataDBTableFieldClass GameHubDataDBTableFieldClass;

#define GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG (game_hub_data_db_tables_tags_tag_get_type ())
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTag))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))

typedef struct _GameHubDataDBTablesTagsTag GameHubDataDBTablesTagsTag;
typedef struct _GameHubDataDBTablesTagsTagClass GameHubDataDBTablesTagsTagClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define GAME_HUB_UTILS_BINARY_VDF_TYPE_NODE (game_hub_utils_binary_vdf_node_get_type ())
#define GAME_HUB_UTILS_BINARY_VDF_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_BINARY_VDF_TYPE_NODE, GameHubUtilsBinaryVDFNode))
#define GAME_HUB_UTILS_BINARY_VDF_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_BINARY_VDF_TYPE_NODE, GameHubUtilsBinaryVDFNodeClass))
#define GAME_HUB_UTILS_BINARY_VDF_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_BINARY_VDF_TYPE_NODE))
#define GAME_HUB_UTILS_BINARY_VDF_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_BINARY_VDF_TYPE_NODE))
#define GAME_HUB_UTILS_BINARY_VDF_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_BINARY_VDF_TYPE_NODE, GameHubUtilsBinaryVDFNodeClass))

typedef struct _GameHubUtilsBinaryVDFNode GameHubUtilsBinaryVDFNode;
typedef struct _GameHubUtilsBinaryVDFNodeClass GameHubUtilsBinaryVDFNodeClass;

#define GAME_HUB_UTILS_BINARY_VDF_TYPE_LIST_NODE (game_hub_utils_binary_vdf_list_node_get_type ())
#define GAME_HUB_UTILS_BINARY_VDF_LIST_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_BINARY_VDF_TYPE_LIST_NODE, GameHubUtilsBinaryVDFListNode))
#define GAME_HUB_UTILS_BINARY_VDF_LIST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_BINARY_VDF_TYPE_LIST_NODE, GameHubUtilsBinaryVDFListNodeClass))
#define GAME_HUB_UTILS_BINARY_VDF_IS_LIST_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_BINARY_VDF_TYPE_LIST_NODE))
#define GAME_HUB_UTILS_BINARY_VDF_IS_LIST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_BINARY_VDF_TYPE_LIST_NODE))
#define GAME_HUB_UTILS_BINARY_VDF_LIST_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_BINARY_VDF_TYPE_LIST_NODE, GameHubUtilsBinaryVDFListNodeClass))

typedef struct _GameHubUtilsBinaryVDFListNode GameHubUtilsBinaryVDFListNode;
typedef struct _GameHubUtilsBinaryVDFListNodeClass GameHubUtilsBinaryVDFListNodeClass;
#define _game_hub_utils_binary_vdf_node_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_binary_vdf_node_unref (var), NULL)))
typedef struct _GameHubDataSourcesSteamSteamGameUpdateGameInfoData GameHubDataSourcesSteamSteamGameUpdateGameInfoData;
typedef enum  {
	GAME_HUB_DATA_GAME_STATE_UNINSTALLED,
	GAME_HUB_DATA_GAME_STATE_INSTALLED,
	GAME_HUB_DATA_GAME_STATE_DOWNLOADING,
	GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY,
	GAME_HUB_DATA_GAME_STATE_INSTALLING
} GameHubDataGameState;

#define GAME_HUB_DATA_GAME_TYPE_STATE (game_hub_data_game_state_get_type ())

#define GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD (game_hub_utils_downloader_download_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownload))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))

typedef struct _GameHubUtilsDownloaderDownload GameHubUtilsDownloaderDownload;
typedef struct _GameHubUtilsDownloaderDownloadClass GameHubUtilsDownloaderDownloadClass;
#define _game_hub_data_game_status_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_game_status_unref (var), NULL)))
typedef struct _GameHubDataSourcesSteamSteamGameInstallData GameHubDataSourcesSteamSteamGameInstallData;
typedef struct _GameHubDataSourcesSteamSteamGameRunData GameHubDataSourcesSteamSteamGameRunData;
typedef struct _GameHubDataSourcesSteamSteamGameRunWithCompatData GameHubDataSourcesSteamSteamGameRunWithCompatData;
typedef struct _GameHubDataSourcesSteamSteamGameUninstallData GameHubDataSourcesSteamSteamGameUninstallData;
typedef struct _GameHubDataGameSourcePrivate GameHubDataGameSourcePrivate;
typedef void (*GameHubUtilsFutureResult2) (gconstpointer t, gconstpointer t2, gpointer user_data);
typedef void (*GameHubUtilsFuture) (gpointer user_data);
typedef struct _GameHubDataSourcesSteamSteamPrivate GameHubDataSourcesSteamSteamPrivate;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT (game_hub_data_sources_steam_steam_game_achievement_get_type ())
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT, GameHubDataSourcesSteamSteamGameAchievement))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT, GameHubDataSourcesSteamSteamGameAchievementClass))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_ACHIEVEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT, GameHubDataSourcesSteamSteamGameAchievementClass))

typedef struct _GameHubDataSourcesSteamSteamGameAchievement GameHubDataSourcesSteamSteamGameAchievement;
typedef struct _GameHubDataSourcesSteamSteamGameAchievementClass GameHubDataSourcesSteamSteamGameAchievementClass;
#define _game_hub_data_game_achievement_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_game_achievement_unref (var), NULL)))
typedef struct _GameHubDataGameAchievementPrivate GameHubDataGameAchievementPrivate;
typedef struct _GameHubDataSourcesSteamSteamGameAchievementPrivate GameHubDataSourcesSteamSteamGameAchievementPrivate;
typedef struct _GameHubDataSourcesSteamSteamGameLoadAchievementsData GameHubDataSourcesSteamSteamGameLoadAchievementsData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GameHubDataRunnable {
	GObject parent_instance;
	GameHubDataRunnablePrivate * priv;
};

struct _GameHubDataRunnableClass {
	GObjectClass parent_class;
	gboolean (*is_supported) (GameHubDataRunnable* self, GameHubDataPlatform* platform, gboolean with_compat);
	void (*install) (GameHubDataRunnable* self, GameHubDataRunnableInstallerInstallMode install_mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	void (*run) (GameHubDataRunnable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	gboolean (*can_be_launched) (GameHubDataRunnable* self, gboolean is_launch_attempt);
	void (*run_with_compat) (GameHubDataRunnable* self, gboolean is_opened_from_menu, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_with_compat_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	GtkFileChooser* (*setup_executable_chooser) (GameHubDataRunnable* self);
	void (*choose_executable) (GameHubDataRunnable* self, gboolean update);
	void (*set_chosen_executable) (GameHubDataRunnable* self, GFile* file, gboolean update);
	void (*save) (GameHubDataRunnable* self);
	void (*update_status) (GameHubDataRunnable* self);
	void (*import) (GameHubDataRunnable* self, gboolean update);
	GFile* (*get_executable) (GameHubDataRunnable* self);
	void (*set_executable) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_work_dir) (GameHubDataRunnable* self);
	void (*set_work_dir) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_default_install_dir) (GameHubDataRunnable* self);
};

struct _GameHubDataGame {
	GameHubDataRunnable parent_instance;
	GameHubDataGamePrivate * priv;
	GameHubDataGameStatus* _status;
	GeeArrayList* overlays;
	gchar* executable_path;
	gchar* work_dir_path;
};

struct _GameHubDataGameClass {
	GameHubDataRunnableClass parent_class;
	void (*uninstall) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*uninstall_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*update_game_info) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_game_info_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*load_achievements) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeArrayList* (*load_achievements_finish) (GameHubDataGame* self, GAsyncResult* _res_);
};

struct _GameHubDataSourcesSteamSteamGame {
	GameHubDataGame parent_instance;
	GameHubDataSourcesSteamSteamGamePrivate * priv;
};

struct _GameHubDataSourcesSteamSteamGameClass {
	GameHubDataGameClass parent_class;
};

struct _GameHubDataSourcesSteamSteamGamePrivate {
	gint metadata_tries;
	gboolean game_info_updating;
	gboolean game_info_updated;
	gboolean _is_updating;
	GFile* _screenshots_dir;
	gboolean loading_achievements;
};

struct _GameHubDataSourcesSteamSteamGameUpdateGameInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesSteamSteamGame* self;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	JsonObject* i;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	JsonNode* _tmp9_;
	JsonNode* _tmp10_;
	JsonObject* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* icon_hash;
	JsonObject* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gint64 _tmp29_;
	gint64 _tmp30_;
	JsonObject* _tmp31_;
	GFile* dir;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	GameHubUtilsBinaryVDFListNode* appinfo;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GameHubUtilsBinaryVDFListNode* _tmp39_;
	GameHubUtilsBinaryVDFListNode* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GFile* _tmp48_;
	GFile* _tmp49_;
	gboolean _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* lang;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gboolean _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* url;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	JsonNode* root;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	JsonNode* _tmp86_;
	JsonObject* app;
	JsonNode* _tmp87_;
	const gchar* _tmp88_;
	const gchar* _tmp89_;
	gchar* _tmp90_;
	gchar** _tmp91_;
	gchar** _tmp92_;
	gint _tmp92__length1;
	JsonObject* _tmp93_;
	JsonObject* _tmp94_;
	JsonObject* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	const gchar* _tmp99_;
	JsonObject* data;
	JsonNode* _tmp100_;
	const gchar* _tmp101_;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar** _tmp105_;
	gchar** _tmp106_;
	gint _tmp106__length1;
	JsonObject* _tmp107_;
	JsonObject* _tmp108_;
	JsonObject* _tmp109_;
	gboolean _tmp110_;
	JsonObject* _tmp111_;
	JsonObject* _tmp112_;
	gboolean success;
	const gchar* _tmp113_;
	const gchar* _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	const gchar* _tmp119_;
	gboolean _tmp120_;
	JsonObject* _tmp121_;
	JsonObject* _tmp122_;
	JsonObject* _tmp123_;
	const gchar* _tmp124_;
	gint _tmp125_;
	JsonObject* platforms_json;
	JsonNode* _tmp126_;
	const gchar* _tmp127_;
	const gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	gchar** _tmp132_;
	gchar** _tmp133_;
	gint _tmp133__length1;
	JsonObject* _tmp134_;
	JsonObject* _tmp135_;
	GeeArrayList* _tmp136_;
	GeeArrayList* _tmp137_;
	JsonObject* _tmp138_;
	const gchar* _tmp139_;
	const gchar* _tmp140_;
	GeeArrayList* _tmp141_;
	GeeArrayList* _tmp142_;
	GameHubDataPlatform* p_collection;
	gint p_collection_length1;
	gint _p_collection_size_;
	gint p_it;
	GameHubDataPlatform p;
	gboolean _tmp143_;
	JsonObject* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	gboolean _tmp147_;
	JsonObject* _tmp148_;
	gchar* _tmp149_;
	gchar* _tmp150_;
	GeeArrayList* _tmp151_;
	GeeArrayList* _tmp152_;
};

struct _GameHubDataSourcesSteamSteamGameInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesSteamSteamGame* self;
	GameHubDataRunnableInstallerInstallMode install_mode;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
};

struct _GameHubDataSourcesSteamSteamGameRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesSteamSteamGame* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
};

struct _GameHubDataSourcesSteamSteamGameRunWithCompatData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesSteamSteamGame* self;
	gboolean is_opened_from_menu;
};

struct _GameHubDataSourcesSteamSteamGameUninstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesSteamSteamGame* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
};

struct _GameHubDataGameSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameSourcePrivate * priv;
};

struct _GameHubDataGameSourceClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameSource *self);
	gboolean (*is_installed) (GameHubDataGameSource* self, gboolean refresh);
	void (*install) (GameHubDataGameSource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*install_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	void (*authenticate) (GameHubDataGameSource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*authenticate_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	gboolean (*is_authenticated) (GameHubDataGameSource* self);
	gboolean (*can_authenticate_automatically) (GameHubDataGameSource* self);
	void (*load_games) (GameHubDataGameSource* self, GameHubUtilsFutureResult2 game_loaded, gpointer game_loaded_target, GameHubUtilsFuture cache_loaded, gpointer cache_loaded_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeArrayList* (*load_games_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	const gchar* (*get_id) (GameHubDataGameSource* self);
	const gchar* (*get_name) (GameHubDataGameSource* self);
	gchar* (*get_name_from) (GameHubDataGameSource* self);
	const gchar* (*get_icon) (GameHubDataGameSource* self);
	gchar* (*get_auth_description) (GameHubDataGameSource* self);
	gboolean (*get_enabled) (GameHubDataGameSource* self);
	void (*set_enabled) (GameHubDataGameSource* self, gboolean value);
	GeeArrayList* (*get_games) (GameHubDataGameSource* self);
};

struct _GameHubDataSourcesSteamSteam {
	GameHubDataGameSource parent_instance;
	GameHubDataSourcesSteamSteamPrivate * priv;
	gchar* api_key;
	GameHubUtilsBinaryVDFListNode* appinfo;
	GameHubUtilsBinaryVDFListNode* packageinfo;
};

struct _GameHubDataSourcesSteamSteamClass {
	GameHubDataGameSourceClass parent_class;
};

struct _GameHubDataGameAchievement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameAchievementPrivate * priv;
};

struct _GameHubDataGameAchievementClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameAchievement *self);
};

struct _GameHubDataSourcesSteamSteamGameAchievement {
	GameHubDataGameAchievement parent_instance;
	GameHubDataSourcesSteamSteamGameAchievementPrivate * priv;
	gint64 unlock_timestamp;
};

struct _GameHubDataSourcesSteamSteamGameAchievementClass {
	GameHubDataGameAchievementClass parent_class;
};

struct _GameHubDataSourcesSteamSteamGameLoadAchievementsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesSteamSteamGame* self;
	GeeArrayList* result;
	gboolean _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gchar* lang;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* schema_url;
	GameHubDataSourcesSteamSteam* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* achievements_url;
	GameHubDataSourcesSteamSteam* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GameHubDataSourcesSteamSteam* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* global_percentages_url;
	GameHubDataSourcesSteamSteam* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	JsonNode* schema_root;
	const gchar* _tmp49_;
	JsonNode* _tmp50_;
	JsonNode* achievements_root;
	const gchar* _tmp51_;
	JsonNode* _tmp52_;
	JsonNode* global_percentages_root;
	const gchar* _tmp53_;
	JsonNode* _tmp54_;
	JsonObject* schema_achievements_obj;
	JsonNode* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar** _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	JsonObject* _tmp60_;
	JsonObject* _tmp61_;
	gboolean _tmp62_;
	JsonObject* _tmp63_;
	JsonObject* _tmp64_;
	JsonArray* schema_achievements;
	JsonObject* _tmp65_;
	JsonArray* _tmp66_;
	JsonArray* _tmp67_;
	JsonObject* achievements_obj;
	JsonNode* _tmp68_;
	gchar* _tmp69_;
	gchar** _tmp70_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	JsonObject* _tmp72_;
	JsonObject* _tmp73_;
	gboolean _tmp74_;
	JsonObject* _tmp75_;
	JsonObject* _tmp76_;
	JsonArray* player_achievements;
	JsonObject* _tmp77_;
	JsonArray* _tmp78_;
	JsonArray* _tmp79_;
	JsonObject* global_percentages_obj;
	JsonNode* _tmp80_;
	gchar* _tmp81_;
	gchar** _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	JsonObject* _tmp84_;
	JsonObject* _tmp85_;
	gboolean _tmp86_;
	JsonObject* _tmp87_;
	JsonObject* _tmp88_;
	JsonArray* global_percentages;
	JsonObject* _tmp89_;
	JsonArray* _tmp90_;
	JsonArray* _tmp91_;
	GeeArrayList* _achievements;
	GeeArrayList* _tmp92_;
	JsonArray* _tmp93_;
	GList* _tmp94_;
	GList* s_achievement_node_collection;
	GList* s_achievement_node_it;
	JsonNode* s_achievement_node;
	JsonObject* _tmp95_;
	gboolean _tmp96_;
	JsonNode* _tmp97_;
	JsonNode* _tmp98_;
	JsonNode* _tmp99_;
	JsonObject* _tmp100_;
	JsonObject* s_achievement;
	JsonObject* _tmp101_;
	gboolean _tmp102_;
	JsonObject* _tmp103_;
	JsonObject* _tmp104_;
	gchar* a_id;
	JsonObject* _tmp105_;
	const gchar* _tmp106_;
	gchar* _tmp107_;
	const gchar* _tmp108_;
	JsonObject* _tmp109_;
	JsonObject* _tmp110_;
	const gchar* _tmp111_;
	const gchar* _tmp112_;
	gchar* a_name;
	gchar* _tmp113_;
	const gchar* _tmp114_;
	JsonObject* _tmp115_;
	JsonObject* _tmp116_;
	const gchar* _tmp117_;
	gchar* a_desc;
	gchar* _tmp118_;
	const gchar* _tmp119_;
	JsonObject* _tmp120_;
	JsonObject* _tmp121_;
	const gchar* _tmp122_;
	gchar* a_image_unlocked;
	gchar* _tmp123_;
	const gchar* _tmp124_;
	JsonObject* _tmp125_;
	JsonObject* _tmp126_;
	const gchar* _tmp127_;
	gchar* a_image_locked;
	gchar* _tmp128_;
	gboolean a_unlocked;
	gint64 a_unlock_time;
	gfloat a_global_percentage;
	JsonArray* _tmp129_;
	GList* _tmp130_;
	GList* p_achievement_node_collection;
	GList* p_achievement_node_it;
	JsonNode* p_achievement_node;
	JsonObject* _tmp131_;
	gboolean _tmp132_;
	JsonNode* _tmp133_;
	JsonNode* _tmp134_;
	JsonNode* _tmp135_;
	JsonObject* _tmp136_;
	JsonObject* p_achievement;
	JsonObject* _tmp137_;
	gboolean _tmp138_;
	gboolean _tmp139_;
	JsonObject* _tmp140_;
	JsonObject* _tmp141_;
	JsonObject* _tmp142_;
	const gchar* _tmp143_;
	const gchar* _tmp144_;
	gboolean _tmp145_;
	JsonObject* _tmp146_;
	JsonObject* _tmp147_;
	gint64 _tmp148_;
	JsonObject* _tmp149_;
	JsonObject* _tmp150_;
	JsonArray* _tmp151_;
	GList* _tmp152_;
	GList* gp_achievement_node_collection;
	GList* gp_achievement_node_it;
	JsonNode* gp_achievement_node;
	JsonObject* _tmp153_;
	gboolean _tmp154_;
	JsonNode* _tmp155_;
	JsonNode* _tmp156_;
	JsonNode* _tmp157_;
	JsonObject* _tmp158_;
	JsonObject* gp_achievement;
	JsonObject* _tmp159_;
	gboolean _tmp160_;
	gboolean _tmp161_;
	JsonObject* _tmp162_;
	JsonObject* _tmp163_;
	JsonObject* _tmp164_;
	const gchar* _tmp165_;
	const gchar* _tmp166_;
	gdouble _tmp167_;
	JsonObject* _tmp168_;
	JsonObject* _tmp169_;
	GeeArrayList* _tmp170_;
	const gchar* _tmp171_;
	const gchar* _tmp172_;
	const gchar* _tmp173_;
	const gchar* _tmp174_;
	const gchar* _tmp175_;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp176_;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp177_;
	GeeArrayList* _tmp178_;
	GeeArrayList* _tmp179_;
	GeeArrayList* _tmp180_;
	GeeArrayList* _tmp181_;
	GeeArrayList* _tmp182_;
};

static gint GameHubDataSourcesSteamSteamGame_private_offset;
static gpointer game_hub_data_sources_steam_steam_game_parent_class = NULL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ID;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_NAME;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INFO;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INFO_DETAILED;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_COMPAT_TOOL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_COMPAT_TOOL_SETTINGS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ARGUMENTS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_LAST_LAUNCH;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLAYTIME_SOURCE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLAYTIME_TRACKED;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ICON;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_IMAGE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_IMAGE_VERTICAL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLATFORMS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_TAGS;
VALA_EXTERN GeeArrayList* game_hub_data_db_tables_tags_TAGS;
VALA_EXTERN gboolean game_hub_application_log_verbose;
VALA_EXTERN GameHubDataDBTablesTagsTag* game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
VALA_EXTERN GameHubDataDBTablesTagsTag* game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
VALA_EXTERN GameHubDataSourcesSteamSteam* game_hub_data_sources_steam_steam_instance;
static gpointer game_hub_data_sources_steam_steam_game_achievement_parent_class = NULL;

VALA_EXTERN GType game_hub_data_runnable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnable, g_object_unref)
VALA_EXTERN GType game_hub_data_platform_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_runnable_installer_install_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGame, g_object_unref)
VALA_EXTERN gpointer game_hub_data_game_achievement_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_achievement_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_achievement (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_achievement (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_achievement (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_achievement (const GValue* value);
VALA_EXTERN GType game_hub_data_game_achievement_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameAchievement, game_hub_data_game_achievement_unref)
VALA_EXTERN gpointer game_hub_data_game_status_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_status_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_status (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_status (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_status (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_status (const GValue* value);
VALA_EXTERN GType game_hub_data_game_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameStatus, game_hub_data_game_status_unref)
VALA_EXTERN GType game_hub_data_game_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameOverlay, g_object_unref)
VALA_EXTERN GType game_hub_data_sources_steam_steam_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesSteamSteamGame, g_object_unref)
VALA_EXTERN void game_hub_data_game_update_game_info (GameHubDataGame* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_update_game_info_finish (GameHubDataGame* self,
                                                 GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_update_status (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_install (GameHubDataRunnable* self,
                                     GameHubDataRunnableInstallerInstallMode install_mode,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_install_finish (GameHubDataRunnable* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_run (GameHubDataRunnable* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_run_finish (GameHubDataRunnable* self,
                                        GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_run_with_compat (GameHubDataRunnable* self,
                                             gboolean is_opened_from_menu,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_run_with_compat_finish (GameHubDataRunnable* self,
                                                    GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_game_uninstall (GameHubDataGame* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_uninstall_finish (GameHubDataGame* self,
                                          GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_game_load_achievements (GameHubDataGame* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN GeeArrayList* game_hub_data_game_load_achievements_finish (GameHubDataGame* self,
                                                           GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_import (GameHubDataRunnable* self,
                                    gboolean update);
VALA_EXTERN void game_hub_data_runnable_choose_executable (GameHubDataRunnable* self,
                                               gboolean update);
VALA_EXTERN gpointer game_hub_data_game_source_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_param_spec_game_source (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_value_set_game_source (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_value_take_game_source (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_value_get_game_source (const GValue* value);
VALA_EXTERN GType game_hub_data_game_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameSource, game_hub_data_game_source_unref)
VALA_EXTERN GType game_hub_data_sources_steam_steam_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesSteamSteam, game_hub_data_game_source_unref)
VALA_EXTERN GameHubDataSourcesSteamSteamGame* game_hub_data_sources_steam_steam_game_new (GameHubDataSourcesSteamSteam* src,
                                                                              JsonNode* json_node);
VALA_EXTERN GameHubDataSourcesSteamSteamGame* game_hub_data_sources_steam_steam_game_construct (GType object_type,
                                                                                    GameHubDataSourcesSteamSteam* src,
                                                                                    JsonNode* json_node);
VALA_EXTERN GameHubDataGame* game_hub_data_game_construct (GType object_type);
VALA_EXTERN void game_hub_data_game_set_source (GameHubDataGame* self,
                                    GameHubDataGameSource* value);
VALA_EXTERN void game_hub_data_runnable_set_id (GameHubDataRunnable* self,
                                    const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_name (GameHubDataRunnable* self,
                                      const gchar* value);
VALA_EXTERN const gchar* game_hub_data_runnable_get_id (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_game_set_icon (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN void game_hub_data_game_set_image (GameHubDataGame* self,
                                   const gchar* value);
VALA_EXTERN void game_hub_data_game_set_image_vertical (GameHubDataGame* self,
                                            const gchar* value);
VALA_EXTERN void game_hub_data_game_set_info (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN void game_hub_data_game_set_store_page (GameHubDataGame* self,
                                        const gchar* value);
VALA_EXTERN GameHubDataSourcesSteamSteamGame* game_hub_data_sources_steam_steam_game_new_from_db (GameHubDataSourcesSteamSteam* src,
                                                                                      sqlite3_stmt* s);
VALA_EXTERN GameHubDataSourcesSteamSteamGame* game_hub_data_sources_steam_steam_game_construct_from_db (GType object_type,
                                                                                            GameHubDataSourcesSteamSteam* src,
                                                                                            sqlite3_stmt* s);
VALA_EXTERN gpointer game_hub_data_db_table_field_ref (gpointer instance);
VALA_EXTERN void game_hub_data_db_table_field_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_db_table_param_spec_field (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void game_hub_data_db_table_value_set_field (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void game_hub_data_db_table_value_take_field (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer game_hub_data_db_table_value_get_field (const GValue* value);
VALA_EXTERN GType game_hub_data_db_table_field_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTableField, game_hub_data_db_table_field_unref)
VALA_EXTERN gchar* game_hub_data_db_table_field_get (GameHubDataDBTableField* self,
                                         sqlite3_stmt* s);
VALA_EXTERN void game_hub_data_game_set_info_detailed (GameHubDataGame* self,
                                           const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool (GameHubDataRunnable* self,
                                             const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool_settings (GameHubDataRunnable* self,
                                                      const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_arguments (GameHubDataRunnable* self,
                                           const gchar* value);
VALA_EXTERN gint64 game_hub_data_db_table_field_get_int64 (GameHubDataDBTableField* self,
                                               sqlite3_stmt* s);
VALA_EXTERN void game_hub_data_game_set_last_launch (GameHubDataGame* self,
                                         gint64 value);
VALA_EXTERN void game_hub_data_game_set_playtime_source (GameHubDataGame* self,
                                             gint64 value);
VALA_EXTERN void game_hub_data_game_set_playtime_tracked (GameHubDataGame* self,
                                              gint64 value);
VALA_EXTERN const gchar* game_hub_data_game_get_image (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_game_get_image_vertical (GameHubDataGame* self);
VALA_EXTERN GeeArrayList* game_hub_data_runnable_get_platforms (GameHubDataRunnable* self);
VALA_EXTERN gchar* game_hub_data_platform_id (GameHubDataPlatform self);
VALA_EXTERN GType game_hub_data_db_tables_tags_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTablesTagsTag, g_object_unref)
VALA_EXTERN GeeArrayList* game_hub_data_game_get_tags (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_db_tables_tags_tag_get_id (GameHubDataDBTablesTagsTag* self);
static void game_hub_data_sources_steam_steam_game_real_update_game_info_data_free (gpointer _data);
static void game_hub_data_sources_steam_steam_game_real_update_game_info (GameHubDataGame* base,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static gboolean game_hub_data_sources_steam_steam_game_real_update_game_info_co (GameHubDataSourcesSteamSteamGameUpdateGameInfoData* _data_);
VALA_EXTERN const gchar* game_hub_data_game_get_info (GameHubDataGame* self);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_json (const gchar* json);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN const gchar* game_hub_data_game_get_icon (GameHubDataGame* self);
VALA_EXTERN gint64 game_hub_data_game_get_playtime_source (GameHubDataGame* self);
VALA_EXTERN gboolean game_hub_data_sources_steam_steam_find_app_install_dir (const gchar* app,
                                                                 GFile** install_dir);
VALA_EXTERN void game_hub_data_runnable_set_install_dir (GameHubDataRunnable* self,
                                             GFile* value);
VALA_EXTERN void game_hub_data_runnable_set_work_dir (GameHubDataRunnable* self,
                                          GFile* value);
VALA_EXTERN gpointer game_hub_utils_binary_vdf_node_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_binary_vdf_node_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_binary_vdf_param_spec_node (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_utils_binary_vdf_value_set_node (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_utils_binary_vdf_value_take_node (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_binary_vdf_value_get_node (const GValue* value);
VALA_EXTERN GType game_hub_utils_binary_vdf_node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsBinaryVDFNode, game_hub_utils_binary_vdf_node_unref)
VALA_EXTERN GType game_hub_utils_binary_vdf_list_node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsBinaryVDFListNode, game_hub_utils_binary_vdf_node_unref)
VALA_EXTERN GameHubUtilsBinaryVDFListNode* game_hub_data_sources_steam_steam_get_appinfo (const gchar* appid);
VALA_EXTERN GFile* game_hub_utils_fs_utils_find_case_insensitive (GFile* root,
                                                      const gchar* path,
                                                      gchar** parts,
                                                      gint parts_length1);
VALA_EXTERN GFile* game_hub_data_sources_steam_steam_get_userdata_dir (void);
VALA_EXTERN void game_hub_data_sources_steam_steam_game_set_screenshots_dir (GameHubDataSourcesSteamSteamGame* self,
                                                                 GFile* value);
VALA_EXTERN const gchar* game_hub_data_game_get_info_detailed (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_runnable_get_name (GameHubDataRunnable* self);
VALA_EXTERN gchar* game_hub_utils_get_language_name (void);
VALA_EXTERN void game_hub_utils_parser_load_remote_file_async (const gchar* url,
                                                   const gchar* method,
                                                   const gchar* auth,
                                                   GeeHashMap* headers,
                                                   GeeHashMap* data,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar* game_hub_utils_parser_load_remote_file_finish (GAsyncResult* _res_,
                                                      guint* status);
static void game_hub_data_sources_steam_steam_game_update_game_info_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
VALA_EXTERN JsonObject* game_hub_utils_parser_json_object (JsonNode* root,
                                               gchar** keys,
                                               gint keys_length1);
VALA_EXTERN void game_hub_data_game_set_description (GameHubDataGame* self,
                                         const gchar* value);
VALA_EXTERN void game_hub_data_runnable_save (GameHubDataRunnable* self);
static void game_hub_data_sources_steam_steam_game_real_update_status (GameHubDataRunnable* base);
VALA_EXTERN GType game_hub_data_game_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean game_hub_data_sources_steam_steam_game_get_is_updating (GameHubDataSourcesSteamSteamGame* self);
VALA_EXTERN gboolean game_hub_data_sources_steam_steam_is_app_installed (const gchar* app);
VALA_EXTERN void game_hub_data_game_remove_tag (GameHubDataGame* self,
                                    GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN void game_hub_data_game_add_tag (GameHubDataGame* self,
                                 GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN gpointer game_hub_utils_downloader_download_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_downloader_download_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_downloader_param_spec_download (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags);
VALA_EXTERN void game_hub_utils_downloader_value_set_download (GValue* value,
                                                   gpointer v_object);
VALA_EXTERN void game_hub_utils_downloader_value_take_download (GValue* value,
                                                    gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_downloader_value_get_download (const GValue* value);
VALA_EXTERN GType game_hub_utils_downloader_download_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownload, game_hub_utils_downloader_download_unref)
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_new (GameHubDataGameState state,
                                                      GameHubDataGame* game,
                                                      GameHubUtilsDownloaderDownload* download);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_construct (GType object_type,
                                                            GameHubDataGameState state,
                                                            GameHubDataGame* game,
                                                            GameHubUtilsDownloaderDownload* download);
VALA_EXTERN void game_hub_data_game_set_status (GameHubDataGame* self,
                                    GameHubDataGameStatus* value);
static void game_hub_data_sources_steam_steam_game_real_install_data_free (gpointer _data);
static void game_hub_data_sources_steam_steam_game_real_install (GameHubDataRunnable* base,
                                                          GameHubDataRunnableInstallerInstallMode install_mode,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static gboolean game_hub_data_sources_steam_steam_game_real_install_co (GameHubDataSourcesSteamSteamGameInstallData* _data_);
VALA_EXTERN void game_hub_data_sources_steam_steam_install_app (const gchar* appid);
static void game_hub_data_sources_steam_steam_game_real_run_data_free (gpointer _data);
static void game_hub_data_sources_steam_steam_game_real_run (GameHubDataRunnable* base,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean game_hub_data_sources_steam_steam_game_real_run_co (GameHubDataSourcesSteamSteamGameRunData* _data_);
VALA_EXTERN gboolean game_hub_data_runnable_can_be_launched (GameHubDataRunnable* self,
                                                 gboolean is_launch_attempt);
VALA_EXTERN void game_hub_utils_open_uri (const gchar* uri);
static void game_hub_data_sources_steam_steam_game_real_run_with_compat_data_free (gpointer _data);
static void game_hub_data_sources_steam_steam_game_real_run_with_compat (GameHubDataRunnable* base,
                                                                  gboolean is_opened_from_menu,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static gboolean game_hub_data_sources_steam_steam_game_real_run_with_compat_co (GameHubDataSourcesSteamSteamGameRunWithCompatData* _data_);
static void game_hub_data_sources_steam_steam_game_run_with_compat_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void game_hub_data_sources_steam_steam_game_real_uninstall_data_free (gpointer _data);
static void game_hub_data_sources_steam_steam_game_real_uninstall (GameHubDataGame* base,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gboolean game_hub_data_sources_steam_steam_game_real_uninstall_co (GameHubDataSourcesSteamSteamGameUninstallData* _data_);
static void game_hub_data_sources_steam_steam_game_real_load_achievements_data_free (gpointer _data);
static void game_hub_data_sources_steam_steam_game_real_load_achievements (GameHubDataGame* base,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_);
static gboolean game_hub_data_sources_steam_steam_game_real_load_achievements_co (GameHubDataSourcesSteamSteamGameLoadAchievementsData* _data_);
VALA_EXTERN GeeArrayList* game_hub_data_game_get_achievements (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_sources_steam_steam_get_user_id (GameHubDataSourcesSteamSteam* self);
VALA_EXTERN void game_hub_utils_parser_parse_remote_json_file_async (const gchar* url,
                                                         const gchar* method,
                                                         const gchar* auth,
                                                         GeeHashMap* headers,
                                                         GeeHashMap* data,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_remote_json_file_finish (GAsyncResult* _res_,
                                                               guint* status);
static void game_hub_data_sources_steam_steam_game_load_achievements_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
VALA_EXTERN GameHubDataSourcesSteamSteamGameAchievement* game_hub_data_sources_steam_steam_game_achievement_new (const gchar* id,
                                                                                                     const gchar* name,
                                                                                                     const gchar* desc,
                                                                                                     const gchar* image_locked,
                                                                                                     const gchar* image_unlocked,
                                                                                                     gboolean unlocked,
                                                                                                     gint64 unlock_time,
                                                                                                     gfloat global_percentage);
VALA_EXTERN GameHubDataSourcesSteamSteamGameAchievement* game_hub_data_sources_steam_steam_game_achievement_construct (GType object_type,
                                                                                                           const gchar* id,
                                                                                                           const gchar* name,
                                                                                                           const gchar* desc,
                                                                                                           const gchar* image_locked,
                                                                                                           const gchar* image_unlocked,
                                                                                                           gboolean unlocked,
                                                                                                           gint64 unlock_time,
                                                                                                           gfloat global_percentage);
VALA_EXTERN GType game_hub_data_sources_steam_steam_game_achievement_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesSteamSteamGameAchievement, game_hub_data_game_achievement_unref)
static gint __lambda129_ (GameHubDataSourcesSteamSteamGame* self,
                   GameHubDataGameAchievement* first,
                   GameHubDataGameAchievement* second);
VALA_EXTERN gfloat game_hub_data_game_achievement_get_global_percentage (GameHubDataGameAchievement* self);
static gint ___lambda129__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
VALA_EXTERN void game_hub_data_game_set_achievements (GameHubDataGame* self,
                                          GeeArrayList* value);
static void game_hub_data_sources_steam_steam_game_real_import (GameHubDataRunnable* base,
                                                         gboolean update);
static void game_hub_data_sources_steam_steam_game_real_choose_executable (GameHubDataRunnable* base,
                                                                    gboolean update);
VALA_EXTERN void game_hub_data_sources_steam_steam_game_set_is_updating (GameHubDataSourcesSteamSteamGame* self,
                                                             gboolean value);
VALA_EXTERN GFile* game_hub_data_sources_steam_steam_game_get_screenshots_dir (GameHubDataSourcesSteamSteamGame* self);
VALA_EXTERN GameHubDataGameAchievement* game_hub_data_game_achievement_construct (GType object_type);
VALA_EXTERN void game_hub_data_game_achievement_set_id (GameHubDataGameAchievement* self,
                                            const gchar* value);
VALA_EXTERN void game_hub_data_game_achievement_set_name (GameHubDataGameAchievement* self,
                                              const gchar* value);
VALA_EXTERN void game_hub_data_game_achievement_set_description (GameHubDataGameAchievement* self,
                                                     const gchar* value);
VALA_EXTERN void game_hub_data_game_achievement_set_image_locked (GameHubDataGameAchievement* self,
                                                      const gchar* value);
VALA_EXTERN void game_hub_data_game_achievement_set_image_unlocked (GameHubDataGameAchievement* self,
                                                        const gchar* value);
VALA_EXTERN void game_hub_data_game_achievement_set_unlocked (GameHubDataGameAchievement* self,
                                                  gboolean value);
VALA_EXTERN void game_hub_data_game_achievement_set_global_percentage (GameHubDataGameAchievement* self,
                                                           gfloat value);
VALA_EXTERN void game_hub_data_game_achievement_set_unlock_date (GameHubDataGameAchievement* self,
                                                     GDateTime* value);
VALA_EXTERN gchar* game_hub_utils_get_relative_datetime (GDateTime* date_time);
VALA_EXTERN GDateTime* game_hub_data_game_achievement_get_unlock_date (GameHubDataGameAchievement* self);
VALA_EXTERN void game_hub_data_game_achievement_set_unlock_time (GameHubDataGameAchievement* self,
                                                     const gchar* value);
static void game_hub_data_sources_steam_steam_game_achievement_finalize (GameHubDataGameAchievement * obj);
static GType game_hub_data_sources_steam_steam_game_achievement_get_type_once (void);
static void game_hub_data_sources_steam_steam_game_finalize (GObject * obj);
static GType game_hub_data_sources_steam_steam_game_get_type_once (void);
static void _vala_game_hub_data_sources_steam_steam_game_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_game_hub_data_sources_steam_steam_game_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const GameHubDataPlatform GAME_HUB_DATA_PLATFORM_PLATFORMS[4];

static inline gpointer
game_hub_data_sources_steam_steam_game_get_instance_private (GameHubDataSourcesSteamSteamGame* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataSourcesSteamSteamGame_private_offset);
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 41 "../src/data/sources/steam/SteamGame.vala"
	return self ? json_object_ref (self) : NULL;
#line 1241 "SteamGame.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 1254 "SteamGame.c"
}

GameHubDataSourcesSteamSteamGame*
game_hub_data_sources_steam_steam_game_construct (GType object_type,
                                                  GameHubDataSourcesSteamSteam* src,
                                                  JsonNode* json_node)
{
	GameHubDataSourcesSteamSteamGame * self = NULL;
	JsonObject* json_obj = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* icon_hash = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
#line 37 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 37 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (json_node != NULL, NULL);
#line 37 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) game_hub_data_game_construct (object_type);
#line 39 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_source ((GameHubDataGame*) self, (GameHubDataGameSource*) src);
#line 41 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = json_node_get_object (json_node);
#line 41 "../src/data/sources/steam/SteamGame.vala"
	_tmp1_ = _json_object_ref0 (_tmp0_);
#line 41 "../src/data/sources/steam/SteamGame.vala"
	json_obj = _tmp1_;
#line 43 "../src/data/sources/steam/SteamGame.vala"
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (json_obj, "appid"));
#line 43 "../src/data/sources/steam/SteamGame.vala"
	_tmp3_ = _tmp2_;
#line 43 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp3_);
#line 43 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp3_);
#line 44 "../src/data/sources/steam/SteamGame.vala"
	_tmp4_ = json_object_get_string_member (json_obj, "name");
#line 44 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, _tmp4_);
#line 46 "../src/data/sources/steam/SteamGame.vala"
	_tmp5_ = json_object_get_string_member (json_obj, "img_icon_url");
#line 46 "../src/data/sources/steam/SteamGame.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 46 "../src/data/sources/steam/SteamGame.vala"
	icon_hash = _tmp6_;
#line 48 "../src/data/sources/steam/SteamGame.vala"
	_tmp7_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 48 "../src/data/sources/steam/SteamGame.vala"
	_tmp8_ = _tmp7_;
#line 48 "../src/data/sources/steam/SteamGame.vala"
	_tmp9_ = string_to_string (_tmp8_);
#line 48 "../src/data/sources/steam/SteamGame.vala"
	_tmp10_ = string_to_string (icon_hash);
#line 48 "../src/data/sources/steam/SteamGame.vala"
	_tmp11_ = g_strconcat ("http://media.steampowered.com/steamcommunity/public/images/apps/", _tmp9_, "/", _tmp10_, ".jpg", NULL);
#line 48 "../src/data/sources/steam/SteamGame.vala"
	_tmp12_ = _tmp11_;
#line 48 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_icon ((GameHubDataGame*) self, _tmp12_);
#line 48 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp12_);
#line 49 "../src/data/sources/steam/SteamGame.vala"
	_tmp13_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 49 "../src/data/sources/steam/SteamGame.vala"
	_tmp14_ = _tmp13_;
#line 49 "../src/data/sources/steam/SteamGame.vala"
	_tmp15_ = string_to_string (_tmp14_);
#line 49 "../src/data/sources/steam/SteamGame.vala"
	_tmp16_ = g_strconcat ("http://cdn.akamai.steamstatic.com/steam/apps/", _tmp15_, "/header.jpg", NULL);
#line 49 "../src/data/sources/steam/SteamGame.vala"
	_tmp17_ = _tmp16_;
#line 49 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_image ((GameHubDataGame*) self, _tmp17_);
#line 49 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp17_);
#line 50 "../src/data/sources/steam/SteamGame.vala"
	_tmp18_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 50 "../src/data/sources/steam/SteamGame.vala"
	_tmp19_ = _tmp18_;
#line 50 "../src/data/sources/steam/SteamGame.vala"
	_tmp20_ = string_to_string (_tmp19_);
#line 50 "../src/data/sources/steam/SteamGame.vala"
	_tmp21_ = g_strconcat ("http://cdn.akamai.steamstatic.com/steam/apps/", _tmp20_, "/library_600x900_2x.jpg", NULL);
#line 50 "../src/data/sources/steam/SteamGame.vala"
	_tmp22_ = _tmp21_;
#line 50 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_image_vertical ((GameHubDataGame*) self, _tmp22_);
#line 50 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp22_);
#line 52 "../src/data/sources/steam/SteamGame.vala"
	_tmp23_ = json_to_string (json_node, FALSE);
#line 52 "../src/data/sources/steam/SteamGame.vala"
	_tmp24_ = _tmp23_;
#line 52 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp24_);
#line 52 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp24_);
#line 54 "../src/data/sources/steam/SteamGame.vala"
	_tmp25_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 54 "../src/data/sources/steam/SteamGame.vala"
	_tmp26_ = _tmp25_;
#line 54 "../src/data/sources/steam/SteamGame.vala"
	_tmp27_ = string_to_string (_tmp26_);
#line 54 "../src/data/sources/steam/SteamGame.vala"
	_tmp28_ = g_strconcat ("steam://store/", _tmp27_, NULL);
#line 54 "../src/data/sources/steam/SteamGame.vala"
	_tmp29_ = _tmp28_;
#line 54 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_store_page ((GameHubDataGame*) self, _tmp29_);
#line 54 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp29_);
#line 56 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 37 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (icon_hash);
#line 37 "../src/data/sources/steam/SteamGame.vala"
	_json_object_unref0 (json_obj);
#line 37 "../src/data/sources/steam/SteamGame.vala"
	return self;
#line 1401 "SteamGame.c"
}

GameHubDataSourcesSteamSteamGame*
game_hub_data_sources_steam_steam_game_new (GameHubDataSourcesSteamSteam* src,
                                            JsonNode* json_node)
{
#line 37 "../src/data/sources/steam/SteamGame.vala"
	return game_hub_data_sources_steam_steam_game_construct (GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, src, json_node);
#line 1410 "SteamGame.c"
}

GameHubDataSourcesSteamSteamGame*
game_hub_data_sources_steam_steam_game_construct_from_db (GType object_type,
                                                          GameHubDataSourcesSteamSteam* src,
                                                          sqlite3_stmt* s)
{
	GameHubDataSourcesSteamSteamGame * self = NULL;
	GameHubDataDBTableField* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GameHubDataDBTableField* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GameHubDataDBTableField* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GameHubDataDBTableField* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GameHubDataDBTableField* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GameHubDataDBTableField* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GameHubDataDBTableField* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GameHubDataDBTableField* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GameHubDataDBTableField* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GameHubDataDBTableField* _tmp27_;
	GameHubDataDBTableField* _tmp28_;
	GameHubDataDBTableField* _tmp29_;
	GameHubDataDBTableField* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GameHubDataDBTableField* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GameHubDataDBTableField* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gboolean _tmp39_ = FALSE;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	GeeArrayList* _tmp59_;
	GeeArrayList* _tmp60_;
	gchar** pls = NULL;
	GameHubDataDBTableField* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar** _tmp64_;
	gchar** _tmp65_;
	gchar** _tmp66_;
	gint _tmp66__length1;
	gint pls_length1;
	gint _pls_size_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	GeeArrayList* _tmp75_;
	GeeArrayList* _tmp76_;
	gchar* _tmp77_ = NULL;
	GameHubDataDBTableField* _tmp78_;
	gchar* _tmp79_;
	gchar** tag_ids = NULL;
	gchar** _tmp81_;
	gchar** _tmp82_;
	gint tag_ids_length1;
	gint _tag_ids_size_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	const gchar* _tmp103_;
	const gchar* _tmp104_;
	const gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
#line 59 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 59 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 59 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) game_hub_data_game_construct (object_type);
#line 61 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_source ((GameHubDataGame*) self, (GameHubDataGameSource*) src);
#line 62 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = game_hub_data_db_tables_games_ID;
#line 62 "../src/data/sources/steam/SteamGame.vala"
	_tmp1_ = game_hub_data_db_table_field_get (_tmp0_, s);
#line 62 "../src/data/sources/steam/SteamGame.vala"
	_tmp2_ = _tmp1_;
#line 62 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp2_);
#line 62 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp2_);
#line 63 "../src/data/sources/steam/SteamGame.vala"
	_tmp3_ = game_hub_data_db_tables_games_NAME;
#line 63 "../src/data/sources/steam/SteamGame.vala"
	_tmp4_ = game_hub_data_db_table_field_get (_tmp3_, s);
#line 63 "../src/data/sources/steam/SteamGame.vala"
	_tmp5_ = _tmp4_;
#line 63 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, _tmp5_);
#line 63 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp5_);
#line 64 "../src/data/sources/steam/SteamGame.vala"
	_tmp6_ = game_hub_data_db_tables_games_INFO;
#line 64 "../src/data/sources/steam/SteamGame.vala"
	_tmp7_ = game_hub_data_db_table_field_get (_tmp6_, s);
#line 64 "../src/data/sources/steam/SteamGame.vala"
	_tmp8_ = _tmp7_;
#line 64 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp8_);
#line 64 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp8_);
#line 65 "../src/data/sources/steam/SteamGame.vala"
	_tmp9_ = game_hub_data_db_tables_games_INFO_DETAILED;
#line 65 "../src/data/sources/steam/SteamGame.vala"
	_tmp10_ = game_hub_data_db_table_field_get (_tmp9_, s);
#line 65 "../src/data/sources/steam/SteamGame.vala"
	_tmp11_ = _tmp10_;
#line 65 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_info_detailed ((GameHubDataGame*) self, _tmp11_);
#line 65 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp11_);
#line 66 "../src/data/sources/steam/SteamGame.vala"
	_tmp12_ = game_hub_data_db_tables_games_INFO;
#line 66 "../src/data/sources/steam/SteamGame.vala"
	_tmp13_ = game_hub_data_db_table_field_get (_tmp12_, s);
#line 66 "../src/data/sources/steam/SteamGame.vala"
	_tmp14_ = _tmp13_;
#line 66 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp14_);
#line 66 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp14_);
#line 67 "../src/data/sources/steam/SteamGame.vala"
	_tmp15_ = game_hub_data_db_tables_games_INFO_DETAILED;
#line 67 "../src/data/sources/steam/SteamGame.vala"
	_tmp16_ = game_hub_data_db_table_field_get (_tmp15_, s);
#line 67 "../src/data/sources/steam/SteamGame.vala"
	_tmp17_ = _tmp16_;
#line 67 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_info_detailed ((GameHubDataGame*) self, _tmp17_);
#line 67 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp17_);
#line 68 "../src/data/sources/steam/SteamGame.vala"
	_tmp18_ = game_hub_data_db_tables_games_COMPAT_TOOL;
#line 68 "../src/data/sources/steam/SteamGame.vala"
	_tmp19_ = game_hub_data_db_table_field_get (_tmp18_, s);
#line 68 "../src/data/sources/steam/SteamGame.vala"
	_tmp20_ = _tmp19_;
#line 68 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_compat_tool ((GameHubDataRunnable*) self, _tmp20_);
#line 68 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp20_);
#line 69 "../src/data/sources/steam/SteamGame.vala"
	_tmp21_ = game_hub_data_db_tables_games_COMPAT_TOOL_SETTINGS;
#line 69 "../src/data/sources/steam/SteamGame.vala"
	_tmp22_ = game_hub_data_db_table_field_get (_tmp21_, s);
#line 69 "../src/data/sources/steam/SteamGame.vala"
	_tmp23_ = _tmp22_;
#line 69 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_compat_tool_settings ((GameHubDataRunnable*) self, _tmp23_);
#line 69 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp23_);
#line 70 "../src/data/sources/steam/SteamGame.vala"
	_tmp24_ = game_hub_data_db_tables_games_ARGUMENTS;
#line 70 "../src/data/sources/steam/SteamGame.vala"
	_tmp25_ = game_hub_data_db_table_field_get (_tmp24_, s);
#line 70 "../src/data/sources/steam/SteamGame.vala"
	_tmp26_ = _tmp25_;
#line 70 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_arguments ((GameHubDataRunnable*) self, _tmp26_);
#line 70 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp26_);
#line 71 "../src/data/sources/steam/SteamGame.vala"
	_tmp27_ = game_hub_data_db_tables_games_LAST_LAUNCH;
#line 71 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_last_launch ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp27_, s));
#line 72 "../src/data/sources/steam/SteamGame.vala"
	_tmp28_ = game_hub_data_db_tables_games_PLAYTIME_SOURCE;
#line 72 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_playtime_source ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp28_, s));
#line 73 "../src/data/sources/steam/SteamGame.vala"
	_tmp29_ = game_hub_data_db_tables_games_PLAYTIME_TRACKED;
#line 73 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_playtime_tracked ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp29_, s));
#line 75 "../src/data/sources/steam/SteamGame.vala"
	_tmp30_ = game_hub_data_db_tables_games_ICON;
#line 75 "../src/data/sources/steam/SteamGame.vala"
	_tmp31_ = game_hub_data_db_table_field_get (_tmp30_, s);
#line 75 "../src/data/sources/steam/SteamGame.vala"
	_tmp32_ = _tmp31_;
#line 75 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_icon ((GameHubDataGame*) self, _tmp32_);
#line 75 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp32_);
#line 76 "../src/data/sources/steam/SteamGame.vala"
	_tmp33_ = game_hub_data_db_tables_games_IMAGE;
#line 76 "../src/data/sources/steam/SteamGame.vala"
	_tmp34_ = game_hub_data_db_table_field_get (_tmp33_, s);
#line 76 "../src/data/sources/steam/SteamGame.vala"
	_tmp35_ = _tmp34_;
#line 76 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_image ((GameHubDataGame*) self, _tmp35_);
#line 76 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp35_);
#line 77 "../src/data/sources/steam/SteamGame.vala"
	_tmp36_ = game_hub_data_db_tables_games_IMAGE_VERTICAL;
#line 77 "../src/data/sources/steam/SteamGame.vala"
	_tmp37_ = game_hub_data_db_table_field_get (_tmp36_, s);
#line 77 "../src/data/sources/steam/SteamGame.vala"
	_tmp38_ = _tmp37_;
#line 77 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_image_vertical ((GameHubDataGame*) self, _tmp38_);
#line 77 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp38_);
#line 79 "../src/data/sources/steam/SteamGame.vala"
	_tmp40_ = game_hub_data_game_get_image ((GameHubDataGame*) self);
#line 79 "../src/data/sources/steam/SteamGame.vala"
	_tmp41_ = _tmp40_;
#line 79 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp41_ == NULL) {
#line 79 "../src/data/sources/steam/SteamGame.vala"
		_tmp39_ = TRUE;
#line 1643 "SteamGame.c"
	} else {
		const gchar* _tmp42_;
		const gchar* _tmp43_;
#line 79 "../src/data/sources/steam/SteamGame.vala"
		_tmp42_ = game_hub_data_game_get_image ((GameHubDataGame*) self);
#line 79 "../src/data/sources/steam/SteamGame.vala"
		_tmp43_ = _tmp42_;
#line 79 "../src/data/sources/steam/SteamGame.vala"
		_tmp39_ = g_strcmp0 (_tmp43_, "") == 0;
#line 1653 "SteamGame.c"
	}
#line 79 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp39_) {
#line 1657 "SteamGame.c"
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
#line 81 "../src/data/sources/steam/SteamGame.vala"
		_tmp44_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 81 "../src/data/sources/steam/SteamGame.vala"
		_tmp45_ = _tmp44_;
#line 81 "../src/data/sources/steam/SteamGame.vala"
		_tmp46_ = string_to_string (_tmp45_);
#line 81 "../src/data/sources/steam/SteamGame.vala"
		_tmp47_ = g_strconcat ("http://cdn.akamai.steamstatic.com/steam/apps/", _tmp46_, "/header.jpg", NULL);
#line 81 "../src/data/sources/steam/SteamGame.vala"
		_tmp48_ = _tmp47_;
#line 81 "../src/data/sources/steam/SteamGame.vala"
		game_hub_data_game_set_image ((GameHubDataGame*) self, _tmp48_);
#line 81 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_tmp48_);
#line 1677 "SteamGame.c"
	}
#line 84 "../src/data/sources/steam/SteamGame.vala"
	_tmp50_ = game_hub_data_game_get_image_vertical ((GameHubDataGame*) self);
#line 84 "../src/data/sources/steam/SteamGame.vala"
	_tmp51_ = _tmp50_;
#line 84 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp51_ == NULL) {
#line 84 "../src/data/sources/steam/SteamGame.vala"
		_tmp49_ = TRUE;
#line 1687 "SteamGame.c"
	} else {
		const gchar* _tmp52_;
		const gchar* _tmp53_;
#line 84 "../src/data/sources/steam/SteamGame.vala"
		_tmp52_ = game_hub_data_game_get_image_vertical ((GameHubDataGame*) self);
#line 84 "../src/data/sources/steam/SteamGame.vala"
		_tmp53_ = _tmp52_;
#line 84 "../src/data/sources/steam/SteamGame.vala"
		_tmp49_ = g_strcmp0 (_tmp53_, "") == 0;
#line 1697 "SteamGame.c"
	}
#line 84 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp49_) {
#line 1701 "SteamGame.c"
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
#line 86 "../src/data/sources/steam/SteamGame.vala"
		_tmp54_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 86 "../src/data/sources/steam/SteamGame.vala"
		_tmp55_ = _tmp54_;
#line 86 "../src/data/sources/steam/SteamGame.vala"
		_tmp56_ = string_to_string (_tmp55_);
#line 86 "../src/data/sources/steam/SteamGame.vala"
		_tmp57_ = g_strconcat ("http://cdn.akamai.steamstatic.com/steam/apps/", _tmp56_, "/library_600x900_2x.jpg", NULL);
#line 86 "../src/data/sources/steam/SteamGame.vala"
		_tmp58_ = _tmp57_;
#line 86 "../src/data/sources/steam/SteamGame.vala"
		game_hub_data_game_set_image_vertical ((GameHubDataGame*) self, _tmp58_);
#line 86 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_tmp58_);
#line 1721 "SteamGame.c"
	}
#line 89 "../src/data/sources/steam/SteamGame.vala"
	_tmp59_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 89 "../src/data/sources/steam/SteamGame.vala"
	_tmp60_ = _tmp59_;
#line 89 "../src/data/sources/steam/SteamGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp60_);
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_tmp61_ = game_hub_data_db_tables_games_PLATFORMS;
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_tmp62_ = game_hub_data_db_table_field_get (_tmp61_, s);
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_tmp63_ = _tmp62_;
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_tmp65_ = _tmp64_ = g_strsplit (_tmp63_, ",", 0);
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_tmp66_ = _tmp65_;
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_tmp66__length1 = _vala_array_length (_tmp64_);
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp63_);
#line 90 "../src/data/sources/steam/SteamGame.vala"
	pls = _tmp66_;
#line 90 "../src/data/sources/steam/SteamGame.vala"
	pls_length1 = _tmp66__length1;
#line 90 "../src/data/sources/steam/SteamGame.vala"
	_pls_size_ = pls_length1;
#line 91 "../src/data/sources/steam/SteamGame.vala"
	_tmp67_ = pls;
#line 91 "../src/data/sources/steam/SteamGame.vala"
	_tmp67__length1 = pls_length1;
#line 1753 "SteamGame.c"
	{
		gchar** pl_collection = NULL;
		gint pl_collection_length1 = 0;
		gint _pl_collection_size_ = 0;
		gint pl_it = 0;
#line 91 "../src/data/sources/steam/SteamGame.vala"
		pl_collection = _tmp67_;
#line 91 "../src/data/sources/steam/SteamGame.vala"
		pl_collection_length1 = _tmp67__length1;
#line 91 "../src/data/sources/steam/SteamGame.vala"
		for (pl_it = 0; pl_it < pl_collection_length1; pl_it = pl_it + 1) {
#line 1765 "SteamGame.c"
			gchar* _tmp68_;
			gchar* pl = NULL;
#line 91 "../src/data/sources/steam/SteamGame.vala"
			_tmp68_ = g_strdup (pl_collection[pl_it]);
#line 91 "../src/data/sources/steam/SteamGame.vala"
			pl = _tmp68_;
#line 1772 "SteamGame.c"
			{
				{
					GameHubDataPlatform* p_collection = NULL;
					gint p_collection_length1 = 0;
					gint _p_collection_size_ = 0;
					gint p_it = 0;
#line 93 "../src/data/sources/steam/SteamGame.vala"
					p_collection = GAME_HUB_DATA_PLATFORM_PLATFORMS;
#line 93 "../src/data/sources/steam/SteamGame.vala"
					p_collection_length1 = G_N_ELEMENTS (GAME_HUB_DATA_PLATFORM_PLATFORMS);
#line 93 "../src/data/sources/steam/SteamGame.vala"
					for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 1785 "SteamGame.c"
						GameHubDataPlatform p = 0;
#line 93 "../src/data/sources/steam/SteamGame.vala"
						p = p_collection[p_it];
#line 1789 "SteamGame.c"
						{
							const gchar* _tmp69_;
							gchar* _tmp70_;
							gchar* _tmp71_;
							gboolean _tmp72_;
#line 95 "../src/data/sources/steam/SteamGame.vala"
							_tmp69_ = pl;
#line 95 "../src/data/sources/steam/SteamGame.vala"
							_tmp70_ = game_hub_data_platform_id (p);
#line 95 "../src/data/sources/steam/SteamGame.vala"
							_tmp71_ = _tmp70_;
#line 95 "../src/data/sources/steam/SteamGame.vala"
							_tmp72_ = g_strcmp0 (_tmp69_, _tmp71_) == 0;
#line 95 "../src/data/sources/steam/SteamGame.vala"
							_g_free0 (_tmp71_);
#line 95 "../src/data/sources/steam/SteamGame.vala"
							if (_tmp72_) {
#line 1807 "SteamGame.c"
								GeeArrayList* _tmp73_;
								GeeArrayList* _tmp74_;
#line 97 "../src/data/sources/steam/SteamGame.vala"
								_tmp73_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 97 "../src/data/sources/steam/SteamGame.vala"
								_tmp74_ = _tmp73_;
#line 97 "../src/data/sources/steam/SteamGame.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, (gpointer) ((gintptr) p));
#line 98 "../src/data/sources/steam/SteamGame.vala"
								break;
#line 1818 "SteamGame.c"
							}
						}
					}
				}
#line 91 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (pl);
#line 1825 "SteamGame.c"
			}
		}
	}
#line 103 "../src/data/sources/steam/SteamGame.vala"
	_tmp75_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 103 "../src/data/sources/steam/SteamGame.vala"
	_tmp76_ = _tmp75_;
#line 103 "../src/data/sources/steam/SteamGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp76_);
#line 104 "../src/data/sources/steam/SteamGame.vala"
	_tmp78_ = game_hub_data_db_tables_games_TAGS;
#line 104 "../src/data/sources/steam/SteamGame.vala"
	_tmp79_ = game_hub_data_db_table_field_get (_tmp78_, s);
#line 104 "../src/data/sources/steam/SteamGame.vala"
	_tmp77_ = _tmp79_;
#line 104 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp77_ == NULL) {
#line 1843 "SteamGame.c"
		gchar* _tmp80_;
#line 104 "../src/data/sources/steam/SteamGame.vala"
		_tmp80_ = g_strdup ("");
#line 104 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_tmp77_);
#line 104 "../src/data/sources/steam/SteamGame.vala"
		_tmp77_ = _tmp80_;
#line 1851 "SteamGame.c"
	}
#line 104 "../src/data/sources/steam/SteamGame.vala"
	_tmp82_ = _tmp81_ = g_strsplit (_tmp77_, ",", 0);
#line 104 "../src/data/sources/steam/SteamGame.vala"
	tag_ids = _tmp82_;
#line 104 "../src/data/sources/steam/SteamGame.vala"
	tag_ids_length1 = _vala_array_length (_tmp81_);
#line 104 "../src/data/sources/steam/SteamGame.vala"
	_tag_ids_size_ = tag_ids_length1;
#line 105 "../src/data/sources/steam/SteamGame.vala"
	_tmp83_ = tag_ids;
#line 105 "../src/data/sources/steam/SteamGame.vala"
	_tmp83__length1 = tag_ids_length1;
#line 1865 "SteamGame.c"
	{
		gchar** tid_collection = NULL;
		gint tid_collection_length1 = 0;
		gint _tid_collection_size_ = 0;
		gint tid_it = 0;
#line 105 "../src/data/sources/steam/SteamGame.vala"
		tid_collection = _tmp83_;
#line 105 "../src/data/sources/steam/SteamGame.vala"
		tid_collection_length1 = _tmp83__length1;
#line 105 "../src/data/sources/steam/SteamGame.vala"
		for (tid_it = 0; tid_it < tid_collection_length1; tid_it = tid_it + 1) {
#line 1877 "SteamGame.c"
			gchar* _tmp84_;
			gchar* tid = NULL;
#line 105 "../src/data/sources/steam/SteamGame.vala"
			_tmp84_ = g_strdup (tid_collection[tid_it]);
#line 105 "../src/data/sources/steam/SteamGame.vala"
			tid = _tmp84_;
#line 1884 "SteamGame.c"
			{
				{
					GeeArrayList* _t_list = NULL;
					GeeArrayList* _tmp85_;
					gint _t_size = 0;
					GeeArrayList* _tmp86_;
					gint _tmp87_;
					gint _tmp88_;
					gint _t_index = 0;
#line 107 "../src/data/sources/steam/SteamGame.vala"
					_tmp85_ = game_hub_data_db_tables_tags_TAGS;
#line 107 "../src/data/sources/steam/SteamGame.vala"
					_t_list = _tmp85_;
#line 107 "../src/data/sources/steam/SteamGame.vala"
					_tmp86_ = _t_list;
#line 107 "../src/data/sources/steam/SteamGame.vala"
					_tmp87_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp86_);
#line 107 "../src/data/sources/steam/SteamGame.vala"
					_tmp88_ = _tmp87_;
#line 107 "../src/data/sources/steam/SteamGame.vala"
					_t_size = _tmp88_;
#line 107 "../src/data/sources/steam/SteamGame.vala"
					_t_index = -1;
#line 107 "../src/data/sources/steam/SteamGame.vala"
					while (TRUE) {
#line 1910 "SteamGame.c"
						gint _tmp89_;
						gint _tmp90_;
						GameHubDataDBTablesTagsTag* t = NULL;
						GeeArrayList* _tmp91_;
						gpointer _tmp92_;
						const gchar* _tmp93_;
						GameHubDataDBTablesTagsTag* _tmp94_;
						const gchar* _tmp95_;
						const gchar* _tmp96_;
#line 107 "../src/data/sources/steam/SteamGame.vala"
						_t_index = _t_index + 1;
#line 107 "../src/data/sources/steam/SteamGame.vala"
						_tmp89_ = _t_index;
#line 107 "../src/data/sources/steam/SteamGame.vala"
						_tmp90_ = _t_size;
#line 107 "../src/data/sources/steam/SteamGame.vala"
						if (!(_tmp89_ < _tmp90_)) {
#line 107 "../src/data/sources/steam/SteamGame.vala"
							break;
#line 1930 "SteamGame.c"
						}
#line 107 "../src/data/sources/steam/SteamGame.vala"
						_tmp91_ = _t_list;
#line 107 "../src/data/sources/steam/SteamGame.vala"
						_tmp92_ = gee_abstract_list_get ((GeeAbstractList*) _tmp91_, _t_index);
#line 107 "../src/data/sources/steam/SteamGame.vala"
						t = (GameHubDataDBTablesTagsTag*) _tmp92_;
#line 109 "../src/data/sources/steam/SteamGame.vala"
						_tmp93_ = tid;
#line 109 "../src/data/sources/steam/SteamGame.vala"
						_tmp94_ = t;
#line 109 "../src/data/sources/steam/SteamGame.vala"
						_tmp95_ = game_hub_data_db_tables_tags_tag_get_id (_tmp94_);
#line 109 "../src/data/sources/steam/SteamGame.vala"
						_tmp96_ = _tmp95_;
#line 109 "../src/data/sources/steam/SteamGame.vala"
						if (g_strcmp0 (_tmp93_, _tmp96_) == 0) {
#line 1948 "SteamGame.c"
							GeeArrayList* _tmp97_;
							GeeArrayList* _tmp98_;
							GameHubDataDBTablesTagsTag* _tmp99_;
#line 111 "../src/data/sources/steam/SteamGame.vala"
							_tmp97_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 111 "../src/data/sources/steam/SteamGame.vala"
							_tmp98_ = _tmp97_;
#line 111 "../src/data/sources/steam/SteamGame.vala"
							_tmp99_ = t;
#line 111 "../src/data/sources/steam/SteamGame.vala"
							if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp98_, _tmp99_)) {
#line 1960 "SteamGame.c"
								GeeArrayList* _tmp100_;
								GeeArrayList* _tmp101_;
								GameHubDataDBTablesTagsTag* _tmp102_;
#line 111 "../src/data/sources/steam/SteamGame.vala"
								_tmp100_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 111 "../src/data/sources/steam/SteamGame.vala"
								_tmp101_ = _tmp100_;
#line 111 "../src/data/sources/steam/SteamGame.vala"
								_tmp102_ = t;
#line 111 "../src/data/sources/steam/SteamGame.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp101_, _tmp102_);
#line 1972 "SteamGame.c"
							}
#line 112 "../src/data/sources/steam/SteamGame.vala"
							_g_object_unref0 (t);
#line 112 "../src/data/sources/steam/SteamGame.vala"
							break;
#line 1978 "SteamGame.c"
						}
#line 107 "../src/data/sources/steam/SteamGame.vala"
						_g_object_unref0 (t);
#line 1982 "SteamGame.c"
					}
				}
#line 105 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (tid);
#line 1987 "SteamGame.c"
			}
		}
	}
#line 117 "../src/data/sources/steam/SteamGame.vala"
	_tmp103_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 117 "../src/data/sources/steam/SteamGame.vala"
	_tmp104_ = _tmp103_;
#line 117 "../src/data/sources/steam/SteamGame.vala"
	_tmp105_ = string_to_string (_tmp104_);
#line 117 "../src/data/sources/steam/SteamGame.vala"
	_tmp106_ = g_strconcat ("steam://store/", _tmp105_, NULL);
#line 117 "../src/data/sources/steam/SteamGame.vala"
	_tmp107_ = _tmp106_;
#line 117 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_store_page ((GameHubDataGame*) self, _tmp107_);
#line 117 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp107_);
#line 119 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 59 "../src/data/sources/steam/SteamGame.vala"
	tag_ids = (_vala_array_free (tag_ids, tag_ids_length1, (GDestroyNotify) g_free), NULL);
#line 59 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp77_);
#line 59 "../src/data/sources/steam/SteamGame.vala"
	pls = (_vala_array_free (pls, pls_length1, (GDestroyNotify) g_free), NULL);
#line 59 "../src/data/sources/steam/SteamGame.vala"
	return self;
#line 2015 "SteamGame.c"
}

GameHubDataSourcesSteamSteamGame*
game_hub_data_sources_steam_steam_game_new_from_db (GameHubDataSourcesSteamSteam* src,
                                                    sqlite3_stmt* s)
{
#line 59 "../src/data/sources/steam/SteamGame.vala"
	return game_hub_data_sources_steam_steam_game_construct_from_db (GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, src, s);
#line 2024 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_update_game_info_data_free (gpointer _data)
{
	GameHubDataSourcesSteamSteamGameUpdateGameInfoData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_slice_free (GameHubDataSourcesSteamSteamGameUpdateGameInfoData, _data_);
#line 2036 "SteamGame.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 26 "../src/data/sources/steam/SteamGame.vala"
	return self ? g_object_ref (self) : NULL;
#line 2044 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_update_game_info (GameHubDataGame* base,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGame * self;
	GameHubDataSourcesSteamSteamGameUpdateGameInfoData* _data_;
	GameHubDataSourcesSteamSteamGame* _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesSteamSteamGameUpdateGameInfoData);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_steam_steam_game_real_update_game_info_data_free);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_update_game_info_co (_data_);
#line 2069 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_update_game_info_finish (GameHubDataGame* base,
                                                                GAsyncResult* _res_)
{
	GameHubDataSourcesSteamSteamGameUpdateGameInfoData* _data_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2079 "SteamGame.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 131 "../src/data/sources/steam/SteamGame.vala"
	g_boxed_free (json_node_get_type (), self);
#line 2087 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_update_game_info_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGameUpdateGameInfoData* _data_;
#line 170 "../src/data/sources/steam/SteamGame.vala"
	_data_ = _user_data_;
#line 170 "../src/data/sources/steam/SteamGame.vala"
	_data_->_source_object_ = source_object;
#line 170 "../src/data/sources/steam/SteamGame.vala"
	_data_->_res_ = _res_;
#line 170 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_update_game_info_co (_data_);
#line 2104 "SteamGame.c"
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
#line 37 "glib-2.0.vapi"
	if (self) {
#line 2113 "SteamGame.c"
		gchar* _tmp0_;
#line 38 "glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "glib-2.0.vapi"
		result = _tmp0_;
#line 38 "glib-2.0.vapi"
		return result;
#line 2121 "SteamGame.c"
	} else {
		gchar* _tmp1_;
#line 40 "glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "glib-2.0.vapi"
		result = _tmp1_;
#line 40 "glib-2.0.vapi"
		return result;
#line 2130 "SteamGame.c"
	}
}

static gboolean
game_hub_data_sources_steam_steam_game_real_update_game_info_co (GameHubDataSourcesSteamSteamGameUpdateGameInfoData* _data_)
{
#line 122 "../src/data/sources/steam/SteamGame.vala"
	switch (_data_->_state_) {
#line 122 "../src/data/sources/steam/SteamGame.vala"
		case 0:
#line 2141 "SteamGame.c"
		goto _state_0;
#line 122 "../src/data/sources/steam/SteamGame.vala"
		case 1:
#line 2145 "SteamGame.c"
		goto _state_1;
		default:
#line 122 "../src/data/sources/steam/SteamGame.vala"
		g_assert_not_reached ();
#line 2150 "SteamGame.c"
	}
	_state_0:
#line 124 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->self->priv->game_info_updating) {
#line 124 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 124 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 124 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 124 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2163 "SteamGame.c"
			}
		}
#line 124 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 124 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 2170 "SteamGame.c"
	}
#line 125 "../src/data/sources/steam/SteamGame.vala"
	_data_->self->priv->game_info_updating = TRUE;
#line 127 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 129 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp1_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 129 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 129 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp2_ != NULL) {
#line 129 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp3_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 129 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 129 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp5_ = strlen (_data_->_tmp4_);
#line 129 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 129 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp0_ = _data_->_tmp6_ > 0;
#line 2192 "SteamGame.c"
	} else {
#line 129 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp0_ = FALSE;
#line 2196 "SteamGame.c"
	}
#line 129 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp0_) {
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp7_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp9_ = game_hub_utils_parser_parse_json (_data_->_tmp8_);
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp11_ = json_node_get_object (_data_->_tmp10_);
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp12_ = _json_object_ref0 (_data_->_tmp11_);
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 131 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->_tmp10_);
#line 131 "../src/data/sources/steam/SteamGame.vala"
		_data_->i = _data_->_tmp13_;
#line 132 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp15_ = game_hub_data_game_get_icon ((GameHubDataGame*) _data_->self);
#line 132 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp16_ = _data_->_tmp15_;
#line 132 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_tmp16_ == NULL) {
#line 132 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp14_ = TRUE;
#line 2226 "SteamGame.c"
		} else {
#line 132 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp17_ = game_hub_data_game_get_icon ((GameHubDataGame*) _data_->self);
#line 132 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp18_ = _data_->_tmp17_;
#line 132 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp14_ = g_strcmp0 (_data_->_tmp18_, "") == 0;
#line 2234 "SteamGame.c"
		}
#line 132 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_tmp14_) {
#line 134 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp19_ = _data_->i;
#line 134 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp20_ = json_object_get_string_member (_data_->_tmp19_, "img_icon_url");
#line 134 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
#line 134 "../src/data/sources/steam/SteamGame.vala"
			_data_->icon_hash = _data_->_tmp21_;
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp22_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp23_ = _data_->_tmp22_;
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp24_ = string_to_string (_data_->_tmp23_);
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp25_ = _data_->icon_hash;
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp26_ = string_to_string (_data_->_tmp25_);
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp27_ = g_strconcat ("http://media.steampowered.com/steamcommunity/public/images/apps/", _data_->_tmp24_, "/", _data_->_tmp26_, ".jpg", NULL);
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp28_ = _data_->_tmp27_;
#line 135 "../src/data/sources/steam/SteamGame.vala"
			game_hub_data_game_set_icon ((GameHubDataGame*) _data_->self, _data_->_tmp28_);
#line 135 "../src/data/sources/steam/SteamGame.vala"
			_g_free0 (_data_->_tmp28_);
#line 132 "../src/data/sources/steam/SteamGame.vala"
			_g_free0 (_data_->icon_hash);
#line 2266 "SteamGame.c"
		}
#line 137 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp29_ = game_hub_data_game_get_playtime_source ((GameHubDataGame*) _data_->self);
#line 137 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp30_ = _data_->_tmp29_;
#line 137 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_tmp30_ == ((gint64) 0)) {
#line 139 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp31_ = _data_->i;
#line 139 "../src/data/sources/steam/SteamGame.vala"
			game_hub_data_game_set_playtime_source ((GameHubDataGame*) _data_->self, json_object_get_int_member (_data_->_tmp31_, "playtime_forever"));
#line 2278 "SteamGame.c"
		}
#line 129 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->i);
#line 2282 "SteamGame.c"
	}
#line 144 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp32_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 144 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp33_ = _data_->_tmp32_;
#line 144 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp34_ = NULL;
#line 144 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_find_app_install_dir (_data_->_tmp33_, &_data_->_tmp34_);
#line 144 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->dir);
#line 144 "../src/data/sources/steam/SteamGame.vala"
	_data_->dir = _data_->_tmp34_;
#line 145 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp35_ = _data_->dir;
#line 145 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) _data_->self, _data_->_tmp35_);
#line 146 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp36_ = _data_->dir;
#line 146 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_set_work_dir ((GameHubDataRunnable*) _data_->self, _data_->_tmp36_);
#line 148 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp37_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 148 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp38_ = _data_->_tmp37_;
#line 148 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp39_ = game_hub_data_sources_steam_steam_get_appinfo (_data_->_tmp38_);
#line 148 "../src/data/sources/steam/SteamGame.vala"
	_data_->appinfo = _data_->_tmp39_;
#line 149 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp40_ = _data_->appinfo;
#line 149 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp40_ != NULL) {
#line 2316 "SteamGame.c"
	}
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp41_ = game_hub_data_sources_steam_steam_get_userdata_dir ();
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp42_ = _data_->_tmp41_;
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp43_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp44_ = _data_->_tmp43_;
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp45_ = string_to_string (_data_->_tmp44_);
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp46_ = g_strconcat ("760/remote/", _data_->_tmp45_, "/screenshots", NULL);
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp47_ = _data_->_tmp46_;
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp48_ = game_hub_utils_fs_utils_find_case_insensitive (_data_->_tmp42_, _data_->_tmp47_, NULL, (gint) 0);
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp49_ = _data_->_tmp48_;
#line 154 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_set_screenshots_dir (_data_->self, _data_->_tmp49_);
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->_tmp49_);
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->_tmp47_);
#line 154 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->_tmp42_);
#line 156 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->self->priv->game_info_updated) {
#line 158 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->game_info_updating = FALSE;
#line 159 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_utils_binary_vdf_node_unref0 (_data_->appinfo);
#line 159 "../src/data/sources/steam/SteamGame.vala"
		_g_object_unref0 (_data_->dir);
#line 159 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 159 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 159 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 159 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2360 "SteamGame.c"
			}
		}
#line 159 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 159 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 2367 "SteamGame.c"
	}
#line 162 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp51_ = game_hub_data_game_get_info_detailed ((GameHubDataGame*) _data_->self);
#line 162 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp52_ = _data_->_tmp51_;
#line 162 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp52_ == NULL) {
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp50_ = TRUE;
#line 2377 "SteamGame.c"
	} else {
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp53_ = game_hub_data_game_get_info_detailed ((GameHubDataGame*) _data_->self);
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp54_ = _data_->_tmp53_;
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp55_ = strlen (_data_->_tmp54_);
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp56_ = _data_->_tmp55_;
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp50_ = _data_->_tmp56_ == 0;
#line 2389 "SteamGame.c"
	}
#line 162 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp50_) {
#line 164 "../src/data/sources/steam/SteamGame.vala"
		if (game_hub_application_log_verbose) {
#line 166 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp57_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 166 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp58_ = _data_->_tmp57_;
#line 166 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp59_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) _data_->self);
#line 166 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp60_ = _data_->_tmp59_;
#line 166 "../src/data/sources/steam/SteamGame.vala"
			g_debug ("SteamGame.vala:166: [SteamGame] %s: no cached app data for '%s', fetch" \
"ing...", _data_->_tmp58_, _data_->_tmp60_);
#line 2405 "SteamGame.c"
		}
#line 168 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp61_ = game_hub_utils_get_language_name ();
#line 168 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp62_ = _data_->_tmp61_;
#line 168 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp63_ = g_utf8_strdown (_data_->_tmp62_, (gssize) -1);
#line 168 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp64_ = _data_->_tmp63_;
#line 168 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp62_);
#line 168 "../src/data/sources/steam/SteamGame.vala"
		_data_->lang = _data_->_tmp64_;
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp67_ = _data_->lang;
#line 169 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_tmp67_ != NULL) {
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp68_ = _data_->lang;
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp69_ = strlen (_data_->_tmp68_);
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp70_ = _data_->_tmp69_;
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp66_ = _data_->_tmp70_ > 0;
#line 2431 "SteamGame.c"
		} else {
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp66_ = FALSE;
#line 2435 "SteamGame.c"
		}
#line 169 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_tmp66_) {
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp71_ = _data_->lang;
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp72_ = g_strconcat ("&l=", _data_->_tmp71_, NULL);
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_g_free0 (_data_->_tmp65_);
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp65_ = _data_->_tmp72_;
#line 2447 "SteamGame.c"
		} else {
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp73_ = g_strdup ("");
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_g_free0 (_data_->_tmp65_);
#line 169 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp65_ = _data_->_tmp73_;
#line 2455 "SteamGame.c"
		}
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp74_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp75_ = _data_->_tmp74_;
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp76_ = string_to_string (_data_->_tmp75_);
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp77_ = g_strconcat ("https://store.steampowered.com/api/appdetails?appids=", _data_->_tmp76_, NULL);
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp78_ = _data_->_tmp77_;
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp79_ = g_strconcat (_data_->_tmp78_, _data_->_tmp65_, NULL);
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp80_ = _data_->_tmp79_;
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp78_);
#line 169 "../src/data/sources/steam/SteamGame.vala"
		_data_->url = _data_->_tmp80_;
#line 170 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp81_ = _data_->url;
#line 170 "../src/data/sources/steam/SteamGame.vala"
		_data_->_state_ = 1;
#line 170 "../src/data/sources/steam/SteamGame.vala"
		game_hub_utils_parser_load_remote_file_async (_data_->_tmp81_, "GET", NULL, NULL, NULL, game_hub_data_sources_steam_steam_game_update_game_info_ready, _data_);
#line 170 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 2483 "SteamGame.c"
		_state_1:
#line 170 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp82_ = game_hub_utils_parser_load_remote_file_finish (_data_->_res_, NULL);
#line 170 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp83_ = _data_->_tmp82_;
#line 170 "../src/data/sources/steam/SteamGame.vala"
		game_hub_data_game_set_info_detailed ((GameHubDataGame*) _data_->self, _data_->_tmp83_);
#line 170 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp83_);
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->url);
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp65_);
#line 162 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->lang);
#line 2499 "SteamGame.c"
	}
#line 173 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp84_ = game_hub_data_game_get_info_detailed ((GameHubDataGame*) _data_->self);
#line 173 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp85_ = _data_->_tmp84_;
#line 173 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp86_ = game_hub_utils_parser_parse_json (_data_->_tmp85_);
#line 173 "../src/data/sources/steam/SteamGame.vala"
	_data_->root = _data_->_tmp86_;
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp87_ = _data_->root;
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp88_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp89_ = _data_->_tmp88_;
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp90_ = g_strdup (_data_->_tmp89_);
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp91_ = g_new0 (gchar*, 1 + 1);
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp91_[0] = _data_->_tmp90_;
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp92_ = _data_->_tmp91_;
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp92__length1 = 1;
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp93_ = game_hub_utils_parser_json_object (_data_->_tmp87_, _data_->_tmp92_, (gint) 1);
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp94_ = _data_->_tmp93_;
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp92_ = (_vala_array_free (_data_->_tmp92_, _data_->_tmp92__length1, (GDestroyNotify) g_free), NULL);
#line 175 "../src/data/sources/steam/SteamGame.vala"
	_data_->app = _data_->_tmp94_;
#line 177 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp95_ = _data_->app;
#line 177 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp95_ == NULL) {
#line 179 "../src/data/sources/steam/SteamGame.vala"
		if (game_hub_application_log_verbose) {
#line 181 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp96_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 181 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp97_ = _data_->_tmp96_;
#line 181 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp98_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) _data_->self);
#line 181 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp99_ = _data_->_tmp98_;
#line 181 "../src/data/sources/steam/SteamGame.vala"
			g_debug ("SteamGame.vala:181: [SteamGame] %s: no app data for '%s', store page d" \
"oes not exist", _data_->_tmp97_, _data_->_tmp99_);
#line 2549 "SteamGame.c"
		}
#line 183 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->game_info_updated = TRUE;
#line 184 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->game_info_updating = FALSE;
#line 185 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->app);
#line 185 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->root);
#line 185 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_utils_binary_vdf_node_unref0 (_data_->appinfo);
#line 185 "../src/data/sources/steam/SteamGame.vala"
		_g_object_unref0 (_data_->dir);
#line 185 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 185 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 185 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 185 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2571 "SteamGame.c"
			}
		}
#line 185 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 185 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 2578 "SteamGame.c"
	}
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp100_ = _data_->root;
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp101_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp102_ = _data_->_tmp101_;
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp103_ = g_strdup (_data_->_tmp102_);
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp104_ = g_strdup ("data");
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp105_ = g_new0 (gchar*, 2 + 1);
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp105_[0] = _data_->_tmp103_;
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp105_[1] = _data_->_tmp104_;
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp106_ = _data_->_tmp105_;
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp106__length1 = 2;
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp107_ = game_hub_utils_parser_json_object (_data_->_tmp100_, _data_->_tmp106_, (gint) 2);
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp108_ = _data_->_tmp107_;
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp106_ = (_vala_array_free (_data_->_tmp106_, _data_->_tmp106__length1, (GDestroyNotify) g_free), NULL);
#line 188 "../src/data/sources/steam/SteamGame.vala"
	_data_->data = _data_->_tmp108_;
#line 190 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp109_ = _data_->data;
#line 190 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp109_ == NULL) {
#line 192 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp111_ = _data_->app;
#line 192 "../src/data/sources/steam/SteamGame.vala"
		if (json_object_has_member (_data_->_tmp111_, "success")) {
#line 192 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp112_ = _data_->app;
#line 192 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp110_ = json_object_get_boolean_member (_data_->_tmp112_, "success");
#line 2620 "SteamGame.c"
		} else {
#line 192 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp110_ = FALSE;
#line 2624 "SteamGame.c"
		}
#line 192 "../src/data/sources/steam/SteamGame.vala"
		_data_->success = _data_->_tmp110_;
#line 193 "../src/data/sources/steam/SteamGame.vala"
		if (game_hub_application_log_verbose) {
#line 195 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp113_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 195 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp114_ = _data_->_tmp113_;
#line 195 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp115_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) _data_->self);
#line 195 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp116_ = _data_->_tmp115_;
#line 195 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp117_ = bool_to_string (_data_->success);
#line 195 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp118_ = _data_->_tmp117_;
#line 195 "../src/data/sources/steam/SteamGame.vala"
			g_debug ("SteamGame.vala:195: [SteamGame] %s: no app data for '%s', success: %s," \
" store page does not exist", _data_->_tmp114_, _data_->_tmp116_, _data_->_tmp118_);
#line 195 "../src/data/sources/steam/SteamGame.vala"
			_g_free0 (_data_->_tmp118_);
#line 2646 "SteamGame.c"
		}
#line 197 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->self->priv->metadata_tries > 0) {
#line 199 "../src/data/sources/steam/SteamGame.vala"
			_data_->self->priv->game_info_updated = TRUE;
#line 200 "../src/data/sources/steam/SteamGame.vala"
			_data_->self->priv->game_info_updating = FALSE;
#line 201 "../src/data/sources/steam/SteamGame.vala"
			_json_object_unref0 (_data_->data);
#line 201 "../src/data/sources/steam/SteamGame.vala"
			_json_object_unref0 (_data_->app);
#line 201 "../src/data/sources/steam/SteamGame.vala"
			__vala_JsonNode_free0 (_data_->root);
#line 201 "../src/data/sources/steam/SteamGame.vala"
			_game_hub_utils_binary_vdf_node_unref0 (_data_->appinfo);
#line 201 "../src/data/sources/steam/SteamGame.vala"
			_g_object_unref0 (_data_->dir);
#line 201 "../src/data/sources/steam/SteamGame.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 201 "../src/data/sources/steam/SteamGame.vala"
			if (_data_->_state_ != 0) {
#line 201 "../src/data/sources/steam/SteamGame.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 201 "../src/data/sources/steam/SteamGame.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2672 "SteamGame.c"
				}
			}
#line 201 "../src/data/sources/steam/SteamGame.vala"
			g_object_unref (_data_->_async_result);
#line 201 "../src/data/sources/steam/SteamGame.vala"
			return FALSE;
#line 2679 "SteamGame.c"
		}
	}
#line 205 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp121_ = _data_->data;
#line 205 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp121_ != NULL) {
#line 205 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp122_ = _data_->data;
#line 205 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp120_ = json_object_has_member (_data_->_tmp122_, "detailed_description");
#line 2690 "SteamGame.c"
	} else {
#line 205 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp120_ = FALSE;
#line 2694 "SteamGame.c"
	}
#line 205 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp120_) {
#line 205 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp123_ = _data_->data;
#line 205 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp124_ = json_object_get_string_member (_data_->_tmp123_, "detailed_description");
#line 205 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp119_ = _data_->_tmp124_;
#line 2704 "SteamGame.c"
	} else {
#line 205 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp119_ = "";
#line 2708 "SteamGame.c"
	}
#line 205 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_description ((GameHubDataGame*) _data_->self, _data_->_tmp119_);
#line 207 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp125_ = _data_->self->priv->metadata_tries;
#line 207 "../src/data/sources/steam/SteamGame.vala"
	_data_->self->priv->metadata_tries = _data_->_tmp125_ + 1;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp126_ = _data_->root;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp127_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp128_ = _data_->_tmp127_;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp129_ = g_strdup (_data_->_tmp128_);
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp130_ = g_strdup ("data");
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp131_ = g_strdup ("platforms");
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp132_ = g_new0 (gchar*, 3 + 1);
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp132_[0] = _data_->_tmp129_;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp132_[1] = _data_->_tmp130_;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp132_[2] = _data_->_tmp131_;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp133_ = _data_->_tmp132_;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp133__length1 = 3;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp134_ = game_hub_utils_parser_json_object (_data_->_tmp126_, _data_->_tmp133_, (gint) 3);
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp135_ = _data_->_tmp134_;
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp133_ = (_vala_array_free (_data_->_tmp133_, _data_->_tmp133__length1, (GDestroyNotify) g_free), NULL);
#line 209 "../src/data/sources/steam/SteamGame.vala"
	_data_->platforms_json = _data_->_tmp135_;
#line 211 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp136_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) _data_->self);
#line 211 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp137_ = _data_->_tmp136_;
#line 211 "../src/data/sources/steam/SteamGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp137_);
#line 212 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp138_ = _data_->platforms_json;
#line 212 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp138_ == NULL) {
#line 214 "../src/data/sources/steam/SteamGame.vala"
		if (game_hub_application_log_verbose) {
#line 216 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp139_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 216 "../src/data/sources/steam/SteamGame.vala"
			_data_->_tmp140_ = _data_->_tmp139_;
#line 216 "../src/data/sources/steam/SteamGame.vala"
			g_debug ("SteamGame.vala:216: [SteamGame] %s: No platform support data, %d tries" \
" failed, assuming Windows support", _data_->_tmp140_, _data_->self->priv->metadata_tries);
#line 2766 "SteamGame.c"
		}
#line 218 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp141_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) _data_->self);
#line 218 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp142_ = _data_->_tmp141_;
#line 218 "../src/data/sources/steam/SteamGame.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp142_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_WINDOWS));
#line 219 "../src/data/sources/steam/SteamGame.vala"
		game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 220 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->game_info_updated = TRUE;
#line 221 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->game_info_updating = FALSE;
#line 222 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->platforms_json);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->data);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->app);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->root);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_utils_binary_vdf_node_unref0 (_data_->appinfo);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		_g_object_unref0 (_data_->dir);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 222 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 222 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2800 "SteamGame.c"
			}
		}
#line 222 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 222 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 2807 "SteamGame.c"
	}
	{
#line 225 "../src/data/sources/steam/SteamGame.vala"
		_data_->p_collection_length1 = 0;
#line 225 "../src/data/sources/steam/SteamGame.vala"
		_data_->_p_collection_size_ = 0;
#line 225 "../src/data/sources/steam/SteamGame.vala"
		_data_->p_collection = GAME_HUB_DATA_PLATFORM_PLATFORMS;
#line 225 "../src/data/sources/steam/SteamGame.vala"
		_data_->p_collection_length1 = G_N_ELEMENTS (GAME_HUB_DATA_PLATFORM_PLATFORMS);
#line 225 "../src/data/sources/steam/SteamGame.vala"
		for (_data_->p_it = 0; _data_->p_it < _data_->p_collection_length1; _data_->p_it = _data_->p_it + 1) {
#line 225 "../src/data/sources/steam/SteamGame.vala"
			_data_->p = _data_->p_collection[_data_->p_it];
#line 2822 "SteamGame.c"
			{
#line 227 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp144_ = _data_->platforms_json;
#line 227 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp145_ = game_hub_data_platform_id (_data_->p);
#line 227 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp146_ = _data_->_tmp145_;
#line 227 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp147_ = json_object_has_member (_data_->_tmp144_, _data_->_tmp146_);
#line 227 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (_data_->_tmp146_);
#line 227 "../src/data/sources/steam/SteamGame.vala"
				if (_data_->_tmp147_) {
#line 227 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp148_ = _data_->platforms_json;
#line 227 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp149_ = game_hub_data_platform_id (_data_->p);
#line 227 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp150_ = _data_->_tmp149_;
#line 227 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp143_ = json_object_get_boolean_member (_data_->_tmp148_, _data_->_tmp150_);
#line 227 "../src/data/sources/steam/SteamGame.vala"
					_g_free0 (_data_->_tmp150_);
#line 2846 "SteamGame.c"
				} else {
#line 227 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp143_ = FALSE;
#line 2850 "SteamGame.c"
				}
#line 227 "../src/data/sources/steam/SteamGame.vala"
				if (_data_->_tmp143_) {
#line 229 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp151_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) _data_->self);
#line 229 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp152_ = _data_->_tmp151_;
#line 229 "../src/data/sources/steam/SteamGame.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp152_, (gpointer) ((gintptr) _data_->p));
#line 2860 "SteamGame.c"
				}
			}
		}
	}
#line 233 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 235 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 237 "../src/data/sources/steam/SteamGame.vala"
	_data_->self->priv->game_info_updated = TRUE;
#line 238 "../src/data/sources/steam/SteamGame.vala"
	_data_->self->priv->game_info_updating = FALSE;
#line 122 "../src/data/sources/steam/SteamGame.vala"
	_json_object_unref0 (_data_->platforms_json);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	_json_object_unref0 (_data_->data);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	_json_object_unref0 (_data_->app);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	__vala_JsonNode_free0 (_data_->root);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	_game_hub_utils_binary_vdf_node_unref0 (_data_->appinfo);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->dir);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_state_ != 0) {
#line 122 "../src/data/sources/steam/SteamGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 122 "../src/data/sources/steam/SteamGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2893 "SteamGame.c"
		}
	}
#line 122 "../src/data/sources/steam/SteamGame.vala"
	g_object_unref (_data_->_async_result);
#line 122 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 2900 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_update_status (GameHubDataRunnable* base)
{
	GameHubDataSourcesSteamSteamGame * self;
	GameHubDataGameState state = 0;
	gboolean _tmp0_;
	GameHubDataGameStatus* _tmp7_;
	GameHubDataGameStatus* _tmp8_;
#line 241 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 243 "../src/data/sources/steam/SteamGame.vala"
	state = GAME_HUB_DATA_GAME_STATE_UNINSTALLED;
#line 244 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = self->priv->_is_updating;
#line 244 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp0_) {
#line 246 "../src/data/sources/steam/SteamGame.vala"
		state = GAME_HUB_DATA_GAME_STATE_INSTALLING;
#line 2921 "SteamGame.c"
	} else {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
#line 248 "../src/data/sources/steam/SteamGame.vala"
		_tmp1_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 248 "../src/data/sources/steam/SteamGame.vala"
		_tmp2_ = _tmp1_;
#line 248 "../src/data/sources/steam/SteamGame.vala"
		if (game_hub_data_sources_steam_steam_is_app_installed (_tmp2_)) {
#line 2931 "SteamGame.c"
			GameHubDataDBTablesTagsTag* _tmp3_;
			GameHubDataDBTablesTagsTag* _tmp4_;
#line 250 "../src/data/sources/steam/SteamGame.vala"
			state = GAME_HUB_DATA_GAME_STATE_INSTALLED;
#line 251 "../src/data/sources/steam/SteamGame.vala"
			_tmp3_ = game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
#line 251 "../src/data/sources/steam/SteamGame.vala"
			game_hub_data_game_remove_tag ((GameHubDataGame*) self, _tmp3_);
#line 252 "../src/data/sources/steam/SteamGame.vala"
			_tmp4_ = game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
#line 252 "../src/data/sources/steam/SteamGame.vala"
			game_hub_data_game_add_tag ((GameHubDataGame*) self, _tmp4_);
#line 2944 "SteamGame.c"
		} else {
			GameHubDataDBTablesTagsTag* _tmp5_;
			GameHubDataDBTablesTagsTag* _tmp6_;
#line 256 "../src/data/sources/steam/SteamGame.vala"
			_tmp5_ = game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
#line 256 "../src/data/sources/steam/SteamGame.vala"
			game_hub_data_game_add_tag ((GameHubDataGame*) self, _tmp5_);
#line 257 "../src/data/sources/steam/SteamGame.vala"
			_tmp6_ = game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
#line 257 "../src/data/sources/steam/SteamGame.vala"
			game_hub_data_game_remove_tag ((GameHubDataGame*) self, _tmp6_);
#line 2956 "SteamGame.c"
		}
	}
#line 259 "../src/data/sources/steam/SteamGame.vala"
	_tmp7_ = game_hub_data_game_status_new (state, (GameHubDataGame*) self, NULL);
#line 259 "../src/data/sources/steam/SteamGame.vala"
	_tmp8_ = _tmp7_;
#line 259 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_status ((GameHubDataGame*) self, _tmp8_);
#line 259 "../src/data/sources/steam/SteamGame.vala"
	_game_hub_data_game_status_unref0 (_tmp8_);
#line 2967 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_install_data_free (gpointer _data)
{
	GameHubDataSourcesSteamSteamGameInstallData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_slice_free (GameHubDataSourcesSteamSteamGameInstallData, _data_);
#line 2979 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_install (GameHubDataRunnable* base,
                                                     GameHubDataRunnableInstallerInstallMode install_mode,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGame * self;
	GameHubDataSourcesSteamSteamGameInstallData* _data_;
	GameHubDataSourcesSteamSteamGame* _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesSteamSteamGameInstallData);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_steam_steam_game_real_install_data_free);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->install_mode = install_mode;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_install_co (_data_);
#line 3007 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_install_finish (GameHubDataRunnable* base,
                                                       GAsyncResult* _res_)
{
	GameHubDataSourcesSteamSteamGameInstallData* _data_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3017 "SteamGame.c"
}

static gboolean
game_hub_data_sources_steam_steam_game_real_install_co (GameHubDataSourcesSteamSteamGameInstallData* _data_)
{
#line 262 "../src/data/sources/steam/SteamGame.vala"
	switch (_data_->_state_) {
#line 262 "../src/data/sources/steam/SteamGame.vala"
		case 0:
#line 3027 "SteamGame.c"
		goto _state_0;
		default:
#line 262 "../src/data/sources/steam/SteamGame.vala"
		g_assert_not_reached ();
#line 3032 "SteamGame.c"
	}
	_state_0:
#line 264 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp0_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 264 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 264 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_install_app (_data_->_tmp1_);
#line 265 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 262 "../src/data/sources/steam/SteamGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 262 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_state_ != 0) {
#line 262 "../src/data/sources/steam/SteamGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 262 "../src/data/sources/steam/SteamGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3051 "SteamGame.c"
		}
	}
#line 262 "../src/data/sources/steam/SteamGame.vala"
	g_object_unref (_data_->_async_result);
#line 262 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3058 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_run_data_free (gpointer _data)
{
	GameHubDataSourcesSteamSteamGameRunData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_slice_free (GameHubDataSourcesSteamSteamGameRunData, _data_);
#line 3070 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_run (GameHubDataRunnable* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGame * self;
	GameHubDataSourcesSteamSteamGameRunData* _data_;
	GameHubDataSourcesSteamSteamGame* _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesSteamSteamGameRunData);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_steam_steam_game_real_run_data_free);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_run_co (_data_);
#line 3095 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_run_finish (GameHubDataRunnable* base,
                                                   GAsyncResult* _res_)
{
	GameHubDataSourcesSteamSteamGameRunData* _data_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3105 "SteamGame.c"
}

static gboolean
game_hub_data_sources_steam_steam_game_real_run_co (GameHubDataSourcesSteamSteamGameRunData* _data_)
{
#line 268 "../src/data/sources/steam/SteamGame.vala"
	switch (_data_->_state_) {
#line 268 "../src/data/sources/steam/SteamGame.vala"
		case 0:
#line 3115 "SteamGame.c"
		goto _state_0;
		default:
#line 268 "../src/data/sources/steam/SteamGame.vala"
		g_assert_not_reached ();
#line 3120 "SteamGame.c"
	}
	_state_0:
#line 270 "../src/data/sources/steam/SteamGame.vala"
	if (!game_hub_data_runnable_can_be_launched ((GameHubDataRunnable*) _data_->self, TRUE)) {
#line 270 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 270 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 270 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 270 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3133 "SteamGame.c"
			}
		}
#line 270 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 270 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 3140 "SteamGame.c"
	}
#line 271 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_last_launch ((GameHubDataGame*) _data_->self, g_get_real_time () / 1000000);
#line 272 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 273 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp0_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 273 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 273 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp2_ = string_to_string (_data_->_tmp1_);
#line 273 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp3_ = g_strconcat ("steam://rungameid/", _data_->_tmp2_, NULL);
#line 273 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 273 "../src/data/sources/steam/SteamGame.vala"
	game_hub_utils_open_uri (_data_->_tmp4_);
#line 273 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->_tmp4_);
#line 274 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 268 "../src/data/sources/steam/SteamGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 268 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_state_ != 0) {
#line 268 "../src/data/sources/steam/SteamGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 268 "../src/data/sources/steam/SteamGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3170 "SteamGame.c"
		}
	}
#line 268 "../src/data/sources/steam/SteamGame.vala"
	g_object_unref (_data_->_async_result);
#line 268 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3177 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_run_with_compat_data_free (gpointer _data)
{
	GameHubDataSourcesSteamSteamGameRunWithCompatData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_slice_free (GameHubDataSourcesSteamSteamGameRunWithCompatData, _data_);
#line 3189 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_run_with_compat (GameHubDataRunnable* base,
                                                             gboolean is_opened_from_menu,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGame * self;
	GameHubDataSourcesSteamSteamGameRunWithCompatData* _data_;
	GameHubDataSourcesSteamSteamGame* _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesSteamSteamGameRunWithCompatData);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_steam_steam_game_real_run_with_compat_data_free);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->is_opened_from_menu = is_opened_from_menu;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_run_with_compat_co (_data_);
#line 3217 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_run_with_compat_finish (GameHubDataRunnable* base,
                                                               GAsyncResult* _res_)
{
	GameHubDataSourcesSteamSteamGameRunWithCompatData* _data_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3227 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_run_with_compat_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGameRunWithCompatData* _data_;
#line 279 "../src/data/sources/steam/SteamGame.vala"
	_data_ = _user_data_;
#line 279 "../src/data/sources/steam/SteamGame.vala"
	_data_->_source_object_ = source_object;
#line 279 "../src/data/sources/steam/SteamGame.vala"
	_data_->_res_ = _res_;
#line 279 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_run_with_compat_co (_data_);
#line 3244 "SteamGame.c"
}

static gboolean
game_hub_data_sources_steam_steam_game_real_run_with_compat_co (GameHubDataSourcesSteamSteamGameRunWithCompatData* _data_)
{
#line 277 "../src/data/sources/steam/SteamGame.vala"
	switch (_data_->_state_) {
#line 277 "../src/data/sources/steam/SteamGame.vala"
		case 0:
#line 3254 "SteamGame.c"
		goto _state_0;
#line 277 "../src/data/sources/steam/SteamGame.vala"
		case 1:
#line 3258 "SteamGame.c"
		goto _state_1;
		default:
#line 277 "../src/data/sources/steam/SteamGame.vala"
		g_assert_not_reached ();
#line 3263 "SteamGame.c"
	}
	_state_0:
#line 279 "../src/data/sources/steam/SteamGame.vala"
	_data_->_state_ = 1;
#line 279 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_run ((GameHubDataRunnable*) _data_->self, game_hub_data_sources_steam_steam_game_run_with_compat_ready, _data_);
#line 279 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3272 "SteamGame.c"
	_state_1:
#line 279 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_run_finish ((GameHubDataRunnable*) _data_->self, _data_->_res_);
#line 277 "../src/data/sources/steam/SteamGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 277 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_state_ != 0) {
#line 277 "../src/data/sources/steam/SteamGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 277 "../src/data/sources/steam/SteamGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3284 "SteamGame.c"
		}
	}
#line 277 "../src/data/sources/steam/SteamGame.vala"
	g_object_unref (_data_->_async_result);
#line 277 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3291 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_uninstall_data_free (gpointer _data)
{
	GameHubDataSourcesSteamSteamGameUninstallData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_slice_free (GameHubDataSourcesSteamSteamGameUninstallData, _data_);
#line 3303 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_uninstall (GameHubDataGame* base,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGame * self;
	GameHubDataSourcesSteamSteamGameUninstallData* _data_;
	GameHubDataSourcesSteamSteamGame* _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesSteamSteamGameUninstallData);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_steam_steam_game_real_uninstall_data_free);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_uninstall_co (_data_);
#line 3328 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_uninstall_finish (GameHubDataGame* base,
                                                         GAsyncResult* _res_)
{
	GameHubDataSourcesSteamSteamGameUninstallData* _data_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3338 "SteamGame.c"
}

static gboolean
game_hub_data_sources_steam_steam_game_real_uninstall_co (GameHubDataSourcesSteamSteamGameUninstallData* _data_)
{
#line 282 "../src/data/sources/steam/SteamGame.vala"
	switch (_data_->_state_) {
#line 282 "../src/data/sources/steam/SteamGame.vala"
		case 0:
#line 3348 "SteamGame.c"
		goto _state_0;
		default:
#line 282 "../src/data/sources/steam/SteamGame.vala"
		g_assert_not_reached ();
#line 3353 "SteamGame.c"
	}
	_state_0:
#line 284 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp0_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 284 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 284 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp2_ = string_to_string (_data_->_tmp1_);
#line 284 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp3_ = g_strconcat ("steam://uninstall/", _data_->_tmp2_, NULL);
#line 284 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 284 "../src/data/sources/steam/SteamGame.vala"
	game_hub_utils_open_uri (_data_->_tmp4_);
#line 284 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->_tmp4_);
#line 285 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 282 "../src/data/sources/steam/SteamGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 282 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_state_ != 0) {
#line 282 "../src/data/sources/steam/SteamGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 282 "../src/data/sources/steam/SteamGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3380 "SteamGame.c"
		}
	}
#line 282 "../src/data/sources/steam/SteamGame.vala"
	g_object_unref (_data_->_async_result);
#line 282 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3387 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_load_achievements_data_free (gpointer _data)
{
	GameHubDataSourcesSteamSteamGameLoadAchievementsData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->result);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_slice_free (GameHubDataSourcesSteamSteamGameLoadAchievementsData, _data_);
#line 3401 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_load_achievements (GameHubDataGame* base,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGame * self;
	GameHubDataSourcesSteamSteamGameLoadAchievementsData* _data_;
	GameHubDataSourcesSteamSteamGame* _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesSteamSteamGameLoadAchievementsData);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_steam_steam_game_real_load_achievements_data_free);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_load_achievements_co (_data_);
#line 3426 "SteamGame.c"
}

static GeeArrayList*
game_hub_data_sources_steam_steam_game_load_achievements_finish (GameHubDataGame* base,
                                                                 GAsyncResult* _res_)
{
	GeeArrayList* result;
	GameHubDataSourcesSteamSteamGameLoadAchievementsData* _data_;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	result = _data_->result;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	_data_->result = NULL;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	return result;
#line 3443 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_load_achievements_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	GameHubDataSourcesSteamSteamGameLoadAchievementsData* _data_;
#line 305 "../src/data/sources/steam/SteamGame.vala"
	_data_ = _user_data_;
#line 305 "../src/data/sources/steam/SteamGame.vala"
	_data_->_source_object_ = source_object;
#line 305 "../src/data/sources/steam/SteamGame.vala"
	_data_->_res_ = _res_;
#line 305 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_real_load_achievements_co (_data_);
#line 3460 "SteamGame.c"
}

static gpointer
_json_array_ref0 (gpointer self)
{
#line 315 "../src/data/sources/steam/SteamGame.vala"
	return self ? json_array_ref (self) : NULL;
#line 3468 "SteamGame.c"
}

static gpointer
_game_hub_data_game_achievement_ref0 (gpointer self)
{
#line 379 "../src/data/sources/steam/SteamGame.vala"
	return self ? game_hub_data_game_achievement_ref (self) : NULL;
#line 3476 "SteamGame.c"
}

static gint
__lambda129_ (GameHubDataSourcesSteamSteamGame* self,
              GameHubDataGameAchievement* first,
              GameHubDataGameAchievement* second)
{
	GameHubDataSourcesSteamSteamGameAchievement* a1 = NULL;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp0_;
	GameHubDataSourcesSteamSteamGameAchievement* a2 = NULL;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp3_;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	GameHubDataSourcesSteamSteamGameAchievement* _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_;
	gint result;
#line 378 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (first != NULL, 0);
#line 378 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (second != NULL, 0);
#line 379 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = _game_hub_data_game_achievement_ref0 (GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_ACHIEVEMENT (first) ? ((GameHubDataSourcesSteamSteamGameAchievement*) first) : NULL);
#line 379 "../src/data/sources/steam/SteamGame.vala"
	a1 = _tmp0_;
#line 380 "../src/data/sources/steam/SteamGame.vala"
	_tmp1_ = _game_hub_data_game_achievement_ref0 (GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_ACHIEVEMENT (second) ? ((GameHubDataSourcesSteamSteamGameAchievement*) second) : NULL);
#line 380 "../src/data/sources/steam/SteamGame.vala"
	a2 = _tmp1_;
#line 382 "../src/data/sources/steam/SteamGame.vala"
	_tmp3_ = a1;
#line 382 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp3_->unlock_timestamp > ((gint64) 0)) {
#line 382 "../src/data/sources/steam/SteamGame.vala"
		_tmp2_ = TRUE;
#line 3521 "SteamGame.c"
	} else {
		GameHubDataSourcesSteamSteamGameAchievement* _tmp4_;
#line 382 "../src/data/sources/steam/SteamGame.vala"
		_tmp4_ = a2;
#line 382 "../src/data/sources/steam/SteamGame.vala"
		_tmp2_ = _tmp4_->unlock_timestamp > ((gint64) 0);
#line 3528 "SteamGame.c"
	}
#line 382 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp2_) {
#line 3532 "SteamGame.c"
		GameHubDataSourcesSteamSteamGameAchievement* _tmp5_;
		GameHubDataSourcesSteamSteamGameAchievement* _tmp6_;
#line 384 "../src/data/sources/steam/SteamGame.vala"
		_tmp5_ = a2;
#line 384 "../src/data/sources/steam/SteamGame.vala"
		_tmp6_ = a1;
#line 384 "../src/data/sources/steam/SteamGame.vala"
		result = (gint) (_tmp5_->unlock_timestamp - _tmp6_->unlock_timestamp);
#line 384 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_data_game_achievement_unref0 (a2);
#line 384 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_data_game_achievement_unref0 (a1);
#line 384 "../src/data/sources/steam/SteamGame.vala"
		return result;
#line 3547 "SteamGame.c"
	}
#line 387 "../src/data/sources/steam/SteamGame.vala"
	_tmp7_ = a1;
#line 387 "../src/data/sources/steam/SteamGame.vala"
	_tmp8_ = game_hub_data_game_achievement_get_global_percentage ((GameHubDataGameAchievement*) _tmp7_);
#line 387 "../src/data/sources/steam/SteamGame.vala"
	_tmp9_ = _tmp8_;
#line 387 "../src/data/sources/steam/SteamGame.vala"
	_tmp10_ = a2;
#line 387 "../src/data/sources/steam/SteamGame.vala"
	_tmp11_ = game_hub_data_game_achievement_get_global_percentage ((GameHubDataGameAchievement*) _tmp10_);
#line 387 "../src/data/sources/steam/SteamGame.vala"
	_tmp12_ = _tmp11_;
#line 387 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp9_ < _tmp12_) {
#line 387 "../src/data/sources/steam/SteamGame.vala"
		result = 1;
#line 387 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_data_game_achievement_unref0 (a2);
#line 387 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_data_game_achievement_unref0 (a1);
#line 387 "../src/data/sources/steam/SteamGame.vala"
		return result;
#line 3571 "SteamGame.c"
	}
#line 388 "../src/data/sources/steam/SteamGame.vala"
	_tmp13_ = a1;
#line 388 "../src/data/sources/steam/SteamGame.vala"
	_tmp14_ = game_hub_data_game_achievement_get_global_percentage ((GameHubDataGameAchievement*) _tmp13_);
#line 388 "../src/data/sources/steam/SteamGame.vala"
	_tmp15_ = _tmp14_;
#line 388 "../src/data/sources/steam/SteamGame.vala"
	_tmp16_ = a2;
#line 388 "../src/data/sources/steam/SteamGame.vala"
	_tmp17_ = game_hub_data_game_achievement_get_global_percentage ((GameHubDataGameAchievement*) _tmp16_);
#line 388 "../src/data/sources/steam/SteamGame.vala"
	_tmp18_ = _tmp17_;
#line 388 "../src/data/sources/steam/SteamGame.vala"
	if (_tmp15_ > _tmp18_) {
#line 388 "../src/data/sources/steam/SteamGame.vala"
		result = -1;
#line 388 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_data_game_achievement_unref0 (a2);
#line 388 "../src/data/sources/steam/SteamGame.vala"
		_game_hub_data_game_achievement_unref0 (a1);
#line 388 "../src/data/sources/steam/SteamGame.vala"
		return result;
#line 3595 "SteamGame.c"
	}
#line 389 "../src/data/sources/steam/SteamGame.vala"
	result = 0;
#line 389 "../src/data/sources/steam/SteamGame.vala"
	_game_hub_data_game_achievement_unref0 (a2);
#line 389 "../src/data/sources/steam/SteamGame.vala"
	_game_hub_data_game_achievement_unref0 (a1);
#line 389 "../src/data/sources/steam/SteamGame.vala"
	return result;
#line 3605 "SteamGame.c"
}

static gint
___lambda129__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda129_ ((GameHubDataSourcesSteamSteamGame*) self, (GameHubDataGameAchievement*) a, (GameHubDataGameAchievement*) b);
#line 378 "../src/data/sources/steam/SteamGame.vala"
	return result;
#line 3617 "SteamGame.c"
}

static gboolean
game_hub_data_sources_steam_steam_game_real_load_achievements_co (GameHubDataSourcesSteamSteamGameLoadAchievementsData* _data_)
{
#line 289 "../src/data/sources/steam/SteamGame.vala"
	switch (_data_->_state_) {
#line 289 "../src/data/sources/steam/SteamGame.vala"
		case 0:
#line 3627 "SteamGame.c"
		goto _state_0;
#line 289 "../src/data/sources/steam/SteamGame.vala"
		case 1:
#line 3631 "SteamGame.c"
		goto _state_1;
#line 289 "../src/data/sources/steam/SteamGame.vala"
		case 2:
#line 3635 "SteamGame.c"
		goto _state_2;
#line 289 "../src/data/sources/steam/SteamGame.vala"
		case 3:
#line 3639 "SteamGame.c"
		goto _state_3;
		default:
#line 289 "../src/data/sources/steam/SteamGame.vala"
		g_assert_not_reached ();
#line 3644 "SteamGame.c"
	}
	_state_0:
#line 291 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp1_ = game_hub_data_game_get_achievements ((GameHubDataGame*) _data_->self);
#line 291 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 291 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp2_ != NULL) {
#line 291 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp0_ = TRUE;
#line 3655 "SteamGame.c"
	} else {
#line 291 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp0_ = _data_->self->priv->loading_achievements;
#line 3659 "SteamGame.c"
	}
#line 291 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp0_) {
#line 293 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp3_ = game_hub_data_game_get_achievements ((GameHubDataGame*) _data_->self);
#line 293 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 293 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
#line 293 "../src/data/sources/steam/SteamGame.vala"
		_data_->result = _data_->_tmp5_;
#line 293 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 293 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 293 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 293 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3679 "SteamGame.c"
			}
		}
#line 293 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 293 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 3686 "SteamGame.c"
	}
#line 296 "../src/data/sources/steam/SteamGame.vala"
	_data_->self->priv->loading_achievements = TRUE;
#line 298 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp6_ = game_hub_utils_get_language_name ();
#line 298 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 298 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp8_ = g_utf8_strdown (_data_->_tmp7_, (gssize) -1);
#line 298 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 298 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->_tmp7_);
#line 298 "../src/data/sources/steam/SteamGame.vala"
	_data_->lang = _data_->_tmp9_;
#line 299 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp12_ = _data_->lang;
#line 299 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp12_ != NULL) {
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp13_ = _data_->lang;
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp14_ = strlen (_data_->_tmp13_);
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp11_ = _data_->_tmp15_ > 0;
#line 3714 "SteamGame.c"
	} else {
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp11_ = FALSE;
#line 3718 "SteamGame.c"
	}
#line 299 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp11_) {
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp16_ = _data_->lang;
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp17_ = g_strconcat ("&l=", _data_->_tmp16_, NULL);
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp10_);
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp10_ = _data_->_tmp17_;
#line 3730 "SteamGame.c"
	} else {
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp18_ = g_strdup ("");
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp10_);
#line 299 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp10_ = _data_->_tmp18_;
#line 3738 "SteamGame.c"
	}
#line 299 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp19_ = g_strdup (_data_->_tmp10_);
#line 299 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->lang);
#line 299 "../src/data/sources/steam/SteamGame.vala"
	_data_->lang = _data_->_tmp19_;
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp20_ = game_hub_data_sources_steam_steam_instance;
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp21_ = _data_->_tmp20_->api_key;
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp22_ = string_to_string (_data_->_tmp21_);
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp23_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp24_ = _data_->_tmp23_;
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp25_ = string_to_string (_data_->_tmp24_);
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp26_ = _data_->lang;
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp27_ = string_to_string (_data_->_tmp26_);
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp28_ = g_strconcat ("https://api.steampowered.com/ISteamUserStats/GetSchemaForGame/v2/?key=", _data_->_tmp22_, "&format=json&appid=", _data_->_tmp25_, _data_->_tmp27_, NULL);
#line 301 "../src/data/sources/steam/SteamGame.vala"
	_data_->schema_url = _data_->_tmp28_;
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp29_ = game_hub_data_sources_steam_steam_instance;
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp30_ = _data_->_tmp29_->api_key;
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp31_ = string_to_string (_data_->_tmp30_);
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp32_ = game_hub_data_sources_steam_steam_instance;
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp33_ = game_hub_data_sources_steam_steam_get_user_id (_data_->_tmp32_);
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp34_ = _data_->_tmp33_;
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp35_ = string_to_string (_data_->_tmp34_);
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp36_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp37_ = _data_->_tmp36_;
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp38_ = string_to_string (_data_->_tmp37_);
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp39_ = _data_->lang;
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp40_ = string_to_string (_data_->_tmp39_);
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp41_ = g_strconcat ("https://api.steampowered.com/ISteamUserStats/GetPlayerAchievements/v1/" \
"?key=", _data_->_tmp31_, "&steamid=", _data_->_tmp35_, "&format=json&appid=", _data_->_tmp38_, _data_->_tmp40_, NULL);
#line 302 "../src/data/sources/steam/SteamGame.vala"
	_data_->achievements_url = _data_->_tmp41_;
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp42_ = game_hub_data_sources_steam_steam_instance;
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp43_ = _data_->_tmp42_->api_key;
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp44_ = string_to_string (_data_->_tmp43_);
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp45_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp46_ = _data_->_tmp45_;
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp47_ = string_to_string (_data_->_tmp46_);
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp48_ = g_strconcat ("https://api.steampowered.com/ISteamUserStats/GetGlobalAchievementPerce" \
"ntagesForApp/v2/?key=", _data_->_tmp44_, "&format=json&gameid=", _data_->_tmp47_, NULL);
#line 303 "../src/data/sources/steam/SteamGame.vala"
	_data_->global_percentages_url = _data_->_tmp48_;
#line 305 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp49_ = _data_->schema_url;
#line 305 "../src/data/sources/steam/SteamGame.vala"
	_data_->_state_ = 1;
#line 305 "../src/data/sources/steam/SteamGame.vala"
	game_hub_utils_parser_parse_remote_json_file_async (_data_->_tmp49_, "GET", NULL, NULL, NULL, game_hub_data_sources_steam_steam_game_load_achievements_ready, _data_);
#line 305 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3818 "SteamGame.c"
	_state_1:
#line 305 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp50_ = game_hub_utils_parser_parse_remote_json_file_finish (_data_->_res_, NULL);
#line 305 "../src/data/sources/steam/SteamGame.vala"
	_data_->schema_root = _data_->_tmp50_;
#line 306 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp51_ = _data_->achievements_url;
#line 306 "../src/data/sources/steam/SteamGame.vala"
	_data_->_state_ = 2;
#line 306 "../src/data/sources/steam/SteamGame.vala"
	game_hub_utils_parser_parse_remote_json_file_async (_data_->_tmp51_, "GET", NULL, NULL, NULL, game_hub_data_sources_steam_steam_game_load_achievements_ready, _data_);
#line 306 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3832 "SteamGame.c"
	_state_2:
#line 306 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp52_ = game_hub_utils_parser_parse_remote_json_file_finish (_data_->_res_, NULL);
#line 306 "../src/data/sources/steam/SteamGame.vala"
	_data_->achievements_root = _data_->_tmp52_;
#line 307 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp53_ = _data_->global_percentages_url;
#line 307 "../src/data/sources/steam/SteamGame.vala"
	_data_->_state_ = 3;
#line 307 "../src/data/sources/steam/SteamGame.vala"
	game_hub_utils_parser_parse_remote_json_file_async (_data_->_tmp53_, "GET", NULL, NULL, NULL, game_hub_data_sources_steam_steam_game_load_achievements_ready, _data_);
#line 307 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 3846 "SteamGame.c"
	_state_3:
#line 307 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp54_ = game_hub_utils_parser_parse_remote_json_file_finish (_data_->_res_, NULL);
#line 307 "../src/data/sources/steam/SteamGame.vala"
	_data_->global_percentages_root = _data_->_tmp54_;
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp55_ = _data_->schema_root;
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp56_ = g_strdup ("game");
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp57_ = g_strdup ("availableGameStats");
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp58_ = g_new0 (gchar*, 2 + 1);
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp58_[0] = _data_->_tmp56_;
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp58_[1] = _data_->_tmp57_;
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp59_ = _data_->_tmp58_;
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp59__length1 = 2;
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp60_ = game_hub_utils_parser_json_object (_data_->_tmp55_, _data_->_tmp59_, (gint) 2);
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp61_ = _data_->_tmp60_;
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp59_ = (_vala_array_free (_data_->_tmp59_, _data_->_tmp59__length1, (GDestroyNotify) g_free), NULL);
#line 309 "../src/data/sources/steam/SteamGame.vala"
	_data_->schema_achievements_obj = _data_->_tmp61_;
#line 310 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp63_ = _data_->schema_achievements_obj;
#line 310 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp63_ == NULL) {
#line 310 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp62_ = TRUE;
#line 3882 "SteamGame.c"
	} else {
#line 310 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp64_ = _data_->schema_achievements_obj;
#line 310 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp62_ = !json_object_has_member (_data_->_tmp64_, "achievements");
#line 3888 "SteamGame.c"
	}
#line 310 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp62_) {
#line 312 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->loading_achievements = FALSE;
#line 313 "../src/data/sources/steam/SteamGame.vala"
		_data_->result = NULL;
#line 313 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->schema_achievements_obj);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->global_percentages_root);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->achievements_root);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->schema_root);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->global_percentages_url);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->achievements_url);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->schema_url);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp10_);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->lang);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 313 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 313 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3922 "SteamGame.c"
			}
		}
#line 313 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 313 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 3929 "SteamGame.c"
	}
#line 315 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp65_ = _data_->schema_achievements_obj;
#line 315 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp66_ = json_object_get_array_member (_data_->_tmp65_, "achievements");
#line 315 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp67_ = _json_array_ref0 (_data_->_tmp66_);
#line 315 "../src/data/sources/steam/SteamGame.vala"
	_data_->schema_achievements = _data_->_tmp67_;
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp68_ = _data_->achievements_root;
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp69_ = g_strdup ("playerstats");
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp70_ = g_new0 (gchar*, 1 + 1);
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp70_[0] = _data_->_tmp69_;
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp71_ = _data_->_tmp70_;
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp71__length1 = 1;
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp72_ = game_hub_utils_parser_json_object (_data_->_tmp68_, _data_->_tmp71_, (gint) 1);
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp73_ = _data_->_tmp72_;
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp71_ = (_vala_array_free (_data_->_tmp71_, _data_->_tmp71__length1, (GDestroyNotify) g_free), NULL);
#line 317 "../src/data/sources/steam/SteamGame.vala"
	_data_->achievements_obj = _data_->_tmp73_;
#line 318 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp75_ = _data_->achievements_obj;
#line 318 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp75_ == NULL) {
#line 318 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp74_ = TRUE;
#line 3965 "SteamGame.c"
	} else {
#line 318 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp76_ = _data_->achievements_obj;
#line 318 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp74_ = !json_object_has_member (_data_->_tmp76_, "achievements");
#line 3971 "SteamGame.c"
	}
#line 318 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp74_) {
#line 320 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->loading_achievements = FALSE;
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_data_->result = NULL;
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->achievements_obj);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_json_array_unref0 (_data_->schema_achievements);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->schema_achievements_obj);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->global_percentages_root);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->achievements_root);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->schema_root);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->global_percentages_url);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->achievements_url);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->schema_url);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp10_);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->lang);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 321 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 321 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4009 "SteamGame.c"
			}
		}
#line 321 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 321 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 4016 "SteamGame.c"
	}
#line 323 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp77_ = _data_->achievements_obj;
#line 323 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp78_ = json_object_get_array_member (_data_->_tmp77_, "achievements");
#line 323 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp79_ = _json_array_ref0 (_data_->_tmp78_);
#line 323 "../src/data/sources/steam/SteamGame.vala"
	_data_->player_achievements = _data_->_tmp79_;
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp80_ = _data_->global_percentages_root;
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp81_ = g_strdup ("achievementpercentages");
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp82_ = g_new0 (gchar*, 1 + 1);
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp82_[0] = _data_->_tmp81_;
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp83_ = _data_->_tmp82_;
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp83__length1 = 1;
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp84_ = game_hub_utils_parser_json_object (_data_->_tmp80_, _data_->_tmp83_, (gint) 1);
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp85_ = _data_->_tmp84_;
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp83_ = (_vala_array_free (_data_->_tmp83_, _data_->_tmp83__length1, (GDestroyNotify) g_free), NULL);
#line 325 "../src/data/sources/steam/SteamGame.vala"
	_data_->global_percentages_obj = _data_->_tmp85_;
#line 326 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp87_ = _data_->global_percentages_obj;
#line 326 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp87_ == NULL) {
#line 326 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp86_ = TRUE;
#line 4052 "SteamGame.c"
	} else {
#line 326 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp88_ = _data_->global_percentages_obj;
#line 326 "../src/data/sources/steam/SteamGame.vala"
		_data_->_tmp86_ = !json_object_has_member (_data_->_tmp88_, "achievements");
#line 4058 "SteamGame.c"
	}
#line 326 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_tmp86_) {
#line 328 "../src/data/sources/steam/SteamGame.vala"
		_data_->self->priv->loading_achievements = FALSE;
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_data_->result = NULL;
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->global_percentages_obj);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_json_array_unref0 (_data_->player_achievements);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->achievements_obj);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_json_array_unref0 (_data_->schema_achievements);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_json_object_unref0 (_data_->schema_achievements_obj);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->global_percentages_root);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->achievements_root);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		__vala_JsonNode_free0 (_data_->schema_root);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->global_percentages_url);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->achievements_url);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->schema_url);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->_tmp10_);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		_g_free0 (_data_->lang);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		if (_data_->_state_ != 0) {
#line 329 "../src/data/sources/steam/SteamGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 329 "../src/data/sources/steam/SteamGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4100 "SteamGame.c"
			}
		}
#line 329 "../src/data/sources/steam/SteamGame.vala"
		g_object_unref (_data_->_async_result);
#line 329 "../src/data/sources/steam/SteamGame.vala"
		return FALSE;
#line 4107 "SteamGame.c"
	}
#line 331 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp89_ = _data_->global_percentages_obj;
#line 331 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp90_ = json_object_get_array_member (_data_->_tmp89_, "achievements");
#line 331 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp91_ = _json_array_ref0 (_data_->_tmp90_);
#line 331 "../src/data/sources/steam/SteamGame.vala"
	_data_->global_percentages = _data_->_tmp91_;
#line 333 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp92_ = gee_array_list_new (GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, (GBoxedCopyFunc) game_hub_data_game_achievement_ref, (GDestroyNotify) game_hub_data_game_achievement_unref, NULL, NULL, NULL);
#line 333 "../src/data/sources/steam/SteamGame.vala"
	_data_->_achievements = _data_->_tmp92_;
#line 335 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp93_ = _data_->schema_achievements;
#line 335 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp94_ = json_array_get_elements (_data_->_tmp93_);
#line 4125 "SteamGame.c"
	{
#line 335 "../src/data/sources/steam/SteamGame.vala"
		_data_->s_achievement_node_collection = _data_->_tmp94_;
#line 335 "../src/data/sources/steam/SteamGame.vala"
		for (_data_->s_achievement_node_it = _data_->s_achievement_node_collection; _data_->s_achievement_node_it != NULL; _data_->s_achievement_node_it = _data_->s_achievement_node_it->next) {
#line 335 "../src/data/sources/steam/SteamGame.vala"
			_data_->s_achievement_node = (JsonNode*) _data_->s_achievement_node_it->data;
#line 4133 "SteamGame.c"
			{
#line 337 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp97_ = _data_->s_achievement_node;
#line 337 "../src/data/sources/steam/SteamGame.vala"
				if (_data_->_tmp97_ != NULL) {
#line 337 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp98_ = _data_->s_achievement_node;
#line 337 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp96_ = json_node_get_node_type (_data_->_tmp98_) == JSON_NODE_OBJECT;
#line 4143 "SteamGame.c"
				} else {
#line 337 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp96_ = FALSE;
#line 4147 "SteamGame.c"
				}
#line 337 "../src/data/sources/steam/SteamGame.vala"
				if (_data_->_tmp96_) {
#line 338 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp99_ = _data_->s_achievement_node;
#line 338 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp100_ = json_node_get_object (_data_->_tmp99_);
#line 338 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp95_ = _data_->_tmp100_;
#line 4157 "SteamGame.c"
				} else {
#line 338 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp95_ = NULL;
#line 4161 "SteamGame.c"
				}
#line 337 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp101_ = _json_object_ref0 (_data_->_tmp95_);
#line 337 "../src/data/sources/steam/SteamGame.vala"
				_data_->s_achievement = _data_->_tmp101_;
#line 340 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp103_ = _data_->s_achievement;
#line 340 "../src/data/sources/steam/SteamGame.vala"
				if (_data_->_tmp103_ == NULL) {
#line 340 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp102_ = TRUE;
#line 4173 "SteamGame.c"
				} else {
#line 340 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp104_ = _data_->s_achievement;
#line 340 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp102_ = !json_object_has_member (_data_->_tmp104_, "name");
#line 4179 "SteamGame.c"
				}
#line 340 "../src/data/sources/steam/SteamGame.vala"
				if (_data_->_tmp102_) {
#line 340 "../src/data/sources/steam/SteamGame.vala"
					_json_object_unref0 (_data_->s_achievement);
#line 340 "../src/data/sources/steam/SteamGame.vala"
					continue;
#line 4187 "SteamGame.c"
				}
#line 342 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp105_ = _data_->s_achievement;
#line 342 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp106_ = json_object_get_string_member (_data_->_tmp105_, "name");
#line 342 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp107_ = g_strdup (_data_->_tmp106_);
#line 342 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_id = _data_->_tmp107_;
#line 343 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp109_ = _data_->s_achievement;
#line 343 "../src/data/sources/steam/SteamGame.vala"
				if (json_object_has_member (_data_->_tmp109_, "displayName")) {
#line 343 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp110_ = _data_->s_achievement;
#line 343 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp111_ = json_object_get_string_member (_data_->_tmp110_, "displayName");
#line 343 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp108_ = _data_->_tmp111_;
#line 4207 "SteamGame.c"
				} else {
#line 343 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp112_ = _data_->a_id;
#line 343 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp108_ = _data_->_tmp112_;
#line 4213 "SteamGame.c"
				}
#line 343 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp113_ = g_strdup (_data_->_tmp108_);
#line 343 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_name = _data_->_tmp113_;
#line 344 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp115_ = _data_->s_achievement;
#line 344 "../src/data/sources/steam/SteamGame.vala"
				if (json_object_has_member (_data_->_tmp115_, "description")) {
#line 344 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp116_ = _data_->s_achievement;
#line 344 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp117_ = json_object_get_string_member (_data_->_tmp116_, "description");
#line 344 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp114_ = _data_->_tmp117_;
#line 4229 "SteamGame.c"
				} else {
#line 344 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp114_ = "";
#line 4233 "SteamGame.c"
				}
#line 344 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp118_ = g_strdup (_data_->_tmp114_);
#line 344 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_desc = _data_->_tmp118_;
#line 345 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp120_ = _data_->s_achievement;
#line 345 "../src/data/sources/steam/SteamGame.vala"
				if (json_object_has_member (_data_->_tmp120_, "icon")) {
#line 345 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp121_ = _data_->s_achievement;
#line 345 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp122_ = json_object_get_string_member (_data_->_tmp121_, "icon");
#line 345 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp119_ = _data_->_tmp122_;
#line 4249 "SteamGame.c"
				} else {
#line 345 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp119_ = NULL;
#line 4253 "SteamGame.c"
				}
#line 345 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp123_ = g_strdup (_data_->_tmp119_);
#line 345 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_image_unlocked = _data_->_tmp123_;
#line 346 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp125_ = _data_->s_achievement;
#line 346 "../src/data/sources/steam/SteamGame.vala"
				if (json_object_has_member (_data_->_tmp125_, "icongray")) {
#line 346 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp126_ = _data_->s_achievement;
#line 346 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp127_ = json_object_get_string_member (_data_->_tmp126_, "icongray");
#line 346 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp124_ = _data_->_tmp127_;
#line 4269 "SteamGame.c"
				} else {
#line 346 "../src/data/sources/steam/SteamGame.vala"
					_data_->_tmp124_ = NULL;
#line 4273 "SteamGame.c"
				}
#line 346 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp128_ = g_strdup (_data_->_tmp124_);
#line 346 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_image_locked = _data_->_tmp128_;
#line 347 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_unlocked = FALSE;
#line 348 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_unlock_time = (gint64) 0;
#line 349 "../src/data/sources/steam/SteamGame.vala"
				_data_->a_global_percentage = (gfloat) 0;
#line 351 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp129_ = _data_->player_achievements;
#line 351 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp130_ = json_array_get_elements (_data_->_tmp129_);
#line 4289 "SteamGame.c"
				{
#line 351 "../src/data/sources/steam/SteamGame.vala"
					_data_->p_achievement_node_collection = _data_->_tmp130_;
#line 351 "../src/data/sources/steam/SteamGame.vala"
					for (_data_->p_achievement_node_it = _data_->p_achievement_node_collection; _data_->p_achievement_node_it != NULL; _data_->p_achievement_node_it = _data_->p_achievement_node_it->next) {
#line 351 "../src/data/sources/steam/SteamGame.vala"
						_data_->p_achievement_node = (JsonNode*) _data_->p_achievement_node_it->data;
#line 4297 "SteamGame.c"
						{
#line 353 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp133_ = _data_->p_achievement_node;
#line 353 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp133_ != NULL) {
#line 353 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp134_ = _data_->p_achievement_node;
#line 353 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp132_ = json_node_get_node_type (_data_->_tmp134_) == JSON_NODE_OBJECT;
#line 4307 "SteamGame.c"
							} else {
#line 353 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp132_ = FALSE;
#line 4311 "SteamGame.c"
							}
#line 353 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp132_) {
#line 354 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp135_ = _data_->p_achievement_node;
#line 354 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp136_ = json_node_get_object (_data_->_tmp135_);
#line 354 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp131_ = _data_->_tmp136_;
#line 4321 "SteamGame.c"
							} else {
#line 354 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp131_ = NULL;
#line 4325 "SteamGame.c"
							}
#line 353 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp137_ = _json_object_ref0 (_data_->_tmp131_);
#line 353 "../src/data/sources/steam/SteamGame.vala"
							_data_->p_achievement = _data_->_tmp137_;
#line 356 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp140_ = _data_->p_achievement;
#line 356 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp140_ == NULL) {
#line 356 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp139_ = TRUE;
#line 4337 "SteamGame.c"
							} else {
#line 356 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp141_ = _data_->p_achievement;
#line 356 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp139_ = !json_object_has_member (_data_->_tmp141_, "apiname");
#line 4343 "SteamGame.c"
							}
#line 356 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp139_) {
#line 356 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp138_ = TRUE;
#line 4349 "SteamGame.c"
							} else {
#line 357 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp142_ = _data_->p_achievement;
#line 357 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp143_ = json_object_get_string_member (_data_->_tmp142_, "apiname");
#line 357 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp144_ = _data_->a_id;
#line 357 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp138_ = g_strcmp0 (_data_->_tmp143_, _data_->_tmp144_) != 0;
#line 4359 "SteamGame.c"
							}
#line 356 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp138_) {
#line 357 "../src/data/sources/steam/SteamGame.vala"
								_json_object_unref0 (_data_->p_achievement);
#line 357 "../src/data/sources/steam/SteamGame.vala"
								continue;
#line 4367 "SteamGame.c"
							}
#line 359 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp146_ = _data_->p_achievement;
#line 359 "../src/data/sources/steam/SteamGame.vala"
							if (json_object_has_member (_data_->_tmp146_, "achieved")) {
#line 359 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp147_ = _data_->p_achievement;
#line 359 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp145_ = json_object_get_int_member (_data_->_tmp147_, "achieved") > ((gint64) 0);
#line 4377 "SteamGame.c"
							} else {
#line 359 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp145_ = FALSE;
#line 4381 "SteamGame.c"
							}
#line 359 "../src/data/sources/steam/SteamGame.vala"
							_data_->a_unlocked = _data_->_tmp145_;
#line 360 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp149_ = _data_->p_achievement;
#line 360 "../src/data/sources/steam/SteamGame.vala"
							if (json_object_has_member (_data_->_tmp149_, "unlocktime")) {
#line 360 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp150_ = _data_->p_achievement;
#line 360 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp148_ = json_object_get_int_member (_data_->_tmp150_, "unlocktime");
#line 4393 "SteamGame.c"
							} else {
#line 360 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp148_ = (gint64) 0;
#line 4397 "SteamGame.c"
							}
#line 360 "../src/data/sources/steam/SteamGame.vala"
							_data_->a_unlock_time = _data_->_tmp148_;
#line 351 "../src/data/sources/steam/SteamGame.vala"
							_json_object_unref0 (_data_->p_achievement);
#line 4403 "SteamGame.c"
						}
					}
#line 351 "../src/data/sources/steam/SteamGame.vala"
					(_data_->p_achievement_node_collection == NULL) ? NULL : (_data_->p_achievement_node_collection = (g_list_free (_data_->p_achievement_node_collection), NULL));
#line 4408 "SteamGame.c"
				}
#line 363 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp151_ = _data_->global_percentages;
#line 363 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp152_ = json_array_get_elements (_data_->_tmp151_);
#line 4414 "SteamGame.c"
				{
#line 363 "../src/data/sources/steam/SteamGame.vala"
					_data_->gp_achievement_node_collection = _data_->_tmp152_;
#line 363 "../src/data/sources/steam/SteamGame.vala"
					for (_data_->gp_achievement_node_it = _data_->gp_achievement_node_collection; _data_->gp_achievement_node_it != NULL; _data_->gp_achievement_node_it = _data_->gp_achievement_node_it->next) {
#line 363 "../src/data/sources/steam/SteamGame.vala"
						_data_->gp_achievement_node = (JsonNode*) _data_->gp_achievement_node_it->data;
#line 4422 "SteamGame.c"
						{
#line 365 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp155_ = _data_->gp_achievement_node;
#line 365 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp155_ != NULL) {
#line 365 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp156_ = _data_->gp_achievement_node;
#line 365 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp154_ = json_node_get_node_type (_data_->_tmp156_) == JSON_NODE_OBJECT;
#line 4432 "SteamGame.c"
							} else {
#line 365 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp154_ = FALSE;
#line 4436 "SteamGame.c"
							}
#line 365 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp154_) {
#line 366 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp157_ = _data_->gp_achievement_node;
#line 366 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp158_ = json_node_get_object (_data_->_tmp157_);
#line 366 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp153_ = _data_->_tmp158_;
#line 4446 "SteamGame.c"
							} else {
#line 366 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp153_ = NULL;
#line 4450 "SteamGame.c"
							}
#line 365 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp159_ = _json_object_ref0 (_data_->_tmp153_);
#line 365 "../src/data/sources/steam/SteamGame.vala"
							_data_->gp_achievement = _data_->_tmp159_;
#line 368 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp162_ = _data_->gp_achievement;
#line 368 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp162_ == NULL) {
#line 368 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp161_ = TRUE;
#line 4462 "SteamGame.c"
							} else {
#line 368 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp163_ = _data_->gp_achievement;
#line 368 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp161_ = !json_object_has_member (_data_->_tmp163_, "name");
#line 4468 "SteamGame.c"
							}
#line 368 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp161_) {
#line 368 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp160_ = TRUE;
#line 4474 "SteamGame.c"
							} else {
#line 369 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp164_ = _data_->gp_achievement;
#line 369 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp165_ = json_object_get_string_member (_data_->_tmp164_, "name");
#line 369 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp166_ = _data_->a_id;
#line 369 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp160_ = g_strcmp0 (_data_->_tmp165_, _data_->_tmp166_) != 0;
#line 4484 "SteamGame.c"
							}
#line 368 "../src/data/sources/steam/SteamGame.vala"
							if (_data_->_tmp160_) {
#line 369 "../src/data/sources/steam/SteamGame.vala"
								_json_object_unref0 (_data_->gp_achievement);
#line 369 "../src/data/sources/steam/SteamGame.vala"
								continue;
#line 4492 "SteamGame.c"
							}
#line 371 "../src/data/sources/steam/SteamGame.vala"
							_data_->_tmp168_ = _data_->gp_achievement;
#line 371 "../src/data/sources/steam/SteamGame.vala"
							if (json_object_has_member (_data_->_tmp168_, "percent")) {
#line 371 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp169_ = _data_->gp_achievement;
#line 371 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp167_ = json_object_get_double_member (_data_->_tmp169_, "percent");
#line 4502 "SteamGame.c"
							} else {
#line 371 "../src/data/sources/steam/SteamGame.vala"
								_data_->_tmp167_ = (gdouble) 0;
#line 4506 "SteamGame.c"
							}
#line 371 "../src/data/sources/steam/SteamGame.vala"
							_data_->a_global_percentage = (gfloat) _data_->_tmp167_;
#line 363 "../src/data/sources/steam/SteamGame.vala"
							_json_object_unref0 (_data_->gp_achievement);
#line 4512 "SteamGame.c"
						}
					}
#line 363 "../src/data/sources/steam/SteamGame.vala"
					(_data_->gp_achievement_node_collection == NULL) ? NULL : (_data_->gp_achievement_node_collection = (g_list_free (_data_->gp_achievement_node_collection), NULL));
#line 4517 "SteamGame.c"
				}
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp170_ = _data_->_achievements;
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp171_ = _data_->a_id;
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp172_ = _data_->a_name;
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp173_ = _data_->a_desc;
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp174_ = _data_->a_image_locked;
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp175_ = _data_->a_image_unlocked;
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp176_ = game_hub_data_sources_steam_steam_game_achievement_new (_data_->_tmp171_, _data_->_tmp172_, _data_->_tmp173_, _data_->_tmp174_, _data_->_tmp175_, _data_->a_unlocked, _data_->a_unlock_time, _data_->a_global_percentage);
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_data_->_tmp177_ = _data_->_tmp176_;
#line 374 "../src/data/sources/steam/SteamGame.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp170_, (GameHubDataGameAchievement*) _data_->_tmp177_);
#line 374 "../src/data/sources/steam/SteamGame.vala"
				_game_hub_data_game_achievement_unref0 (_data_->_tmp177_);
#line 335 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (_data_->a_image_locked);
#line 335 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (_data_->a_image_unlocked);
#line 335 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (_data_->a_desc);
#line 335 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (_data_->a_name);
#line 335 "../src/data/sources/steam/SteamGame.vala"
				_g_free0 (_data_->a_id);
#line 335 "../src/data/sources/steam/SteamGame.vala"
				_json_object_unref0 (_data_->s_achievement);
#line 4551 "SteamGame.c"
			}
		}
#line 335 "../src/data/sources/steam/SteamGame.vala"
		(_data_->s_achievement_node_collection == NULL) ? NULL : (_data_->s_achievement_node_collection = (g_list_free (_data_->s_achievement_node_collection), NULL));
#line 4556 "SteamGame.c"
	}
#line 378 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp178_ = _data_->_achievements;
#line 378 "../src/data/sources/steam/SteamGame.vala"
	gee_list_sort ((GeeList*) _data_->_tmp178_, ___lambda129__gcompare_data_func, g_object_ref (_data_->self), g_object_unref);
#line 392 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp179_ = _data_->_achievements;
#line 392 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_set_achievements ((GameHubDataGame*) _data_->self, _data_->_tmp179_);
#line 393 "../src/data/sources/steam/SteamGame.vala"
	_data_->self->priv->loading_achievements = FALSE;
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp180_ = game_hub_data_game_get_achievements ((GameHubDataGame*) _data_->self);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp181_ = _data_->_tmp180_;
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_data_->_tmp182_ = _g_object_ref0 (_data_->_tmp181_);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_data_->result = _data_->_tmp182_;
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (_data_->_achievements);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_json_array_unref0 (_data_->global_percentages);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_json_object_unref0 (_data_->global_percentages_obj);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_json_array_unref0 (_data_->player_achievements);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_json_object_unref0 (_data_->achievements_obj);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_json_array_unref0 (_data_->schema_achievements);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_json_object_unref0 (_data_->schema_achievements_obj);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	__vala_JsonNode_free0 (_data_->global_percentages_root);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	__vala_JsonNode_free0 (_data_->achievements_root);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	__vala_JsonNode_free0 (_data_->schema_root);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->global_percentages_url);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->achievements_url);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->schema_url);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->_tmp10_);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_data_->lang);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	if (_data_->_state_ != 0) {
#line 394 "../src/data/sources/steam/SteamGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 394 "../src/data/sources/steam/SteamGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4614 "SteamGame.c"
		}
	}
#line 394 "../src/data/sources/steam/SteamGame.vala"
	g_object_unref (_data_->_async_result);
#line 394 "../src/data/sources/steam/SteamGame.vala"
	return FALSE;
#line 4621 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_import (GameHubDataRunnable* base,
                                                    gboolean update)
{
	GameHubDataSourcesSteamSteamGame * self;
#line 397 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 4631 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_real_choose_executable (GameHubDataRunnable* base,
                                                               gboolean update)
{
	GameHubDataSourcesSteamSteamGame * self;
#line 398 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGame*) base;
#line 4641 "SteamGame.c"
}

gboolean
game_hub_data_sources_steam_steam_game_get_is_updating (GameHubDataSourcesSteamSteamGame* self)
{
	gboolean result;
#line 33 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 33 "../src/data/sources/steam/SteamGame.vala"
	result = self->priv->_is_updating;
#line 33 "../src/data/sources/steam/SteamGame.vala"
	return result;
#line 4654 "SteamGame.c"
}

void
game_hub_data_sources_steam_steam_game_set_is_updating (GameHubDataSourcesSteamSteamGame* self,
                                                        gboolean value)
{
	gboolean old_value;
#line 33 "../src/data/sources/steam/SteamGame.vala"
	g_return_if_fail (self != NULL);
#line 33 "../src/data/sources/steam/SteamGame.vala"
	old_value = game_hub_data_sources_steam_steam_game_get_is_updating (self);
#line 33 "../src/data/sources/steam/SteamGame.vala"
	if (old_value != value) {
#line 33 "../src/data/sources/steam/SteamGame.vala"
		self->priv->_is_updating = value;
#line 33 "../src/data/sources/steam/SteamGame.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_sources_steam_steam_game_properties[GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_UPDATING_PROPERTY]);
#line 4672 "SteamGame.c"
	}
}

GFile*
game_hub_data_sources_steam_steam_game_get_screenshots_dir (GameHubDataSourcesSteamSteamGame* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 35 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = self->priv->_screenshots_dir;
#line 35 "../src/data/sources/steam/SteamGame.vala"
	result = _tmp0_;
#line 35 "../src/data/sources/steam/SteamGame.vala"
	return result;
#line 4689 "SteamGame.c"
}

void
game_hub_data_sources_steam_steam_game_set_screenshots_dir (GameHubDataSourcesSteamSteamGame* self,
                                                            GFile* value)
{
	GFile* old_value;
#line 35 "../src/data/sources/steam/SteamGame.vala"
	g_return_if_fail (self != NULL);
#line 35 "../src/data/sources/steam/SteamGame.vala"
	old_value = game_hub_data_sources_steam_steam_game_get_screenshots_dir (self);
#line 35 "../src/data/sources/steam/SteamGame.vala"
	if (old_value != value) {
#line 4703 "SteamGame.c"
		GFile* _tmp0_;
#line 35 "../src/data/sources/steam/SteamGame.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 35 "../src/data/sources/steam/SteamGame.vala"
		_g_object_unref0 (self->priv->_screenshots_dir);
#line 35 "../src/data/sources/steam/SteamGame.vala"
		self->priv->_screenshots_dir = _tmp0_;
#line 35 "../src/data/sources/steam/SteamGame.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_sources_steam_steam_game_properties[GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_SCREENSHOTS_DIR_PROPERTY]);
#line 4713 "SteamGame.c"
	}
}

GameHubDataSourcesSteamSteamGameAchievement*
game_hub_data_sources_steam_steam_game_achievement_construct (GType object_type,
                                                              const gchar* id,
                                                              const gchar* name,
                                                              const gchar* desc,
                                                              const gchar* image_locked,
                                                              const gchar* image_unlocked,
                                                              gboolean unlocked,
                                                              gint64 unlock_time,
                                                              gfloat global_percentage)
{
	GameHubDataSourcesSteamSteamGameAchievement* self = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 404 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 404 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 404 "../src/data/sources/steam/SteamGame.vala"
	g_return_val_if_fail (desc != NULL, NULL);
#line 404 "../src/data/sources/steam/SteamGame.vala"
	self = (GameHubDataSourcesSteamSteamGameAchievement*) game_hub_data_game_achievement_construct (object_type);
#line 407 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_id ((GameHubDataGameAchievement*) self, id);
#line 408 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_name ((GameHubDataGameAchievement*) self, name);
#line 409 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_description ((GameHubDataGameAchievement*) self, desc);
#line 410 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_image_locked ((GameHubDataGameAchievement*) self, image_locked);
#line 411 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_image_unlocked ((GameHubDataGameAchievement*) self, image_unlocked);
#line 412 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_unlocked ((GameHubDataGameAchievement*) self, unlocked);
#line 413 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_global_percentage ((GameHubDataGameAchievement*) self, global_percentage);
#line 414 "../src/data/sources/steam/SteamGame.vala"
	self->unlock_timestamp = unlock_time;
#line 415 "../src/data/sources/steam/SteamGame.vala"
	_tmp0_ = g_date_time_new_from_unix_utc (unlock_time);
#line 415 "../src/data/sources/steam/SteamGame.vala"
	_tmp1_ = _tmp0_;
#line 415 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_unlock_date ((GameHubDataGameAchievement*) self, _tmp1_);
#line 415 "../src/data/sources/steam/SteamGame.vala"
	_g_date_time_unref0 (_tmp1_);
#line 416 "../src/data/sources/steam/SteamGame.vala"
	_tmp2_ = game_hub_data_game_achievement_get_unlock_date ((GameHubDataGameAchievement*) self);
#line 416 "../src/data/sources/steam/SteamGame.vala"
	_tmp3_ = _tmp2_;
#line 416 "../src/data/sources/steam/SteamGame.vala"
	_tmp4_ = game_hub_utils_get_relative_datetime (_tmp3_);
#line 416 "../src/data/sources/steam/SteamGame.vala"
	_tmp5_ = _tmp4_;
#line 416 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_game_achievement_set_unlock_time ((GameHubDataGameAchievement*) self, _tmp5_);
#line 416 "../src/data/sources/steam/SteamGame.vala"
	_g_free0 (_tmp5_);
#line 404 "../src/data/sources/steam/SteamGame.vala"
	return self;
#line 4781 "SteamGame.c"
}

GameHubDataSourcesSteamSteamGameAchievement*
game_hub_data_sources_steam_steam_game_achievement_new (const gchar* id,
                                                        const gchar* name,
                                                        const gchar* desc,
                                                        const gchar* image_locked,
                                                        const gchar* image_unlocked,
                                                        gboolean unlocked,
                                                        gint64 unlock_time,
                                                        gfloat global_percentage)
{
#line 404 "../src/data/sources/steam/SteamGame.vala"
	return game_hub_data_sources_steam_steam_game_achievement_construct (GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT, id, name, desc, image_locked, image_unlocked, unlocked, unlock_time, global_percentage);
#line 4796 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_achievement_class_init (GameHubDataSourcesSteamSteamGameAchievementClass * klass,
                                                               gpointer klass_data)
{
#line 400 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_achievement_parent_class = g_type_class_peek_parent (klass);
#line 400 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataGameAchievementClass *) klass)->finalize = game_hub_data_sources_steam_steam_game_achievement_finalize;
#line 4807 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_achievement_instance_init (GameHubDataSourcesSteamSteamGameAchievement * self,
                                                                  gpointer klass)
{
}

static void
game_hub_data_sources_steam_steam_game_achievement_finalize (GameHubDataGameAchievement * obj)
{
	GameHubDataSourcesSteamSteamGameAchievement * self;
#line 400 "../src/data/sources/steam/SteamGame.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_TYPE_ACHIEVEMENT, GameHubDataSourcesSteamSteamGameAchievement);
#line 400 "../src/data/sources/steam/SteamGame.vala"
	GAME_HUB_DATA_GAME_ACHIEVEMENT_CLASS (game_hub_data_sources_steam_steam_game_achievement_parent_class)->finalize (obj);
#line 4824 "SteamGame.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_sources_steam_steam_game_achievement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataSourcesSteamSteamGameAchievementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_sources_steam_steam_game_achievement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataSourcesSteamSteamGameAchievement), 0, (GInstanceInitFunc) game_hub_data_sources_steam_steam_game_achievement_instance_init, NULL };
	GType game_hub_data_sources_steam_steam_game_achievement_type_id;
	game_hub_data_sources_steam_steam_game_achievement_type_id = g_type_register_static (GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, "GameHubDataSourcesSteamSteamGameAchievement", &g_define_type_info, 0);
	return game_hub_data_sources_steam_steam_game_achievement_type_id;
}

GType
game_hub_data_sources_steam_steam_game_achievement_get_type (void)
{
	static volatile gsize game_hub_data_sources_steam_steam_game_achievement_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_sources_steam_steam_game_achievement_type_id__once)) {
		GType game_hub_data_sources_steam_steam_game_achievement_type_id;
		game_hub_data_sources_steam_steam_game_achievement_type_id = game_hub_data_sources_steam_steam_game_achievement_get_type_once ();
		g_once_init_leave (&game_hub_data_sources_steam_steam_game_achievement_type_id__once, game_hub_data_sources_steam_steam_game_achievement_type_id);
	}
	return game_hub_data_sources_steam_steam_game_achievement_type_id__once;
}

static void
game_hub_data_sources_steam_steam_game_class_init (GameHubDataSourcesSteamSteamGameClass * klass,
                                                   gpointer klass_data)
{
#line 26 "../src/data/sources/steam/SteamGame.vala"
	game_hub_data_sources_steam_steam_game_parent_class = g_type_class_peek_parent (klass);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataSourcesSteamSteamGame_private_offset);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataGameClass *) klass)->update_game_info = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_steam_steam_game_real_update_game_info;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataGameClass *) klass)->update_game_info_finish = (void (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_sources_steam_steam_game_update_game_info_finish;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->update_status = (void (*) (GameHubDataRunnable*)) game_hub_data_sources_steam_steam_game_real_update_status;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->install = (void (*) (GameHubDataRunnable*, GameHubDataRunnableInstallerInstallMode, GAsyncReadyCallback, gpointer)) game_hub_data_sources_steam_steam_game_real_install;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->install_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_sources_steam_steam_game_install_finish;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->run = (void (*) (GameHubDataRunnable*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_steam_steam_game_real_run;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->run_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_sources_steam_steam_game_run_finish;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->run_with_compat = (void (*) (GameHubDataRunnable*, gboolean, GAsyncReadyCallback, gpointer)) game_hub_data_sources_steam_steam_game_real_run_with_compat;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->run_with_compat_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_sources_steam_steam_game_run_with_compat_finish;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataGameClass *) klass)->uninstall = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_steam_steam_game_real_uninstall;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataGameClass *) klass)->uninstall_finish = (void (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_sources_steam_steam_game_uninstall_finish;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataGameClass *) klass)->load_achievements = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_steam_steam_game_real_load_achievements;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataGameClass *) klass)->load_achievements_finish = (GeeArrayList* (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_sources_steam_steam_game_load_achievements_finish;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->import = (void (*) (GameHubDataRunnable*, gboolean)) game_hub_data_sources_steam_steam_game_real_import;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	((GameHubDataRunnableClass *) klass)->choose_executable = (void (*) (GameHubDataRunnable*, gboolean)) game_hub_data_sources_steam_steam_game_real_choose_executable;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_data_sources_steam_steam_game_get_property;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_data_sources_steam_steam_game_set_property;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_data_sources_steam_steam_game_finalize;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_UPDATING_PROPERTY, game_hub_data_sources_steam_steam_game_properties[GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_UPDATING_PROPERTY] = g_param_spec_boolean ("is-updating", "is-updating", "is-updating", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 26 "../src/data/sources/steam/SteamGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_SCREENSHOTS_DIR_PROPERTY, game_hub_data_sources_steam_steam_game_properties[GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_SCREENSHOTS_DIR_PROPERTY] = g_param_spec_object ("screenshots-dir", "screenshots-dir", "screenshots-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 4896 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_instance_init (GameHubDataSourcesSteamSteamGame * self,
                                                      gpointer klass)
{
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self->priv = game_hub_data_sources_steam_steam_game_get_instance_private (self);
#line 28 "../src/data/sources/steam/SteamGame.vala"
	self->priv->metadata_tries = 0;
#line 30 "../src/data/sources/steam/SteamGame.vala"
	self->priv->game_info_updating = FALSE;
#line 31 "../src/data/sources/steam/SteamGame.vala"
	self->priv->game_info_updated = FALSE;
#line 33 "../src/data/sources/steam/SteamGame.vala"
	self->priv->_is_updating = FALSE;
#line 35 "../src/data/sources/steam/SteamGame.vala"
	self->priv->_screenshots_dir = NULL;
#line 288 "../src/data/sources/steam/SteamGame.vala"
	self->priv->loading_achievements = FALSE;
#line 4917 "SteamGame.c"
}

static void
game_hub_data_sources_steam_steam_game_finalize (GObject * obj)
{
	GameHubDataSourcesSteamSteamGame * self;
#line 26 "../src/data/sources/steam/SteamGame.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGame);
#line 35 "../src/data/sources/steam/SteamGame.vala"
	_g_object_unref0 (self->priv->_screenshots_dir);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	G_OBJECT_CLASS (game_hub_data_sources_steam_steam_game_parent_class)->finalize (obj);
#line 4930 "SteamGame.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_sources_steam_steam_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataSourcesSteamSteamGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_sources_steam_steam_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataSourcesSteamSteamGame), 0, (GInstanceInitFunc) game_hub_data_sources_steam_steam_game_instance_init, NULL };
	GType game_hub_data_sources_steam_steam_game_type_id;
	game_hub_data_sources_steam_steam_game_type_id = g_type_register_static (GAME_HUB_DATA_TYPE_GAME, "GameHubDataSourcesSteamSteamGame", &g_define_type_info, 0);
	GameHubDataSourcesSteamSteamGame_private_offset = g_type_add_instance_private (game_hub_data_sources_steam_steam_game_type_id, sizeof (GameHubDataSourcesSteamSteamGamePrivate));
	return game_hub_data_sources_steam_steam_game_type_id;
}

GType
game_hub_data_sources_steam_steam_game_get_type (void)
{
	static volatile gsize game_hub_data_sources_steam_steam_game_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_sources_steam_steam_game_type_id__once)) {
		GType game_hub_data_sources_steam_steam_game_type_id;
		game_hub_data_sources_steam_steam_game_type_id = game_hub_data_sources_steam_steam_game_get_type_once ();
		g_once_init_leave (&game_hub_data_sources_steam_steam_game_type_id__once, game_hub_data_sources_steam_steam_game_type_id);
	}
	return game_hub_data_sources_steam_steam_game_type_id__once;
}

static void
_vala_game_hub_data_sources_steam_steam_game_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	GameHubDataSourcesSteamSteamGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGame);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	switch (property_id) {
#line 26 "../src/data/sources/steam/SteamGame.vala"
		case GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_UPDATING_PROPERTY:
#line 26 "../src/data/sources/steam/SteamGame.vala"
		g_value_set_boolean (value, game_hub_data_sources_steam_steam_game_get_is_updating (self));
#line 26 "../src/data/sources/steam/SteamGame.vala"
		break;
#line 26 "../src/data/sources/steam/SteamGame.vala"
		case GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_SCREENSHOTS_DIR_PROPERTY:
#line 26 "../src/data/sources/steam/SteamGame.vala"
		g_value_set_object (value, game_hub_data_sources_steam_steam_game_get_screenshots_dir (self));
#line 26 "../src/data/sources/steam/SteamGame.vala"
		break;
#line 4977 "SteamGame.c"
		default:
#line 26 "../src/data/sources/steam/SteamGame.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "../src/data/sources/steam/SteamGame.vala"
		break;
#line 4983 "SteamGame.c"
	}
}

static void
_vala_game_hub_data_sources_steam_steam_game_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	GameHubDataSourcesSteamSteamGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_SOURCES_STEAM_TYPE_STEAM_GAME, GameHubDataSourcesSteamSteamGame);
#line 26 "../src/data/sources/steam/SteamGame.vala"
	switch (property_id) {
#line 26 "../src/data/sources/steam/SteamGame.vala"
		case GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_IS_UPDATING_PROPERTY:
#line 26 "../src/data/sources/steam/SteamGame.vala"
		game_hub_data_sources_steam_steam_game_set_is_updating (self, g_value_get_boolean (value));
#line 26 "../src/data/sources/steam/SteamGame.vala"
		break;
#line 26 "../src/data/sources/steam/SteamGame.vala"
		case GAME_HUB_DATA_SOURCES_STEAM_STEAM_GAME_SCREENSHOTS_DIR_PROPERTY:
#line 26 "../src/data/sources/steam/SteamGame.vala"
		game_hub_data_sources_steam_steam_game_set_screenshots_dir (self, g_value_get_object (value));
#line 26 "../src/data/sources/steam/SteamGame.vala"
		break;
#line 5009 "SteamGame.c"
		default:
#line 26 "../src/data/sources/steam/SteamGame.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "../src/data/sources/steam/SteamGame.vala"
		break;
#line 5015 "SteamGame.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

