/* ItchGame.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ItchGame.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <sqlite3.h>
#include <float.h>
#include <math.h>

#define GAME_HUB_DATA_PLATFORM_CURRENT GAME_HUB_DATA_PLATFORM_LINUX
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_DATA_TYPE_RUNNABLE (game_hub_data_runnable_get_type ())
#define GAME_HUB_DATA_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnable))
#define GAME_HUB_DATA_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))
#define GAME_HUB_DATA_IS_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_IS_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_RUNNABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))

typedef struct _GameHubDataRunnable GameHubDataRunnable;
typedef struct _GameHubDataRunnableClass GameHubDataRunnableClass;
typedef struct _GameHubDataRunnablePrivate GameHubDataRunnablePrivate;
typedef enum  {
	GAME_HUB_DATA_PLATFORM_LINUX,
	GAME_HUB_DATA_PLATFORM_WINDOWS,
	GAME_HUB_DATA_PLATFORM_MACOS,
	GAME_HUB_DATA_PLATFORM_EMULATED
} GameHubDataPlatform;

#define GAME_HUB_DATA_TYPE_PLATFORM (game_hub_data_platform_get_type ())
typedef enum  {
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_INTERACTIVE,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC_DOWNLOAD
} GameHubDataRunnableInstallerInstallMode;

#define GAME_HUB_DATA_RUNNABLE_INSTALLER_TYPE_INSTALL_MODE (game_hub_data_runnable_installer_install_mode_get_type ())

#define GAME_HUB_DATA_TYPE_GAME (game_hub_data_game_get_type ())
#define GAME_HUB_DATA_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGame))
#define GAME_HUB_DATA_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))
#define GAME_HUB_DATA_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))

typedef struct _GameHubDataGame GameHubDataGame;
typedef struct _GameHubDataGameClass GameHubDataGameClass;
typedef struct _GameHubDataGamePrivate GameHubDataGamePrivate;

#define GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT (game_hub_data_game_achievement_get_type ())
#define GAME_HUB_DATA_GAME_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievement))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))

typedef struct _GameHubDataGameAchievement GameHubDataGameAchievement;
typedef struct _GameHubDataGameAchievementClass GameHubDataGameAchievementClass;

#define GAME_HUB_DATA_GAME_TYPE_STATUS (game_hub_data_game_status_get_type ())
#define GAME_HUB_DATA_GAME_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatus))
#define GAME_HUB_DATA_GAME_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))
#define GAME_HUB_DATA_GAME_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))

typedef struct _GameHubDataGameStatus GameHubDataGameStatus;
typedef struct _GameHubDataGameStatusClass GameHubDataGameStatusClass;

#define GAME_HUB_DATA_GAME_TYPE_OVERLAY (game_hub_data_game_overlay_get_type ())
#define GAME_HUB_DATA_GAME_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay))
#define GAME_HUB_DATA_GAME_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))
#define GAME_HUB_DATA_GAME_IS_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_IS_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))

typedef struct _GameHubDataGameOverlay GameHubDataGameOverlay;
typedef struct _GameHubDataGameOverlayClass GameHubDataGameOverlayClass;

#define GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME (game_hub_data_sources_itch_itch_game_get_type ())
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME, GameHubDataSourcesItchItchGame))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME, GameHubDataSourcesItchItchGameClass))
#define GAME_HUB_DATA_SOURCES_ITCH_IS_ITCH_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME))
#define GAME_HUB_DATA_SOURCES_ITCH_IS_ITCH_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME, GameHubDataSourcesItchItchGameClass))

typedef struct _GameHubDataSourcesItchItchGame GameHubDataSourcesItchItchGame;
typedef struct _GameHubDataSourcesItchItchGameClass GameHubDataSourcesItchItchGameClass;
typedef struct _GameHubDataSourcesItchItchGamePrivate GameHubDataSourcesItchItchGamePrivate;

#define GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE (game_hub_data_sources_itch_cave_get_type ())
#define GAME_HUB_DATA_SOURCES_ITCH_CAVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE, GameHubDataSourcesItchCave))
#define GAME_HUB_DATA_SOURCES_ITCH_CAVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE, GameHubDataSourcesItchCaveClass))
#define GAME_HUB_DATA_SOURCES_ITCH_IS_CAVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE))
#define GAME_HUB_DATA_SOURCES_ITCH_IS_CAVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE))
#define GAME_HUB_DATA_SOURCES_ITCH_CAVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE, GameHubDataSourcesItchCaveClass))

typedef struct _GameHubDataSourcesItchCave GameHubDataSourcesItchCave;
typedef struct _GameHubDataSourcesItchCaveClass GameHubDataSourcesItchCaveClass;
enum  {
	GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_0_PROPERTY,
	GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_INT_ID_PROPERTY,
	GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_PROPERTY,
	GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_ID_PROPERTY,
	GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_NUM_PROPERTIES
};
static GParamSpec* game_hub_data_sources_itch_itch_game_properties[GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAME_HUB_DATA_TYPE_GAME_SOURCE (game_hub_data_game_source_get_type ())
#define GAME_HUB_DATA_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSource))
#define GAME_HUB_DATA_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))
#define GAME_HUB_DATA_IS_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_IS_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_GAME_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))

typedef struct _GameHubDataGameSource GameHubDataGameSource;
typedef struct _GameHubDataGameSourceClass GameHubDataGameSourceClass;

#define GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH (game_hub_data_sources_itch_itch_get_type ())
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItchClass))
#define GAME_HUB_DATA_SOURCES_ITCH_IS_ITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH))
#define GAME_HUB_DATA_SOURCES_ITCH_IS_ITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItchClass))

typedef struct _GameHubDataSourcesItchItch GameHubDataSourcesItchItch;
typedef struct _GameHubDataSourcesItchItchClass GameHubDataSourcesItchItchClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define GAME_HUB_DATA_DB_TABLE_TYPE_FIELD (game_hub_data_db_table_field_get_type ())
#define GAME_HUB_DATA_DB_TABLE_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableField))
#define GAME_HUB_DATA_DB_TABLE_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))

typedef struct _GameHubDataDBTableField GameHubDataDBTableField;
typedef struct _GameHubDataDBTableFieldClass GameHubDataDBTableFieldClass;

#define GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG (game_hub_data_db_tables_tags_tag_get_type ())
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTag))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))

typedef struct _GameHubDataDBTablesTagsTag GameHubDataDBTablesTagsTag;
typedef struct _GameHubDataDBTablesTagsTagClass GameHubDataDBTablesTagsTagClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _GameHubDataSourcesItchItchGameUpdateGameInfoData GameHubDataSourcesItchItchGameUpdateGameInfoData;
typedef struct _GameHubDataSourcesItchCavePrivate GameHubDataSourcesItchCavePrivate;
#define _game_hub_data_sources_itch_cave_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_sources_itch_cave_unref (var), NULL)))
typedef struct _GameHubDataGameStatusPrivate GameHubDataGameStatusPrivate;
typedef enum  {
	GAME_HUB_DATA_GAME_STATE_UNINSTALLED,
	GAME_HUB_DATA_GAME_STATE_INSTALLED,
	GAME_HUB_DATA_GAME_STATE_DOWNLOADING,
	GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY,
	GAME_HUB_DATA_GAME_STATE_INSTALLING
} GameHubDataGameState;

#define GAME_HUB_DATA_GAME_TYPE_STATE (game_hub_data_game_state_get_type ())

#define GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD (game_hub_utils_downloader_download_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownload))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))

typedef struct _GameHubUtilsDownloaderDownload GameHubUtilsDownloaderDownload;
typedef struct _GameHubUtilsDownloaderDownloadClass GameHubUtilsDownloaderDownloadClass;

#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS (game_hub_utils_downloader_download_status_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatus))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatusClass))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatusClass))

typedef struct _GameHubUtilsDownloaderDownloadStatus GameHubUtilsDownloaderDownloadStatus;
typedef struct _GameHubUtilsDownloaderDownloadStatusClass GameHubUtilsDownloaderDownloadStatusClass;
typedef struct _GameHubUtilsDownloaderDownloadStatusPrivate GameHubUtilsDownloaderDownloadStatusPrivate;
typedef enum  {
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_QUEUED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_STARTING,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_STARTED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_DOWNLOADING,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_FINISHED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_PAUSED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_CANCELLED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_FAILED
} GameHubUtilsDownloaderDownloadState;

#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATE (game_hub_utils_downloader_download_state_get_type ())
#define _game_hub_data_game_status_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_game_status_unref (var), NULL)))

#define GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER (game_hub_data_runnable_installer_get_type ())
#define GAME_HUB_DATA_RUNNABLE_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstaller))
#define GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstallerClass))
#define GAME_HUB_DATA_RUNNABLE_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstallerClass))

typedef struct _GameHubDataRunnableInstaller GameHubDataRunnableInstaller;
typedef struct _GameHubDataRunnableInstallerClass GameHubDataRunnableInstallerClass;

#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER (game_hub_data_sources_itch_itch_game_installer_get_type ())
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER, GameHubDataSourcesItchItchGameInstaller))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER, GameHubDataSourcesItchItchGameInstallerClass))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER))
#define GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER, GameHubDataSourcesItchItchGameInstallerClass))

typedef struct _GameHubDataSourcesItchItchGameInstaller GameHubDataSourcesItchItchGameInstaller;
typedef struct _GameHubDataSourcesItchItchGameInstallerClass GameHubDataSourcesItchItchGameInstallerClass;
#define _game_hub_data_runnable_installer_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_runnable_installer_unref (var), NULL)))

#define GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG (game_hub_ui_dialogs_install_dialog_get_type ())
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialog))
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialogClass))
#define GAME_HUB_UI_DIALOGS_IS_INSTALL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG))
#define GAME_HUB_UI_DIALOGS_IS_INSTALL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG))
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialogClass))

typedef struct _GameHubUIDialogsInstallDialog GameHubUIDialogsInstallDialog;
typedef struct _GameHubUIDialogsInstallDialogClass GameHubUIDialogsInstallDialogClass;
typedef struct _GameHubDataSourcesItchItchGameInstallData GameHubDataSourcesItchItchGameInstallData;
typedef struct _GameHubDataSourcesItchItchGameRunData GameHubDataSourcesItchItchGameRunData;
typedef struct _GameHubDataSourcesItchItchGameRunWithCompatData GameHubDataSourcesItchItchGameRunWithCompatData;
typedef struct _GameHubDataSourcesItchItchGameUninstallData GameHubDataSourcesItchItchGameUninstallData;
typedef struct _GameHubDataRunnableInstallerPrivate GameHubDataRunnableInstallerPrivate;

#define GAME_HUB_DATA_TYPE_COMPAT_TOOL (game_hub_data_compat_tool_get_type ())
#define GAME_HUB_DATA_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatTool))
#define GAME_HUB_DATA_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))
#define GAME_HUB_DATA_IS_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_IS_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_COMPAT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))

typedef struct _GameHubDataCompatTool GameHubDataCompatTool;
typedef struct _GameHubDataCompatToolClass GameHubDataCompatToolClass;
typedef struct _GameHubDataSourcesItchItchGameInstallerPrivate GameHubDataSourcesItchItchGameInstallerPrivate;
typedef struct _GameHubDataSourcesItchItchGameInstallerInstallData GameHubDataSourcesItchItchGameInstallerInstallData;

struct _GameHubDataRunnable {
	GObject parent_instance;
	GameHubDataRunnablePrivate * priv;
};

struct _GameHubDataRunnableClass {
	GObjectClass parent_class;
	gboolean (*is_supported) (GameHubDataRunnable* self, GameHubDataPlatform* platform, gboolean with_compat);
	void (*install) (GameHubDataRunnable* self, GameHubDataRunnableInstallerInstallMode install_mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	void (*run) (GameHubDataRunnable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	gboolean (*can_be_launched) (GameHubDataRunnable* self, gboolean is_launch_attempt);
	void (*run_with_compat) (GameHubDataRunnable* self, gboolean is_opened_from_menu, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_with_compat_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	GtkFileChooser* (*setup_executable_chooser) (GameHubDataRunnable* self);
	void (*choose_executable) (GameHubDataRunnable* self, gboolean update);
	void (*set_chosen_executable) (GameHubDataRunnable* self, GFile* file, gboolean update);
	void (*save) (GameHubDataRunnable* self);
	void (*update_status) (GameHubDataRunnable* self);
	void (*import) (GameHubDataRunnable* self, gboolean update);
	GFile* (*get_executable) (GameHubDataRunnable* self);
	void (*set_executable) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_work_dir) (GameHubDataRunnable* self);
	void (*set_work_dir) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_default_install_dir) (GameHubDataRunnable* self);
};

struct _GameHubDataGame {
	GameHubDataRunnable parent_instance;
	GameHubDataGamePrivate * priv;
	GameHubDataGameStatus* _status;
	GeeArrayList* overlays;
	gchar* executable_path;
	gchar* work_dir_path;
};

struct _GameHubDataGameClass {
	GameHubDataRunnableClass parent_class;
	void (*uninstall) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*uninstall_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*update_game_info) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_game_info_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*load_achievements) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeArrayList* (*load_achievements_finish) (GameHubDataGame* self, GAsyncResult* _res_);
};

struct _GameHubDataSourcesItchItchGame {
	GameHubDataGame parent_instance;
	GameHubDataSourcesItchItchGamePrivate * priv;
};

struct _GameHubDataSourcesItchItchGameClass {
	GameHubDataGameClass parent_class;
};

struct _GameHubDataSourcesItchItchGamePrivate {
	GeeArrayList* caves;
};

struct _GameHubDataSourcesItchItchGameUpdateGameInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesItchItchGame* self;
};

struct _GameHubDataSourcesItchCave {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataSourcesItchCavePrivate * priv;
	gchar* id;
	gchar* install_dir;
};

struct _GameHubDataSourcesItchCaveClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataSourcesItchCave *self);
};

struct _GameHubDataGameStatus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameStatusPrivate * priv;
	GameHubDataGameState state;
	GameHubDataGame* game;
	GameHubUtilsDownloaderDownload* download;
};

struct _GameHubDataGameStatusClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameStatus *self);
};

struct _GameHubUtilsDownloaderDownloadStatus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubUtilsDownloaderDownloadStatusPrivate * priv;
	GameHubUtilsDownloaderDownloadState state;
};

struct _GameHubUtilsDownloaderDownloadStatusClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubUtilsDownloaderDownloadStatus *self);
	gdouble (*get_progress) (GameHubUtilsDownloaderDownloadStatus* self);
	gchar* (*get_progress_string) (GameHubUtilsDownloaderDownloadStatus* self);
};

struct _GameHubDataSourcesItchItchGameInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesItchItchGame* self;
	GameHubDataRunnableInstallerInstallMode install_mode;
	GeeArrayList* uploads;
	GameHubDataGameSource* _tmp0_;
	GameHubDataGameSource* _tmp1_;
	GeeArrayList* _tmp2_;
	gboolean _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* installers;
	GeeArrayList* _tmp8_;
	GeeArrayList* _upload_list;
	GeeArrayList* _tmp9_;
	gint _upload_size;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _upload_index;
	gint _tmp13_;
	gint _tmp14_;
	JsonObject* upload;
	GeeArrayList* _tmp15_;
	gpointer _tmp16_;
	GeeArrayList* platforms;
	GeeArrayList* _tmp17_;
	JsonObject* platforms_obj;
	JsonObject* _tmp18_;
	JsonObject* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	GeeArrayList* _tmp22_;
	JsonObject* _tmp23_;
	GeeArrayList* _tmp24_;
	JsonObject* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _platform_list;
	GeeArrayList* _tmp31_;
	gint _platform_size;
	GeeArrayList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gint _platform_index;
	gint _tmp35_;
	gint _tmp36_;
	GameHubDataPlatform platform;
	GeeArrayList* _tmp37_;
	gpointer _tmp38_;
	GeeArrayList* _tmp39_;
	JsonObject* _tmp40_;
	GameHubDataSourcesItchItchGameInstaller* _tmp41_;
	GameHubDataSourcesItchItchGameInstaller* _tmp42_;
	GeeArrayList* _tmp43_;
	GameHubUIDialogsInstallDialog* _tmp44_;
	GameHubUIDialogsInstallDialog* _tmp45_;
};

struct _GameHubDataSourcesItchItchGameRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesItchItchGame* self;
	GameHubDataGameSource* _tmp0_;
	GameHubDataGameSource* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
};

struct _GameHubDataSourcesItchItchGameRunWithCompatData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesItchItchGame* self;
	gboolean is_opened_from_menu;
};

struct _GameHubDataSourcesItchItchGameUninstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesItchItchGame* self;
	GameHubDataGameSource* _tmp0_;
	GameHubDataGameSource* _tmp1_;
};

struct _GameHubDataRunnableInstaller {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataRunnableInstallerPrivate * priv;
};

struct _GameHubDataRunnableInstallerClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataRunnableInstaller *self);
	void (*install) (GameHubDataRunnableInstaller* self, GameHubDataRunnable* runnable, GameHubDataCompatTool* tool, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnableInstaller* self, GAsyncResult* _res_);
	gchar* (*get_name) (GameHubDataRunnableInstaller* self);
};

struct _GameHubDataSourcesItchItchGameInstaller {
	GameHubDataRunnableInstaller parent_instance;
	GameHubDataSourcesItchItchGameInstallerPrivate * priv;
	GameHubDataSourcesItchItchGame* game;
	gchar* display_name;
	gchar* file_name;
};

struct _GameHubDataSourcesItchItchGameInstallerClass {
	GameHubDataRunnableInstallerClass parent_class;
};

struct _GameHubDataSourcesItchItchGameInstallerPrivate {
	JsonObject* json;
	gchar* _name;
};

struct _GameHubDataSourcesItchItchGameInstallerInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesItchItchGameInstaller* self;
	GameHubDataRunnable* runnable;
	GameHubDataCompatTool* tool;
	GameHubDataSourcesItchItchGame* _tmp0_;
	GameHubDataGameSource* _tmp1_;
	GameHubDataGameSource* _tmp2_;
};

static gint GameHubDataSourcesItchItchGame_private_offset;
static gpointer game_hub_data_sources_itch_itch_game_parent_class = NULL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ID;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_NAME;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INFO;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INFO_DETAILED;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ICON;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_IMAGE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INSTALL_PATH;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_EXECUTABLE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_WORK_DIR;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_COMPAT_TOOL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_COMPAT_TOOL_SETTINGS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ARGUMENTS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_LAST_LAUNCH;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLAYTIME_SOURCE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLAYTIME_TRACKED;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLATFORMS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_TAGS;
VALA_EXTERN GeeArrayList* game_hub_data_db_tables_tags_TAGS;
VALA_EXTERN GameHubDataDBTablesTagsTag* game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
VALA_EXTERN GameHubDataDBTablesTagsTag* game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
VALA_EXTERN gboolean game_hub_data_runnable_IsLaunched;
static gint GameHubDataSourcesItchItchGameInstaller_private_offset;
static gpointer game_hub_data_sources_itch_itch_game_installer_parent_class = NULL;

VALA_EXTERN GType game_hub_data_runnable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnable, g_object_unref)
VALA_EXTERN GType game_hub_data_platform_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_runnable_installer_install_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGame, g_object_unref)
VALA_EXTERN gpointer game_hub_data_game_achievement_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_achievement_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_achievement (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_achievement (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_achievement (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_achievement (const GValue* value);
VALA_EXTERN GType game_hub_data_game_achievement_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameAchievement, game_hub_data_game_achievement_unref)
VALA_EXTERN gpointer game_hub_data_game_status_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_status_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_status (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_status (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_status (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_status (const GValue* value);
VALA_EXTERN GType game_hub_data_game_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameStatus, game_hub_data_game_status_unref)
VALA_EXTERN GType game_hub_data_game_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameOverlay, g_object_unref)
VALA_EXTERN GType game_hub_data_sources_itch_itch_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesItchItchGame, g_object_unref)
VALA_EXTERN gpointer game_hub_data_sources_itch_cave_ref (gpointer instance);
VALA_EXTERN void game_hub_data_sources_itch_cave_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_sources_itch_param_spec_cave (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags);
VALA_EXTERN void game_hub_data_sources_itch_value_set_cave (GValue* value,
                                                gpointer v_object);
VALA_EXTERN void game_hub_data_sources_itch_value_take_cave (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN gpointer game_hub_data_sources_itch_value_get_cave (const GValue* value);
VALA_EXTERN GType game_hub_data_sources_itch_cave_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesItchCave, game_hub_data_sources_itch_cave_unref)
VALA_EXTERN void game_hub_data_game_update_game_info (GameHubDataGame* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_update_game_info_finish (GameHubDataGame* self,
                                                 GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_update_status (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_install (GameHubDataRunnable* self,
                                     GameHubDataRunnableInstallerInstallMode install_mode,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_install_finish (GameHubDataRunnable* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_run (GameHubDataRunnable* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_run_finish (GameHubDataRunnable* self,
                                        GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_run_with_compat (GameHubDataRunnable* self,
                                             gboolean is_opened_from_menu,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_run_with_compat_finish (GameHubDataRunnable* self,
                                                    GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_game_uninstall (GameHubDataGame* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_uninstall_finish (GameHubDataGame* self,
                                          GAsyncResult* _res_);
VALA_EXTERN gpointer game_hub_data_game_source_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_param_spec_game_source (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_value_set_game_source (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_value_take_game_source (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_value_get_game_source (const GValue* value);
VALA_EXTERN GType game_hub_data_game_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameSource, game_hub_data_game_source_unref)
VALA_EXTERN GType game_hub_data_sources_itch_itch_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesItchItch, game_hub_data_game_source_unref)
VALA_EXTERN GameHubDataSourcesItchItchGame* game_hub_data_sources_itch_itch_game_new (GameHubDataSourcesItchItch* src,
                                                                          JsonNode* json_node);
VALA_EXTERN GameHubDataSourcesItchItchGame* game_hub_data_sources_itch_itch_game_construct (GType object_type,
                                                                                GameHubDataSourcesItchItch* src,
                                                                                JsonNode* json_node);
VALA_EXTERN GameHubDataGame* game_hub_data_game_construct (GType object_type);
VALA_EXTERN void game_hub_data_game_set_source (GameHubDataGame* self,
                                    GameHubDataGameSource* value);
VALA_EXTERN void game_hub_data_runnable_set_id (GameHubDataRunnable* self,
                                    const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_name (GameHubDataRunnable* self,
                                      const gchar* value);
VALA_EXTERN void game_hub_data_game_set_icon (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN void game_hub_data_game_set_description (GameHubDataGame* self,
                                         const gchar* value);
VALA_EXTERN void game_hub_data_game_set_store_page (GameHubDataGame* self,
                                        const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_get_icon (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_image (GameHubDataGame* self,
                                   const gchar* value);
VALA_EXTERN GeeArrayList* game_hub_data_runnable_get_platforms (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_game_set_info (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN GameHubDataSourcesItchItchGame* game_hub_data_sources_itch_itch_game_new_from_db (GameHubDataSourcesItchItch* src,
                                                                                  sqlite3_stmt* s);
VALA_EXTERN GameHubDataSourcesItchItchGame* game_hub_data_sources_itch_itch_game_construct_from_db (GType object_type,
                                                                                        GameHubDataSourcesItchItch* src,
                                                                                        sqlite3_stmt* s);
VALA_EXTERN gpointer game_hub_data_db_table_field_ref (gpointer instance);
VALA_EXTERN void game_hub_data_db_table_field_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_db_table_param_spec_field (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void game_hub_data_db_table_value_set_field (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void game_hub_data_db_table_value_take_field (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer game_hub_data_db_table_value_get_field (const GValue* value);
VALA_EXTERN GType game_hub_data_db_table_field_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTableField, game_hub_data_db_table_field_unref)
VALA_EXTERN gchar* game_hub_data_db_table_field_get (GameHubDataDBTableField* self,
                                         sqlite3_stmt* s);
VALA_EXTERN void game_hub_data_game_set_info_detailed (GameHubDataGame* self,
                                           const gchar* value);
VALA_EXTERN GFile* game_hub_utils_fs_utils_file (const gchar* path,
                                     const gchar* file,
                                     GeeHashMap* variables);
VALA_EXTERN void game_hub_data_runnable_set_install_dir (GameHubDataRunnable* self,
                                             GFile* value);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool (GameHubDataRunnable* self,
                                             const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool_settings (GameHubDataRunnable* self,
                                                      const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_arguments (GameHubDataRunnable* self,
                                           const gchar* value);
VALA_EXTERN gint64 game_hub_data_db_table_field_get_int64 (GameHubDataDBTableField* self,
                                               sqlite3_stmt* s);
VALA_EXTERN void game_hub_data_game_set_last_launch (GameHubDataGame* self,
                                         gint64 value);
VALA_EXTERN void game_hub_data_game_set_playtime_source (GameHubDataGame* self,
                                             gint64 value);
VALA_EXTERN void game_hub_data_game_set_playtime_tracked (GameHubDataGame* self,
                                              gint64 value);
VALA_EXTERN gchar* game_hub_data_platform_id (GameHubDataPlatform self);
VALA_EXTERN GType game_hub_data_db_tables_tags_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTablesTagsTag, g_object_unref)
VALA_EXTERN GeeArrayList* game_hub_data_game_get_tags (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_db_tables_tags_tag_get_id (GameHubDataDBTablesTagsTag* self);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_json (const gchar* json);
VALA_EXTERN const gchar* game_hub_data_game_get_info (GameHubDataGame* self);
static void _vala_JsonNode_free (JsonNode* self);
static void game_hub_data_sources_itch_itch_game_real_update_game_info_data_free (gpointer _data);
static void game_hub_data_sources_itch_itch_game_real_update_game_info (GameHubDataGame* base,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gboolean game_hub_data_sources_itch_itch_game_real_update_game_info_co (GameHubDataSourcesItchItchGameUpdateGameInfoData* _data_);
VALA_EXTERN void game_hub_data_sources_itch_itch_game_update_caves (GameHubDataSourcesItchItchGame* self,
                                                        GeeHashMap* caves_map);
VALA_EXTERN gint game_hub_data_sources_itch_itch_game_get_int_id (GameHubDataSourcesItchItchGame* self);
VALA_EXTERN GameHubDataSourcesItchCave* game_hub_data_sources_itch_itch_game_get_cave (GameHubDataSourcesItchItchGame* self);
static void game_hub_data_sources_itch_itch_game_real_update_status (GameHubDataRunnable* base);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_get_status (GameHubDataGame* self);
VALA_EXTERN GType game_hub_data_game_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer game_hub_utils_downloader_download_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_downloader_download_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_downloader_param_spec_download (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags);
VALA_EXTERN void game_hub_utils_downloader_value_set_download (GValue* value,
                                                   gpointer v_object);
VALA_EXTERN void game_hub_utils_downloader_value_take_download (GValue* value,
                                                    gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_downloader_value_get_download (const GValue* value);
VALA_EXTERN GType game_hub_utils_downloader_download_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownload, game_hub_utils_downloader_download_unref)
VALA_EXTERN gpointer game_hub_utils_downloader_download_status_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_downloader_download_status_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_downloader_download_param_spec_status (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags);
VALA_EXTERN void game_hub_utils_downloader_download_value_set_status (GValue* value,
                                                          gpointer v_object);
VALA_EXTERN void game_hub_utils_downloader_download_value_take_status (GValue* value,
                                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_downloader_download_value_get_status (const GValue* value);
VALA_EXTERN GType game_hub_utils_downloader_download_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownloadStatus, game_hub_utils_downloader_download_status_unref)
VALA_EXTERN GameHubUtilsDownloaderDownloadStatus* game_hub_utils_downloader_download_get_status (GameHubUtilsDownloaderDownload* self);
VALA_EXTERN GType game_hub_utils_downloader_download_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_new (GameHubDataGameState state,
                                                      GameHubDataGame* game,
                                                      GameHubUtilsDownloaderDownload* download);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_construct (GType object_type,
                                                            GameHubDataGameState state,
                                                            GameHubDataGame* game,
                                                            GameHubUtilsDownloaderDownload* download);
VALA_EXTERN void game_hub_data_game_set_status (GameHubDataGame* self,
                                    GameHubDataGameStatus* value);
VALA_EXTERN void game_hub_data_game_remove_tag (GameHubDataGame* self,
                                    GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN void game_hub_data_game_add_tag (GameHubDataGame* self,
                                 GameHubDataDBTablesTagsTag* tag);
static void game_hub_data_sources_itch_itch_game_real_install_data_free (gpointer _data);
static void game_hub_data_sources_itch_itch_game_real_install (GameHubDataRunnable* base,
                                                        GameHubDataRunnableInstallerInstallMode install_mode,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean game_hub_data_sources_itch_itch_game_real_install_co (GameHubDataSourcesItchItchGameInstallData* _data_);
VALA_EXTERN GameHubDataGameSource* game_hub_data_game_get_source (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_sources_itch_itch_get_game_uploads (GameHubDataSourcesItchItch* self,
                                                       GameHubDataSourcesItchItchGame* game,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN GeeArrayList* game_hub_data_sources_itch_itch_get_game_uploads_finish (GameHubDataSourcesItchItch* self,
                                                                       GAsyncResult* _res_);
static void game_hub_data_sources_itch_itch_game_install_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_set_is_installable (GameHubDataGame* self,
                                            gboolean value);
VALA_EXTERN gpointer game_hub_data_runnable_installer_ref (gpointer instance);
VALA_EXTERN void game_hub_data_runnable_installer_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_runnable_param_spec_installer (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags);
VALA_EXTERN void game_hub_data_runnable_value_set_installer (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN void game_hub_data_runnable_value_take_installer (GValue* value,
                                                  gpointer v_object);
VALA_EXTERN gpointer game_hub_data_runnable_value_get_installer (const GValue* value);
VALA_EXTERN GType game_hub_data_runnable_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnableInstaller, game_hub_data_runnable_installer_unref)
VALA_EXTERN GameHubDataSourcesItchItchGameInstaller* game_hub_data_sources_itch_itch_game_installer_new (GameHubDataSourcesItchItchGame* game,
                                                                                             JsonObject* json,
                                                                                             GameHubDataPlatform platform);
VALA_EXTERN GameHubDataSourcesItchItchGameInstaller* game_hub_data_sources_itch_itch_game_installer_construct (GType object_type,
                                                                                                   GameHubDataSourcesItchItchGame* game,
                                                                                                   JsonObject* json,
                                                                                                   GameHubDataPlatform platform);
VALA_EXTERN GType game_hub_data_sources_itch_itch_game_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesItchItchGameInstaller, game_hub_data_runnable_installer_unref)
static gboolean _game_hub_data_sources_itch_itch_game_real_install_co_gsource_func (gpointer self);
VALA_EXTERN GameHubUIDialogsInstallDialog* game_hub_ui_dialogs_install_dialog_new (GameHubDataRunnable* runnable,
                                                                       GeeArrayList* installers,
                                                                       GameHubDataRunnableInstallerInstallMode install_mode,
                                                                       GSourceFunc callback,
                                                                       gpointer callback_target,
                                                                       GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN GameHubUIDialogsInstallDialog* game_hub_ui_dialogs_install_dialog_construct (GType object_type,
                                                                             GameHubDataRunnable* runnable,
                                                                             GeeArrayList* installers,
                                                                             GameHubDataRunnableInstallerInstallMode install_mode,
                                                                             GSourceFunc callback,
                                                                             gpointer callback_target,
                                                                             GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN GType game_hub_ui_dialogs_install_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUIDialogsInstallDialog, g_object_unref)
static void game_hub_data_sources_itch_itch_game_real_run_data_free (gpointer _data);
static void game_hub_data_sources_itch_itch_game_real_run (GameHubDataRunnable* base,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static gboolean game_hub_data_sources_itch_itch_game_real_run_co (GameHubDataSourcesItchItchGameRunData* _data_);
VALA_EXTERN gboolean game_hub_data_runnable_can_be_launched (GameHubDataRunnable* self,
                                                 gboolean is_launch_attempt);
VALA_EXTERN void game_hub_data_runnable_set_is_running (GameHubDataRunnable* self,
                                            gboolean value);
VALA_EXTERN void game_hub_data_runnable_save (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_sources_itch_itch_run_game (GameHubDataSourcesItchItch* self,
                                               GameHubDataSourcesItchItchGame* game,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void game_hub_data_sources_itch_itch_run_game_finish (GameHubDataSourcesItchItch* self,
                                                      GAsyncResult* _res_);
static void game_hub_data_sources_itch_itch_game_run_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN gint64 game_hub_data_game_get_playtime_tracked (GameHubDataGame* self);
VALA_EXTERN gint64 game_hub_data_game_get_last_launch (GameHubDataGame* self);
static gboolean ___lambda121_ (GameHubDataSourcesItchItchGame* self);
static gboolean ____lambda121__gsource_func (gpointer self);
static void game_hub_data_sources_itch_itch_game_real_run_with_compat_data_free (gpointer _data);
static void game_hub_data_sources_itch_itch_game_real_run_with_compat (GameHubDataRunnable* base,
                                                                gboolean is_opened_from_menu,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static gboolean game_hub_data_sources_itch_itch_game_real_run_with_compat_co (GameHubDataSourcesItchItchGameRunWithCompatData* _data_);
static void game_hub_data_sources_itch_itch_game_real_uninstall_data_free (gpointer _data);
static void game_hub_data_sources_itch_itch_game_real_uninstall (GameHubDataGame* base,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static gboolean game_hub_data_sources_itch_itch_game_real_uninstall_co (GameHubDataSourcesItchItchGameUninstallData* _data_);
VALA_EXTERN void game_hub_data_sources_itch_itch_uninstall_game (GameHubDataSourcesItchItch* self,
                                                     GameHubDataSourcesItchItchGame* game,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void game_hub_data_sources_itch_itch_uninstall_game_finish (GameHubDataSourcesItchItch* self,
                                                            GAsyncResult* _res_);
VALA_EXTERN const gchar* game_hub_data_runnable_get_id (GameHubDataRunnable* self);
VALA_EXTERN const gchar* game_hub_data_sources_itch_itch_game_get_cave_id (GameHubDataSourcesItchItchGame* self);
VALA_EXTERN GType game_hub_data_compat_tool_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataCompatTool, g_object_unref)
VALA_EXTERN void game_hub_data_runnable_installer_install (GameHubDataRunnableInstaller* self,
                                               GameHubDataRunnable* runnable,
                                               GameHubDataCompatTool* tool,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_installer_install_finish (GameHubDataRunnableInstaller* self,
                                                      GAsyncResult* _res_);
VALA_EXTERN gchar* game_hub_data_runnable_installer_get_name (GameHubDataRunnableInstaller* self);
VALA_EXTERN GameHubDataRunnableInstaller* game_hub_data_runnable_installer_construct (GType object_type);
VALA_EXTERN void game_hub_data_runnable_installer_set_id (GameHubDataRunnableInstaller* self,
                                              const gchar* value);
VALA_EXTERN void game_hub_data_runnable_installer_set_platform (GameHubDataRunnableInstaller* self,
                                                    GameHubDataPlatform value);
VALA_EXTERN const gchar* game_hub_data_runnable_get_name (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_installer_set_version (GameHubDataRunnableInstaller* self,
                                                   const gchar* value);
VALA_EXTERN const gchar* game_hub_data_runnable_installer_get_version (GameHubDataRunnableInstaller* self);
VALA_EXTERN void game_hub_data_runnable_installer_set_full_size (GameHubDataRunnableInstaller* self,
                                                     gint64 value);
static void game_hub_data_sources_itch_itch_game_installer_real_install_data_free (gpointer _data);
static void game_hub_data_sources_itch_itch_game_installer_real_install (GameHubDataRunnableInstaller* base,
                                                                  GameHubDataRunnable* runnable,
                                                                  GameHubDataCompatTool* tool,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static gboolean game_hub_data_sources_itch_itch_game_installer_real_install_co (GameHubDataSourcesItchItchGameInstallerInstallData* _data_);
VALA_EXTERN void game_hub_data_sources_itch_itch_install_game (GameHubDataSourcesItchItch* self,
                                                   GameHubDataSourcesItchItchGameInstaller* installer,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void game_hub_data_sources_itch_itch_install_game_finish (GameHubDataSourcesItchItch* self,
                                                          GAsyncResult* _res_);
static void game_hub_data_sources_itch_itch_game_installer_install_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
VALA_EXTERN gint game_hub_data_sources_itch_itch_game_installer_get_int_id (GameHubDataSourcesItchItchGameInstaller* self);
VALA_EXTERN const gchar* game_hub_data_runnable_installer_get_id (GameHubDataRunnableInstaller* self);
static void game_hub_data_sources_itch_itch_game_installer_finalize (GameHubDataRunnableInstaller * obj);
static GType game_hub_data_sources_itch_itch_game_installer_get_type_once (void);
static void game_hub_data_sources_itch_itch_game_finalize (GObject * obj);
static GType game_hub_data_sources_itch_itch_game_get_type_once (void);
static void _vala_game_hub_data_sources_itch_itch_game_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const GameHubDataPlatform GAME_HUB_DATA_PLATFORM_PLATFORMS[4];

static inline gpointer
game_hub_data_sources_itch_itch_game_get_instance_private (GameHubDataSourcesItchItchGame* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataSourcesItchItchGame_private_offset);
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 34 "../src/data/sources/itch/ItchGame.vala"
	return self ? json_object_ref (self) : NULL;
#line 960 "ItchGame.c"
}

GameHubDataSourcesItchItchGame*
game_hub_data_sources_itch_itch_game_construct (GType object_type,
                                                GameHubDataSourcesItchItch* src,
                                                JsonNode* json_node)
{
	GameHubDataSourcesItchItchGame * self = NULL;
	JsonObject* json_obj = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	JsonObject* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	JsonObject* _tmp8_;
	JsonObject* _tmp13_;
	const gchar* _tmp14_;
	JsonObject* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	JsonObject* platforms_obj = NULL;
	JsonObject* _tmp19_;
	JsonObject* _tmp20_;
	JsonObject* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp25_;
	JsonObject* _tmp28_;
	gchar* _tmp31_;
	gchar* _tmp32_;
#line 30 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 30 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (json_node != NULL, NULL);
#line 30 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) game_hub_data_game_construct (object_type);
#line 32 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_source ((GameHubDataGame*) self, (GameHubDataGameSource*) src);
#line 34 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = json_node_get_object (json_node);
#line 34 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = _json_object_ref0 (_tmp0_);
#line 34 "../src/data/sources/itch/ItchGame.vala"
	json_obj = _tmp1_;
#line 36 "../src/data/sources/itch/ItchGame.vala"
	_tmp2_ = json_obj;
#line 36 "../src/data/sources/itch/ItchGame.vala"
	_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (_tmp2_, "id"));
#line 36 "../src/data/sources/itch/ItchGame.vala"
	_tmp4_ = _tmp3_;
#line 36 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp4_);
#line 36 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp4_);
#line 37 "../src/data/sources/itch/ItchGame.vala"
	_tmp5_ = json_obj;
#line 37 "../src/data/sources/itch/ItchGame.vala"
	_tmp6_ = json_object_get_string_member (_tmp5_, "title");
#line 37 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, _tmp6_);
#line 38 "../src/data/sources/itch/ItchGame.vala"
	_tmp8_ = json_obj;
#line 38 "../src/data/sources/itch/ItchGame.vala"
	if (json_object_has_member (_tmp8_, "stillCoverUrl")) {
#line 1028 "ItchGame.c"
		JsonObject* _tmp9_;
		const gchar* _tmp10_;
#line 38 "../src/data/sources/itch/ItchGame.vala"
		_tmp9_ = json_obj;
#line 38 "../src/data/sources/itch/ItchGame.vala"
		_tmp10_ = json_object_get_string_member (_tmp9_, "stillCoverUrl");
#line 38 "../src/data/sources/itch/ItchGame.vala"
		_tmp7_ = _tmp10_;
#line 1037 "ItchGame.c"
	} else {
		JsonObject* _tmp11_;
		const gchar* _tmp12_;
#line 38 "../src/data/sources/itch/ItchGame.vala"
		_tmp11_ = json_obj;
#line 38 "../src/data/sources/itch/ItchGame.vala"
		_tmp12_ = json_object_get_string_member (_tmp11_, "coverUrl");
#line 38 "../src/data/sources/itch/ItchGame.vala"
		_tmp7_ = _tmp12_;
#line 1047 "ItchGame.c"
	}
#line 38 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_icon ((GameHubDataGame*) self, _tmp7_);
#line 39 "../src/data/sources/itch/ItchGame.vala"
	_tmp13_ = json_obj;
#line 39 "../src/data/sources/itch/ItchGame.vala"
	_tmp14_ = json_object_get_string_member (_tmp13_, "shortText");
#line 39 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_description ((GameHubDataGame*) self, _tmp14_);
#line 40 "../src/data/sources/itch/ItchGame.vala"
	_tmp15_ = json_obj;
#line 40 "../src/data/sources/itch/ItchGame.vala"
	_tmp16_ = json_object_get_string_member (_tmp15_, "url");
#line 40 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_store_page ((GameHubDataGame*) self, _tmp16_);
#line 42 "../src/data/sources/itch/ItchGame.vala"
	_tmp17_ = game_hub_data_game_get_icon ((GameHubDataGame*) self);
#line 42 "../src/data/sources/itch/ItchGame.vala"
	_tmp18_ = _tmp17_;
#line 42 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_image ((GameHubDataGame*) self, _tmp18_);
#line 44 "../src/data/sources/itch/ItchGame.vala"
	_tmp19_ = json_obj;
#line 44 "../src/data/sources/itch/ItchGame.vala"
	_tmp20_ = json_object_get_object_member (_tmp19_, "platforms");
#line 44 "../src/data/sources/itch/ItchGame.vala"
	_tmp21_ = _json_object_ref0 (_tmp20_);
#line 44 "../src/data/sources/itch/ItchGame.vala"
	platforms_obj = _tmp21_;
#line 45 "../src/data/sources/itch/ItchGame.vala"
	_tmp22_ = platforms_obj;
#line 45 "../src/data/sources/itch/ItchGame.vala"
	if (json_object_has_member (_tmp22_, "windows")) {
#line 1081 "ItchGame.c"
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
#line 47 "../src/data/sources/itch/ItchGame.vala"
		_tmp23_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 47 "../src/data/sources/itch/ItchGame.vala"
		_tmp24_ = _tmp23_;
#line 47 "../src/data/sources/itch/ItchGame.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_WINDOWS));
#line 1090 "ItchGame.c"
	}
#line 49 "../src/data/sources/itch/ItchGame.vala"
	_tmp25_ = platforms_obj;
#line 49 "../src/data/sources/itch/ItchGame.vala"
	if (json_object_has_member (_tmp25_, "linux")) {
#line 1096 "ItchGame.c"
		GeeArrayList* _tmp26_;
		GeeArrayList* _tmp27_;
#line 51 "../src/data/sources/itch/ItchGame.vala"
		_tmp26_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 51 "../src/data/sources/itch/ItchGame.vala"
		_tmp27_ = _tmp26_;
#line 51 "../src/data/sources/itch/ItchGame.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_LINUX));
#line 1105 "ItchGame.c"
	}
#line 53 "../src/data/sources/itch/ItchGame.vala"
	_tmp28_ = platforms_obj;
#line 53 "../src/data/sources/itch/ItchGame.vala"
	if (json_object_has_member (_tmp28_, "osx")) {
#line 1111 "ItchGame.c"
		GeeArrayList* _tmp29_;
		GeeArrayList* _tmp30_;
#line 55 "../src/data/sources/itch/ItchGame.vala"
		_tmp29_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 55 "../src/data/sources/itch/ItchGame.vala"
		_tmp30_ = _tmp29_;
#line 55 "../src/data/sources/itch/ItchGame.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_MACOS));
#line 1120 "ItchGame.c"
	}
#line 59 "../src/data/sources/itch/ItchGame.vala"
	_tmp31_ = json_to_string (json_node, FALSE);
#line 59 "../src/data/sources/itch/ItchGame.vala"
	_tmp32_ = _tmp31_;
#line 59 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp32_);
#line 59 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp32_);
#line 61 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 30 "../src/data/sources/itch/ItchGame.vala"
	_json_object_unref0 (platforms_obj);
#line 30 "../src/data/sources/itch/ItchGame.vala"
	_json_object_unref0 (json_obj);
#line 30 "../src/data/sources/itch/ItchGame.vala"
	return self;
#line 1138 "ItchGame.c"
}

GameHubDataSourcesItchItchGame*
game_hub_data_sources_itch_itch_game_new (GameHubDataSourcesItchItch* src,
                                          JsonNode* json_node)
{
#line 30 "../src/data/sources/itch/ItchGame.vala"
	return game_hub_data_sources_itch_itch_game_construct (GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME, src, json_node);
#line 1147 "ItchGame.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 64 "../src/data/sources/itch/ItchGame.vala"
	g_boxed_free (json_node_get_type (), self);
#line 1155 "ItchGame.c"
}

GameHubDataSourcesItchItchGame*
game_hub_data_sources_itch_itch_game_construct_from_db (GType object_type,
                                                        GameHubDataSourcesItchItch* src,
                                                        sqlite3_stmt* s)
{
	GameHubDataSourcesItchItchGame * self = NULL;
	GameHubDataDBTableField* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GameHubDataDBTableField* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GameHubDataDBTableField* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GameHubDataDBTableField* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GameHubDataDBTableField* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GameHubDataDBTableField* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GFile* _tmp18_ = NULL;
	GameHubDataDBTableField* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	GameHubDataDBTableField* _tmp27_;
	gchar* _tmp28_;
	GameHubDataDBTableField* _tmp29_;
	gchar* _tmp30_;
	GameHubDataDBTableField* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GameHubDataDBTableField* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GameHubDataDBTableField* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GameHubDataDBTableField* _tmp40_;
	GameHubDataDBTableField* _tmp41_;
	GameHubDataDBTableField* _tmp42_;
	GeeArrayList* _tmp43_;
	GeeArrayList* _tmp44_;
	gchar** pls = NULL;
	GameHubDataDBTableField* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	gint pls_length1;
	gint _pls_size_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	GeeArrayList* _tmp59_;
	GeeArrayList* _tmp60_;
	gchar* _tmp61_ = NULL;
	GameHubDataDBTableField* _tmp62_;
	gchar* _tmp63_;
	gchar** tag_ids = NULL;
	gchar** _tmp65_;
	gchar** _tmp66_;
	gint tag_ids_length1;
	gint _tag_ids_size_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	JsonNode* info_root = NULL;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	JsonNode* _tmp89_;
	gboolean _tmp90_ = FALSE;
	JsonNode* _tmp91_;
#line 64 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) game_hub_data_game_construct (object_type);
#line 66 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_source ((GameHubDataGame*) self, (GameHubDataGameSource*) src);
#line 67 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = game_hub_data_db_tables_games_ID;
#line 67 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = game_hub_data_db_table_field_get (_tmp0_, s);
#line 67 "../src/data/sources/itch/ItchGame.vala"
	_tmp2_ = _tmp1_;
#line 67 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp2_);
#line 67 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp2_);
#line 68 "../src/data/sources/itch/ItchGame.vala"
	_tmp3_ = game_hub_data_db_tables_games_NAME;
#line 68 "../src/data/sources/itch/ItchGame.vala"
	_tmp4_ = game_hub_data_db_table_field_get (_tmp3_, s);
#line 68 "../src/data/sources/itch/ItchGame.vala"
	_tmp5_ = _tmp4_;
#line 68 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, _tmp5_);
#line 68 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp5_);
#line 69 "../src/data/sources/itch/ItchGame.vala"
	_tmp6_ = game_hub_data_db_tables_games_INFO;
#line 69 "../src/data/sources/itch/ItchGame.vala"
	_tmp7_ = game_hub_data_db_table_field_get (_tmp6_, s);
#line 69 "../src/data/sources/itch/ItchGame.vala"
	_tmp8_ = _tmp7_;
#line 69 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp8_);
#line 69 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp8_);
#line 70 "../src/data/sources/itch/ItchGame.vala"
	_tmp9_ = game_hub_data_db_tables_games_INFO_DETAILED;
#line 70 "../src/data/sources/itch/ItchGame.vala"
	_tmp10_ = game_hub_data_db_table_field_get (_tmp9_, s);
#line 70 "../src/data/sources/itch/ItchGame.vala"
	_tmp11_ = _tmp10_;
#line 70 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_info_detailed ((GameHubDataGame*) self, _tmp11_);
#line 70 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp11_);
#line 71 "../src/data/sources/itch/ItchGame.vala"
	_tmp12_ = game_hub_data_db_tables_games_ICON;
#line 71 "../src/data/sources/itch/ItchGame.vala"
	_tmp13_ = game_hub_data_db_table_field_get (_tmp12_, s);
#line 71 "../src/data/sources/itch/ItchGame.vala"
	_tmp14_ = _tmp13_;
#line 71 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_icon ((GameHubDataGame*) self, _tmp14_);
#line 71 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp14_);
#line 72 "../src/data/sources/itch/ItchGame.vala"
	_tmp15_ = game_hub_data_db_tables_games_IMAGE;
#line 72 "../src/data/sources/itch/ItchGame.vala"
	_tmp16_ = game_hub_data_db_table_field_get (_tmp15_, s);
#line 72 "../src/data/sources/itch/ItchGame.vala"
	_tmp17_ = _tmp16_;
#line 72 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_image ((GameHubDataGame*) self, _tmp17_);
#line 72 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp17_);
#line 73 "../src/data/sources/itch/ItchGame.vala"
	_tmp19_ = game_hub_data_db_tables_games_INSTALL_PATH;
#line 73 "../src/data/sources/itch/ItchGame.vala"
	_tmp20_ = game_hub_data_db_table_field_get (_tmp19_, s);
#line 73 "../src/data/sources/itch/ItchGame.vala"
	_tmp21_ = _tmp20_;
#line 73 "../src/data/sources/itch/ItchGame.vala"
	_tmp22_ = _tmp21_ != NULL;
#line 73 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp21_);
#line 73 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp22_) {
#line 1315 "ItchGame.c"
		GameHubDataDBTableField* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GFile* _tmp26_;
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_tmp23_ = game_hub_data_db_tables_games_INSTALL_PATH;
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_tmp24_ = game_hub_data_db_table_field_get (_tmp23_, s);
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_tmp25_ = _tmp24_;
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_tmp26_ = game_hub_utils_fs_utils_file (_tmp25_, NULL, NULL);
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_g_object_unref0 (_tmp18_);
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_tmp18_ = _tmp26_;
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_g_free0 (_tmp25_);
#line 1334 "ItchGame.c"
	} else {
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_g_object_unref0 (_tmp18_);
#line 73 "../src/data/sources/itch/ItchGame.vala"
		_tmp18_ = NULL;
#line 1340 "ItchGame.c"
	}
#line 73 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) self, _tmp18_);
#line 74 "../src/data/sources/itch/ItchGame.vala"
	_tmp27_ = game_hub_data_db_tables_games_EXECUTABLE;
#line 74 "../src/data/sources/itch/ItchGame.vala"
	_tmp28_ = game_hub_data_db_table_field_get (_tmp27_, s);
#line 74 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (((GameHubDataGame*) self)->executable_path);
#line 74 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataGame*) self)->executable_path = _tmp28_;
#line 75 "../src/data/sources/itch/ItchGame.vala"
	_tmp29_ = game_hub_data_db_tables_games_WORK_DIR;
#line 75 "../src/data/sources/itch/ItchGame.vala"
	_tmp30_ = game_hub_data_db_table_field_get (_tmp29_, s);
#line 75 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (((GameHubDataGame*) self)->work_dir_path);
#line 75 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataGame*) self)->work_dir_path = _tmp30_;
#line 76 "../src/data/sources/itch/ItchGame.vala"
	_tmp31_ = game_hub_data_db_tables_games_COMPAT_TOOL;
#line 76 "../src/data/sources/itch/ItchGame.vala"
	_tmp32_ = game_hub_data_db_table_field_get (_tmp31_, s);
#line 76 "../src/data/sources/itch/ItchGame.vala"
	_tmp33_ = _tmp32_;
#line 76 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_compat_tool ((GameHubDataRunnable*) self, _tmp33_);
#line 76 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp33_);
#line 77 "../src/data/sources/itch/ItchGame.vala"
	_tmp34_ = game_hub_data_db_tables_games_COMPAT_TOOL_SETTINGS;
#line 77 "../src/data/sources/itch/ItchGame.vala"
	_tmp35_ = game_hub_data_db_table_field_get (_tmp34_, s);
#line 77 "../src/data/sources/itch/ItchGame.vala"
	_tmp36_ = _tmp35_;
#line 77 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_compat_tool_settings ((GameHubDataRunnable*) self, _tmp36_);
#line 77 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp36_);
#line 78 "../src/data/sources/itch/ItchGame.vala"
	_tmp37_ = game_hub_data_db_tables_games_ARGUMENTS;
#line 78 "../src/data/sources/itch/ItchGame.vala"
	_tmp38_ = game_hub_data_db_table_field_get (_tmp37_, s);
#line 78 "../src/data/sources/itch/ItchGame.vala"
	_tmp39_ = _tmp38_;
#line 78 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_arguments ((GameHubDataRunnable*) self, _tmp39_);
#line 78 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp39_);
#line 79 "../src/data/sources/itch/ItchGame.vala"
	_tmp40_ = game_hub_data_db_tables_games_LAST_LAUNCH;
#line 79 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_last_launch ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp40_, s));
#line 80 "../src/data/sources/itch/ItchGame.vala"
	_tmp41_ = game_hub_data_db_tables_games_PLAYTIME_SOURCE;
#line 80 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_playtime_source ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp41_, s));
#line 81 "../src/data/sources/itch/ItchGame.vala"
	_tmp42_ = game_hub_data_db_tables_games_PLAYTIME_TRACKED;
#line 81 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_game_set_playtime_tracked ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp42_, s));
#line 83 "../src/data/sources/itch/ItchGame.vala"
	_tmp43_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 83 "../src/data/sources/itch/ItchGame.vala"
	_tmp44_ = _tmp43_;
#line 83 "../src/data/sources/itch/ItchGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp44_);
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_tmp45_ = game_hub_data_db_tables_games_PLATFORMS;
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_tmp46_ = game_hub_data_db_table_field_get (_tmp45_, s);
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_tmp47_ = _tmp46_;
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_tmp49_ = _tmp48_ = g_strsplit (_tmp47_, ",", 0);
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_tmp50_ = _tmp49_;
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_tmp50__length1 = _vala_array_length (_tmp48_);
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp47_);
#line 84 "../src/data/sources/itch/ItchGame.vala"
	pls = _tmp50_;
#line 84 "../src/data/sources/itch/ItchGame.vala"
	pls_length1 = _tmp50__length1;
#line 84 "../src/data/sources/itch/ItchGame.vala"
	_pls_size_ = pls_length1;
#line 85 "../src/data/sources/itch/ItchGame.vala"
	_tmp51_ = pls;
#line 85 "../src/data/sources/itch/ItchGame.vala"
	_tmp51__length1 = pls_length1;
#line 1432 "ItchGame.c"
	{
		gchar** pl_collection = NULL;
		gint pl_collection_length1 = 0;
		gint _pl_collection_size_ = 0;
		gint pl_it = 0;
#line 85 "../src/data/sources/itch/ItchGame.vala"
		pl_collection = _tmp51_;
#line 85 "../src/data/sources/itch/ItchGame.vala"
		pl_collection_length1 = _tmp51__length1;
#line 85 "../src/data/sources/itch/ItchGame.vala"
		for (pl_it = 0; pl_it < pl_collection_length1; pl_it = pl_it + 1) {
#line 1444 "ItchGame.c"
			gchar* _tmp52_;
			gchar* pl = NULL;
#line 85 "../src/data/sources/itch/ItchGame.vala"
			_tmp52_ = g_strdup (pl_collection[pl_it]);
#line 85 "../src/data/sources/itch/ItchGame.vala"
			pl = _tmp52_;
#line 1451 "ItchGame.c"
			{
				{
					GameHubDataPlatform* p_collection = NULL;
					gint p_collection_length1 = 0;
					gint _p_collection_size_ = 0;
					gint p_it = 0;
#line 87 "../src/data/sources/itch/ItchGame.vala"
					p_collection = GAME_HUB_DATA_PLATFORM_PLATFORMS;
#line 87 "../src/data/sources/itch/ItchGame.vala"
					p_collection_length1 = G_N_ELEMENTS (GAME_HUB_DATA_PLATFORM_PLATFORMS);
#line 87 "../src/data/sources/itch/ItchGame.vala"
					for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 1464 "ItchGame.c"
						GameHubDataPlatform p = 0;
#line 87 "../src/data/sources/itch/ItchGame.vala"
						p = p_collection[p_it];
#line 1468 "ItchGame.c"
						{
							const gchar* _tmp53_;
							gchar* _tmp54_;
							gchar* _tmp55_;
							gboolean _tmp56_;
#line 89 "../src/data/sources/itch/ItchGame.vala"
							_tmp53_ = pl;
#line 89 "../src/data/sources/itch/ItchGame.vala"
							_tmp54_ = game_hub_data_platform_id (p);
#line 89 "../src/data/sources/itch/ItchGame.vala"
							_tmp55_ = _tmp54_;
#line 89 "../src/data/sources/itch/ItchGame.vala"
							_tmp56_ = g_strcmp0 (_tmp53_, _tmp55_) == 0;
#line 89 "../src/data/sources/itch/ItchGame.vala"
							_g_free0 (_tmp55_);
#line 89 "../src/data/sources/itch/ItchGame.vala"
							if (_tmp56_) {
#line 1486 "ItchGame.c"
								GeeArrayList* _tmp57_;
								GeeArrayList* _tmp58_;
#line 91 "../src/data/sources/itch/ItchGame.vala"
								_tmp57_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 91 "../src/data/sources/itch/ItchGame.vala"
								_tmp58_ = _tmp57_;
#line 91 "../src/data/sources/itch/ItchGame.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, (gpointer) ((gintptr) p));
#line 92 "../src/data/sources/itch/ItchGame.vala"
								break;
#line 1497 "ItchGame.c"
							}
						}
					}
				}
#line 85 "../src/data/sources/itch/ItchGame.vala"
				_g_free0 (pl);
#line 1504 "ItchGame.c"
			}
		}
	}
#line 97 "../src/data/sources/itch/ItchGame.vala"
	_tmp59_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 97 "../src/data/sources/itch/ItchGame.vala"
	_tmp60_ = _tmp59_;
#line 97 "../src/data/sources/itch/ItchGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp60_);
#line 98 "../src/data/sources/itch/ItchGame.vala"
	_tmp62_ = game_hub_data_db_tables_games_TAGS;
#line 98 "../src/data/sources/itch/ItchGame.vala"
	_tmp63_ = game_hub_data_db_table_field_get (_tmp62_, s);
#line 98 "../src/data/sources/itch/ItchGame.vala"
	_tmp61_ = _tmp63_;
#line 98 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp61_ == NULL) {
#line 1522 "ItchGame.c"
		gchar* _tmp64_;
#line 98 "../src/data/sources/itch/ItchGame.vala"
		_tmp64_ = g_strdup ("");
#line 98 "../src/data/sources/itch/ItchGame.vala"
		_g_free0 (_tmp61_);
#line 98 "../src/data/sources/itch/ItchGame.vala"
		_tmp61_ = _tmp64_;
#line 1530 "ItchGame.c"
	}
#line 98 "../src/data/sources/itch/ItchGame.vala"
	_tmp66_ = _tmp65_ = g_strsplit (_tmp61_, ",", 0);
#line 98 "../src/data/sources/itch/ItchGame.vala"
	tag_ids = _tmp66_;
#line 98 "../src/data/sources/itch/ItchGame.vala"
	tag_ids_length1 = _vala_array_length (_tmp65_);
#line 98 "../src/data/sources/itch/ItchGame.vala"
	_tag_ids_size_ = tag_ids_length1;
#line 99 "../src/data/sources/itch/ItchGame.vala"
	_tmp67_ = tag_ids;
#line 99 "../src/data/sources/itch/ItchGame.vala"
	_tmp67__length1 = tag_ids_length1;
#line 1544 "ItchGame.c"
	{
		gchar** tid_collection = NULL;
		gint tid_collection_length1 = 0;
		gint _tid_collection_size_ = 0;
		gint tid_it = 0;
#line 99 "../src/data/sources/itch/ItchGame.vala"
		tid_collection = _tmp67_;
#line 99 "../src/data/sources/itch/ItchGame.vala"
		tid_collection_length1 = _tmp67__length1;
#line 99 "../src/data/sources/itch/ItchGame.vala"
		for (tid_it = 0; tid_it < tid_collection_length1; tid_it = tid_it + 1) {
#line 1556 "ItchGame.c"
			gchar* _tmp68_;
			gchar* tid = NULL;
#line 99 "../src/data/sources/itch/ItchGame.vala"
			_tmp68_ = g_strdup (tid_collection[tid_it]);
#line 99 "../src/data/sources/itch/ItchGame.vala"
			tid = _tmp68_;
#line 1563 "ItchGame.c"
			{
				{
					GeeArrayList* _t_list = NULL;
					GeeArrayList* _tmp69_;
					gint _t_size = 0;
					GeeArrayList* _tmp70_;
					gint _tmp71_;
					gint _tmp72_;
					gint _t_index = 0;
#line 101 "../src/data/sources/itch/ItchGame.vala"
					_tmp69_ = game_hub_data_db_tables_tags_TAGS;
#line 101 "../src/data/sources/itch/ItchGame.vala"
					_t_list = _tmp69_;
#line 101 "../src/data/sources/itch/ItchGame.vala"
					_tmp70_ = _t_list;
#line 101 "../src/data/sources/itch/ItchGame.vala"
					_tmp71_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp70_);
#line 101 "../src/data/sources/itch/ItchGame.vala"
					_tmp72_ = _tmp71_;
#line 101 "../src/data/sources/itch/ItchGame.vala"
					_t_size = _tmp72_;
#line 101 "../src/data/sources/itch/ItchGame.vala"
					_t_index = -1;
#line 101 "../src/data/sources/itch/ItchGame.vala"
					while (TRUE) {
#line 1589 "ItchGame.c"
						gint _tmp73_;
						gint _tmp74_;
						GameHubDataDBTablesTagsTag* t = NULL;
						GeeArrayList* _tmp75_;
						gpointer _tmp76_;
						const gchar* _tmp77_;
						GameHubDataDBTablesTagsTag* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
#line 101 "../src/data/sources/itch/ItchGame.vala"
						_t_index = _t_index + 1;
#line 101 "../src/data/sources/itch/ItchGame.vala"
						_tmp73_ = _t_index;
#line 101 "../src/data/sources/itch/ItchGame.vala"
						_tmp74_ = _t_size;
#line 101 "../src/data/sources/itch/ItchGame.vala"
						if (!(_tmp73_ < _tmp74_)) {
#line 101 "../src/data/sources/itch/ItchGame.vala"
							break;
#line 1609 "ItchGame.c"
						}
#line 101 "../src/data/sources/itch/ItchGame.vala"
						_tmp75_ = _t_list;
#line 101 "../src/data/sources/itch/ItchGame.vala"
						_tmp76_ = gee_abstract_list_get ((GeeAbstractList*) _tmp75_, _t_index);
#line 101 "../src/data/sources/itch/ItchGame.vala"
						t = (GameHubDataDBTablesTagsTag*) _tmp76_;
#line 103 "../src/data/sources/itch/ItchGame.vala"
						_tmp77_ = tid;
#line 103 "../src/data/sources/itch/ItchGame.vala"
						_tmp78_ = t;
#line 103 "../src/data/sources/itch/ItchGame.vala"
						_tmp79_ = game_hub_data_db_tables_tags_tag_get_id (_tmp78_);
#line 103 "../src/data/sources/itch/ItchGame.vala"
						_tmp80_ = _tmp79_;
#line 103 "../src/data/sources/itch/ItchGame.vala"
						if (g_strcmp0 (_tmp77_, _tmp80_) == 0) {
#line 1627 "ItchGame.c"
							GeeArrayList* _tmp81_;
							GeeArrayList* _tmp82_;
							GameHubDataDBTablesTagsTag* _tmp83_;
#line 105 "../src/data/sources/itch/ItchGame.vala"
							_tmp81_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 105 "../src/data/sources/itch/ItchGame.vala"
							_tmp82_ = _tmp81_;
#line 105 "../src/data/sources/itch/ItchGame.vala"
							_tmp83_ = t;
#line 105 "../src/data/sources/itch/ItchGame.vala"
							if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp82_, _tmp83_)) {
#line 1639 "ItchGame.c"
								GeeArrayList* _tmp84_;
								GeeArrayList* _tmp85_;
								GameHubDataDBTablesTagsTag* _tmp86_;
#line 105 "../src/data/sources/itch/ItchGame.vala"
								_tmp84_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 105 "../src/data/sources/itch/ItchGame.vala"
								_tmp85_ = _tmp84_;
#line 105 "../src/data/sources/itch/ItchGame.vala"
								_tmp86_ = t;
#line 105 "../src/data/sources/itch/ItchGame.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp85_, _tmp86_);
#line 1651 "ItchGame.c"
							}
#line 106 "../src/data/sources/itch/ItchGame.vala"
							_g_object_unref0 (t);
#line 106 "../src/data/sources/itch/ItchGame.vala"
							break;
#line 1657 "ItchGame.c"
						}
#line 101 "../src/data/sources/itch/ItchGame.vala"
						_g_object_unref0 (t);
#line 1661 "ItchGame.c"
					}
				}
#line 99 "../src/data/sources/itch/ItchGame.vala"
				_g_free0 (tid);
#line 1666 "ItchGame.c"
			}
		}
	}
#line 111 "../src/data/sources/itch/ItchGame.vala"
	_tmp87_ = game_hub_data_game_get_info ((GameHubDataGame*) self);
#line 111 "../src/data/sources/itch/ItchGame.vala"
	_tmp88_ = _tmp87_;
#line 111 "../src/data/sources/itch/ItchGame.vala"
	_tmp89_ = game_hub_utils_parser_parse_json (_tmp88_);
#line 111 "../src/data/sources/itch/ItchGame.vala"
	info_root = _tmp89_;
#line 112 "../src/data/sources/itch/ItchGame.vala"
	_tmp91_ = info_root;
#line 112 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp91_ != NULL) {
#line 1682 "ItchGame.c"
		JsonNode* _tmp92_;
#line 112 "../src/data/sources/itch/ItchGame.vala"
		_tmp92_ = info_root;
#line 112 "../src/data/sources/itch/ItchGame.vala"
		_tmp90_ = json_node_get_node_type (_tmp92_) == JSON_NODE_OBJECT;
#line 1688 "ItchGame.c"
	} else {
#line 112 "../src/data/sources/itch/ItchGame.vala"
		_tmp90_ = FALSE;
#line 1692 "ItchGame.c"
	}
#line 112 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp90_) {
#line 1696 "ItchGame.c"
		JsonObject* info_root_obj = NULL;
		JsonNode* _tmp93_;
		JsonObject* _tmp94_;
		JsonObject* _tmp95_;
		JsonObject* _tmp96_;
		const gchar* _tmp97_;
		JsonObject* _tmp98_;
		const gchar* _tmp99_;
#line 114 "../src/data/sources/itch/ItchGame.vala"
		_tmp93_ = info_root;
#line 114 "../src/data/sources/itch/ItchGame.vala"
		_tmp94_ = json_node_get_object (_tmp93_);
#line 114 "../src/data/sources/itch/ItchGame.vala"
		_tmp95_ = _json_object_ref0 (_tmp94_);
#line 114 "../src/data/sources/itch/ItchGame.vala"
		info_root_obj = _tmp95_;
#line 115 "../src/data/sources/itch/ItchGame.vala"
		_tmp96_ = info_root_obj;
#line 115 "../src/data/sources/itch/ItchGame.vala"
		_tmp97_ = json_object_get_string_member (_tmp96_, "shortText");
#line 115 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_set_description ((GameHubDataGame*) self, _tmp97_);
#line 116 "../src/data/sources/itch/ItchGame.vala"
		_tmp98_ = info_root_obj;
#line 116 "../src/data/sources/itch/ItchGame.vala"
		_tmp99_ = json_object_get_string_member (_tmp98_, "url");
#line 116 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_set_store_page ((GameHubDataGame*) self, _tmp99_);
#line 112 "../src/data/sources/itch/ItchGame.vala"
		_json_object_unref0 (info_root_obj);
#line 1727 "ItchGame.c"
	}
#line 119 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	__vala_JsonNode_free0 (info_root);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	tag_ids = (_vala_array_free (tag_ids, tag_ids_length1, (GDestroyNotify) g_free), NULL);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp61_);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	pls = (_vala_array_free (pls, pls_length1, (GDestroyNotify) g_free), NULL);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_tmp18_);
#line 64 "../src/data/sources/itch/ItchGame.vala"
	return self;
#line 1743 "ItchGame.c"
}

GameHubDataSourcesItchItchGame*
game_hub_data_sources_itch_itch_game_new_from_db (GameHubDataSourcesItchItch* src,
                                                  sqlite3_stmt* s)
{
#line 64 "../src/data/sources/itch/ItchGame.vala"
	return game_hub_data_sources_itch_itch_game_construct_from_db (GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME, src, s);
#line 1752 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_update_game_info_data_free (gpointer _data)
{
	GameHubDataSourcesItchItchGameUpdateGameInfoData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_slice_free (GameHubDataSourcesItchItchGameUpdateGameInfoData, _data_);
#line 1764 "ItchGame.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 26 "../src/data/sources/itch/ItchGame.vala"
	return self ? g_object_ref (self) : NULL;
#line 1772 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_update_game_info (GameHubDataGame* base,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GameHubDataSourcesItchItchGame * self;
	GameHubDataSourcesItchItchGameUpdateGameInfoData* _data_;
	GameHubDataSourcesItchItchGame* _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) base;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesItchItchGameUpdateGameInfoData);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_itch_itch_game_real_update_game_info_data_free);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_real_update_game_info_co (_data_);
#line 1797 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_update_game_info_finish (GameHubDataGame* base,
                                                              GAsyncResult* _res_)
{
	GameHubDataSourcesItchItchGameUpdateGameInfoData* _data_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1807 "ItchGame.c"
}

static gboolean
game_hub_data_sources_itch_itch_game_real_update_game_info_co (GameHubDataSourcesItchItchGameUpdateGameInfoData* _data_)
{
#line 122 "../src/data/sources/itch/ItchGame.vala"
	switch (_data_->_state_) {
#line 122 "../src/data/sources/itch/ItchGame.vala"
		case 0:
#line 1817 "ItchGame.c"
		goto _state_0;
		default:
#line 122 "../src/data/sources/itch/ItchGame.vala"
		g_assert_not_reached ();
#line 1822 "ItchGame.c"
	}
	_state_0:
#line 124 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 122 "../src/data/sources/itch/ItchGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 122 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_state_ != 0) {
#line 122 "../src/data/sources/itch/ItchGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 122 "../src/data/sources/itch/ItchGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1835 "ItchGame.c"
		}
	}
#line 122 "../src/data/sources/itch/ItchGame.vala"
	g_object_unref (_data_->_async_result);
#line 122 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 1842 "ItchGame.c"
}

void
game_hub_data_sources_itch_itch_game_update_caves (GameHubDataSourcesItchItchGame* self,
                                                   GeeHashMap* caves_map)
{
	gint _tmp0_;
	gint _tmp1_;
	GameHubDataSourcesItchCave* cave = NULL;
	GameHubDataSourcesItchCave* _tmp6_;
	GameHubDataSourcesItchCave* _tmp7_;
	GameHubDataSourcesItchCave* _tmp8_;
#line 128 "../src/data/sources/itch/ItchGame.vala"
	g_return_if_fail (self != NULL);
#line 128 "../src/data/sources/itch/ItchGame.vala"
	g_return_if_fail (caves_map != NULL);
#line 130 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = game_hub_data_sources_itch_itch_game_get_int_id (self);
#line 130 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = _tmp0_;
#line 130 "../src/data/sources/itch/ItchGame.vala"
	if (gee_abstract_map_has_key ((GeeAbstractMap*) caves_map, (gpointer) ((gintptr) _tmp1_))) {
#line 1865 "ItchGame.c"
		gint _tmp2_;
		gint _tmp3_;
		gpointer _tmp4_;
#line 132 "../src/data/sources/itch/ItchGame.vala"
		_tmp2_ = game_hub_data_sources_itch_itch_game_get_int_id (self);
#line 132 "../src/data/sources/itch/ItchGame.vala"
		_tmp3_ = _tmp2_;
#line 132 "../src/data/sources/itch/ItchGame.vala"
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) caves_map, (gpointer) ((gintptr) _tmp3_));
#line 132 "../src/data/sources/itch/ItchGame.vala"
		_g_object_unref0 (self->priv->caves);
#line 132 "../src/data/sources/itch/ItchGame.vala"
		self->priv->caves = (GeeArrayList*) _tmp4_;
#line 1879 "ItchGame.c"
	} else {
		GeeArrayList* _tmp5_;
#line 136 "../src/data/sources/itch/ItchGame.vala"
		_tmp5_ = self->priv->caves;
#line 136 "../src/data/sources/itch/ItchGame.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
#line 1886 "ItchGame.c"
	}
#line 139 "../src/data/sources/itch/ItchGame.vala"
	_tmp6_ = game_hub_data_sources_itch_itch_game_get_cave (self);
#line 139 "../src/data/sources/itch/ItchGame.vala"
	_tmp7_ = _tmp6_;
#line 139 "../src/data/sources/itch/ItchGame.vala"
	cave = _tmp7_;
#line 140 "../src/data/sources/itch/ItchGame.vala"
	_tmp8_ = cave;
#line 140 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp8_ != NULL) {
#line 1898 "ItchGame.c"
		GameHubDataSourcesItchCave* _tmp9_;
		const gchar* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
#line 142 "../src/data/sources/itch/ItchGame.vala"
		_tmp9_ = cave;
#line 142 "../src/data/sources/itch/ItchGame.vala"
		_tmp10_ = _tmp9_->install_dir;
#line 142 "../src/data/sources/itch/ItchGame.vala"
		_tmp11_ = game_hub_utils_fs_utils_file (_tmp10_, NULL, NULL);
#line 142 "../src/data/sources/itch/ItchGame.vala"
		_tmp12_ = _tmp11_;
#line 142 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) self, _tmp12_);
#line 142 "../src/data/sources/itch/ItchGame.vala"
		_g_object_unref0 (_tmp12_);
#line 1915 "ItchGame.c"
	}
#line 145 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 128 "../src/data/sources/itch/ItchGame.vala"
	_game_hub_data_sources_itch_cave_unref0 (cave);
#line 1921 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_update_status (GameHubDataRunnable* base)
{
	GameHubDataSourcesItchItchGame * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GameHubDataGameStatus* _tmp4_;
	GameHubDataGameStatus* _tmp5_;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GameHubDataGameStatus* _tmp31_;
	GameHubDataGameStatus* _tmp32_;
#line 169 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) base;
#line 171 "../src/data/sources/itch/ItchGame.vala"
	_tmp4_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 171 "../src/data/sources/itch/ItchGame.vala"
	_tmp5_ = _tmp4_;
#line 171 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp5_->state == GAME_HUB_DATA_GAME_STATE_DOWNLOADING) {
#line 1947 "ItchGame.c"
		GameHubDataGameStatus* _tmp6_;
		GameHubDataGameStatus* _tmp7_;
		GameHubUtilsDownloaderDownload* _tmp8_;
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp6_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp7_ = _tmp6_;
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp8_ = _tmp7_->download;
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp3_ = _tmp8_ != NULL;
#line 1959 "ItchGame.c"
	} else {
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp3_ = FALSE;
#line 1963 "ItchGame.c"
	}
#line 171 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp3_) {
#line 1967 "ItchGame.c"
		GameHubDataGameStatus* _tmp9_;
		GameHubDataGameStatus* _tmp10_;
		GameHubUtilsDownloaderDownload* _tmp11_;
		GameHubUtilsDownloaderDownloadStatus* _tmp12_;
		GameHubUtilsDownloaderDownloadStatus* _tmp13_;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp9_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp10_ = _tmp9_;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp11_ = _tmp10_->download;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp12_ = game_hub_utils_downloader_download_get_status (_tmp11_);
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp13_ = _tmp12_;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp2_ = _tmp13_ != NULL;
#line 1985 "ItchGame.c"
	} else {
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp2_ = FALSE;
#line 1989 "ItchGame.c"
	}
#line 171 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp2_) {
#line 1993 "ItchGame.c"
		GameHubDataGameStatus* _tmp14_;
		GameHubDataGameStatus* _tmp15_;
		GameHubUtilsDownloaderDownload* _tmp16_;
		GameHubUtilsDownloaderDownloadStatus* _tmp17_;
		GameHubUtilsDownloaderDownloadStatus* _tmp18_;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp14_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp15_ = _tmp14_;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp16_ = _tmp15_->download;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp17_ = game_hub_utils_downloader_download_get_status (_tmp16_);
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp18_ = _tmp17_;
#line 172 "../src/data/sources/itch/ItchGame.vala"
		_tmp1_ = _tmp18_->state != GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_CANCELLED;
#line 2011 "ItchGame.c"
	} else {
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp1_ = FALSE;
#line 2015 "ItchGame.c"
	}
#line 171 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp1_) {
#line 2019 "ItchGame.c"
		GameHubDataGameStatus* _tmp19_;
		GameHubDataGameStatus* _tmp20_;
		GameHubUtilsDownloaderDownload* _tmp21_;
		GameHubUtilsDownloaderDownloadStatus* _tmp22_;
		GameHubUtilsDownloaderDownloadStatus* _tmp23_;
#line 173 "../src/data/sources/itch/ItchGame.vala"
		_tmp19_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 173 "../src/data/sources/itch/ItchGame.vala"
		_tmp20_ = _tmp19_;
#line 173 "../src/data/sources/itch/ItchGame.vala"
		_tmp21_ = _tmp20_->download;
#line 173 "../src/data/sources/itch/ItchGame.vala"
		_tmp22_ = game_hub_utils_downloader_download_get_status (_tmp21_);
#line 173 "../src/data/sources/itch/ItchGame.vala"
		_tmp23_ = _tmp22_;
#line 173 "../src/data/sources/itch/ItchGame.vala"
		_tmp0_ = _tmp23_->state != GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_FINISHED;
#line 2037 "ItchGame.c"
	} else {
#line 171 "../src/data/sources/itch/ItchGame.vala"
		_tmp0_ = FALSE;
#line 2041 "ItchGame.c"
	}
#line 171 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp0_) {
#line 173 "../src/data/sources/itch/ItchGame.vala"
		return;
#line 2047 "ItchGame.c"
	}
#line 175 "../src/data/sources/itch/ItchGame.vala"
	_tmp24_ = self->priv->caves;
#line 175 "../src/data/sources/itch/ItchGame.vala"
	_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
#line 175 "../src/data/sources/itch/ItchGame.vala"
	_tmp26_ = _tmp25_;
#line 175 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp26_ > 0) {
#line 2057 "ItchGame.c"
		GameHubDataGameStatus* _tmp27_;
		GameHubDataGameStatus* _tmp28_;
#line 177 "../src/data/sources/itch/ItchGame.vala"
		_tmp27_ = game_hub_data_game_status_new (GAME_HUB_DATA_GAME_STATE_INSTALLED, (GameHubDataGame*) self, NULL);
#line 177 "../src/data/sources/itch/ItchGame.vala"
		_tmp28_ = _tmp27_;
#line 177 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_set_status ((GameHubDataGame*) self, _tmp28_);
#line 177 "../src/data/sources/itch/ItchGame.vala"
		_game_hub_data_game_status_unref0 (_tmp28_);
#line 2068 "ItchGame.c"
	} else {
		GameHubDataGameStatus* _tmp29_;
		GameHubDataGameStatus* _tmp30_;
#line 181 "../src/data/sources/itch/ItchGame.vala"
		_tmp29_ = game_hub_data_game_status_new (GAME_HUB_DATA_GAME_STATE_UNINSTALLED, (GameHubDataGame*) self, NULL);
#line 181 "../src/data/sources/itch/ItchGame.vala"
		_tmp30_ = _tmp29_;
#line 181 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_set_status ((GameHubDataGame*) self, _tmp30_);
#line 181 "../src/data/sources/itch/ItchGame.vala"
		_game_hub_data_game_status_unref0 (_tmp30_);
#line 2080 "ItchGame.c"
	}
#line 184 "../src/data/sources/itch/ItchGame.vala"
	_tmp31_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 184 "../src/data/sources/itch/ItchGame.vala"
	_tmp32_ = _tmp31_;
#line 184 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp32_->state == GAME_HUB_DATA_GAME_STATE_INSTALLED) {
#line 2088 "ItchGame.c"
		GameHubDataDBTablesTagsTag* _tmp33_;
		GameHubDataDBTablesTagsTag* _tmp34_;
#line 186 "../src/data/sources/itch/ItchGame.vala"
		_tmp33_ = game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
#line 186 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_remove_tag ((GameHubDataGame*) self, _tmp33_);
#line 187 "../src/data/sources/itch/ItchGame.vala"
		_tmp34_ = game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
#line 187 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_add_tag ((GameHubDataGame*) self, _tmp34_);
#line 2099 "ItchGame.c"
	} else {
		GameHubDataDBTablesTagsTag* _tmp35_;
		GameHubDataDBTablesTagsTag* _tmp36_;
#line 191 "../src/data/sources/itch/ItchGame.vala"
		_tmp35_ = game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
#line 191 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_add_tag ((GameHubDataGame*) self, _tmp35_);
#line 192 "../src/data/sources/itch/ItchGame.vala"
		_tmp36_ = game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
#line 192 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_remove_tag ((GameHubDataGame*) self, _tmp36_);
#line 2111 "ItchGame.c"
	}
}

static void
game_hub_data_sources_itch_itch_game_real_install_data_free (gpointer _data)
{
	GameHubDataSourcesItchItchGameInstallData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_slice_free (GameHubDataSourcesItchItchGameInstallData, _data_);
#line 2124 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_install (GameHubDataRunnable* base,
                                                   GameHubDataRunnableInstallerInstallMode install_mode,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GameHubDataSourcesItchItchGame * self;
	GameHubDataSourcesItchItchGameInstallData* _data_;
	GameHubDataSourcesItchItchGame* _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) base;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesItchItchGameInstallData);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_itch_itch_game_real_install_data_free);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->install_mode = install_mode;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_real_install_co (_data_);
#line 2152 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_install_finish (GameHubDataRunnable* base,
                                                     GAsyncResult* _res_)
{
	GameHubDataSourcesItchItchGameInstallData* _data_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2162 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_install_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GameHubDataSourcesItchItchGameInstallData* _data_;
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_ = _user_data_;
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_->_source_object_ = source_object;
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_->_res_ = _res_;
#line 198 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_real_install_co (_data_);
#line 2179 "ItchGame.c"
}

static gboolean
_game_hub_data_sources_itch_itch_game_real_install_co_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hub_data_sources_itch_itch_game_real_install_co (self);
#line 233 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 2189 "ItchGame.c"
}

static gboolean
game_hub_data_sources_itch_itch_game_real_install_co (GameHubDataSourcesItchItchGameInstallData* _data_)
{
#line 196 "../src/data/sources/itch/ItchGame.vala"
	switch (_data_->_state_) {
#line 196 "../src/data/sources/itch/ItchGame.vala"
		case 0:
#line 2199 "ItchGame.c"
		goto _state_0;
#line 196 "../src/data/sources/itch/ItchGame.vala"
		case 1:
#line 2203 "ItchGame.c"
		goto _state_1;
#line 196 "../src/data/sources/itch/ItchGame.vala"
		case 2:
#line 2207 "ItchGame.c"
		goto _state_2;
		default:
#line 196 "../src/data/sources/itch/ItchGame.vala"
		g_assert_not_reached ();
#line 2212 "ItchGame.c"
	}
	_state_0:
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp0_ = game_hub_data_game_get_source ((GameHubDataGame*) _data_->self);
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_->_state_ = 1;
#line 198 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_get_game_uploads (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch), _data_->self, game_hub_data_sources_itch_itch_game_install_ready, _data_);
#line 198 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 2225 "ItchGame.c"
	_state_1:
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp2_ = game_hub_data_sources_itch_itch_get_game_uploads_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch), _data_->_res_);
#line 198 "../src/data/sources/itch/ItchGame.vala"
	_data_->uploads = _data_->_tmp2_;
#line 200 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp4_ = _data_->uploads;
#line 200 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_tmp4_ == NULL) {
#line 200 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp3_ = TRUE;
#line 2237 "ItchGame.c"
	} else {
#line 200 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp5_ = _data_->uploads;
#line 200 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp5_);
#line 200 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 200 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp3_ = _data_->_tmp7_ == 0;
#line 2247 "ItchGame.c"
	}
#line 200 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_tmp3_) {
#line 202 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_set_is_installable ((GameHubDataGame*) _data_->self, FALSE);
#line 203 "../src/data/sources/itch/ItchGame.vala"
		_g_object_unref0 (_data_->uploads);
#line 203 "../src/data/sources/itch/ItchGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 203 "../src/data/sources/itch/ItchGame.vala"
		if (_data_->_state_ != 0) {
#line 203 "../src/data/sources/itch/ItchGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 203 "../src/data/sources/itch/ItchGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2263 "ItchGame.c"
			}
		}
#line 203 "../src/data/sources/itch/ItchGame.vala"
		g_object_unref (_data_->_async_result);
#line 203 "../src/data/sources/itch/ItchGame.vala"
		return FALSE;
#line 2270 "ItchGame.c"
	}
#line 206 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp8_ = gee_array_list_new (GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, (GBoxedCopyFunc) game_hub_data_runnable_installer_ref, (GDestroyNotify) game_hub_data_runnable_installer_unref, NULL, NULL, NULL);
#line 206 "../src/data/sources/itch/ItchGame.vala"
	_data_->installers = _data_->_tmp8_;
#line 2276 "ItchGame.c"
	{
#line 208 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp9_ = _data_->uploads;
#line 208 "../src/data/sources/itch/ItchGame.vala"
		_data_->_upload_list = _data_->_tmp9_;
#line 208 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp10_ = _data_->_upload_list;
#line 208 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp10_);
#line 208 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 208 "../src/data/sources/itch/ItchGame.vala"
		_data_->_upload_size = _data_->_tmp12_;
#line 208 "../src/data/sources/itch/ItchGame.vala"
		_data_->_upload_index = -1;
#line 208 "../src/data/sources/itch/ItchGame.vala"
		while (TRUE) {
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_data_->_upload_index = _data_->_upload_index + 1;
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp13_ = _data_->_upload_index;
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp14_ = _data_->_upload_size;
#line 208 "../src/data/sources/itch/ItchGame.vala"
			if (!(_data_->_tmp13_ < _data_->_tmp14_)) {
#line 208 "../src/data/sources/itch/ItchGame.vala"
				break;
#line 2304 "ItchGame.c"
			}
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp15_ = _data_->_upload_list;
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp15_, _data_->_upload_index);
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_data_->upload = (JsonObject*) _data_->_tmp16_;
#line 210 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp17_ = gee_array_list_new (GAME_HUB_DATA_TYPE_PLATFORM, NULL, NULL, NULL, NULL, NULL);
#line 210 "../src/data/sources/itch/ItchGame.vala"
			_data_->platforms = _data_->_tmp17_;
#line 211 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp18_ = _data_->upload;
#line 211 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp19_ = json_object_get_object_member (_data_->_tmp18_, "platforms");
#line 211 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp20_ = _json_object_ref0 (_data_->_tmp19_);
#line 211 "../src/data/sources/itch/ItchGame.vala"
			_data_->platforms_obj = _data_->_tmp20_;
#line 212 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp21_ = _data_->platforms_obj;
#line 212 "../src/data/sources/itch/ItchGame.vala"
			if (json_object_has_member (_data_->_tmp21_, "windows")) {
#line 214 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp22_ = _data_->platforms;
#line 214 "../src/data/sources/itch/ItchGame.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp22_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_WINDOWS));
#line 2332 "ItchGame.c"
			}
#line 216 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp23_ = _data_->platforms_obj;
#line 216 "../src/data/sources/itch/ItchGame.vala"
			if (json_object_has_member (_data_->_tmp23_, "linux")) {
#line 218 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp24_ = _data_->platforms;
#line 218 "../src/data/sources/itch/ItchGame.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp24_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_LINUX));
#line 2342 "ItchGame.c"
			}
#line 220 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp25_ = _data_->platforms_obj;
#line 220 "../src/data/sources/itch/ItchGame.vala"
			if (json_object_has_member (_data_->_tmp25_, "osx")) {
#line 222 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp26_ = _data_->platforms;
#line 222 "../src/data/sources/itch/ItchGame.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp26_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_MACOS));
#line 2352 "ItchGame.c"
			}
#line 225 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp27_ = _data_->platforms;
#line 225 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp27_);
#line 225 "../src/data/sources/itch/ItchGame.vala"
			_data_->_tmp29_ = _data_->_tmp28_;
#line 225 "../src/data/sources/itch/ItchGame.vala"
			if (_data_->_tmp29_ == 0) {
#line 225 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp30_ = _data_->platforms;
#line 225 "../src/data/sources/itch/ItchGame.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp30_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_CURRENT));
#line 2366 "ItchGame.c"
			}
			{
#line 227 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp31_ = _data_->platforms;
#line 227 "../src/data/sources/itch/ItchGame.vala"
				_data_->_platform_list = _data_->_tmp31_;
#line 227 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp32_ = _data_->_platform_list;
#line 227 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp32_);
#line 227 "../src/data/sources/itch/ItchGame.vala"
				_data_->_tmp34_ = _data_->_tmp33_;
#line 227 "../src/data/sources/itch/ItchGame.vala"
				_data_->_platform_size = _data_->_tmp34_;
#line 227 "../src/data/sources/itch/ItchGame.vala"
				_data_->_platform_index = -1;
#line 227 "../src/data/sources/itch/ItchGame.vala"
				while (TRUE) {
#line 227 "../src/data/sources/itch/ItchGame.vala"
					_data_->_platform_index = _data_->_platform_index + 1;
#line 227 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp35_ = _data_->_platform_index;
#line 227 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp36_ = _data_->_platform_size;
#line 227 "../src/data/sources/itch/ItchGame.vala"
					if (!(_data_->_tmp35_ < _data_->_tmp36_)) {
#line 227 "../src/data/sources/itch/ItchGame.vala"
						break;
#line 2395 "ItchGame.c"
					}
#line 227 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp37_ = _data_->_platform_list;
#line 227 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp37_, _data_->_platform_index);
#line 227 "../src/data/sources/itch/ItchGame.vala"
					_data_->platform = (GameHubDataPlatform) ((gintptr) _data_->_tmp38_);
#line 229 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp39_ = _data_->installers;
#line 229 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp40_ = _data_->upload;
#line 229 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp41_ = game_hub_data_sources_itch_itch_game_installer_new (_data_->self, _data_->_tmp40_, _data_->platform);
#line 229 "../src/data/sources/itch/ItchGame.vala"
					_data_->_tmp42_ = _data_->_tmp41_;
#line 229 "../src/data/sources/itch/ItchGame.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp39_, (GameHubDataRunnableInstaller*) _data_->_tmp42_);
#line 229 "../src/data/sources/itch/ItchGame.vala"
					_game_hub_data_runnable_installer_unref0 (_data_->_tmp42_);
#line 2415 "ItchGame.c"
				}
			}
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_json_object_unref0 (_data_->platforms_obj);
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_g_object_unref0 (_data_->platforms);
#line 208 "../src/data/sources/itch/ItchGame.vala"
			_json_object_unref0 (_data_->upload);
#line 2424 "ItchGame.c"
		}
	}
#line 233 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp43_ = _data_->installers;
#line 233 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp44_ = game_hub_ui_dialogs_install_dialog_new ((GameHubDataRunnable*) _data_->self, _data_->_tmp43_, _data_->install_mode, _game_hub_data_sources_itch_itch_game_real_install_co_gsource_func, _data_, NULL);
#line 233 "../src/data/sources/itch/ItchGame.vala"
	g_object_ref_sink (_data_->_tmp44_);
#line 233 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp45_ = _data_->_tmp44_;
#line 233 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->_tmp45_);
#line 234 "../src/data/sources/itch/ItchGame.vala"
	_data_->_state_ = 2;
#line 234 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 2441 "ItchGame.c"
	_state_2:
	;
#line 196 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->installers);
#line 196 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->uploads);
#line 196 "../src/data/sources/itch/ItchGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 196 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_state_ != 0) {
#line 196 "../src/data/sources/itch/ItchGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 196 "../src/data/sources/itch/ItchGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2456 "ItchGame.c"
		}
	}
#line 196 "../src/data/sources/itch/ItchGame.vala"
	g_object_unref (_data_->_async_result);
#line 196 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 2463 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_run_data_free (gpointer _data)
{
	GameHubDataSourcesItchItchGameRunData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_slice_free (GameHubDataSourcesItchItchGameRunData, _data_);
#line 2475 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_run (GameHubDataRunnable* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GameHubDataSourcesItchItchGame * self;
	GameHubDataSourcesItchItchGameRunData* _data_;
	GameHubDataSourcesItchItchGame* _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) base;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesItchItchGameRunData);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_itch_itch_game_real_run_data_free);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_real_run_co (_data_);
#line 2500 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_run_finish (GameHubDataRunnable* base,
                                                 GAsyncResult* _res_)
{
	GameHubDataSourcesItchItchGameRunData* _data_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2510 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_run_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GameHubDataSourcesItchItchGameRunData* _data_;
#line 247 "../src/data/sources/itch/ItchGame.vala"
	_data_ = _user_data_;
#line 247 "../src/data/sources/itch/ItchGame.vala"
	_data_->_source_object_ = source_object;
#line 247 "../src/data/sources/itch/ItchGame.vala"
	_data_->_res_ = _res_;
#line 247 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_real_run_co (_data_);
#line 2527 "ItchGame.c"
}

static gboolean
___lambda121_ (GameHubDataSourcesItchItchGame* self)
{
	gboolean result;
#line 253 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) self, FALSE);
#line 253 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_IsLaunched = FALSE;
#line 254 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 255 "../src/data/sources/itch/ItchGame.vala"
	result = G_SOURCE_REMOVE;
#line 255 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 2544 "ItchGame.c"
}

static gboolean
____lambda121__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda121_ ((GameHubDataSourcesItchItchGame*) self);
#line 252 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 2554 "ItchGame.c"
}

static gboolean
game_hub_data_sources_itch_itch_game_real_run_co (GameHubDataSourcesItchItchGameRunData* _data_)
{
#line 237 "../src/data/sources/itch/ItchGame.vala"
	switch (_data_->_state_) {
#line 237 "../src/data/sources/itch/ItchGame.vala"
		case 0:
#line 2564 "ItchGame.c"
		goto _state_0;
#line 237 "../src/data/sources/itch/ItchGame.vala"
		case 1:
#line 2568 "ItchGame.c"
		goto _state_1;
		default:
#line 237 "../src/data/sources/itch/ItchGame.vala"
		g_assert_not_reached ();
#line 2573 "ItchGame.c"
	}
	_state_0:
#line 239 "../src/data/sources/itch/ItchGame.vala"
	if (game_hub_data_runnable_can_be_launched ((GameHubDataRunnable*) _data_->self, TRUE)) {
#line 241 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) _data_->self, TRUE);
#line 241 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_runnable_IsLaunched = TRUE;
#line 242 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 244 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_set_last_launch ((GameHubDataGame*) _data_->self, g_get_real_time () / 1000000);
#line 245 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 247 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp0_ = game_hub_data_game_get_source ((GameHubDataGame*) _data_->self);
#line 247 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp1_ = _data_->_tmp0_;
#line 247 "../src/data/sources/itch/ItchGame.vala"
		_data_->_state_ = 1;
#line 247 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_sources_itch_itch_run_game (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch), _data_->self, game_hub_data_sources_itch_itch_game_run_ready, _data_);
#line 247 "../src/data/sources/itch/ItchGame.vala"
		return FALSE;
#line 2598 "ItchGame.c"
		_state_1:
#line 247 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_sources_itch_itch_run_game_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch), _data_->_res_);
#line 249 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp2_ = game_hub_data_game_get_playtime_tracked ((GameHubDataGame*) _data_->self);
#line 249 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 249 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp4_ = game_hub_data_game_get_last_launch ((GameHubDataGame*) _data_->self);
#line 249 "../src/data/sources/itch/ItchGame.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 249 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_game_set_playtime_tracked ((GameHubDataGame*) _data_->self, _data_->_tmp3_ + (((g_get_real_time () / 1000000) - _data_->_tmp5_) / 60));
#line 250 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 252 "../src/data/sources/itch/ItchGame.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda121__gsource_func, g_object_ref (_data_->self), g_object_unref);
#line 2616 "ItchGame.c"
	}
#line 237 "../src/data/sources/itch/ItchGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 237 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_state_ != 0) {
#line 237 "../src/data/sources/itch/ItchGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 237 "../src/data/sources/itch/ItchGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2626 "ItchGame.c"
		}
	}
#line 237 "../src/data/sources/itch/ItchGame.vala"
	g_object_unref (_data_->_async_result);
#line 237 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 2633 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_run_with_compat_data_free (gpointer _data)
{
	GameHubDataSourcesItchItchGameRunWithCompatData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_slice_free (GameHubDataSourcesItchItchGameRunWithCompatData, _data_);
#line 2645 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_run_with_compat (GameHubDataRunnable* base,
                                                           gboolean is_opened_from_menu,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	GameHubDataSourcesItchItchGame * self;
	GameHubDataSourcesItchItchGameRunWithCompatData* _data_;
	GameHubDataSourcesItchItchGame* _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) base;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesItchItchGameRunWithCompatData);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_itch_itch_game_real_run_with_compat_data_free);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->is_opened_from_menu = is_opened_from_menu;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_real_run_with_compat_co (_data_);
#line 2673 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_run_with_compat_finish (GameHubDataRunnable* base,
                                                             GAsyncResult* _res_)
{
	GameHubDataSourcesItchItchGameRunWithCompatData* _data_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2683 "ItchGame.c"
}

static gboolean
game_hub_data_sources_itch_itch_game_real_run_with_compat_co (GameHubDataSourcesItchItchGameRunWithCompatData* _data_)
{
#line 260 "../src/data/sources/itch/ItchGame.vala"
	switch (_data_->_state_) {
#line 260 "../src/data/sources/itch/ItchGame.vala"
		case 0:
#line 2693 "ItchGame.c"
		goto _state_0;
		default:
#line 260 "../src/data/sources/itch/ItchGame.vala"
		g_assert_not_reached ();
#line 2698 "ItchGame.c"
	}
	_state_0:
#line 260 "../src/data/sources/itch/ItchGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 260 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_state_ != 0) {
#line 260 "../src/data/sources/itch/ItchGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 260 "../src/data/sources/itch/ItchGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2709 "ItchGame.c"
		}
	}
#line 260 "../src/data/sources/itch/ItchGame.vala"
	g_object_unref (_data_->_async_result);
#line 260 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 2716 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_uninstall_data_free (gpointer _data)
{
	GameHubDataSourcesItchItchGameUninstallData* _data_;
	_data_ = _data;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_slice_free (GameHubDataSourcesItchItchGameUninstallData, _data_);
#line 2728 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_real_uninstall (GameHubDataGame* base,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GameHubDataSourcesItchItchGame * self;
	GameHubDataSourcesItchItchGameUninstallData* _data_;
	GameHubDataSourcesItchItchGame* _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGame*) base;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesItchItchGameUninstallData);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_itch_itch_game_real_uninstall_data_free);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_->self = _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_real_uninstall_co (_data_);
#line 2753 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_uninstall_finish (GameHubDataGame* base,
                                                       GAsyncResult* _res_)
{
	GameHubDataSourcesItchItchGameUninstallData* _data_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2763 "ItchGame.c"
}

static gboolean
game_hub_data_sources_itch_itch_game_real_uninstall_co (GameHubDataSourcesItchItchGameUninstallData* _data_)
{
#line 264 "../src/data/sources/itch/ItchGame.vala"
	switch (_data_->_state_) {
#line 264 "../src/data/sources/itch/ItchGame.vala"
		case 0:
#line 2773 "ItchGame.c"
		goto _state_0;
		default:
#line 264 "../src/data/sources/itch/ItchGame.vala"
		g_assert_not_reached ();
#line 2778 "ItchGame.c"
	}
	_state_0:
#line 266 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp0_ = game_hub_data_game_get_source ((GameHubDataGame*) _data_->self);
#line 266 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 266 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_uninstall_game (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch), _data_->self, NULL, NULL);
#line 264 "../src/data/sources/itch/ItchGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 264 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_state_ != 0) {
#line 264 "../src/data/sources/itch/ItchGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 264 "../src/data/sources/itch/ItchGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2795 "ItchGame.c"
		}
	}
#line 264 "../src/data/sources/itch/ItchGame.vala"
	g_object_unref (_data_->_async_result);
#line 264 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 2802 "ItchGame.c"
}

gint
game_hub_data_sources_itch_itch_game_get_int_id (GameHubDataSourcesItchItchGame* self)
{
	gint result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 28 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 28 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 28 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = _tmp0_;
#line 28 "../src/data/sources/itch/ItchGame.vala"
	result = atoi (_tmp1_);
#line 28 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 2821 "ItchGame.c"
}

GameHubDataSourcesItchCave*
game_hub_data_sources_itch_itch_game_get_cave (GameHubDataSourcesItchItchGame* self)
{
	GameHubDataSourcesItchCave* result;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 150 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 152 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = self->priv->caves;
#line 152 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
#line 152 "../src/data/sources/itch/ItchGame.vala"
	_tmp2_ = _tmp1_;
#line 152 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp2_ > 0) {
#line 2841 "ItchGame.c"
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
#line 154 "../src/data/sources/itch/ItchGame.vala"
		_tmp3_ = self->priv->caves;
#line 154 "../src/data/sources/itch/ItchGame.vala"
		_tmp4_ = gee_list_first ((GeeList*) _tmp3_);
#line 154 "../src/data/sources/itch/ItchGame.vala"
		result = (GameHubDataSourcesItchCave*) _tmp4_;
#line 154 "../src/data/sources/itch/ItchGame.vala"
		return result;
#line 2852 "ItchGame.c"
	}
#line 156 "../src/data/sources/itch/ItchGame.vala"
	result = NULL;
#line 156 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 2858 "ItchGame.c"
}

const gchar*
game_hub_data_sources_itch_itch_game_get_cave_id (GameHubDataSourcesItchItchGame* self)
{
	const gchar* result;
	GameHubDataSourcesItchCave* cave = NULL;
	GameHubDataSourcesItchCave* _tmp0_;
	GameHubDataSourcesItchCave* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GameHubDataSourcesItchCave* _tmp3_;
#line 162 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 164 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = game_hub_data_sources_itch_itch_game_get_cave (self);
#line 164 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = _tmp0_;
#line 164 "../src/data/sources/itch/ItchGame.vala"
	cave = _tmp1_;
#line 165 "../src/data/sources/itch/ItchGame.vala"
	_tmp3_ = cave;
#line 165 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp3_ != NULL) {
#line 2882 "ItchGame.c"
		GameHubDataSourcesItchCave* _tmp4_;
		const gchar* _tmp5_;
#line 165 "../src/data/sources/itch/ItchGame.vala"
		_tmp4_ = cave;
#line 165 "../src/data/sources/itch/ItchGame.vala"
		_tmp5_ = _tmp4_->id;
#line 165 "../src/data/sources/itch/ItchGame.vala"
		_tmp2_ = _tmp5_;
#line 2891 "ItchGame.c"
	} else {
#line 165 "../src/data/sources/itch/ItchGame.vala"
		_tmp2_ = NULL;
#line 2895 "ItchGame.c"
	}
#line 165 "../src/data/sources/itch/ItchGame.vala"
	result = _tmp2_;
#line 165 "../src/data/sources/itch/ItchGame.vala"
	_game_hub_data_sources_itch_cave_unref0 (cave);
#line 165 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 2903 "ItchGame.c"
}

static inline gpointer
game_hub_data_sources_itch_itch_game_installer_get_instance_private (GameHubDataSourcesItchItchGameInstaller* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataSourcesItchItchGameInstaller_private_offset);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 2922 "ItchGame.c"
}

GameHubDataSourcesItchItchGameInstaller*
game_hub_data_sources_itch_itch_game_installer_construct (GType object_type,
                                                          GameHubDataSourcesItchItchGame* game,
                                                          JsonObject* json,
                                                          GameHubDataPlatform platform)
{
	GameHubDataSourcesItchItchGameInstaller* self = NULL;
	GameHubDataSourcesItchItchGame* _tmp0_;
	JsonObject* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_;
	gchar* _tmp22_;
	JsonObject* _tmp23_ = NULL;
	JsonObject* build_obj = NULL;
	JsonObject* _tmp25_;
	JsonObject* _tmp26_;
#line 282 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 282 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (json != NULL, NULL);
#line 282 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGameInstaller*) game_hub_data_runnable_installer_construct (object_type);
#line 284 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = _g_object_ref0 (game);
#line 284 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (self->game);
#line 284 "../src/data/sources/itch/ItchGame.vala"
	self->game = _tmp0_;
#line 285 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = _json_object_ref0 (json);
#line 285 "../src/data/sources/itch/ItchGame.vala"
	_json_object_unref0 (self->priv->json);
#line 285 "../src/data/sources/itch/ItchGame.vala"
	self->priv->json = _tmp1_;
#line 287 "../src/data/sources/itch/ItchGame.vala"
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, json_object_get_int_member (json, "id"));
#line 287 "../src/data/sources/itch/ItchGame.vala"
	_tmp3_ = _tmp2_;
#line 287 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_installer_set_id ((GameHubDataRunnableInstaller*) self, _tmp3_);
#line 287 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (_tmp3_);
#line 288 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_installer_set_platform ((GameHubDataRunnableInstaller*) self, platform);
#line 290 "../src/data/sources/itch/ItchGame.vala"
	if (json_object_has_member (json, "filename")) {
#line 2983 "ItchGame.c"
		const gchar* _tmp5_;
#line 290 "../src/data/sources/itch/ItchGame.vala"
		_tmp5_ = json_object_get_string_member (json, "filename");
#line 290 "../src/data/sources/itch/ItchGame.vala"
		_tmp4_ = _tmp5_;
#line 2989 "ItchGame.c"
	} else {
#line 290 "../src/data/sources/itch/ItchGame.vala"
		_tmp4_ = NULL;
#line 2993 "ItchGame.c"
	}
#line 290 "../src/data/sources/itch/ItchGame.vala"
	_tmp6_ = g_strdup (_tmp4_);
#line 290 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (self->file_name);
#line 290 "../src/data/sources/itch/ItchGame.vala"
	self->file_name = _tmp6_;
#line 291 "../src/data/sources/itch/ItchGame.vala"
	if (json_object_has_member (json, "displayName")) {
#line 3003 "ItchGame.c"
		const gchar* _tmp8_;
#line 291 "../src/data/sources/itch/ItchGame.vala"
		_tmp8_ = json_object_get_string_member (json, "displayName");
#line 291 "../src/data/sources/itch/ItchGame.vala"
		_tmp7_ = _tmp8_;
#line 3009 "ItchGame.c"
	} else {
#line 291 "../src/data/sources/itch/ItchGame.vala"
		_tmp7_ = NULL;
#line 3013 "ItchGame.c"
	}
#line 291 "../src/data/sources/itch/ItchGame.vala"
	_tmp9_ = g_strdup (_tmp7_);
#line 291 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (self->display_name);
#line 291 "../src/data/sources/itch/ItchGame.vala"
	self->display_name = _tmp9_;
#line 293 "../src/data/sources/itch/ItchGame.vala"
	_tmp10_ = self->file_name;
#line 293 "../src/data/sources/itch/ItchGame.vala"
	_tmp11_ = strlen (_tmp10_);
#line 293 "../src/data/sources/itch/ItchGame.vala"
	_tmp12_ = _tmp11_;
#line 293 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp12_ == 0) {
#line 293 "../src/data/sources/itch/ItchGame.vala"
		_g_free0 (self->file_name);
#line 293 "../src/data/sources/itch/ItchGame.vala"
		self->file_name = NULL;
#line 3033 "ItchGame.c"
	}
#line 294 "../src/data/sources/itch/ItchGame.vala"
	_tmp13_ = self->display_name;
#line 294 "../src/data/sources/itch/ItchGame.vala"
	_tmp14_ = strlen (_tmp13_);
#line 294 "../src/data/sources/itch/ItchGame.vala"
	_tmp15_ = _tmp14_;
#line 294 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp15_ == 0) {
#line 294 "../src/data/sources/itch/ItchGame.vala"
		_g_free0 (self->display_name);
#line 294 "../src/data/sources/itch/ItchGame.vala"
		self->display_name = NULL;
#line 3047 "ItchGame.c"
	}
#line 296 "../src/data/sources/itch/ItchGame.vala"
	_tmp17_ = self->display_name;
#line 296 "../src/data/sources/itch/ItchGame.vala"
	_tmp16_ = _tmp17_;
#line 296 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp16_ == NULL) {
#line 3055 "ItchGame.c"
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_;
#line 296 "../src/data/sources/itch/ItchGame.vala"
		_tmp19_ = self->file_name;
#line 296 "../src/data/sources/itch/ItchGame.vala"
		_tmp18_ = _tmp19_;
#line 296 "../src/data/sources/itch/ItchGame.vala"
		if (_tmp18_ == NULL) {
#line 3064 "ItchGame.c"
			const gchar* _tmp20_;
			const gchar* _tmp21_;
#line 296 "../src/data/sources/itch/ItchGame.vala"
			_tmp20_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) game);
#line 296 "../src/data/sources/itch/ItchGame.vala"
			_tmp21_ = _tmp20_;
#line 296 "../src/data/sources/itch/ItchGame.vala"
			_tmp18_ = _tmp21_;
#line 3073 "ItchGame.c"
		}
#line 296 "../src/data/sources/itch/ItchGame.vala"
		_tmp16_ = _tmp18_;
#line 3077 "ItchGame.c"
	}
#line 296 "../src/data/sources/itch/ItchGame.vala"
	_tmp22_ = g_strdup (_tmp16_);
#line 296 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (self->priv->_name);
#line 296 "../src/data/sources/itch/ItchGame.vala"
	self->priv->_name = _tmp22_;
#line 298 "../src/data/sources/itch/ItchGame.vala"
	if (json_object_has_member (json, "build")) {
#line 3087 "ItchGame.c"
		JsonObject* _tmp24_;
#line 298 "../src/data/sources/itch/ItchGame.vala"
		_tmp24_ = json_object_get_object_member (json, "build");
#line 298 "../src/data/sources/itch/ItchGame.vala"
		_tmp23_ = _tmp24_;
#line 3093 "ItchGame.c"
	} else {
#line 298 "../src/data/sources/itch/ItchGame.vala"
		_tmp23_ = NULL;
#line 3097 "ItchGame.c"
	}
#line 298 "../src/data/sources/itch/ItchGame.vala"
	_tmp25_ = _json_object_ref0 (_tmp23_);
#line 298 "../src/data/sources/itch/ItchGame.vala"
	build_obj = _tmp25_;
#line 299 "../src/data/sources/itch/ItchGame.vala"
	_tmp26_ = build_obj;
#line 299 "../src/data/sources/itch/ItchGame.vala"
	if (_tmp26_ != NULL) {
#line 3107 "ItchGame.c"
		const gchar* _tmp27_ = NULL;
		JsonObject* _tmp28_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
#line 301 "../src/data/sources/itch/ItchGame.vala"
		_tmp28_ = build_obj;
#line 301 "../src/data/sources/itch/ItchGame.vala"
		if (json_object_has_member (_tmp28_, "userVersion")) {
#line 3121 "ItchGame.c"
			JsonObject* _tmp29_;
			const gchar* _tmp30_;
#line 301 "../src/data/sources/itch/ItchGame.vala"
			_tmp29_ = build_obj;
#line 301 "../src/data/sources/itch/ItchGame.vala"
			_tmp30_ = json_object_get_string_member (_tmp29_, "userVersion");
#line 301 "../src/data/sources/itch/ItchGame.vala"
			_tmp27_ = _tmp30_;
#line 3130 "ItchGame.c"
		} else {
#line 301 "../src/data/sources/itch/ItchGame.vala"
			_tmp27_ = NULL;
#line 3134 "ItchGame.c"
		}
#line 301 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_runnable_installer_set_version ((GameHubDataRunnableInstaller*) self, _tmp27_);
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_tmp31_ = self->priv->_name;
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_tmp32_ = game_hub_data_runnable_installer_get_version ((GameHubDataRunnableInstaller*) self);
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_tmp33_ = _tmp32_;
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_tmp34_ = string_to_string (_tmp33_);
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_tmp35_ = g_strconcat (" (", _tmp34_, ")", NULL);
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_tmp36_ = _tmp35_;
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_tmp37_ = g_strconcat (_tmp31_, _tmp36_, NULL);
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_g_free0 (self->priv->_name);
#line 302 "../src/data/sources/itch/ItchGame.vala"
		self->priv->_name = _tmp37_;
#line 302 "../src/data/sources/itch/ItchGame.vala"
		_g_free0 (_tmp36_);
#line 3158 "ItchGame.c"
	}
#line 305 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_runnable_installer_set_full_size ((GameHubDataRunnableInstaller*) self, json_object_get_int_member (json, "size"));
#line 282 "../src/data/sources/itch/ItchGame.vala"
	_json_object_unref0 (build_obj);
#line 282 "../src/data/sources/itch/ItchGame.vala"
	return self;
#line 3166 "ItchGame.c"
}

GameHubDataSourcesItchItchGameInstaller*
game_hub_data_sources_itch_itch_game_installer_new (GameHubDataSourcesItchItchGame* game,
                                                    JsonObject* json,
                                                    GameHubDataPlatform platform)
{
#line 282 "../src/data/sources/itch/ItchGame.vala"
	return game_hub_data_sources_itch_itch_game_installer_construct (GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER, game, json, platform);
#line 3176 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_installer_real_install_data_free (gpointer _data)
{
	GameHubDataSourcesItchItchGameInstallerInstallData* _data_;
	_data_ = _data;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->runnable);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->tool);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_game_hub_data_runnable_installer_unref0 (_data_->self);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	g_slice_free (GameHubDataSourcesItchItchGameInstallerInstallData, _data_);
#line 3192 "ItchGame.c"
}

static gpointer
_game_hub_data_runnable_installer_ref0 (gpointer self)
{
#line 269 "../src/data/sources/itch/ItchGame.vala"
	return self ? game_hub_data_runnable_installer_ref (self) : NULL;
#line 3200 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_installer_real_install (GameHubDataRunnableInstaller* base,
                                                             GameHubDataRunnable* runnable,
                                                             GameHubDataCompatTool* tool,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	GameHubDataSourcesItchItchGameInstaller * self;
	GameHubDataSourcesItchItchGameInstallerInstallData* _data_;
	GameHubDataSourcesItchItchGameInstaller* _tmp0_;
	GameHubDataRunnable* _tmp1_;
	GameHubDataCompatTool* _tmp2_;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	g_return_if_fail (runnable != NULL);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGameInstaller*) base;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesItchItchGameInstallerInstallData);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_itch_itch_game_installer_real_install_data_free);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = _game_hub_data_runnable_installer_ref0 (self);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_data_->self = _tmp0_;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = _g_object_ref0 (runnable);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->runnable);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_data_->runnable = _tmp1_;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_tmp2_ = _g_object_ref0 (tool);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (_data_->tool);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_data_->tool = _tmp2_;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_installer_real_install_co (_data_);
#line 3243 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_installer_install_finish (GameHubDataRunnableInstaller* base,
                                                               GAsyncResult* _res_)
{
	GameHubDataSourcesItchItchGameInstallerInstallData* _data_;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3253 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_installer_install_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	GameHubDataSourcesItchItchGameInstallerInstallData* _data_;
#line 310 "../src/data/sources/itch/ItchGame.vala"
	_data_ = _user_data_;
#line 310 "../src/data/sources/itch/ItchGame.vala"
	_data_->_source_object_ = source_object;
#line 310 "../src/data/sources/itch/ItchGame.vala"
	_data_->_res_ = _res_;
#line 310 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_installer_real_install_co (_data_);
#line 3270 "ItchGame.c"
}

static gboolean
game_hub_data_sources_itch_itch_game_installer_real_install_co (GameHubDataSourcesItchItchGameInstallerInstallData* _data_)
{
#line 308 "../src/data/sources/itch/ItchGame.vala"
	switch (_data_->_state_) {
#line 308 "../src/data/sources/itch/ItchGame.vala"
		case 0:
#line 3280 "ItchGame.c"
		goto _state_0;
#line 308 "../src/data/sources/itch/ItchGame.vala"
		case 1:
#line 3284 "ItchGame.c"
		goto _state_1;
		default:
#line 308 "../src/data/sources/itch/ItchGame.vala"
		g_assert_not_reached ();
#line 3289 "ItchGame.c"
	}
	_state_0:
#line 310 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp0_ = _data_->self->game;
#line 310 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp1_ = game_hub_data_game_get_source ((GameHubDataGame*) _data_->_tmp0_);
#line 310 "../src/data/sources/itch/ItchGame.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 310 "../src/data/sources/itch/ItchGame.vala"
	_data_->_state_ = 1;
#line 310 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_install_game (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch), _data_->self, game_hub_data_sources_itch_itch_game_installer_install_ready, _data_);
#line 310 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 3304 "ItchGame.c"
	_state_1:
#line 310 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_install_game_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH, GameHubDataSourcesItchItch), _data_->_res_);
#line 308 "../src/data/sources/itch/ItchGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 308 "../src/data/sources/itch/ItchGame.vala"
	if (_data_->_state_ != 0) {
#line 308 "../src/data/sources/itch/ItchGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 308 "../src/data/sources/itch/ItchGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3316 "ItchGame.c"
		}
	}
#line 308 "../src/data/sources/itch/ItchGame.vala"
	g_object_unref (_data_->_async_result);
#line 308 "../src/data/sources/itch/ItchGame.vala"
	return FALSE;
#line 3323 "ItchGame.c"
}

gint
game_hub_data_sources_itch_itch_game_installer_get_int_id (GameHubDataSourcesItchItchGameInstaller* self)
{
	gint result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 271 "../src/data/sources/itch/ItchGame.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 271 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = game_hub_data_runnable_installer_get_id ((GameHubDataRunnableInstaller*) self);
#line 271 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = _tmp0_;
#line 271 "../src/data/sources/itch/ItchGame.vala"
	result = atoi (_tmp1_);
#line 271 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 3342 "ItchGame.c"
}

static gchar*
game_hub_data_sources_itch_itch_game_installer_real_get_name (GameHubDataRunnableInstaller* base)
{
	gchar* result;
	GameHubDataSourcesItchItchGameInstaller* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 280 "../src/data/sources/itch/ItchGame.vala"
	self = (GameHubDataSourcesItchItchGameInstaller*) base;
#line 280 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = self->priv->_name;
#line 280 "../src/data/sources/itch/ItchGame.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 280 "../src/data/sources/itch/ItchGame.vala"
	result = _tmp1_;
#line 280 "../src/data/sources/itch/ItchGame.vala"
	return result;
#line 3362 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_installer_class_init (GameHubDataSourcesItchItchGameInstallerClass * klass,
                                                           gpointer klass_data)
{
#line 269 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_installer_parent_class = g_type_class_peek_parent (klass);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableInstallerClass *) klass)->finalize = game_hub_data_sources_itch_itch_game_installer_finalize;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataSourcesItchItchGameInstaller_private_offset);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableInstallerClass *) klass)->install = (void (*) (GameHubDataRunnableInstaller*, GameHubDataRunnable*, GameHubDataCompatTool*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_itch_itch_game_installer_real_install;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableInstallerClass *) klass)->install_finish = (void (*) (GameHubDataRunnableInstaller*, GAsyncResult*)) game_hub_data_sources_itch_itch_game_installer_install_finish;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS (klass)->get_name = (gchar* (*) (GameHubDataRunnableInstaller*)) game_hub_data_sources_itch_itch_game_installer_real_get_name;
#line 3381 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_installer_instance_init (GameHubDataSourcesItchItchGameInstaller * self,
                                                              gpointer klass)
{
#line 269 "../src/data/sources/itch/ItchGame.vala"
	self->priv = game_hub_data_sources_itch_itch_game_installer_get_instance_private (self);
#line 3390 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_installer_finalize (GameHubDataRunnableInstaller * obj)
{
	GameHubDataSourcesItchItchGameInstaller * self;
#line 269 "../src/data/sources/itch/ItchGame.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_TYPE_INSTALLER, GameHubDataSourcesItchItchGameInstaller);
#line 273 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (self->game);
#line 274 "../src/data/sources/itch/ItchGame.vala"
	_json_object_unref0 (self->priv->json);
#line 276 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (self->display_name);
#line 277 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (self->file_name);
#line 279 "../src/data/sources/itch/ItchGame.vala"
	_g_free0 (self->priv->_name);
#line 269 "../src/data/sources/itch/ItchGame.vala"
	GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS (game_hub_data_sources_itch_itch_game_installer_parent_class)->finalize (obj);
#line 3411 "ItchGame.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_sources_itch_itch_game_installer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataSourcesItchItchGameInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_sources_itch_itch_game_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataSourcesItchItchGameInstaller), 0, (GInstanceInitFunc) game_hub_data_sources_itch_itch_game_installer_instance_init, NULL };
	GType game_hub_data_sources_itch_itch_game_installer_type_id;
	game_hub_data_sources_itch_itch_game_installer_type_id = g_type_register_static (GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, "GameHubDataSourcesItchItchGameInstaller", &g_define_type_info, 0);
	GameHubDataSourcesItchItchGameInstaller_private_offset = g_type_add_instance_private (game_hub_data_sources_itch_itch_game_installer_type_id, sizeof (GameHubDataSourcesItchItchGameInstallerPrivate));
	return game_hub_data_sources_itch_itch_game_installer_type_id;
}

GType
game_hub_data_sources_itch_itch_game_installer_get_type (void)
{
	static volatile gsize game_hub_data_sources_itch_itch_game_installer_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_sources_itch_itch_game_installer_type_id__once)) {
		GType game_hub_data_sources_itch_itch_game_installer_type_id;
		game_hub_data_sources_itch_itch_game_installer_type_id = game_hub_data_sources_itch_itch_game_installer_get_type_once ();
		g_once_init_leave (&game_hub_data_sources_itch_itch_game_installer_type_id__once, game_hub_data_sources_itch_itch_game_installer_type_id);
	}
	return game_hub_data_sources_itch_itch_game_installer_type_id__once;
}

static void
game_hub_data_sources_itch_itch_game_class_init (GameHubDataSourcesItchItchGameClass * klass,
                                                 gpointer klass_data)
{
#line 26 "../src/data/sources/itch/ItchGame.vala"
	game_hub_data_sources_itch_itch_game_parent_class = g_type_class_peek_parent (klass);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataSourcesItchItchGame_private_offset);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataGameClass *) klass)->update_game_info = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_itch_itch_game_real_update_game_info;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataGameClass *) klass)->update_game_info_finish = (void (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_sources_itch_itch_game_update_game_info_finish;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableClass *) klass)->update_status = (void (*) (GameHubDataRunnable*)) game_hub_data_sources_itch_itch_game_real_update_status;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableClass *) klass)->install = (void (*) (GameHubDataRunnable*, GameHubDataRunnableInstallerInstallMode, GAsyncReadyCallback, gpointer)) game_hub_data_sources_itch_itch_game_real_install;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableClass *) klass)->install_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_sources_itch_itch_game_install_finish;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableClass *) klass)->run = (void (*) (GameHubDataRunnable*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_itch_itch_game_real_run;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableClass *) klass)->run_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_sources_itch_itch_game_run_finish;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableClass *) klass)->run_with_compat = (void (*) (GameHubDataRunnable*, gboolean, GAsyncReadyCallback, gpointer)) game_hub_data_sources_itch_itch_game_real_run_with_compat;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataRunnableClass *) klass)->run_with_compat_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_sources_itch_itch_game_run_with_compat_finish;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataGameClass *) klass)->uninstall = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_itch_itch_game_real_uninstall;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	((GameHubDataGameClass *) klass)->uninstall_finish = (void (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_sources_itch_itch_game_uninstall_finish;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_data_sources_itch_itch_game_get_property;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_data_sources_itch_itch_game_finalize;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_INT_ID_PROPERTY, game_hub_data_sources_itch_itch_game_properties[GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_INT_ID_PROPERTY] = g_param_spec_int ("int-id", "int-id", "int-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_PROPERTY, game_hub_data_sources_itch_itch_game_properties[GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_PROPERTY] = game_hub_data_sources_itch_param_spec_cave ("cave", "cave", "cave", GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 26 "../src/data/sources/itch/ItchGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_ID_PROPERTY, game_hub_data_sources_itch_itch_game_properties[GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_ID_PROPERTY] = g_param_spec_string ("cave-id", "cave-id", "cave-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 3476 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_instance_init (GameHubDataSourcesItchItchGame * self,
                                                    gpointer klass)
{
	GeeArrayList* _tmp0_;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	self->priv = game_hub_data_sources_itch_itch_game_get_instance_private (self);
#line 127 "../src/data/sources/itch/ItchGame.vala"
	_tmp0_ = gee_array_list_new (GAME_HUB_DATA_SOURCES_ITCH_TYPE_CAVE, (GBoxedCopyFunc) game_hub_data_sources_itch_cave_ref, (GDestroyNotify) game_hub_data_sources_itch_cave_unref, NULL, NULL, NULL);
#line 127 "../src/data/sources/itch/ItchGame.vala"
	self->priv->caves = _tmp0_;
#line 3490 "ItchGame.c"
}

static void
game_hub_data_sources_itch_itch_game_finalize (GObject * obj)
{
	GameHubDataSourcesItchItchGame * self;
#line 26 "../src/data/sources/itch/ItchGame.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME, GameHubDataSourcesItchItchGame);
#line 127 "../src/data/sources/itch/ItchGame.vala"
	_g_object_unref0 (self->priv->caves);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	G_OBJECT_CLASS (game_hub_data_sources_itch_itch_game_parent_class)->finalize (obj);
#line 3503 "ItchGame.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_sources_itch_itch_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataSourcesItchItchGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_sources_itch_itch_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataSourcesItchItchGame), 0, (GInstanceInitFunc) game_hub_data_sources_itch_itch_game_instance_init, NULL };
	GType game_hub_data_sources_itch_itch_game_type_id;
	game_hub_data_sources_itch_itch_game_type_id = g_type_register_static (GAME_HUB_DATA_TYPE_GAME, "GameHubDataSourcesItchItchGame", &g_define_type_info, 0);
	GameHubDataSourcesItchItchGame_private_offset = g_type_add_instance_private (game_hub_data_sources_itch_itch_game_type_id, sizeof (GameHubDataSourcesItchItchGamePrivate));
	return game_hub_data_sources_itch_itch_game_type_id;
}

GType
game_hub_data_sources_itch_itch_game_get_type (void)
{
	static volatile gsize game_hub_data_sources_itch_itch_game_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_sources_itch_itch_game_type_id__once)) {
		GType game_hub_data_sources_itch_itch_game_type_id;
		game_hub_data_sources_itch_itch_game_type_id = game_hub_data_sources_itch_itch_game_get_type_once ();
		g_once_init_leave (&game_hub_data_sources_itch_itch_game_type_id__once, game_hub_data_sources_itch_itch_game_type_id);
	}
	return game_hub_data_sources_itch_itch_game_type_id__once;
}

static void
_vala_game_hub_data_sources_itch_itch_game_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	GameHubDataSourcesItchItchGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_SOURCES_ITCH_TYPE_ITCH_GAME, GameHubDataSourcesItchItchGame);
#line 26 "../src/data/sources/itch/ItchGame.vala"
	switch (property_id) {
#line 26 "../src/data/sources/itch/ItchGame.vala"
		case GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_INT_ID_PROPERTY:
#line 26 "../src/data/sources/itch/ItchGame.vala"
		g_value_set_int (value, game_hub_data_sources_itch_itch_game_get_int_id (self));
#line 26 "../src/data/sources/itch/ItchGame.vala"
		break;
#line 26 "../src/data/sources/itch/ItchGame.vala"
		case GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_PROPERTY:
#line 26 "../src/data/sources/itch/ItchGame.vala"
		game_hub_data_sources_itch_value_take_cave (value, game_hub_data_sources_itch_itch_game_get_cave (self));
#line 26 "../src/data/sources/itch/ItchGame.vala"
		break;
#line 26 "../src/data/sources/itch/ItchGame.vala"
		case GAME_HUB_DATA_SOURCES_ITCH_ITCH_GAME_CAVE_ID_PROPERTY:
#line 26 "../src/data/sources/itch/ItchGame.vala"
		g_value_set_string (value, game_hub_data_sources_itch_itch_game_get_cave_id (self));
#line 26 "../src/data/sources/itch/ItchGame.vala"
		break;
#line 3556 "ItchGame.c"
		default:
#line 26 "../src/data/sources/itch/ItchGame.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "../src/data/sources/itch/ItchGame.vala"
		break;
#line 3562 "ItchGame.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

