/* Trove.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Trove.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/HTMLtree.h>
#include <libxml/HTMLparser.h>
#include <libxml/xpath.h>
#include <libxml/tree.h>
#include <json-glib/json-glib.h>

#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_PAGE_URL "https://www.humblebundle.com/monthly/trove"
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_SIGN_URL "https://www.humblebundle.com/api/v1/user/download/sign"
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_FAKE_ORDER "humble-trove"
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_TROVE_INTRO_ID "trove_intro"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_DATA_TYPE_GAME_SOURCE (game_hub_data_game_source_get_type ())
#define GAME_HUB_DATA_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSource))
#define GAME_HUB_DATA_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))
#define GAME_HUB_DATA_IS_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_IS_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_GAME_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))

typedef struct _GameHubDataGameSource GameHubDataGameSource;
typedef struct _GameHubDataGameSourceClass GameHubDataGameSourceClass;
typedef struct _GameHubDataGameSourcePrivate GameHubDataGameSourcePrivate;
typedef void (*GameHubUtilsFutureResult2) (gconstpointer t, gconstpointer t2, gpointer user_data);

#define GAME_HUB_DATA_TYPE_RUNNABLE (game_hub_data_runnable_get_type ())
#define GAME_HUB_DATA_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnable))
#define GAME_HUB_DATA_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))
#define GAME_HUB_DATA_IS_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_IS_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_RUNNABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))

typedef struct _GameHubDataRunnable GameHubDataRunnable;
typedef struct _GameHubDataRunnableClass GameHubDataRunnableClass;

#define GAME_HUB_DATA_TYPE_GAME (game_hub_data_game_get_type ())
#define GAME_HUB_DATA_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGame))
#define GAME_HUB_DATA_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))
#define GAME_HUB_DATA_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))

typedef struct _GameHubDataGame GameHubDataGame;
typedef struct _GameHubDataGameClass GameHubDataGameClass;
typedef void (*GameHubUtilsFuture) (gpointer user_data);

#define GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE (game_hub_data_sources_humble_humble_get_type ())
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumble))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumbleClass))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumbleClass))

typedef struct _GameHubDataSourcesHumbleHumble GameHubDataSourcesHumbleHumble;
typedef struct _GameHubDataSourcesHumbleHumbleClass GameHubDataSourcesHumbleHumbleClass;
typedef struct _GameHubDataSourcesHumbleHumblePrivate GameHubDataSourcesHumbleHumblePrivate;

#define GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE (game_hub_data_sources_humble_trove_get_type ())
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE, GameHubDataSourcesHumbleTrove))
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE, GameHubDataSourcesHumbleTroveClass))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_TROVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_TROVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE, GameHubDataSourcesHumbleTroveClass))

typedef struct _GameHubDataSourcesHumbleTrove GameHubDataSourcesHumbleTrove;
typedef struct _GameHubDataSourcesHumbleTroveClass GameHubDataSourcesHumbleTroveClass;
typedef struct _GameHubDataSourcesHumbleTrovePrivate GameHubDataSourcesHumbleTrovePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _game_hub_data_game_source_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_game_source_unref (var), NULL)))
typedef struct _Block21Data Block21Data;
typedef enum  {
	GAME_HUB_DATA_PLATFORM_LINUX,
	GAME_HUB_DATA_PLATFORM_WINDOWS,
	GAME_HUB_DATA_PLATFORM_MACOS,
	GAME_HUB_DATA_PLATFORM_EMULATED
} GameHubDataPlatform;

#define GAME_HUB_DATA_TYPE_PLATFORM (game_hub_data_platform_get_type ())

#define GAME_HUB_SETTINGS_TYPE_SETTINGS_SCHEMA (game_hub_settings_settings_schema_get_type ())
#define GAME_HUB_SETTINGS_SETTINGS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_SETTINGS_TYPE_SETTINGS_SCHEMA, GameHubSettingsSettingsSchema))
#define GAME_HUB_SETTINGS_SETTINGS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_SETTINGS_TYPE_SETTINGS_SCHEMA, GameHubSettingsSettingsSchemaClass))
#define GAME_HUB_SETTINGS_IS_SETTINGS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_SETTINGS_TYPE_SETTINGS_SCHEMA))
#define GAME_HUB_SETTINGS_IS_SETTINGS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_SETTINGS_TYPE_SETTINGS_SCHEMA))
#define GAME_HUB_SETTINGS_SETTINGS_SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_SETTINGS_TYPE_SETTINGS_SCHEMA, GameHubSettingsSettingsSchemaClass))

typedef struct _GameHubSettingsSettingsSchema GameHubSettingsSettingsSchema;
typedef struct _GameHubSettingsSettingsSchemaClass GameHubSettingsSettingsSchemaClass;

#define GAME_HUB_SETTINGS_UI_TYPE_BEHAVIOR (game_hub_settings_ui_behavior_get_type ())
#define GAME_HUB_SETTINGS_UI_BEHAVIOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_SETTINGS_UI_TYPE_BEHAVIOR, GameHubSettingsUIBehavior))
#define GAME_HUB_SETTINGS_UI_BEHAVIOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_SETTINGS_UI_TYPE_BEHAVIOR, GameHubSettingsUIBehaviorClass))
#define GAME_HUB_SETTINGS_UI_IS_BEHAVIOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_SETTINGS_UI_TYPE_BEHAVIOR))
#define GAME_HUB_SETTINGS_UI_IS_BEHAVIOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_SETTINGS_UI_TYPE_BEHAVIOR))
#define GAME_HUB_SETTINGS_UI_BEHAVIOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_SETTINGS_UI_TYPE_BEHAVIOR, GameHubSettingsUIBehaviorClass))

typedef struct _GameHubSettingsUIBehavior GameHubSettingsUIBehavior;
typedef struct _GameHubSettingsUIBehaviorClass GameHubSettingsUIBehaviorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME (game_hub_data_sources_humble_humble_game_get_type ())
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGame))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGameClass))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGameClass))

typedef struct _GameHubDataSourcesHumbleHumbleGame GameHubDataSourcesHumbleHumbleGame;
typedef struct _GameHubDataSourcesHumbleHumbleGameClass GameHubDataSourcesHumbleHumbleGameClass;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
typedef struct _GameHubDataSourcesHumbleTroveLoadGamesData GameHubDataSourcesHumbleTroveLoadGamesData;

#define GAME_HUB_SETTINGS_AUTH_TYPE_HUMBLE (game_hub_settings_auth_humble_get_type ())
#define GAME_HUB_SETTINGS_AUTH_HUMBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_SETTINGS_AUTH_TYPE_HUMBLE, GameHubSettingsAuthHumble))
#define GAME_HUB_SETTINGS_AUTH_HUMBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_SETTINGS_AUTH_TYPE_HUMBLE, GameHubSettingsAuthHumbleClass))
#define GAME_HUB_SETTINGS_AUTH_IS_HUMBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_SETTINGS_AUTH_TYPE_HUMBLE))
#define GAME_HUB_SETTINGS_AUTH_IS_HUMBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_SETTINGS_AUTH_TYPE_HUMBLE))
#define GAME_HUB_SETTINGS_AUTH_HUMBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_SETTINGS_AUTH_TYPE_HUMBLE, GameHubSettingsAuthHumbleClass))

typedef struct _GameHubSettingsAuthHumble GameHubSettingsAuthHumble;
typedef struct _GameHubSettingsAuthHumbleClass GameHubSettingsAuthHumbleClass;

struct _GameHubDataGameSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameSourcePrivate * priv;
};

struct _GameHubDataGameSourceClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameSource *self);
	gboolean (*is_installed) (GameHubDataGameSource* self, gboolean refresh);
	void (*install) (GameHubDataGameSource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*install_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	void (*authenticate) (GameHubDataGameSource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*authenticate_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	gboolean (*is_authenticated) (GameHubDataGameSource* self);
	gboolean (*can_authenticate_automatically) (GameHubDataGameSource* self);
	void (*load_games) (GameHubDataGameSource* self, GameHubUtilsFutureResult2 game_loaded, gpointer game_loaded_target, GameHubUtilsFuture cache_loaded, gpointer cache_loaded_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeArrayList* (*load_games_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	const gchar* (*get_id) (GameHubDataGameSource* self);
	const gchar* (*get_name) (GameHubDataGameSource* self);
	gchar* (*get_name_from) (GameHubDataGameSource* self);
	const gchar* (*get_icon) (GameHubDataGameSource* self);
	gchar* (*get_auth_description) (GameHubDataGameSource* self);
	gboolean (*get_enabled) (GameHubDataGameSource* self);
	void (*set_enabled) (GameHubDataGameSource* self, gboolean value);
	GeeArrayList* (*get_games) (GameHubDataGameSource* self);
};

struct _GameHubDataSourcesHumbleHumble {
	GameHubDataGameSource parent_instance;
	GameHubDataSourcesHumbleHumblePrivate * priv;
	gchar* user_token;
};

struct _GameHubDataSourcesHumbleHumbleClass {
	GameHubDataGameSourceClass parent_class;
};

struct _GameHubDataSourcesHumbleTrove {
	GameHubDataSourcesHumbleHumble parent_instance;
	GameHubDataSourcesHumbleTrovePrivate * priv;
};

struct _GameHubDataSourcesHumbleTroveClass {
	GameHubDataSourcesHumbleHumbleClass parent_class;
};

struct _GameHubDataSourcesHumbleTrovePrivate {
	GeeArrayList* _games;
};

struct _Block21Data {
	int _ref_count_;
	GameHubDataSourcesHumbleTrove* self;
	GameHubUtilsFutureResult2 game_loaded;
	gpointer game_loaded_target;
	GameHubUtilsFuture cache_loaded;
	gpointer cache_loaded_target;
	gpointer _async_data_;
};

struct _GameHubDataSourcesHumbleTroveLoadGamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesHumbleTrove* self;
	GameHubUtilsFutureResult2 game_loaded;
	gpointer game_loaded_target;
	GameHubUtilsFuture cache_loaded;
	gpointer cache_loaded_target;
	GeeArrayList* result;
	Block21Data* _data21_;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
};

static gint GameHubDataSourcesHumbleTrove_private_offset;
static gpointer game_hub_data_sources_humble_trove_parent_class = NULL;
VALA_EXTERN gboolean game_hub_application_log_verbose;

VALA_EXTERN gpointer game_hub_data_game_source_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_param_spec_game_source (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_value_set_game_source (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_value_take_game_source (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_value_get_game_source (const GValue* value);
VALA_EXTERN GType game_hub_data_game_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameSource, game_hub_data_game_source_unref)
VALA_EXTERN GType game_hub_data_runnable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnable, g_object_unref)
VALA_EXTERN GType game_hub_data_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGame, g_object_unref)
VALA_EXTERN GType game_hub_data_sources_humble_humble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesHumbleHumble, game_hub_data_game_source_unref)
VALA_EXTERN GType game_hub_data_sources_humble_trove_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesHumbleTrove, game_hub_data_game_source_unref)
VALA_EXTERN void game_hub_data_game_source_load_games (GameHubDataGameSource* self,
                                           GameHubUtilsFutureResult2 game_loaded,
                                           gpointer game_loaded_target,
                                           GameHubUtilsFuture cache_loaded,
                                           gpointer cache_loaded_target,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN GeeArrayList* game_hub_data_game_source_load_games_finish (GameHubDataGameSource* self,
                                                           GAsyncResult* _res_);
VALA_EXTERN const gchar* game_hub_data_game_source_get_id (GameHubDataGameSource* self);
VALA_EXTERN const gchar* game_hub_data_game_source_get_name (GameHubDataGameSource* self);
VALA_EXTERN const gchar* game_hub_data_game_source_get_icon (GameHubDataGameSource* self);
VALA_EXTERN gboolean game_hub_data_game_source_get_enabled (GameHubDataGameSource* self);
VALA_EXTERN void game_hub_data_game_source_set_enabled (GameHubDataGameSource* self,
                                            gboolean value);
VALA_EXTERN GeeArrayList* game_hub_data_game_source_get_games (GameHubDataGameSource* self);
VALA_EXTERN gboolean game_hub_data_game_is_equal (GameHubDataGame* first,
                                      GameHubDataGame* second);
static gboolean _game_hub_data_game_is_equal_gee_equal_data_func (gconstpointer a,
                                                           gconstpointer b,
                                                           gpointer self);
static void game_hub_data_sources_humble_trove_real_load_games_data_free (gpointer _data);
static void game_hub_data_sources_humble_trove_real_load_games (GameHubDataGameSource* base,
                                                         GameHubUtilsFutureResult2 game_loaded,
                                                         gpointer game_loaded_target,
                                                         GameHubUtilsFuture cache_loaded,
                                                         gpointer cache_loaded_target,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean game_hub_data_sources_humble_trove_real_load_games_co (GameHubDataSourcesHumbleTroveLoadGamesData* _data_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
VALA_EXTERN void game_hub_utils_thread (const gchar* name,
                            GameHubUtilsFuture worker,
                            gpointer worker_target,
                            GDestroyNotify worker_target_destroy_notify,
                            gboolean log);
static void __lambda48_ (Block21Data* _data21_);
VALA_EXTERN GeeArrayList* game_hub_data_db_tables_games_get_all (GameHubDataGameSource* src);
VALA_EXTERN void game_hub_data_game_source_set_games_count (GameHubDataGameSource* self,
                                                gint value);
VALA_EXTERN GType game_hub_data_platform_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeArrayList* game_hub_data_runnable_get_platforms (GameHubDataRunnable* self);
VALA_EXTERN GType game_hub_settings_settings_schema_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubSettingsSettingsSchema, g_object_unref)
VALA_EXTERN GType game_hub_settings_ui_behavior_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubSettingsUIBehavior, g_object_unref)
VALA_EXTERN GameHubSettingsUIBehavior* game_hub_settings_ui_behavior_get_instance (void);
VALA_EXTERN gboolean game_hub_settings_ui_behavior_get_merge_games (GameHubSettingsUIBehavior* self);
VALA_EXTERN gboolean game_hub_data_db_tables_merges_is_game_merged (GameHubDataGame* game);
VALA_EXTERN gint game_hub_data_game_source_get_games_count (GameHubDataGameSource* self);
VALA_EXTERN gchar* game_hub_data_sources_humble_humble_escaped_cookie (const gchar* token);
VALA_EXTERN xmlDoc* game_hub_utils_parser_parse_remote_html_file (const gchar* url,
                                                      const gchar* method,
                                                      const gchar* auth,
                                                      GeeHashMap* headers,
                                                      GeeHashMap* data);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_json (const gchar* json);
static void _______lambda49_ (Block21Data* _data21_,
                       JsonArray* array,
                       guint index,
                       JsonNode* node);
static void __lambda50_ (GameHubDataSourcesHumbleTrove* self,
                  JsonObject* downloads_obj,
                  const gchar* dl_os,
                  JsonNode* dl_node);
static void ___lambda50__json_object_foreach (JsonObject* object,
                                       const gchar* member_name,
                                       JsonNode* member_node,
                                       gpointer self);
VALA_EXTERN GType game_hub_data_sources_humble_humble_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesHumbleHumbleGame, g_object_unref)
VALA_EXTERN GameHubDataSourcesHumbleHumbleGame* game_hub_data_sources_humble_humble_game_new (GameHubDataSourcesHumbleHumble* src,
                                                                                  const gchar* order,
                                                                                  JsonNode* json_node);
VALA_EXTERN GameHubDataSourcesHumbleHumbleGame* game_hub_data_sources_humble_humble_game_construct (GType object_type,
                                                                                        GameHubDataSourcesHumbleHumble* src,
                                                                                        const gchar* order,
                                                                                        JsonNode* json_node);
static void ________lambda49__json_array_foreach (JsonArray* array,
                                           guint index_,
                                           JsonNode* element_node,
                                           gpointer self);
static void _vala_JsonNode_free (JsonNode* self);
static gboolean _game_hub_data_sources_humble_trove_real_load_games_co_gsource_func (gpointer self);
static void ___lambda48__game_hub_utils_future (gpointer self);
VALA_EXTERN gchar* game_hub_data_sources_humble_trove_sign_url (const gchar* machine_name,
                                                    const gchar* filename,
                                                    const gchar* humble_token);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_remote_json_file (const gchar* url,
                                                        const gchar* method,
                                                        const gchar* auth,
                                                        GeeHashMap* headers,
                                                        GeeHashMap* data,
                                                        guint* status);
VALA_EXTERN GameHubDataSourcesHumbleTrove* game_hub_data_sources_humble_trove_new (void);
VALA_EXTERN GameHubDataSourcesHumbleTrove* game_hub_data_sources_humble_trove_construct (GType object_type);
VALA_EXTERN GameHubDataSourcesHumbleHumble* game_hub_data_sources_humble_humble_new (void);
VALA_EXTERN GameHubDataSourcesHumbleHumble* game_hub_data_sources_humble_humble_construct (GType object_type);
VALA_EXTERN GType game_hub_settings_auth_humble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubSettingsAuthHumble, g_object_unref)
VALA_EXTERN GameHubSettingsAuthHumble* game_hub_settings_auth_humble_get_instance (void);
VALA_EXTERN void game_hub_settings_auth_humble_set_load_trove_games (GameHubSettingsAuthHumble* self,
                                                         gboolean value);
static void game_hub_data_sources_humble_trove_finalize (GameHubDataGameSource * obj);
static GType game_hub_data_sources_humble_trove_get_type_once (void);

static inline gpointer
game_hub_data_sources_humble_trove_get_instance_private (GameHubDataSourcesHumbleTrove* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataSourcesHumbleTrove_private_offset);
}

static gboolean
_game_hub_data_game_is_equal_gee_equal_data_func (gconstpointer a,
                                                  gconstpointer b,
                                                  gpointer self)
{
	gboolean result;
	result = game_hub_data_game_is_equal ((GameHubDataGame*) a, (GameHubDataGame*) b);
#line 46 "../src/data/sources/humble/Trove.vala"
	return result;
#line 402 "Trove.c"
}

static void
game_hub_data_sources_humble_trove_real_load_games_data_free (gpointer _data)
{
	GameHubDataSourcesHumbleTroveLoadGamesData* _data_;
	_data_ = _data;
#line 25 "../src/data/sources/humble/Trove.vala"
	_g_object_unref0 (_data_->result);
#line 25 "../src/data/sources/humble/Trove.vala"
	_game_hub_data_game_source_unref0 (_data_->self);
#line 25 "../src/data/sources/humble/Trove.vala"
	g_slice_free (GameHubDataSourcesHumbleTroveLoadGamesData, _data_);
#line 416 "Trove.c"
}

static gpointer
_game_hub_data_game_source_ref0 (gpointer self)
{
#line 25 "../src/data/sources/humble/Trove.vala"
	return self ? game_hub_data_game_source_ref (self) : NULL;
#line 424 "Trove.c"
}

static void
game_hub_data_sources_humble_trove_real_load_games (GameHubDataGameSource* base,
                                                    GameHubUtilsFutureResult2 game_loaded,
                                                    gpointer game_loaded_target,
                                                    GameHubUtilsFuture cache_loaded,
                                                    gpointer cache_loaded_target,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	GameHubDataSourcesHumbleTrove * self;
	GameHubDataSourcesHumbleTroveLoadGamesData* _data_;
	GameHubDataSourcesHumbleTrove* _tmp0_;
#line 25 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) base;
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesHumbleTroveLoadGamesData);
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 25 "../src/data/sources/humble/Trove.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_humble_trove_real_load_games_data_free);
#line 25 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = _game_hub_data_game_source_ref0 (self);
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_->game_loaded = game_loaded;
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_->game_loaded_target = game_loaded_target;
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_->cache_loaded = cache_loaded;
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_->cache_loaded_target = cache_loaded_target;
#line 25 "../src/data/sources/humble/Trove.vala"
	game_hub_data_sources_humble_trove_real_load_games_co (_data_);
#line 461 "Trove.c"
}

static GeeArrayList*
game_hub_data_sources_humble_trove_load_games_finish (GameHubDataGameSource* base,
                                                      GAsyncResult* _res_)
{
	GeeArrayList* result;
	GameHubDataSourcesHumbleTroveLoadGamesData* _data_;
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 25 "../src/data/sources/humble/Trove.vala"
	result = _data_->result;
#line 25 "../src/data/sources/humble/Trove.vala"
	_data_->result = NULL;
#line 25 "../src/data/sources/humble/Trove.vala"
	return result;
#line 478 "Trove.c"
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
#line 50 "../src/data/sources/humble/Trove.vala"
	g_atomic_int_inc (&_data21_->_ref_count_);
#line 50 "../src/data/sources/humble/Trove.vala"
	return _data21_;
#line 488 "Trove.c"
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
#line 50 "../src/data/sources/humble/Trove.vala"
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
#line 498 "Trove.c"
		GameHubDataSourcesHumbleTrove* self;
#line 50 "../src/data/sources/humble/Trove.vala"
		self = _data21_->self;
#line 50 "../src/data/sources/humble/Trove.vala"
		_game_hub_data_game_source_unref0 (self);
#line 50 "../src/data/sources/humble/Trove.vala"
		g_slice_free (Block21Data, _data21_);
#line 506 "Trove.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 54 "../src/data/sources/humble/Trove.vala"
	return self ? g_object_ref (self) : NULL;
#line 515 "Trove.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 536 "Trove.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 102 "../src/data/sources/humble/Trove.vala"
	return self ? json_object_ref (self) : NULL;
#line 544 "Trove.c"
}

static gpointer
_json_array_ref0 (gpointer self)
{
#line 105 "../src/data/sources/humble/Trove.vala"
	return self ? json_array_ref (self) : NULL;
#line 552 "Trove.c"
}

static void
__lambda50_ (GameHubDataSourcesHumbleTrove* self,
             JsonObject* downloads_obj,
             const gchar* dl_os,
             JsonNode* dl_node)
{
	JsonObject* dl_obj = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gchar* dl_name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dl_id = NULL;
	JsonObject* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	JsonObject* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
#line 116 "../src/data/sources/humble/Trove.vala"
	g_return_if_fail (downloads_obj != NULL);
#line 116 "../src/data/sources/humble/Trove.vala"
	g_return_if_fail (dl_os != NULL);
#line 116 "../src/data/sources/humble/Trove.vala"
	g_return_if_fail (dl_node != NULL);
#line 117 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = json_node_get_object (dl_node);
#line 117 "../src/data/sources/humble/Trove.vala"
	_tmp1_ = _json_object_ref0 (_tmp0_);
#line 117 "../src/data/sources/humble/Trove.vala"
	dl_obj = _tmp1_;
#line 118 "../src/data/sources/humble/Trove.vala"
	_tmp2_ = json_object_get_string_member (dl_obj, "machine_name");
#line 118 "../src/data/sources/humble/Trove.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 118 "../src/data/sources/humble/Trove.vala"
	dl_name = _tmp3_;
#line 119 "../src/data/sources/humble/Trove.vala"
	_tmp4_ = json_object_get_object_member (dl_obj, "url");
#line 119 "../src/data/sources/humble/Trove.vala"
	_tmp5_ = json_object_get_string_member (_tmp4_, "web");
#line 119 "../src/data/sources/humble/Trove.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 119 "../src/data/sources/humble/Trove.vala"
	dl_id = _tmp6_;
#line 120 "../src/data/sources/humble/Trove.vala"
	json_object_set_string_member (dl_obj, "download_identifier", dl_id);
#line 121 "../src/data/sources/humble/Trove.vala"
	_tmp7_ = json_object_get_object_member (dl_obj, "url");
#line 121 "../src/data/sources/humble/Trove.vala"
	_tmp8_ = g_strconcat ("humble-trove-unsigned://", dl_name, NULL);
#line 121 "../src/data/sources/humble/Trove.vala"
	_tmp9_ = _tmp8_;
#line 121 "../src/data/sources/humble/Trove.vala"
	_tmp10_ = g_strconcat (_tmp9_, "/_gh_dl_/", NULL);
#line 121 "../src/data/sources/humble/Trove.vala"
	_tmp11_ = _tmp10_;
#line 121 "../src/data/sources/humble/Trove.vala"
	_tmp12_ = g_strconcat (_tmp11_, dl_id, NULL);
#line 121 "../src/data/sources/humble/Trove.vala"
	_tmp13_ = _tmp12_;
#line 121 "../src/data/sources/humble/Trove.vala"
	json_object_set_string_member (_tmp7_, "web", _tmp13_);
#line 121 "../src/data/sources/humble/Trove.vala"
	_g_free0 (_tmp13_);
#line 121 "../src/data/sources/humble/Trove.vala"
	_g_free0 (_tmp11_);
#line 121 "../src/data/sources/humble/Trove.vala"
	_g_free0 (_tmp9_);
#line 116 "../src/data/sources/humble/Trove.vala"
	_g_free0 (dl_id);
#line 116 "../src/data/sources/humble/Trove.vala"
	_g_free0 (dl_name);
#line 116 "../src/data/sources/humble/Trove.vala"
	_json_object_unref0 (dl_obj);
#line 634 "Trove.c"
}

static void
___lambda50__json_object_foreach (JsonObject* object,
                                  const gchar* member_name,
                                  JsonNode* member_node,
                                  gpointer self)
{
#line 116 "../src/data/sources/humble/Trove.vala"
	__lambda50_ ((GameHubDataSourcesHumbleTrove*) self, object, member_name, member_node);
#line 645 "Trove.c"
}

static void
_______lambda49_ (Block21Data* _data21_,
                  JsonArray* array,
                  guint index,
                  JsonNode* node)
{
	GameHubDataSourcesHumbleTrove* self;
	JsonObject* obj = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gchar* key = NULL;
	JsonObject* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	JsonObject* downloads = NULL;
	JsonObject* _tmp6_;
	JsonObject* _tmp7_;
	JsonObject* _tmp8_;
	JsonObject* _tmp9_;
	GameHubDataSourcesHumbleHumbleGame* game = NULL;
	GameHubDataSourcesHumbleHumbleGame* _tmp10_;
	GameHubDataSourcesHumbleHumbleGame* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gboolean is_new_game = FALSE;
	GeeArrayList* _tmp16_;
	GameHubDataSourcesHumbleHumbleGame* _tmp17_;
	gboolean _tmp18_ = FALSE;
#line 108 "../src/data/sources/humble/Trove.vala"
	self = _data21_->self;
#line 108 "../src/data/sources/humble/Trove.vala"
	g_return_if_fail (array != NULL);
#line 108 "../src/data/sources/humble/Trove.vala"
	g_return_if_fail (node != NULL);
#line 109 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = json_node_get_object (node);
#line 109 "../src/data/sources/humble/Trove.vala"
	_tmp1_ = _json_object_ref0 (_tmp0_);
#line 109 "../src/data/sources/humble/Trove.vala"
	obj = _tmp1_;
#line 110 "../src/data/sources/humble/Trove.vala"
	_tmp2_ = obj;
#line 110 "../src/data/sources/humble/Trove.vala"
	_tmp3_ = json_object_get_string_member (_tmp2_, "machine_name");
#line 110 "../src/data/sources/humble/Trove.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 110 "../src/data/sources/humble/Trove.vala"
	key = _tmp4_;
#line 112 "../src/data/sources/humble/Trove.vala"
	_tmp5_ = key;
#line 112 "../src/data/sources/humble/Trove.vala"
	if (g_strcmp0 (_tmp5_, GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_TROVE_INTRO_ID) == 0) {
#line 112 "../src/data/sources/humble/Trove.vala"
		_g_free0 (key);
#line 112 "../src/data/sources/humble/Trove.vala"
		_json_object_unref0 (obj);
#line 112 "../src/data/sources/humble/Trove.vala"
		return;
#line 709 "Trove.c"
	}
#line 114 "../src/data/sources/humble/Trove.vala"
	_tmp6_ = obj;
#line 114 "../src/data/sources/humble/Trove.vala"
	_tmp7_ = json_object_get_object_member (_tmp6_, "downloads");
#line 114 "../src/data/sources/humble/Trove.vala"
	_tmp8_ = _json_object_ref0 (_tmp7_);
#line 114 "../src/data/sources/humble/Trove.vala"
	downloads = _tmp8_;
#line 116 "../src/data/sources/humble/Trove.vala"
	_tmp9_ = downloads;
#line 116 "../src/data/sources/humble/Trove.vala"
	json_object_foreach_member (_tmp9_, ___lambda50__json_object_foreach, self);
#line 124 "../src/data/sources/humble/Trove.vala"
	_tmp10_ = game_hub_data_sources_humble_humble_game_new ((GameHubDataSourcesHumbleHumble*) self, GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_FAKE_ORDER, node);
#line 124 "../src/data/sources/humble/Trove.vala"
	game = _tmp10_;
#line 126 "../src/data/sources/humble/Trove.vala"
	_tmp11_ = game;
#line 126 "../src/data/sources/humble/Trove.vala"
	_tmp12_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) _tmp11_);
#line 126 "../src/data/sources/humble/Trove.vala"
	_tmp13_ = _tmp12_;
#line 126 "../src/data/sources/humble/Trove.vala"
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
#line 126 "../src/data/sources/humble/Trove.vala"
	_tmp15_ = _tmp14_;
#line 126 "../src/data/sources/humble/Trove.vala"
	if (_tmp15_ == 0) {
#line 126 "../src/data/sources/humble/Trove.vala"
		_g_object_unref0 (game);
#line 126 "../src/data/sources/humble/Trove.vala"
		_json_object_unref0 (downloads);
#line 126 "../src/data/sources/humble/Trove.vala"
		_g_free0 (key);
#line 126 "../src/data/sources/humble/Trove.vala"
		_json_object_unref0 (obj);
#line 126 "../src/data/sources/humble/Trove.vala"
		return;
#line 749 "Trove.c"
	}
#line 127 "../src/data/sources/humble/Trove.vala"
	_tmp16_ = self->priv->_games;
#line 127 "../src/data/sources/humble/Trove.vala"
	_tmp17_ = game;
#line 127 "../src/data/sources/humble/Trove.vala"
	is_new_game = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp16_, (GameHubDataGame*) _tmp17_);
#line 128 "../src/data/sources/humble/Trove.vala"
	if (is_new_game) {
#line 759 "Trove.c"
		gboolean _tmp19_ = FALSE;
		GameHubSettingsUIBehavior* _tmp20_;
		GameHubSettingsUIBehavior* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
#line 128 "../src/data/sources/humble/Trove.vala"
		_tmp20_ = game_hub_settings_ui_behavior_get_instance ();
#line 128 "../src/data/sources/humble/Trove.vala"
		_tmp21_ = _tmp20_;
#line 128 "../src/data/sources/humble/Trove.vala"
		_tmp22_ = game_hub_settings_ui_behavior_get_merge_games (_tmp21_);
#line 128 "../src/data/sources/humble/Trove.vala"
		_tmp23_ = _tmp22_;
#line 128 "../src/data/sources/humble/Trove.vala"
		if (!_tmp23_) {
#line 128 "../src/data/sources/humble/Trove.vala"
			_tmp19_ = TRUE;
#line 777 "Trove.c"
		} else {
			GameHubDataSourcesHumbleHumbleGame* _tmp24_;
#line 128 "../src/data/sources/humble/Trove.vala"
			_tmp24_ = game;
#line 128 "../src/data/sources/humble/Trove.vala"
			_tmp19_ = !game_hub_data_db_tables_merges_is_game_merged ((GameHubDataGame*) _tmp24_);
#line 784 "Trove.c"
		}
#line 128 "../src/data/sources/humble/Trove.vala"
		_tmp18_ = _tmp19_;
#line 788 "Trove.c"
	} else {
#line 128 "../src/data/sources/humble/Trove.vala"
		_tmp18_ = FALSE;
#line 792 "Trove.c"
	}
#line 128 "../src/data/sources/humble/Trove.vala"
	if (_tmp18_) {
#line 796 "Trove.c"
		GeeArrayList* _tmp25_;
		GameHubDataSourcesHumbleHumbleGame* _tmp26_;
#line 130 "../src/data/sources/humble/Trove.vala"
		_tmp25_ = self->priv->_games;
#line 130 "../src/data/sources/humble/Trove.vala"
		_tmp26_ = game;
#line 130 "../src/data/sources/humble/Trove.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (GameHubDataGame*) _tmp26_);
#line 131 "../src/data/sources/humble/Trove.vala"
		if (_data21_->game_loaded != NULL) {
#line 807 "Trove.c"
			GameHubDataSourcesHumbleHumbleGame* _tmp27_;
#line 133 "../src/data/sources/humble/Trove.vala"
			_tmp27_ = game;
#line 133 "../src/data/sources/humble/Trove.vala"
			_data21_->game_loaded ((GameHubDataGame*) _tmp27_, (gpointer) ((gintptr) FALSE), _data21_->game_loaded_target);
#line 813 "Trove.c"
		}
	}
#line 136 "../src/data/sources/humble/Trove.vala"
	if (is_new_game) {
#line 818 "Trove.c"
		gint _tmp28_;
		gint _tmp29_;
#line 136 "../src/data/sources/humble/Trove.vala"
		_tmp28_ = game_hub_data_game_source_get_games_count ((GameHubDataGameSource*) self);
#line 136 "../src/data/sources/humble/Trove.vala"
		_tmp29_ = _tmp28_;
#line 136 "../src/data/sources/humble/Trove.vala"
		game_hub_data_game_source_set_games_count ((GameHubDataGameSource*) self, _tmp29_ + 1);
#line 827 "Trove.c"
	}
#line 108 "../src/data/sources/humble/Trove.vala"
	_g_object_unref0 (game);
#line 108 "../src/data/sources/humble/Trove.vala"
	_json_object_unref0 (downloads);
#line 108 "../src/data/sources/humble/Trove.vala"
	_g_free0 (key);
#line 108 "../src/data/sources/humble/Trove.vala"
	_json_object_unref0 (obj);
#line 837 "Trove.c"
}

static void
________lambda49__json_array_foreach (JsonArray* array,
                                      guint index_,
                                      JsonNode* element_node,
                                      gpointer self)
{
#line 108 "../src/data/sources/humble/Trove.vala"
	_______lambda49_ (self, array, index_, element_node);
#line 848 "Trove.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 97 "../src/data/sources/humble/Trove.vala"
	g_boxed_free (json_node_get_type (), self);
#line 856 "Trove.c"
}

static gboolean
_game_hub_data_sources_humble_trove_real_load_games_co_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hub_data_sources_humble_trove_real_load_games_co (self);
#line 146 "../src/data/sources/humble/Trove.vala"
	return result;
#line 866 "Trove.c"
}

static void
__lambda48_ (Block21Data* _data21_)
{
	GameHubDataSourcesHumbleTrove* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* cached = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeHashMap* headers = NULL;
	GeeHashMap* _tmp29_;
	GeeHashMap* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	xmlDoc* html = NULL;
	GeeHashMap* _tmp34_;
	xmlDoc* _tmp35_;
	xmlDoc* _tmp36_;
#line 57 "../src/data/sources/humble/Trove.vala"
	self = _data21_->self;
#line 58 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = self->priv->_games;
#line 58 "../src/data/sources/humble/Trove.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 60 "../src/data/sources/humble/Trove.vala"
	_tmp1_ = game_hub_data_db_tables_games_get_all ((GameHubDataGameSource*) self);
#line 60 "../src/data/sources/humble/Trove.vala"
	cached = _tmp1_;
#line 61 "../src/data/sources/humble/Trove.vala"
	game_hub_data_game_source_set_games_count ((GameHubDataGameSource*) self, 0);
#line 62 "../src/data/sources/humble/Trove.vala"
	_tmp2_ = cached;
#line 62 "../src/data/sources/humble/Trove.vala"
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 62 "../src/data/sources/humble/Trove.vala"
	_tmp4_ = _tmp3_;
#line 62 "../src/data/sources/humble/Trove.vala"
	if (_tmp4_ > 0) {
#line 909 "Trove.c"
		{
			GeeArrayList* _g_list = NULL;
			GeeArrayList* _tmp5_;
			gint _g_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _g_index = 0;
#line 64 "../src/data/sources/humble/Trove.vala"
			_tmp5_ = cached;
#line 64 "../src/data/sources/humble/Trove.vala"
			_g_list = _tmp5_;
#line 64 "../src/data/sources/humble/Trove.vala"
			_tmp6_ = _g_list;
#line 64 "../src/data/sources/humble/Trove.vala"
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
#line 64 "../src/data/sources/humble/Trove.vala"
			_tmp8_ = _tmp7_;
#line 64 "../src/data/sources/humble/Trove.vala"
			_g_size = _tmp8_;
#line 64 "../src/data/sources/humble/Trove.vala"
			_g_index = -1;
#line 64 "../src/data/sources/humble/Trove.vala"
			while (TRUE) {
#line 934 "Trove.c"
				gint _tmp9_;
				gint _tmp10_;
				GameHubDataGame* g = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				GameHubDataGame* _tmp13_;
				GeeArrayList* _tmp14_;
				GeeArrayList* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gboolean _tmp18_ = FALSE;
				GameHubSettingsUIBehavior* _tmp19_;
				GameHubSettingsUIBehavior* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp22_;
				gint _tmp27_;
				gint _tmp28_;
#line 64 "../src/data/sources/humble/Trove.vala"
				_g_index = _g_index + 1;
#line 64 "../src/data/sources/humble/Trove.vala"
				_tmp9_ = _g_index;
#line 64 "../src/data/sources/humble/Trove.vala"
				_tmp10_ = _g_size;
#line 64 "../src/data/sources/humble/Trove.vala"
				if (!(_tmp9_ < _tmp10_)) {
#line 64 "../src/data/sources/humble/Trove.vala"
					break;
#line 962 "Trove.c"
				}
#line 64 "../src/data/sources/humble/Trove.vala"
				_tmp11_ = _g_list;
#line 64 "../src/data/sources/humble/Trove.vala"
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _g_index);
#line 64 "../src/data/sources/humble/Trove.vala"
				g = (GameHubDataGame*) _tmp12_;
#line 66 "../src/data/sources/humble/Trove.vala"
				_tmp13_ = g;
#line 66 "../src/data/sources/humble/Trove.vala"
				_tmp14_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) _tmp13_);
#line 66 "../src/data/sources/humble/Trove.vala"
				_tmp15_ = _tmp14_;
#line 66 "../src/data/sources/humble/Trove.vala"
				_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
#line 66 "../src/data/sources/humble/Trove.vala"
				_tmp17_ = _tmp16_;
#line 66 "../src/data/sources/humble/Trove.vala"
				if (_tmp17_ == 0) {
#line 66 "../src/data/sources/humble/Trove.vala"
					_g_object_unref0 (g);
#line 66 "../src/data/sources/humble/Trove.vala"
					continue;
#line 986 "Trove.c"
				}
#line 67 "../src/data/sources/humble/Trove.vala"
				_tmp19_ = game_hub_settings_ui_behavior_get_instance ();
#line 67 "../src/data/sources/humble/Trove.vala"
				_tmp20_ = _tmp19_;
#line 67 "../src/data/sources/humble/Trove.vala"
				_tmp21_ = game_hub_settings_ui_behavior_get_merge_games (_tmp20_);
#line 67 "../src/data/sources/humble/Trove.vala"
				_tmp22_ = _tmp21_;
#line 67 "../src/data/sources/humble/Trove.vala"
				if (!_tmp22_) {
#line 67 "../src/data/sources/humble/Trove.vala"
					_tmp18_ = TRUE;
#line 1000 "Trove.c"
				} else {
					GameHubDataGame* _tmp23_;
#line 67 "../src/data/sources/humble/Trove.vala"
					_tmp23_ = g;
#line 67 "../src/data/sources/humble/Trove.vala"
					_tmp18_ = !game_hub_data_db_tables_merges_is_game_merged (_tmp23_);
#line 1007 "Trove.c"
				}
#line 67 "../src/data/sources/humble/Trove.vala"
				if (_tmp18_) {
#line 1011 "Trove.c"
					GeeArrayList* _tmp24_;
					GameHubDataGame* _tmp25_;
#line 69 "../src/data/sources/humble/Trove.vala"
					_tmp24_ = self->priv->_games;
#line 69 "../src/data/sources/humble/Trove.vala"
					_tmp25_ = g;
#line 69 "../src/data/sources/humble/Trove.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
#line 70 "../src/data/sources/humble/Trove.vala"
					if (_data21_->game_loaded != NULL) {
#line 1022 "Trove.c"
						GameHubDataGame* _tmp26_;
#line 72 "../src/data/sources/humble/Trove.vala"
						_tmp26_ = g;
#line 72 "../src/data/sources/humble/Trove.vala"
						_data21_->game_loaded (_tmp26_, (gpointer) ((gintptr) TRUE), _data21_->game_loaded_target);
#line 1028 "Trove.c"
					}
				}
#line 75 "../src/data/sources/humble/Trove.vala"
				_tmp27_ = game_hub_data_game_source_get_games_count ((GameHubDataGameSource*) self);
#line 75 "../src/data/sources/humble/Trove.vala"
				_tmp28_ = _tmp27_;
#line 75 "../src/data/sources/humble/Trove.vala"
				game_hub_data_game_source_set_games_count ((GameHubDataGameSource*) self, _tmp28_ + 1);
#line 64 "../src/data/sources/humble/Trove.vala"
				_g_object_unref0 (g);
#line 1039 "Trove.c"
			}
		}
	}
#line 79 "../src/data/sources/humble/Trove.vala"
	if (_data21_->cache_loaded != NULL) {
#line 81 "../src/data/sources/humble/Trove.vala"
		_data21_->cache_loaded (_data21_->cache_loaded_target);
#line 1047 "Trove.c"
	}
#line 84 "../src/data/sources/humble/Trove.vala"
	_tmp29_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 84 "../src/data/sources/humble/Trove.vala"
	headers = _tmp29_;
#line 85 "../src/data/sources/humble/Trove.vala"
	_tmp30_ = headers;
#line 85 "../src/data/sources/humble/Trove.vala"
	_tmp31_ = ((GameHubDataSourcesHumbleHumble*) self)->user_token;
#line 85 "../src/data/sources/humble/Trove.vala"
	_tmp32_ = game_hub_data_sources_humble_humble_escaped_cookie (_tmp31_);
#line 85 "../src/data/sources/humble/Trove.vala"
	_tmp33_ = _tmp32_;
#line 85 "../src/data/sources/humble/Trove.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, "Cookie", _tmp33_);
#line 85 "../src/data/sources/humble/Trove.vala"
	_g_free0 (_tmp33_);
#line 87 "../src/data/sources/humble/Trove.vala"
	_tmp34_ = headers;
#line 87 "../src/data/sources/humble/Trove.vala"
	_tmp35_ = game_hub_utils_parser_parse_remote_html_file (GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_PAGE_URL, "GET", NULL, _tmp34_, NULL);
#line 87 "../src/data/sources/humble/Trove.vala"
	html = _tmp35_;
#line 89 "../src/data/sources/humble/Trove.vala"
	_tmp36_ = html;
#line 89 "../src/data/sources/humble/Trove.vala"
	if (_tmp36_ != NULL) {
#line 1075 "Trove.c"
		xmlXPathContext* xpath = NULL;
		xmlDoc* _tmp37_;
		xmlXPathContext* _tmp38_;
		xmlXPathObject* xpath_object = NULL;
		xmlXPathContext* _tmp39_;
		xmlXPathObject* _tmp40_;
		xmlNodeSet* _tmp41_ = NULL;
		xmlXPathObject* _tmp42_;
		xmlNodeSet* xpath_nodeset = NULL;
		gchar* _tmp45_ = NULL;
		gboolean _tmp46_ = FALSE;
		xmlNodeSet* _tmp47_;
		gchar* trove_json = NULL;
		gchar* _tmp53_;
		const gchar* _tmp54_;
		xmlDoc* _tmp69_;
#line 91 "../src/data/sources/humble/Trove.vala"
		_tmp37_ = html;
#line 91 "../src/data/sources/humble/Trove.vala"
		_tmp38_ = xmlXPathNewContext (_tmp37_);
#line 91 "../src/data/sources/humble/Trove.vala"
		xpath = _tmp38_;
#line 93 "../src/data/sources/humble/Trove.vala"
		_tmp39_ = xpath;
#line 93 "../src/data/sources/humble/Trove.vala"
		_tmp40_ = xmlXPathEval ((xmlChar*) "//script[@id='webpack-monthly-trove-data']/text()", _tmp39_);
#line 93 "../src/data/sources/humble/Trove.vala"
		xpath_object = _tmp40_;
#line 94 "../src/data/sources/humble/Trove.vala"
		_tmp42_ = xpath_object;
#line 94 "../src/data/sources/humble/Trove.vala"
		if (_tmp42_ != NULL) {
#line 1108 "Trove.c"
			xmlXPathObject* _tmp43_;
			xmlNodeSet* _tmp44_;
#line 94 "../src/data/sources/humble/Trove.vala"
			_tmp43_ = xpath_object;
#line 94 "../src/data/sources/humble/Trove.vala"
			_tmp44_ = _tmp43_->nodesetval;
#line 94 "../src/data/sources/humble/Trove.vala"
			_tmp41_ = _tmp44_;
#line 1117 "Trove.c"
		} else {
#line 94 "../src/data/sources/humble/Trove.vala"
			_tmp41_ = NULL;
#line 1121 "Trove.c"
		}
#line 94 "../src/data/sources/humble/Trove.vala"
		xpath_nodeset = _tmp41_;
#line 95 "../src/data/sources/humble/Trove.vala"
		_tmp47_ = xpath_nodeset;
#line 95 "../src/data/sources/humble/Trove.vala"
		if (_tmp47_ != NULL) {
#line 1129 "Trove.c"
			xmlNodeSet* _tmp48_;
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp48_ = xpath_nodeset;
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp46_ = !xmlXPathNodeSetIsEmpty (_tmp48_);
#line 1135 "Trove.c"
		} else {
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp46_ = FALSE;
#line 1139 "Trove.c"
		}
#line 95 "../src/data/sources/humble/Trove.vala"
		if (_tmp46_) {
#line 1143 "Trove.c"
			xmlNodeSet* _tmp49_;
			xmlNode* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp49_ = xpath_nodeset;
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp50_ = xmlXPathNodeSetItem (_tmp49_, 0);
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp51_ = _tmp50_->content;
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp52_ = string_strip (_tmp51_);
#line 95 "../src/data/sources/humble/Trove.vala"
			_g_free0 (_tmp45_);
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp45_ = _tmp52_;
#line 1160 "Trove.c"
		} else {
#line 95 "../src/data/sources/humble/Trove.vala"
			_g_free0 (_tmp45_);
#line 95 "../src/data/sources/humble/Trove.vala"
			_tmp45_ = NULL;
#line 1166 "Trove.c"
		}
#line 95 "../src/data/sources/humble/Trove.vala"
		_tmp53_ = g_strdup (_tmp45_);
#line 95 "../src/data/sources/humble/Trove.vala"
		trove_json = _tmp53_;
#line 97 "../src/data/sources/humble/Trove.vala"
		_tmp54_ = trove_json;
#line 97 "../src/data/sources/humble/Trove.vala"
		if (_tmp54_ != NULL) {
#line 1176 "Trove.c"
			JsonNode* trove_root_node = NULL;
			const gchar* _tmp55_;
			JsonNode* _tmp56_;
			JsonNode* _tmp57_;
#line 99 "../src/data/sources/humble/Trove.vala"
			_tmp55_ = trove_json;
#line 99 "../src/data/sources/humble/Trove.vala"
			_tmp56_ = game_hub_utils_parser_parse_json (_tmp55_);
#line 99 "../src/data/sources/humble/Trove.vala"
			trove_root_node = _tmp56_;
#line 100 "../src/data/sources/humble/Trove.vala"
			_tmp57_ = trove_root_node;
#line 100 "../src/data/sources/humble/Trove.vala"
			if (json_node_get_node_type (_tmp57_) == JSON_NODE_OBJECT) {
#line 1191 "Trove.c"
				JsonObject* trove_root = NULL;
				JsonNode* _tmp58_;
				JsonObject* _tmp59_;
				JsonObject* _tmp60_;
				JsonObject* _tmp61_;
#line 102 "../src/data/sources/humble/Trove.vala"
				_tmp58_ = trove_root_node;
#line 102 "../src/data/sources/humble/Trove.vala"
				_tmp59_ = json_node_get_object (_tmp58_);
#line 102 "../src/data/sources/humble/Trove.vala"
				_tmp60_ = _json_object_ref0 (_tmp59_);
#line 102 "../src/data/sources/humble/Trove.vala"
				trove_root = _tmp60_;
#line 103 "../src/data/sources/humble/Trove.vala"
				_tmp61_ = trove_root;
#line 103 "../src/data/sources/humble/Trove.vala"
				if (_tmp61_ != NULL) {
#line 1209 "Trove.c"
					JsonArray* _tmp62_ = NULL;
					JsonObject* _tmp63_;
					JsonArray* products = NULL;
					JsonArray* _tmp66_;
					JsonArray* _tmp67_;
#line 105 "../src/data/sources/humble/Trove.vala"
					_tmp63_ = trove_root;
#line 105 "../src/data/sources/humble/Trove.vala"
					if (json_object_has_member (_tmp63_, "standardProducts")) {
#line 1219 "Trove.c"
						JsonObject* _tmp64_;
						JsonArray* _tmp65_;
#line 105 "../src/data/sources/humble/Trove.vala"
						_tmp64_ = trove_root;
#line 105 "../src/data/sources/humble/Trove.vala"
						_tmp65_ = json_object_get_array_member (_tmp64_, "standardProducts");
#line 105 "../src/data/sources/humble/Trove.vala"
						_tmp62_ = _tmp65_;
#line 1228 "Trove.c"
					} else {
#line 105 "../src/data/sources/humble/Trove.vala"
						_tmp62_ = NULL;
#line 1232 "Trove.c"
					}
#line 105 "../src/data/sources/humble/Trove.vala"
					_tmp66_ = _json_array_ref0 (_tmp62_);
#line 105 "../src/data/sources/humble/Trove.vala"
					products = _tmp66_;
#line 106 "../src/data/sources/humble/Trove.vala"
					_tmp67_ = products;
#line 106 "../src/data/sources/humble/Trove.vala"
					if (_tmp67_ != NULL) {
#line 1242 "Trove.c"
						JsonArray* _tmp68_;
#line 108 "../src/data/sources/humble/Trove.vala"
						_tmp68_ = products;
#line 108 "../src/data/sources/humble/Trove.vala"
						json_array_foreach_element (_tmp68_, ________lambda49__json_array_foreach, _data21_);
#line 1248 "Trove.c"
					}
#line 103 "../src/data/sources/humble/Trove.vala"
					_json_array_unref0 (products);
#line 1252 "Trove.c"
				}
#line 100 "../src/data/sources/humble/Trove.vala"
				_json_object_unref0 (trove_root);
#line 1256 "Trove.c"
			}
#line 97 "../src/data/sources/humble/Trove.vala"
			__vala_JsonNode_free0 (trove_root_node);
#line 1260 "Trove.c"
		}
#line 143 "../src/data/sources/humble/Trove.vala"
		_tmp69_ = html;
#line 143 "../src/data/sources/humble/Trove.vala"
		_xmlFreeDoc0 (_tmp69_);
#line 89 "../src/data/sources/humble/Trove.vala"
		_g_free0 (trove_json);
#line 89 "../src/data/sources/humble/Trove.vala"
		_g_free0 (_tmp45_);
#line 89 "../src/data/sources/humble/Trove.vala"
		_xmlXPathFreeContext0 (xpath);
#line 1272 "Trove.c"
	}
#line 146 "../src/data/sources/humble/Trove.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _game_hub_data_sources_humble_trove_real_load_games_co_gsource_func, _data21_->_async_data_, NULL);
#line 57 "../src/data/sources/humble/Trove.vala"
	_g_object_unref0 (headers);
#line 57 "../src/data/sources/humble/Trove.vala"
	_g_object_unref0 (cached);
#line 1280 "Trove.c"
}

static void
___lambda48__game_hub_utils_future (gpointer self)
{
#line 57 "../src/data/sources/humble/Trove.vala"
	__lambda48_ (self);
#line 1288 "Trove.c"
}

static gboolean
game_hub_data_sources_humble_trove_real_load_games_co (GameHubDataSourcesHumbleTroveLoadGamesData* _data_)
{
#line 50 "../src/data/sources/humble/Trove.vala"
	switch (_data_->_state_) {
#line 50 "../src/data/sources/humble/Trove.vala"
		case 0:
#line 1298 "Trove.c"
		goto _state_0;
#line 50 "../src/data/sources/humble/Trove.vala"
		case 1:
#line 1302 "Trove.c"
		goto _state_1;
		default:
#line 50 "../src/data/sources/humble/Trove.vala"
		g_assert_not_reached ();
#line 1307 "Trove.c"
	}
	_state_0:
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_ = g_slice_new0 (Block21Data);
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_->_ref_count_ = 1;
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_->self = game_hub_data_game_source_ref (_data_->self);
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_->game_loaded = _data_->game_loaded;
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_->game_loaded_target = _data_->game_loaded_target;
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_->cache_loaded = _data_->cache_loaded;
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_->cache_loaded_target = _data_->cache_loaded_target;
#line 50 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_->_async_data_ = _data_;
#line 52 "../src/data/sources/humble/Trove.vala"
	_data_->_tmp1_ = ((GameHubDataSourcesHumbleHumble*) _data_->self)->user_token;
#line 52 "../src/data/sources/humble/Trove.vala"
	if (_data_->_tmp1_ == NULL) {
#line 52 "../src/data/sources/humble/Trove.vala"
		_data_->_tmp0_ = TRUE;
#line 1332 "Trove.c"
	} else {
#line 52 "../src/data/sources/humble/Trove.vala"
		_data_->_tmp2_ = _data_->self->priv->_games;
#line 52 "../src/data/sources/humble/Trove.vala"
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
#line 52 "../src/data/sources/humble/Trove.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 52 "../src/data/sources/humble/Trove.vala"
		_data_->_tmp0_ = _data_->_tmp4_ > 0;
#line 1342 "Trove.c"
	}
#line 52 "../src/data/sources/humble/Trove.vala"
	if (_data_->_tmp0_) {
#line 54 "../src/data/sources/humble/Trove.vala"
		_data_->_tmp5_ = _data_->self->priv->_games;
#line 54 "../src/data/sources/humble/Trove.vala"
		_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 54 "../src/data/sources/humble/Trove.vala"
		_data_->result = _data_->_tmp6_;
#line 54 "../src/data/sources/humble/Trove.vala"
		block21_data_unref (_data_->_data21_);
#line 54 "../src/data/sources/humble/Trove.vala"
		_data_->_data21_ = NULL;
#line 54 "../src/data/sources/humble/Trove.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 54 "../src/data/sources/humble/Trove.vala"
		if (_data_->_state_ != 0) {
#line 54 "../src/data/sources/humble/Trove.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 54 "../src/data/sources/humble/Trove.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1364 "Trove.c"
			}
		}
#line 54 "../src/data/sources/humble/Trove.vala"
		g_object_unref (_data_->_async_result);
#line 54 "../src/data/sources/humble/Trove.vala"
		return FALSE;
#line 1371 "Trove.c"
	}
#line 57 "../src/data/sources/humble/Trove.vala"
	game_hub_utils_thread ("HumbleTroveLoading", ___lambda48__game_hub_utils_future, block21_data_ref (_data_->_data21_), block21_data_unref, TRUE);
#line 149 "../src/data/sources/humble/Trove.vala"
	_data_->_state_ = 1;
#line 149 "../src/data/sources/humble/Trove.vala"
	return FALSE;
#line 1379 "Trove.c"
	_state_1:
	;
#line 151 "../src/data/sources/humble/Trove.vala"
	_data_->_tmp7_ = _data_->self->priv->_games;
#line 151 "../src/data/sources/humble/Trove.vala"
	_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
#line 151 "../src/data/sources/humble/Trove.vala"
	_data_->result = _data_->_tmp8_;
#line 151 "../src/data/sources/humble/Trove.vala"
	block21_data_unref (_data_->_data21_);
#line 151 "../src/data/sources/humble/Trove.vala"
	_data_->_data21_ = NULL;
#line 151 "../src/data/sources/humble/Trove.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 151 "../src/data/sources/humble/Trove.vala"
	if (_data_->_state_ != 0) {
#line 151 "../src/data/sources/humble/Trove.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 151 "../src/data/sources/humble/Trove.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1400 "Trove.c"
		}
	}
#line 151 "../src/data/sources/humble/Trove.vala"
	g_object_unref (_data_->_async_result);
#line 151 "../src/data/sources/humble/Trove.vala"
	return FALSE;
#line 1407 "Trove.c"
}

gchar*
game_hub_data_sources_humble_trove_sign_url (const gchar* machine_name,
                                             const gchar* filename,
                                             const gchar* humble_token)
{
	GeeHashMap* headers = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* data = NULL;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	JsonNode* signed_node = NULL;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	JsonNode* _tmp9_;
	JsonObject* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	JsonNode* _tmp12_;
	JsonObject* _signed_ = NULL;
	JsonObject* _tmp16_;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	JsonObject* _tmp19_;
	gchar* signed_url = NULL;
	gchar* _tmp23_;
	gchar* result;
#line 154 "../src/data/sources/humble/Trove.vala"
	g_return_val_if_fail (machine_name != NULL, NULL);
#line 154 "../src/data/sources/humble/Trove.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 154 "../src/data/sources/humble/Trove.vala"
	g_return_val_if_fail (humble_token != NULL, NULL);
#line 156 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 156 "../src/data/sources/humble/Trove.vala"
	headers = _tmp0_;
#line 157 "../src/data/sources/humble/Trove.vala"
	_tmp1_ = headers;
#line 157 "../src/data/sources/humble/Trove.vala"
	_tmp2_ = game_hub_data_sources_humble_humble_escaped_cookie (humble_token);
#line 157 "../src/data/sources/humble/Trove.vala"
	_tmp3_ = _tmp2_;
#line 157 "../src/data/sources/humble/Trove.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, "Cookie", _tmp3_);
#line 157 "../src/data/sources/humble/Trove.vala"
	_g_free0 (_tmp3_);
#line 159 "../src/data/sources/humble/Trove.vala"
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 159 "../src/data/sources/humble/Trove.vala"
	data = _tmp4_;
#line 160 "../src/data/sources/humble/Trove.vala"
	_tmp5_ = data;
#line 160 "../src/data/sources/humble/Trove.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, "machine_name", machine_name);
#line 161 "../src/data/sources/humble/Trove.vala"
	_tmp6_ = data;
#line 161 "../src/data/sources/humble/Trove.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, "filename", filename);
#line 163 "../src/data/sources/humble/Trove.vala"
	_tmp7_ = headers;
#line 163 "../src/data/sources/humble/Trove.vala"
	_tmp8_ = data;
#line 163 "../src/data/sources/humble/Trove.vala"
	_tmp9_ = game_hub_utils_parser_parse_remote_json_file (GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_SIGN_URL, "POST", NULL, _tmp7_, _tmp8_, NULL);
#line 163 "../src/data/sources/humble/Trove.vala"
	signed_node = _tmp9_;
#line 164 "../src/data/sources/humble/Trove.vala"
	_tmp12_ = signed_node;
#line 164 "../src/data/sources/humble/Trove.vala"
	if (_tmp12_ != NULL) {
#line 1483 "Trove.c"
		JsonNode* _tmp13_;
#line 164 "../src/data/sources/humble/Trove.vala"
		_tmp13_ = signed_node;
#line 164 "../src/data/sources/humble/Trove.vala"
		_tmp11_ = json_node_get_node_type (_tmp13_) == JSON_NODE_OBJECT;
#line 1489 "Trove.c"
	} else {
#line 164 "../src/data/sources/humble/Trove.vala"
		_tmp11_ = FALSE;
#line 1493 "Trove.c"
	}
#line 164 "../src/data/sources/humble/Trove.vala"
	if (_tmp11_) {
#line 1497 "Trove.c"
		JsonNode* _tmp14_;
		JsonObject* _tmp15_;
#line 164 "../src/data/sources/humble/Trove.vala"
		_tmp14_ = signed_node;
#line 164 "../src/data/sources/humble/Trove.vala"
		_tmp15_ = json_node_get_object (_tmp14_);
#line 164 "../src/data/sources/humble/Trove.vala"
		_tmp10_ = _tmp15_;
#line 1506 "Trove.c"
	} else {
#line 164 "../src/data/sources/humble/Trove.vala"
		_tmp10_ = NULL;
#line 1510 "Trove.c"
	}
#line 164 "../src/data/sources/humble/Trove.vala"
	_tmp16_ = _json_object_ref0 (_tmp10_);
#line 164 "../src/data/sources/humble/Trove.vala"
	_signed_ = _tmp16_;
#line 166 "../src/data/sources/humble/Trove.vala"
	_tmp19_ = _signed_;
#line 166 "../src/data/sources/humble/Trove.vala"
	if (_tmp19_ != NULL) {
#line 1520 "Trove.c"
		JsonObject* _tmp20_;
#line 166 "../src/data/sources/humble/Trove.vala"
		_tmp20_ = _signed_;
#line 166 "../src/data/sources/humble/Trove.vala"
		_tmp18_ = json_object_has_member (_tmp20_, "signed_url");
#line 1526 "Trove.c"
	} else {
#line 166 "../src/data/sources/humble/Trove.vala"
		_tmp18_ = FALSE;
#line 1530 "Trove.c"
	}
#line 166 "../src/data/sources/humble/Trove.vala"
	if (_tmp18_) {
#line 1534 "Trove.c"
		JsonObject* _tmp21_;
		const gchar* _tmp22_;
#line 166 "../src/data/sources/humble/Trove.vala"
		_tmp21_ = _signed_;
#line 166 "../src/data/sources/humble/Trove.vala"
		_tmp22_ = json_object_get_string_member (_tmp21_, "signed_url");
#line 166 "../src/data/sources/humble/Trove.vala"
		_tmp17_ = _tmp22_;
#line 1543 "Trove.c"
	} else {
#line 166 "../src/data/sources/humble/Trove.vala"
		_tmp17_ = NULL;
#line 1547 "Trove.c"
	}
#line 166 "../src/data/sources/humble/Trove.vala"
	_tmp23_ = g_strdup (_tmp17_);
#line 166 "../src/data/sources/humble/Trove.vala"
	signed_url = _tmp23_;
#line 168 "../src/data/sources/humble/Trove.vala"
	if (game_hub_application_log_verbose) {
#line 1555 "Trove.c"
		const gchar* _tmp24_;
#line 170 "../src/data/sources/humble/Trove.vala"
		_tmp24_ = signed_url;
#line 170 "../src/data/sources/humble/Trove.vala"
		g_debug ("Trove.vala:170: [Trove.sign_url] '%s':'%s' -> '%s'", machine_name, filename, _tmp24_);
#line 1561 "Trove.c"
	}
#line 173 "../src/data/sources/humble/Trove.vala"
	result = signed_url;
#line 173 "../src/data/sources/humble/Trove.vala"
	_json_object_unref0 (_signed_);
#line 173 "../src/data/sources/humble/Trove.vala"
	__vala_JsonNode_free0 (signed_node);
#line 173 "../src/data/sources/humble/Trove.vala"
	_g_object_unref0 (data);
#line 173 "../src/data/sources/humble/Trove.vala"
	_g_object_unref0 (headers);
#line 173 "../src/data/sources/humble/Trove.vala"
	return result;
#line 1575 "Trove.c"
}

GameHubDataSourcesHumbleTrove*
game_hub_data_sources_humble_trove_construct (GType object_type)
{
	GameHubDataSourcesHumbleTrove* self = NULL;
#line 25 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) game_hub_data_sources_humble_humble_construct (object_type);
#line 25 "../src/data/sources/humble/Trove.vala"
	return self;
#line 1586 "Trove.c"
}

GameHubDataSourcesHumbleTrove*
game_hub_data_sources_humble_trove_new (void)
{
#line 25 "../src/data/sources/humble/Trove.vala"
	return game_hub_data_sources_humble_trove_construct (GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE);
#line 1594 "Trove.c"
}

static const gchar*
game_hub_data_sources_humble_trove_real_get_id (GameHubDataGameSource* base)
{
	const gchar* result;
	GameHubDataSourcesHumbleTrove* self;
#line 32 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) base;
#line 32 "../src/data/sources/humble/Trove.vala"
	result = "humble-trove";
#line 32 "../src/data/sources/humble/Trove.vala"
	return result;
#line 1608 "Trove.c"
}

static const gchar*
game_hub_data_sources_humble_trove_real_get_name (GameHubDataGameSource* base)
{
	const gchar* result;
	GameHubDataSourcesHumbleTrove* self;
#line 33 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) base;
#line 33 "../src/data/sources/humble/Trove.vala"
	result = "Humble Trove";
#line 33 "../src/data/sources/humble/Trove.vala"
	return result;
#line 1622 "Trove.c"
}

static const gchar*
game_hub_data_sources_humble_trove_real_get_icon (GameHubDataGameSource* base)
{
	const gchar* result;
	GameHubDataSourcesHumbleTrove* self;
#line 34 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) base;
#line 34 "../src/data/sources/humble/Trove.vala"
	result = "source-humble-trove-symbolic";
#line 34 "../src/data/sources/humble/Trove.vala"
	return result;
#line 1636 "Trove.c"
}

static gboolean
game_hub_data_sources_humble_trove_real_get_enabled (GameHubDataGameSource* base)
{
	gboolean result;
	GameHubDataSourcesHumbleTrove* self;
#line 38 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) base;
#line 41 "../src/data/sources/humble/Trove.vala"
	result = FALSE;
#line 41 "../src/data/sources/humble/Trove.vala"
	return result;
#line 1650 "Trove.c"
}

static void
game_hub_data_sources_humble_trove_real_set_enabled (GameHubDataGameSource* base,
                                                     gboolean value)
{
	GameHubDataSourcesHumbleTrove* self;
	GameHubSettingsAuthHumble* _tmp0_;
	GameHubSettingsAuthHumble* _tmp1_;
#line 43 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) base;
#line 43 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = game_hub_settings_auth_humble_get_instance ();
#line 43 "../src/data/sources/humble/Trove.vala"
	_tmp1_ = _tmp0_;
#line 43 "../src/data/sources/humble/Trove.vala"
	game_hub_settings_auth_humble_set_load_trove_games (_tmp1_, value);
#line 1668 "Trove.c"
}

static GeeArrayList*
game_hub_data_sources_humble_trove_real_get_games (GameHubDataGameSource* base)
{
	GeeArrayList* result;
	GameHubDataSourcesHumbleTrove* self;
	GeeArrayList* _tmp0_;
#line 48 "../src/data/sources/humble/Trove.vala"
	self = (GameHubDataSourcesHumbleTrove*) base;
#line 48 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = self->priv->_games;
#line 48 "../src/data/sources/humble/Trove.vala"
	result = _tmp0_;
#line 48 "../src/data/sources/humble/Trove.vala"
	return result;
#line 1685 "Trove.c"
}

static void
game_hub_data_sources_humble_trove_class_init (GameHubDataSourcesHumbleTroveClass * klass,
                                               gpointer klass_data)
{
#line 25 "../src/data/sources/humble/Trove.vala"
	game_hub_data_sources_humble_trove_parent_class = g_type_class_peek_parent (klass);
#line 25 "../src/data/sources/humble/Trove.vala"
	((GameHubDataGameSourceClass *) klass)->finalize = game_hub_data_sources_humble_trove_finalize;
#line 25 "../src/data/sources/humble/Trove.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataSourcesHumbleTrove_private_offset);
#line 25 "../src/data/sources/humble/Trove.vala"
	((GameHubDataGameSourceClass *) klass)->load_games = (void (*) (GameHubDataGameSource*, GameHubUtilsFutureResult2, gpointer, GameHubUtilsFuture, gpointer, GAsyncReadyCallback, gpointer)) game_hub_data_sources_humble_trove_real_load_games;
#line 25 "../src/data/sources/humble/Trove.vala"
	((GameHubDataGameSourceClass *) klass)->load_games_finish = (GeeArrayList* (*) (GameHubDataGameSource*, GAsyncResult*)) game_hub_data_sources_humble_trove_load_games_finish;
#line 25 "../src/data/sources/humble/Trove.vala"
	GAME_HUB_DATA_GAME_SOURCE_CLASS (klass)->get_id = (const gchar* (*) (GameHubDataGameSource*)) game_hub_data_sources_humble_trove_real_get_id;
#line 25 "../src/data/sources/humble/Trove.vala"
	GAME_HUB_DATA_GAME_SOURCE_CLASS (klass)->get_name = (const gchar* (*) (GameHubDataGameSource*)) game_hub_data_sources_humble_trove_real_get_name;
#line 25 "../src/data/sources/humble/Trove.vala"
	GAME_HUB_DATA_GAME_SOURCE_CLASS (klass)->get_icon = (const gchar* (*) (GameHubDataGameSource*)) game_hub_data_sources_humble_trove_real_get_icon;
#line 25 "../src/data/sources/humble/Trove.vala"
	GAME_HUB_DATA_GAME_SOURCE_CLASS (klass)->get_enabled = (gboolean (*) (GameHubDataGameSource*)) game_hub_data_sources_humble_trove_real_get_enabled;
#line 25 "../src/data/sources/humble/Trove.vala"
	GAME_HUB_DATA_GAME_SOURCE_CLASS (klass)->set_enabled = (void (*) (GameHubDataGameSource*, gboolean)) game_hub_data_sources_humble_trove_real_set_enabled;
#line 25 "../src/data/sources/humble/Trove.vala"
	GAME_HUB_DATA_GAME_SOURCE_CLASS (klass)->get_games = (GeeArrayList* (*) (GameHubDataGameSource*)) game_hub_data_sources_humble_trove_real_get_games;
#line 1714 "Trove.c"
}

static void
game_hub_data_sources_humble_trove_instance_init (GameHubDataSourcesHumbleTrove * self,
                                                  gpointer klass)
{
	GeeArrayList* _tmp0_;
#line 25 "../src/data/sources/humble/Trove.vala"
	self->priv = game_hub_data_sources_humble_trove_get_instance_private (self);
#line 46 "../src/data/sources/humble/Trove.vala"
	_tmp0_ = gee_array_list_new (GAME_HUB_DATA_TYPE_GAME, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _game_hub_data_game_is_equal_gee_equal_data_func, NULL, NULL);
#line 46 "../src/data/sources/humble/Trove.vala"
	self->priv->_games = _tmp0_;
#line 1728 "Trove.c"
}

static void
game_hub_data_sources_humble_trove_finalize (GameHubDataGameSource * obj)
{
	GameHubDataSourcesHumbleTrove * self;
#line 25 "../src/data/sources/humble/Trove.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE, GameHubDataSourcesHumbleTrove);
#line 46 "../src/data/sources/humble/Trove.vala"
	_g_object_unref0 (self->priv->_games);
#line 25 "../src/data/sources/humble/Trove.vala"
	GAME_HUB_DATA_GAME_SOURCE_CLASS (game_hub_data_sources_humble_trove_parent_class)->finalize (obj);
#line 1741 "Trove.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_sources_humble_trove_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataSourcesHumbleTroveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_sources_humble_trove_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataSourcesHumbleTrove), 0, (GInstanceInitFunc) game_hub_data_sources_humble_trove_instance_init, NULL };
	GType game_hub_data_sources_humble_trove_type_id;
	game_hub_data_sources_humble_trove_type_id = g_type_register_static (GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, "GameHubDataSourcesHumbleTrove", &g_define_type_info, 0);
	GameHubDataSourcesHumbleTrove_private_offset = g_type_add_instance_private (game_hub_data_sources_humble_trove_type_id, sizeof (GameHubDataSourcesHumbleTrovePrivate));
	return game_hub_data_sources_humble_trove_type_id;
}

GType
game_hub_data_sources_humble_trove_get_type (void)
{
	static volatile gsize game_hub_data_sources_humble_trove_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_sources_humble_trove_type_id__once)) {
		GType game_hub_data_sources_humble_trove_type_id;
		game_hub_data_sources_humble_trove_type_id = game_hub_data_sources_humble_trove_get_type_once ();
		g_once_init_leave (&game_hub_data_sources_humble_trove_type_id__once, game_hub_data_sources_humble_trove_type_id);
	}
	return game_hub_data_sources_humble_trove_type_id__once;
}

