/* HumbleGame.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from HumbleGame.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <sqlite3.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_AUTH_COOKIE "_simpleauth_sess"
#define GAME_HUB_DATA_PLATFORM_CURRENT GAME_HUB_DATA_PLATFORM_LINUX
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_DATA_TYPE_RUNNABLE (game_hub_data_runnable_get_type ())
#define GAME_HUB_DATA_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnable))
#define GAME_HUB_DATA_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))
#define GAME_HUB_DATA_IS_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_IS_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_RUNNABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))

typedef struct _GameHubDataRunnable GameHubDataRunnable;
typedef struct _GameHubDataRunnableClass GameHubDataRunnableClass;
typedef struct _GameHubDataRunnablePrivate GameHubDataRunnablePrivate;
typedef enum  {
	GAME_HUB_DATA_PLATFORM_LINUX,
	GAME_HUB_DATA_PLATFORM_WINDOWS,
	GAME_HUB_DATA_PLATFORM_MACOS,
	GAME_HUB_DATA_PLATFORM_EMULATED
} GameHubDataPlatform;

#define GAME_HUB_DATA_TYPE_PLATFORM (game_hub_data_platform_get_type ())
typedef enum  {
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_INTERACTIVE,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC_DOWNLOAD
} GameHubDataRunnableInstallerInstallMode;

#define GAME_HUB_DATA_RUNNABLE_INSTALLER_TYPE_INSTALL_MODE (game_hub_data_runnable_installer_install_mode_get_type ())

#define GAME_HUB_DATA_TYPE_GAME (game_hub_data_game_get_type ())
#define GAME_HUB_DATA_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGame))
#define GAME_HUB_DATA_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))
#define GAME_HUB_DATA_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))

typedef struct _GameHubDataGame GameHubDataGame;
typedef struct _GameHubDataGameClass GameHubDataGameClass;
typedef struct _GameHubDataGamePrivate GameHubDataGamePrivate;

#define GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT (game_hub_data_game_achievement_get_type ())
#define GAME_HUB_DATA_GAME_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievement))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_IS_ACHIEVEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT))
#define GAME_HUB_DATA_GAME_ACHIEVEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_ACHIEVEMENT, GameHubDataGameAchievementClass))

typedef struct _GameHubDataGameAchievement GameHubDataGameAchievement;
typedef struct _GameHubDataGameAchievementClass GameHubDataGameAchievementClass;

#define GAME_HUB_DATA_GAME_TYPE_STATUS (game_hub_data_game_status_get_type ())
#define GAME_HUB_DATA_GAME_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatus))
#define GAME_HUB_DATA_GAME_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))
#define GAME_HUB_DATA_GAME_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_STATUS))
#define GAME_HUB_DATA_GAME_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_STATUS, GameHubDataGameStatusClass))

typedef struct _GameHubDataGameStatus GameHubDataGameStatus;
typedef struct _GameHubDataGameStatusClass GameHubDataGameStatusClass;

#define GAME_HUB_DATA_GAME_TYPE_OVERLAY (game_hub_data_game_overlay_get_type ())
#define GAME_HUB_DATA_GAME_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlay))
#define GAME_HUB_DATA_GAME_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))
#define GAME_HUB_DATA_GAME_IS_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_IS_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_GAME_TYPE_OVERLAY))
#define GAME_HUB_DATA_GAME_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_GAME_TYPE_OVERLAY, GameHubDataGameOverlayClass))

typedef struct _GameHubDataGameOverlay GameHubDataGameOverlay;
typedef struct _GameHubDataGameOverlayClass GameHubDataGameOverlayClass;

#define GAME_HUB_DATA_TYPE_TWEAKABLE_GAME (game_hub_data_tweakable_game_get_type ())
#define GAME_HUB_DATA_TWEAKABLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGame))
#define GAME_HUB_DATA_IS_TWEAKABLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME))
#define GAME_HUB_DATA_TWEAKABLE_GAME_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGameIface))

typedef struct _GameHubDataTweakableGame GameHubDataTweakableGame;
typedef struct _GameHubDataTweakableGameIface GameHubDataTweakableGameIface;

#define GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME (game_hub_data_sources_humble_humble_game_get_type ())
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGame))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGameClass))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGameClass))

typedef struct _GameHubDataSourcesHumbleHumbleGame GameHubDataSourcesHumbleHumbleGame;
typedef struct _GameHubDataSourcesHumbleHumbleGameClass GameHubDataSourcesHumbleHumbleGameClass;
typedef struct _GameHubDataSourcesHumbleHumbleGamePrivate GameHubDataSourcesHumbleHumbleGamePrivate;

#define GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER (game_hub_data_runnable_installer_get_type ())
#define GAME_HUB_DATA_RUNNABLE_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstaller))
#define GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstallerClass))
#define GAME_HUB_DATA_RUNNABLE_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstallerClass))

typedef struct _GameHubDataRunnableInstaller GameHubDataRunnableInstaller;
typedef struct _GameHubDataRunnableInstallerClass GameHubDataRunnableInstallerClass;
enum  {
	GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_0_PROPERTY,
	GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TWEAKS_PROPERTY,
	GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLERS_PROPERTY,
	GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_DEFAULT_INSTALL_DIR_PROPERTY,
	GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_NUM_PROPERTIES
};
static GParamSpec* game_hub_data_sources_humble_humble_game_properties[GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAME_HUB_DATA_TYPE_GAME_SOURCE (game_hub_data_game_source_get_type ())
#define GAME_HUB_DATA_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSource))
#define GAME_HUB_DATA_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))
#define GAME_HUB_DATA_IS_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_IS_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME_SOURCE))
#define GAME_HUB_DATA_GAME_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME_SOURCE, GameHubDataGameSourceClass))

typedef struct _GameHubDataGameSource GameHubDataGameSource;
typedef struct _GameHubDataGameSourceClass GameHubDataGameSourceClass;

#define GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE (game_hub_data_sources_humble_humble_get_type ())
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumble))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumbleClass))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_HUMBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumbleClass))

typedef struct _GameHubDataSourcesHumbleHumble GameHubDataSourcesHumbleHumble;
typedef struct _GameHubDataSourcesHumbleHumbleClass GameHubDataSourcesHumbleHumbleClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define GAME_HUB_DATA_DB_TABLE_TYPE_FIELD (game_hub_data_db_table_field_get_type ())
#define GAME_HUB_DATA_DB_TABLE_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableField))
#define GAME_HUB_DATA_DB_TABLE_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))

typedef struct _GameHubDataDBTableField GameHubDataDBTableField;
typedef struct _GameHubDataDBTableFieldClass GameHubDataDBTableFieldClass;

#define GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG (game_hub_data_db_tables_tags_tag_get_type ())
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTag))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG))
#define GAME_HUB_DATA_DB_TABLES_TAGS_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLES_TAGS_TYPE_TAG, GameHubDataDBTablesTagsTagClass))

typedef struct _GameHubDataDBTablesTagsTag GameHubDataDBTablesTagsTag;
typedef struct _GameHubDataDBTablesTagsTagClass GameHubDataDBTablesTagsTagClass;
typedef struct _GameHubDataGameStatusPrivate GameHubDataGameStatusPrivate;
typedef enum  {
	GAME_HUB_DATA_GAME_STATE_UNINSTALLED,
	GAME_HUB_DATA_GAME_STATE_INSTALLED,
	GAME_HUB_DATA_GAME_STATE_DOWNLOADING,
	GAME_HUB_DATA_GAME_STATE_VERIFYING_INSTALLER_INTEGRITY,
	GAME_HUB_DATA_GAME_STATE_INSTALLING
} GameHubDataGameState;

#define GAME_HUB_DATA_GAME_TYPE_STATE (game_hub_data_game_state_get_type ())

#define GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD (game_hub_utils_downloader_download_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownload))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_IS_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_TYPE_DOWNLOAD, GameHubUtilsDownloaderDownloadClass))

typedef struct _GameHubUtilsDownloaderDownload GameHubUtilsDownloaderDownload;
typedef struct _GameHubUtilsDownloaderDownloadClass GameHubUtilsDownloaderDownloadClass;

#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS (game_hub_utils_downloader_download_status_get_type ())
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatus))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatusClass))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_IS_STATUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_IS_STATUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS))
#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATUS, GameHubUtilsDownloaderDownloadStatusClass))

typedef struct _GameHubUtilsDownloaderDownloadStatus GameHubUtilsDownloaderDownloadStatus;
typedef struct _GameHubUtilsDownloaderDownloadStatusClass GameHubUtilsDownloaderDownloadStatusClass;
typedef struct _GameHubUtilsDownloaderDownloadStatusPrivate GameHubUtilsDownloaderDownloadStatusPrivate;
typedef enum  {
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_QUEUED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_STARTING,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_STARTED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_DOWNLOADING,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_FINISHED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_PAUSED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_CANCELLED,
	GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_FAILED
} GameHubUtilsDownloaderDownloadState;

#define GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_TYPE_STATE (game_hub_utils_downloader_download_state_get_type ())
#define _game_hub_data_game_status_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_game_status_unref (var), NULL)))
typedef struct _GameHubDataGameSourcePrivate GameHubDataGameSourcePrivate;
typedef void (*GameHubUtilsFutureResult2) (gconstpointer t, gconstpointer t2, gpointer user_data);
typedef void (*GameHubUtilsFuture) (gpointer user_data);
typedef struct _GameHubDataSourcesHumbleHumblePrivate GameHubDataSourcesHumbleHumblePrivate;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData;

#define GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE (game_hub_data_sources_humble_trove_get_type ())
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE, GameHubDataSourcesHumbleTrove))
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE, GameHubDataSourcesHumbleTroveClass))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_TROVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_IS_TROVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE))
#define GAME_HUB_DATA_SOURCES_HUMBLE_TROVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_TROVE, GameHubDataSourcesHumbleTroveClass))

typedef struct _GameHubDataSourcesHumbleTrove GameHubDataSourcesHumbleTrove;
typedef struct _GameHubDataSourcesHumbleTroveClass GameHubDataSourcesHumbleTroveClass;
typedef GNotification* (*GameHubUtilsNotificationConfigureDelegate) (GNotification* notification, gpointer user_data);
typedef struct _GameHubDataSourcesHumbleHumbleGameUpdateInstallersData GameHubDataSourcesHumbleHumbleGameUpdateInstallersData;

#define GAME_HUB_DATA_RUNNABLE_TYPE_DOWNLOADABLE_INSTALLER (game_hub_data_runnable_downloadable_installer_get_type ())
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_DOWNLOADABLE_INSTALLER, GameHubDataRunnableDownloadableInstaller))
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_DOWNLOADABLE_INSTALLER, GameHubDataRunnableDownloadableInstallerClass))
#define GAME_HUB_DATA_RUNNABLE_IS_DOWNLOADABLE_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_DOWNLOADABLE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_IS_DOWNLOADABLE_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_DOWNLOADABLE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_DOWNLOADABLE_INSTALLER, GameHubDataRunnableDownloadableInstallerClass))

typedef struct _GameHubDataRunnableDownloadableInstaller GameHubDataRunnableDownloadableInstaller;
typedef struct _GameHubDataRunnableDownloadableInstallerClass GameHubDataRunnableDownloadableInstallerClass;

#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER (game_hub_data_sources_humble_humble_game_installer_get_type ())
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER, GameHubDataSourcesHumbleHumbleGameInstaller))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER, GameHubDataSourcesHumbleHumbleGameInstallerClass))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER))
#define GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER, GameHubDataSourcesHumbleHumbleGameInstallerClass))

typedef struct _GameHubDataSourcesHumbleHumbleGameInstaller GameHubDataSourcesHumbleHumbleGameInstaller;
typedef struct _GameHubDataSourcesHumbleHumbleGameInstallerClass GameHubDataSourcesHumbleHumbleGameInstallerClass;
typedef struct _GameHubDataRunnableInstallerPrivate GameHubDataRunnableInstallerPrivate;

#define GAME_HUB_DATA_TYPE_COMPAT_TOOL (game_hub_data_compat_tool_get_type ())
#define GAME_HUB_DATA_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatTool))
#define GAME_HUB_DATA_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))
#define GAME_HUB_DATA_IS_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_IS_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_COMPAT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))

typedef struct _GameHubDataCompatTool GameHubDataCompatTool;
typedef struct _GameHubDataCompatToolClass GameHubDataCompatToolClass;
typedef struct _GameHubDataRunnableDownloadableInstallerPrivate GameHubDataRunnableDownloadableInstallerPrivate;
typedef struct _GameHubDataSourcesHumbleHumbleGameInstallerPrivate GameHubDataSourcesHumbleHumbleGameInstallerPrivate;

#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_TYPE_PART (game_hub_data_runnable_downloadable_installer_part_get_type ())
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_PART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_TYPE_PART, GameHubDataRunnableDownloadableInstallerPart))
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_PART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_TYPE_PART, GameHubDataRunnableDownloadableInstallerPartClass))
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_IS_PART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_TYPE_PART))
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_IS_PART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_TYPE_PART))
#define GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_PART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_RUNNABLE_DOWNLOADABLE_INSTALLER_TYPE_PART, GameHubDataRunnableDownloadableInstallerPartClass))

typedef struct _GameHubDataRunnableDownloadableInstallerPart GameHubDataRunnableDownloadableInstallerPart;
typedef struct _GameHubDataRunnableDownloadableInstallerPartClass GameHubDataRunnableDownloadableInstallerPartClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _game_hub_data_runnable_installer_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_runnable_installer_unref (var), NULL)))

#define GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG (game_hub_ui_dialogs_install_dialog_get_type ())
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialog))
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialogClass))
#define GAME_HUB_UI_DIALOGS_IS_INSTALL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG))
#define GAME_HUB_UI_DIALOGS_IS_INSTALL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG))
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialogClass))

typedef struct _GameHubUIDialogsInstallDialog GameHubUIDialogsInstallDialog;
typedef struct _GameHubUIDialogsInstallDialogClass GameHubUIDialogsInstallDialogClass;
typedef struct _GameHubDataSourcesHumbleHumbleGameInstallData GameHubDataSourcesHumbleHumbleGameInstallData;
typedef struct _GameHubDataSourcesHumbleHumbleGameUninstallData GameHubDataSourcesHumbleHumbleGameUninstallData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GameHubDataRunnable {
	GObject parent_instance;
	GameHubDataRunnablePrivate * priv;
};

struct _GameHubDataRunnableClass {
	GObjectClass parent_class;
	gboolean (*is_supported) (GameHubDataRunnable* self, GameHubDataPlatform* platform, gboolean with_compat);
	void (*install) (GameHubDataRunnable* self, GameHubDataRunnableInstallerInstallMode install_mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	void (*run) (GameHubDataRunnable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	gboolean (*can_be_launched) (GameHubDataRunnable* self, gboolean is_launch_attempt);
	void (*run_with_compat) (GameHubDataRunnable* self, gboolean is_opened_from_menu, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_with_compat_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	GtkFileChooser* (*setup_executable_chooser) (GameHubDataRunnable* self);
	void (*choose_executable) (GameHubDataRunnable* self, gboolean update);
	void (*set_chosen_executable) (GameHubDataRunnable* self, GFile* file, gboolean update);
	void (*save) (GameHubDataRunnable* self);
	void (*update_status) (GameHubDataRunnable* self);
	void (*import) (GameHubDataRunnable* self, gboolean update);
	GFile* (*get_executable) (GameHubDataRunnable* self);
	void (*set_executable) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_work_dir) (GameHubDataRunnable* self);
	void (*set_work_dir) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_default_install_dir) (GameHubDataRunnable* self);
};

struct _GameHubDataGame {
	GameHubDataRunnable parent_instance;
	GameHubDataGamePrivate * priv;
	GameHubDataGameStatus* _status;
	GeeArrayList* overlays;
	gchar* executable_path;
	gchar* work_dir_path;
};

struct _GameHubDataGameClass {
	GameHubDataRunnableClass parent_class;
	void (*uninstall) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*uninstall_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*update_game_info) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_game_info_finish) (GameHubDataGame* self, GAsyncResult* _res_);
	void (*load_achievements) (GameHubDataGame* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeArrayList* (*load_achievements_finish) (GameHubDataGame* self, GAsyncResult* _res_);
};

struct _GameHubDataTweakableGameIface {
	GTypeInterface parent_iface;
	gchar** (*get_tweaks) (GameHubDataTweakableGame* self, gint* result_length1);
	void (*set_tweaks) (GameHubDataTweakableGame* self, gchar** value, gint value_length1);
};

struct _GameHubDataSourcesHumbleHumbleGame {
	GameHubDataGame parent_instance;
	GameHubDataSourcesHumbleHumbleGamePrivate * priv;
	gchar* order_id;
};

struct _GameHubDataSourcesHumbleHumbleGameClass {
	GameHubDataGameClass parent_class;
};

struct _GameHubDataSourcesHumbleHumbleGamePrivate {
	gchar** _tweaks;
	gint _tweaks_length1;
	gint __tweaks_size_;
	gboolean game_info_updating;
	gboolean game_info_updated;
	gboolean game_info_refreshed;
	GeeArrayList* _installers;
};

struct _GameHubDataGameStatus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameStatusPrivate * priv;
	GameHubDataGameState state;
	GameHubDataGame* game;
	GameHubUtilsDownloaderDownload* download;
};

struct _GameHubDataGameStatusClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameStatus *self);
};

struct _GameHubUtilsDownloaderDownloadStatus {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubUtilsDownloaderDownloadStatusPrivate * priv;
	GameHubUtilsDownloaderDownloadState state;
};

struct _GameHubUtilsDownloaderDownloadStatusClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubUtilsDownloaderDownloadStatus *self);
	gdouble (*get_progress) (GameHubUtilsDownloaderDownloadStatus* self);
	gchar* (*get_progress_string) (GameHubUtilsDownloaderDownloadStatus* self);
};

struct _GameHubDataGameSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataGameSourcePrivate * priv;
};

struct _GameHubDataGameSourceClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataGameSource *self);
	gboolean (*is_installed) (GameHubDataGameSource* self, gboolean refresh);
	void (*install) (GameHubDataGameSource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*install_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	void (*authenticate) (GameHubDataGameSource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*authenticate_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	gboolean (*is_authenticated) (GameHubDataGameSource* self);
	gboolean (*can_authenticate_automatically) (GameHubDataGameSource* self);
	void (*load_games) (GameHubDataGameSource* self, GameHubUtilsFutureResult2 game_loaded, gpointer game_loaded_target, GameHubUtilsFuture cache_loaded, gpointer cache_loaded_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeArrayList* (*load_games_finish) (GameHubDataGameSource* self, GAsyncResult* _res_);
	const gchar* (*get_id) (GameHubDataGameSource* self);
	const gchar* (*get_name) (GameHubDataGameSource* self);
	gchar* (*get_name_from) (GameHubDataGameSource* self);
	const gchar* (*get_icon) (GameHubDataGameSource* self);
	gchar* (*get_auth_description) (GameHubDataGameSource* self);
	gboolean (*get_enabled) (GameHubDataGameSource* self);
	void (*set_enabled) (GameHubDataGameSource* self, gboolean value);
	GeeArrayList* (*get_games) (GameHubDataGameSource* self);
};

struct _GameHubDataSourcesHumbleHumble {
	GameHubDataGameSource parent_instance;
	GameHubDataSourcesHumbleHumblePrivate * priv;
	gchar* user_token;
};

struct _GameHubDataSourcesHumbleHumbleClass {
	GameHubDataGameSourceClass parent_class;
};

struct _GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesHumbleHumbleGame* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	JsonObject* i;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	JsonNode* _tmp15_;
	JsonNode* _tmp16_;
	JsonObject* _tmp17_;
	JsonObject* _tmp18_;
	JsonObject* _tmp19_;
	JsonObject* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gchar* token;
	GameHubDataGameSource* _tmp36_;
	GameHubDataGameSource* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GeeHashMap* headers;
	GeeHashMap* _tmp40_;
	GeeHashMap* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	JsonNode* root_node;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GeeHashMap* _tmp51_;
	JsonNode* _tmp52_;
	JsonNode* _tmp53_;
	gboolean _tmp54_;
	JsonNode* _tmp55_;
	JsonNode* _tmp56_;
	JsonObject* root;
	JsonNode* _tmp57_;
	JsonObject* _tmp58_;
	JsonObject* _tmp59_;
	JsonObject* _tmp60_;
	JsonArray* products;
	JsonObject* _tmp61_;
	JsonArray* _tmp62_;
	JsonArray* _tmp63_;
	JsonArray* _tmp64_;
	JsonArray* _tmp65_;
	GList* _tmp66_;
	GList* product_node_collection;
	GList* product_node_it;
	JsonNode* product_node;
	JsonNode* _tmp67_;
	JsonObject* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	JsonNode* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	JsonNode* _vala1_product_node;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	JsonNode* _tmp77_;
	gboolean _tmp78_;
	JsonNode* _tmp79_;
	JsonNode* _tmp80_;
	JsonObject* product;
	JsonNode* _tmp81_;
	JsonObject* _tmp82_;
	JsonObject* _tmp83_;
	JsonObject* _tmp84_;
	JsonObject* _tmp85_;
	JsonObject* _tmp86_;
	const gchar* _tmp87_;
	JsonObject* _tmp88_;
	JsonObject* _tmp89_;
	const gchar* _tmp90_;
};

struct _GameHubDataSourcesHumbleHumbleGameUpdateInstallersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesHumbleHumbleGame* self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	JsonNode* product_node;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	JsonNode* _tmp5_;
	gboolean _tmp6_;
	JsonNode* _tmp7_;
	JsonNode* _tmp8_;
	JsonObject* product;
	JsonNode* _tmp9_;
	JsonObject* _tmp10_;
	JsonObject* _tmp11_;
	JsonObject* _tmp12_;
	JsonObject* _tmp13_;
	gboolean refresh;
	JsonNode* downloads_node;
	JsonObject* _tmp14_;
	JsonNode* _tmp15_;
	JsonNode* _tmp16_;
	JsonNode* _tmp17_;
	JsonNode* _tmp18_;
	JsonArray* _tmp19_;
	GList* _tmp20_;
	GList* dl_node_collection;
	GList* dl_node_it;
	JsonNode* dl_node;
	JsonObject* dl;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	gchar* id;
	JsonObject* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	JsonObject* _tmp28_;
	JsonObject* _tmp29_;
	const gchar* _tmp30_;
	gchar* dl_id;
	gchar* _tmp31_;
	gchar* os;
	JsonObject* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_;
	JsonObject* _tmp36_;
	JsonObject* _tmp37_;
	JsonNode* _tmp38_;
	JsonObject* _tmp39_;
	JsonArray* _tmp40_;
	GList* _tmp41_;
	GList* dls_node_collection;
	GList* dls_node_it;
	JsonNode* dls_node;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	JsonNode* _tmp45_;
	JsonObject* _tmp46_;
	JsonNode* _tmp47_;
	JsonObject* _tmp48_;
	GList* _tmp49_;
	GList* os_collection;
	GList* os_it;
	const gchar* _vala1_os;
	JsonObject* _vala1_dl;
	JsonNode* _tmp50_;
	JsonObject* _tmp51_;
	const gchar* _tmp52_;
	JsonObject* _tmp53_;
	JsonObject* _tmp54_;
	gchar* _vala1_id;
	JsonObject* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	JsonObject* _tmp59_;
	JsonObject* _tmp60_;
	const gchar* _tmp61_;
	gchar* _vala1_dl_id;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	JsonObject* _tmp66_;
	gboolean _tmp67_;
	GeeArrayList* _tmp68_;
	GeeArrayList* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gboolean _tmp72_;
	GeeArrayList* _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	GameHubDataGameSource* _tmp76_;
	GameHubDataGameSource* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
};

struct _GameHubDataRunnableInstaller {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataRunnableInstallerPrivate * priv;
};

struct _GameHubDataRunnableInstallerClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataRunnableInstaller *self);
	void (*install) (GameHubDataRunnableInstaller* self, GameHubDataRunnable* runnable, GameHubDataCompatTool* tool, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnableInstaller* self, GAsyncResult* _res_);
	gchar* (*get_name) (GameHubDataRunnableInstaller* self);
};

struct _GameHubDataRunnableDownloadableInstaller {
	GameHubDataRunnableInstaller parent_instance;
	GameHubDataRunnableDownloadableInstallerPrivate * priv;
};

struct _GameHubDataRunnableDownloadableInstallerClass {
	GameHubDataRunnableInstallerClass parent_class;
	void (*fetch_parts) (GameHubDataRunnableDownloadableInstaller* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*fetch_parts_finish) (GameHubDataRunnableDownloadableInstaller* self, GAsyncResult* _res_);
};

struct _GameHubDataSourcesHumbleHumbleGameInstaller {
	GameHubDataRunnableDownloadableInstaller parent_instance;
	GameHubDataSourcesHumbleHumbleGameInstallerPrivate * priv;
	gchar* dl_name;
	gchar* dl_id;
	GameHubDataRunnableDownloadableInstallerPart* part;
};

struct _GameHubDataSourcesHumbleHumbleGameInstallerClass {
	GameHubDataRunnableDownloadableInstallerClass parent_class;
};

struct _GameHubDataSourcesHumbleHumbleGameInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesHumbleHumbleGame* self;
	GameHubDataRunnableInstallerInstallMode install_mode;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GameHubUIDialogsInstallDialog* _tmp4_;
	GameHubUIDialogsInstallDialog* _tmp5_;
};

struct _GameHubDataSourcesHumbleHumbleGameUninstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataSourcesHumbleHumbleGame* self;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gboolean _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gboolean _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp22_;
};

struct _GameHubDataSourcesHumbleHumbleGameInstallerPrivate {
	GFile* installers_dir;
};

static gint GameHubDataSourcesHumbleHumbleGame_private_offset;
static gpointer game_hub_data_sources_humble_humble_game_parent_class = NULL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ID;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_NAME;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INFO;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INFO_DETAILED;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ICON;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_IMAGE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_INSTALL_PATH;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_EXECUTABLE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_WORK_DIR;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_COMPAT_TOOL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_COMPAT_TOOL_SETTINGS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_ARGUMENTS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_LAST_LAUNCH;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLAYTIME_SOURCE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLAYTIME_TRACKED;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_IMAGE_VERTICAL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_PLATFORMS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_TAGS;
VALA_EXTERN GeeArrayList* game_hub_data_db_tables_tags_TAGS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_games_TWEAKS;
VALA_EXTERN GameHubDataDBTablesTagsTag* game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
VALA_EXTERN GameHubDataDBTablesTagsTag* game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
static gint GameHubDataSourcesHumbleHumbleGameInstaller_private_offset;
static gpointer game_hub_data_sources_humble_humble_game_installer_parent_class = NULL;
VALA_EXTERN gboolean game_hub_application_log_verbose;
static GameHubDataTweakableGameIface * game_hub_data_sources_humble_humble_game_game_hub_data_tweakable_game_parent_iface = NULL;

VALA_EXTERN GType game_hub_data_runnable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnable, g_object_unref)
VALA_EXTERN GType game_hub_data_platform_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_runnable_installer_install_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGame, g_object_unref)
VALA_EXTERN gpointer game_hub_data_game_achievement_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_achievement_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_achievement (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_achievement (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_achievement (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_achievement (const GValue* value);
VALA_EXTERN GType game_hub_data_game_achievement_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameAchievement, game_hub_data_game_achievement_unref)
VALA_EXTERN gpointer game_hub_data_game_status_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_status_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_game_param_spec_status (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_game_value_set_status (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_game_value_take_status (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_game_value_get_status (const GValue* value);
VALA_EXTERN GType game_hub_data_game_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameStatus, game_hub_data_game_status_unref)
VALA_EXTERN GType game_hub_data_game_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameOverlay, g_object_unref)
VALA_EXTERN GType game_hub_data_tweakable_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataTweakableGame, g_object_unref)
VALA_EXTERN GType game_hub_data_sources_humble_humble_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesHumbleHumbleGame, g_object_unref)
VALA_EXTERN gpointer game_hub_data_runnable_installer_ref (gpointer instance);
VALA_EXTERN void game_hub_data_runnable_installer_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_runnable_param_spec_installer (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags);
VALA_EXTERN void game_hub_data_runnable_value_set_installer (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN void game_hub_data_runnable_value_take_installer (GValue* value,
                                                  gpointer v_object);
VALA_EXTERN gpointer game_hub_data_runnable_value_get_installer (const GValue* value);
VALA_EXTERN GType game_hub_data_runnable_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnableInstaller, game_hub_data_runnable_installer_unref)
VALA_EXTERN void game_hub_data_runnable_update_status (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_game_update_game_info (GameHubDataGame* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_update_game_info_finish (GameHubDataGame* self,
                                                 GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_install (GameHubDataRunnable* self,
                                     GameHubDataRunnableInstallerInstallMode install_mode,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_install_finish (GameHubDataRunnable* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_game_uninstall (GameHubDataGame* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_uninstall_finish (GameHubDataGame* self,
                                          GAsyncResult* _res_);
VALA_EXTERN GFile* game_hub_data_runnable_get_default_install_dir (GameHubDataRunnable* self);
VALA_EXTERN gpointer game_hub_data_game_source_ref (gpointer instance);
VALA_EXTERN void game_hub_data_game_source_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_param_spec_game_source (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void game_hub_data_value_set_game_source (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void game_hub_data_value_take_game_source (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_data_value_get_game_source (const GValue* value);
VALA_EXTERN GType game_hub_data_game_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGameSource, game_hub_data_game_source_unref)
VALA_EXTERN GType game_hub_data_sources_humble_humble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesHumbleHumble, game_hub_data_game_source_unref)
VALA_EXTERN GameHubDataSourcesHumbleHumbleGame* game_hub_data_sources_humble_humble_game_new (GameHubDataSourcesHumbleHumble* src,
                                                                                  const gchar* order,
                                                                                  JsonNode* json_node);
VALA_EXTERN GameHubDataSourcesHumbleHumbleGame* game_hub_data_sources_humble_humble_game_construct (GType object_type,
                                                                                        GameHubDataSourcesHumbleHumble* src,
                                                                                        const gchar* order,
                                                                                        JsonNode* json_node);
VALA_EXTERN GameHubDataGame* game_hub_data_game_construct (GType object_type);
VALA_EXTERN void game_hub_data_game_set_source (GameHubDataGame* self,
                                    GameHubDataGameSource* value);
VALA_EXTERN void game_hub_data_runnable_set_id (GameHubDataRunnable* self,
                                    const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_name (GameHubDataRunnable* self,
                                      const gchar* value);
VALA_EXTERN void game_hub_data_game_set_image (GameHubDataGame* self,
                                   const gchar* value);
VALA_EXTERN const gchar* game_hub_data_game_get_image (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_game_set_icon (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN void game_hub_data_game_set_info (GameHubDataGame* self,
                                  const gchar* value);
VALA_EXTERN GeeArrayList* game_hub_data_runnable_get_platforms (GameHubDataRunnable* self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
VALA_EXTERN gchar* game_hub_data_platform_id (GameHubDataPlatform self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN void game_hub_data_runnable_set_install_dir (GameHubDataRunnable* self,
                                             GFile* value);
VALA_EXTERN void game_hub_data_game_set_info_detailed (GameHubDataGame* self,
                                           const gchar* value);
VALA_EXTERN void game_hub_data_game_mount_overlays (GameHubDataGame* self,
                                        GFile* persist,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_mount_overlays_finish (GameHubDataGame* self,
                                               GAsyncResult* _res_);
VALA_EXTERN GameHubDataSourcesHumbleHumbleGame* game_hub_data_sources_humble_humble_game_new_from_db (GameHubDataSourcesHumbleHumble* src,
                                                                                          sqlite3_stmt* s);
VALA_EXTERN GameHubDataSourcesHumbleHumbleGame* game_hub_data_sources_humble_humble_game_construct_from_db (GType object_type,
                                                                                                GameHubDataSourcesHumbleHumble* src,
                                                                                                sqlite3_stmt* s);
VALA_EXTERN gpointer game_hub_data_db_table_field_ref (gpointer instance);
VALA_EXTERN void game_hub_data_db_table_field_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_db_table_param_spec_field (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void game_hub_data_db_table_value_set_field (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void game_hub_data_db_table_value_take_field (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer game_hub_data_db_table_value_get_field (const GValue* value);
VALA_EXTERN GType game_hub_data_db_table_field_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTableField, game_hub_data_db_table_field_unref)
VALA_EXTERN gchar* game_hub_data_db_table_field_get (GameHubDataDBTableField* self,
                                         sqlite3_stmt* s);
VALA_EXTERN GFile* game_hub_utils_fs_utils_file (const gchar* path,
                                     const gchar* file,
                                     GeeHashMap* variables);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool (GameHubDataRunnable* self,
                                             const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool_settings (GameHubDataRunnable* self,
                                                      const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_arguments (GameHubDataRunnable* self,
                                           const gchar* value);
VALA_EXTERN gint64 game_hub_data_db_table_field_get_int64 (GameHubDataDBTableField* self,
                                               sqlite3_stmt* s);
VALA_EXTERN void game_hub_data_game_set_last_launch (GameHubDataGame* self,
                                         gint64 value);
VALA_EXTERN void game_hub_data_game_set_playtime_source (GameHubDataGame* self,
                                             gint64 value);
VALA_EXTERN void game_hub_data_game_set_playtime_tracked (GameHubDataGame* self,
                                              gint64 value);
VALA_EXTERN void game_hub_data_game_set_image_vertical (GameHubDataGame* self,
                                            const gchar* value);
VALA_EXTERN GType game_hub_data_db_tables_tags_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTablesTagsTag, g_object_unref)
VALA_EXTERN GeeArrayList* game_hub_data_game_get_tags (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_db_tables_tags_tag_get_id (GameHubDataDBTablesTagsTag* self);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_json (const gchar* json);
VALA_EXTERN const gchar* game_hub_data_game_get_info_detailed (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_tweakable_game_set_tweaks (GameHubDataTweakableGame* self,
                                              gchar** value,
                                              gint value_length1);
static void game_hub_data_sources_humble_humble_game_real_update_status (GameHubDataRunnable* base);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_get_status (GameHubDataGame* self);
VALA_EXTERN GType game_hub_data_game_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer game_hub_utils_downloader_download_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_downloader_download_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_downloader_param_spec_download (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags);
VALA_EXTERN void game_hub_utils_downloader_value_set_download (GValue* value,
                                                   gpointer v_object);
VALA_EXTERN void game_hub_utils_downloader_value_take_download (GValue* value,
                                                    gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_downloader_value_get_download (const GValue* value);
VALA_EXTERN GType game_hub_utils_downloader_download_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownload, game_hub_utils_downloader_download_unref)
VALA_EXTERN gpointer game_hub_utils_downloader_download_status_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_downloader_download_status_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_downloader_download_param_spec_status (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags);
VALA_EXTERN void game_hub_utils_downloader_download_value_set_status (GValue* value,
                                                          gpointer v_object);
VALA_EXTERN void game_hub_utils_downloader_download_value_take_status (GValue* value,
                                                           gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_downloader_download_value_get_status (const GValue* value);
VALA_EXTERN GType game_hub_utils_downloader_download_status_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsDownloaderDownloadStatus, game_hub_utils_downloader_download_status_unref)
VALA_EXTERN GameHubUtilsDownloaderDownloadStatus* game_hub_utils_downloader_download_get_status (GameHubUtilsDownloaderDownload* self);
VALA_EXTERN GType game_hub_utils_downloader_download_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GFile* game_hub_data_runnable_get_executable (GameHubDataRunnable* self);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_new (GameHubDataGameState state,
                                                      GameHubDataGame* game,
                                                      GameHubUtilsDownloaderDownload* download);
VALA_EXTERN GameHubDataGameStatus* game_hub_data_game_status_construct (GType object_type,
                                                            GameHubDataGameState state,
                                                            GameHubDataGame* game,
                                                            GameHubUtilsDownloaderDownload* download);
VALA_EXTERN void game_hub_data_game_set_status (GameHubDataGame* self,
                                    GameHubDataGameStatus* value);
VALA_EXTERN void game_hub_data_game_remove_tag (GameHubDataGame* self,
                                    GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN void game_hub_data_game_add_tag (GameHubDataGame* self,
                                 GameHubDataDBTablesTagsTag* tag);
VALA_EXTERN gchar* game_hub_utils_fs_utils_paths_collection_humble_expand_installers (const gchar* game,
                                                                          GameHubDataPlatform* platform);
VALA_EXTERN const gchar* game_hub_data_runnable_get_name (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_game_set_installers_dir (GameHubDataGame* self,
                                            GFile* value);
VALA_EXTERN void game_hub_data_game_update_version (GameHubDataGame* self);
static void game_hub_data_sources_humble_humble_game_real_update_game_info_data_free (gpointer _data);
static void game_hub_data_sources_humble_humble_game_real_update_game_info (GameHubDataGame* base,
                                                                     GAsyncReadyCallback _callback_,
                                                                     gpointer _user_data_);
static gboolean game_hub_data_sources_humble_humble_game_real_update_game_info_co (GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData* _data_);
static void game_hub_data_sources_humble_humble_game_update_game_info_ready (GObject* source_object,
                                                                      GAsyncResult* _res_,
                                                                      gpointer _user_data_);
VALA_EXTERN const gchar* game_hub_data_game_get_icon (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_game_get_info (GameHubDataGame* self);
VALA_EXTERN GameHubDataGameSource* game_hub_data_game_get_source (GameHubDataGame* self);
VALA_EXTERN void game_hub_utils_parser_parse_remote_json_file_async (const gchar* url,
                                                         const gchar* method,
                                                         const gchar* auth,
                                                         GeeHashMap* headers,
                                                         GeeHashMap* data,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
VALA_EXTERN JsonNode* game_hub_utils_parser_parse_remote_json_file_finish (GAsyncResult* _res_,
                                                               guint* status);
VALA_EXTERN const gchar* game_hub_data_runnable_get_id (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_game_set_description (GameHubDataGame* self,
                                         const gchar* value);
VALA_EXTERN void game_hub_data_runnable_save (GameHubDataRunnable* self);
static void game_hub_data_sources_humble_humble_game_update_installers_data_free (gpointer _data);
static void game_hub_data_sources_humble_humble_game_update_installers (GameHubDataSourcesHumbleHumbleGame* self,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static void game_hub_data_sources_humble_humble_game_update_installers_finish (GameHubDataSourcesHumbleHumbleGame* self,
                                                                        GAsyncResult* _res_);
static gboolean game_hub_data_sources_humble_humble_game_update_installers_co (GameHubDataSourcesHumbleHumbleGameUpdateInstallersData* _data_);
VALA_EXTERN GeeArrayList* game_hub_data_sources_humble_humble_game_get_installers (GameHubDataSourcesHumbleHumbleGame* self);
static gboolean game_hub_data_sources_humble_humble_game_process_download (GameHubDataSourcesHumbleHumbleGame* self,
                                                                    const gchar* id,
                                                                    const gchar* dl_id,
                                                                    const gchar* os,
                                                                    JsonObject* dl_struct);
static void game_hub_data_sources_humble_humble_game_update_installers_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_set_is_installable (GameHubDataGame* self,
                                            gboolean value);
VALA_EXTERN GType game_hub_data_sources_humble_trove_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesHumbleTrove, game_hub_data_game_source_unref)
VALA_EXTERN void game_hub_utils_notify (const gchar* title,
                            const gchar* body,
                            GNotificationPriority priority,
                            GameHubUtilsNotificationConfigureDelegate config,
                            gpointer config_target);
static GNotification* ___lambda51_ (GameHubDataSourcesHumbleHumbleGame* self,
                             GNotification* n);
VALA_EXTERN GFile* game_hub_utils_image_cache_local_file (const gchar* url,
                                              const gchar* prefix);
VALA_EXTERN const gchar* game_hub_data_game_source_get_id (GameHubDataGameSource* self);
static GNotification* ____lambda51__game_hub_utils_notification_configure_delegate (GNotification* notification,
                                                                             gpointer self);
VALA_EXTERN GType game_hub_data_runnable_downloadable_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnableDownloadableInstaller, game_hub_data_runnable_installer_unref)
VALA_EXTERN GType game_hub_data_sources_humble_humble_game_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataSourcesHumbleHumbleGameInstaller, game_hub_data_runnable_installer_unref)
VALA_EXTERN GameHubDataSourcesHumbleHumbleGameInstaller* game_hub_data_sources_humble_humble_game_installer_new (GameHubDataSourcesHumbleHumbleGame* game,
                                                                                                     const gchar* machine_name,
                                                                                                     const gchar* download_identifier,
                                                                                                     GameHubDataPlatform platform,
                                                                                                     JsonObject* download);
VALA_EXTERN GameHubDataSourcesHumbleHumbleGameInstaller* game_hub_data_sources_humble_humble_game_installer_construct (GType object_type,
                                                                                                           GameHubDataSourcesHumbleHumbleGame* game,
                                                                                                           const gchar* machine_name,
                                                                                                           const gchar* download_identifier,
                                                                                                           GameHubDataPlatform platform,
                                                                                                           JsonObject* download);
VALA_EXTERN gboolean game_hub_data_sources_humble_humble_game_installer_is_url_update_required (GameHubDataSourcesHumbleHumbleGameInstaller* self);
VALA_EXTERN GType game_hub_data_compat_tool_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataCompatTool, g_object_unref)
VALA_EXTERN GType game_hub_data_runnable_downloadable_installer_part_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnableDownloadableInstallerPart, g_object_unref)
VALA_EXTERN const gchar* game_hub_data_runnable_downloadable_installer_part_get_url (GameHubDataRunnableDownloadableInstallerPart* self);
VALA_EXTERN gchar* game_hub_data_sources_humble_humble_game_installer_update_url (GameHubDataSourcesHumbleHumbleGameInstaller* self,
                                                                      GameHubDataSourcesHumbleHumbleGame* game);
static void game_hub_data_sources_humble_humble_game_real_install_data_free (gpointer _data);
static void game_hub_data_sources_humble_humble_game_real_install (GameHubDataRunnable* base,
                                                            GameHubDataRunnableInstallerInstallMode install_mode,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gboolean game_hub_data_sources_humble_humble_game_real_install_co (GameHubDataSourcesHumbleHumbleGameInstallData* _data_);
static void game_hub_data_sources_humble_humble_game_install_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static gboolean _game_hub_data_sources_humble_humble_game_real_install_co_gsource_func (gpointer self);
VALA_EXTERN GameHubUIDialogsInstallDialog* game_hub_ui_dialogs_install_dialog_new (GameHubDataRunnable* runnable,
                                                                       GeeArrayList* installers,
                                                                       GameHubDataRunnableInstallerInstallMode install_mode,
                                                                       GSourceFunc callback,
                                                                       gpointer callback_target,
                                                                       GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN GameHubUIDialogsInstallDialog* game_hub_ui_dialogs_install_dialog_construct (GType object_type,
                                                                             GameHubDataRunnable* runnable,
                                                                             GeeArrayList* installers,
                                                                             GameHubDataRunnableInstallerInstallMode install_mode,
                                                                             GSourceFunc callback,
                                                                             gpointer callback_target,
                                                                             GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN GType game_hub_ui_dialogs_install_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUIDialogsInstallDialog, g_object_unref)
static void game_hub_data_sources_humble_humble_game_real_uninstall_data_free (gpointer _data);
static void game_hub_data_sources_humble_humble_game_real_uninstall (GameHubDataGame* base,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean game_hub_data_sources_humble_humble_game_real_uninstall_co (GameHubDataSourcesHumbleHumbleGameUninstallData* _data_);
VALA_EXTERN GFile* game_hub_data_runnable_get_install_dir (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_game_umount_overlays (GameHubDataGame* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void game_hub_data_game_umount_overlays_finish (GameHubDataGame* self,
                                                GAsyncResult* _res_);
static void game_hub_data_sources_humble_humble_game_uninstall_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
VALA_EXTERN void game_hub_utils_fs_utils_rm (const gchar* path,
                                 const gchar* file,
                                 const gchar* flags,
                                 GeeHashMap* variables);
VALA_EXTERN void game_hub_data_runnable_set_executable (GameHubDataRunnable* self,
                                            GFile* value);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
VALA_EXTERN void game_hub_data_sources_humble_humble_game_set_installers (GameHubDataSourcesHumbleHumbleGame* self,
                                                              GeeArrayList* value);
VALA_EXTERN gchar* game_hub_utils_fs_utils_paths_humble_get_Games (void);
VALA_EXTERN const gchar* game_hub_data_runnable_get_escaped_name (GameHubDataRunnable* self);
VALA_EXTERN gchar* game_hub_data_runnable_installer_get_name (GameHubDataRunnableInstaller* self);
VALA_EXTERN GameHubDataRunnableDownloadableInstaller* game_hub_data_runnable_downloadable_installer_construct (GType object_type);
VALA_EXTERN void game_hub_data_runnable_installer_set_id (GameHubDataRunnableInstaller* self,
                                              const gchar* value);
VALA_EXTERN void game_hub_data_runnable_installer_set_platform (GameHubDataRunnableInstaller* self,
                                                    GameHubDataPlatform value);
VALA_EXTERN void game_hub_data_runnable_installer_set_full_size (GameHubDataRunnableInstaller* self,
                                                     gint64 value);
VALA_EXTERN GFile* game_hub_data_game_get_installers_dir (GameHubDataGame* self);
VALA_EXTERN const gchar* game_hub_data_runnable_installer_get_id (GameHubDataRunnableInstaller* self);
VALA_EXTERN gint64 game_hub_data_runnable_installer_get_full_size (GameHubDataRunnableInstaller* self);
VALA_EXTERN GameHubDataRunnableDownloadableInstallerPart* game_hub_data_runnable_downloadable_installer_part_new (const gchar* id,
                                                                                                      const gchar* url,
                                                                                                      gint64 size,
                                                                                                      GFile* remote,
                                                                                                      GFile* local,
                                                                                                      const gchar* checksum,
                                                                                                      GChecksumType checksum_type);
VALA_EXTERN GameHubDataRunnableDownloadableInstallerPart* game_hub_data_runnable_downloadable_installer_part_construct (GType object_type,
                                                                                                            const gchar* id,
                                                                                                            const gchar* url,
                                                                                                            gint64 size,
                                                                                                            GFile* remote,
                                                                                                            GFile* local,
                                                                                                            const gchar* checksum,
                                                                                                            GChecksumType checksum_type);
VALA_EXTERN GeeArrayList* game_hub_data_runnable_downloadable_installer_get_parts (GameHubDataRunnableDownloadableInstaller* self);
VALA_EXTERN gchar* game_hub_data_sources_humble_trove_sign_url (const gchar* machine_name,
                                                    const gchar* filename,
                                                    const gchar* humble_token);
VALA_EXTERN gchar* game_hub_data_game_get_full_id (GameHubDataGame* self);
VALA_EXTERN void game_hub_data_runnable_downloadable_installer_part_set_url (GameHubDataRunnableDownloadableInstallerPart* self,
                                                                 const gchar* value);
static void game_hub_data_sources_humble_humble_game_installer_finalize (GameHubDataRunnableInstaller * obj);
static GType game_hub_data_sources_humble_humble_game_installer_get_type_once (void);
VALA_EXTERN gchar** game_hub_data_tweakable_game_get_tweaks (GameHubDataTweakableGame* self,
                                                 gint* result_length1);
static void game_hub_data_sources_humble_humble_game_finalize (GObject * obj);
static GType game_hub_data_sources_humble_humble_game_get_type_once (void);
static void _vala_game_hub_data_sources_humble_humble_game_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_game_hub_data_sources_humble_humble_game_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const GameHubDataPlatform GAME_HUB_DATA_PLATFORM_PLATFORMS[4];

static inline gpointer
game_hub_data_sources_humble_humble_game_get_instance_private (GameHubDataSourcesHumbleHumbleGame* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataSourcesHumbleHumbleGame_private_offset);
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 49 "../src/data/sources/humble/HumbleGame.vala"
	return self ? json_object_ref (self) : NULL;
#line 1222 "HumbleGame.c"
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
#line 63 "../src/data/sources/humble/HumbleGame.vala"
	return g_boxed_copy (json_node_get_type (), self);
#line 1230 "HumbleGame.c"
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
#line 63 "../src/data/sources/humble/HumbleGame.vala"
	return self ? _vala_JsonNode_copy (self) : NULL;
#line 1238 "HumbleGame.c"
}

static void
_vala_JsonNode_free (JsonNode* self)
{
#line 61 "../src/data/sources/humble/HumbleGame.vala"
	g_boxed_free (json_node_get_type (), self);
#line 1246 "HumbleGame.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 1259 "HumbleGame.c"
}

GameHubDataSourcesHumbleHumbleGame*
game_hub_data_sources_humble_humble_game_construct (GType object_type,
                                                    GameHubDataSourcesHumbleHumble* src,
                                                    const gchar* order,
                                                    JsonNode* json_node)
{
	GameHubDataSourcesHumbleHumbleGame * self = NULL;
	JsonObject* json_obj = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	JsonObject* _tmp5_;
	const gchar* _tmp10_ = NULL;
	JsonObject* _tmp11_;
	const gchar* _tmp16_ = NULL;
	JsonObject* _tmp17_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	JsonObject* _tmp27_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
#line 45 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 45 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (order != NULL, NULL);
#line 45 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (json_node != NULL, NULL);
#line 45 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) game_hub_data_game_construct (object_type);
#line 47 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_source ((GameHubDataGame*) self, (GameHubDataGameSource*) src);
#line 49 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = json_node_get_object (json_node);
#line 49 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = _json_object_ref0 (_tmp0_);
#line 49 "../src/data/sources/humble/HumbleGame.vala"
	json_obj = _tmp1_;
#line 51 "../src/data/sources/humble/HumbleGame.vala"
	_tmp2_ = json_obj;
#line 51 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = json_object_get_string_member (_tmp2_, "machine_name");
#line 51 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp3_);
#line 52 "../src/data/sources/humble/HumbleGame.vala"
	_tmp5_ = json_obj;
#line 52 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (_tmp5_, "human_name")) {
#line 1318 "HumbleGame.c"
		JsonObject* _tmp6_;
		const gchar* _tmp7_;
#line 52 "../src/data/sources/humble/HumbleGame.vala"
		_tmp6_ = json_obj;
#line 52 "../src/data/sources/humble/HumbleGame.vala"
		_tmp7_ = json_object_get_string_member (_tmp6_, "human_name");
#line 52 "../src/data/sources/humble/HumbleGame.vala"
		_tmp4_ = _tmp7_;
#line 1327 "HumbleGame.c"
	} else {
		JsonObject* _tmp8_;
		const gchar* _tmp9_;
#line 52 "../src/data/sources/humble/HumbleGame.vala"
		_tmp8_ = json_obj;
#line 52 "../src/data/sources/humble/HumbleGame.vala"
		_tmp9_ = json_object_get_string_member (_tmp8_, "human-name");
#line 52 "../src/data/sources/humble/HumbleGame.vala"
		_tmp4_ = _tmp9_;
#line 1337 "HumbleGame.c"
	}
#line 52 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, _tmp4_);
#line 53 "../src/data/sources/humble/HumbleGame.vala"
	_tmp11_ = json_obj;
#line 53 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (_tmp11_, "image")) {
#line 1345 "HumbleGame.c"
		JsonObject* _tmp12_;
		const gchar* _tmp13_;
#line 53 "../src/data/sources/humble/HumbleGame.vala"
		_tmp12_ = json_obj;
#line 53 "../src/data/sources/humble/HumbleGame.vala"
		_tmp13_ = json_object_get_string_member (_tmp12_, "image");
#line 53 "../src/data/sources/humble/HumbleGame.vala"
		_tmp10_ = _tmp13_;
#line 1354 "HumbleGame.c"
	} else {
		JsonObject* _tmp14_;
		const gchar* _tmp15_;
#line 53 "../src/data/sources/humble/HumbleGame.vala"
		_tmp14_ = json_obj;
#line 53 "../src/data/sources/humble/HumbleGame.vala"
		_tmp15_ = json_object_get_string_member (_tmp14_, "icon");
#line 53 "../src/data/sources/humble/HumbleGame.vala"
		_tmp10_ = _tmp15_;
#line 1364 "HumbleGame.c"
	}
#line 53 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_image ((GameHubDataGame*) self, _tmp10_);
#line 54 "../src/data/sources/humble/HumbleGame.vala"
	_tmp17_ = json_obj;
#line 54 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (_tmp17_, "icon")) {
#line 1372 "HumbleGame.c"
		JsonObject* _tmp18_;
		const gchar* _tmp19_;
#line 54 "../src/data/sources/humble/HumbleGame.vala"
		_tmp18_ = json_obj;
#line 54 "../src/data/sources/humble/HumbleGame.vala"
		_tmp19_ = json_object_get_string_member (_tmp18_, "icon");
#line 54 "../src/data/sources/humble/HumbleGame.vala"
		_tmp16_ = _tmp19_;
#line 1381 "HumbleGame.c"
	} else {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
#line 54 "../src/data/sources/humble/HumbleGame.vala"
		_tmp20_ = game_hub_data_game_get_image ((GameHubDataGame*) self);
#line 54 "../src/data/sources/humble/HumbleGame.vala"
		_tmp21_ = _tmp20_;
#line 54 "../src/data/sources/humble/HumbleGame.vala"
		_tmp16_ = _tmp21_;
#line 1391 "HumbleGame.c"
	}
#line 54 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_icon ((GameHubDataGame*) self, _tmp16_);
#line 55 "../src/data/sources/humble/HumbleGame.vala"
	_tmp22_ = g_strdup (order);
#line 55 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (self->order_id);
#line 55 "../src/data/sources/humble/HumbleGame.vala"
	self->order_id = _tmp22_;
#line 57 "../src/data/sources/humble/HumbleGame.vala"
	_tmp23_ = json_to_string (json_node, FALSE);
#line 57 "../src/data/sources/humble/HumbleGame.vala"
	_tmp24_ = _tmp23_;
#line 57 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp24_);
#line 57 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp24_);
#line 59 "../src/data/sources/humble/HumbleGame.vala"
	_tmp25_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 59 "../src/data/sources/humble/HumbleGame.vala"
	_tmp26_ = _tmp25_;
#line 59 "../src/data/sources/humble/HumbleGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp26_);
#line 61 "../src/data/sources/humble/HumbleGame.vala"
	_tmp27_ = json_obj;
#line 61 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (_tmp27_, "downloads")) {
#line 1419 "HumbleGame.c"
		JsonNode* downloads_node = NULL;
		JsonObject* _tmp28_;
		JsonNode* _tmp29_;
		JsonNode* _tmp30_;
		JsonNode* _tmp31_;
#line 63 "../src/data/sources/humble/HumbleGame.vala"
		_tmp28_ = json_obj;
#line 63 "../src/data/sources/humble/HumbleGame.vala"
		_tmp29_ = json_object_get_member (_tmp28_, "downloads");
#line 63 "../src/data/sources/humble/HumbleGame.vala"
		_tmp30_ = __vala_JsonNode_copy0 (_tmp29_);
#line 63 "../src/data/sources/humble/HumbleGame.vala"
		downloads_node = _tmp30_;
#line 64 "../src/data/sources/humble/HumbleGame.vala"
		_tmp31_ = downloads_node;
#line 64 "../src/data/sources/humble/HumbleGame.vala"
		switch (json_node_get_node_type (_tmp31_)) {
#line 64 "../src/data/sources/humble/HumbleGame.vala"
			case JSON_NODE_ARRAY:
#line 1439 "HumbleGame.c"
			{
				JsonNode* _tmp32_;
				JsonArray* _tmp33_;
				GList* _tmp34_;
#line 67 "../src/data/sources/humble/HumbleGame.vala"
				_tmp32_ = downloads_node;
#line 67 "../src/data/sources/humble/HumbleGame.vala"
				_tmp33_ = json_node_get_array (_tmp32_);
#line 67 "../src/data/sources/humble/HumbleGame.vala"
				_tmp34_ = json_array_get_elements (_tmp33_);
#line 1450 "HumbleGame.c"
				{
					GList* dl_collection = NULL;
					GList* dl_it = NULL;
#line 67 "../src/data/sources/humble/HumbleGame.vala"
					dl_collection = _tmp34_;
#line 67 "../src/data/sources/humble/HumbleGame.vala"
					for (dl_it = dl_collection; dl_it != NULL; dl_it = dl_it->next) {
#line 1458 "HumbleGame.c"
						JsonNode* dl = NULL;
#line 67 "../src/data/sources/humble/HumbleGame.vala"
						dl = (JsonNode*) dl_it->data;
#line 1462 "HumbleGame.c"
						{
							gchar* dl_platform = NULL;
							JsonNode* _tmp35_;
							JsonObject* _tmp36_;
							const gchar* _tmp37_;
							gchar* _tmp38_;
#line 69 "../src/data/sources/humble/HumbleGame.vala"
							_tmp35_ = dl;
#line 69 "../src/data/sources/humble/HumbleGame.vala"
							_tmp36_ = json_node_get_object (_tmp35_);
#line 69 "../src/data/sources/humble/HumbleGame.vala"
							_tmp37_ = json_object_get_string_member (_tmp36_, "platform");
#line 69 "../src/data/sources/humble/HumbleGame.vala"
							_tmp38_ = g_strdup (_tmp37_);
#line 69 "../src/data/sources/humble/HumbleGame.vala"
							dl_platform = _tmp38_;
#line 1479 "HumbleGame.c"
							{
								GameHubDataPlatform* p_collection = NULL;
								gint p_collection_length1 = 0;
								gint _p_collection_size_ = 0;
								gint p_it = 0;
#line 70 "../src/data/sources/humble/HumbleGame.vala"
								p_collection = GAME_HUB_DATA_PLATFORM_PLATFORMS;
#line 70 "../src/data/sources/humble/HumbleGame.vala"
								p_collection_length1 = G_N_ELEMENTS (GAME_HUB_DATA_PLATFORM_PLATFORMS);
#line 70 "../src/data/sources/humble/HumbleGame.vala"
								for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 1491 "HumbleGame.c"
									GameHubDataPlatform p = 0;
#line 70 "../src/data/sources/humble/HumbleGame.vala"
									p = p_collection[p_it];
#line 1495 "HumbleGame.c"
									{
										const gchar* _tmp39_;
										gchar* _tmp40_;
										gchar* _tmp41_;
										gboolean _tmp42_;
#line 72 "../src/data/sources/humble/HumbleGame.vala"
										_tmp39_ = dl_platform;
#line 72 "../src/data/sources/humble/HumbleGame.vala"
										_tmp40_ = game_hub_data_platform_id (p);
#line 72 "../src/data/sources/humble/HumbleGame.vala"
										_tmp41_ = _tmp40_;
#line 72 "../src/data/sources/humble/HumbleGame.vala"
										_tmp42_ = g_strcmp0 (_tmp39_, _tmp41_) == 0;
#line 72 "../src/data/sources/humble/HumbleGame.vala"
										_g_free0 (_tmp41_);
#line 72 "../src/data/sources/humble/HumbleGame.vala"
										if (_tmp42_) {
#line 1513 "HumbleGame.c"
											GeeArrayList* _tmp43_;
											GeeArrayList* _tmp44_;
#line 74 "../src/data/sources/humble/HumbleGame.vala"
											_tmp43_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 74 "../src/data/sources/humble/HumbleGame.vala"
											_tmp44_ = _tmp43_;
#line 74 "../src/data/sources/humble/HumbleGame.vala"
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, (gpointer) ((gintptr) p));
#line 1522 "HumbleGame.c"
										}
									}
								}
							}
#line 67 "../src/data/sources/humble/HumbleGame.vala"
							_g_free0 (dl_platform);
#line 1529 "HumbleGame.c"
						}
					}
#line 67 "../src/data/sources/humble/HumbleGame.vala"
					(dl_collection == NULL) ? NULL : (dl_collection = (g_list_free (dl_collection), NULL));
#line 1534 "HumbleGame.c"
				}
#line 78 "../src/data/sources/humble/HumbleGame.vala"
				break;
#line 1538 "HumbleGame.c"
			}
#line 64 "../src/data/sources/humble/HumbleGame.vala"
			case JSON_NODE_OBJECT:
#line 1542 "HumbleGame.c"
			{
				JsonNode* _tmp45_;
				JsonObject* _tmp46_;
				GList* _tmp47_;
#line 81 "../src/data/sources/humble/HumbleGame.vala"
				_tmp45_ = downloads_node;
#line 81 "../src/data/sources/humble/HumbleGame.vala"
				_tmp46_ = json_node_get_object (_tmp45_);
#line 81 "../src/data/sources/humble/HumbleGame.vala"
				_tmp47_ = json_object_get_members (_tmp46_);
#line 1553 "HumbleGame.c"
				{
					GList* dl_platform_collection = NULL;
					GList* dl_platform_it = NULL;
#line 81 "../src/data/sources/humble/HumbleGame.vala"
					dl_platform_collection = _tmp47_;
#line 81 "../src/data/sources/humble/HumbleGame.vala"
					for (dl_platform_it = dl_platform_collection; dl_platform_it != NULL; dl_platform_it = dl_platform_it->next) {
#line 1561 "HumbleGame.c"
						const gchar* dl_platform = NULL;
#line 81 "../src/data/sources/humble/HumbleGame.vala"
						dl_platform = (const gchar*) dl_platform_it->data;
#line 1565 "HumbleGame.c"
						{
							{
								GameHubDataPlatform* p_collection = NULL;
								gint p_collection_length1 = 0;
								gint _p_collection_size_ = 0;
								gint p_it = 0;
#line 83 "../src/data/sources/humble/HumbleGame.vala"
								p_collection = GAME_HUB_DATA_PLATFORM_PLATFORMS;
#line 83 "../src/data/sources/humble/HumbleGame.vala"
								p_collection_length1 = G_N_ELEMENTS (GAME_HUB_DATA_PLATFORM_PLATFORMS);
#line 83 "../src/data/sources/humble/HumbleGame.vala"
								for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 1578 "HumbleGame.c"
									GameHubDataPlatform p = 0;
#line 83 "../src/data/sources/humble/HumbleGame.vala"
									p = p_collection[p_it];
#line 1582 "HumbleGame.c"
									{
										const gchar* _tmp48_;
										gchar* _tmp49_;
										gchar* _tmp50_;
										gboolean _tmp51_;
#line 85 "../src/data/sources/humble/HumbleGame.vala"
										_tmp48_ = dl_platform;
#line 85 "../src/data/sources/humble/HumbleGame.vala"
										_tmp49_ = game_hub_data_platform_id (p);
#line 85 "../src/data/sources/humble/HumbleGame.vala"
										_tmp50_ = _tmp49_;
#line 85 "../src/data/sources/humble/HumbleGame.vala"
										_tmp51_ = g_strcmp0 (_tmp48_, _tmp50_) == 0;
#line 85 "../src/data/sources/humble/HumbleGame.vala"
										_g_free0 (_tmp50_);
#line 85 "../src/data/sources/humble/HumbleGame.vala"
										if (_tmp51_) {
#line 1600 "HumbleGame.c"
											GeeArrayList* _tmp52_;
											GeeArrayList* _tmp53_;
#line 87 "../src/data/sources/humble/HumbleGame.vala"
											_tmp52_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 87 "../src/data/sources/humble/HumbleGame.vala"
											_tmp53_ = _tmp52_;
#line 87 "../src/data/sources/humble/HumbleGame.vala"
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, (gpointer) ((gintptr) p));
#line 1609 "HumbleGame.c"
										}
									}
								}
							}
						}
					}
#line 81 "../src/data/sources/humble/HumbleGame.vala"
					(dl_platform_collection == NULL) ? NULL : (dl_platform_collection = (g_list_free (dl_platform_collection), NULL));
#line 1618 "HumbleGame.c"
				}
#line 91 "../src/data/sources/humble/HumbleGame.vala"
				break;
#line 1622 "HumbleGame.c"
			}
			default:
#line 64 "../src/data/sources/humble/HumbleGame.vala"
			break;
#line 1627 "HumbleGame.c"
		}
#line 61 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (downloads_node);
#line 1631 "HumbleGame.c"
	}
#line 95 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) self, NULL);
#line 96 "../src/data/sources/humble/HumbleGame.vala"
	_tmp54_ = g_strdup ("$game_dir/start.sh");
#line 96 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (((GameHubDataGame*) self)->executable_path);
#line 96 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGame*) self)->executable_path = _tmp54_;
#line 97 "../src/data/sources/humble/HumbleGame.vala"
	_tmp55_ = g_strdup ("$game_dir");
#line 97 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (((GameHubDataGame*) self)->work_dir_path);
#line 97 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGame*) self)->work_dir_path = _tmp55_;
#line 98 "../src/data/sources/humble/HumbleGame.vala"
	_tmp56_ = self->order_id;
#line 98 "../src/data/sources/humble/HumbleGame.vala"
	_tmp57_ = string_to_string (_tmp56_);
#line 98 "../src/data/sources/humble/HumbleGame.vala"
	_tmp58_ = g_strconcat ("{\"order\":\"", _tmp57_, "\"}", NULL);
#line 98 "../src/data/sources/humble/HumbleGame.vala"
	_tmp59_ = _tmp58_;
#line 98 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_info_detailed ((GameHubDataGame*) self, _tmp59_);
#line 98 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp59_);
#line 100 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_mount_overlays ((GameHubDataGame*) self, NULL, NULL, NULL);
#line 101 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 45 "../src/data/sources/humble/HumbleGame.vala"
	_json_object_unref0 (json_obj);
#line 45 "../src/data/sources/humble/HumbleGame.vala"
	return self;
#line 1667 "HumbleGame.c"
}

GameHubDataSourcesHumbleHumbleGame*
game_hub_data_sources_humble_humble_game_new (GameHubDataSourcesHumbleHumble* src,
                                              const gchar* order,
                                              JsonNode* json_node)
{
#line 45 "../src/data/sources/humble/HumbleGame.vala"
	return game_hub_data_sources_humble_humble_game_construct (GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, src, order, json_node);
#line 1677 "HumbleGame.c"
}

GameHubDataSourcesHumbleHumbleGame*
game_hub_data_sources_humble_humble_game_construct_from_db (GType object_type,
                                                            GameHubDataSourcesHumbleHumble* src,
                                                            sqlite3_stmt* s)
{
	GameHubDataSourcesHumbleHumbleGame * self = NULL;
	GameHubDataDBTableField* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GameHubDataDBTableField* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GameHubDataDBTableField* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GameHubDataDBTableField* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GameHubDataDBTableField* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GameHubDataDBTableField* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GFile* _tmp18_ = NULL;
	GameHubDataDBTableField* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	GameHubDataDBTableField* _tmp27_;
	gchar* _tmp28_;
	GameHubDataDBTableField* _tmp29_;
	gchar* _tmp30_;
	GameHubDataDBTableField* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GameHubDataDBTableField* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GameHubDataDBTableField* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GameHubDataDBTableField* _tmp40_;
	GameHubDataDBTableField* _tmp41_;
	GameHubDataDBTableField* _tmp42_;
	GameHubDataDBTableField* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GeeArrayList* _tmp46_;
	GeeArrayList* _tmp47_;
	gchar** pls = NULL;
	GameHubDataDBTableField* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gchar** _tmp53_;
	gint _tmp53__length1;
	gint pls_length1;
	gint _pls_size_;
	gchar** _tmp54_;
	gint _tmp54__length1;
	GeeArrayList* _tmp62_;
	GeeArrayList* _tmp63_;
	gchar* _tmp64_ = NULL;
	GameHubDataDBTableField* _tmp65_;
	gchar* _tmp66_;
	gchar** tag_ids = NULL;
	gchar** _tmp68_;
	gchar** _tmp69_;
	gint tag_ids_length1;
	gint _tag_ids_size_;
	gchar** _tmp70_;
	gint _tmp70__length1;
	JsonNode* json_node = NULL;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	JsonNode* _tmp92_;
	gboolean _tmp93_ = FALSE;
	JsonNode* _tmp94_;
	gchar* tweaks_string = NULL;
	GameHubDataDBTableField* _tmp103_;
	gchar* _tmp104_;
	const gchar* _tmp105_;
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) game_hub_data_game_construct (object_type);
#line 106 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_source ((GameHubDataGame*) self, (GameHubDataGameSource*) src);
#line 107 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = game_hub_data_db_tables_games_ID;
#line 107 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = game_hub_data_db_table_field_get (_tmp0_, s);
#line 107 "../src/data/sources/humble/HumbleGame.vala"
	_tmp2_ = _tmp1_;
#line 107 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp2_);
#line 107 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp2_);
#line 108 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = game_hub_data_db_tables_games_NAME;
#line 108 "../src/data/sources/humble/HumbleGame.vala"
	_tmp4_ = game_hub_data_db_table_field_get (_tmp3_, s);
#line 108 "../src/data/sources/humble/HumbleGame.vala"
	_tmp5_ = _tmp4_;
#line 108 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, _tmp5_);
#line 108 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp5_);
#line 109 "../src/data/sources/humble/HumbleGame.vala"
	_tmp6_ = game_hub_data_db_tables_games_INFO;
#line 109 "../src/data/sources/humble/HumbleGame.vala"
	_tmp7_ = game_hub_data_db_table_field_get (_tmp6_, s);
#line 109 "../src/data/sources/humble/HumbleGame.vala"
	_tmp8_ = _tmp7_;
#line 109 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp8_);
#line 109 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp8_);
#line 110 "../src/data/sources/humble/HumbleGame.vala"
	_tmp9_ = game_hub_data_db_tables_games_INFO_DETAILED;
#line 110 "../src/data/sources/humble/HumbleGame.vala"
	_tmp10_ = game_hub_data_db_table_field_get (_tmp9_, s);
#line 110 "../src/data/sources/humble/HumbleGame.vala"
	_tmp11_ = _tmp10_;
#line 110 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_info_detailed ((GameHubDataGame*) self, _tmp11_);
#line 110 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp11_);
#line 111 "../src/data/sources/humble/HumbleGame.vala"
	_tmp12_ = game_hub_data_db_tables_games_ICON;
#line 111 "../src/data/sources/humble/HumbleGame.vala"
	_tmp13_ = game_hub_data_db_table_field_get (_tmp12_, s);
#line 111 "../src/data/sources/humble/HumbleGame.vala"
	_tmp14_ = _tmp13_;
#line 111 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_icon ((GameHubDataGame*) self, _tmp14_);
#line 111 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp14_);
#line 112 "../src/data/sources/humble/HumbleGame.vala"
	_tmp15_ = game_hub_data_db_tables_games_IMAGE;
#line 112 "../src/data/sources/humble/HumbleGame.vala"
	_tmp16_ = game_hub_data_db_table_field_get (_tmp15_, s);
#line 112 "../src/data/sources/humble/HumbleGame.vala"
	_tmp17_ = _tmp16_;
#line 112 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_image ((GameHubDataGame*) self, _tmp17_);
#line 112 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp17_);
#line 113 "../src/data/sources/humble/HumbleGame.vala"
	_tmp19_ = game_hub_data_db_tables_games_INSTALL_PATH;
#line 113 "../src/data/sources/humble/HumbleGame.vala"
	_tmp20_ = game_hub_data_db_table_field_get (_tmp19_, s);
#line 113 "../src/data/sources/humble/HumbleGame.vala"
	_tmp21_ = _tmp20_;
#line 113 "../src/data/sources/humble/HumbleGame.vala"
	_tmp22_ = _tmp21_ != NULL;
#line 113 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp21_);
#line 113 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp22_) {
#line 1844 "HumbleGame.c"
		GameHubDataDBTableField* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GFile* _tmp26_;
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_tmp23_ = game_hub_data_db_tables_games_INSTALL_PATH;
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_tmp24_ = game_hub_data_db_table_field_get (_tmp23_, s);
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_tmp25_ = _tmp24_;
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_tmp26_ = game_hub_utils_fs_utils_file (_tmp25_, NULL, NULL);
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (_tmp18_);
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_tmp18_ = _tmp26_;
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_tmp25_);
#line 1863 "HumbleGame.c"
	} else {
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (_tmp18_);
#line 113 "../src/data/sources/humble/HumbleGame.vala"
		_tmp18_ = NULL;
#line 1869 "HumbleGame.c"
	}
#line 113 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) self, _tmp18_);
#line 114 "../src/data/sources/humble/HumbleGame.vala"
	_tmp27_ = game_hub_data_db_tables_games_EXECUTABLE;
#line 114 "../src/data/sources/humble/HumbleGame.vala"
	_tmp28_ = game_hub_data_db_table_field_get (_tmp27_, s);
#line 114 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (((GameHubDataGame*) self)->executable_path);
#line 114 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGame*) self)->executable_path = _tmp28_;
#line 115 "../src/data/sources/humble/HumbleGame.vala"
	_tmp29_ = game_hub_data_db_tables_games_WORK_DIR;
#line 115 "../src/data/sources/humble/HumbleGame.vala"
	_tmp30_ = game_hub_data_db_table_field_get (_tmp29_, s);
#line 115 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (((GameHubDataGame*) self)->work_dir_path);
#line 115 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGame*) self)->work_dir_path = _tmp30_;
#line 116 "../src/data/sources/humble/HumbleGame.vala"
	_tmp31_ = game_hub_data_db_tables_games_COMPAT_TOOL;
#line 116 "../src/data/sources/humble/HumbleGame.vala"
	_tmp32_ = game_hub_data_db_table_field_get (_tmp31_, s);
#line 116 "../src/data/sources/humble/HumbleGame.vala"
	_tmp33_ = _tmp32_;
#line 116 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_compat_tool ((GameHubDataRunnable*) self, _tmp33_);
#line 116 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp33_);
#line 117 "../src/data/sources/humble/HumbleGame.vala"
	_tmp34_ = game_hub_data_db_tables_games_COMPAT_TOOL_SETTINGS;
#line 117 "../src/data/sources/humble/HumbleGame.vala"
	_tmp35_ = game_hub_data_db_table_field_get (_tmp34_, s);
#line 117 "../src/data/sources/humble/HumbleGame.vala"
	_tmp36_ = _tmp35_;
#line 117 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_compat_tool_settings ((GameHubDataRunnable*) self, _tmp36_);
#line 117 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp36_);
#line 118 "../src/data/sources/humble/HumbleGame.vala"
	_tmp37_ = game_hub_data_db_tables_games_ARGUMENTS;
#line 118 "../src/data/sources/humble/HumbleGame.vala"
	_tmp38_ = game_hub_data_db_table_field_get (_tmp37_, s);
#line 118 "../src/data/sources/humble/HumbleGame.vala"
	_tmp39_ = _tmp38_;
#line 118 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_set_arguments ((GameHubDataRunnable*) self, _tmp39_);
#line 118 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp39_);
#line 119 "../src/data/sources/humble/HumbleGame.vala"
	_tmp40_ = game_hub_data_db_tables_games_LAST_LAUNCH;
#line 119 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_last_launch ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp40_, s));
#line 120 "../src/data/sources/humble/HumbleGame.vala"
	_tmp41_ = game_hub_data_db_tables_games_PLAYTIME_SOURCE;
#line 120 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_playtime_source ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp41_, s));
#line 121 "../src/data/sources/humble/HumbleGame.vala"
	_tmp42_ = game_hub_data_db_tables_games_PLAYTIME_TRACKED;
#line 121 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_playtime_tracked ((GameHubDataGame*) self, game_hub_data_db_table_field_get_int64 (_tmp42_, s));
#line 122 "../src/data/sources/humble/HumbleGame.vala"
	_tmp43_ = game_hub_data_db_tables_games_IMAGE_VERTICAL;
#line 122 "../src/data/sources/humble/HumbleGame.vala"
	_tmp44_ = game_hub_data_db_table_field_get (_tmp43_, s);
#line 122 "../src/data/sources/humble/HumbleGame.vala"
	_tmp45_ = _tmp44_;
#line 122 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_image_vertical ((GameHubDataGame*) self, _tmp45_);
#line 122 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp45_);
#line 124 "../src/data/sources/humble/HumbleGame.vala"
	_tmp46_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 124 "../src/data/sources/humble/HumbleGame.vala"
	_tmp47_ = _tmp46_;
#line 124 "../src/data/sources/humble/HumbleGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp47_);
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_tmp48_ = game_hub_data_db_tables_games_PLATFORMS;
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_tmp49_ = game_hub_data_db_table_field_get (_tmp48_, s);
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_tmp50_ = _tmp49_;
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_tmp52_ = _tmp51_ = g_strsplit (_tmp50_, ",", 0);
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_tmp53_ = _tmp52_;
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_tmp53__length1 = _vala_array_length (_tmp51_);
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp50_);
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	pls = _tmp53_;
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	pls_length1 = _tmp53__length1;
#line 125 "../src/data/sources/humble/HumbleGame.vala"
	_pls_size_ = pls_length1;
#line 126 "../src/data/sources/humble/HumbleGame.vala"
	_tmp54_ = pls;
#line 126 "../src/data/sources/humble/HumbleGame.vala"
	_tmp54__length1 = pls_length1;
#line 1971 "HumbleGame.c"
	{
		gchar** pl_collection = NULL;
		gint pl_collection_length1 = 0;
		gint _pl_collection_size_ = 0;
		gint pl_it = 0;
#line 126 "../src/data/sources/humble/HumbleGame.vala"
		pl_collection = _tmp54_;
#line 126 "../src/data/sources/humble/HumbleGame.vala"
		pl_collection_length1 = _tmp54__length1;
#line 126 "../src/data/sources/humble/HumbleGame.vala"
		for (pl_it = 0; pl_it < pl_collection_length1; pl_it = pl_it + 1) {
#line 1983 "HumbleGame.c"
			gchar* _tmp55_;
			gchar* pl = NULL;
#line 126 "../src/data/sources/humble/HumbleGame.vala"
			_tmp55_ = g_strdup (pl_collection[pl_it]);
#line 126 "../src/data/sources/humble/HumbleGame.vala"
			pl = _tmp55_;
#line 1990 "HumbleGame.c"
			{
				{
					GameHubDataPlatform* p_collection = NULL;
					gint p_collection_length1 = 0;
					gint _p_collection_size_ = 0;
					gint p_it = 0;
#line 128 "../src/data/sources/humble/HumbleGame.vala"
					p_collection = GAME_HUB_DATA_PLATFORM_PLATFORMS;
#line 128 "../src/data/sources/humble/HumbleGame.vala"
					p_collection_length1 = G_N_ELEMENTS (GAME_HUB_DATA_PLATFORM_PLATFORMS);
#line 128 "../src/data/sources/humble/HumbleGame.vala"
					for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 2003 "HumbleGame.c"
						GameHubDataPlatform p = 0;
#line 128 "../src/data/sources/humble/HumbleGame.vala"
						p = p_collection[p_it];
#line 2007 "HumbleGame.c"
						{
							const gchar* _tmp56_;
							gchar* _tmp57_;
							gchar* _tmp58_;
							gboolean _tmp59_;
#line 130 "../src/data/sources/humble/HumbleGame.vala"
							_tmp56_ = pl;
#line 130 "../src/data/sources/humble/HumbleGame.vala"
							_tmp57_ = game_hub_data_platform_id (p);
#line 130 "../src/data/sources/humble/HumbleGame.vala"
							_tmp58_ = _tmp57_;
#line 130 "../src/data/sources/humble/HumbleGame.vala"
							_tmp59_ = g_strcmp0 (_tmp56_, _tmp58_) == 0;
#line 130 "../src/data/sources/humble/HumbleGame.vala"
							_g_free0 (_tmp58_);
#line 130 "../src/data/sources/humble/HumbleGame.vala"
							if (_tmp59_) {
#line 2025 "HumbleGame.c"
								GeeArrayList* _tmp60_;
								GeeArrayList* _tmp61_;
#line 132 "../src/data/sources/humble/HumbleGame.vala"
								_tmp60_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 132 "../src/data/sources/humble/HumbleGame.vala"
								_tmp61_ = _tmp60_;
#line 132 "../src/data/sources/humble/HumbleGame.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, (gpointer) ((gintptr) p));
#line 133 "../src/data/sources/humble/HumbleGame.vala"
								break;
#line 2036 "HumbleGame.c"
							}
						}
					}
				}
#line 126 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (pl);
#line 2043 "HumbleGame.c"
			}
		}
	}
#line 138 "../src/data/sources/humble/HumbleGame.vala"
	_tmp62_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 138 "../src/data/sources/humble/HumbleGame.vala"
	_tmp63_ = _tmp62_;
#line 138 "../src/data/sources/humble/HumbleGame.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp63_);
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	_tmp65_ = game_hub_data_db_tables_games_TAGS;
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	_tmp66_ = game_hub_data_db_table_field_get (_tmp65_, s);
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	_tmp64_ = _tmp66_;
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp64_ == NULL) {
#line 2061 "HumbleGame.c"
		gchar* _tmp67_;
#line 139 "../src/data/sources/humble/HumbleGame.vala"
		_tmp67_ = g_strdup ("");
#line 139 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_tmp64_);
#line 139 "../src/data/sources/humble/HumbleGame.vala"
		_tmp64_ = _tmp67_;
#line 2069 "HumbleGame.c"
	}
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	_tmp69_ = _tmp68_ = g_strsplit (_tmp64_, ",", 0);
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	tag_ids = _tmp69_;
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	tag_ids_length1 = _vala_array_length (_tmp68_);
#line 139 "../src/data/sources/humble/HumbleGame.vala"
	_tag_ids_size_ = tag_ids_length1;
#line 140 "../src/data/sources/humble/HumbleGame.vala"
	_tmp70_ = tag_ids;
#line 140 "../src/data/sources/humble/HumbleGame.vala"
	_tmp70__length1 = tag_ids_length1;
#line 2083 "HumbleGame.c"
	{
		gchar** tid_collection = NULL;
		gint tid_collection_length1 = 0;
		gint _tid_collection_size_ = 0;
		gint tid_it = 0;
#line 140 "../src/data/sources/humble/HumbleGame.vala"
		tid_collection = _tmp70_;
#line 140 "../src/data/sources/humble/HumbleGame.vala"
		tid_collection_length1 = _tmp70__length1;
#line 140 "../src/data/sources/humble/HumbleGame.vala"
		for (tid_it = 0; tid_it < tid_collection_length1; tid_it = tid_it + 1) {
#line 2095 "HumbleGame.c"
			gchar* _tmp71_;
			gchar* tid = NULL;
#line 140 "../src/data/sources/humble/HumbleGame.vala"
			_tmp71_ = g_strdup (tid_collection[tid_it]);
#line 140 "../src/data/sources/humble/HumbleGame.vala"
			tid = _tmp71_;
#line 2102 "HumbleGame.c"
			{
				{
					GeeArrayList* _t_list = NULL;
					GeeArrayList* _tmp72_;
					gint _t_size = 0;
					GeeArrayList* _tmp73_;
					gint _tmp74_;
					gint _tmp75_;
					gint _t_index = 0;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					_tmp72_ = game_hub_data_db_tables_tags_TAGS;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					_t_list = _tmp72_;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					_tmp73_ = _t_list;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					_tmp74_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp73_);
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					_tmp75_ = _tmp74_;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					_t_size = _tmp75_;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					_t_index = -1;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
					while (TRUE) {
#line 2128 "HumbleGame.c"
						gint _tmp76_;
						gint _tmp77_;
						GameHubDataDBTablesTagsTag* t = NULL;
						GeeArrayList* _tmp78_;
						gpointer _tmp79_;
						const gchar* _tmp80_;
						GameHubDataDBTablesTagsTag* _tmp81_;
						const gchar* _tmp82_;
						const gchar* _tmp83_;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						_t_index = _t_index + 1;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						_tmp76_ = _t_index;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						_tmp77_ = _t_size;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						if (!(_tmp76_ < _tmp77_)) {
#line 142 "../src/data/sources/humble/HumbleGame.vala"
							break;
#line 2148 "HumbleGame.c"
						}
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						_tmp78_ = _t_list;
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						_tmp79_ = gee_abstract_list_get ((GeeAbstractList*) _tmp78_, _t_index);
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						t = (GameHubDataDBTablesTagsTag*) _tmp79_;
#line 144 "../src/data/sources/humble/HumbleGame.vala"
						_tmp80_ = tid;
#line 144 "../src/data/sources/humble/HumbleGame.vala"
						_tmp81_ = t;
#line 144 "../src/data/sources/humble/HumbleGame.vala"
						_tmp82_ = game_hub_data_db_tables_tags_tag_get_id (_tmp81_);
#line 144 "../src/data/sources/humble/HumbleGame.vala"
						_tmp83_ = _tmp82_;
#line 144 "../src/data/sources/humble/HumbleGame.vala"
						if (g_strcmp0 (_tmp80_, _tmp83_) == 0) {
#line 2166 "HumbleGame.c"
							GeeArrayList* _tmp84_;
							GeeArrayList* _tmp85_;
							GameHubDataDBTablesTagsTag* _tmp86_;
#line 146 "../src/data/sources/humble/HumbleGame.vala"
							_tmp84_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 146 "../src/data/sources/humble/HumbleGame.vala"
							_tmp85_ = _tmp84_;
#line 146 "../src/data/sources/humble/HumbleGame.vala"
							_tmp86_ = t;
#line 146 "../src/data/sources/humble/HumbleGame.vala"
							if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp85_, _tmp86_)) {
#line 2178 "HumbleGame.c"
								GeeArrayList* _tmp87_;
								GeeArrayList* _tmp88_;
								GameHubDataDBTablesTagsTag* _tmp89_;
#line 146 "../src/data/sources/humble/HumbleGame.vala"
								_tmp87_ = game_hub_data_game_get_tags ((GameHubDataGame*) self);
#line 146 "../src/data/sources/humble/HumbleGame.vala"
								_tmp88_ = _tmp87_;
#line 146 "../src/data/sources/humble/HumbleGame.vala"
								_tmp89_ = t;
#line 146 "../src/data/sources/humble/HumbleGame.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp88_, _tmp89_);
#line 2190 "HumbleGame.c"
							}
#line 147 "../src/data/sources/humble/HumbleGame.vala"
							_g_object_unref0 (t);
#line 147 "../src/data/sources/humble/HumbleGame.vala"
							break;
#line 2196 "HumbleGame.c"
						}
#line 142 "../src/data/sources/humble/HumbleGame.vala"
						_g_object_unref0 (t);
#line 2200 "HumbleGame.c"
					}
				}
#line 140 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (tid);
#line 2205 "HumbleGame.c"
			}
		}
	}
#line 152 "../src/data/sources/humble/HumbleGame.vala"
	_tmp90_ = game_hub_data_game_get_info_detailed ((GameHubDataGame*) self);
#line 152 "../src/data/sources/humble/HumbleGame.vala"
	_tmp91_ = _tmp90_;
#line 152 "../src/data/sources/humble/HumbleGame.vala"
	_tmp92_ = game_hub_utils_parser_parse_json (_tmp91_);
#line 152 "../src/data/sources/humble/HumbleGame.vala"
	json_node = _tmp92_;
#line 153 "../src/data/sources/humble/HumbleGame.vala"
	_tmp94_ = json_node;
#line 153 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp94_ != NULL) {
#line 2221 "HumbleGame.c"
		JsonNode* _tmp95_;
#line 153 "../src/data/sources/humble/HumbleGame.vala"
		_tmp95_ = json_node;
#line 153 "../src/data/sources/humble/HumbleGame.vala"
		_tmp93_ = json_node_get_node_type (_tmp95_) == JSON_NODE_OBJECT;
#line 2227 "HumbleGame.c"
	} else {
#line 153 "../src/data/sources/humble/HumbleGame.vala"
		_tmp93_ = FALSE;
#line 2231 "HumbleGame.c"
	}
#line 153 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp93_) {
#line 2235 "HumbleGame.c"
		JsonObject* json = NULL;
		JsonNode* _tmp96_;
		JsonObject* _tmp97_;
		JsonObject* _tmp98_;
		JsonObject* _tmp99_;
#line 155 "../src/data/sources/humble/HumbleGame.vala"
		_tmp96_ = json_node;
#line 155 "../src/data/sources/humble/HumbleGame.vala"
		_tmp97_ = json_node_get_object (_tmp96_);
#line 155 "../src/data/sources/humble/HumbleGame.vala"
		_tmp98_ = _json_object_ref0 (_tmp97_);
#line 155 "../src/data/sources/humble/HumbleGame.vala"
		json = _tmp98_;
#line 156 "../src/data/sources/humble/HumbleGame.vala"
		_tmp99_ = json;
#line 156 "../src/data/sources/humble/HumbleGame.vala"
		if (json_object_has_member (_tmp99_, "order")) {
#line 2253 "HumbleGame.c"
			JsonObject* _tmp100_;
			const gchar* _tmp101_;
			gchar* _tmp102_;
#line 158 "../src/data/sources/humble/HumbleGame.vala"
			_tmp100_ = json;
#line 158 "../src/data/sources/humble/HumbleGame.vala"
			_tmp101_ = json_object_get_string_member (_tmp100_, "order");
#line 158 "../src/data/sources/humble/HumbleGame.vala"
			_tmp102_ = g_strdup (_tmp101_);
#line 158 "../src/data/sources/humble/HumbleGame.vala"
			_g_free0 (self->order_id);
#line 158 "../src/data/sources/humble/HumbleGame.vala"
			self->order_id = _tmp102_;
#line 2267 "HumbleGame.c"
		}
#line 153 "../src/data/sources/humble/HumbleGame.vala"
		_json_object_unref0 (json);
#line 2271 "HumbleGame.c"
	}
#line 162 "../src/data/sources/humble/HumbleGame.vala"
	_tmp103_ = game_hub_data_db_tables_games_TWEAKS;
#line 162 "../src/data/sources/humble/HumbleGame.vala"
	_tmp104_ = game_hub_data_db_table_field_get (_tmp103_, s);
#line 162 "../src/data/sources/humble/HumbleGame.vala"
	tweaks_string = _tmp104_;
#line 163 "../src/data/sources/humble/HumbleGame.vala"
	_tmp105_ = tweaks_string;
#line 163 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp105_ != NULL) {
#line 2283 "HumbleGame.c"
		const gchar* _tmp106_;
		gchar** _tmp107_;
		gchar** _tmp108_;
		gchar** _tmp109_;
		gint _tmp109__length1;
#line 165 "../src/data/sources/humble/HumbleGame.vala"
		_tmp106_ = tweaks_string;
#line 165 "../src/data/sources/humble/HumbleGame.vala"
		_tmp108_ = _tmp107_ = g_strsplit (_tmp106_, ",", 0);
#line 165 "../src/data/sources/humble/HumbleGame.vala"
		_tmp109_ = _tmp108_;
#line 165 "../src/data/sources/humble/HumbleGame.vala"
		_tmp109__length1 = _vala_array_length (_tmp107_);
#line 165 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_tweakable_game_set_tweaks ((GameHubDataTweakableGame*) self, _tmp109_, _vala_array_length (_tmp107_));
#line 165 "../src/data/sources/humble/HumbleGame.vala"
		_tmp109_ = (_vala_array_free (_tmp109_, _tmp109__length1, (GDestroyNotify) g_free), NULL);
#line 2301 "HumbleGame.c"
	}
#line 168 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_mount_overlays ((GameHubDataGame*) self, NULL, NULL, NULL);
#line 169 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (tweaks_string);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	__vala_JsonNode_free0 (json_node);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	tag_ids = (_vala_array_free (tag_ids, tag_ids_length1, (GDestroyNotify) g_free), NULL);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp64_);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	pls = (_vala_array_free (pls, pls_length1, (GDestroyNotify) g_free), NULL);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_tmp18_);
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	return self;
#line 2321 "HumbleGame.c"
}

GameHubDataSourcesHumbleHumbleGame*
game_hub_data_sources_humble_humble_game_new_from_db (GameHubDataSourcesHumbleHumble* src,
                                                      sqlite3_stmt* s)
{
#line 104 "../src/data/sources/humble/HumbleGame.vala"
	return game_hub_data_sources_humble_humble_game_construct_from_db (GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, src, s);
#line 2330 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_update_status (GameHubDataRunnable* base)
{
	GameHubDataSourcesHumbleHumbleGame * self;
	gboolean _tmp0_ = FALSE;
	GameHubDataGameStatus* _tmp1_;
	GameHubDataGameStatus* _tmp2_;
	GameHubDataGameState _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	GameHubDataGameStatus* _tmp17_;
	GameHubDataGameStatus* _tmp18_;
	GameHubDataGameStatus* _tmp19_;
	GameHubDataGameStatus* _tmp20_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
#line 172 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) base;
#line 174 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 174 "../src/data/sources/humble/HumbleGame.vala"
	_tmp2_ = _tmp1_;
#line 174 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp2_->state == GAME_HUB_DATA_GAME_STATE_DOWNLOADING) {
#line 2364 "HumbleGame.c"
		GameHubDataGameStatus* _tmp3_;
		GameHubDataGameStatus* _tmp4_;
		GameHubUtilsDownloaderDownload* _tmp5_;
		GameHubUtilsDownloaderDownloadStatus* _tmp6_;
		GameHubUtilsDownloaderDownloadStatus* _tmp7_;
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		_tmp3_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		_tmp4_ = _tmp3_;
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		_tmp5_ = _tmp4_->download;
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		_tmp6_ = game_hub_utils_downloader_download_get_status (_tmp5_);
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		_tmp7_ = _tmp6_;
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = _tmp7_->state != GAME_HUB_UTILS_DOWNLOADER_DOWNLOAD_STATE_CANCELLED;
#line 2382 "HumbleGame.c"
	} else {
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = FALSE;
#line 2386 "HumbleGame.c"
	}
#line 174 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp0_) {
#line 174 "../src/data/sources/humble/HumbleGame.vala"
		return;
#line 2392 "HumbleGame.c"
	}
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_tmp10_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) self);
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_tmp11_ = _tmp10_;
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_tmp12_ = _tmp11_;
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_tmp13_ = _tmp12_ != NULL;
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_tmp12_);
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp13_) {
#line 2406 "HumbleGame.c"
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_tmp14_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) self);
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_tmp15_ = _tmp14_;
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_tmp16_ = _tmp15_;
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_tmp9_ = g_file_query_exists (_tmp16_, NULL);
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (_tmp16_);
#line 2420 "HumbleGame.c"
	} else {
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_tmp9_ = FALSE;
#line 2424 "HumbleGame.c"
	}
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp9_) {
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_tmp8_ = GAME_HUB_DATA_GAME_STATE_INSTALLED;
#line 2430 "HumbleGame.c"
	} else {
#line 176 "../src/data/sources/humble/HumbleGame.vala"
		_tmp8_ = GAME_HUB_DATA_GAME_STATE_UNINSTALLED;
#line 2434 "HumbleGame.c"
	}
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_tmp17_ = game_hub_data_game_status_new (_tmp8_, (GameHubDataGame*) self, NULL);
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_tmp18_ = _tmp17_;
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_status ((GameHubDataGame*) self, _tmp18_);
#line 176 "../src/data/sources/humble/HumbleGame.vala"
	_game_hub_data_game_status_unref0 (_tmp18_);
#line 177 "../src/data/sources/humble/HumbleGame.vala"
	_tmp19_ = game_hub_data_game_get_status ((GameHubDataGame*) self);
#line 177 "../src/data/sources/humble/HumbleGame.vala"
	_tmp20_ = _tmp19_;
#line 177 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp20_->state == GAME_HUB_DATA_GAME_STATE_INSTALLED) {
#line 2450 "HumbleGame.c"
		GameHubDataDBTablesTagsTag* _tmp21_;
		GameHubDataDBTablesTagsTag* _tmp22_;
#line 179 "../src/data/sources/humble/HumbleGame.vala"
		_tmp21_ = game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
#line 179 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_remove_tag ((GameHubDataGame*) self, _tmp21_);
#line 180 "../src/data/sources/humble/HumbleGame.vala"
		_tmp22_ = game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
#line 180 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_add_tag ((GameHubDataGame*) self, _tmp22_);
#line 2461 "HumbleGame.c"
	} else {
		GameHubDataDBTablesTagsTag* _tmp23_;
		GameHubDataDBTablesTagsTag* _tmp24_;
#line 184 "../src/data/sources/humble/HumbleGame.vala"
		_tmp23_ = game_hub_data_db_tables_tags_BUILTIN_UNINSTALLED;
#line 184 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_add_tag ((GameHubDataGame*) self, _tmp23_);
#line 185 "../src/data/sources/humble/HumbleGame.vala"
		_tmp24_ = game_hub_data_db_tables_tags_BUILTIN_INSTALLED;
#line 185 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_remove_tag ((GameHubDataGame*) self, _tmp24_);
#line 2473 "HumbleGame.c"
	}
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_tmp25_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) self);
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_tmp26_ = _tmp25_;
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_tmp27_ = game_hub_utils_fs_utils_paths_collection_humble_expand_installers (_tmp26_, NULL);
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_tmp28_ = _tmp27_;
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_tmp29_ = game_hub_utils_fs_utils_file (_tmp28_, NULL, NULL);
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_tmp30_ = _tmp29_;
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_installers_dir ((GameHubDataGame*) self, _tmp30_);
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_tmp30_);
#line 188 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp28_);
#line 190 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_update_version ((GameHubDataGame*) self);
#line 2495 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_update_game_info_data_free (gpointer _data)
{
	GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData* _data_;
	_data_ = _data;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_slice_free (GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData, _data_);
#line 2507 "HumbleGame.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	return self ? g_object_ref (self) : NULL;
#line 2515 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_update_game_info (GameHubDataGame* base,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGame * self;
	GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData* _data_;
	GameHubDataSourcesHumbleHumbleGame* _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) base;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_humble_humble_game_real_update_game_info_data_free);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_real_update_game_info_co (_data_);
#line 2540 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_update_game_info_finish (GameHubDataGame* base,
                                                                  GAsyncResult* _res_)
{
	GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData* _data_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2550 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_update_game_info_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData* _data_;
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = _user_data_;
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_source_object_ = source_object;
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_res_ = _res_;
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_real_update_game_info_co (_data_);
#line 2567 "HumbleGame.c"
}

static gpointer
_json_array_ref0 (gpointer self)
{
#line 237 "../src/data/sources/humble/HumbleGame.vala"
	return self ? json_array_ref (self) : NULL;
#line 2575 "HumbleGame.c"
}

static gboolean
game_hub_data_sources_humble_humble_game_real_update_game_info_co (GameHubDataSourcesHumbleHumbleGameUpdateGameInfoData* _data_)
{
#line 193 "../src/data/sources/humble/HumbleGame.vala"
	switch (_data_->_state_) {
#line 193 "../src/data/sources/humble/HumbleGame.vala"
		case 0:
#line 2585 "HumbleGame.c"
		goto _state_0;
#line 193 "../src/data/sources/humble/HumbleGame.vala"
		case 1:
#line 2589 "HumbleGame.c"
		goto _state_1;
#line 193 "../src/data/sources/humble/HumbleGame.vala"
		case 2:
#line 2593 "HumbleGame.c"
		goto _state_2;
		default:
#line 193 "../src/data/sources/humble/HumbleGame.vala"
		g_assert_not_reached ();
#line 2598 "HumbleGame.c"
	}
	_state_0:
#line 195 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->self->priv->game_info_updating) {
#line 195 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 195 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 195 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 195 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2611 "HumbleGame.c"
			}
		}
#line 195 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 195 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 2618 "HumbleGame.c"
	}
#line 196 "../src/data/sources/humble/HumbleGame.vala"
	_data_->self->priv->game_info_updating = TRUE;
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_state_ = 1;
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_mount_overlays ((GameHubDataGame*) _data_->self, NULL, game_hub_data_sources_humble_humble_game_update_game_info_ready, _data_);
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	return FALSE;
#line 2628 "HumbleGame.c"
	_state_1:
#line 198 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_mount_overlays_finish ((GameHubDataGame*) _data_->self, _data_->_res_);
#line 199 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 201 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp2_ = game_hub_data_game_get_icon ((GameHubDataGame*) _data_->self);
#line 201 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 201 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp3_ == NULL) {
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp1_ = TRUE;
#line 2642 "HumbleGame.c"
	} else {
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp4_ = game_hub_data_game_get_icon ((GameHubDataGame*) _data_->self);
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp1_ = g_strcmp0 (_data_->_tmp5_, "") == 0;
#line 2650 "HumbleGame.c"
	}
#line 201 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp1_) {
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp7_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp8_ != NULL) {
#line 201 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp9_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 201 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 201 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp11_ = strlen (_data_->_tmp10_);
#line 201 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 201 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp6_ = _data_->_tmp12_ > 0;
#line 2670 "HumbleGame.c"
		} else {
#line 201 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp6_ = FALSE;
#line 2674 "HumbleGame.c"
		}
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp0_ = _data_->_tmp6_;
#line 2678 "HumbleGame.c"
	} else {
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp0_ = FALSE;
#line 2682 "HumbleGame.c"
	}
#line 201 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp0_) {
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp13_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp15_ = game_hub_utils_parser_parse_json (_data_->_tmp14_);
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp16_ = _data_->_tmp15_;
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp17_ = json_node_get_object (_data_->_tmp16_);
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp18_ = _json_object_ref0 (_data_->_tmp17_);
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp19_ = _data_->_tmp18_;
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (_data_->_tmp16_);
#line 203 "../src/data/sources/humble/HumbleGame.vala"
		_data_->i = _data_->_tmp19_;
#line 204 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp20_ = _data_->i;
#line 204 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp21_ = json_object_get_string_member (_data_->_tmp20_, "icon");
#line 204 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_set_icon ((GameHubDataGame*) _data_->self, _data_->_tmp21_);
#line 201 "../src/data/sources/humble/HumbleGame.vala"
		_json_object_unref0 (_data_->i);
#line 2712 "HumbleGame.c"
	}
#line 207 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp23_ = game_hub_data_game_get_image ((GameHubDataGame*) _data_->self);
#line 207 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp24_ = _data_->_tmp23_;
#line 207 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp24_ == NULL) {
#line 207 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp22_ = TRUE;
#line 2722 "HumbleGame.c"
	} else {
#line 207 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp25_ = game_hub_data_game_get_image ((GameHubDataGame*) _data_->self);
#line 207 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 207 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp22_ = g_strcmp0 (_data_->_tmp26_, "") == 0;
#line 2730 "HumbleGame.c"
	}
#line 207 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp22_) {
#line 209 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp27_ = game_hub_data_game_get_icon ((GameHubDataGame*) _data_->self);
#line 209 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp28_ = _data_->_tmp27_;
#line 209 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_set_image ((GameHubDataGame*) _data_->self, _data_->_tmp28_);
#line 2740 "HumbleGame.c"
	}
#line 212 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->self->priv->game_info_updated) {
#line 214 "../src/data/sources/humble/HumbleGame.vala"
		_data_->self->priv->game_info_updating = FALSE;
#line 215 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 215 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 215 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 215 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2754 "HumbleGame.c"
			}
		}
#line 215 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 215 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 2761 "HumbleGame.c"
	}
#line 218 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp30_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 218 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp31_ = _data_->_tmp30_;
#line 218 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp31_ == NULL) {
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp29_ = TRUE;
#line 2771 "HumbleGame.c"
	} else {
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp32_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp33_ = _data_->_tmp32_;
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp34_ = strlen (_data_->_tmp33_);
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp35_ = _data_->_tmp34_;
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp29_ = _data_->_tmp35_ == 0;
#line 2783 "HumbleGame.c"
	}
#line 218 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp29_) {
#line 220 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp36_ = game_hub_data_game_get_source ((GameHubDataGame*) _data_->self);
#line 220 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp37_ = _data_->_tmp36_;
#line 220 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp38_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp37_, GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumble)->user_token;
#line 220 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp39_ = g_strdup (_data_->_tmp38_);
#line 220 "../src/data/sources/humble/HumbleGame.vala"
		_data_->token = _data_->_tmp39_;
#line 222 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp40_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 222 "../src/data/sources/humble/HumbleGame.vala"
		_data_->headers = _data_->_tmp40_;
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp41_ = _data_->headers;
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp42_ = string_to_string (GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_AUTH_COOKIE);
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp43_ = _data_->token;
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp44_ = string_to_string (_data_->_tmp43_);
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp45_ = g_strconcat (_data_->_tmp42_, "=\"", _data_->_tmp44_, "\";", NULL);
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp46_ = _data_->_tmp45_;
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp41_, "Cookie", _data_->_tmp46_);
#line 223 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_data_->_tmp46_);
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp47_ = _data_->self->order_id;
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp48_ = string_to_string (_data_->_tmp47_);
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp49_ = g_strconcat ("https://www.humblebundle.com/api/v1/order/", _data_->_tmp48_, "?ajax=true", NULL);
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp50_ = _data_->_tmp49_;
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp51_ = _data_->headers;
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_state_ = 2;
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_utils_parser_parse_remote_json_file_async (_data_->_tmp50_, "GET", NULL, _data_->_tmp51_, NULL, game_hub_data_sources_humble_humble_game_update_game_info_ready, _data_);
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 2833 "HumbleGame.c"
		_state_2:
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp52_ = game_hub_utils_parser_parse_remote_json_file_finish (_data_->_res_, NULL);
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp53_ = _data_->_tmp52_;
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_data_->_tmp50_);
#line 225 "../src/data/sources/humble/HumbleGame.vala"
		_data_->root_node = _data_->_tmp53_;
#line 226 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp55_ = _data_->root_node;
#line 226 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp55_ == NULL) {
#line 226 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp54_ = TRUE;
#line 2849 "HumbleGame.c"
		} else {
#line 226 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp56_ = _data_->root_node;
#line 226 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp54_ = json_node_get_node_type (_data_->_tmp56_) != JSON_NODE_OBJECT;
#line 2855 "HumbleGame.c"
		}
#line 226 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp54_) {
#line 228 "../src/data/sources/humble/HumbleGame.vala"
			_data_->self->priv->game_info_updating = FALSE;
#line 229 "../src/data/sources/humble/HumbleGame.vala"
			__vala_JsonNode_free0 (_data_->root_node);
#line 229 "../src/data/sources/humble/HumbleGame.vala"
			_g_object_unref0 (_data_->headers);
#line 229 "../src/data/sources/humble/HumbleGame.vala"
			_g_free0 (_data_->token);
#line 229 "../src/data/sources/humble/HumbleGame.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 229 "../src/data/sources/humble/HumbleGame.vala"
			if (_data_->_state_ != 0) {
#line 229 "../src/data/sources/humble/HumbleGame.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 229 "../src/data/sources/humble/HumbleGame.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2875 "HumbleGame.c"
				}
			}
#line 229 "../src/data/sources/humble/HumbleGame.vala"
			g_object_unref (_data_->_async_result);
#line 229 "../src/data/sources/humble/HumbleGame.vala"
			return FALSE;
#line 2882 "HumbleGame.c"
		}
#line 231 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp57_ = _data_->root_node;
#line 231 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp58_ = json_node_get_object (_data_->_tmp57_);
#line 231 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp59_ = _json_object_ref0 (_data_->_tmp58_);
#line 231 "../src/data/sources/humble/HumbleGame.vala"
		_data_->root = _data_->_tmp59_;
#line 232 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp60_ = _data_->root;
#line 232 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp60_ == NULL) {
#line 234 "../src/data/sources/humble/HumbleGame.vala"
			_data_->self->priv->game_info_updating = FALSE;
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			_json_object_unref0 (_data_->root);
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			__vala_JsonNode_free0 (_data_->root_node);
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			_g_object_unref0 (_data_->headers);
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			_g_free0 (_data_->token);
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			if (_data_->_state_ != 0) {
#line 235 "../src/data/sources/humble/HumbleGame.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 235 "../src/data/sources/humble/HumbleGame.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2914 "HumbleGame.c"
				}
			}
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			g_object_unref (_data_->_async_result);
#line 235 "../src/data/sources/humble/HumbleGame.vala"
			return FALSE;
#line 2921 "HumbleGame.c"
		}
#line 237 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp61_ = _data_->root;
#line 237 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp62_ = json_object_get_array_member (_data_->_tmp61_, "subproducts");
#line 237 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp63_ = _json_array_ref0 (_data_->_tmp62_);
#line 237 "../src/data/sources/humble/HumbleGame.vala"
		_data_->products = _data_->_tmp63_;
#line 238 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp64_ = _data_->products;
#line 238 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp64_ == NULL) {
#line 240 "../src/data/sources/humble/HumbleGame.vala"
			_data_->self->priv->game_info_updating = FALSE;
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			_json_array_unref0 (_data_->products);
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			_json_object_unref0 (_data_->root);
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			__vala_JsonNode_free0 (_data_->root_node);
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			_g_object_unref0 (_data_->headers);
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			_g_free0 (_data_->token);
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			if (_data_->_state_ != 0) {
#line 241 "../src/data/sources/humble/HumbleGame.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 241 "../src/data/sources/humble/HumbleGame.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2955 "HumbleGame.c"
				}
			}
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			g_object_unref (_data_->_async_result);
#line 241 "../src/data/sources/humble/HumbleGame.vala"
			return FALSE;
#line 2962 "HumbleGame.c"
		}
#line 243 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp65_ = _data_->products;
#line 243 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp66_ = json_array_get_elements (_data_->_tmp65_);
#line 2968 "HumbleGame.c"
		{
#line 243 "../src/data/sources/humble/HumbleGame.vala"
			_data_->product_node_collection = _data_->_tmp66_;
#line 243 "../src/data/sources/humble/HumbleGame.vala"
			for (_data_->product_node_it = _data_->product_node_collection; _data_->product_node_it != NULL; _data_->product_node_it = _data_->product_node_it->next) {
#line 243 "../src/data/sources/humble/HumbleGame.vala"
				_data_->product_node = (JsonNode*) _data_->product_node_it->data;
#line 2976 "HumbleGame.c"
				{
#line 245 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp67_ = _data_->product_node;
#line 245 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp68_ = json_node_get_object (_data_->_tmp67_);
#line 245 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp69_ = json_object_get_string_member (_data_->_tmp68_, "machine_name");
#line 245 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp70_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) _data_->self);
#line 245 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp71_ = _data_->_tmp70_;
#line 245 "../src/data/sources/humble/HumbleGame.vala"
					if (g_strcmp0 (_data_->_tmp69_, _data_->_tmp71_) != 0) {
#line 245 "../src/data/sources/humble/HumbleGame.vala"
						continue;
#line 2992 "HumbleGame.c"
					}
#line 246 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp72_ = _data_->product_node;
#line 246 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp73_ = json_to_string (_data_->_tmp72_, FALSE);
#line 246 "../src/data/sources/humble/HumbleGame.vala"
					_data_->_tmp74_ = _data_->_tmp73_;
#line 246 "../src/data/sources/humble/HumbleGame.vala"
					game_hub_data_game_set_info ((GameHubDataGame*) _data_->self, _data_->_tmp74_);
#line 246 "../src/data/sources/humble/HumbleGame.vala"
					_g_free0 (_data_->_tmp74_);
#line 247 "../src/data/sources/humble/HumbleGame.vala"
					break;
#line 3006 "HumbleGame.c"
				}
			}
#line 243 "../src/data/sources/humble/HumbleGame.vala"
			(_data_->product_node_collection == NULL) ? NULL : (_data_->product_node_collection = (g_list_free (_data_->product_node_collection), NULL));
#line 3011 "HumbleGame.c"
		}
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_json_array_unref0 (_data_->products);
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_json_object_unref0 (_data_->root);
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (_data_->root_node);
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (_data_->headers);
#line 218 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_data_->token);
#line 3023 "HumbleGame.c"
	}
#line 251 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp75_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 251 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp76_ = _data_->_tmp75_;
#line 251 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp77_ = game_hub_utils_parser_parse_json (_data_->_tmp76_);
#line 251 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_vala1_product_node = _data_->_tmp77_;
#line 252 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp79_ = _data_->_vala1_product_node;
#line 252 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp79_ == NULL) {
#line 252 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp78_ = TRUE;
#line 3039 "HumbleGame.c"
	} else {
#line 252 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp80_ = _data_->_vala1_product_node;
#line 252 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp78_ = json_node_get_node_type (_data_->_tmp80_) != JSON_NODE_OBJECT;
#line 3045 "HumbleGame.c"
	}
#line 252 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp78_) {
#line 254 "../src/data/sources/humble/HumbleGame.vala"
		_data_->self->priv->game_info_updating = FALSE;
#line 255 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (_data_->_vala1_product_node);
#line 255 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 255 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 255 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 255 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3061 "HumbleGame.c"
			}
		}
#line 255 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 255 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 3068 "HumbleGame.c"
	}
#line 258 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp81_ = _data_->_vala1_product_node;
#line 258 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp82_ = json_node_get_object (_data_->_tmp81_);
#line 258 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp83_ = _json_object_ref0 (_data_->_tmp82_);
#line 258 "../src/data/sources/humble/HumbleGame.vala"
	_data_->product = _data_->_tmp83_;
#line 259 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp84_ = _data_->product;
#line 259 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp84_ == NULL) {
#line 261 "../src/data/sources/humble/HumbleGame.vala"
		_data_->self->priv->game_info_updating = FALSE;
#line 262 "../src/data/sources/humble/HumbleGame.vala"
		_json_object_unref0 (_data_->product);
#line 262 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (_data_->_vala1_product_node);
#line 262 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 262 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 262 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 262 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3096 "HumbleGame.c"
			}
		}
#line 262 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 262 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 3103 "HumbleGame.c"
	}
#line 265 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp85_ = _data_->product;
#line 265 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (_data_->_tmp85_, "description-text")) {
#line 267 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp86_ = _data_->product;
#line 267 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp87_ = json_object_get_string_member (_data_->_tmp86_, "description-text");
#line 267 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_set_description ((GameHubDataGame*) _data_->self, _data_->_tmp87_);
#line 3115 "HumbleGame.c"
	} else {
#line 269 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp88_ = _data_->product;
#line 269 "../src/data/sources/humble/HumbleGame.vala"
		if (json_object_has_member (_data_->_tmp88_, "_gamehub_description")) {
#line 271 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp89_ = _data_->product;
#line 271 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp90_ = json_object_get_string_member (_data_->_tmp89_, "_gamehub_description");
#line 271 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_game_set_description ((GameHubDataGame*) _data_->self, _data_->_tmp90_);
#line 3127 "HumbleGame.c"
		}
	}
#line 274 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 276 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 278 "../src/data/sources/humble/HumbleGame.vala"
	_data_->self->priv->game_info_updated = TRUE;
#line 279 "../src/data/sources/humble/HumbleGame.vala"
	_data_->self->priv->game_info_updating = FALSE;
#line 193 "../src/data/sources/humble/HumbleGame.vala"
	_json_object_unref0 (_data_->product);
#line 193 "../src/data/sources/humble/HumbleGame.vala"
	__vala_JsonNode_free0 (_data_->_vala1_product_node);
#line 193 "../src/data/sources/humble/HumbleGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 193 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_state_ != 0) {
#line 193 "../src/data/sources/humble/HumbleGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 193 "../src/data/sources/humble/HumbleGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3150 "HumbleGame.c"
		}
	}
#line 193 "../src/data/sources/humble/HumbleGame.vala"
	g_object_unref (_data_->_async_result);
#line 193 "../src/data/sources/humble/HumbleGame.vala"
	return FALSE;
#line 3157 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_update_installers_data_free (gpointer _data)
{
	GameHubDataSourcesHumbleHumbleGameUpdateInstallersData* _data_;
	_data_ = _data;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_slice_free (GameHubDataSourcesHumbleHumbleGameUpdateInstallersData, _data_);
#line 3169 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_update_installers (GameHubDataSourcesHumbleHumbleGame* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGameUpdateInstallersData* _data_;
	GameHubDataSourcesHumbleHumbleGame* _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_return_if_fail (self != NULL);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesHumbleHumbleGameUpdateInstallersData);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_humble_humble_game_update_installers_data_free);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_update_installers_co (_data_);
#line 3193 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_update_installers_finish (GameHubDataSourcesHumbleHumbleGame* self,
                                                                   GAsyncResult* _res_)
{
	GameHubDataSourcesHumbleHumbleGameUpdateInstallersData* _data_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3203 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_update_installers_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGameUpdateInstallersData* _data_;
#line 332 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = _user_data_;
#line 332 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_source_object_ = source_object;
#line 332 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_res_ = _res_;
#line 332 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_update_installers_co (_data_);
#line 3220 "HumbleGame.c"
}

static GNotification*
___lambda51_ (GameHubDataSourcesHumbleHumbleGame* self,
              GNotification* n)
{
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GFile* cached_icon = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GameHubDataGameSource* _tmp4_;
	GameHubDataGameSource* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GFile* _tmp17_;
	GNotification* _tmp22_;
	GNotification* result;
#line 346 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (n != NULL, NULL);
#line 347 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning");
#line 347 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = _tmp0_;
#line 347 "../src/data/sources/humble/HumbleGame.vala"
	g_notification_set_icon (n, (GIcon*) _tmp1_);
#line 347 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_tmp1_);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp2_ = game_hub_data_game_get_icon ((GameHubDataGame*) self);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = _tmp2_;
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp4_ = game_hub_data_game_get_source ((GameHubDataGame*) self);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp5_ = _tmp4_;
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp6_ = game_hub_data_game_source_get_id (_tmp5_);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp7_ = _tmp6_;
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp8_ = string_to_string (_tmp7_);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp9_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) self);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp10_ = _tmp9_;
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp11_ = string_to_string (_tmp10_);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp12_ = g_strconcat (_tmp8_, "/", _tmp11_, "/icons/", NULL);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp13_ = _tmp12_;
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp14_ = game_hub_utils_image_cache_local_file (_tmp3_, _tmp13_);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_tmp15_ = _tmp14_;
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp13_);
#line 348 "../src/data/sources/humble/HumbleGame.vala"
	cached_icon = _tmp15_;
#line 349 "../src/data/sources/humble/HumbleGame.vala"
	_tmp17_ = cached_icon;
#line 349 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp17_ != NULL) {
#line 3294 "HumbleGame.c"
		GFile* _tmp18_;
#line 349 "../src/data/sources/humble/HumbleGame.vala"
		_tmp18_ = cached_icon;
#line 349 "../src/data/sources/humble/HumbleGame.vala"
		_tmp16_ = g_file_query_exists (_tmp18_, NULL);
#line 3300 "HumbleGame.c"
	} else {
#line 349 "../src/data/sources/humble/HumbleGame.vala"
		_tmp16_ = FALSE;
#line 3304 "HumbleGame.c"
	}
#line 349 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp16_) {
#line 3308 "HumbleGame.c"
		GFile* _tmp19_;
		GFileIcon* _tmp20_;
		GFileIcon* _tmp21_;
#line 351 "../src/data/sources/humble/HumbleGame.vala"
		_tmp19_ = cached_icon;
#line 351 "../src/data/sources/humble/HumbleGame.vala"
		_tmp20_ = (GFileIcon*) g_file_icon_new (_tmp19_);
#line 351 "../src/data/sources/humble/HumbleGame.vala"
		_tmp21_ = _tmp20_;
#line 351 "../src/data/sources/humble/HumbleGame.vala"
		g_notification_set_icon (n, (GIcon*) _tmp21_);
#line 351 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (_tmp21_);
#line 3322 "HumbleGame.c"
	}
#line 353 "../src/data/sources/humble/HumbleGame.vala"
	_tmp22_ = _g_object_ref0 (n);
#line 353 "../src/data/sources/humble/HumbleGame.vala"
	result = _tmp22_;
#line 353 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (cached_icon);
#line 353 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 3332 "HumbleGame.c"
}

static GNotification*
____lambda51__game_hub_utils_notification_configure_delegate (GNotification* notification,
                                                              gpointer self)
{
	GNotification* result;
	result = ___lambda51_ ((GameHubDataSourcesHumbleHumbleGame*) self, notification);
#line 342 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 3343 "HumbleGame.c"
}

static gboolean
game_hub_data_sources_humble_humble_game_update_installers_co (GameHubDataSourcesHumbleHumbleGameUpdateInstallersData* _data_)
{
#line 282 "../src/data/sources/humble/HumbleGame.vala"
	switch (_data_->_state_) {
#line 282 "../src/data/sources/humble/HumbleGame.vala"
		case 0:
#line 3353 "HumbleGame.c"
		goto _state_0;
#line 282 "../src/data/sources/humble/HumbleGame.vala"
		case 1:
#line 3357 "HumbleGame.c"
		goto _state_1;
#line 282 "../src/data/sources/humble/HumbleGame.vala"
		case 2:
#line 3361 "HumbleGame.c"
		goto _state_2;
		default:
#line 282 "../src/data/sources/humble/HumbleGame.vala"
		g_assert_not_reached ();
#line 3366 "HumbleGame.c"
	}
	_state_0:
#line 284 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp0_ = _data_->self->priv->_installers;
#line 284 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp0_);
#line 284 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 284 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp2_ > 0) {
#line 284 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 284 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 284 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 284 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3385 "HumbleGame.c"
			}
		}
#line 284 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 284 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 3392 "HumbleGame.c"
	}
#line 286 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp3_ = game_hub_data_game_get_info ((GameHubDataGame*) _data_->self);
#line 286 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 286 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp5_ = game_hub_utils_parser_parse_json (_data_->_tmp4_);
#line 286 "../src/data/sources/humble/HumbleGame.vala"
	_data_->product_node = _data_->_tmp5_;
#line 287 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp7_ = _data_->product_node;
#line 287 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp7_ == NULL) {
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp6_ = TRUE;
#line 3408 "HumbleGame.c"
	} else {
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp8_ = _data_->product_node;
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp6_ = json_node_get_node_type (_data_->_tmp8_) != JSON_NODE_OBJECT;
#line 3414 "HumbleGame.c"
	}
#line 287 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp6_) {
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (_data_->product_node);
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 287 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 287 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3428 "HumbleGame.c"
			}
		}
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 287 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 3435 "HumbleGame.c"
	}
#line 289 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp9_ = _data_->product_node;
#line 289 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp10_ = json_node_get_object (_data_->_tmp9_);
#line 289 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp11_ = _json_object_ref0 (_data_->_tmp10_);
#line 289 "../src/data/sources/humble/HumbleGame.vala"
	_data_->product = _data_->_tmp11_;
#line 290 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp12_ = _data_->product;
#line 290 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp12_ == NULL) {
#line 290 "../src/data/sources/humble/HumbleGame.vala"
		_json_object_unref0 (_data_->product);
#line 290 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (_data_->product_node);
#line 290 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 290 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 290 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 290 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3461 "HumbleGame.c"
			}
		}
#line 290 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 290 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 3468 "HumbleGame.c"
	}
#line 292 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp13_ = _data_->product;
#line 292 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (_data_->_tmp13_, "downloads")) {
#line 294 "../src/data/sources/humble/HumbleGame.vala"
		_data_->refresh = FALSE;
#line 296 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp14_ = _data_->product;
#line 296 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp15_ = json_object_get_member (_data_->_tmp14_, "downloads");
#line 296 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp16_ = __vala_JsonNode_copy0 (_data_->_tmp15_);
#line 296 "../src/data/sources/humble/HumbleGame.vala"
		_data_->downloads_node = _data_->_tmp16_;
#line 297 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp17_ = _data_->downloads_node;
#line 297 "../src/data/sources/humble/HumbleGame.vala"
		switch (json_node_get_node_type (_data_->_tmp17_)) {
#line 297 "../src/data/sources/humble/HumbleGame.vala"
			case JSON_NODE_ARRAY:
#line 3490 "HumbleGame.c"
			{
#line 300 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp18_ = _data_->downloads_node;
#line 300 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp19_ = json_node_get_array (_data_->_tmp18_);
#line 300 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp20_ = json_array_get_elements (_data_->_tmp19_);
#line 3498 "HumbleGame.c"
				{
#line 300 "../src/data/sources/humble/HumbleGame.vala"
					_data_->dl_node_collection = _data_->_tmp20_;
#line 300 "../src/data/sources/humble/HumbleGame.vala"
					for (_data_->dl_node_it = _data_->dl_node_collection; _data_->dl_node_it != NULL; _data_->dl_node_it = _data_->dl_node_it->next) {
#line 300 "../src/data/sources/humble/HumbleGame.vala"
						_data_->dl_node = (JsonNode*) _data_->dl_node_it->data;
#line 3506 "HumbleGame.c"
						{
#line 302 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp21_ = _data_->dl_node;
#line 302 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp22_ = json_node_get_object (_data_->_tmp21_);
#line 302 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp23_ = _json_object_ref0 (_data_->_tmp22_);
#line 302 "../src/data/sources/humble/HumbleGame.vala"
							_data_->dl = _data_->_tmp23_;
#line 303 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp24_ = _data_->dl;
#line 303 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp25_ = json_object_get_string_member (_data_->_tmp24_, "machine_name");
#line 303 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
#line 303 "../src/data/sources/humble/HumbleGame.vala"
							_data_->id = _data_->_tmp26_;
#line 304 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp28_ = _data_->dl;
#line 304 "../src/data/sources/humble/HumbleGame.vala"
							if (json_object_has_member (_data_->_tmp28_, "download_identifier")) {
#line 304 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp29_ = _data_->dl;
#line 304 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp30_ = json_object_get_string_member (_data_->_tmp29_, "download_identifier");
#line 304 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp27_ = _data_->_tmp30_;
#line 3534 "HumbleGame.c"
							} else {
#line 304 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp27_ = NULL;
#line 3538 "HumbleGame.c"
							}
#line 304 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp31_ = g_strdup (_data_->_tmp27_);
#line 304 "../src/data/sources/humble/HumbleGame.vala"
							_data_->dl_id = _data_->_tmp31_;
#line 305 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp32_ = _data_->dl;
#line 305 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp33_ = json_object_get_string_member (_data_->_tmp32_, "platform");
#line 305 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp34_ = g_strdup (_data_->_tmp33_);
#line 305 "../src/data/sources/humble/HumbleGame.vala"
							_data_->os = _data_->_tmp34_;
#line 306 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp36_ = _data_->dl;
#line 306 "../src/data/sources/humble/HumbleGame.vala"
							if (json_object_has_member (_data_->_tmp36_, "download_struct")) {
#line 306 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp37_ = _data_->dl;
#line 306 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp38_ = json_object_get_member (_data_->_tmp37_, "download_struct");
#line 306 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp35_ = json_node_get_node_type (_data_->_tmp38_) == JSON_NODE_ARRAY;
#line 3562 "HumbleGame.c"
							} else {
#line 306 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp35_ = FALSE;
#line 3566 "HumbleGame.c"
							}
#line 306 "../src/data/sources/humble/HumbleGame.vala"
							if (_data_->_tmp35_) {
#line 308 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp39_ = _data_->dl;
#line 308 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp40_ = json_object_get_array_member (_data_->_tmp39_, "download_struct");
#line 308 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp41_ = json_array_get_elements (_data_->_tmp40_);
#line 3576 "HumbleGame.c"
								{
#line 308 "../src/data/sources/humble/HumbleGame.vala"
									_data_->dls_node_collection = _data_->_tmp41_;
#line 308 "../src/data/sources/humble/HumbleGame.vala"
									for (_data_->dls_node_it = _data_->dls_node_collection; _data_->dls_node_it != NULL; _data_->dls_node_it = _data_->dls_node_it->next) {
#line 308 "../src/data/sources/humble/HumbleGame.vala"
										_data_->dls_node = (JsonNode*) _data_->dls_node_it->data;
#line 3584 "HumbleGame.c"
										{
#line 310 "../src/data/sources/humble/HumbleGame.vala"
											_data_->_tmp42_ = _data_->id;
#line 310 "../src/data/sources/humble/HumbleGame.vala"
											_data_->_tmp43_ = _data_->dl_id;
#line 310 "../src/data/sources/humble/HumbleGame.vala"
											_data_->_tmp44_ = _data_->os;
#line 310 "../src/data/sources/humble/HumbleGame.vala"
											_data_->_tmp45_ = _data_->dls_node;
#line 310 "../src/data/sources/humble/HumbleGame.vala"
											_data_->_tmp46_ = json_node_get_object (_data_->_tmp45_);
#line 310 "../src/data/sources/humble/HumbleGame.vala"
											_data_->refresh = game_hub_data_sources_humble_humble_game_process_download (_data_->self, _data_->_tmp42_, _data_->_tmp43_, _data_->_tmp44_, _data_->_tmp46_);
#line 3598 "HumbleGame.c"
										}
									}
#line 308 "../src/data/sources/humble/HumbleGame.vala"
									(_data_->dls_node_collection == NULL) ? NULL : (_data_->dls_node_collection = (g_list_free (_data_->dls_node_collection), NULL));
#line 3603 "HumbleGame.c"
								}
							}
#line 300 "../src/data/sources/humble/HumbleGame.vala"
							_g_free0 (_data_->os);
#line 300 "../src/data/sources/humble/HumbleGame.vala"
							_g_free0 (_data_->dl_id);
#line 300 "../src/data/sources/humble/HumbleGame.vala"
							_g_free0 (_data_->id);
#line 300 "../src/data/sources/humble/HumbleGame.vala"
							_json_object_unref0 (_data_->dl);
#line 3614 "HumbleGame.c"
						}
					}
#line 300 "../src/data/sources/humble/HumbleGame.vala"
					(_data_->dl_node_collection == NULL) ? NULL : (_data_->dl_node_collection = (g_list_free (_data_->dl_node_collection), NULL));
#line 3619 "HumbleGame.c"
				}
#line 314 "../src/data/sources/humble/HumbleGame.vala"
				break;
#line 3623 "HumbleGame.c"
			}
#line 297 "../src/data/sources/humble/HumbleGame.vala"
			case JSON_NODE_OBJECT:
#line 3627 "HumbleGame.c"
			{
#line 317 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp47_ = _data_->downloads_node;
#line 317 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp48_ = json_node_get_object (_data_->_tmp47_);
#line 317 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp49_ = json_object_get_members (_data_->_tmp48_);
#line 3635 "HumbleGame.c"
				{
#line 317 "../src/data/sources/humble/HumbleGame.vala"
					_data_->os_collection = _data_->_tmp49_;
#line 317 "../src/data/sources/humble/HumbleGame.vala"
					for (_data_->os_it = _data_->os_collection; _data_->os_it != NULL; _data_->os_it = _data_->os_it->next) {
#line 317 "../src/data/sources/humble/HumbleGame.vala"
						_data_->_vala1_os = (const gchar*) _data_->os_it->data;
#line 3643 "HumbleGame.c"
						{
#line 319 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp50_ = _data_->downloads_node;
#line 319 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp51_ = json_node_get_object (_data_->_tmp50_);
#line 319 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp52_ = _data_->_vala1_os;
#line 319 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp53_ = json_object_get_object_member (_data_->_tmp51_, _data_->_tmp52_);
#line 319 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp54_ = _json_object_ref0 (_data_->_tmp53_);
#line 319 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_vala1_dl = _data_->_tmp54_;
#line 320 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp55_ = _data_->_vala1_dl;
#line 320 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp56_ = json_object_get_string_member (_data_->_tmp55_, "machine_name");
#line 320 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp57_ = g_strdup (_data_->_tmp56_);
#line 320 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_vala1_id = _data_->_tmp57_;
#line 321 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp59_ = _data_->_vala1_dl;
#line 321 "../src/data/sources/humble/HumbleGame.vala"
							if (json_object_has_member (_data_->_tmp59_, "download_identifier")) {
#line 321 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp60_ = _data_->_vala1_dl;
#line 321 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp61_ = json_object_get_string_member (_data_->_tmp60_, "download_identifier");
#line 321 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp58_ = _data_->_tmp61_;
#line 3675 "HumbleGame.c"
							} else {
#line 321 "../src/data/sources/humble/HumbleGame.vala"
								_data_->_tmp58_ = NULL;
#line 3679 "HumbleGame.c"
							}
#line 321 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp62_ = g_strdup (_data_->_tmp58_);
#line 321 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_vala1_dl_id = _data_->_tmp62_;
#line 322 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp63_ = _data_->_vala1_id;
#line 322 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp64_ = _data_->_vala1_dl_id;
#line 322 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp65_ = _data_->_vala1_os;
#line 322 "../src/data/sources/humble/HumbleGame.vala"
							_data_->_tmp66_ = _data_->_vala1_dl;
#line 322 "../src/data/sources/humble/HumbleGame.vala"
							_data_->refresh = game_hub_data_sources_humble_humble_game_process_download (_data_->self, _data_->_tmp63_, _data_->_tmp64_, _data_->_tmp65_, _data_->_tmp66_);
#line 317 "../src/data/sources/humble/HumbleGame.vala"
							_g_free0 (_data_->_vala1_dl_id);
#line 317 "../src/data/sources/humble/HumbleGame.vala"
							_g_free0 (_data_->_vala1_id);
#line 317 "../src/data/sources/humble/HumbleGame.vala"
							_json_object_unref0 (_data_->_vala1_dl);
#line 3701 "HumbleGame.c"
						}
					}
#line 317 "../src/data/sources/humble/HumbleGame.vala"
					(_data_->os_collection == NULL) ? NULL : (_data_->os_collection = (g_list_free (_data_->os_collection), NULL));
#line 3706 "HumbleGame.c"
				}
#line 324 "../src/data/sources/humble/HumbleGame.vala"
				break;
#line 3710 "HumbleGame.c"
			}
			default:
#line 297 "../src/data/sources/humble/HumbleGame.vala"
			break;
#line 3715 "HumbleGame.c"
		}
#line 327 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->refresh) {
#line 327 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp67_ = !_data_->self->priv->game_info_refreshed;
#line 3721 "HumbleGame.c"
		} else {
#line 327 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp67_ = FALSE;
#line 3725 "HumbleGame.c"
		}
#line 327 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp67_) {
#line 329 "../src/data/sources/humble/HumbleGame.vala"
			_data_->self->priv->game_info_refreshed = TRUE;
#line 330 "../src/data/sources/humble/HumbleGame.vala"
			_data_->self->priv->game_info_updated = FALSE;
#line 331 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp68_ = _data_->self->priv->_installers;
#line 331 "../src/data/sources/humble/HumbleGame.vala"
			gee_abstract_collection_clear ((GeeAbstractCollection*) _data_->_tmp68_);
#line 332 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_state_ = 1;
#line 332 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_game_update_game_info ((GameHubDataGame*) _data_->self, game_hub_data_sources_humble_humble_game_update_installers_ready, _data_);
#line 332 "../src/data/sources/humble/HumbleGame.vala"
			return FALSE;
#line 3743 "HumbleGame.c"
			_state_1:
#line 332 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_game_update_game_info_finish ((GameHubDataGame*) _data_->self, _data_->_res_);
#line 333 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_state_ = 2;
#line 333 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_sources_humble_humble_game_update_installers (_data_->self, game_hub_data_sources_humble_humble_game_update_installers_ready, _data_);
#line 333 "../src/data/sources/humble/HumbleGame.vala"
			return FALSE;
#line 3753 "HumbleGame.c"
			_state_2:
#line 333 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_sources_humble_humble_game_update_installers_finish (_data_->self, _data_->_res_);
#line 334 "../src/data/sources/humble/HumbleGame.vala"
			__vala_JsonNode_free0 (_data_->downloads_node);
#line 334 "../src/data/sources/humble/HumbleGame.vala"
			_json_object_unref0 (_data_->product);
#line 334 "../src/data/sources/humble/HumbleGame.vala"
			__vala_JsonNode_free0 (_data_->product_node);
#line 334 "../src/data/sources/humble/HumbleGame.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 334 "../src/data/sources/humble/HumbleGame.vala"
			if (_data_->_state_ != 0) {
#line 334 "../src/data/sources/humble/HumbleGame.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 334 "../src/data/sources/humble/HumbleGame.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3771 "HumbleGame.c"
				}
			}
#line 334 "../src/data/sources/humble/HumbleGame.vala"
			g_object_unref (_data_->_async_result);
#line 334 "../src/data/sources/humble/HumbleGame.vala"
			return FALSE;
#line 3778 "HumbleGame.c"
		}
#line 292 "../src/data/sources/humble/HumbleGame.vala"
		__vala_JsonNode_free0 (_data_->downloads_node);
#line 3782 "HumbleGame.c"
	}
#line 338 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp69_ = _data_->self->priv->_installers;
#line 338 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp70_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp69_);
#line 338 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp71_ = _data_->_tmp70_;
#line 338 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_game_set_is_installable ((GameHubDataGame*) _data_->self, _data_->_tmp71_ > 0);
#line 340 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp73_ = _data_->self->priv->_installers;
#line 340 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp74_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp73_);
#line 340 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp75_ = _data_->_tmp74_;
#line 340 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp75_ == 0) {
#line 340 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp76_ = game_hub_data_game_get_source ((GameHubDataGame*) _data_->self);
#line 340 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp77_ = _data_->_tmp76_;
#line 340 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp72_ = GAME_HUB_DATA_SOURCES_HUMBLE_IS_TROVE (_data_->_tmp77_);
#line 3806 "HumbleGame.c"
	} else {
#line 340 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp72_ = FALSE;
#line 3810 "HumbleGame.c"
	}
#line 340 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp72_) {
#line 342 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp78_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) _data_->self);
#line 342 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp79_ = _data_->_tmp78_;
#line 342 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp80_ = g_strdup_printf (_ ("%s: no available installers"), _data_->_tmp79_);
#line 342 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp81_ = _data_->_tmp80_;
#line 342 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_utils_notify (_data_->_tmp81_, _ ("Cannot get Trove download URL.\n" \
"Make sure your Humble Monthly subscription is active."), G_NOTIFICATION_PRIORITY_HIGH, ____lambda51__game_hub_utils_notification_configure_delegate, _data_->self);
#line 342 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_data_->_tmp81_);
#line 3826 "HumbleGame.c"
	}
#line 282 "../src/data/sources/humble/HumbleGame.vala"
	_json_object_unref0 (_data_->product);
#line 282 "../src/data/sources/humble/HumbleGame.vala"
	__vala_JsonNode_free0 (_data_->product_node);
#line 282 "../src/data/sources/humble/HumbleGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 282 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_state_ != 0) {
#line 282 "../src/data/sources/humble/HumbleGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 282 "../src/data/sources/humble/HumbleGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3840 "HumbleGame.c"
		}
	}
#line 282 "../src/data/sources/humble/HumbleGame.vala"
	g_object_unref (_data_->_async_result);
#line 282 "../src/data/sources/humble/HumbleGame.vala"
	return FALSE;
#line 3847 "HumbleGame.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 3869 "HumbleGame.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 3873 "HumbleGame.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 3879 "HumbleGame.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 3883 "HumbleGame.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 3887 "HumbleGame.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 3895 "HumbleGame.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 3923 "HumbleGame.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 3932 "HumbleGame.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 3946 "HumbleGame.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 3955 "HumbleGame.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 3969 "HumbleGame.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 3978 "HumbleGame.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 3987 "HumbleGame.c"
}

static gboolean
game_hub_data_sources_humble_humble_game_process_download (GameHubDataSourcesHumbleHumbleGame* self,
                                                           const gchar* id,
                                                           const gchar* dl_id,
                                                           const gchar* os,
                                                           JsonObject* dl_struct)
{
	GameHubDataPlatform platform = 0;
	gboolean refresh = FALSE;
	GameHubDataSourcesHumbleHumbleGameInstaller* installer = NULL;
	GameHubDataSourcesHumbleHumbleGameInstaller* _tmp3_;
	GameHubDataSourcesHumbleHumbleGameInstaller* _tmp4_;
	gboolean result;
#line 359 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 359 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 359 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (os != NULL, FALSE);
#line 359 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (dl_struct != NULL, FALSE);
#line 361 "../src/data/sources/humble/HumbleGame.vala"
	platform = GAME_HUB_DATA_PLATFORM_CURRENT;
#line 4013 "HumbleGame.c"
	{
		GameHubDataPlatform* p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
#line 362 "../src/data/sources/humble/HumbleGame.vala"
		p_collection = GAME_HUB_DATA_PLATFORM_PLATFORMS;
#line 362 "../src/data/sources/humble/HumbleGame.vala"
		p_collection_length1 = G_N_ELEMENTS (GAME_HUB_DATA_PLATFORM_PLATFORMS);
#line 362 "../src/data/sources/humble/HumbleGame.vala"
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 4025 "HumbleGame.c"
			GameHubDataPlatform p = 0;
#line 362 "../src/data/sources/humble/HumbleGame.vala"
			p = p_collection[p_it];
#line 4029 "HumbleGame.c"
			{
				gchar* _tmp0_;
				gchar* _tmp1_;
				gboolean _tmp2_;
#line 364 "../src/data/sources/humble/HumbleGame.vala"
				_tmp0_ = game_hub_data_platform_id (p);
#line 364 "../src/data/sources/humble/HumbleGame.vala"
				_tmp1_ = _tmp0_;
#line 364 "../src/data/sources/humble/HumbleGame.vala"
				_tmp2_ = g_strcmp0 (os, _tmp1_) == 0;
#line 364 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (_tmp1_);
#line 364 "../src/data/sources/humble/HumbleGame.vala"
				if (_tmp2_) {
#line 366 "../src/data/sources/humble/HumbleGame.vala"
					platform = p;
#line 367 "../src/data/sources/humble/HumbleGame.vala"
					break;
#line 4048 "HumbleGame.c"
				}
			}
		}
	}
#line 371 "../src/data/sources/humble/HumbleGame.vala"
	refresh = FALSE;
#line 373 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = game_hub_data_sources_humble_humble_game_installer_new (self, id, dl_id, platform, dl_struct);
#line 373 "../src/data/sources/humble/HumbleGame.vala"
	installer = _tmp3_;
#line 374 "../src/data/sources/humble/HumbleGame.vala"
	_tmp4_ = installer;
#line 374 "../src/data/sources/humble/HumbleGame.vala"
	if (game_hub_data_sources_humble_humble_game_installer_is_url_update_required (_tmp4_)) {
#line 4063 "HumbleGame.c"
		GameHubDataGameSource* _tmp5_;
		GameHubDataGameSource* _tmp6_;
#line 376 "../src/data/sources/humble/HumbleGame.vala"
		_tmp5_ = game_hub_data_game_get_source ((GameHubDataGame*) self);
#line 376 "../src/data/sources/humble/HumbleGame.vala"
		_tmp6_ = _tmp5_;
#line 376 "../src/data/sources/humble/HumbleGame.vala"
		if (GAME_HUB_DATA_SOURCES_HUMBLE_IS_TROVE (_tmp6_)) {
#line 4072 "HumbleGame.c"
			gchar* old_url = NULL;
			GameHubDataSourcesHumbleHumbleGameInstaller* _tmp7_;
			GameHubDataRunnableDownloadableInstallerPart* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* new_url = NULL;
			GameHubDataSourcesHumbleHumbleGameInstaller* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
#line 378 "../src/data/sources/humble/HumbleGame.vala"
			_tmp7_ = installer;
#line 378 "../src/data/sources/humble/HumbleGame.vala"
			_tmp8_ = _tmp7_->part;
#line 378 "../src/data/sources/humble/HumbleGame.vala"
			_tmp9_ = game_hub_data_runnable_downloadable_installer_part_get_url (_tmp8_);
#line 378 "../src/data/sources/humble/HumbleGame.vala"
			_tmp10_ = _tmp9_;
#line 378 "../src/data/sources/humble/HumbleGame.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 378 "../src/data/sources/humble/HumbleGame.vala"
			old_url = _tmp11_;
#line 379 "../src/data/sources/humble/HumbleGame.vala"
			_tmp12_ = installer;
#line 379 "../src/data/sources/humble/HumbleGame.vala"
			_tmp13_ = game_hub_data_sources_humble_humble_game_installer_update_url (_tmp12_, self);
#line 379 "../src/data/sources/humble/HumbleGame.vala"
			new_url = _tmp13_;
#line 380 "../src/data/sources/humble/HumbleGame.vala"
			_tmp14_ = new_url;
#line 380 "../src/data/sources/humble/HumbleGame.vala"
			if (_tmp14_ != NULL) {
#line 4105 "HumbleGame.c"
				gchar* url_field = NULL;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
#line 382 "../src/data/sources/humble/HumbleGame.vala"
				_tmp15_ = g_strdup ("\"%s\"");
#line 382 "../src/data/sources/humble/HumbleGame.vala"
				url_field = _tmp15_;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp16_ = game_hub_data_game_get_info ((GameHubDataGame*) self);
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp17_ = _tmp16_;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp18_ = url_field;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp19_ = old_url;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp20_ = g_strdup_printf (_tmp18_, _tmp19_);
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp21_ = _tmp20_;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp22_ = url_field;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp23_ = new_url;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp24_ = g_strdup_printf (_tmp22_, _tmp23_);
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp25_ = _tmp24_;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp26_ = string_replace (_tmp17_, _tmp21_, _tmp25_);
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_tmp27_ = _tmp26_;
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				game_hub_data_game_set_info ((GameHubDataGame*) self, _tmp27_);
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (_tmp27_);
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (_tmp25_);
#line 383 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (_tmp21_);
#line 380 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (url_field);
#line 4158 "HumbleGame.c"
			}
#line 385 "../src/data/sources/humble/HumbleGame.vala"
			refresh = TRUE;
#line 376 "../src/data/sources/humble/HumbleGame.vala"
			_g_free0 (new_url);
#line 376 "../src/data/sources/humble/HumbleGame.vala"
			_g_free0 (old_url);
#line 4166 "HumbleGame.c"
		} else {
#line 389 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_game_set_info ((GameHubDataGame*) self, NULL);
#line 390 "../src/data/sources/humble/HumbleGame.vala"
			refresh = TRUE;
#line 4172 "HumbleGame.c"
		}
	}
#line 393 "../src/data/sources/humble/HumbleGame.vala"
	if (!refresh) {
#line 4177 "HumbleGame.c"
		GeeArrayList* _tmp28_;
		GameHubDataSourcesHumbleHumbleGameInstaller* _tmp29_;
#line 393 "../src/data/sources/humble/HumbleGame.vala"
		_tmp28_ = self->priv->_installers;
#line 393 "../src/data/sources/humble/HumbleGame.vala"
		_tmp29_ = installer;
#line 393 "../src/data/sources/humble/HumbleGame.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (GameHubDataRunnableInstaller*) _tmp29_);
#line 4186 "HumbleGame.c"
	}
#line 395 "../src/data/sources/humble/HumbleGame.vala"
	result = refresh;
#line 395 "../src/data/sources/humble/HumbleGame.vala"
	_game_hub_data_runnable_installer_unref0 (installer);
#line 395 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 4194 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_install_data_free (gpointer _data)
{
	GameHubDataSourcesHumbleHumbleGameInstallData* _data_;
	_data_ = _data;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_slice_free (GameHubDataSourcesHumbleHumbleGameInstallData, _data_);
#line 4206 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_install (GameHubDataRunnable* base,
                                                       GameHubDataRunnableInstallerInstallMode install_mode,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGame * self;
	GameHubDataSourcesHumbleHumbleGameInstallData* _data_;
	GameHubDataSourcesHumbleHumbleGame* _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) base;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesHumbleHumbleGameInstallData);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_humble_humble_game_real_install_data_free);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->install_mode = install_mode;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_real_install_co (_data_);
#line 4234 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_install_finish (GameHubDataRunnable* base,
                                                         GAsyncResult* _res_)
{
	GameHubDataSourcesHumbleHumbleGameInstallData* _data_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4244 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_install_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGameInstallData* _data_;
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = _user_data_;
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_source_object_ = source_object;
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_res_ = _res_;
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_real_install_co (_data_);
#line 4261 "HumbleGame.c"
}

static gboolean
_game_hub_data_sources_humble_humble_game_real_install_co_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hub_data_sources_humble_humble_game_real_install_co (self);
#line 402 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 4271 "HumbleGame.c"
}

static gboolean
game_hub_data_sources_humble_humble_game_real_install_co (GameHubDataSourcesHumbleHumbleGameInstallData* _data_)
{
#line 398 "../src/data/sources/humble/HumbleGame.vala"
	switch (_data_->_state_) {
#line 398 "../src/data/sources/humble/HumbleGame.vala"
		case 0:
#line 4281 "HumbleGame.c"
		goto _state_0;
#line 398 "../src/data/sources/humble/HumbleGame.vala"
		case 1:
#line 4285 "HumbleGame.c"
		goto _state_1;
#line 398 "../src/data/sources/humble/HumbleGame.vala"
		case 2:
#line 4289 "HumbleGame.c"
		goto _state_2;
		default:
#line 398 "../src/data/sources/humble/HumbleGame.vala"
		g_assert_not_reached ();
#line 4294 "HumbleGame.c"
	}
	_state_0:
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_state_ = 1;
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_update_installers (_data_->self, game_hub_data_sources_humble_humble_game_install_ready, _data_);
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	return FALSE;
#line 4303 "HumbleGame.c"
	_state_1:
#line 400 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_update_installers_finish (_data_->self, _data_->_res_);
#line 401 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp0_ = _data_->self->priv->_installers;
#line 401 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp0_);
#line 401 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 401 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp2_ < 1) {
#line 401 "../src/data/sources/humble/HumbleGame.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 401 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_state_ != 0) {
#line 401 "../src/data/sources/humble/HumbleGame.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 401 "../src/data/sources/humble/HumbleGame.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4323 "HumbleGame.c"
			}
		}
#line 401 "../src/data/sources/humble/HumbleGame.vala"
		g_object_unref (_data_->_async_result);
#line 401 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 4330 "HumbleGame.c"
	}
#line 402 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp3_ = _data_->self->priv->_installers;
#line 402 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp4_ = game_hub_ui_dialogs_install_dialog_new ((GameHubDataRunnable*) _data_->self, _data_->_tmp3_, _data_->install_mode, _game_hub_data_sources_humble_humble_game_real_install_co_gsource_func, _data_, NULL);
#line 402 "../src/data/sources/humble/HumbleGame.vala"
	g_object_ref_sink (_data_->_tmp4_);
#line 402 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 402 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_data_->_tmp5_);
#line 403 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_state_ = 2;
#line 403 "../src/data/sources/humble/HumbleGame.vala"
	return FALSE;
#line 4346 "HumbleGame.c"
	_state_2:
	;
#line 398 "../src/data/sources/humble/HumbleGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 398 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_state_ != 0) {
#line 398 "../src/data/sources/humble/HumbleGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 398 "../src/data/sources/humble/HumbleGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4357 "HumbleGame.c"
		}
	}
#line 398 "../src/data/sources/humble/HumbleGame.vala"
	g_object_unref (_data_->_async_result);
#line 398 "../src/data/sources/humble/HumbleGame.vala"
	return FALSE;
#line 4364 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_uninstall_data_free (gpointer _data)
{
	GameHubDataSourcesHumbleHumbleGameUninstallData* _data_;
	_data_ = _data;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_slice_free (GameHubDataSourcesHumbleHumbleGameUninstallData, _data_);
#line 4376 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_uninstall (GameHubDataGame* base,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGame * self;
	GameHubDataSourcesHumbleHumbleGameUninstallData* _data_;
	GameHubDataSourcesHumbleHumbleGame* _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) base;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_slice_new0 (GameHubDataSourcesHumbleHumbleGameUninstallData);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_sources_humble_humble_game_real_uninstall_data_free);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_real_uninstall_co (_data_);
#line 4401 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_uninstall_finish (GameHubDataGame* base,
                                                           GAsyncResult* _res_)
{
	GameHubDataSourcesHumbleHumbleGameUninstallData* _data_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4411 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_uninstall_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GameHubDataSourcesHumbleHumbleGameUninstallData* _data_;
#line 410 "../src/data/sources/humble/HumbleGame.vala"
	_data_ = _user_data_;
#line 410 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_source_object_ = source_object;
#line 410 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_res_ = _res_;
#line 410 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_real_uninstall_co (_data_);
#line 4428 "HumbleGame.c"
}

static gboolean
game_hub_data_sources_humble_humble_game_real_uninstall_co (GameHubDataSourcesHumbleHumbleGameUninstallData* _data_)
{
#line 406 "../src/data/sources/humble/HumbleGame.vala"
	switch (_data_->_state_) {
#line 406 "../src/data/sources/humble/HumbleGame.vala"
		case 0:
#line 4438 "HumbleGame.c"
		goto _state_0;
#line 406 "../src/data/sources/humble/HumbleGame.vala"
		case 1:
#line 4442 "HumbleGame.c"
		goto _state_1;
		default:
#line 406 "../src/data/sources/humble/HumbleGame.vala"
		g_assert_not_reached ();
#line 4447 "HumbleGame.c"
	}
	_state_0:
#line 408 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp1_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 408 "../src/data/sources/humble/HumbleGame.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 408 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp2_ != NULL) {
#line 408 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp3_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 408 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp4_ = _data_->_tmp3_;
#line 408 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp0_ = g_file_query_exists (_data_->_tmp4_, NULL);
#line 4462 "HumbleGame.c"
	} else {
#line 408 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp0_ = FALSE;
#line 4466 "HumbleGame.c"
	}
#line 408 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_tmp0_) {
#line 410 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_state_ = 1;
#line 410 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_umount_overlays ((GameHubDataGame*) _data_->self, game_hub_data_sources_humble_humble_game_uninstall_ready, _data_);
#line 410 "../src/data/sources/humble/HumbleGame.vala"
		return FALSE;
#line 4476 "HumbleGame.c"
		_state_1:
#line 410 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_game_umount_overlays_finish ((GameHubDataGame*) _data_->self, _data_->_res_);
#line 411 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 411 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 411 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp7_ = g_file_get_path (_data_->_tmp6_);
#line 411 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 411 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_utils_fs_utils_rm (_data_->_tmp8_, "", "-rf", NULL);
#line 411 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_data_->_tmp8_);
#line 412 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 413 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp11_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 413 "../src/data/sources/humble/HumbleGame.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 413 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp12_ == NULL) {
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp10_ = TRUE;
#line 4502 "HumbleGame.c"
		} else {
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp13_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp14_ = _data_->_tmp13_;
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp10_ = !g_file_query_exists (_data_->_tmp14_, NULL);
#line 4510 "HumbleGame.c"
		}
#line 413 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp10_) {
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp16_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp18_ = _data_->_tmp17_;
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp19_ = _data_->_tmp18_ == NULL;
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_g_object_unref0 (_data_->_tmp18_);
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			if (_data_->_tmp19_) {
#line 413 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp15_ = TRUE;
#line 4528 "HumbleGame.c"
			} else {
#line 413 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp20_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 413 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp21_ = _data_->_tmp20_;
#line 413 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp22_ = _data_->_tmp21_;
#line 413 "../src/data/sources/humble/HumbleGame.vala"
				_data_->_tmp15_ = !g_file_query_exists (_data_->_tmp22_, NULL);
#line 413 "../src/data/sources/humble/HumbleGame.vala"
				_g_object_unref0 (_data_->_tmp22_);
#line 4540 "HumbleGame.c"
			}
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp9_ = _data_->_tmp15_;
#line 4544 "HumbleGame.c"
		} else {
#line 413 "../src/data/sources/humble/HumbleGame.vala"
			_data_->_tmp9_ = FALSE;
#line 4548 "HumbleGame.c"
		}
#line 413 "../src/data/sources/humble/HumbleGame.vala"
		if (_data_->_tmp9_) {
#line 415 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) _data_->self, NULL);
#line 416 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_runnable_set_executable ((GameHubDataRunnable*) _data_->self, NULL);
#line 417 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_runnable_save ((GameHubDataRunnable*) _data_->self);
#line 418 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 4560 "HumbleGame.c"
		}
	}
#line 406 "../src/data/sources/humble/HumbleGame.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 406 "../src/data/sources/humble/HumbleGame.vala"
	if (_data_->_state_ != 0) {
#line 406 "../src/data/sources/humble/HumbleGame.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 406 "../src/data/sources/humble/HumbleGame.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4571 "HumbleGame.c"
		}
	}
#line 406 "../src/data/sources/humble/HumbleGame.vala"
	g_object_unref (_data_->_async_result);
#line 406 "../src/data/sources/humble/HumbleGame.vala"
	return FALSE;
#line 4578 "HumbleGame.c"
}

static gchar**
game_hub_data_sources_humble_humble_game_real_get_tweaks (GameHubDataTweakableGame* base,
                                                          gint* result_length1)
{
	gchar** result;
	GameHubDataSourcesHumbleHumbleGame* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) base;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = self->priv->_tweaks;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0__length1 = self->priv->_tweaks_length1;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = _tmp0_;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1__length1 = _tmp0__length1;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	if (result_length1) {
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		*result_length1 = _tmp1__length1;
#line 4605 "HumbleGame.c"
	}
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	result = _tmp1_;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 4611 "HumbleGame.c"
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	if (length >= 0) {
#line 4620 "HumbleGame.c"
		gchar** result;
		gssize i;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		result = g_new0 (gchar*, length + 1);
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		for (i = 0; i < length; i++) {
#line 4627 "HumbleGame.c"
			gchar* _tmp0_;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
			_tmp0_ = g_strdup (self[i]);
#line 27 "../src/data/sources/humble/HumbleGame.vala"
			result[i] = _tmp0_;
#line 4633 "HumbleGame.c"
		}
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		return result;
#line 4637 "HumbleGame.c"
	}
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	return NULL;
#line 4641 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_real_set_tweaks (GameHubDataTweakableGame* base,
                                                          gchar** value,
                                                          gint value_length1)
{
	GameHubDataSourcesHumbleHumbleGame* self;
	gchar** old_value;
	gint old_value_length;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) base;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	old_value = game_hub_data_sources_humble_humble_game_real_get_tweaks (base, &old_value_length);
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	if (old_value != value) {
#line 4658 "HumbleGame.c"
		gchar** _tmp0_;
		gint _tmp0__length1;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = (value != NULL) ? _vala_array_dup6 (value, value_length1) : value;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0__length1 = value_length1;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		self->priv->_tweaks = (_vala_array_free (self->priv->_tweaks, self->priv->_tweaks_length1, (GDestroyNotify) g_free), NULL);
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		self->priv->_tweaks = _tmp0_;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		self->priv->_tweaks_length1 = _tmp0__length1;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		self->priv->__tweaks_size_ = self->priv->_tweaks_length1;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_sources_humble_humble_game_properties[GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TWEAKS_PROPERTY]);
#line 4675 "HumbleGame.c"
	}
}

GeeArrayList*
game_hub_data_sources_humble_humble_game_get_installers (GameHubDataSourcesHumbleHumbleGame* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = self->priv->_installers;
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	result = _tmp0_;
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 4692 "HumbleGame.c"
}

void
game_hub_data_sources_humble_humble_game_set_installers (GameHubDataSourcesHumbleHumbleGame* self,
                                                         GeeArrayList* value)
{
	GeeArrayList* old_value;
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	g_return_if_fail (self != NULL);
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	old_value = game_hub_data_sources_humble_humble_game_get_installers (self);
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	if (old_value != value) {
#line 4706 "HumbleGame.c"
		GeeArrayList* _tmp0_;
#line 35 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 35 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (self->priv->_installers);
#line 35 "../src/data/sources/humble/HumbleGame.vala"
		self->priv->_installers = _tmp0_;
#line 35 "../src/data/sources/humble/HumbleGame.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_sources_humble_humble_game_properties[GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLERS_PROPERTY]);
#line 4716 "HumbleGame.c"
	}
}

static GFile*
game_hub_data_sources_humble_humble_game_real_get_default_install_dir (GameHubDataRunnable* base)
{
	GFile* result;
	GameHubDataSourcesHumbleHumbleGame* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
#line 39 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGame*) base;
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = game_hub_utils_fs_utils_paths_humble_get_Games ();
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = _tmp0_;
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_tmp2_ = _tmp1_;
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = game_hub_data_runnable_get_escaped_name ((GameHubDataRunnable*) self);
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_tmp4_ = _tmp3_;
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_tmp5_ = game_hub_utils_fs_utils_file (_tmp2_, _tmp4_, NULL);
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_tmp6_ = _tmp5_;
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp2_);
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	result = _tmp6_;
#line 41 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 4754 "HumbleGame.c"
}

static inline gpointer
game_hub_data_sources_humble_humble_game_installer_get_instance_private (GameHubDataSourcesHumbleHumbleGameInstaller* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataSourcesHumbleHumbleGameInstaller_private_offset);
}

GameHubDataSourcesHumbleHumbleGameInstaller*
game_hub_data_sources_humble_humble_game_installer_construct (GType object_type,
                                                              GameHubDataSourcesHumbleHumbleGame* game,
                                                              const gchar* machine_name,
                                                              const gchar* download_identifier,
                                                              GameHubDataPlatform platform,
                                                              JsonObject* download)
{
	GameHubDataSourcesHumbleHumbleGameInstaller* self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_;
	JsonObject* _tmp4_ = NULL;
	JsonObject* url_obj = NULL;
	JsonObject* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	JsonObject* _tmp9_;
	gchar* url = NULL;
	gchar* _tmp13_;
	gint64 _tmp14_ = 0LL;
	GFile* _tmp15_ = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GFile* _tmp20_;
	GFile* _tmp21_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFile* remote = NULL;
	const gchar* _tmp27_;
	GFile* _tmp28_;
	GFile* local = NULL;
	GFile* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GFile* _tmp40_;
	GFile* _tmp41_;
	gchar* hash = NULL;
	GChecksumType hash_type = 0;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gint64 _tmp51_;
	gint64 _tmp52_;
	GFile* _tmp53_;
	GFile* _tmp54_;
	const gchar* _tmp55_;
	GameHubDataRunnableDownloadableInstallerPart* _tmp56_;
	GeeArrayList* _tmp57_;
	GeeArrayList* _tmp58_;
	GameHubDataRunnableDownloadableInstallerPart* _tmp59_;
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (machine_name != NULL, NULL);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (download != NULL, NULL);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGameInstaller*) game_hub_data_runnable_downloadable_installer_construct (object_type);
#line 435 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_installer_set_id ((GameHubDataRunnableInstaller*) self, machine_name);
#line 436 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_installer_set_platform ((GameHubDataRunnableInstaller*) self, platform);
#line 437 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = g_strdup (download_identifier);
#line 437 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (self->dl_id);
#line 437 "../src/data/sources/humble/HumbleGame.vala"
	self->dl_id = _tmp0_;
#line 438 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (download, "name")) {
#line 4844 "HumbleGame.c"
		const gchar* _tmp2_;
#line 438 "../src/data/sources/humble/HumbleGame.vala"
		_tmp2_ = json_object_get_string_member (download, "name");
#line 438 "../src/data/sources/humble/HumbleGame.vala"
		_tmp1_ = _tmp2_;
#line 4850 "HumbleGame.c"
	} else {
#line 438 "../src/data/sources/humble/HumbleGame.vala"
		_tmp1_ = "";
#line 4854 "HumbleGame.c"
	}
#line 438 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = g_strdup (_tmp1_);
#line 438 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (self->dl_name);
#line 438 "../src/data/sources/humble/HumbleGame.vala"
	self->dl_name = _tmp3_;
#line 439 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (download, "url")) {
#line 4864 "HumbleGame.c"
		JsonObject* _tmp5_;
#line 439 "../src/data/sources/humble/HumbleGame.vala"
		_tmp5_ = json_object_get_object_member (download, "url");
#line 439 "../src/data/sources/humble/HumbleGame.vala"
		_tmp4_ = _tmp5_;
#line 4870 "HumbleGame.c"
	} else {
#line 439 "../src/data/sources/humble/HumbleGame.vala"
		_tmp4_ = NULL;
#line 4874 "HumbleGame.c"
	}
#line 439 "../src/data/sources/humble/HumbleGame.vala"
	_tmp6_ = _json_object_ref0 (_tmp4_);
#line 439 "../src/data/sources/humble/HumbleGame.vala"
	url_obj = _tmp6_;
#line 440 "../src/data/sources/humble/HumbleGame.vala"
	_tmp9_ = url_obj;
#line 440 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp9_ != NULL) {
#line 4884 "HumbleGame.c"
		JsonObject* _tmp10_;
#line 440 "../src/data/sources/humble/HumbleGame.vala"
		_tmp10_ = url_obj;
#line 440 "../src/data/sources/humble/HumbleGame.vala"
		_tmp8_ = json_object_has_member (_tmp10_, "web");
#line 4890 "HumbleGame.c"
	} else {
#line 440 "../src/data/sources/humble/HumbleGame.vala"
		_tmp8_ = FALSE;
#line 4894 "HumbleGame.c"
	}
#line 440 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp8_) {
#line 4898 "HumbleGame.c"
		JsonObject* _tmp11_;
		const gchar* _tmp12_;
#line 440 "../src/data/sources/humble/HumbleGame.vala"
		_tmp11_ = url_obj;
#line 440 "../src/data/sources/humble/HumbleGame.vala"
		_tmp12_ = json_object_get_string_member (_tmp11_, "web");
#line 440 "../src/data/sources/humble/HumbleGame.vala"
		_tmp7_ = _tmp12_;
#line 4907 "HumbleGame.c"
	} else {
#line 440 "../src/data/sources/humble/HumbleGame.vala"
		_tmp7_ = "";
#line 4911 "HumbleGame.c"
	}
#line 440 "../src/data/sources/humble/HumbleGame.vala"
	_tmp13_ = g_strdup (_tmp7_);
#line 440 "../src/data/sources/humble/HumbleGame.vala"
	url = _tmp13_;
#line 441 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (download, "file_size")) {
#line 441 "../src/data/sources/humble/HumbleGame.vala"
		_tmp14_ = json_object_get_int_member (download, "file_size");
#line 4921 "HumbleGame.c"
	} else {
#line 441 "../src/data/sources/humble/HumbleGame.vala"
		_tmp14_ = (gint64) 0;
#line 4925 "HumbleGame.c"
	}
#line 441 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_runnable_installer_set_full_size ((GameHubDataRunnableInstaller*) self, _tmp14_);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp16_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) game);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp17_ = _tmp16_;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp18_ = game_hub_utils_fs_utils_paths_collection_humble_expand_installers (_tmp17_, &platform);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp19_ = _tmp18_;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp20_ = game_hub_utils_fs_utils_file (_tmp19_, NULL, NULL);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp21_ = _tmp20_;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp19_);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp15_ = _tmp21_;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp15_ == NULL) {
#line 4947 "HumbleGame.c"
		GFile* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
		_tmp22_ = game_hub_data_game_get_installers_dir ((GameHubDataGame*) game);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
		_tmp23_ = _tmp22_;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (_tmp15_);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
		_tmp15_ = _tmp24_;
#line 4961 "HumbleGame.c"
	}
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp25_ = _tmp15_;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_tmp15_ = NULL;
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (self->priv->installers_dir);
#line 443 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->installers_dir = _tmp25_;
#line 445 "../src/data/sources/humble/HumbleGame.vala"
	_tmp26_ = self->priv->installers_dir;
#line 445 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp26_ == NULL) {
#line 445 "../src/data/sources/humble/HumbleGame.vala"
		_g_object_unref0 (_tmp15_);
#line 445 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (url);
#line 445 "../src/data/sources/humble/HumbleGame.vala"
		_json_object_unref0 (url_obj);
#line 445 "../src/data/sources/humble/HumbleGame.vala"
		return self;
#line 4983 "HumbleGame.c"
	}
#line 447 "../src/data/sources/humble/HumbleGame.vala"
	_tmp27_ = url;
#line 447 "../src/data/sources/humble/HumbleGame.vala"
	_tmp28_ = g_file_new_for_uri (_tmp27_);
#line 447 "../src/data/sources/humble/HumbleGame.vala"
	remote = _tmp28_;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp29_ = self->priv->installers_dir;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp30_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) game);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp31_ = _tmp30_;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp32_ = g_strconcat ("humble_", _tmp31_, NULL);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp33_ = _tmp32_;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp34_ = g_strconcat (_tmp33_, "_", NULL);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp35_ = _tmp34_;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp36_ = game_hub_data_runnable_installer_get_id ((GameHubDataRunnableInstaller*) self);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp37_ = _tmp36_;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp38_ = g_strconcat (_tmp35_, _tmp37_, NULL);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp39_ = _tmp38_;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp40_ = g_file_get_child (_tmp29_, _tmp39_);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_tmp41_ = _tmp40_;
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp39_);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp35_);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (_tmp33_);
#line 448 "../src/data/sources/humble/HumbleGame.vala"
	local = _tmp41_;
#line 450 "../src/data/sources/humble/HumbleGame.vala"
	hash = NULL;
#line 451 "../src/data/sources/humble/HumbleGame.vala"
	hash_type = G_CHECKSUM_MD5;
#line 453 "../src/data/sources/humble/HumbleGame.vala"
	if (json_object_has_member (download, "md5")) {
#line 5031 "HumbleGame.c"
		const gchar* _tmp42_;
		gchar* _tmp43_;
#line 455 "../src/data/sources/humble/HumbleGame.vala"
		_tmp42_ = json_object_get_string_member (download, "md5");
#line 455 "../src/data/sources/humble/HumbleGame.vala"
		_tmp43_ = g_strdup (_tmp42_);
#line 455 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (hash);
#line 455 "../src/data/sources/humble/HumbleGame.vala"
		hash = _tmp43_;
#line 456 "../src/data/sources/humble/HumbleGame.vala"
		hash_type = G_CHECKSUM_MD5;
#line 5044 "HumbleGame.c"
	} else {
#line 458 "../src/data/sources/humble/HumbleGame.vala"
		if (json_object_has_member (download, "sha1")) {
#line 5048 "HumbleGame.c"
			const gchar* _tmp44_;
			gchar* _tmp45_;
#line 460 "../src/data/sources/humble/HumbleGame.vala"
			_tmp44_ = json_object_get_string_member (download, "sha1");
#line 460 "../src/data/sources/humble/HumbleGame.vala"
			_tmp45_ = g_strdup (_tmp44_);
#line 460 "../src/data/sources/humble/HumbleGame.vala"
			_g_free0 (hash);
#line 460 "../src/data/sources/humble/HumbleGame.vala"
			hash = _tmp45_;
#line 461 "../src/data/sources/humble/HumbleGame.vala"
			hash_type = G_CHECKSUM_SHA1;
#line 5061 "HumbleGame.c"
		} else {
#line 463 "../src/data/sources/humble/HumbleGame.vala"
			if (json_object_has_member (download, "sha256")) {
#line 5065 "HumbleGame.c"
				const gchar* _tmp46_;
				gchar* _tmp47_;
#line 465 "../src/data/sources/humble/HumbleGame.vala"
				_tmp46_ = json_object_get_string_member (download, "sha256");
#line 465 "../src/data/sources/humble/HumbleGame.vala"
				_tmp47_ = g_strdup (_tmp46_);
#line 465 "../src/data/sources/humble/HumbleGame.vala"
				_g_free0 (hash);
#line 465 "../src/data/sources/humble/HumbleGame.vala"
				hash = _tmp47_;
#line 466 "../src/data/sources/humble/HumbleGame.vala"
				hash_type = G_CHECKSUM_SHA256;
#line 5078 "HumbleGame.c"
			}
		}
	}
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp48_ = game_hub_data_runnable_installer_get_id ((GameHubDataRunnableInstaller*) self);
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp49_ = _tmp48_;
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp50_ = url;
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp51_ = game_hub_data_runnable_installer_get_full_size ((GameHubDataRunnableInstaller*) self);
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp52_ = _tmp51_;
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp53_ = remote;
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp54_ = local;
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp55_ = hash;
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_tmp56_ = game_hub_data_runnable_downloadable_installer_part_new (_tmp49_, _tmp50_, _tmp52_, _tmp53_, _tmp54_, _tmp55_, hash_type);
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (self->part);
#line 469 "../src/data/sources/humble/HumbleGame.vala"
	self->part = _tmp56_;
#line 470 "../src/data/sources/humble/HumbleGame.vala"
	_tmp57_ = game_hub_data_runnable_downloadable_installer_get_parts ((GameHubDataRunnableDownloadableInstaller*) self);
#line 470 "../src/data/sources/humble/HumbleGame.vala"
	_tmp58_ = _tmp57_;
#line 470 "../src/data/sources/humble/HumbleGame.vala"
	_tmp59_ = self->part;
#line 470 "../src/data/sources/humble/HumbleGame.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, _tmp59_);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (hash);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (local);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (remote);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (_tmp15_);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (url);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	_json_object_unref0 (url_obj);
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	return self;
#line 5126 "HumbleGame.c"
}

GameHubDataSourcesHumbleHumbleGameInstaller*
game_hub_data_sources_humble_humble_game_installer_new (GameHubDataSourcesHumbleHumbleGame* game,
                                                        const gchar* machine_name,
                                                        const gchar* download_identifier,
                                                        GameHubDataPlatform platform,
                                                        JsonObject* download)
{
#line 433 "../src/data/sources/humble/HumbleGame.vala"
	return game_hub_data_sources_humble_humble_game_installer_construct (GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER, game, machine_name, download_identifier, platform, download);
#line 5138 "HumbleGame.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 5157 "HumbleGame.c"
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
#line 778 "glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0LL);
#line 779 "glib-2.0.vapi"
	result = g_ascii_strtoll (str, NULL, _base);
#line 779 "glib-2.0.vapi"
	return result;
#line 5171 "HumbleGame.c"
}

gboolean
game_hub_data_sources_humble_humble_game_installer_is_url_update_required (GameHubDataSourcesHumbleHumbleGameInstaller* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GameHubDataRunnableDownloadableInstallerPart* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GameHubDataRunnableDownloadableInstallerPart* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* ttl_string = NULL;
	GameHubDataRunnableDownloadableInstallerPart* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GDateTime* ttl = NULL;
	const gchar* _tmp29_;
	GDateTime* _tmp30_;
	GDateTime* now = NULL;
	GDateTime* _tmp31_;
	gint res = 0;
	GDateTime* _tmp32_;
	GDateTime* _tmp33_;
	gboolean result;
#line 473 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 475 "../src/data/sources/humble/HumbleGame.vala"
	_tmp2_ = self->part;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = game_hub_data_runnable_downloadable_installer_part_get_url (_tmp2_);
#line 475 "../src/data/sources/humble/HumbleGame.vala"
	_tmp4_ = _tmp3_;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp4_ == NULL) {
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp1_ = TRUE;
#line 5222 "HumbleGame.c"
	} else {
		GameHubDataRunnableDownloadableInstallerPart* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp5_ = self->part;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp6_ = game_hub_data_runnable_downloadable_installer_part_get_url (_tmp5_);
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp7_ = _tmp6_;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp8_ = strlen (_tmp7_);
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp9_ = _tmp8_;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp1_ = _tmp9_ == 0;
#line 5241 "HumbleGame.c"
	}
#line 475 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp1_) {
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = TRUE;
#line 5247 "HumbleGame.c"
	} else {
		GameHubDataRunnableDownloadableInstallerPart* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp10_ = self->part;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp11_ = game_hub_data_runnable_downloadable_installer_part_get_url (_tmp10_);
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp12_ = _tmp11_;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = g_str_has_prefix (_tmp12_, "humble-trove-unsigned://");
#line 5260 "HumbleGame.c"
	}
#line 475 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp0_) {
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		result = TRUE;
#line 475 "../src/data/sources/humble/HumbleGame.vala"
		return result;
#line 5268 "HumbleGame.c"
	}
#line 476 "../src/data/sources/humble/HumbleGame.vala"
	_tmp13_ = self->part;
#line 476 "../src/data/sources/humble/HumbleGame.vala"
	_tmp14_ = game_hub_data_runnable_downloadable_installer_part_get_url (_tmp13_);
#line 476 "../src/data/sources/humble/HumbleGame.vala"
	_tmp15_ = _tmp14_;
#line 476 "../src/data/sources/humble/HumbleGame.vala"
	if (!string_contains (_tmp15_, "&ttl=")) {
#line 476 "../src/data/sources/humble/HumbleGame.vala"
		result = FALSE;
#line 476 "../src/data/sources/humble/HumbleGame.vala"
		return result;
#line 5282 "HumbleGame.c"
	}
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp16_ = self->part;
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp17_ = game_hub_data_runnable_downloadable_installer_part_get_url (_tmp16_);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp18_ = _tmp17_;
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "&ttl=", 0);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp21_ = _tmp20_;
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp21__length1 = _vala_array_length (_tmp19_);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp22_ = _tmp21_[1];
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "&", 0);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp25_ = _tmp24_;
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp25__length1 = _vala_array_length (_tmp23_);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp26_ = _tmp25_[0];
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp27_ = g_strdup (_tmp26_);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp28_ = _tmp27_;
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
#line 477 "../src/data/sources/humble/HumbleGame.vala"
	ttl_string = _tmp28_;
#line 478 "../src/data/sources/humble/HumbleGame.vala"
	_tmp29_ = ttl_string;
#line 478 "../src/data/sources/humble/HumbleGame.vala"
	_tmp30_ = g_date_time_new_from_unix_utc (int64_parse (_tmp29_, (guint) 0));
#line 478 "../src/data/sources/humble/HumbleGame.vala"
	ttl = _tmp30_;
#line 479 "../src/data/sources/humble/HumbleGame.vala"
	_tmp31_ = g_date_time_new_now_utc ();
#line 479 "../src/data/sources/humble/HumbleGame.vala"
	now = _tmp31_;
#line 480 "../src/data/sources/humble/HumbleGame.vala"
	_tmp32_ = ttl;
#line 480 "../src/data/sources/humble/HumbleGame.vala"
	_tmp33_ = now;
#line 480 "../src/data/sources/humble/HumbleGame.vala"
	res = g_date_time_compare (_tmp32_, _tmp33_);
#line 481 "../src/data/sources/humble/HumbleGame.vala"
	result = res != 1;
#line 481 "../src/data/sources/humble/HumbleGame.vala"
	_g_date_time_unref0 (now);
#line 481 "../src/data/sources/humble/HumbleGame.vala"
	_g_date_time_unref0 (ttl);
#line 481 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (ttl_string);
#line 481 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 5342 "HumbleGame.c"
}

gchar*
game_hub_data_sources_humble_humble_game_installer_update_url (GameHubDataSourcesHumbleHumbleGameInstaller* self,
                                                               GameHubDataSourcesHumbleHumbleGame* game)
{
	gboolean _tmp0_ = FALSE;
	GameHubDataGameSource* _tmp1_;
	GameHubDataGameSource* _tmp2_;
	gchar* new_url = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GameHubDataGameSource* _tmp6_;
	GameHubDataGameSource* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp20_;
	gchar* result;
#line 484 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 484 "../src/data/sources/humble/HumbleGame.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 486 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = game_hub_data_game_get_source ((GameHubDataGame*) game);
#line 486 "../src/data/sources/humble/HumbleGame.vala"
	_tmp2_ = _tmp1_;
#line 486 "../src/data/sources/humble/HumbleGame.vala"
	if (!GAME_HUB_DATA_SOURCES_HUMBLE_IS_TROVE (_tmp2_)) {
#line 486 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = TRUE;
#line 5374 "HumbleGame.c"
	} else {
#line 486 "../src/data/sources/humble/HumbleGame.vala"
		_tmp0_ = !game_hub_data_sources_humble_humble_game_installer_is_url_update_required (self);
#line 5378 "HumbleGame.c"
	}
#line 486 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp0_) {
#line 486 "../src/data/sources/humble/HumbleGame.vala"
		result = NULL;
#line 486 "../src/data/sources/humble/HumbleGame.vala"
		return result;
#line 5386 "HumbleGame.c"
	}
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	_tmp3_ = game_hub_data_runnable_installer_get_id ((GameHubDataRunnableInstaller*) self);
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	_tmp4_ = _tmp3_;
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	_tmp5_ = self->dl_id;
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	_tmp6_ = game_hub_data_game_get_source ((GameHubDataGame*) game);
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	_tmp7_ = _tmp6_;
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE, GameHubDataSourcesHumbleHumble)->user_token;
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	_tmp9_ = game_hub_data_sources_humble_trove_sign_url (_tmp4_, _tmp5_, _tmp8_);
#line 488 "../src/data/sources/humble/HumbleGame.vala"
	new_url = _tmp9_;
#line 490 "../src/data/sources/humble/HumbleGame.vala"
	if (game_hub_application_log_verbose) {
#line 5406 "HumbleGame.c"
		GameHubDataRunnableDownloadableInstallerPart* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		_tmp10_ = self->part;
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		_tmp11_ = game_hub_data_runnable_downloadable_installer_part_get_url (_tmp10_);
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		_tmp12_ = _tmp11_;
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		_tmp13_ = game_hub_data_game_get_full_id ((GameHubDataGame*) game);
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		_tmp14_ = _tmp13_;
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		_tmp15_ = _tmp14_;
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		g_debug ("HumbleGame.vala:492: [HumbleGame.Installer.update_url] Old URL: '%s'; " \
"(%s)", _tmp12_, _tmp15_);
#line 492 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_tmp15_);
#line 493 "../src/data/sources/humble/HumbleGame.vala"
		_tmp16_ = new_url;
#line 493 "../src/data/sources/humble/HumbleGame.vala"
		_tmp17_ = game_hub_data_game_get_full_id ((GameHubDataGame*) game);
#line 493 "../src/data/sources/humble/HumbleGame.vala"
		_tmp18_ = _tmp17_;
#line 493 "../src/data/sources/humble/HumbleGame.vala"
		_tmp19_ = _tmp18_;
#line 493 "../src/data/sources/humble/HumbleGame.vala"
		g_debug ("HumbleGame.vala:493: [HumbleGame.Installer.update_url] New URL: '%s'; " \
"(%s)", _tmp16_, _tmp19_);
#line 493 "../src/data/sources/humble/HumbleGame.vala"
		_g_free0 (_tmp19_);
#line 5445 "HumbleGame.c"
	}
#line 496 "../src/data/sources/humble/HumbleGame.vala"
	_tmp20_ = new_url;
#line 496 "../src/data/sources/humble/HumbleGame.vala"
	if (_tmp20_ != NULL) {
#line 5451 "HumbleGame.c"
		GameHubDataRunnableDownloadableInstallerPart* _tmp21_;
		const gchar* _tmp22_;
#line 496 "../src/data/sources/humble/HumbleGame.vala"
		_tmp21_ = self->part;
#line 496 "../src/data/sources/humble/HumbleGame.vala"
		_tmp22_ = new_url;
#line 496 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_runnable_downloadable_installer_part_set_url (_tmp21_, _tmp22_);
#line 5460 "HumbleGame.c"
	}
#line 498 "../src/data/sources/humble/HumbleGame.vala"
	result = new_url;
#line 498 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 5466 "HumbleGame.c"
}

static gchar*
game_hub_data_sources_humble_humble_game_installer_real_get_name (GameHubDataRunnableInstaller* base)
{
	gchar* result;
	GameHubDataSourcesHumbleHumbleGameInstaller* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 431 "../src/data/sources/humble/HumbleGame.vala"
	self = (GameHubDataSourcesHumbleHumbleGameInstaller*) base;
#line 431 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = self->dl_name;
#line 431 "../src/data/sources/humble/HumbleGame.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 431 "../src/data/sources/humble/HumbleGame.vala"
	result = _tmp1_;
#line 431 "../src/data/sources/humble/HumbleGame.vala"
	return result;
#line 5486 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_installer_class_init (GameHubDataSourcesHumbleHumbleGameInstallerClass * klass,
                                                               gpointer klass_data)
{
#line 423 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_installer_parent_class = g_type_class_peek_parent (klass);
#line 423 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataRunnableInstallerClass *) klass)->finalize = game_hub_data_sources_humble_humble_game_installer_finalize;
#line 423 "../src/data/sources/humble/HumbleGame.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataSourcesHumbleHumbleGameInstaller_private_offset);
#line 423 "../src/data/sources/humble/HumbleGame.vala"
	GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS (klass)->get_name = (gchar* (*) (GameHubDataRunnableInstaller*)) game_hub_data_sources_humble_humble_game_installer_real_get_name;
#line 5501 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_installer_instance_init (GameHubDataSourcesHumbleHumbleGameInstaller * self,
                                                                  gpointer klass)
{
#line 423 "../src/data/sources/humble/HumbleGame.vala"
	self->priv = game_hub_data_sources_humble_humble_game_installer_get_instance_private (self);
#line 5510 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_installer_finalize (GameHubDataRunnableInstaller * obj)
{
	GameHubDataSourcesHumbleHumbleGameInstaller * self;
#line 423 "../src/data/sources/humble/HumbleGame.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TYPE_INSTALLER, GameHubDataSourcesHumbleHumbleGameInstaller);
#line 425 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (self->priv->installers_dir);
#line 427 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (self->dl_name);
#line 428 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (self->dl_id);
#line 429 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (self->part);
#line 423 "../src/data/sources/humble/HumbleGame.vala"
	GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS (game_hub_data_sources_humble_humble_game_installer_parent_class)->finalize (obj);
#line 5529 "HumbleGame.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_sources_humble_humble_game_installer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataSourcesHumbleHumbleGameInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_sources_humble_humble_game_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataSourcesHumbleHumbleGameInstaller), 0, (GInstanceInitFunc) game_hub_data_sources_humble_humble_game_installer_instance_init, NULL };
	GType game_hub_data_sources_humble_humble_game_installer_type_id;
	game_hub_data_sources_humble_humble_game_installer_type_id = g_type_register_static (GAME_HUB_DATA_RUNNABLE_TYPE_DOWNLOADABLE_INSTALLER, "GameHubDataSourcesHumbleHumbleGameInstaller", &g_define_type_info, 0);
	GameHubDataSourcesHumbleHumbleGameInstaller_private_offset = g_type_add_instance_private (game_hub_data_sources_humble_humble_game_installer_type_id, sizeof (GameHubDataSourcesHumbleHumbleGameInstallerPrivate));
	return game_hub_data_sources_humble_humble_game_installer_type_id;
}

GType
game_hub_data_sources_humble_humble_game_installer_get_type (void)
{
	static volatile gsize game_hub_data_sources_humble_humble_game_installer_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_sources_humble_humble_game_installer_type_id__once)) {
		GType game_hub_data_sources_humble_humble_game_installer_type_id;
		game_hub_data_sources_humble_humble_game_installer_type_id = game_hub_data_sources_humble_humble_game_installer_get_type_once ();
		g_once_init_leave (&game_hub_data_sources_humble_humble_game_installer_type_id__once, game_hub_data_sources_humble_humble_game_installer_type_id);
	}
	return game_hub_data_sources_humble_humble_game_installer_type_id__once;
}

static void
game_hub_data_sources_humble_humble_game_class_init (GameHubDataSourcesHumbleHumbleGameClass * klass,
                                                     gpointer klass_data)
{
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_parent_class = g_type_class_peek_parent (klass);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataSourcesHumbleHumbleGame_private_offset);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataRunnableClass *) klass)->update_status = (void (*) (GameHubDataRunnable*)) game_hub_data_sources_humble_humble_game_real_update_status;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGameClass *) klass)->update_game_info = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_humble_humble_game_real_update_game_info;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGameClass *) klass)->update_game_info_finish = (void (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_sources_humble_humble_game_update_game_info_finish;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataRunnableClass *) klass)->install = (void (*) (GameHubDataRunnable*, GameHubDataRunnableInstallerInstallMode, GAsyncReadyCallback, gpointer)) game_hub_data_sources_humble_humble_game_real_install;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataRunnableClass *) klass)->install_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_sources_humble_humble_game_install_finish;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGameClass *) klass)->uninstall = (void (*) (GameHubDataGame*, GAsyncReadyCallback, gpointer)) game_hub_data_sources_humble_humble_game_real_uninstall;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	((GameHubDataGameClass *) klass)->uninstall_finish = (void (*) (GameHubDataGame*, GAsyncResult*)) game_hub_data_sources_humble_humble_game_uninstall_finish;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->get_default_install_dir = (GFile* (*) (GameHubDataRunnable*)) game_hub_data_sources_humble_humble_game_real_get_default_install_dir;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_data_sources_humble_humble_game_get_property;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_data_sources_humble_humble_game_set_property;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_data_sources_humble_humble_game_finalize;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TWEAKS_PROPERTY, game_hub_data_sources_humble_humble_game_properties[GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TWEAKS_PROPERTY] = g_param_spec_boxed ("tweaks", "tweaks", "tweaks", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLERS_PROPERTY, game_hub_data_sources_humble_humble_game_properties[GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLERS_PROPERTY] = g_param_spec_object ("installers", "installers", "installers", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_DEFAULT_INSTALL_DIR_PROPERTY, game_hub_data_sources_humble_humble_game_properties[GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_DEFAULT_INSTALL_DIR_PROPERTY] = g_param_spec_object ("default-install-dir", "default-install-dir", "default-install-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 5590 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_game_hub_data_tweakable_game_interface_init (GameHubDataTweakableGameIface * iface,
                                                                                      gpointer iface_data)
{
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	game_hub_data_sources_humble_humble_game_game_hub_data_tweakable_game_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	iface->get_tweaks = game_hub_data_sources_humble_humble_game_real_get_tweaks;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	iface->set_tweaks = game_hub_data_sources_humble_humble_game_real_set_tweaks;
#line 5603 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_instance_init (GameHubDataSourcesHumbleHumbleGame * self,
                                                        gpointer klass)
{
	GeeArrayList* _tmp0_;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	self->priv = game_hub_data_sources_humble_humble_game_get_instance_private (self);
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->_tweaks = NULL;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->_tweaks_length1 = 0;
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->__tweaks_size_ = self->priv->_tweaks_length1;
#line 31 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->game_info_updating = FALSE;
#line 32 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->game_info_updated = FALSE;
#line 33 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->game_info_refreshed = FALSE;
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	_tmp0_ = gee_array_list_new (GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, (GBoxedCopyFunc) game_hub_data_runnable_installer_ref, (GDestroyNotify) game_hub_data_runnable_installer_unref, NULL, NULL, NULL);
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->_installers = _tmp0_;
#line 5629 "HumbleGame.c"
}

static void
game_hub_data_sources_humble_humble_game_finalize (GObject * obj)
{
	GameHubDataSourcesHumbleHumbleGame * self;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGame);
#line 27 "../src/data/sources/humble/HumbleGame.vala"
	self->priv->_tweaks = (_vala_array_free (self->priv->_tweaks, self->priv->_tweaks_length1, (GDestroyNotify) g_free), NULL);
#line 29 "../src/data/sources/humble/HumbleGame.vala"
	_g_free0 (self->order_id);
#line 35 "../src/data/sources/humble/HumbleGame.vala"
	_g_object_unref0 (self->priv->_installers);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	G_OBJECT_CLASS (game_hub_data_sources_humble_humble_game_parent_class)->finalize (obj);
#line 5646 "HumbleGame.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_sources_humble_humble_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataSourcesHumbleHumbleGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_sources_humble_humble_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataSourcesHumbleHumbleGame), 0, (GInstanceInitFunc) game_hub_data_sources_humble_humble_game_instance_init, NULL };
	static const GInterfaceInfo game_hub_data_tweakable_game_info = { (GInterfaceInitFunc) game_hub_data_sources_humble_humble_game_game_hub_data_tweakable_game_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType game_hub_data_sources_humble_humble_game_type_id;
	game_hub_data_sources_humble_humble_game_type_id = g_type_register_static (GAME_HUB_DATA_TYPE_GAME, "GameHubDataSourcesHumbleHumbleGame", &g_define_type_info, 0);
	g_type_add_interface_static (game_hub_data_sources_humble_humble_game_type_id, GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, &game_hub_data_tweakable_game_info);
	GameHubDataSourcesHumbleHumbleGame_private_offset = g_type_add_instance_private (game_hub_data_sources_humble_humble_game_type_id, sizeof (GameHubDataSourcesHumbleHumbleGamePrivate));
	return game_hub_data_sources_humble_humble_game_type_id;
}

GType
game_hub_data_sources_humble_humble_game_get_type (void)
{
	static volatile gsize game_hub_data_sources_humble_humble_game_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_sources_humble_humble_game_type_id__once)) {
		GType game_hub_data_sources_humble_humble_game_type_id;
		game_hub_data_sources_humble_humble_game_type_id = game_hub_data_sources_humble_humble_game_get_type_once ();
		g_once_init_leave (&game_hub_data_sources_humble_humble_game_type_id__once, game_hub_data_sources_humble_humble_game_type_id);
	}
	return game_hub_data_sources_humble_humble_game_type_id__once;
}

static void
_vala_game_hub_data_sources_humble_humble_game_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	GameHubDataSourcesHumbleHumbleGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGame);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	switch (property_id) {
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		case GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TWEAKS_PROPERTY:
#line 5685 "HumbleGame.c"
		{
			int length;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
			g_value_set_boxed (value, game_hub_data_tweakable_game_get_tweaks ((GameHubDataTweakableGame*) self, &length));
#line 5690 "HumbleGame.c"
		}
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		break;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		case GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLERS_PROPERTY:
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		g_value_set_object (value, game_hub_data_sources_humble_humble_game_get_installers (self));
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		break;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		case GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_DEFAULT_INSTALL_DIR_PROPERTY:
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		g_value_take_object (value, game_hub_data_runnable_get_default_install_dir ((GameHubDataRunnable*) self));
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		break;
#line 5706 "HumbleGame.c"
		default:
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		break;
#line 5712 "HumbleGame.c"
	}
}

static void
_vala_game_hub_data_sources_humble_humble_game_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	GameHubDataSourcesHumbleHumbleGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_SOURCES_HUMBLE_TYPE_HUMBLE_GAME, GameHubDataSourcesHumbleHumbleGame);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
	switch (property_id) {
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		case GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_TWEAKS_PROPERTY:
#line 5728 "HumbleGame.c"
		{
			gpointer boxed;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
			boxed = g_value_get_boxed (value);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
			game_hub_data_tweakable_game_set_tweaks ((GameHubDataTweakableGame*) self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 5735 "HumbleGame.c"
		}
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		break;
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		case GAME_HUB_DATA_SOURCES_HUMBLE_HUMBLE_GAME_INSTALLERS_PROPERTY:
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		game_hub_data_sources_humble_humble_game_set_installers (self, g_value_get_object (value));
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		break;
#line 5745 "HumbleGame.c"
		default:
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../src/data/sources/humble/HumbleGame.vala"
		break;
#line 5751 "HumbleGame.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

