/* Emulator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Emulator.vala, do not modify */

/*
This file is part of GameHub.
Copyright (C) 2018-2019 Anatoliy Kashkin

GameHub is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

GameHub is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GameHub.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <sqlite3.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAME_HUB_DATA_TYPE_RUNNABLE (game_hub_data_runnable_get_type ())
#define GAME_HUB_DATA_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnable))
#define GAME_HUB_DATA_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))
#define GAME_HUB_DATA_IS_RUNNABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_IS_RUNNABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_RUNNABLE))
#define GAME_HUB_DATA_RUNNABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_RUNNABLE, GameHubDataRunnableClass))

typedef struct _GameHubDataRunnable GameHubDataRunnable;
typedef struct _GameHubDataRunnableClass GameHubDataRunnableClass;
typedef struct _GameHubDataRunnablePrivate GameHubDataRunnablePrivate;
typedef enum  {
	GAME_HUB_DATA_PLATFORM_LINUX,
	GAME_HUB_DATA_PLATFORM_WINDOWS,
	GAME_HUB_DATA_PLATFORM_MACOS,
	GAME_HUB_DATA_PLATFORM_EMULATED
} GameHubDataPlatform;

#define GAME_HUB_DATA_TYPE_PLATFORM (game_hub_data_platform_get_type ())
typedef enum  {
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_INTERACTIVE,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC,
	GAME_HUB_DATA_RUNNABLE_INSTALLER_INSTALL_MODE_AUTOMATIC_DOWNLOAD
} GameHubDataRunnableInstallerInstallMode;

#define GAME_HUB_DATA_RUNNABLE_INSTALLER_TYPE_INSTALL_MODE (game_hub_data_runnable_installer_install_mode_get_type ())

#define GAME_HUB_DATA_TYPE_EMULATOR (game_hub_data_emulator_get_type ())
#define GAME_HUB_DATA_EMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_EMULATOR, GameHubDataEmulator))
#define GAME_HUB_DATA_EMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_EMULATOR, GameHubDataEmulatorClass))
#define GAME_HUB_DATA_IS_EMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_EMULATOR))
#define GAME_HUB_DATA_IS_EMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_EMULATOR))
#define GAME_HUB_DATA_EMULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_EMULATOR, GameHubDataEmulatorClass))

typedef struct _GameHubDataEmulator GameHubDataEmulator;
typedef struct _GameHubDataEmulatorClass GameHubDataEmulatorClass;
typedef struct _GameHubDataEmulatorPrivate GameHubDataEmulatorPrivate;

#define GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER (game_hub_data_runnable_installer_get_type ())
#define GAME_HUB_DATA_RUNNABLE_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstaller))
#define GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstallerClass))
#define GAME_HUB_DATA_RUNNABLE_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, GameHubDataRunnableInstallerClass))

typedef struct _GameHubDataRunnableInstaller GameHubDataRunnableInstaller;
typedef struct _GameHubDataRunnableInstallerClass GameHubDataRunnableInstallerClass;

#define GAME_HUB_DATA_RUNNABLE_TYPE_FILE_INSTALLER (game_hub_data_runnable_file_installer_get_type ())
#define GAME_HUB_DATA_RUNNABLE_FILE_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_FILE_INSTALLER, GameHubDataRunnableFileInstaller))
#define GAME_HUB_DATA_RUNNABLE_FILE_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_FILE_INSTALLER, GameHubDataRunnableFileInstallerClass))
#define GAME_HUB_DATA_RUNNABLE_IS_FILE_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_FILE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_IS_FILE_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_RUNNABLE_TYPE_FILE_INSTALLER))
#define GAME_HUB_DATA_RUNNABLE_FILE_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_RUNNABLE_TYPE_FILE_INSTALLER, GameHubDataRunnableFileInstallerClass))

typedef struct _GameHubDataRunnableFileInstaller GameHubDataRunnableFileInstaller;
typedef struct _GameHubDataRunnableFileInstallerClass GameHubDataRunnableFileInstallerClass;

#define GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER (game_hub_data_emulator_installer_get_type ())
#define GAME_HUB_DATA_EMULATOR_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER, GameHubDataEmulatorInstaller))
#define GAME_HUB_DATA_EMULATOR_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER, GameHubDataEmulatorInstallerClass))
#define GAME_HUB_DATA_EMULATOR_IS_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER))
#define GAME_HUB_DATA_EMULATOR_IS_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER))
#define GAME_HUB_DATA_EMULATOR_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER, GameHubDataEmulatorInstallerClass))

typedef struct _GameHubDataEmulatorInstaller GameHubDataEmulatorInstaller;
typedef struct _GameHubDataEmulatorInstallerClass GameHubDataEmulatorInstallerClass;
enum  {
	GAME_HUB_DATA_EMULATOR_0_PROPERTY,
	GAME_HUB_DATA_EMULATOR_EXECUTABLE_PROPERTY,
	GAME_HUB_DATA_EMULATOR_WORK_DIR_PROPERTY,
	GAME_HUB_DATA_EMULATOR_GAME_EXECUTABLE_PATTERN_PROPERTY,
	GAME_HUB_DATA_EMULATOR_GAME_IMAGE_PATTERN_PROPERTY,
	GAME_HUB_DATA_EMULATOR_GAME_ICON_PATTERN_PROPERTY,
	GAME_HUB_DATA_EMULATOR_NUM_PROPERTIES
};
static GParamSpec* game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _game_hub_data_runnable_installer_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_data_runnable_installer_unref (var), NULL)))

#define GAME_HUB_DATA_DB_TABLE_TYPE_FIELD (game_hub_data_db_table_field_get_type ())
#define GAME_HUB_DATA_DB_TABLE_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableField))
#define GAME_HUB_DATA_DB_TABLE_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD))
#define GAME_HUB_DATA_DB_TABLE_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_DB_TABLE_TYPE_FIELD, GameHubDataDBTableFieldClass))

typedef struct _GameHubDataDBTableField GameHubDataDBTableField;
typedef struct _GameHubDataDBTableFieldClass GameHubDataDBTableFieldClass;

#define GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG (game_hub_ui_dialogs_install_dialog_get_type ())
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialog))
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialogClass))
#define GAME_HUB_UI_DIALOGS_IS_INSTALL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG))
#define GAME_HUB_UI_DIALOGS_IS_INSTALL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG))
#define GAME_HUB_UI_DIALOGS_INSTALL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UI_DIALOGS_TYPE_INSTALL_DIALOG, GameHubUIDialogsInstallDialogClass))

typedef struct _GameHubUIDialogsInstallDialog GameHubUIDialogsInstallDialog;
typedef struct _GameHubUIDialogsInstallDialogClass GameHubUIDialogsInstallDialogClass;
typedef struct _GameHubDataEmulatorInstallData GameHubDataEmulatorInstallData;

#define GAME_HUB_DATA_TYPE_GAME (game_hub_data_game_get_type ())
#define GAME_HUB_DATA_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGame))
#define GAME_HUB_DATA_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))
#define GAME_HUB_DATA_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_GAME))
#define GAME_HUB_DATA_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_GAME, GameHubDataGameClass))

typedef struct _GameHubDataGame GameHubDataGame;
typedef struct _GameHubDataGameClass GameHubDataGameClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define GAME_HUB_UTILS_TYPE_RUN_TASK (game_hub_utils_run_task_get_type ())
#define GAME_HUB_UTILS_RUN_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTask))
#define GAME_HUB_UTILS_RUN_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTaskClass))
#define GAME_HUB_UTILS_IS_RUN_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK))
#define GAME_HUB_UTILS_IS_RUN_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_TYPE_RUN_TASK))
#define GAME_HUB_UTILS_RUN_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_TYPE_RUN_TASK, GameHubUtilsRunTaskClass))

typedef struct _GameHubUtilsRunTask GameHubUtilsRunTask;
typedef struct _GameHubUtilsRunTaskClass GameHubUtilsRunTaskClass;

#define GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT (game_hub_utils_run_task_result_get_type ())
#define GAME_HUB_UTILS_RUN_TASK_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResult))
#define GAME_HUB_UTILS_RUN_TASK_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResultClass))
#define GAME_HUB_UTILS_RUN_TASK_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT))
#define GAME_HUB_UTILS_RUN_TASK_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT))
#define GAME_HUB_UTILS_RUN_TASK_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UTILS_RUN_TASK_TYPE_RESULT, GameHubUtilsRunTaskResultClass))

typedef struct _GameHubUtilsRunTaskResult GameHubUtilsRunTaskResult;
typedef struct _GameHubUtilsRunTaskResultClass GameHubUtilsRunTaskResultClass;
#define _game_hub_utils_run_task_result_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_run_task_result_unref (var), NULL)))
#define _game_hub_utils_run_task_unref0(var) ((var == NULL) ? NULL : (var = (game_hub_utils_run_task_unref (var), NULL)))
typedef struct _GameHubDataEmulatorRunData GameHubDataEmulatorRunData;
typedef struct _Block10Data Block10Data;

#define GAME_HUB_DATA_TYPE_TWEAKABLE_GAME (game_hub_data_tweakable_game_get_type ())
#define GAME_HUB_DATA_TWEAKABLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGame))
#define GAME_HUB_DATA_IS_TWEAKABLE_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME))
#define GAME_HUB_DATA_TWEAKABLE_GAME_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGameIface))

typedef struct _GameHubDataTweakableGame GameHubDataTweakableGame;
typedef struct _GameHubDataTweakableGameIface GameHubDataTweakableGameIface;

#define GAME_HUB_DATA_TWEAKS_TYPE_TWEAK (game_hub_data_tweaks_tweak_get_type ())
#define GAME_HUB_DATA_TWEAKS_TWEAK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweak))
#define GAME_HUB_DATA_TWEAKS_TWEAK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweakClass))
#define GAME_HUB_DATA_TWEAKS_IS_TWEAK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK))
#define GAME_HUB_DATA_TWEAKS_IS_TWEAK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK))
#define GAME_HUB_DATA_TWEAKS_TWEAK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TWEAKS_TYPE_TWEAK, GameHubDataTweaksTweakClass))

typedef struct _GameHubDataTweaksTweak GameHubDataTweaksTweak;
typedef struct _GameHubDataTweaksTweakClass GameHubDataTweaksTweakClass;

#define GAME_HUB_DATA_TYPE_COMPAT_TOOL (game_hub_data_compat_tool_get_type ())
#define GAME_HUB_DATA_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatTool))
#define GAME_HUB_DATA_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))
#define GAME_HUB_DATA_IS_COMPAT_TOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_IS_COMPAT_TOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_DATA_TYPE_COMPAT_TOOL))
#define GAME_HUB_DATA_COMPAT_TOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_DATA_TYPE_COMPAT_TOOL, GameHubDataCompatToolClass))

typedef struct _GameHubDataCompatTool GameHubDataCompatTool;
typedef struct _GameHubDataCompatToolClass GameHubDataCompatToolClass;
typedef struct _GameHubDataEmulatorRunGameData GameHubDataEmulatorRunGameData;

#define GAME_HUB_UI_DIALOGS_TYPE_COMPAT_RUN_DIALOG (game_hub_ui_dialogs_compat_run_dialog_get_type ())
#define GAME_HUB_UI_DIALOGS_COMPAT_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAME_HUB_UI_DIALOGS_TYPE_COMPAT_RUN_DIALOG, GameHubUIDialogsCompatRunDialog))
#define GAME_HUB_UI_DIALOGS_COMPAT_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAME_HUB_UI_DIALOGS_TYPE_COMPAT_RUN_DIALOG, GameHubUIDialogsCompatRunDialogClass))
#define GAME_HUB_UI_DIALOGS_IS_COMPAT_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAME_HUB_UI_DIALOGS_TYPE_COMPAT_RUN_DIALOG))
#define GAME_HUB_UI_DIALOGS_IS_COMPAT_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAME_HUB_UI_DIALOGS_TYPE_COMPAT_RUN_DIALOG))
#define GAME_HUB_UI_DIALOGS_COMPAT_RUN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAME_HUB_UI_DIALOGS_TYPE_COMPAT_RUN_DIALOG, GameHubUIDialogsCompatRunDialogClass))

typedef struct _GameHubUIDialogsCompatRunDialog GameHubUIDialogsCompatRunDialog;
typedef struct _GameHubUIDialogsCompatRunDialogClass GameHubUIDialogsCompatRunDialogClass;
typedef struct _GameHubDataEmulatorRunGameCompatData GameHubDataEmulatorRunGameCompatData;
typedef struct _GameHubDataRunnableInstallerPrivate GameHubDataRunnableInstallerPrivate;
typedef struct _GameHubDataRunnableFileInstallerPrivate GameHubDataRunnableFileInstallerPrivate;
typedef struct _GameHubDataEmulatorInstallerPrivate GameHubDataEmulatorInstallerPrivate;
enum  {
	GAME_HUB_DATA_EMULATOR_REMOVED_SIGNAL,
	GAME_HUB_DATA_EMULATOR_NUM_SIGNALS
};
static guint game_hub_data_emulator_signals[GAME_HUB_DATA_EMULATOR_NUM_SIGNALS] = {0};

struct _GameHubDataRunnable {
	GObject parent_instance;
	GameHubDataRunnablePrivate * priv;
};

struct _GameHubDataRunnableClass {
	GObjectClass parent_class;
	gboolean (*is_supported) (GameHubDataRunnable* self, GameHubDataPlatform* platform, gboolean with_compat);
	void (*install) (GameHubDataRunnable* self, GameHubDataRunnableInstallerInstallMode install_mode, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	void (*run) (GameHubDataRunnable* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	gboolean (*can_be_launched) (GameHubDataRunnable* self, gboolean is_launch_attempt);
	void (*run_with_compat) (GameHubDataRunnable* self, gboolean is_opened_from_menu, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_with_compat_finish) (GameHubDataRunnable* self, GAsyncResult* _res_);
	GtkFileChooser* (*setup_executable_chooser) (GameHubDataRunnable* self);
	void (*choose_executable) (GameHubDataRunnable* self, gboolean update);
	void (*set_chosen_executable) (GameHubDataRunnable* self, GFile* file, gboolean update);
	void (*save) (GameHubDataRunnable* self);
	void (*update_status) (GameHubDataRunnable* self);
	void (*import) (GameHubDataRunnable* self, gboolean update);
	GFile* (*get_executable) (GameHubDataRunnable* self);
	void (*set_executable) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_work_dir) (GameHubDataRunnable* self);
	void (*set_work_dir) (GameHubDataRunnable* self, GFile* value);
	GFile* (*get_default_install_dir) (GameHubDataRunnable* self);
};

struct _GameHubDataEmulator {
	GameHubDataRunnable parent_instance;
	GameHubDataEmulatorPrivate * priv;
	gchar* work_dir_path;
	GameHubDataEmulatorInstaller* installer;
};

struct _GameHubDataEmulatorClass {
	GameHubDataRunnableClass parent_class;
};

struct _GameHubDataEmulatorPrivate {
	gboolean is_removed;
	GFile* _executable;
	gchar* _game_executable_pattern;
	gchar* _game_image_pattern;
	gchar* _game_icon_pattern;
};

struct _GameHubDataEmulatorInstallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataEmulator* self;
	GameHubDataRunnableInstallerInstallMode install_mode;
	gboolean _tmp0_;
	GameHubDataEmulatorInstaller* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GeeArrayList* installers;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GameHubDataEmulatorInstaller* _tmp6_;
	GeeArrayList* _tmp7_;
	GameHubUIDialogsInstallDialog* _tmp8_;
	GameHubUIDialogsInstallDialog* _tmp9_;
};

struct _GameHubDataEmulatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataEmulator* self;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gint _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GameHubUtilsRunTask* _tmp10_;
	GameHubUtilsRunTask* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GameHubUtilsRunTask* _tmp17_;
	GameHubUtilsRunTask* _tmp18_;
	GameHubUtilsRunTask* _tmp19_;
	GameHubUtilsRunTask* _tmp20_;
	GameHubUtilsRunTaskResult* _tmp21_;
	GameHubUtilsRunTaskResult* _tmp22_;
};

struct _Block10Data {
	int _ref_count_;
	GameHubDataEmulator* self;
	GameHubDataGame* game;
	gpointer _async_data_;
};

struct _GameHubDataTweakableGameIface {
	GTypeInterface parent_iface;
	gchar** (*get_tweaks) (GameHubDataTweakableGame* self, gint* result_length1);
	void (*set_tweaks) (GameHubDataTweakableGame* self, gchar** value, gint value_length1);
};

struct _GameHubDataEmulatorRunGameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataEmulator* self;
	GameHubDataGame* game;
	gboolean launch_in_game_dir;
	Block10Data* _data10_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* dir;
	GFile* _tmp12_;
	GameHubUtilsRunTask* task;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gint _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GameHubUtilsRunTask* _tmp19_;
	GameHubUtilsRunTask* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GameHubUtilsRunTask* _tmp24_;
	GameHubUtilsRunTask* _tmp25_;
	GameHubUtilsRunTask* _tmp26_;
	GameHubUtilsRunTask* _tmp27_;
	gboolean _tmp28_;
	GameHubUtilsRunTask* _tmp29_;
	gint _tmp30_;
	GameHubDataTweaksTweak** _tmp31_;
	GameHubDataTweaksTweak** _tmp32_;
	gint _tmp32__length1;
	GameHubUtilsRunTask* _tmp33_;
	GameHubUtilsRunTask* _tmp34_;
	GameHubUtilsRunTask* _tmp35_;
	GameHubUtilsRunTaskResult* _tmp36_;
	GameHubUtilsRunTaskResult* _tmp37_;
};

struct _GameHubDataEmulatorRunGameCompatData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameHubDataEmulator* self;
	GameHubDataGame* game;
	gboolean launch_in_game_dir;
	GameHubUIDialogsCompatRunDialog* _tmp0_;
	GameHubUIDialogsCompatRunDialog* _tmp1_;
};

struct _GameHubDataRunnableInstaller {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GameHubDataRunnableInstallerPrivate * priv;
};

struct _GameHubDataRunnableInstallerClass {
	GTypeClass parent_class;
	void (*finalize) (GameHubDataRunnableInstaller *self);
	void (*install) (GameHubDataRunnableInstaller* self, GameHubDataRunnable* runnable, GameHubDataCompatTool* tool, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*install_finish) (GameHubDataRunnableInstaller* self, GAsyncResult* _res_);
	gchar* (*get_name) (GameHubDataRunnableInstaller* self);
};

struct _GameHubDataRunnableFileInstaller {
	GameHubDataRunnableInstaller parent_instance;
	GameHubDataRunnableFileInstallerPrivate * priv;
};

struct _GameHubDataRunnableFileInstallerClass {
	GameHubDataRunnableInstallerClass parent_class;
};

struct _GameHubDataEmulatorInstaller {
	GameHubDataRunnableFileInstaller parent_instance;
	GameHubDataEmulatorInstallerPrivate * priv;
};

struct _GameHubDataEmulatorInstallerClass {
	GameHubDataRunnableFileInstallerClass parent_class;
};

struct _GameHubDataEmulatorInstallerPrivate {
	gchar* emu_name;
};

static gint GameHubDataEmulator_private_offset;
static gpointer game_hub_data_emulator_parent_class = NULL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_ID;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_NAME;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_INSTALL_PATH;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_WORK_DIR;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_EXECUTABLE;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_COMPAT_TOOL;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_COMPAT_TOOL_SETTINGS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_ARGUMENTS;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_GAME_EXECUTABLE_PATTERN;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_GAME_IMAGE_PATTERN;
VALA_EXTERN GameHubDataDBTableField* game_hub_data_db_tables_emulators_GAME_ICON_PATTERN;
VALA_EXTERN gboolean game_hub_data_runnable_IsLaunched;
static gint GameHubDataEmulatorInstaller_private_offset;
static gpointer game_hub_data_emulator_installer_parent_class = NULL;

VALA_EXTERN GType game_hub_data_runnable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnable, g_object_unref)
VALA_EXTERN GType game_hub_data_platform_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_runnable_installer_install_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_hub_data_emulator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataEmulator, g_object_unref)
VALA_EXTERN gpointer game_hub_data_runnable_installer_ref (gpointer instance);
VALA_EXTERN void game_hub_data_runnable_installer_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_runnable_param_spec_installer (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags);
VALA_EXTERN void game_hub_data_runnable_value_set_installer (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN void game_hub_data_runnable_value_take_installer (GValue* value,
                                                  gpointer v_object);
VALA_EXTERN gpointer game_hub_data_runnable_value_get_installer (const GValue* value);
VALA_EXTERN GType game_hub_data_runnable_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnableInstaller, game_hub_data_runnable_installer_unref)
VALA_EXTERN GType game_hub_data_runnable_file_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataRunnableFileInstaller, game_hub_data_runnable_installer_unref)
VALA_EXTERN GType game_hub_data_emulator_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataEmulatorInstaller, game_hub_data_runnable_installer_unref)
VALA_EXTERN void game_hub_data_runnable_save (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_update_status (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_install (GameHubDataRunnable* self,
                                     GameHubDataRunnableInstallerInstallMode install_mode,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_install_finish (GameHubDataRunnable* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void game_hub_data_runnable_run (GameHubDataRunnable* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void game_hub_data_runnable_run_finish (GameHubDataRunnable* self,
                                        GAsyncResult* _res_);
VALA_EXTERN GFile* game_hub_data_runnable_get_executable (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_set_executable (GameHubDataRunnable* self,
                                            GFile* value);
VALA_EXTERN GFile* game_hub_data_runnable_get_work_dir (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_runnable_set_work_dir (GameHubDataRunnable* self,
                                          GFile* value);
VALA_EXTERN GFile* game_hub_data_emulator_get_file (GameHubDataEmulator* self,
                                        const gchar* p);
VALA_EXTERN GFile* game_hub_data_runnable_get_install_dir (GameHubDataRunnable* self);
VALA_EXTERN GFile* game_hub_utils_fs_utils_file (const gchar* path,
                                     const gchar* file,
                                     GeeHashMap* variables);
VALA_EXTERN GameHubDataEmulator* game_hub_data_emulator_new_empty (void);
VALA_EXTERN GameHubDataEmulator* game_hub_data_emulator_construct_empty (GType object_type);
VALA_EXTERN GameHubDataRunnable* game_hub_data_runnable_construct (GType object_type);
VALA_EXTERN GameHubDataEmulator* game_hub_data_emulator_new (const gchar* name,
                                                 GFile* dir,
                                                 GFile* exec,
                                                 const gchar* args,
                                                 const gchar* compat);
VALA_EXTERN GameHubDataEmulator* game_hub_data_emulator_construct (GType object_type,
                                                       const gchar* name,
                                                       GFile* dir,
                                                       GFile* exec,
                                                       const gchar* args,
                                                       const gchar* compat);
VALA_EXTERN void game_hub_data_runnable_set_name (GameHubDataRunnable* self,
                                      const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_install_dir (GameHubDataRunnable* self,
                                             GFile* value);
VALA_EXTERN void game_hub_data_runnable_set_arguments (GameHubDataRunnable* self,
                                           const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool (GameHubDataRunnable* self,
                                             const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_force_compat (GameHubDataRunnable* self,
                                              gboolean value);
VALA_EXTERN GameHubDataEmulator* game_hub_data_emulator_new_from_db (sqlite3_stmt* s);
VALA_EXTERN GameHubDataEmulator* game_hub_data_emulator_construct_from_db (GType object_type,
                                                               sqlite3_stmt* s);
VALA_EXTERN gpointer game_hub_data_db_table_field_ref (gpointer instance);
VALA_EXTERN void game_hub_data_db_table_field_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_data_db_table_param_spec_field (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void game_hub_data_db_table_value_set_field (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void game_hub_data_db_table_value_take_field (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer game_hub_data_db_table_value_get_field (const GValue* value);
VALA_EXTERN GType game_hub_data_db_table_field_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataDBTableField, game_hub_data_db_table_field_unref)
VALA_EXTERN gchar* game_hub_data_db_table_field_get (GameHubDataDBTableField* self,
                                         sqlite3_stmt* s);
VALA_EXTERN void game_hub_data_runnable_set_id (GameHubDataRunnable* self,
                                    const gchar* value);
VALA_EXTERN void game_hub_data_runnable_set_compat_tool_settings (GameHubDataRunnable* self,
                                                      const gchar* value);
VALA_EXTERN void game_hub_data_emulator_set_game_executable_pattern (GameHubDataEmulator* self,
                                                         const gchar* value);
VALA_EXTERN void game_hub_data_emulator_set_game_image_pattern (GameHubDataEmulator* self,
                                                    const gchar* value);
VALA_EXTERN void game_hub_data_emulator_set_game_icon_pattern (GameHubDataEmulator* self,
                                                   const gchar* value);
VALA_EXTERN void game_hub_data_emulator_remove (GameHubDataEmulator* self);
VALA_EXTERN gboolean game_hub_data_db_tables_emulators_remove (GameHubDataEmulator* emu);
static void game_hub_data_emulator_real_save (GameHubDataRunnable* base);
VALA_EXTERN const gchar* game_hub_data_runnable_get_name (GameHubDataRunnable* self);
VALA_EXTERN gboolean game_hub_data_db_tables_emulators_add (GameHubDataEmulator* emu);
static void game_hub_data_emulator_real_update_status (GameHubDataRunnable* base);
VALA_EXTERN gchar* game_hub_utils_md5 (const gchar* s);
VALA_EXTERN GeeArrayList* game_hub_data_runnable_get_platforms (GameHubDataRunnable* self);
static void game_hub_data_emulator_real_install_data_free (gpointer _data);
static void game_hub_data_emulator_real_install (GameHubDataRunnable* base,
                                          GameHubDataRunnableInstallerInstallMode install_mode,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean game_hub_data_emulator_real_install_co (GameHubDataEmulatorInstallData* _data_);
static gboolean _game_hub_data_emulator_real_install_co_gsource_func (gpointer self);
VALA_EXTERN GameHubUIDialogsInstallDialog* game_hub_ui_dialogs_install_dialog_new (GameHubDataRunnable* runnable,
                                                                       GeeArrayList* installers,
                                                                       GameHubDataRunnableInstallerInstallMode install_mode,
                                                                       GSourceFunc callback,
                                                                       gpointer callback_target,
                                                                       GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN GameHubUIDialogsInstallDialog* game_hub_ui_dialogs_install_dialog_construct (GType object_type,
                                                                             GameHubDataRunnable* runnable,
                                                                             GeeArrayList* installers,
                                                                             GameHubDataRunnableInstallerInstallMode install_mode,
                                                                             GSourceFunc callback,
                                                                             gpointer callback_target,
                                                                             GDestroyNotify callback_target_destroy_notify);
VALA_EXTERN GType game_hub_ui_dialogs_install_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUIDialogsInstallDialog, g_object_unref)
VALA_EXTERN GType game_hub_data_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataGame, g_object_unref)
VALA_EXTERN gchar** game_hub_data_emulator_get_args (GameHubDataEmulator* self,
                                         GameHubDataGame* game,
                                         GFile* exec,
                                         gint* result_length1);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN const gchar* game_hub_data_runnable_get_arguments (GameHubDataRunnable* self);
VALA_EXTERN gchar** game_hub_utils_parse_args (const gchar* args,
                                   gint* result_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN gchar* game_hub_utils_fs_utils_expand (const gchar* path,
                                       const gchar* file,
                                       GeeHashMap* variables);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void game_hub_data_emulator_real_run_data_free (gpointer _data);
static void game_hub_data_emulator_real_run (GameHubDataRunnable* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean game_hub_data_emulator_real_run_co (GameHubDataEmulatorRunData* _data_);
VALA_EXTERN gboolean game_hub_data_runnable_can_be_launched (GameHubDataRunnable* self,
                                                 gboolean is_launch_attempt);
VALA_EXTERN void game_hub_data_runnable_set_is_running (GameHubDataRunnable* self,
                                            gboolean value);
VALA_EXTERN gpointer game_hub_utils_run_task_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_run_task_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_param_spec_run_task (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void game_hub_utils_value_set_run_task (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void game_hub_utils_value_take_run_task (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_value_get_run_task (const GValue* value);
VALA_EXTERN GType game_hub_utils_run_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsRunTask, game_hub_utils_run_task_unref)
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run (gchar** cmd,
                                         gint cmd_length1);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_dir (GameHubUtilsRunTask* self,
                                                  const gchar* dir);
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_override_runtime (GameHubUtilsRunTask* self,
                                                               gboolean override_runtime);
VALA_EXTERN void game_hub_utils_run_task_run_sync_thread (GameHubUtilsRunTask* self,
                                              gboolean capture_output,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN gpointer game_hub_utils_run_task_result_ref (gpointer instance);
VALA_EXTERN void game_hub_utils_run_task_result_unref (gpointer instance);
VALA_EXTERN GParamSpec* game_hub_utils_run_task_param_spec_result (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void game_hub_utils_run_task_value_set_result (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void game_hub_utils_run_task_value_take_result (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer game_hub_utils_run_task_value_get_result (const GValue* value);
VALA_EXTERN GType game_hub_utils_run_task_result_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUtilsRunTaskResult, game_hub_utils_run_task_result_unref)
VALA_EXTERN GameHubUtilsRunTaskResult* game_hub_utils_run_task_run_sync_thread_finish (GameHubUtilsRunTask* self,
                                                                           GAsyncResult* _res_);
static void game_hub_data_emulator_run_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static gboolean ___lambda130_ (GameHubDataEmulator* self);
static gboolean ____lambda130__gsource_func (gpointer self);
static void game_hub_data_emulator_run_game_data_free (gpointer _data);
VALA_EXTERN void game_hub_data_emulator_run_game (GameHubDataEmulator* self,
                                      GameHubDataGame* game,
                                      gboolean launch_in_game_dir,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void game_hub_data_emulator_run_game_finish (GameHubDataEmulator* self,
                                             GAsyncResult* _res_);
static gboolean game_hub_data_emulator_run_game_co (GameHubDataEmulatorRunGameData* _data_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
VALA_EXTERN gboolean game_hub_data_runnable_get_use_compat (GameHubDataRunnable* self);
VALA_EXTERN void game_hub_data_emulator_run_game_compat (GameHubDataEmulator* self,
                                             GameHubDataGame* game,
                                             gboolean launch_in_game_dir,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void game_hub_data_emulator_run_game_compat_finish (GameHubDataEmulator* self,
                                                    GAsyncResult* _res_);
static void game_hub_data_emulator_run_game_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN GType game_hub_data_tweakable_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataTweakableGame, g_object_unref)
VALA_EXTERN GType game_hub_data_tweaks_tweak_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataTweaksTweak, g_object_unref)
VALA_EXTERN GameHubUtilsRunTask* game_hub_utils_run_task_tweaks (GameHubUtilsRunTask* self,
                                                     GameHubDataTweaksTweak** tweaks,
                                                     gint tweaks_length1);
VALA_EXTERN GType game_hub_data_compat_tool_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubDataCompatTool, g_object_unref)
VALA_EXTERN GameHubDataTweaksTweak** game_hub_data_tweakable_game_get_enabled_tweaks (GameHubDataTweakableGame* self,
                                                                          GameHubDataCompatTool* tool,
                                                                          gint* result_length1);
static gboolean ___lambda131_ (Block10Data* _data10_);
static gboolean ____lambda131__gsource_func (gpointer self);
static void game_hub_data_emulator_run_game_compat_data_free (gpointer _data);
static gboolean game_hub_data_emulator_run_game_compat_co (GameHubDataEmulatorRunGameCompatData* _data_);
VALA_EXTERN GameHubUIDialogsCompatRunDialog* game_hub_ui_dialogs_compat_run_dialog_new (GameHubDataRunnable* game,
                                                                            gboolean is_opened_from_menu,
                                                                            GameHubDataGame* emulated_game,
                                                                            gboolean launch_in_game_dir);
VALA_EXTERN GameHubUIDialogsCompatRunDialog* game_hub_ui_dialogs_compat_run_dialog_construct (GType object_type,
                                                                                  GameHubDataRunnable* game,
                                                                                  gboolean is_opened_from_menu,
                                                                                  GameHubDataGame* emulated_game,
                                                                                  gboolean launch_in_game_dir);
VALA_EXTERN GType game_hub_ui_dialogs_compat_run_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHubUIDialogsCompatRunDialog, g_object_unref)
VALA_EXTERN gboolean game_hub_data_emulator_is_equal (GameHubDataEmulator* first,
                                          GameHubDataEmulator* second);
VALA_EXTERN const gchar* game_hub_data_runnable_get_id (GameHubDataRunnable* self);
VALA_EXTERN guint game_hub_data_emulator_hash (GameHubDataEmulator* emu);
VALA_EXTERN const gchar* game_hub_data_emulator_get_game_executable_pattern (GameHubDataEmulator* self);
VALA_EXTERN const gchar* game_hub_data_emulator_get_game_image_pattern (GameHubDataEmulator* self);
VALA_EXTERN const gchar* game_hub_data_emulator_get_game_icon_pattern (GameHubDataEmulator* self);
VALA_EXTERN gchar* game_hub_data_runnable_installer_get_name (GameHubDataRunnableInstaller* self);
VALA_EXTERN GameHubDataEmulatorInstaller* game_hub_data_emulator_installer_new (GameHubDataEmulator* emu,
                                                                    GFile* installer);
VALA_EXTERN GameHubDataEmulatorInstaller* game_hub_data_emulator_installer_construct (GType object_type,
                                                                          GameHubDataEmulator* emu,
                                                                          GFile* installer);
VALA_EXTERN GameHubDataRunnableFileInstaller* game_hub_data_runnable_file_installer_construct (GType object_type);
VALA_EXTERN void game_hub_data_runnable_installer_set_id (GameHubDataRunnableInstaller* self,
                                              const gchar* value);
VALA_EXTERN void game_hub_data_runnable_installer_set_platform (GameHubDataRunnableInstaller* self,
                                                    GameHubDataPlatform value);
VALA_EXTERN void game_hub_data_runnable_file_installer_set_file (GameHubDataRunnableFileInstaller* self,
                                                     GFile* value);
static void game_hub_data_emulator_installer_finalize (GameHubDataRunnableInstaller * obj);
static GType game_hub_data_emulator_installer_get_type_once (void);
static void game_hub_data_emulator_finalize (GObject * obj);
static GType game_hub_data_emulator_get_type_once (void);
static void _vala_game_hub_data_emulator_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_game_hub_data_emulator_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
game_hub_data_emulator_get_instance_private (GameHubDataEmulator* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataEmulator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 70 "../src/data/Emulator.vala"
	return self ? g_object_ref (self) : NULL;
#line 776 "Emulator.c"
}

GFile*
game_hub_data_emulator_get_file (GameHubDataEmulator* self,
                                 const gchar* p)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* path = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GFile** dirs = NULL;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile** _tmp15_;
	gint dirs_length1;
	gint _dirs_size_;
	GeeHashMap* variables = NULL;
	GeeHashMap* _tmp16_;
	GFile** _tmp17_;
	gint _tmp17__length1;
	GFile* result;
#line 62 "../src/data/Emulator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "../src/data/Emulator.vala"
	if (p == NULL) {
#line 64 "../src/data/Emulator.vala"
		_tmp1_ = TRUE;
#line 807 "Emulator.c"
	} else {
		gint _tmp2_;
		gint _tmp3_;
#line 64 "../src/data/Emulator.vala"
		_tmp2_ = strlen (p);
#line 64 "../src/data/Emulator.vala"
		_tmp3_ = _tmp2_;
#line 64 "../src/data/Emulator.vala"
		_tmp1_ = _tmp3_ == 0;
#line 817 "Emulator.c"
	}
#line 64 "../src/data/Emulator.vala"
	if (_tmp1_) {
#line 64 "../src/data/Emulator.vala"
		_tmp0_ = TRUE;
#line 823 "Emulator.c"
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
#line 64 "../src/data/Emulator.vala"
		_tmp4_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 64 "../src/data/Emulator.vala"
		_tmp5_ = _tmp4_;
#line 64 "../src/data/Emulator.vala"
		_tmp0_ = _tmp5_ == NULL;
#line 833 "Emulator.c"
	}
#line 64 "../src/data/Emulator.vala"
	if (_tmp0_) {
#line 64 "../src/data/Emulator.vala"
		result = NULL;
#line 64 "../src/data/Emulator.vala"
		return result;
#line 841 "Emulator.c"
	}
#line 65 "../src/data/Emulator.vala"
	_tmp6_ = g_strdup (p);
#line 65 "../src/data/Emulator.vala"
	path = _tmp6_;
#line 66 "../src/data/Emulator.vala"
	_tmp8_ = path;
#line 66 "../src/data/Emulator.vala"
	if (!g_str_has_prefix (_tmp8_, "$game_dir/")) {
#line 851 "Emulator.c"
		const gchar* _tmp9_;
#line 66 "../src/data/Emulator.vala"
		_tmp9_ = path;
#line 66 "../src/data/Emulator.vala"
		_tmp7_ = !g_str_has_prefix (_tmp9_, "/");
#line 857 "Emulator.c"
	} else {
#line 66 "../src/data/Emulator.vala"
		_tmp7_ = FALSE;
#line 861 "Emulator.c"
	}
#line 66 "../src/data/Emulator.vala"
	if (_tmp7_) {
#line 865 "Emulator.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 68 "../src/data/Emulator.vala"
		_tmp10_ = path;
#line 68 "../src/data/Emulator.vala"
		_tmp11_ = g_strconcat ("$game_dir/", _tmp10_, NULL);
#line 68 "../src/data/Emulator.vala"
		_g_free0 (path);
#line 68 "../src/data/Emulator.vala"
		path = _tmp11_;
#line 876 "Emulator.c"
	}
#line 70 "../src/data/Emulator.vala"
	_tmp12_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 70 "../src/data/Emulator.vala"
	_tmp13_ = _tmp12_;
#line 70 "../src/data/Emulator.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 70 "../src/data/Emulator.vala"
	_tmp15_ = g_new0 (GFile*, 1 + 1);
#line 70 "../src/data/Emulator.vala"
	_tmp15_[0] = _tmp14_;
#line 70 "../src/data/Emulator.vala"
	dirs = _tmp15_;
#line 70 "../src/data/Emulator.vala"
	dirs_length1 = 1;
#line 70 "../src/data/Emulator.vala"
	_dirs_size_ = dirs_length1;
#line 71 "../src/data/Emulator.vala"
	_tmp16_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 71 "../src/data/Emulator.vala"
	variables = _tmp16_;
#line 72 "../src/data/Emulator.vala"
	_tmp17_ = dirs;
#line 72 "../src/data/Emulator.vala"
	_tmp17__length1 = dirs_length1;
#line 902 "Emulator.c"
	{
		GFile** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
#line 72 "../src/data/Emulator.vala"
		dir_collection = _tmp17_;
#line 72 "../src/data/Emulator.vala"
		dir_collection_length1 = _tmp17__length1;
#line 72 "../src/data/Emulator.vala"
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 914 "Emulator.c"
			GFile* _tmp18_;
			GFile* dir = NULL;
#line 72 "../src/data/Emulator.vala"
			_tmp18_ = _g_object_ref0 (dir_collection[dir_it]);
#line 72 "../src/data/Emulator.vala"
			dir = _tmp18_;
#line 921 "Emulator.c"
			{
				GeeHashMap* _tmp19_;
				GFile* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GFile* file = NULL;
				const gchar* _tmp23_;
				GeeHashMap* _tmp24_;
				GFile* _tmp25_;
				gboolean _tmp26_ = FALSE;
				GFile* _tmp27_;
#line 74 "../src/data/Emulator.vala"
				_tmp19_ = variables;
#line 74 "../src/data/Emulator.vala"
				_tmp20_ = dir;
#line 74 "../src/data/Emulator.vala"
				_tmp21_ = g_file_get_path (_tmp20_);
#line 74 "../src/data/Emulator.vala"
				_tmp22_ = _tmp21_;
#line 74 "../src/data/Emulator.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, "game_dir", _tmp22_);
#line 74 "../src/data/Emulator.vala"
				_g_free0 (_tmp22_);
#line 75 "../src/data/Emulator.vala"
				_tmp23_ = path;
#line 75 "../src/data/Emulator.vala"
				_tmp24_ = variables;
#line 75 "../src/data/Emulator.vala"
				_tmp25_ = game_hub_utils_fs_utils_file (_tmp23_, NULL, _tmp24_);
#line 75 "../src/data/Emulator.vala"
				file = _tmp25_;
#line 76 "../src/data/Emulator.vala"
				_tmp27_ = file;
#line 76 "../src/data/Emulator.vala"
				if (_tmp27_ != NULL) {
#line 957 "Emulator.c"
					GFile* _tmp28_;
#line 76 "../src/data/Emulator.vala"
					_tmp28_ = file;
#line 76 "../src/data/Emulator.vala"
					_tmp26_ = g_file_query_exists (_tmp28_, NULL);
#line 963 "Emulator.c"
				} else {
#line 76 "../src/data/Emulator.vala"
					_tmp26_ = FALSE;
#line 967 "Emulator.c"
				}
#line 76 "../src/data/Emulator.vala"
				if (_tmp26_) {
#line 78 "../src/data/Emulator.vala"
					result = file;
#line 78 "../src/data/Emulator.vala"
					_g_object_unref0 (dir);
#line 78 "../src/data/Emulator.vala"
					_g_object_unref0 (variables);
#line 78 "../src/data/Emulator.vala"
					dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 78 "../src/data/Emulator.vala"
					_g_free0 (path);
#line 78 "../src/data/Emulator.vala"
					return result;
#line 983 "Emulator.c"
				}
#line 72 "../src/data/Emulator.vala"
				_g_object_unref0 (file);
#line 72 "../src/data/Emulator.vala"
				_g_object_unref0 (dir);
#line 989 "Emulator.c"
			}
		}
	}
#line 81 "../src/data/Emulator.vala"
	result = NULL;
#line 81 "../src/data/Emulator.vala"
	_g_object_unref0 (variables);
#line 81 "../src/data/Emulator.vala"
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 81 "../src/data/Emulator.vala"
	_g_free0 (path);
#line 81 "../src/data/Emulator.vala"
	return result;
#line 1003 "Emulator.c"
}

GameHubDataEmulator*
game_hub_data_emulator_construct_empty (GType object_type)
{
	GameHubDataEmulator * self = NULL;
#line 89 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) game_hub_data_runnable_construct (object_type);
#line 89 "../src/data/Emulator.vala"
	return self;
#line 1014 "Emulator.c"
}

GameHubDataEmulator*
game_hub_data_emulator_new_empty (void)
{
#line 89 "../src/data/Emulator.vala"
	return game_hub_data_emulator_construct_empty (GAME_HUB_DATA_TYPE_EMULATOR);
#line 1022 "Emulator.c"
}

GameHubDataEmulator*
game_hub_data_emulator_construct (GType object_type,
                                  const gchar* name,
                                  GFile* dir,
                                  GFile* exec,
                                  const gchar* args,
                                  const gchar* compat)
{
	GameHubDataEmulator * self = NULL;
#line 91 "../src/data/Emulator.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 91 "../src/data/Emulator.vala"
	g_return_val_if_fail (dir != NULL, NULL);
#line 91 "../src/data/Emulator.vala"
	g_return_val_if_fail (exec != NULL, NULL);
#line 91 "../src/data/Emulator.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 91 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) game_hub_data_runnable_construct (object_type);
#line 93 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, name);
#line 95 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) self, dir);
#line 96 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_work_dir ((GameHubDataRunnable*) self, dir);
#line 98 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_executable ((GameHubDataRunnable*) self, exec);
#line 99 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_arguments ((GameHubDataRunnable*) self, args);
#line 101 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_compat_tool ((GameHubDataRunnable*) self, compat);
#line 102 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_force_compat ((GameHubDataRunnable*) self, compat != NULL);
#line 104 "../src/data/Emulator.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 91 "../src/data/Emulator.vala"
	return self;
#line 1062 "Emulator.c"
}

GameHubDataEmulator*
game_hub_data_emulator_new (const gchar* name,
                            GFile* dir,
                            GFile* exec,
                            const gchar* args,
                            const gchar* compat)
{
#line 91 "../src/data/Emulator.vala"
	return game_hub_data_emulator_construct (GAME_HUB_DATA_TYPE_EMULATOR, name, dir, exec, args, compat);
#line 1074 "Emulator.c"
}

GameHubDataEmulator*
game_hub_data_emulator_construct_from_db (GType object_type,
                                          sqlite3_stmt* s)
{
	GameHubDataEmulator * self = NULL;
	GameHubDataDBTableField* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GameHubDataDBTableField* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GameHubDataDBTableField* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GameHubDataDBTableField* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GameHubDataDBTableField* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GameHubDataDBTableField* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GameHubDataDBTableField* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GameHubDataDBTableField* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GameHubDataDBTableField* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GameHubDataDBTableField* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GameHubDataDBTableField* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
#line 107 "../src/data/Emulator.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 107 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) game_hub_data_runnable_construct (object_type);
#line 109 "../src/data/Emulator.vala"
	_tmp0_ = game_hub_data_db_tables_emulators_ID;
#line 109 "../src/data/Emulator.vala"
	_tmp1_ = game_hub_data_db_table_field_get (_tmp0_, s);
#line 109 "../src/data/Emulator.vala"
	_tmp2_ = _tmp1_;
#line 109 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp2_);
#line 109 "../src/data/Emulator.vala"
	_g_free0 (_tmp2_);
#line 110 "../src/data/Emulator.vala"
	_tmp3_ = game_hub_data_db_tables_emulators_NAME;
#line 110 "../src/data/Emulator.vala"
	_tmp4_ = game_hub_data_db_table_field_get (_tmp3_, s);
#line 110 "../src/data/Emulator.vala"
	_tmp5_ = _tmp4_;
#line 110 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_name ((GameHubDataRunnable*) self, _tmp5_);
#line 110 "../src/data/Emulator.vala"
	_g_free0 (_tmp5_);
#line 111 "../src/data/Emulator.vala"
	_tmp6_ = game_hub_data_db_tables_emulators_INSTALL_PATH;
#line 111 "../src/data/Emulator.vala"
	_tmp7_ = game_hub_data_db_table_field_get (_tmp6_, s);
#line 111 "../src/data/Emulator.vala"
	_tmp8_ = _tmp7_;
#line 111 "../src/data/Emulator.vala"
	_tmp9_ = game_hub_utils_fs_utils_file (_tmp8_, NULL, NULL);
#line 111 "../src/data/Emulator.vala"
	_tmp10_ = _tmp9_;
#line 111 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_install_dir ((GameHubDataRunnable*) self, _tmp10_);
#line 111 "../src/data/Emulator.vala"
	_g_object_unref0 (_tmp10_);
#line 111 "../src/data/Emulator.vala"
	_g_free0 (_tmp8_);
#line 112 "../src/data/Emulator.vala"
	_tmp11_ = game_hub_data_db_tables_emulators_WORK_DIR;
#line 112 "../src/data/Emulator.vala"
	_tmp12_ = game_hub_data_db_table_field_get (_tmp11_, s);
#line 112 "../src/data/Emulator.vala"
	_tmp13_ = _tmp12_;
#line 112 "../src/data/Emulator.vala"
	_tmp14_ = game_hub_utils_fs_utils_file (_tmp13_, NULL, NULL);
#line 112 "../src/data/Emulator.vala"
	_tmp15_ = _tmp14_;
#line 112 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_work_dir ((GameHubDataRunnable*) self, _tmp15_);
#line 112 "../src/data/Emulator.vala"
	_g_object_unref0 (_tmp15_);
#line 112 "../src/data/Emulator.vala"
	_g_free0 (_tmp13_);
#line 113 "../src/data/Emulator.vala"
	_tmp16_ = game_hub_data_db_tables_emulators_EXECUTABLE;
#line 113 "../src/data/Emulator.vala"
	_tmp17_ = game_hub_data_db_table_field_get (_tmp16_, s);
#line 113 "../src/data/Emulator.vala"
	_tmp18_ = _tmp17_;
#line 113 "../src/data/Emulator.vala"
	_tmp19_ = game_hub_utils_fs_utils_file (_tmp18_, NULL, NULL);
#line 113 "../src/data/Emulator.vala"
	_tmp20_ = _tmp19_;
#line 113 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_executable ((GameHubDataRunnable*) self, _tmp20_);
#line 113 "../src/data/Emulator.vala"
	_g_object_unref0 (_tmp20_);
#line 113 "../src/data/Emulator.vala"
	_g_free0 (_tmp18_);
#line 114 "../src/data/Emulator.vala"
	_tmp21_ = game_hub_data_db_tables_emulators_COMPAT_TOOL;
#line 114 "../src/data/Emulator.vala"
	_tmp22_ = game_hub_data_db_table_field_get (_tmp21_, s);
#line 114 "../src/data/Emulator.vala"
	_tmp23_ = _tmp22_;
#line 114 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_compat_tool ((GameHubDataRunnable*) self, _tmp23_);
#line 114 "../src/data/Emulator.vala"
	_g_free0 (_tmp23_);
#line 115 "../src/data/Emulator.vala"
	_tmp24_ = game_hub_data_db_tables_emulators_COMPAT_TOOL_SETTINGS;
#line 115 "../src/data/Emulator.vala"
	_tmp25_ = game_hub_data_db_table_field_get (_tmp24_, s);
#line 115 "../src/data/Emulator.vala"
	_tmp26_ = _tmp25_;
#line 115 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_compat_tool_settings ((GameHubDataRunnable*) self, _tmp26_);
#line 115 "../src/data/Emulator.vala"
	_g_free0 (_tmp26_);
#line 116 "../src/data/Emulator.vala"
	_tmp27_ = game_hub_data_db_tables_emulators_ARGUMENTS;
#line 116 "../src/data/Emulator.vala"
	_tmp28_ = game_hub_data_db_table_field_get (_tmp27_, s);
#line 116 "../src/data/Emulator.vala"
	_tmp29_ = _tmp28_;
#line 116 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_arguments ((GameHubDataRunnable*) self, _tmp29_);
#line 116 "../src/data/Emulator.vala"
	_g_free0 (_tmp29_);
#line 117 "../src/data/Emulator.vala"
	_tmp30_ = game_hub_data_db_tables_emulators_GAME_EXECUTABLE_PATTERN;
#line 117 "../src/data/Emulator.vala"
	_tmp31_ = game_hub_data_db_table_field_get (_tmp30_, s);
#line 117 "../src/data/Emulator.vala"
	_tmp32_ = _tmp31_;
#line 117 "../src/data/Emulator.vala"
	game_hub_data_emulator_set_game_executable_pattern (self, _tmp32_);
#line 117 "../src/data/Emulator.vala"
	_g_free0 (_tmp32_);
#line 118 "../src/data/Emulator.vala"
	_tmp33_ = game_hub_data_db_tables_emulators_GAME_IMAGE_PATTERN;
#line 118 "../src/data/Emulator.vala"
	_tmp34_ = game_hub_data_db_table_field_get (_tmp33_, s);
#line 118 "../src/data/Emulator.vala"
	_tmp35_ = _tmp34_;
#line 118 "../src/data/Emulator.vala"
	game_hub_data_emulator_set_game_image_pattern (self, _tmp35_);
#line 118 "../src/data/Emulator.vala"
	_g_free0 (_tmp35_);
#line 119 "../src/data/Emulator.vala"
	_tmp36_ = game_hub_data_db_tables_emulators_GAME_ICON_PATTERN;
#line 119 "../src/data/Emulator.vala"
	_tmp37_ = game_hub_data_db_table_field_get (_tmp36_, s);
#line 119 "../src/data/Emulator.vala"
	_tmp38_ = _tmp37_;
#line 119 "../src/data/Emulator.vala"
	game_hub_data_emulator_set_game_icon_pattern (self, _tmp38_);
#line 119 "../src/data/Emulator.vala"
	_g_free0 (_tmp38_);
#line 121 "../src/data/Emulator.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 107 "../src/data/Emulator.vala"
	return self;
#line 1257 "Emulator.c"
}

GameHubDataEmulator*
game_hub_data_emulator_new_from_db (sqlite3_stmt* s)
{
#line 107 "../src/data/Emulator.vala"
	return game_hub_data_emulator_construct_from_db (GAME_HUB_DATA_TYPE_EMULATOR, s);
#line 1265 "Emulator.c"
}

void
game_hub_data_emulator_remove (GameHubDataEmulator* self)
{
#line 124 "../src/data/Emulator.vala"
	g_return_if_fail (self != NULL);
#line 126 "../src/data/Emulator.vala"
	self->priv->is_removed = TRUE;
#line 127 "../src/data/Emulator.vala"
	game_hub_data_db_tables_emulators_remove (self);
#line 128 "../src/data/Emulator.vala"
	g_signal_emit (self, game_hub_data_emulator_signals[GAME_HUB_DATA_EMULATOR_REMOVED_SIGNAL], 0);
#line 1279 "Emulator.c"
}

static void
game_hub_data_emulator_real_save (GameHubDataRunnable* base)
{
	GameHubDataEmulator * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 131 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 133 "../src/data/Emulator.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) self);
#line 135 "../src/data/Emulator.vala"
	if (self->priv->is_removed) {
#line 135 "../src/data/Emulator.vala"
		_tmp1_ = TRUE;
#line 1296 "Emulator.c"
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 135 "../src/data/Emulator.vala"
		_tmp2_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) self);
#line 135 "../src/data/Emulator.vala"
		_tmp3_ = _tmp2_;
#line 135 "../src/data/Emulator.vala"
		_tmp1_ = _tmp3_ == NULL;
#line 1306 "Emulator.c"
	}
#line 135 "../src/data/Emulator.vala"
	if (_tmp1_) {
#line 135 "../src/data/Emulator.vala"
		_tmp0_ = TRUE;
#line 1312 "Emulator.c"
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 135 "../src/data/Emulator.vala"
		_tmp4_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) self);
#line 135 "../src/data/Emulator.vala"
		_tmp5_ = _tmp4_;
#line 135 "../src/data/Emulator.vala"
		_tmp6_ = _tmp5_;
#line 135 "../src/data/Emulator.vala"
		_tmp0_ = _tmp6_ == NULL;
#line 135 "../src/data/Emulator.vala"
		_g_object_unref0 (_tmp6_);
#line 1327 "Emulator.c"
	}
#line 135 "../src/data/Emulator.vala"
	if (_tmp0_) {
#line 135 "../src/data/Emulator.vala"
		return;
#line 1333 "Emulator.c"
	}
#line 137 "../src/data/Emulator.vala"
	game_hub_data_db_tables_emulators_add (self);
#line 1337 "Emulator.c"
}

static void
game_hub_data_emulator_real_update_status (GameHubDataRunnable* base)
{
	GameHubDataEmulator * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
#line 140 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 142 "../src/data/Emulator.vala"
	if (self->priv->is_removed) {
#line 142 "../src/data/Emulator.vala"
		_tmp1_ = TRUE;
#line 1360 "Emulator.c"
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 142 "../src/data/Emulator.vala"
		_tmp2_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) self);
#line 142 "../src/data/Emulator.vala"
		_tmp3_ = _tmp2_;
#line 142 "../src/data/Emulator.vala"
		_tmp1_ = _tmp3_ == NULL;
#line 1370 "Emulator.c"
	}
#line 142 "../src/data/Emulator.vala"
	if (_tmp1_) {
#line 142 "../src/data/Emulator.vala"
		_tmp0_ = TRUE;
#line 1376 "Emulator.c"
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 142 "../src/data/Emulator.vala"
		_tmp4_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) self);
#line 142 "../src/data/Emulator.vala"
		_tmp5_ = _tmp4_;
#line 142 "../src/data/Emulator.vala"
		_tmp6_ = _tmp5_;
#line 142 "../src/data/Emulator.vala"
		_tmp0_ = _tmp6_ == NULL;
#line 142 "../src/data/Emulator.vala"
		_g_object_unref0 (_tmp6_);
#line 1391 "Emulator.c"
	}
#line 142 "../src/data/Emulator.vala"
	if (_tmp0_) {
#line 142 "../src/data/Emulator.vala"
		return;
#line 1397 "Emulator.c"
	}
#line 144 "../src/data/Emulator.vala"
	_tmp7_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) self);
#line 144 "../src/data/Emulator.vala"
	_tmp8_ = _tmp7_;
#line 144 "../src/data/Emulator.vala"
	_tmp9_ = game_hub_utils_md5 (_tmp8_);
#line 144 "../src/data/Emulator.vala"
	_tmp10_ = _tmp9_;
#line 144 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_id ((GameHubDataRunnable*) self, _tmp10_);
#line 144 "../src/data/Emulator.vala"
	_g_free0 (_tmp10_);
#line 146 "../src/data/Emulator.vala"
	_tmp11_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 146 "../src/data/Emulator.vala"
	_tmp12_ = _tmp11_;
#line 146 "../src/data/Emulator.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
#line 147 "../src/data/Emulator.vala"
	_tmp13_ = game_hub_data_runnable_get_platforms ((GameHubDataRunnable*) self);
#line 147 "../src/data/Emulator.vala"
	_tmp14_ = _tmp13_;
#line 147 "../src/data/Emulator.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (gpointer) ((gintptr) GAME_HUB_DATA_PLATFORM_LINUX));
#line 1423 "Emulator.c"
}

static void
game_hub_data_emulator_real_install_data_free (gpointer _data)
{
	GameHubDataEmulatorInstallData* _data_;
	_data_ = _data;
#line 25 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/Emulator.vala"
	g_slice_free (GameHubDataEmulatorInstallData, _data_);
#line 1435 "Emulator.c"
}

static void
game_hub_data_emulator_real_install (GameHubDataRunnable* base,
                                     GameHubDataRunnableInstallerInstallMode install_mode,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GameHubDataEmulator * self;
	GameHubDataEmulatorInstallData* _data_;
	GameHubDataEmulator* _tmp0_;
#line 25 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 25 "../src/data/Emulator.vala"
	_data_ = g_slice_new0 (GameHubDataEmulatorInstallData);
#line 25 "../src/data/Emulator.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/Emulator.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_emulator_real_install_data_free);
#line 25 "../src/data/Emulator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/Emulator.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/Emulator.vala"
	_data_->install_mode = install_mode;
#line 25 "../src/data/Emulator.vala"
	game_hub_data_emulator_real_install_co (_data_);
#line 1463 "Emulator.c"
}

static void
game_hub_data_emulator_install_finish (GameHubDataRunnable* base,
                                       GAsyncResult* _res_)
{
	GameHubDataEmulatorInstallData* _data_;
#line 25 "../src/data/Emulator.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1473 "Emulator.c"
}

static gboolean
_game_hub_data_emulator_real_install_co_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hub_data_emulator_real_install_co (self);
#line 156 "../src/data/Emulator.vala"
	return result;
#line 1483 "Emulator.c"
}

static gboolean
game_hub_data_emulator_real_install_co (GameHubDataEmulatorInstallData* _data_)
{
#line 150 "../src/data/Emulator.vala"
	switch (_data_->_state_) {
#line 150 "../src/data/Emulator.vala"
		case 0:
#line 1493 "Emulator.c"
		goto _state_0;
#line 150 "../src/data/Emulator.vala"
		case 1:
#line 1497 "Emulator.c"
		goto _state_1;
		default:
#line 150 "../src/data/Emulator.vala"
		g_assert_not_reached ();
#line 1502 "Emulator.c"
	}
	_state_0:
#line 152 "../src/data/Emulator.vala"
	game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->self);
#line 153 "../src/data/Emulator.vala"
	_data_->_tmp1_ = _data_->self->installer;
#line 153 "../src/data/Emulator.vala"
	if (_data_->_tmp1_ == NULL) {
#line 153 "../src/data/Emulator.vala"
		_data_->_tmp0_ = TRUE;
#line 1513 "Emulator.c"
	} else {
#line 153 "../src/data/Emulator.vala"
		_data_->_tmp2_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) _data_->self);
#line 153 "../src/data/Emulator.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 153 "../src/data/Emulator.vala"
		_data_->_tmp0_ = _data_->_tmp3_ == NULL;
#line 1521 "Emulator.c"
	}
#line 153 "../src/data/Emulator.vala"
	if (_data_->_tmp0_) {
#line 153 "../src/data/Emulator.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 153 "../src/data/Emulator.vala"
		if (_data_->_state_ != 0) {
#line 153 "../src/data/Emulator.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 153 "../src/data/Emulator.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1533 "Emulator.c"
			}
		}
#line 153 "../src/data/Emulator.vala"
		g_object_unref (_data_->_async_result);
#line 153 "../src/data/Emulator.vala"
		return FALSE;
#line 1540 "Emulator.c"
	}
#line 154 "../src/data/Emulator.vala"
	_data_->_tmp4_ = gee_array_list_new (GAME_HUB_DATA_RUNNABLE_TYPE_INSTALLER, (GBoxedCopyFunc) game_hub_data_runnable_installer_ref, (GDestroyNotify) game_hub_data_runnable_installer_unref, NULL, NULL, NULL);
#line 154 "../src/data/Emulator.vala"
	_data_->installers = _data_->_tmp4_;
#line 155 "../src/data/Emulator.vala"
	_data_->_tmp5_ = _data_->installers;
#line 155 "../src/data/Emulator.vala"
	_data_->_tmp6_ = _data_->self->installer;
#line 155 "../src/data/Emulator.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp5_, (GameHubDataRunnableInstaller*) _data_->_tmp6_);
#line 156 "../src/data/Emulator.vala"
	_data_->_tmp7_ = _data_->installers;
#line 156 "../src/data/Emulator.vala"
	_data_->_tmp8_ = game_hub_ui_dialogs_install_dialog_new ((GameHubDataRunnable*) _data_->self, _data_->_tmp7_, _data_->install_mode, _game_hub_data_emulator_real_install_co_gsource_func, _data_, NULL);
#line 156 "../src/data/Emulator.vala"
	g_object_ref_sink (_data_->_tmp8_);
#line 156 "../src/data/Emulator.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 156 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->_tmp9_);
#line 157 "../src/data/Emulator.vala"
	_data_->_state_ = 1;
#line 157 "../src/data/Emulator.vala"
	return FALSE;
#line 1566 "Emulator.c"
	_state_1:
	;
#line 150 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->installers);
#line 150 "../src/data/Emulator.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 150 "../src/data/Emulator.vala"
	if (_data_->_state_ != 0) {
#line 150 "../src/data/Emulator.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 150 "../src/data/Emulator.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1579 "Emulator.c"
		}
	}
#line 150 "../src/data/Emulator.vala"
	g_object_unref (_data_->_async_result);
#line 150 "../src/data/Emulator.vala"
	return FALSE;
#line 1586 "Emulator.c"
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 166 "../src/data/Emulator.vala"
	if ((*length) == (*size)) {
#line 166 "../src/data/Emulator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 166 "../src/data/Emulator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1601 "Emulator.c"
	}
#line 166 "../src/data/Emulator.vala"
	(*array)[(*length)++] = value;
#line 166 "../src/data/Emulator.vala"
	(*array)[*length] = NULL;
#line 1607 "Emulator.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1629 "Emulator.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1633 "Emulator.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1639 "Emulator.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1643 "Emulator.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1647 "Emulator.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1655 "Emulator.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1683 "Emulator.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1692 "Emulator.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1706 "Emulator.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1715 "Emulator.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1729 "Emulator.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1738 "Emulator.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1747 "Emulator.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 189 "../src/data/Emulator.vala"
	for (i = 0; i < stack_length; i++) {
#line 189 "../src/data/Emulator.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 189 "../src/data/Emulator.vala"
			return TRUE;
#line 1762 "Emulator.c"
		}
	}
#line 189 "../src/data/Emulator.vala"
	return FALSE;
#line 1767 "Emulator.c"
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 205 "../src/data/Emulator.vala"
	if ((*length) == (*size)) {
#line 205 "../src/data/Emulator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 205 "../src/data/Emulator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1782 "Emulator.c"
	}
#line 205 "../src/data/Emulator.vala"
	(*array)[(*length)++] = value;
#line 205 "../src/data/Emulator.vala"
	(*array)[*length] = NULL;
#line 1788 "Emulator.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 1807 "Emulator.c"
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
#line 215 "../src/data/Emulator.vala"
	if ((*length) == (*size)) {
#line 215 "../src/data/Emulator.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 215 "../src/data/Emulator.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1822 "Emulator.c"
	}
#line 215 "../src/data/Emulator.vala"
	(*array)[(*length)++] = value;
#line 215 "../src/data/Emulator.vala"
	(*array)[*length] = NULL;
#line 1828 "Emulator.c"
}

gchar**
game_hub_data_emulator_get_args (GameHubDataEmulator* self,
                                 GameHubDataGame* game,
                                 GFile* exec,
                                 gint* result_length1)
{
	gchar** result_args = NULL;
	gchar** _tmp0_;
	gint result_args_length1;
	gint _result_args_size_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp76_;
	gint _tmp76__length1;
	gchar** result;
#line 160 "../src/data/Emulator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "../src/data/Emulator.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 162 "../src/data/Emulator.vala"
	result_args = _tmp0_;
#line 162 "../src/data/Emulator.vala"
	result_args_length1 = 0;
#line 162 "../src/data/Emulator.vala"
	_result_args_size_ = result_args_length1;
#line 164 "../src/data/Emulator.vala"
	if (exec != NULL) {
#line 1859 "Emulator.c"
		gchar* _tmp1_;
#line 166 "../src/data/Emulator.vala"
		_tmp1_ = g_file_get_path (exec);
#line 166 "../src/data/Emulator.vala"
		_vala_array_add10 (&result_args, &result_args_length1, &_result_args_size_, _tmp1_);
#line 1865 "Emulator.c"
	}
#line 169 "../src/data/Emulator.vala"
	_tmp3_ = game_hub_data_runnable_get_arguments ((GameHubDataRunnable*) self);
#line 169 "../src/data/Emulator.vala"
	_tmp4_ = _tmp3_;
#line 169 "../src/data/Emulator.vala"
	if (_tmp4_ != NULL) {
#line 1873 "Emulator.c"
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 169 "../src/data/Emulator.vala"
		_tmp5_ = game_hub_data_runnable_get_arguments ((GameHubDataRunnable*) self);
#line 169 "../src/data/Emulator.vala"
		_tmp6_ = _tmp5_;
#line 169 "../src/data/Emulator.vala"
		_tmp7_ = strlen (_tmp6_);
#line 169 "../src/data/Emulator.vala"
		_tmp8_ = _tmp7_;
#line 169 "../src/data/Emulator.vala"
		_tmp2_ = _tmp8_ > 0;
#line 1888 "Emulator.c"
	} else {
#line 169 "../src/data/Emulator.vala"
		_tmp2_ = FALSE;
#line 1892 "Emulator.c"
	}
#line 169 "../src/data/Emulator.vala"
	if (_tmp2_) {
#line 1896 "Emulator.c"
		GeeHashMap* variables = NULL;
		GeeHashMap* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GeeHashMap* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar** args = NULL;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gint _tmp45_ = 0;
		gchar** _tmp46_;
		gint args_length1;
		gint _args_size_;
		gchar** _tmp47_;
		gint _tmp47__length1;
#line 171 "../src/data/Emulator.vala"
		_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 171 "../src/data/Emulator.vala"
		variables = _tmp9_;
#line 172 "../src/data/Emulator.vala"
		_tmp10_ = variables;
#line 172 "../src/data/Emulator.vala"
		_tmp11_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) self);
#line 172 "../src/data/Emulator.vala"
		_tmp12_ = _tmp11_;
#line 172 "../src/data/Emulator.vala"
		_tmp13_ = string_replace (_tmp12_, ": ", " - ");
#line 172 "../src/data/Emulator.vala"
		_tmp14_ = _tmp13_;
#line 172 "../src/data/Emulator.vala"
		_tmp15_ = string_replace (_tmp14_, ":", "");
#line 172 "../src/data/Emulator.vala"
		_tmp16_ = _tmp15_;
#line 172 "../src/data/Emulator.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, "emu", _tmp16_);
#line 172 "../src/data/Emulator.vala"
		_g_free0 (_tmp16_);
#line 172 "../src/data/Emulator.vala"
		_g_free0 (_tmp14_);
#line 173 "../src/data/Emulator.vala"
		_tmp17_ = variables;
#line 173 "../src/data/Emulator.vala"
		_tmp18_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 173 "../src/data/Emulator.vala"
		_tmp19_ = _tmp18_;
#line 173 "../src/data/Emulator.vala"
		_tmp20_ = g_file_get_path (_tmp19_);
#line 173 "../src/data/Emulator.vala"
		_tmp21_ = _tmp20_;
#line 173 "../src/data/Emulator.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, "emu_dir", _tmp21_);
#line 173 "../src/data/Emulator.vala"
		_g_free0 (_tmp21_);
#line 174 "../src/data/Emulator.vala"
		if (game != NULL) {
#line 1960 "Emulator.c"
			GeeHashMap* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GeeHashMap* _tmp29_;
			GFile* _tmp30_;
			GFile* _tmp31_;
			GFile* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GeeHashMap* _tmp35_;
			GFile* _tmp36_;
			GFile* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
#line 176 "../src/data/Emulator.vala"
			_tmp22_ = variables;
#line 176 "../src/data/Emulator.vala"
			_tmp23_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) game);
#line 176 "../src/data/Emulator.vala"
			_tmp24_ = _tmp23_;
#line 176 "../src/data/Emulator.vala"
			_tmp25_ = string_replace (_tmp24_, ": ", " - ");
#line 176 "../src/data/Emulator.vala"
			_tmp26_ = _tmp25_;
#line 176 "../src/data/Emulator.vala"
			_tmp27_ = string_replace (_tmp26_, ":", "");
#line 176 "../src/data/Emulator.vala"
			_tmp28_ = _tmp27_;
#line 176 "../src/data/Emulator.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, "game", _tmp28_);
#line 176 "../src/data/Emulator.vala"
			_g_free0 (_tmp28_);
#line 176 "../src/data/Emulator.vala"
			_g_free0 (_tmp26_);
#line 177 "../src/data/Emulator.vala"
			_tmp29_ = variables;
#line 177 "../src/data/Emulator.vala"
			_tmp30_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) game);
#line 177 "../src/data/Emulator.vala"
			_tmp31_ = _tmp30_;
#line 177 "../src/data/Emulator.vala"
			_tmp32_ = _tmp31_;
#line 177 "../src/data/Emulator.vala"
			_tmp33_ = g_file_get_path (_tmp32_);
#line 177 "../src/data/Emulator.vala"
			_tmp34_ = _tmp33_;
#line 177 "../src/data/Emulator.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, "file", _tmp34_);
#line 177 "../src/data/Emulator.vala"
			_g_free0 (_tmp34_);
#line 177 "../src/data/Emulator.vala"
			_g_object_unref0 (_tmp32_);
#line 178 "../src/data/Emulator.vala"
			_tmp35_ = variables;
#line 178 "../src/data/Emulator.vala"
			_tmp36_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) game);
#line 178 "../src/data/Emulator.vala"
			_tmp37_ = _tmp36_;
#line 178 "../src/data/Emulator.vala"
			_tmp38_ = g_file_get_path (_tmp37_);
#line 178 "../src/data/Emulator.vala"
			_tmp39_ = _tmp38_;
#line 178 "../src/data/Emulator.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, "game_dir", _tmp39_);
#line 178 "../src/data/Emulator.vala"
			_g_free0 (_tmp39_);
#line 2031 "Emulator.c"
		} else {
			GeeHashMap* _tmp40_;
			GeeHashMap* _tmp41_;
			GeeHashMap* _tmp42_;
#line 182 "../src/data/Emulator.vala"
			_tmp40_ = variables;
#line 182 "../src/data/Emulator.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp40_, "game", "");
#line 183 "../src/data/Emulator.vala"
			_tmp41_ = variables;
#line 183 "../src/data/Emulator.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, "file", "");
#line 184 "../src/data/Emulator.vala"
			_tmp42_ = variables;
#line 184 "../src/data/Emulator.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, "game_dir", "");
#line 2048 "Emulator.c"
		}
#line 186 "../src/data/Emulator.vala"
		_tmp43_ = game_hub_data_runnable_get_arguments ((GameHubDataRunnable*) self);
#line 186 "../src/data/Emulator.vala"
		_tmp44_ = _tmp43_;
#line 186 "../src/data/Emulator.vala"
		_tmp46_ = game_hub_utils_parse_args (_tmp44_, &_tmp45_);
#line 186 "../src/data/Emulator.vala"
		args = _tmp46_;
#line 186 "../src/data/Emulator.vala"
		args_length1 = _tmp45_;
#line 186 "../src/data/Emulator.vala"
		_args_size_ = args_length1;
#line 187 "../src/data/Emulator.vala"
		_tmp47_ = args;
#line 187 "../src/data/Emulator.vala"
		_tmp47__length1 = args_length1;
#line 187 "../src/data/Emulator.vala"
		if (_tmp47_ != NULL) {
#line 2068 "Emulator.c"
			gboolean _tmp48_ = FALSE;
			gchar** _tmp56_;
			gint _tmp56__length1;
#line 189 "../src/data/Emulator.vala"
			if (exec != NULL) {
#line 2074 "Emulator.c"
				gboolean _tmp49_ = FALSE;
				gchar** _tmp50_;
				gint _tmp50__length1;
#line 189 "../src/data/Emulator.vala"
				_tmp50_ = args;
#line 189 "../src/data/Emulator.vala"
				_tmp50__length1 = args_length1;
#line 189 "../src/data/Emulator.vala"
				if (_vala_string_array_contains (_tmp50_, _tmp50__length1, "$command")) {
#line 189 "../src/data/Emulator.vala"
					_tmp49_ = TRUE;
#line 2086 "Emulator.c"
				} else {
					gchar** _tmp51_;
					gint _tmp51__length1;
#line 189 "../src/data/Emulator.vala"
					_tmp51_ = args;
#line 189 "../src/data/Emulator.vala"
					_tmp51__length1 = args_length1;
#line 189 "../src/data/Emulator.vala"
					_tmp49_ = _vala_string_array_contains (_tmp51_, _tmp51__length1, "${command}");
#line 2096 "Emulator.c"
				}
#line 189 "../src/data/Emulator.vala"
				_tmp48_ = _tmp49_;
#line 2100 "Emulator.c"
			} else {
#line 189 "../src/data/Emulator.vala"
				_tmp48_ = FALSE;
#line 2104 "Emulator.c"
			}
#line 189 "../src/data/Emulator.vala"
			if (_tmp48_) {
#line 2108 "Emulator.c"
				gchar** _tmp52_;
				GeeHashMap* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
#line 191 "../src/data/Emulator.vala"
				_tmp52_ = g_new0 (gchar*, 0 + 1);
#line 191 "../src/data/Emulator.vala"
				result_args = (_vala_array_free (result_args, result_args_length1, (GDestroyNotify) g_free), NULL);
#line 191 "../src/data/Emulator.vala"
				result_args = _tmp52_;
#line 191 "../src/data/Emulator.vala"
				result_args_length1 = 0;
#line 191 "../src/data/Emulator.vala"
				_result_args_size_ = result_args_length1;
#line 192 "../src/data/Emulator.vala"
				_tmp53_ = variables;
#line 192 "../src/data/Emulator.vala"
				_tmp54_ = g_file_get_path (exec);
#line 192 "../src/data/Emulator.vala"
				_tmp55_ = _tmp54_;
#line 192 "../src/data/Emulator.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp53_, "command", _tmp55_);
#line 192 "../src/data/Emulator.vala"
				_g_free0 (_tmp55_);
#line 2133 "Emulator.c"
			}
#line 194 "../src/data/Emulator.vala"
			_tmp56_ = args;
#line 194 "../src/data/Emulator.vala"
			_tmp56__length1 = args_length1;
#line 2139 "Emulator.c"
			{
				gchar** arg_collection = NULL;
				gint arg_collection_length1 = 0;
				gint _arg_collection_size_ = 0;
				gint arg_it = 0;
#line 194 "../src/data/Emulator.vala"
				arg_collection = _tmp56_;
#line 194 "../src/data/Emulator.vala"
				arg_collection_length1 = _tmp56__length1;
#line 194 "../src/data/Emulator.vala"
				for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
#line 2151 "Emulator.c"
					gchar* _tmp57_;
					gchar* arg = NULL;
#line 194 "../src/data/Emulator.vala"
					_tmp57_ = g_strdup (arg_collection[arg_it]);
#line 194 "../src/data/Emulator.vala"
					arg = _tmp57_;
#line 2158 "Emulator.c"
					{
						gboolean _tmp58_ = FALSE;
						const gchar* _tmp59_;
						const gchar* _tmp70_;
						const gchar* _tmp74_;
						gchar* _tmp75_;
#line 196 "../src/data/Emulator.vala"
						_tmp59_ = arg;
#line 196 "../src/data/Emulator.vala"
						if (g_strcmp0 (_tmp59_, "$game_args") == 0) {
#line 196 "../src/data/Emulator.vala"
							_tmp58_ = TRUE;
#line 2171 "Emulator.c"
						} else {
							const gchar* _tmp60_;
#line 196 "../src/data/Emulator.vala"
							_tmp60_ = arg;
#line 196 "../src/data/Emulator.vala"
							_tmp58_ = g_strcmp0 (_tmp60_, "${game_args}") == 0;
#line 2178 "Emulator.c"
						}
#line 196 "../src/data/Emulator.vala"
						if (_tmp58_) {
#line 198 "../src/data/Emulator.vala"
							if (game != NULL) {
#line 2184 "Emulator.c"
								gchar** game_args = NULL;
								const gchar* _tmp61_;
								const gchar* _tmp62_;
								gint _tmp63_ = 0;
								gchar** _tmp64_;
								gint game_args_length1;
								gint _game_args_size_;
								gchar** _tmp65_;
								gint _tmp65__length1;
#line 200 "../src/data/Emulator.vala"
								_tmp61_ = game_hub_data_runnable_get_arguments ((GameHubDataRunnable*) game);
#line 200 "../src/data/Emulator.vala"
								_tmp62_ = _tmp61_;
#line 200 "../src/data/Emulator.vala"
								_tmp64_ = game_hub_utils_parse_args (_tmp62_, &_tmp63_);
#line 200 "../src/data/Emulator.vala"
								game_args = _tmp64_;
#line 200 "../src/data/Emulator.vala"
								game_args_length1 = _tmp63_;
#line 200 "../src/data/Emulator.vala"
								_game_args_size_ = game_args_length1;
#line 201 "../src/data/Emulator.vala"
								_tmp65_ = game_args;
#line 201 "../src/data/Emulator.vala"
								_tmp65__length1 = game_args_length1;
#line 201 "../src/data/Emulator.vala"
								if (_tmp65_ != NULL) {
#line 2212 "Emulator.c"
									gchar** _tmp66_;
									gint _tmp66__length1;
#line 203 "../src/data/Emulator.vala"
									_tmp66_ = game_args;
#line 203 "../src/data/Emulator.vala"
									_tmp66__length1 = game_args_length1;
#line 2219 "Emulator.c"
									{
										gchar** game_arg_collection = NULL;
										gint game_arg_collection_length1 = 0;
										gint _game_arg_collection_size_ = 0;
										gint game_arg_it = 0;
#line 203 "../src/data/Emulator.vala"
										game_arg_collection = _tmp66_;
#line 203 "../src/data/Emulator.vala"
										game_arg_collection_length1 = _tmp66__length1;
#line 203 "../src/data/Emulator.vala"
										for (game_arg_it = 0; game_arg_it < game_arg_collection_length1; game_arg_it = game_arg_it + 1) {
#line 2231 "Emulator.c"
											gchar* _tmp67_;
											gchar* game_arg = NULL;
#line 203 "../src/data/Emulator.vala"
											_tmp67_ = g_strdup (game_arg_collection[game_arg_it]);
#line 203 "../src/data/Emulator.vala"
											game_arg = _tmp67_;
#line 2238 "Emulator.c"
											{
												const gchar* _tmp68_;
												gchar* _tmp69_;
#line 205 "../src/data/Emulator.vala"
												_tmp68_ = game_arg;
#line 205 "../src/data/Emulator.vala"
												_tmp69_ = g_strdup (_tmp68_);
#line 205 "../src/data/Emulator.vala"
												_vala_array_add11 (&result_args, &result_args_length1, &_result_args_size_, _tmp69_);
#line 203 "../src/data/Emulator.vala"
												_g_free0 (game_arg);
#line 2250 "Emulator.c"
											}
										}
									}
								}
#line 198 "../src/data/Emulator.vala"
								game_args = (_vala_array_free (game_args, game_args_length1, (GDestroyNotify) g_free), NULL);
#line 2257 "Emulator.c"
							}
#line 209 "../src/data/Emulator.vala"
							_g_free0 (arg);
#line 209 "../src/data/Emulator.vala"
							continue;
#line 2263 "Emulator.c"
						}
#line 211 "../src/data/Emulator.vala"
						_tmp70_ = arg;
#line 211 "../src/data/Emulator.vala"
						if (string_contains (_tmp70_, "$")) {
#line 2269 "Emulator.c"
							const gchar* _tmp71_;
							GeeHashMap* _tmp72_;
							gchar* _tmp73_;
#line 213 "../src/data/Emulator.vala"
							_tmp71_ = arg;
#line 213 "../src/data/Emulator.vala"
							_tmp72_ = variables;
#line 213 "../src/data/Emulator.vala"
							_tmp73_ = game_hub_utils_fs_utils_expand (_tmp71_, NULL, _tmp72_);
#line 213 "../src/data/Emulator.vala"
							_g_free0 (arg);
#line 213 "../src/data/Emulator.vala"
							arg = _tmp73_;
#line 2283 "Emulator.c"
						}
#line 215 "../src/data/Emulator.vala"
						_tmp74_ = arg;
#line 215 "../src/data/Emulator.vala"
						_tmp75_ = g_strdup (_tmp74_);
#line 215 "../src/data/Emulator.vala"
						_vala_array_add12 (&result_args, &result_args_length1, &_result_args_size_, _tmp75_);
#line 194 "../src/data/Emulator.vala"
						_g_free0 (arg);
#line 2293 "Emulator.c"
					}
				}
			}
		}
#line 169 "../src/data/Emulator.vala"
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 169 "../src/data/Emulator.vala"
		_g_object_unref0 (variables);
#line 2302 "Emulator.c"
	}
#line 220 "../src/data/Emulator.vala"
	_tmp76_ = result_args;
#line 220 "../src/data/Emulator.vala"
	_tmp76__length1 = result_args_length1;
#line 220 "../src/data/Emulator.vala"
	if (result_length1) {
#line 220 "../src/data/Emulator.vala"
		*result_length1 = _tmp76__length1;
#line 2312 "Emulator.c"
	}
#line 220 "../src/data/Emulator.vala"
	result = _tmp76_;
#line 220 "../src/data/Emulator.vala"
	return result;
#line 2318 "Emulator.c"
}

static void
game_hub_data_emulator_real_run_data_free (gpointer _data)
{
	GameHubDataEmulatorRunData* _data_;
	_data_ = _data;
#line 25 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/Emulator.vala"
	g_slice_free (GameHubDataEmulatorRunData, _data_);
#line 2330 "Emulator.c"
}

static void
game_hub_data_emulator_real_run (GameHubDataRunnable* base,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	GameHubDataEmulator * self;
	GameHubDataEmulatorRunData* _data_;
	GameHubDataEmulator* _tmp0_;
#line 25 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 25 "../src/data/Emulator.vala"
	_data_ = g_slice_new0 (GameHubDataEmulatorRunData);
#line 25 "../src/data/Emulator.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/Emulator.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_emulator_real_run_data_free);
#line 25 "../src/data/Emulator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/Emulator.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/Emulator.vala"
	game_hub_data_emulator_real_run_co (_data_);
#line 2355 "Emulator.c"
}

static void
game_hub_data_emulator_run_finish (GameHubDataRunnable* base,
                                   GAsyncResult* _res_)
{
	GameHubDataEmulatorRunData* _data_;
#line 25 "../src/data/Emulator.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2365 "Emulator.c"
}

static void
game_hub_data_emulator_run_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	GameHubDataEmulatorRunData* _data_;
#line 229 "../src/data/Emulator.vala"
	_data_ = _user_data_;
#line 229 "../src/data/Emulator.vala"
	_data_->_source_object_ = source_object;
#line 229 "../src/data/Emulator.vala"
	_data_->_res_ = _res_;
#line 229 "../src/data/Emulator.vala"
	game_hub_data_emulator_real_run_co (_data_);
#line 2382 "Emulator.c"
}

static gboolean
___lambda130_ (GameHubDataEmulator* self)
{
	gboolean result;
#line 232 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) self, FALSE);
#line 232 "../src/data/Emulator.vala"
	game_hub_data_runnable_IsLaunched = FALSE;
#line 233 "../src/data/Emulator.vala"
	result = G_SOURCE_REMOVE;
#line 233 "../src/data/Emulator.vala"
	return result;
#line 2397 "Emulator.c"
}

static gboolean
____lambda130__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda130_ ((GameHubDataEmulator*) self);
#line 231 "../src/data/Emulator.vala"
	return result;
#line 2407 "Emulator.c"
}

static gboolean
game_hub_data_emulator_real_run_co (GameHubDataEmulatorRunData* _data_)
{
#line 223 "../src/data/Emulator.vala"
	switch (_data_->_state_) {
#line 223 "../src/data/Emulator.vala"
		case 0:
#line 2417 "Emulator.c"
		goto _state_0;
#line 223 "../src/data/Emulator.vala"
		case 1:
#line 2421 "Emulator.c"
		goto _state_1;
		default:
#line 223 "../src/data/Emulator.vala"
		g_assert_not_reached ();
#line 2426 "Emulator.c"
	}
	_state_0:
#line 225 "../src/data/Emulator.vala"
	if (game_hub_data_runnable_can_be_launched ((GameHubDataRunnable*) _data_->self, TRUE)) {
#line 225 "../src/data/Emulator.vala"
		_data_->_tmp1_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 225 "../src/data/Emulator.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 225 "../src/data/Emulator.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 225 "../src/data/Emulator.vala"
		_data_->_tmp0_ = g_file_query_exists (_data_->_tmp3_, NULL);
#line 225 "../src/data/Emulator.vala"
		_g_object_unref0 (_data_->_tmp3_);
#line 2441 "Emulator.c"
	} else {
#line 225 "../src/data/Emulator.vala"
		_data_->_tmp0_ = FALSE;
#line 2445 "Emulator.c"
	}
#line 225 "../src/data/Emulator.vala"
	if (_data_->_tmp0_) {
#line 227 "../src/data/Emulator.vala"
		game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) _data_->self, TRUE);
#line 227 "../src/data/Emulator.vala"
		game_hub_data_runnable_IsLaunched = TRUE;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp4_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp7_ = 0;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp8_ = game_hub_data_emulator_get_args (_data_->self, NULL, _data_->_tmp6_, &_data_->_tmp7_);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp9__length1 = _data_->_tmp7_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp10_ = game_hub_utils_run (_data_->_tmp9_, (gint) _data_->_tmp7_);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp12_ = game_hub_data_runnable_get_work_dir ((GameHubDataRunnable*) _data_->self);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp15_ = g_file_get_path (_data_->_tmp14_);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp16_ = _data_->_tmp15_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp17_ = game_hub_utils_run_task_dir (_data_->_tmp11_, _data_->_tmp16_);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp19_ = game_hub_utils_run_task_override_runtime (_data_->_tmp18_, TRUE);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp20_ = _data_->_tmp19_;
#line 229 "../src/data/Emulator.vala"
		_data_->_state_ = 1;
#line 229 "../src/data/Emulator.vala"
		game_hub_utils_run_task_run_sync_thread (_data_->_tmp20_, FALSE, game_hub_data_emulator_run_ready, _data_);
#line 229 "../src/data/Emulator.vala"
		return FALSE;
#line 2495 "Emulator.c"
		_state_1:
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp21_ = game_hub_utils_run_task_run_sync_thread_finish (_data_->_tmp20_, _data_->_res_);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp22_ = _data_->_tmp21_;
#line 229 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_result_unref0 (_data_->_tmp22_);
#line 229 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_unref0 (_data_->_tmp20_);
#line 229 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_unref0 (_data_->_tmp18_);
#line 229 "../src/data/Emulator.vala"
		_g_free0 (_data_->_tmp16_);
#line 229 "../src/data/Emulator.vala"
		_g_object_unref0 (_data_->_tmp14_);
#line 229 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_unref0 (_data_->_tmp11_);
#line 229 "../src/data/Emulator.vala"
		_data_->_tmp9_ = (_vala_array_free (_data_->_tmp9_, _data_->_tmp9__length1, (GDestroyNotify) g_free), NULL);
#line 229 "../src/data/Emulator.vala"
		_g_object_unref0 (_data_->_tmp6_);
#line 231 "../src/data/Emulator.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda130__gsource_func, g_object_ref (_data_->self), g_object_unref);
#line 2519 "Emulator.c"
	}
#line 223 "../src/data/Emulator.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 223 "../src/data/Emulator.vala"
	if (_data_->_state_ != 0) {
#line 223 "../src/data/Emulator.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 223 "../src/data/Emulator.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2529 "Emulator.c"
		}
	}
#line 223 "../src/data/Emulator.vala"
	g_object_unref (_data_->_async_result);
#line 223 "../src/data/Emulator.vala"
	return FALSE;
#line 2536 "Emulator.c"
}

static void
game_hub_data_emulator_run_game_data_free (gpointer _data)
{
	GameHubDataEmulatorRunGameData* _data_;
	_data_ = _data;
#line 25 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/Emulator.vala"
	g_slice_free (GameHubDataEmulatorRunGameData, _data_);
#line 2548 "Emulator.c"
}

void
game_hub_data_emulator_run_game (GameHubDataEmulator* self,
                                 GameHubDataGame* game,
                                 gboolean launch_in_game_dir,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	GameHubDataEmulatorRunGameData* _data_;
	GameHubDataEmulator* _tmp0_;
	GameHubDataGame* _tmp1_;
#line 25 "../src/data/Emulator.vala"
	g_return_if_fail (self != NULL);
#line 25 "../src/data/Emulator.vala"
	_data_ = g_slice_new0 (GameHubDataEmulatorRunGameData);
#line 25 "../src/data/Emulator.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/Emulator.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_emulator_run_game_data_free);
#line 25 "../src/data/Emulator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/Emulator.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/Emulator.vala"
	_tmp1_ = _g_object_ref0 (game);
#line 25 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->game);
#line 25 "../src/data/Emulator.vala"
	_data_->game = _tmp1_;
#line 25 "../src/data/Emulator.vala"
	_data_->launch_in_game_dir = launch_in_game_dir;
#line 25 "../src/data/Emulator.vala"
	game_hub_data_emulator_run_game_co (_data_);
#line 2583 "Emulator.c"
}

void
game_hub_data_emulator_run_game_finish (GameHubDataEmulator* self,
                                        GAsyncResult* _res_)
{
	GameHubDataEmulatorRunGameData* _data_;
#line 25 "../src/data/Emulator.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2593 "Emulator.c"
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
#line 238 "../src/data/Emulator.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 238 "../src/data/Emulator.vala"
	return _data10_;
#line 2603 "Emulator.c"
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 238 "../src/data/Emulator.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 2613 "Emulator.c"
		GameHubDataEmulator* self;
#line 238 "../src/data/Emulator.vala"
		self = _data10_->self;
#line 238 "../src/data/Emulator.vala"
		_g_object_unref0 (_data10_->game);
#line 238 "../src/data/Emulator.vala"
		_g_object_unref0 (self);
#line 238 "../src/data/Emulator.vala"
		g_slice_free (Block10Data, _data10_);
#line 2623 "Emulator.c"
	}
}

static void
game_hub_data_emulator_run_game_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	GameHubDataEmulatorRunGameData* _data_;
#line 242 "../src/data/Emulator.vala"
	_data_ = _user_data_;
#line 242 "../src/data/Emulator.vala"
	_data_->_source_object_ = source_object;
#line 242 "../src/data/Emulator.vala"
	_data_->_res_ = _res_;
#line 242 "../src/data/Emulator.vala"
	game_hub_data_emulator_run_game_co (_data_);
#line 2641 "Emulator.c"
}

static gboolean
___lambda131_ (Block10Data* _data10_)
{
	GameHubDataEmulator* self;
	gboolean result;
#line 265 "../src/data/Emulator.vala"
	self = _data10_->self;
#line 266 "../src/data/Emulator.vala"
	game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) self, FALSE);
#line 266 "../src/data/Emulator.vala"
	game_hub_data_runnable_IsLaunched = FALSE;
#line 267 "../src/data/Emulator.vala"
	if (_data10_->game != NULL) {
#line 269 "../src/data/Emulator.vala"
		game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) _data10_->game, FALSE);
#line 270 "../src/data/Emulator.vala"
		game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data10_->game);
#line 2661 "Emulator.c"
	}
#line 272 "../src/data/Emulator.vala"
	result = G_SOURCE_REMOVE;
#line 272 "../src/data/Emulator.vala"
	return result;
#line 2667 "Emulator.c"
}

static gboolean
____lambda131__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda131_ (self);
#line 265 "../src/data/Emulator.vala"
	return result;
#line 2677 "Emulator.c"
}

static gboolean
game_hub_data_emulator_run_game_co (GameHubDataEmulatorRunGameData* _data_)
{
#line 238 "../src/data/Emulator.vala"
	switch (_data_->_state_) {
#line 238 "../src/data/Emulator.vala"
		case 0:
#line 2687 "Emulator.c"
		goto _state_0;
#line 238 "../src/data/Emulator.vala"
		case 1:
#line 2691 "Emulator.c"
		goto _state_1;
#line 238 "../src/data/Emulator.vala"
		case 2:
#line 2695 "Emulator.c"
		goto _state_2;
		default:
#line 238 "../src/data/Emulator.vala"
		g_assert_not_reached ();
#line 2700 "Emulator.c"
	}
	_state_0:
#line 238 "../src/data/Emulator.vala"
	_data_->_data10_ = g_slice_new0 (Block10Data);
#line 238 "../src/data/Emulator.vala"
	_data_->_data10_->_ref_count_ = 1;
#line 238 "../src/data/Emulator.vala"
	_data_->_data10_->self = g_object_ref (_data_->self);
#line 238 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->_data10_->game);
#line 238 "../src/data/Emulator.vala"
	_data_->_data10_->game = _data_->game;
#line 238 "../src/data/Emulator.vala"
	_data_->_data10_->_async_data_ = _data_;
#line 240 "../src/data/Emulator.vala"
	_data_->_tmp0_ = game_hub_data_runnable_get_use_compat ((GameHubDataRunnable*) _data_->self);
#line 240 "../src/data/Emulator.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 240 "../src/data/Emulator.vala"
	if (_data_->_tmp1_) {
#line 242 "../src/data/Emulator.vala"
		_data_->_state_ = 1;
#line 242 "../src/data/Emulator.vala"
		game_hub_data_emulator_run_game_compat (_data_->self, _data_->_data10_->game, _data_->launch_in_game_dir, game_hub_data_emulator_run_game_ready, _data_);
#line 242 "../src/data/Emulator.vala"
		return FALSE;
#line 2727 "Emulator.c"
		_state_1:
#line 242 "../src/data/Emulator.vala"
		game_hub_data_emulator_run_game_compat_finish (_data_->self, _data_->_res_);
#line 243 "../src/data/Emulator.vala"
		block10_data_unref (_data_->_data10_);
#line 243 "../src/data/Emulator.vala"
		_data_->_data10_ = NULL;
#line 243 "../src/data/Emulator.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 243 "../src/data/Emulator.vala"
		if (_data_->_state_ != 0) {
#line 243 "../src/data/Emulator.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 243 "../src/data/Emulator.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2743 "Emulator.c"
			}
		}
#line 243 "../src/data/Emulator.vala"
		g_object_unref (_data_->_async_result);
#line 243 "../src/data/Emulator.vala"
		return FALSE;
#line 2750 "Emulator.c"
	}
#line 246 "../src/data/Emulator.vala"
	_data_->_tmp2_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 246 "../src/data/Emulator.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 246 "../src/data/Emulator.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 246 "../src/data/Emulator.vala"
	_data_->_tmp5_ = g_file_query_exists (_data_->_tmp4_, NULL);
#line 246 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->_tmp4_);
#line 246 "../src/data/Emulator.vala"
	if (_data_->_tmp5_) {
#line 248 "../src/data/Emulator.vala"
		game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) _data_->self, TRUE);
#line 248 "../src/data/Emulator.vala"
		game_hub_data_runnable_IsLaunched = TRUE;
#line 250 "../src/data/Emulator.vala"
		if (_data_->_data10_->game != NULL) {
#line 252 "../src/data/Emulator.vala"
			game_hub_data_runnable_set_is_running ((GameHubDataRunnable*) _data_->_data10_->game, TRUE);
#line 253 "../src/data/Emulator.vala"
			game_hub_data_runnable_update_status ((GameHubDataRunnable*) _data_->_data10_->game);
#line 2774 "Emulator.c"
		}
#line 256 "../src/data/Emulator.vala"
		if (_data_->_data10_->game != NULL) {
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp7_ = _data_->launch_in_game_dir;
#line 2780 "Emulator.c"
		} else {
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp7_ = FALSE;
#line 2784 "Emulator.c"
		}
#line 256 "../src/data/Emulator.vala"
		if (_data_->_tmp7_) {
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp8_ = game_hub_data_runnable_get_work_dir ((GameHubDataRunnable*) _data_->_data10_->game);
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 256 "../src/data/Emulator.vala"
			_g_object_unref0 (_data_->_tmp6_);
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp6_ = _data_->_tmp9_;
#line 2796 "Emulator.c"
		} else {
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp10_ = game_hub_data_runnable_get_work_dir ((GameHubDataRunnable*) _data_->self);
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp11_ = _data_->_tmp10_;
#line 256 "../src/data/Emulator.vala"
			_g_object_unref0 (_data_->_tmp6_);
#line 256 "../src/data/Emulator.vala"
			_data_->_tmp6_ = _data_->_tmp11_;
#line 2806 "Emulator.c"
		}
#line 256 "../src/data/Emulator.vala"
		_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp6_);
#line 256 "../src/data/Emulator.vala"
		_data_->dir = _data_->_tmp12_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp13_ = game_hub_data_runnable_get_executable ((GameHubDataRunnable*) _data_->self);
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp14_ = _data_->_tmp13_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp16_ = 0;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp17_ = game_hub_data_emulator_get_args (_data_->self, _data_->_data10_->game, _data_->_tmp15_, &_data_->_tmp16_);
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp18_ = _data_->_tmp17_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp18__length1 = _data_->_tmp16_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp19_ = game_hub_utils_run (_data_->_tmp18_, (gint) _data_->_tmp16_);
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp20_ = _data_->_tmp19_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp21_ = _data_->dir;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp22_ = g_file_get_path (_data_->_tmp21_);
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp23_ = _data_->_tmp22_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp24_ = game_hub_utils_run_task_dir (_data_->_tmp20_, _data_->_tmp23_);
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp26_ = game_hub_utils_run_task_override_runtime (_data_->_tmp25_, TRUE);
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp27_ = _data_->_tmp26_;
#line 258 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_unref0 (_data_->_tmp25_);
#line 258 "../src/data/Emulator.vala"
		_g_free0 (_data_->_tmp23_);
#line 258 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_unref0 (_data_->_tmp20_);
#line 258 "../src/data/Emulator.vala"
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_free), NULL);
#line 258 "../src/data/Emulator.vala"
		_g_object_unref0 (_data_->_tmp15_);
#line 258 "../src/data/Emulator.vala"
		_data_->task = _data_->_tmp27_;
#line 259 "../src/data/Emulator.vala"
		if (_data_->_data10_->game != NULL) {
#line 259 "../src/data/Emulator.vala"
			_data_->_tmp28_ = GAME_HUB_DATA_IS_TWEAKABLE_GAME (_data_->_data10_->game);
#line 2860 "Emulator.c"
		} else {
#line 259 "../src/data/Emulator.vala"
			_data_->_tmp28_ = FALSE;
#line 2864 "Emulator.c"
		}
#line 259 "../src/data/Emulator.vala"
		if (_data_->_tmp28_) {
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp29_ = _data_->task;
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp30_ = 0;
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp31_ = game_hub_data_tweakable_game_get_enabled_tweaks (G_TYPE_CHECK_INSTANCE_CAST (_data_->_data10_->game, GAME_HUB_DATA_TYPE_TWEAKABLE_GAME, GameHubDataTweakableGame), NULL, &_data_->_tmp30_);
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp32_ = _data_->_tmp31_;
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp32__length1 = _data_->_tmp30_;
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp33_ = game_hub_utils_run_task_tweaks (_data_->_tmp29_, _data_->_tmp32_, (gint) _data_->_tmp30_);
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp34_ = _data_->_tmp33_;
#line 261 "../src/data/Emulator.vala"
			_game_hub_utils_run_task_unref0 (_data_->_tmp34_);
#line 261 "../src/data/Emulator.vala"
			_data_->_tmp32_ = (_vala_array_free (_data_->_tmp32_, _data_->_tmp32__length1, (GDestroyNotify) g_object_unref), NULL);
#line 2886 "Emulator.c"
		}
#line 263 "../src/data/Emulator.vala"
		_data_->_tmp35_ = _data_->task;
#line 263 "../src/data/Emulator.vala"
		_data_->_state_ = 2;
#line 263 "../src/data/Emulator.vala"
		game_hub_utils_run_task_run_sync_thread (_data_->_tmp35_, FALSE, game_hub_data_emulator_run_game_ready, _data_);
#line 263 "../src/data/Emulator.vala"
		return FALSE;
#line 2896 "Emulator.c"
		_state_2:
#line 263 "../src/data/Emulator.vala"
		_data_->_tmp36_ = game_hub_utils_run_task_run_sync_thread_finish (_data_->_tmp35_, _data_->_res_);
#line 263 "../src/data/Emulator.vala"
		_data_->_tmp37_ = _data_->_tmp36_;
#line 263 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_result_unref0 (_data_->_tmp37_);
#line 265 "../src/data/Emulator.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda131__gsource_func, block10_data_ref (_data_->_data10_), block10_data_unref);
#line 246 "../src/data/Emulator.vala"
		_game_hub_utils_run_task_unref0 (_data_->task);
#line 246 "../src/data/Emulator.vala"
		_g_object_unref0 (_data_->dir);
#line 246 "../src/data/Emulator.vala"
		_g_object_unref0 (_data_->_tmp6_);
#line 2912 "Emulator.c"
	}
#line 238 "../src/data/Emulator.vala"
	block10_data_unref (_data_->_data10_);
#line 238 "../src/data/Emulator.vala"
	_data_->_data10_ = NULL;
#line 238 "../src/data/Emulator.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 238 "../src/data/Emulator.vala"
	if (_data_->_state_ != 0) {
#line 238 "../src/data/Emulator.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 238 "../src/data/Emulator.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2926 "Emulator.c"
		}
	}
#line 238 "../src/data/Emulator.vala"
	g_object_unref (_data_->_async_result);
#line 238 "../src/data/Emulator.vala"
	return FALSE;
#line 2933 "Emulator.c"
}

static void
game_hub_data_emulator_run_game_compat_data_free (gpointer _data)
{
	GameHubDataEmulatorRunGameCompatData* _data_;
	_data_ = _data;
#line 25 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->game);
#line 25 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->self);
#line 25 "../src/data/Emulator.vala"
	g_slice_free (GameHubDataEmulatorRunGameCompatData, _data_);
#line 2947 "Emulator.c"
}

void
game_hub_data_emulator_run_game_compat (GameHubDataEmulator* self,
                                        GameHubDataGame* game,
                                        gboolean launch_in_game_dir,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GameHubDataEmulatorRunGameCompatData* _data_;
	GameHubDataEmulator* _tmp0_;
	GameHubDataGame* _tmp1_;
#line 25 "../src/data/Emulator.vala"
	g_return_if_fail (self != NULL);
#line 25 "../src/data/Emulator.vala"
	_data_ = g_slice_new0 (GameHubDataEmulatorRunGameCompatData);
#line 25 "../src/data/Emulator.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 25 "../src/data/Emulator.vala"
	g_task_set_task_data (_data_->_async_result, _data_, game_hub_data_emulator_run_game_compat_data_free);
#line 25 "../src/data/Emulator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "../src/data/Emulator.vala"
	_data_->self = _tmp0_;
#line 25 "../src/data/Emulator.vala"
	_tmp1_ = _g_object_ref0 (game);
#line 25 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->game);
#line 25 "../src/data/Emulator.vala"
	_data_->game = _tmp1_;
#line 25 "../src/data/Emulator.vala"
	_data_->launch_in_game_dir = launch_in_game_dir;
#line 25 "../src/data/Emulator.vala"
	game_hub_data_emulator_run_game_compat_co (_data_);
#line 2982 "Emulator.c"
}

void
game_hub_data_emulator_run_game_compat_finish (GameHubDataEmulator* self,
                                               GAsyncResult* _res_)
{
	GameHubDataEmulatorRunGameCompatData* _data_;
#line 25 "../src/data/Emulator.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2992 "Emulator.c"
}

static gboolean
game_hub_data_emulator_run_game_compat_co (GameHubDataEmulatorRunGameCompatData* _data_)
{
#line 277 "../src/data/Emulator.vala"
	switch (_data_->_state_) {
#line 277 "../src/data/Emulator.vala"
		case 0:
#line 3002 "Emulator.c"
		goto _state_0;
		default:
#line 277 "../src/data/Emulator.vala"
		g_assert_not_reached ();
#line 3007 "Emulator.c"
	}
	_state_0:
#line 279 "../src/data/Emulator.vala"
	_data_->_tmp0_ = game_hub_ui_dialogs_compat_run_dialog_new ((GameHubDataRunnable*) _data_->self, FALSE, _data_->game, _data_->launch_in_game_dir);
#line 279 "../src/data/Emulator.vala"
	g_object_ref_sink (_data_->_tmp0_);
#line 279 "../src/data/Emulator.vala"
	_data_->_tmp1_ = _data_->_tmp0_;
#line 279 "../src/data/Emulator.vala"
	_g_object_unref0 (_data_->_tmp1_);
#line 277 "../src/data/Emulator.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 277 "../src/data/Emulator.vala"
	if (_data_->_state_ != 0) {
#line 277 "../src/data/Emulator.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 277 "../src/data/Emulator.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3026 "Emulator.c"
		}
	}
#line 277 "../src/data/Emulator.vala"
	g_object_unref (_data_->_async_result);
#line 277 "../src/data/Emulator.vala"
	return FALSE;
#line 3033 "Emulator.c"
}

gboolean
game_hub_data_emulator_is_equal (GameHubDataEmulator* first,
                                 GameHubDataEmulator* second)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 282 "../src/data/Emulator.vala"
	g_return_val_if_fail (first != NULL, FALSE);
#line 282 "../src/data/Emulator.vala"
	g_return_val_if_fail (second != NULL, FALSE);
#line 284 "../src/data/Emulator.vala"
	if (first == second) {
#line 284 "../src/data/Emulator.vala"
		_tmp0_ = TRUE;
#line 3050 "Emulator.c"
	} else {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 284 "../src/data/Emulator.vala"
		_tmp1_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) first);
#line 284 "../src/data/Emulator.vala"
		_tmp2_ = _tmp1_;
#line 284 "../src/data/Emulator.vala"
		_tmp3_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) second);
#line 284 "../src/data/Emulator.vala"
		_tmp4_ = _tmp3_;
#line 284 "../src/data/Emulator.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, _tmp4_) == 0;
#line 3066 "Emulator.c"
	}
#line 284 "../src/data/Emulator.vala"
	result = _tmp0_;
#line 284 "../src/data/Emulator.vala"
	return result;
#line 3072 "Emulator.c"
}

guint
game_hub_data_emulator_hash (GameHubDataEmulator* emu)
{
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint result;
#line 287 "../src/data/Emulator.vala"
	g_return_val_if_fail (emu != NULL, 0U);
#line 289 "../src/data/Emulator.vala"
	_tmp0_ = g_str_hash;
#line 289 "../src/data/Emulator.vala"
	_tmp1_ = game_hub_data_runnable_get_id ((GameHubDataRunnable*) emu);
#line 289 "../src/data/Emulator.vala"
	_tmp2_ = _tmp1_;
#line 289 "../src/data/Emulator.vala"
	result = _tmp0_ (_tmp2_);
#line 289 "../src/data/Emulator.vala"
	return result;
#line 3094 "Emulator.c"
}

static GFile*
game_hub_data_emulator_real_get_executable (GameHubDataRunnable* base)
{
	GFile* result;
	GameHubDataEmulator* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 30 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 30 "../src/data/Emulator.vala"
	_tmp0_ = self->priv->_executable;
#line 30 "../src/data/Emulator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "../src/data/Emulator.vala"
	result = _tmp1_;
#line 30 "../src/data/Emulator.vala"
	return result;
#line 3114 "Emulator.c"
}

static void
game_hub_data_emulator_real_set_executable (GameHubDataRunnable* base,
                                            GFile* value)
{
	GameHubDataEmulator* self;
	GFile* old_value;
#line 30 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 30 "../src/data/Emulator.vala"
	old_value = game_hub_data_emulator_real_get_executable (base);
#line 30 "../src/data/Emulator.vala"
	if (old_value != value) {
#line 3129 "Emulator.c"
		GFile* _tmp0_;
#line 30 "../src/data/Emulator.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 30 "../src/data/Emulator.vala"
		_g_object_unref0 (self->priv->_executable);
#line 30 "../src/data/Emulator.vala"
		self->priv->_executable = _tmp0_;
#line 30 "../src/data/Emulator.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_EXECUTABLE_PROPERTY]);
#line 3139 "Emulator.c"
	}
#line 30 "../src/data/Emulator.vala"
	_g_object_unref0 (old_value);
#line 3143 "Emulator.c"
}

static GFile*
game_hub_data_emulator_real_get_work_dir (GameHubDataRunnable* base)
{
	GFile* result;
	GameHubDataEmulator* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
#line 35 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 37 "../src/data/Emulator.vala"
	_tmp0_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 37 "../src/data/Emulator.vala"
	_tmp1_ = _tmp0_;
#line 37 "../src/data/Emulator.vala"
	if (_tmp1_ == NULL) {
#line 37 "../src/data/Emulator.vala"
		result = NULL;
#line 37 "../src/data/Emulator.vala"
		return result;
#line 3169 "Emulator.c"
	}
#line 38 "../src/data/Emulator.vala"
	_tmp3_ = self->work_dir_path;
#line 38 "../src/data/Emulator.vala"
	if (_tmp3_ == NULL) {
#line 38 "../src/data/Emulator.vala"
		_tmp2_ = TRUE;
#line 3177 "Emulator.c"
	} else {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
#line 38 "../src/data/Emulator.vala"
		_tmp4_ = self->work_dir_path;
#line 38 "../src/data/Emulator.vala"
		_tmp5_ = strlen (_tmp4_);
#line 38 "../src/data/Emulator.vala"
		_tmp6_ = _tmp5_;
#line 38 "../src/data/Emulator.vala"
		_tmp2_ = _tmp6_ == 0;
#line 3190 "Emulator.c"
	}
#line 38 "../src/data/Emulator.vala"
	if (_tmp2_) {
#line 3194 "Emulator.c"
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
#line 38 "../src/data/Emulator.vala"
		_tmp7_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 38 "../src/data/Emulator.vala"
		_tmp8_ = _tmp7_;
#line 38 "../src/data/Emulator.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 38 "../src/data/Emulator.vala"
		result = _tmp9_;
#line 38 "../src/data/Emulator.vala"
		return result;
#line 3208 "Emulator.c"
	}
#line 39 "../src/data/Emulator.vala"
	_tmp10_ = self->work_dir_path;
#line 39 "../src/data/Emulator.vala"
	_tmp11_ = game_hub_data_emulator_get_file (self, _tmp10_);
#line 39 "../src/data/Emulator.vala"
	result = _tmp11_;
#line 39 "../src/data/Emulator.vala"
	return result;
#line 3218 "Emulator.c"
}

static void
game_hub_data_emulator_real_set_work_dir (GameHubDataRunnable* base,
                                          GFile* value)
{
	GameHubDataEmulator* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 41 "../src/data/Emulator.vala"
	self = (GameHubDataEmulator*) base;
#line 43 "../src/data/Emulator.vala"
	if (value != NULL) {
#line 43 "../src/data/Emulator.vala"
		_tmp2_ = g_file_query_exists (value, NULL);
#line 3235 "Emulator.c"
	} else {
#line 43 "../src/data/Emulator.vala"
		_tmp2_ = FALSE;
#line 3239 "Emulator.c"
	}
#line 43 "../src/data/Emulator.vala"
	if (_tmp2_) {
#line 3243 "Emulator.c"
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 43 "../src/data/Emulator.vala"
		_tmp3_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 43 "../src/data/Emulator.vala"
		_tmp4_ = _tmp3_;
#line 43 "../src/data/Emulator.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 3252 "Emulator.c"
	} else {
#line 43 "../src/data/Emulator.vala"
		_tmp1_ = FALSE;
#line 3256 "Emulator.c"
	}
#line 43 "../src/data/Emulator.vala"
	if (_tmp1_) {
#line 3260 "Emulator.c"
		GFile* _tmp5_;
		GFile* _tmp6_;
#line 43 "../src/data/Emulator.vala"
		_tmp5_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 43 "../src/data/Emulator.vala"
		_tmp6_ = _tmp5_;
#line 43 "../src/data/Emulator.vala"
		_tmp0_ = g_file_query_exists (_tmp6_, NULL);
#line 3269 "Emulator.c"
	} else {
#line 43 "../src/data/Emulator.vala"
		_tmp0_ = FALSE;
#line 3273 "Emulator.c"
	}
#line 43 "../src/data/Emulator.vala"
	if (_tmp0_) {
#line 3277 "Emulator.c"
		GFile** dirs = NULL;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile** _tmp10_;
		gint dirs_length1;
		gint _dirs_size_;
		GFile** _tmp11_;
		gint _tmp11__length1;
#line 45 "../src/data/Emulator.vala"
		_tmp7_ = game_hub_data_runnable_get_install_dir ((GameHubDataRunnable*) self);
#line 45 "../src/data/Emulator.vala"
		_tmp8_ = _tmp7_;
#line 45 "../src/data/Emulator.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 45 "../src/data/Emulator.vala"
		_tmp10_ = g_new0 (GFile*, 1 + 1);
#line 45 "../src/data/Emulator.vala"
		_tmp10_[0] = _tmp9_;
#line 45 "../src/data/Emulator.vala"
		dirs = _tmp10_;
#line 45 "../src/data/Emulator.vala"
		dirs_length1 = 1;
#line 45 "../src/data/Emulator.vala"
		_dirs_size_ = dirs_length1;
#line 46 "../src/data/Emulator.vala"
		_tmp11_ = dirs;
#line 46 "../src/data/Emulator.vala"
		_tmp11__length1 = dirs_length1;
#line 3307 "Emulator.c"
		{
			GFile** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
#line 46 "../src/data/Emulator.vala"
			dir_collection = _tmp11_;
#line 46 "../src/data/Emulator.vala"
			dir_collection_length1 = _tmp11__length1;
#line 46 "../src/data/Emulator.vala"
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
#line 3319 "Emulator.c"
				GFile* _tmp12_;
				GFile* dir = NULL;
#line 46 "../src/data/Emulator.vala"
				_tmp12_ = _g_object_ref0 (dir_collection[dir_it]);
#line 46 "../src/data/Emulator.vala"
				dir = _tmp12_;
#line 3326 "Emulator.c"
				{
					gchar* _tmp13_;
					gchar* _tmp14_;
					GFile* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gboolean _tmp18_;
#line 48 "../src/data/Emulator.vala"
					_tmp13_ = g_file_get_path (value);
#line 48 "../src/data/Emulator.vala"
					_tmp14_ = _tmp13_;
#line 48 "../src/data/Emulator.vala"
					_tmp15_ = dir;
#line 48 "../src/data/Emulator.vala"
					_tmp16_ = g_file_get_path (_tmp15_);
#line 48 "../src/data/Emulator.vala"
					_tmp17_ = _tmp16_;
#line 48 "../src/data/Emulator.vala"
					_tmp18_ = g_str_has_prefix (_tmp14_, _tmp17_);
#line 48 "../src/data/Emulator.vala"
					_g_free0 (_tmp17_);
#line 48 "../src/data/Emulator.vala"
					_g_free0 (_tmp14_);
#line 48 "../src/data/Emulator.vala"
					if (_tmp18_) {
#line 3352 "Emulator.c"
						gchar* _tmp19_;
						gchar* _tmp20_;
						GFile* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
#line 50 "../src/data/Emulator.vala"
						_tmp19_ = g_file_get_path (value);
#line 50 "../src/data/Emulator.vala"
						_tmp20_ = _tmp19_;
#line 50 "../src/data/Emulator.vala"
						_tmp21_ = dir;
#line 50 "../src/data/Emulator.vala"
						_tmp22_ = g_file_get_path (_tmp21_);
#line 50 "../src/data/Emulator.vala"
						_tmp23_ = _tmp22_;
#line 50 "../src/data/Emulator.vala"
						_tmp24_ = string_replace (_tmp20_, _tmp23_, "$game_dir/");
#line 50 "../src/data/Emulator.vala"
						_g_free0 (self->work_dir_path);
#line 50 "../src/data/Emulator.vala"
						self->work_dir_path = _tmp24_;
#line 50 "../src/data/Emulator.vala"
						_g_free0 (_tmp23_);
#line 50 "../src/data/Emulator.vala"
						_g_free0 (_tmp20_);
#line 51 "../src/data/Emulator.vala"
						_g_object_unref0 (dir);
#line 51 "../src/data/Emulator.vala"
						break;
#line 3383 "Emulator.c"
					}
#line 46 "../src/data/Emulator.vala"
					_g_object_unref0 (dir);
#line 3387 "Emulator.c"
				}
			}
		}
#line 43 "../src/data/Emulator.vala"
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 3393 "Emulator.c"
	} else {
#line 57 "../src/data/Emulator.vala"
		_g_free0 (self->work_dir_path);
#line 57 "../src/data/Emulator.vala"
		self->work_dir_path = NULL;
#line 3399 "Emulator.c"
	}
#line 59 "../src/data/Emulator.vala"
	game_hub_data_runnable_save ((GameHubDataRunnable*) self);
#line 41 "../src/data/Emulator.vala"
	g_object_notify_by_pspec ((GObject *) self, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_WORK_DIR_PROPERTY]);
#line 3405 "Emulator.c"
}

const gchar*
game_hub_data_emulator_get_game_executable_pattern (GameHubDataEmulator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 85 "../src/data/Emulator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "../src/data/Emulator.vala"
	_tmp0_ = self->priv->_game_executable_pattern;
#line 85 "../src/data/Emulator.vala"
	result = _tmp0_;
#line 85 "../src/data/Emulator.vala"
	return result;
#line 3421 "Emulator.c"
}

void
game_hub_data_emulator_set_game_executable_pattern (GameHubDataEmulator* self,
                                                    const gchar* value)
{
	gchar* old_value;
#line 85 "../src/data/Emulator.vala"
	g_return_if_fail (self != NULL);
#line 85 "../src/data/Emulator.vala"
	old_value = game_hub_data_emulator_get_game_executable_pattern (self);
#line 85 "../src/data/Emulator.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3435 "Emulator.c"
		gchar* _tmp0_;
#line 85 "../src/data/Emulator.vala"
		_tmp0_ = g_strdup (value);
#line 85 "../src/data/Emulator.vala"
		_g_free0 (self->priv->_game_executable_pattern);
#line 85 "../src/data/Emulator.vala"
		self->priv->_game_executable_pattern = _tmp0_;
#line 85 "../src/data/Emulator.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_GAME_EXECUTABLE_PATTERN_PROPERTY]);
#line 3445 "Emulator.c"
	}
}

const gchar*
game_hub_data_emulator_get_game_image_pattern (GameHubDataEmulator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 86 "../src/data/Emulator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "../src/data/Emulator.vala"
	_tmp0_ = self->priv->_game_image_pattern;
#line 86 "../src/data/Emulator.vala"
	result = _tmp0_;
#line 86 "../src/data/Emulator.vala"
	return result;
#line 3462 "Emulator.c"
}

void
game_hub_data_emulator_set_game_image_pattern (GameHubDataEmulator* self,
                                               const gchar* value)
{
	gchar* old_value;
#line 86 "../src/data/Emulator.vala"
	g_return_if_fail (self != NULL);
#line 86 "../src/data/Emulator.vala"
	old_value = game_hub_data_emulator_get_game_image_pattern (self);
#line 86 "../src/data/Emulator.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3476 "Emulator.c"
		gchar* _tmp0_;
#line 86 "../src/data/Emulator.vala"
		_tmp0_ = g_strdup (value);
#line 86 "../src/data/Emulator.vala"
		_g_free0 (self->priv->_game_image_pattern);
#line 86 "../src/data/Emulator.vala"
		self->priv->_game_image_pattern = _tmp0_;
#line 86 "../src/data/Emulator.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_GAME_IMAGE_PATTERN_PROPERTY]);
#line 3486 "Emulator.c"
	}
}

const gchar*
game_hub_data_emulator_get_game_icon_pattern (GameHubDataEmulator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 87 "../src/data/Emulator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "../src/data/Emulator.vala"
	_tmp0_ = self->priv->_game_icon_pattern;
#line 87 "../src/data/Emulator.vala"
	result = _tmp0_;
#line 87 "../src/data/Emulator.vala"
	return result;
#line 3503 "Emulator.c"
}

void
game_hub_data_emulator_set_game_icon_pattern (GameHubDataEmulator* self,
                                              const gchar* value)
{
	gchar* old_value;
#line 87 "../src/data/Emulator.vala"
	g_return_if_fail (self != NULL);
#line 87 "../src/data/Emulator.vala"
	old_value = game_hub_data_emulator_get_game_icon_pattern (self);
#line 87 "../src/data/Emulator.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 3517 "Emulator.c"
		gchar* _tmp0_;
#line 87 "../src/data/Emulator.vala"
		_tmp0_ = g_strdup (value);
#line 87 "../src/data/Emulator.vala"
		_g_free0 (self->priv->_game_icon_pattern);
#line 87 "../src/data/Emulator.vala"
		self->priv->_game_icon_pattern = _tmp0_;
#line 87 "../src/data/Emulator.vala"
		g_object_notify_by_pspec ((GObject *) self, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_GAME_ICON_PATTERN_PROPERTY]);
#line 3527 "Emulator.c"
	}
}

static inline gpointer
game_hub_data_emulator_installer_get_instance_private (GameHubDataEmulatorInstaller* self)
{
	return G_STRUCT_MEMBER_P (self, GameHubDataEmulatorInstaller_private_offset);
}

GameHubDataEmulatorInstaller*
game_hub_data_emulator_installer_construct (GType object_type,
                                            GameHubDataEmulator* emu,
                                            GFile* installer)
{
	GameHubDataEmulatorInstaller* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GameHubDataPlatform _tmp3_ = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
#line 297 "../src/data/Emulator.vala"
	g_return_val_if_fail (emu != NULL, NULL);
#line 297 "../src/data/Emulator.vala"
	g_return_val_if_fail (installer != NULL, NULL);
#line 297 "../src/data/Emulator.vala"
	self = (GameHubDataEmulatorInstaller*) game_hub_data_runnable_file_installer_construct (object_type);
#line 299 "../src/data/Emulator.vala"
	_tmp0_ = game_hub_data_runnable_get_name ((GameHubDataRunnable*) emu);
#line 299 "../src/data/Emulator.vala"
	_tmp1_ = _tmp0_;
#line 299 "../src/data/Emulator.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 299 "../src/data/Emulator.vala"
	_g_free0 (self->priv->emu_name);
#line 299 "../src/data/Emulator.vala"
	self->priv->emu_name = _tmp2_;
#line 300 "../src/data/Emulator.vala"
	game_hub_data_runnable_installer_set_id ((GameHubDataRunnableInstaller*) self, "installer");
#line 301 "../src/data/Emulator.vala"
	_tmp4_ = g_file_get_path (installer);
#line 301 "../src/data/Emulator.vala"
	_tmp5_ = _tmp4_;
#line 301 "../src/data/Emulator.vala"
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
#line 301 "../src/data/Emulator.vala"
	_tmp7_ = _tmp6_;
#line 301 "../src/data/Emulator.vala"
	_tmp8_ = g_str_has_suffix (_tmp7_, ".exe");
#line 301 "../src/data/Emulator.vala"
	_g_free0 (_tmp7_);
#line 301 "../src/data/Emulator.vala"
	_g_free0 (_tmp5_);
#line 301 "../src/data/Emulator.vala"
	if (_tmp8_) {
#line 301 "../src/data/Emulator.vala"
		_tmp3_ = GAME_HUB_DATA_PLATFORM_WINDOWS;
#line 3588 "Emulator.c"
	} else {
#line 301 "../src/data/Emulator.vala"
		_tmp3_ = GAME_HUB_DATA_PLATFORM_LINUX;
#line 3592 "Emulator.c"
	}
#line 301 "../src/data/Emulator.vala"
	game_hub_data_runnable_installer_set_platform ((GameHubDataRunnableInstaller*) self, _tmp3_);
#line 302 "../src/data/Emulator.vala"
	game_hub_data_runnable_file_installer_set_file ((GameHubDataRunnableFileInstaller*) self, installer);
#line 297 "../src/data/Emulator.vala"
	return self;
#line 3600 "Emulator.c"
}

GameHubDataEmulatorInstaller*
game_hub_data_emulator_installer_new (GameHubDataEmulator* emu,
                                      GFile* installer)
{
#line 297 "../src/data/Emulator.vala"
	return game_hub_data_emulator_installer_construct (GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER, emu, installer);
#line 3609 "Emulator.c"
}

static gchar*
game_hub_data_emulator_installer_real_get_name (GameHubDataRunnableInstaller* base)
{
	gchar* result;
	GameHubDataEmulatorInstaller* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 295 "../src/data/Emulator.vala"
	self = (GameHubDataEmulatorInstaller*) base;
#line 295 "../src/data/Emulator.vala"
	_tmp0_ = self->priv->emu_name;
#line 295 "../src/data/Emulator.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 295 "../src/data/Emulator.vala"
	result = _tmp1_;
#line 295 "../src/data/Emulator.vala"
	return result;
#line 3629 "Emulator.c"
}

static void
game_hub_data_emulator_installer_class_init (GameHubDataEmulatorInstallerClass * klass,
                                             gpointer klass_data)
{
#line 292 "../src/data/Emulator.vala"
	game_hub_data_emulator_installer_parent_class = g_type_class_peek_parent (klass);
#line 292 "../src/data/Emulator.vala"
	((GameHubDataRunnableInstallerClass *) klass)->finalize = game_hub_data_emulator_installer_finalize;
#line 292 "../src/data/Emulator.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataEmulatorInstaller_private_offset);
#line 292 "../src/data/Emulator.vala"
	GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS (klass)->get_name = (gchar* (*) (GameHubDataRunnableInstaller*)) game_hub_data_emulator_installer_real_get_name;
#line 3644 "Emulator.c"
}

static void
game_hub_data_emulator_installer_instance_init (GameHubDataEmulatorInstaller * self,
                                                gpointer klass)
{
#line 292 "../src/data/Emulator.vala"
	self->priv = game_hub_data_emulator_installer_get_instance_private (self);
#line 3653 "Emulator.c"
}

static void
game_hub_data_emulator_installer_finalize (GameHubDataRunnableInstaller * obj)
{
	GameHubDataEmulatorInstaller * self;
#line 292 "../src/data/Emulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_EMULATOR_TYPE_INSTALLER, GameHubDataEmulatorInstaller);
#line 294 "../src/data/Emulator.vala"
	_g_free0 (self->priv->emu_name);
#line 292 "../src/data/Emulator.vala"
	GAME_HUB_DATA_RUNNABLE_INSTALLER_CLASS (game_hub_data_emulator_installer_parent_class)->finalize (obj);
#line 3666 "Emulator.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_emulator_installer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataEmulatorInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_emulator_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataEmulatorInstaller), 0, (GInstanceInitFunc) game_hub_data_emulator_installer_instance_init, NULL };
	GType game_hub_data_emulator_installer_type_id;
	game_hub_data_emulator_installer_type_id = g_type_register_static (GAME_HUB_DATA_RUNNABLE_TYPE_FILE_INSTALLER, "GameHubDataEmulatorInstaller", &g_define_type_info, 0);
	GameHubDataEmulatorInstaller_private_offset = g_type_add_instance_private (game_hub_data_emulator_installer_type_id, sizeof (GameHubDataEmulatorInstallerPrivate));
	return game_hub_data_emulator_installer_type_id;
}

GType
game_hub_data_emulator_installer_get_type (void)
{
	static volatile gsize game_hub_data_emulator_installer_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_emulator_installer_type_id__once)) {
		GType game_hub_data_emulator_installer_type_id;
		game_hub_data_emulator_installer_type_id = game_hub_data_emulator_installer_get_type_once ();
		g_once_init_leave (&game_hub_data_emulator_installer_type_id__once, game_hub_data_emulator_installer_type_id);
	}
	return game_hub_data_emulator_installer_type_id__once;
}

static void
game_hub_data_emulator_class_init (GameHubDataEmulatorClass * klass,
                                   gpointer klass_data)
{
#line 25 "../src/data/Emulator.vala"
	game_hub_data_emulator_parent_class = g_type_class_peek_parent (klass);
#line 25 "../src/data/Emulator.vala"
	g_type_class_adjust_private_offset (klass, &GameHubDataEmulator_private_offset);
#line 25 "../src/data/Emulator.vala"
	((GameHubDataRunnableClass *) klass)->save = (void (*) (GameHubDataRunnable*)) game_hub_data_emulator_real_save;
#line 25 "../src/data/Emulator.vala"
	((GameHubDataRunnableClass *) klass)->update_status = (void (*) (GameHubDataRunnable*)) game_hub_data_emulator_real_update_status;
#line 25 "../src/data/Emulator.vala"
	((GameHubDataRunnableClass *) klass)->install = (void (*) (GameHubDataRunnable*, GameHubDataRunnableInstallerInstallMode, GAsyncReadyCallback, gpointer)) game_hub_data_emulator_real_install;
#line 25 "../src/data/Emulator.vala"
	((GameHubDataRunnableClass *) klass)->install_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_emulator_install_finish;
#line 25 "../src/data/Emulator.vala"
	((GameHubDataRunnableClass *) klass)->run = (void (*) (GameHubDataRunnable*, GAsyncReadyCallback, gpointer)) game_hub_data_emulator_real_run;
#line 25 "../src/data/Emulator.vala"
	((GameHubDataRunnableClass *) klass)->run_finish = (void (*) (GameHubDataRunnable*, GAsyncResult*)) game_hub_data_emulator_run_finish;
#line 25 "../src/data/Emulator.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->get_executable = (GFile* (*) (GameHubDataRunnable*)) game_hub_data_emulator_real_get_executable;
#line 25 "../src/data/Emulator.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->set_executable = (void (*) (GameHubDataRunnable*, GFile*)) game_hub_data_emulator_real_set_executable;
#line 25 "../src/data/Emulator.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->get_work_dir = (GFile* (*) (GameHubDataRunnable*)) game_hub_data_emulator_real_get_work_dir;
#line 25 "../src/data/Emulator.vala"
	GAME_HUB_DATA_RUNNABLE_CLASS (klass)->set_work_dir = (void (*) (GameHubDataRunnable*, GFile*)) game_hub_data_emulator_real_set_work_dir;
#line 25 "../src/data/Emulator.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_hub_data_emulator_get_property;
#line 25 "../src/data/Emulator.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_hub_data_emulator_set_property;
#line 25 "../src/data/Emulator.vala"
	G_OBJECT_CLASS (klass)->finalize = game_hub_data_emulator_finalize;
#line 25 "../src/data/Emulator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_EMULATOR_EXECUTABLE_PROPERTY, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_EXECUTABLE_PROPERTY] = g_param_spec_object ("executable", "executable", "executable", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/data/Emulator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_EMULATOR_WORK_DIR_PROPERTY, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_WORK_DIR_PROPERTY] = g_param_spec_object ("work-dir", "work-dir", "work-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/data/Emulator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_EMULATOR_GAME_EXECUTABLE_PATTERN_PROPERTY, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_GAME_EXECUTABLE_PATTERN_PROPERTY] = g_param_spec_string ("game-executable-pattern", "game-executable-pattern", "game-executable-pattern", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/data/Emulator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_EMULATOR_GAME_IMAGE_PATTERN_PROPERTY, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_GAME_IMAGE_PATTERN_PROPERTY] = g_param_spec_string ("game-image-pattern", "game-image-pattern", "game-image-pattern", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/data/Emulator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HUB_DATA_EMULATOR_GAME_ICON_PATTERN_PROPERTY, game_hub_data_emulator_properties[GAME_HUB_DATA_EMULATOR_GAME_ICON_PATTERN_PROPERTY] = g_param_spec_string ("game-icon-pattern", "game-icon-pattern", "game-icon-pattern", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "../src/data/Emulator.vala"
	game_hub_data_emulator_signals[GAME_HUB_DATA_EMULATOR_REMOVED_SIGNAL] = g_signal_new ("removed", GAME_HUB_DATA_TYPE_EMULATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3737 "Emulator.c"
}

static void
game_hub_data_emulator_instance_init (GameHubDataEmulator * self,
                                      gpointer klass)
{
#line 25 "../src/data/Emulator.vala"
	self->priv = game_hub_data_emulator_get_instance_private (self);
#line 27 "../src/data/Emulator.vala"
	self->priv->is_removed = FALSE;
#line 3748 "Emulator.c"
}

static void
game_hub_data_emulator_finalize (GObject * obj)
{
	GameHubDataEmulator * self;
#line 25 "../src/data/Emulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAME_HUB_DATA_TYPE_EMULATOR, GameHubDataEmulator);
#line 30 "../src/data/Emulator.vala"
	_g_object_unref0 (self->priv->_executable);
#line 32 "../src/data/Emulator.vala"
	_g_free0 (self->work_dir_path);
#line 83 "../src/data/Emulator.vala"
	_game_hub_data_runnable_installer_unref0 (self->installer);
#line 85 "../src/data/Emulator.vala"
	_g_free0 (self->priv->_game_executable_pattern);
#line 86 "../src/data/Emulator.vala"
	_g_free0 (self->priv->_game_image_pattern);
#line 87 "../src/data/Emulator.vala"
	_g_free0 (self->priv->_game_icon_pattern);
#line 25 "../src/data/Emulator.vala"
	G_OBJECT_CLASS (game_hub_data_emulator_parent_class)->finalize (obj);
#line 3771 "Emulator.c"
}

 G_GNUC_NO_INLINE static GType
game_hub_data_emulator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHubDataEmulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_hub_data_emulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHubDataEmulator), 0, (GInstanceInitFunc) game_hub_data_emulator_instance_init, NULL };
	GType game_hub_data_emulator_type_id;
	game_hub_data_emulator_type_id = g_type_register_static (GAME_HUB_DATA_TYPE_RUNNABLE, "GameHubDataEmulator", &g_define_type_info, 0);
	GameHubDataEmulator_private_offset = g_type_add_instance_private (game_hub_data_emulator_type_id, sizeof (GameHubDataEmulatorPrivate));
	return game_hub_data_emulator_type_id;
}

GType
game_hub_data_emulator_get_type (void)
{
	static volatile gsize game_hub_data_emulator_type_id__once = 0;
	if (g_once_init_enter (&game_hub_data_emulator_type_id__once)) {
		GType game_hub_data_emulator_type_id;
		game_hub_data_emulator_type_id = game_hub_data_emulator_get_type_once ();
		g_once_init_leave (&game_hub_data_emulator_type_id__once, game_hub_data_emulator_type_id);
	}
	return game_hub_data_emulator_type_id__once;
}

static void
_vala_game_hub_data_emulator_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GameHubDataEmulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_TYPE_EMULATOR, GameHubDataEmulator);
#line 25 "../src/data/Emulator.vala"
	switch (property_id) {
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_EXECUTABLE_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		g_value_take_object (value, game_hub_data_runnable_get_executable ((GameHubDataRunnable*) self));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_WORK_DIR_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		g_value_take_object (value, game_hub_data_runnable_get_work_dir ((GameHubDataRunnable*) self));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_GAME_EXECUTABLE_PATTERN_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		g_value_set_string (value, game_hub_data_emulator_get_game_executable_pattern (self));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_GAME_IMAGE_PATTERN_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		g_value_set_string (value, game_hub_data_emulator_get_game_image_pattern (self));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_GAME_ICON_PATTERN_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		g_value_set_string (value, game_hub_data_emulator_get_game_icon_pattern (self));
#line 25 "../src/data/Emulator.vala"
		break;
#line 3836 "Emulator.c"
		default:
#line 25 "../src/data/Emulator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../src/data/Emulator.vala"
		break;
#line 3842 "Emulator.c"
	}
}

static void
_vala_game_hub_data_emulator_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GameHubDataEmulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAME_HUB_DATA_TYPE_EMULATOR, GameHubDataEmulator);
#line 25 "../src/data/Emulator.vala"
	switch (property_id) {
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_EXECUTABLE_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		game_hub_data_runnable_set_executable ((GameHubDataRunnable*) self, g_value_get_object (value));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_WORK_DIR_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		game_hub_data_runnable_set_work_dir ((GameHubDataRunnable*) self, g_value_get_object (value));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_GAME_EXECUTABLE_PATTERN_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		game_hub_data_emulator_set_game_executable_pattern (self, g_value_get_string (value));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_GAME_IMAGE_PATTERN_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		game_hub_data_emulator_set_game_image_pattern (self, g_value_get_string (value));
#line 25 "../src/data/Emulator.vala"
		break;
#line 25 "../src/data/Emulator.vala"
		case GAME_HUB_DATA_EMULATOR_GAME_ICON_PATTERN_PROPERTY:
#line 25 "../src/data/Emulator.vala"
		game_hub_data_emulator_set_game_icon_pattern (self, g_value_get_string (value));
#line 25 "../src/data/Emulator.vala"
		break;
#line 3886 "Emulator.c"
		default:
#line 25 "../src/data/Emulator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "../src/data/Emulator.vala"
		break;
#line 3892 "Emulator.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

